#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <inttypes.h>
#include <sched.h>
#include <signal.h>
#include <asm/ioctls.h>
#include <sys/mount.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <string.h>

int cmd_length=0;

int child(void *ptr)
{
    char **arg, **argv = ptr;
    char * proc = malloc(strlen(argv[1]) + strlen("/proc") + 1);
    int i, j;

    stpcpy(proc,argv[1]);
    strcat(proc,"/proc");

    char* param[7];
    param[0]="chroot";
    param[1]=argv[1];
    param[2]="sudo";
    param[3]="-u";
    param[4]=getenv("SUDO_USER");
    param[5]="-i";
    param[6]=NULL;

    setsid();
    ioctl(STDIN_FILENO, TIOCSCTTY, 1);
    setresuid(getuid(),getuid(),getuid());
    mount("none",proc,"proc",MS_MGC_VAL,NULL);

    if (cmd_length > 0) {
        char* param1[6+cmd_length];
        j=0;

        for(i=0; i < 5; i++) {
            param1[j]=param[i];
            j+=1;
        }

        for(i=2; i < cmd_length+2; i++) {
            param1[j]=argv[i];
            j+=1;
        }
        param1[j]=NULL;
        execvp(*param1,param1);
    }
    else {
        execvp(*param,param);
    }
    umount(proc);

    return -1;
}

int main(int argc, char ** argv)
{
    uint8_t stack[4096];
    int c, status, retval;
    int flags = SIGCHLD | CLONE_NEWUTS | CLONE_NEWPID | CLONE_NEWIPC | CLONE_NEWNS;
    char * opt_target = "";

    if (argc < 3) {
        printf("Invalid parameters (network|nonetwork, path, cmd)\n");
        return 1;
    }

    // We can't mount or chroot without being root
    if (getuid() != 0) {
        printf("You need to start this program as root.\n");
        return 1;
    }

    if (strcmp(argv[1],"nonetwork") == 0) {
        flags = flags | CLONE_NEWNET;
    }

    cmd_length=argc-3;
    clone(child, stack+sizeof(stack), flags, argv+1);
    waitpid(-1, &status, __WALL);

    // Last cleanup
    return WEXITSTATUS(status);
}
