# Change Log

[v2.14.2](https://github.com/sanger-pathogens/ariba/tree/v2.14.2) (2019-06-18)
[Full Changelog](https://github.com/sanger-pathogens/ariba/compare/v2.14.1...v2.14.2)

**Fixed bugs:**

- Added Spades assembler into Docker file - RT ticket 660940
- Incremented release number
- Added LICENSE file into release distribution - RT ticket 660890

[v2.14.1](https://github.com/sanger-pathogens/ariba/tree/v2.14.1) (2019-06-13)
[Full Changelog](https://github.com/sanger-pathogens/ariba/compare/v2.14.0...v2.14.1)

**Fixed bugs:**

- Ariba fails to install from PyPI due to missing .h files in distribution. Related to MANIFEST.in change in [\#269](https://github.com/sanger-pathogens/ariba/pull/269)
- Fix for Issue [\#263](https://github.com/sanger-pathogens/ariba/issues/263)

[v2.14.0](https://github.com/sanger-pathogens/ariba/tree/v2.14.0) (2019-06-06)
[Full Changelog](https://github.com/sanger-pathogens/ariba/compare/v2.13.5...v2.14.0)

**Closed issues:**

- Reference dataset of ARG-ANNOT cannot be downloaded [\#265](https://github.com/sanger-pathogens/ariba/issues/265)
- unable to download mlst schemes [\#264](https://github.com/sanger-pathogens/ariba/issues/264)
- Several "At least one cluster failed!Stopping..." errors [\#261](https://github.com/sanger-pathogens/ariba/issues/261)
- Allow increasing cd-hit-est memory allocation [\#255](https://github.com/sanger-pathogens/ariba/issues/255)
- Ariba pubmlstget Error [\#240](https://github.com/sanger-pathogens/ariba/issues/240)
- segmentation fault when I import ariba [\#230](https://github.com/sanger-pathogens/ariba/issues/230)
- How to use spades and set minimum coverage [\#215](https://github.com/sanger-pathogens/ariba/issues/215)

**Merged pull requests:**

- Additional v2.14.0 updates [\#270](https://github.com/sanger-pathogens/ariba/pull/270) ([kpepper](https://github.com/kpepper))
- Added getref feature for NCBI's Bacterial Antimicrobial Resistance Reference Gene Database [\#269](https://github.com/sanger-pathogens/ariba/pull/269) ([schultzm](https://github.com/schultzm))

## [v2.13.5](https://github.com/sanger-pathogens/ariba/tree/v2.13.5) (2019-03-26)
[Full Changelog](https://github.com/sanger-pathogens/ariba/compare/v2.13.4...v2.13.5)

**Fixed bugs:**

- Ariba fails without --noclean depending on database [\#205](https://github.com/sanger-pathogens/ariba/issues/205)

**Closed issues:**

- Installation failed: clang: error: linker command failed with exit code 1 \(use -v to see invocation\) [\#245](https://github.com/sanger-pathogens/ariba/issues/245)
-  virfinddb db not downloading properly [\#229](https://github.com/sanger-pathogens/ariba/issues/229)
- getref error with resfinder db [\#225](https://github.com/sanger-pathogens/ariba/issues/225)

**Merged pull requests:**

- Updated CHANGELOG.md [\#260](https://github.com/sanger-pathogens/ariba/pull/260) ([kpepper](https://github.com/kpepper))
- Bump version to 2.13.5 and fix Spades invocation issue [\#259](https://github.com/sanger-pathogens/ariba/pull/259) ([kpepper](https://github.com/kpepper))
- Minor code change to mitigate issue \#245 \(installation failure\) [\#258](https://github.com/sanger-pathogens/ariba/pull/258) ([kpepper](https://github.com/kpepper))

## [v2.13.4](https://github.com/sanger-pathogens/ariba/tree/v2.13.4) (2019-03-15)
[Full Changelog](https://github.com/sanger-pathogens/ariba/compare/v2.13.3...v2.13.4)

**Closed issues:**

- Ariba run signal 28 [\#252](https://github.com/sanger-pathogens/ariba/issues/252)
- NCBI database. [\#241](https://github.com/sanger-pathogens/ariba/issues/241)

**Merged pull requests:**

- Rebuilt CHANGELOG for v2.13.4 [\#257](https://github.com/sanger-pathogens/ariba/pull/257) ([kpepper](https://github.com/kpepper))
- Allow increasing cd-hit-est memory allocation \#255 [\#256](https://github.com/sanger-pathogens/ariba/pull/256) ([kpepper](https://github.com/kpepper))

## [v2.13.3](https://github.com/sanger-pathogens/ariba/tree/v2.13.3) (2019-01-02)
[Full Changelog](https://github.com/sanger-pathogens/ariba/compare/v2.13.2...v2.13.3)

**Merged pull requests:**

- TB D94A fix [\#251](https://github.com/sanger-pathogens/ariba/pull/251) ([martinghunt](https://github.com/martinghunt))

## [v2.13.2](https://github.com/sanger-pathogens/ariba/tree/v2.13.2) (2018-12-21)
[Full Changelog](https://github.com/sanger-pathogens/ariba/compare/v2.13.1...v2.13.2)

**Merged pull requests:**

- Update tb panel [\#250](https://github.com/sanger-pathogens/ariba/pull/250) ([martinghunt](https://github.com/martinghunt))
- Added changelog [\#248](https://github.com/sanger-pathogens/ariba/pull/248) ([ssjunnebo](https://github.com/ssjunnebo))
- Update python min version [\#247](https://github.com/sanger-pathogens/ariba/pull/247) ([ssjunnebo](https://github.com/ssjunnebo))

## [v2.13.1](https://github.com/sanger-pathogens/ariba/tree/v2.13.1) (2018-11-16)
[Full Changelog](https://github.com/sanger-pathogens/ariba/compare/v2.13.0...v2.13.1)

**Closed issues:**

- resfinder line breaks problem [\#236](https://github.com/sanger-pathogens/ariba/issues/236)

**Merged pull requests:**

- Include tb\_data dir in release [\#244](https://github.com/sanger-pathogens/ariba/pull/244) ([martinghunt](https://github.com/martinghunt))

## [v2.13.0](https://github.com/sanger-pathogens/ariba/tree/v2.13.0) (2018-11-16)
[Full Changelog](https://github.com/sanger-pathogens/ariba/compare/v2.12.1...v2.13.0)

**Closed issues:**

- Updated to 2.12.1 problems with resfinder [\#237](https://github.com/sanger-pathogens/ariba/issues/237)
- Antibiotic resistance/susceptibility panel? [\#232](https://github.com/sanger-pathogens/ariba/issues/232)
- Ariba fails when using virulencefinder db [\#216](https://github.com/sanger-pathogens/ariba/issues/216)
- Ariba fails when using NFS directories for output [\#203](https://github.com/sanger-pathogens/ariba/issues/203)

**Merged pull requests:**

- Resfinder linebreaks [\#243](https://github.com/sanger-pathogens/ariba/pull/243) ([martinghunt](https://github.com/martinghunt))
- Tb amr [\#242](https://github.com/sanger-pathogens/ariba/pull/242) ([martinghunt](https://github.com/martinghunt))
- Do not use rmtree [\#235](https://github.com/sanger-pathogens/ariba/pull/235) ([martinghunt](https://github.com/martinghunt))
- Add to codecov [\#234](https://github.com/sanger-pathogens/ariba/pull/234) ([ssjunnebo](https://github.com/ssjunnebo))
- Include conda and docker badges [\#233](https://github.com/sanger-pathogens/ariba/pull/233) ([ssjunnebo](https://github.com/ssjunnebo))

## [v2.12.1](https://github.com/sanger-pathogens/ariba/tree/v2.12.1) (2018-06-15)
[Full Changelog](https://github.com/sanger-pathogens/ariba/compare/v2.12.0...v2.12.1)

**Closed issues:**

- PlasmidFinder databases have moved [\#218](https://github.com/sanger-pathogens/ariba/issues/218)
- Add latest version of srst2\_argannot \(ARGannot\_r2.fasta\) [\#217](https://github.com/sanger-pathogens/ariba/issues/217)
- Necessity of spades executable? [\#214](https://github.com/sanger-pathogens/ariba/issues/214)

**Merged pull requests:**

- Fix virulencefinder download [\#228](https://github.com/sanger-pathogens/ariba/pull/228) ([martinghunt](https://github.com/martinghunt))
- Update docker image to Ubuntu 17.10 and Ariba v.2.12.0 [\#227](https://github.com/sanger-pathogens/ariba/pull/227) ([ssjunnebo](https://github.com/ssjunnebo))

## [v2.12.0](https://github.com/sanger-pathogens/ariba/tree/v2.12.0) (2018-05-13)
[Full Changelog](https://github.com/sanger-pathogens/ariba/compare/v2.11.1...v2.12.0)

**Closed issues:**

- Problems Task getref  xxxxFinder and CARD [\#211](https://github.com/sanger-pathogens/ariba/issues/211)

**Merged pull requests:**

- Remove spades warnings [\#224](https://github.com/sanger-pathogens/ariba/pull/224) ([martinghunt](https://github.com/martinghunt))
- Get srst2\_argannot latest version r2 by default [\#223](https://github.com/sanger-pathogens/ariba/pull/223) ([martinghunt](https://github.com/martinghunt))
- Getref xfinder bitbucket [\#222](https://github.com/sanger-pathogens/ariba/pull/222) ([martinghunt](https://github.com/martinghunt))
- virulencefinder and nucmer version fixes [\#220](https://github.com/sanger-pathogens/ariba/pull/220) ([martinghunt](https://github.com/martinghunt))
- change path to license file [\#219](https://github.com/sanger-pathogens/ariba/pull/219) ([ssjunnebo](https://github.com/ssjunnebo))

## [v2.11.1](https://github.com/sanger-pathogens/ariba/tree/v2.11.1) (2018-02-26)
[Full Changelog](https://github.com/sanger-pathogens/ariba/compare/v2.11.0-1...v2.11.1)

**Merged pull requests:**

- fix card db path [\#213](https://github.com/sanger-pathogens/ariba/pull/213) ([eppinglen](https://github.com/eppinglen))

## [v2.11.0-1](https://github.com/sanger-pathogens/ariba/tree/v2.11.0-1) (2018-02-02)
[Full Changelog](https://github.com/sanger-pathogens/ariba/compare/v2.11.0...v2.11.0-1)

## [v2.11.0](https://github.com/sanger-pathogens/ariba/tree/v2.11.0) (2018-02-02)
[Full Changelog](https://github.com/sanger-pathogens/ariba/compare/v2.10.4...v2.11.0)

**Closed issues:**

- micplot requires X window [\#176](https://github.com/sanger-pathogens/ariba/issues/176)

**Merged pull requests:**

- Option to use Spades and multithreading for Bowtie2 and Spades [\#210](https://github.com/sanger-pathogens/ariba/pull/210) ([andreyto](https://github.com/andreyto))

## [v2.10.4](https://github.com/sanger-pathogens/ariba/tree/v2.10.4) (2018-02-01)
[Full Changelog](https://github.com/sanger-pathogens/ariba/compare/v2.10.3...v2.10.4)

**Closed issues:**

- Fails to getref card [\#206](https://github.com/sanger-pathogens/ariba/issues/206)

**Merged pull requests:**

- dont require X to run ariba [\#209](https://github.com/sanger-pathogens/ariba/pull/209) ([andrewjpage](https://github.com/andrewjpage))
- update readme [\#208](https://github.com/sanger-pathogens/ariba/pull/208) ([ssjunnebo](https://github.com/ssjunnebo))

## [v2.10.3](https://github.com/sanger-pathogens/ariba/tree/v2.10.3) (2017-11-24)
[Full Changelog](https://github.com/sanger-pathogens/ariba/compare/v2.10.2...v2.10.3)

**Closed issues:**

- CARD downloads now bz2 [\#200](https://github.com/sanger-pathogens/ariba/issues/200)

**Merged pull requests:**

- Mlst hetmin bug [\#204](https://github.com/sanger-pathogens/ariba/pull/204) ([martinghunt](https://github.com/martinghunt))

## [v2.10.2](https://github.com/sanger-pathogens/ariba/tree/v2.10.2) (2017-11-08)
[Full Changelog](https://github.com/sanger-pathogens/ariba/compare/v2.10.1...v2.10.2)

**Closed issues:**

- The meaning of the flag "ref\_seq\_choose\_fail" [\#199](https://github.com/sanger-pathogens/ariba/issues/199)
- How ariba deal with reads mapped to multiple clusters [\#198](https://github.com/sanger-pathogens/ariba/issues/198)
- TypeError  [\#197](https://github.com/sanger-pathogens/ariba/issues/197)
-  Test failures with bowtie2 2.3.2 [\#190](https://github.com/sanger-pathogens/ariba/issues/190)

**Merged pull requests:**

- Version bump 2.10.2 [\#202](https://github.com/sanger-pathogens/ariba/pull/202) ([martinghunt](https://github.com/martinghunt))
- Changed card to utilise .tar.bz2 from .tar.gz [\#201](https://github.com/sanger-pathogens/ariba/pull/201) ([JezSw](https://github.com/JezSw))
- correct spelling mistake [\#195](https://github.com/sanger-pathogens/ariba/pull/195) ([EdwardBetts](https://github.com/EdwardBetts))

## [v2.10.1](https://github.com/sanger-pathogens/ariba/tree/v2.10.1) (2017-08-14)
[Full Changelog](https://github.com/sanger-pathogens/ariba/compare/v2.10.0...v2.10.1)

**Closed issues:**

- Creation of custom variant database containing indels, both in-frame or frameshifts  [\#189](https://github.com/sanger-pathogens/ariba/issues/189)
- Clusters listed in debug.report.tsv not in report.tsv [\#188](https://github.com/sanger-pathogens/ariba/issues/188)
- \_\_main\_\_ error message [\#187](https://github.com/sanger-pathogens/ariba/issues/187)
- Failed Cluster [\#186](https://github.com/sanger-pathogens/ariba/issues/186)
- What about MLST not hosted at pubmlst.org? [\#185](https://github.com/sanger-pathogens/ariba/issues/185)
- How to detect presence or absence of a sequence carrying a deletion [\#184](https://github.com/sanger-pathogens/ariba/issues/184)

**Merged pull requests:**

- Add curl [\#194](https://github.com/sanger-pathogens/ariba/pull/194) ([martinghunt](https://github.com/martinghunt))
- Bowtie2 version issues [\#193](https://github.com/sanger-pathogens/ariba/pull/193) ([martinghunt](https://github.com/martinghunt))
- Fix utf-8 encoding problems [\#192](https://github.com/sanger-pathogens/ariba/pull/192) ([aunderwo](https://github.com/aunderwo))
- Install specific release instead of master branch [\#191](https://github.com/sanger-pathogens/ariba/pull/191) ([martinghunt](https://github.com/martinghunt))

## [v2.10.0](https://github.com/sanger-pathogens/ariba/tree/v2.10.0) (2017-06-28)
[Full Changelog](https://github.com/sanger-pathogens/ariba/compare/v2.9.4...v2.10.0)

**Closed issues:**

- pubmlstget does not work with docker [\#180](https://github.com/sanger-pathogens/ariba/issues/180)
- getref broken on CARD v1.1.8 [\#178](https://github.com/sanger-pathogens/ariba/issues/178)

**Merged pull requests:**

- Reviewer issues [\#182](https://github.com/sanger-pathogens/ariba/pull/182) ([martinghunt](https://github.com/martinghunt))
- Task expandflag [\#181](https://github.com/sanger-pathogens/ariba/pull/181) ([martinghunt](https://github.com/martinghunt))

## [v2.9.4](https://github.com/sanger-pathogens/ariba/tree/v2.9.4) (2017-05-24)
[Full Changelog](https://github.com/sanger-pathogens/ariba/compare/v2.9.3...v2.9.4)

**Closed issues:**

- problems with fermilite [\#169](https://github.com/sanger-pathogens/ariba/issues/169)

**Merged pull requests:**

- Card 1.1.8 [\#179](https://github.com/sanger-pathogens/ariba/pull/179) ([martinghunt](https://github.com/martinghunt))
- update AUTHORS and LICENSE [\#177](https://github.com/sanger-pathogens/ariba/pull/177) ([ssjunnebo](https://github.com/ssjunnebo))

## [v2.9.3](https://github.com/sanger-pathogens/ariba/tree/v2.9.3) (2017-04-28)
[Full Changelog](https://github.com/sanger-pathogens/ariba/compare/v2.9.2...v2.9.3)

**Closed issues:**

- Test failures with bowtie2 2.3.1 [\#170](https://github.com/sanger-pathogens/ariba/issues/170)

**Merged pull requests:**

- Getmlst dots in names [\#175](https://github.com/sanger-pathogens/ariba/pull/175) ([martinghunt](https://github.com/martinghunt))

## [v2.9.2](https://github.com/sanger-pathogens/ariba/tree/v2.9.2) (2017-04-27)
[Full Changelog](https://github.com/sanger-pathogens/ariba/compare/v2.9.1...v2.9.2)

**Closed issues:**

- Curious output [\#172](https://github.com/sanger-pathogens/ariba/issues/172)
- How to input several fastq files for pooled assembly? [\#171](https://github.com/sanger-pathogens/ariba/issues/171)

**Merged pull requests:**

- Bowtie2.3.1 [\#174](https://github.com/sanger-pathogens/ariba/pull/174) ([martinghunt](https://github.com/martinghunt))

## [v2.9.1](https://github.com/sanger-pathogens/ariba/tree/v2.9.1) (2017-04-07)
[Full Changelog](https://github.com/sanger-pathogens/ariba/compare/v2.9.0...v2.9.1)

**Closed issues:**

- Failing to build wheel [\#168](https://github.com/sanger-pathogens/ariba/issues/168)
- add VirulenceFinder [\#165](https://github.com/sanger-pathogens/ariba/issues/165)

**Merged pull requests:**

- Summary yes mutli het key error [\#173](https://github.com/sanger-pathogens/ariba/pull/173) ([martinghunt](https://github.com/martinghunt))

## [v2.9.0](https://github.com/sanger-pathogens/ariba/tree/v2.9.0) (2017-03-31)
[Full Changelog](https://github.com/sanger-pathogens/ariba/compare/v2.8.1...v2.9.0)

**Closed issues:**

- Ecoli no 1 profile warning [\#163](https://github.com/sanger-pathogens/ariba/issues/163)
- Failed building wheel for ariba [\#161](https://github.com/sanger-pathogens/ariba/issues/161)
- getref CARD  [\#160](https://github.com/sanger-pathogens/ariba/issues/160)

**Merged pull requests:**

- Summary read depth column [\#167](https://github.com/sanger-pathogens/ariba/pull/167) ([martinghunt](https://github.com/martinghunt))
- new method \_get\_from\_virulencefinder [\#166](https://github.com/sanger-pathogens/ariba/pull/166) ([martinghunt](https://github.com/martinghunt))
- Fix bug in README subheading rendering [\#164](https://github.com/sanger-pathogens/ariba/pull/164) ([fmaguire](https://github.com/fmaguire))

## [v2.8.1](https://github.com/sanger-pathogens/ariba/tree/v2.8.1) (2017-03-04)
[Full Changelog](https://github.com/sanger-pathogens/ariba/compare/v2.7.2...v2.8.1)

**Closed issues:**

- compilation problem: ku128\_v \*r = &g-\>v.a\[idd\>\>1\].nei\[idd&1\]; [\#159](https://github.com/sanger-pathogens/ariba/issues/159)
- error generating cluster [\#157](https://github.com/sanger-pathogens/ariba/issues/157)
- --threads bug?  [\#155](https://github.com/sanger-pathogens/ariba/issues/155)

**Merged pull requests:**

- Mic plots [\#162](https://github.com/sanger-pathogens/ariba/pull/162) ([martinghunt](https://github.com/martinghunt))

## [v2.7.2](https://github.com/sanger-pathogens/ariba/tree/v2.7.2) (2017-02-02)
[Full Changelog](https://github.com/sanger-pathogens/ariba/compare/v2.7.1...v2.7.2)

**Merged pull requests:**

- Require pymummer 0.10.2 [\#158](https://github.com/sanger-pathogens/ariba/pull/158) ([martinghunt](https://github.com/martinghunt))

## [v2.7.1](https://github.com/sanger-pathogens/ariba/tree/v2.7.1) (2017-01-27)
[Full Changelog](https://github.com/sanger-pathogens/ariba/compare/v2.7.0...v2.7.1)

**Merged pull requests:**

- Newick rooting bug [\#156](https://github.com/sanger-pathogens/ariba/pull/156) ([martinghunt](https://github.com/martinghunt))
- Check BeautifulSoup version number [\#154](https://github.com/sanger-pathogens/ariba/pull/154) ([martinghunt](https://github.com/martinghunt))

## [v2.7.0](https://github.com/sanger-pathogens/ariba/tree/v2.7.0) (2017-01-17)
[Full Changelog](https://github.com/sanger-pathogens/ariba/compare/v2.6.1...v2.7.0)

**Merged pull requests:**

- Add megares [\#153](https://github.com/sanger-pathogens/ariba/pull/153) ([martinghunt](https://github.com/martinghunt))

## [v2.6.1](https://github.com/sanger-pathogens/ariba/tree/v2.6.1) (2016-12-21)
[Full Changelog](https://github.com/sanger-pathogens/ariba/compare/v2.6.0...v2.6.1)

**Merged pull requests:**

- Ignore additional columns in MLST profiles [\#152](https://github.com/sanger-pathogens/ariba/pull/152) ([andrewjpage](https://github.com/andrewjpage))

## [v2.6.0](https://github.com/sanger-pathogens/ariba/tree/v2.6.0) (2016-12-20)
[Full Changelog](https://github.com/sanger-pathogens/ariba/compare/v2.5.1...v2.6.0)

**Merged pull requests:**

- Pubmlst [\#151](https://github.com/sanger-pathogens/ariba/pull/151) ([martinghunt](https://github.com/martinghunt))

## [v2.5.1](https://github.com/sanger-pathogens/ariba/tree/v2.5.1) (2016-12-05)
[Full Changelog](https://github.com/sanger-pathogens/ariba/compare/v2.5.0...v2.5.1)

**Merged pull requests:**

- Use flank length to choose best assembly [\#150](https://github.com/sanger-pathogens/ariba/pull/150) ([martinghunt](https://github.com/martinghunt))

## [v2.5.0](https://github.com/sanger-pathogens/ariba/tree/v2.5.0) (2016-11-18)
[Full Changelog](https://github.com/sanger-pathogens/ariba/compare/v2.4.0...v2.5.0)

**Closed issues:**

- broken link in the tarball hosted in pypi [\#147](https://github.com/sanger-pathogens/ariba/issues/147)

**Merged pull requests:**

- Ref seq choose use qry length [\#149](https://github.com/sanger-pathogens/ariba/pull/149) ([martinghunt](https://github.com/martinghunt))

## [v2.4.0](https://github.com/sanger-pathogens/ariba/tree/v2.4.0) (2016-11-01)
[Full Changelog](https://github.com/sanger-pathogens/ariba/compare/v2.3.0...v2.4.0)

**Closed issues:**

- Honour $TMPDIR for temporary files [\#143](https://github.com/sanger-pathogens/ariba/issues/143)
- Report full codon change eg. AAT=\>AGG [\#142](https://github.com/sanger-pathogens/ariba/issues/142)
- Report "partial" when 1 contig but not full gene [\#141](https://github.com/sanger-pathogens/ariba/issues/141)
- Add --force to allow overwriting of output\_dir [\#138](https://github.com/sanger-pathogens/ariba/issues/138)
- Report original names from gene database [\#136](https://github.com/sanger-pathogens/ariba/issues/136)
- Cleanup after getref [\#135](https://github.com/sanger-pathogens/ariba/issues/135)

**Merged pull requests:**

- Consecutive genes fix [\#148](https://github.com/sanger-pathogens/ariba/pull/148) ([martinghunt](https://github.com/martinghunt))

## [v2.3.0](https://github.com/sanger-pathogens/ariba/tree/v2.3.0) (2016-10-12)
[Full Changelog](https://github.com/sanger-pathogens/ariba/compare/v2.2.5...v2.3.0)

**Closed issues:**

- Check minimap threads [\#144](https://github.com/sanger-pathogens/ariba/issues/144)

**Merged pull requests:**

- Torsten issues [\#146](https://github.com/sanger-pathogens/ariba/pull/146) ([martinghunt](https://github.com/martinghunt))
- Report full codons and original sequence names [\#145](https://github.com/sanger-pathogens/ariba/pull/145) ([martinghunt](https://github.com/martinghunt))
- Remove cdhit 2d [\#140](https://github.com/sanger-pathogens/ariba/pull/140) ([martinghunt](https://github.com/martinghunt))
- Het snp bugs [\#139](https://github.com/sanger-pathogens/ariba/pull/139) ([martinghunt](https://github.com/martinghunt))
- Docker installation [\#137](https://github.com/sanger-pathogens/ariba/pull/137) ([andrewjpage](https://github.com/andrewjpage))
- Fix for download changes to resfinder data [\#134](https://github.com/sanger-pathogens/ariba/pull/134) ([martinghunt](https://github.com/martinghunt))

## [v2.2.5](https://github.com/sanger-pathogens/ariba/tree/v2.2.5) (2016-08-31)
[Full Changelog](https://github.com/sanger-pathogens/ariba/compare/v2.2.4...v2.2.5)

**Merged pull requests:**

- Bcftools ploidy [\#133](https://github.com/sanger-pathogens/ariba/pull/133) ([martinghunt](https://github.com/martinghunt))

## [v2.2.4](https://github.com/sanger-pathogens/ariba/tree/v2.2.4) (2016-08-23)
[Full Changelog](https://github.com/sanger-pathogens/ariba/compare/v2.2.3...v2.2.4)

**Merged pull requests:**

- Reportfilter bug [\#132](https://github.com/sanger-pathogens/ariba/pull/132) ([martinghunt](https://github.com/martinghunt))

## [v2.2.3](https://github.com/sanger-pathogens/ariba/tree/v2.2.3) (2016-08-22)
[Full Changelog](https://github.com/sanger-pathogens/ariba/compare/v2.2.2...v2.2.3)

**Merged pull requests:**

- bug fix summary when no samtools alt [\#131](https://github.com/sanger-pathogens/ariba/pull/131) ([martinghunt](https://github.com/martinghunt))

## [v2.2.2](https://github.com/sanger-pathogens/ariba/tree/v2.2.2) (2016-08-22)
[Full Changelog](https://github.com/sanger-pathogens/ariba/compare/v2.2.1...v2.2.2)

**Merged pull requests:**

- Contig renaming [\#130](https://github.com/sanger-pathogens/ariba/pull/130) ([martinghunt](https://github.com/martinghunt))

## [v2.2.1](https://github.com/sanger-pathogens/ariba/tree/v2.2.1) (2016-08-18)
[Full Changelog](https://github.com/sanger-pathogens/ariba/compare/v2.2.0...v2.2.1)

**Merged pull requests:**

- Aln2meta fix [\#129](https://github.com/sanger-pathogens/ariba/pull/129) ([martinghunt](https://github.com/martinghunt))

## [v2.2.0](https://github.com/sanger-pathogens/ariba/tree/v2.2.0) (2016-08-18)
[Full Changelog](https://github.com/sanger-pathogens/ariba/compare/v2.1.0...v2.2.0)

**Merged pull requests:**

- Version bump 2.2.0 [\#128](https://github.com/sanger-pathogens/ariba/pull/128) ([martinghunt](https://github.com/martinghunt))
- summary no/NA consistency, phandango NAs [\#127](https://github.com/sanger-pathogens/ariba/pull/127) ([martinghunt](https://github.com/martinghunt))
- Spaces in fasta headers [\#126](https://github.com/sanger-pathogens/ariba/pull/126) ([martinghunt](https://github.com/martinghunt))
- Split show\_vars option into show\_known\_vars and show\_novel\_vars [\#125](https://github.com/sanger-pathogens/ariba/pull/125) ([martinghunt](https://github.com/martinghunt))
- Bug fix reporting ref\_base\_assembled for a partial gene assembly [\#124](https://github.com/sanger-pathogens/ariba/pull/124) ([martinghunt](https://github.com/martinghunt))
- When assembled is no, everything else should be no or NA [\#123](https://github.com/sanger-pathogens/ariba/pull/123) ([martinghunt](https://github.com/martinghunt))
- Vfdb get full and core [\#122](https://github.com/sanger-pathogens/ariba/pull/122) ([martinghunt](https://github.com/martinghunt))
- Add option to choose download version [\#121](https://github.com/sanger-pathogens/ariba/pull/121) ([martinghunt](https://github.com/martinghunt))
- Summary improvements [\#120](https://github.com/sanger-pathogens/ariba/pull/120) ([martinghunt](https://github.com/martinghunt))
- Allow fasta only to prepareref [\#119](https://github.com/sanger-pathogens/ariba/pull/119) ([martinghunt](https://github.com/martinghunt))
- Add srst2 argannot [\#118](https://github.com/sanger-pathogens/ariba/pull/118) ([martinghunt](https://github.com/martinghunt))
- Shorten filenames [\#117](https://github.com/sanger-pathogens/ariba/pull/117) ([martinghunt](https://github.com/martinghunt))

## [v2.1.0](https://github.com/sanger-pathogens/ariba/tree/v2.1.0) (2016-08-03)
[Full Changelog](https://github.com/sanger-pathogens/ariba/compare/v2.0.0...v2.1.0)

**Merged pull requests:**

- V2.0.0 bug fixes/improvements [\#116](https://github.com/sanger-pathogens/ariba/pull/116) ([martinghunt](https://github.com/martinghunt))
- Het snp reporting [\#115](https://github.com/sanger-pathogens/ariba/pull/115) ([martinghunt](https://github.com/martinghunt))
- Minor fixes [\#114](https://github.com/sanger-pathogens/ariba/pull/114) ([satta](https://github.com/satta))
- Make sure c\*.h files included in distribution [\#113](https://github.com/sanger-pathogens/ariba/pull/113) ([martinghunt](https://github.com/martinghunt))

## [v2.0.0](https://github.com/sanger-pathogens/ariba/tree/v2.0.0) (2016-07-29)
[Full Changelog](https://github.com/sanger-pathogens/ariba/compare/v1.0.1...v2.0.0)

**Closed issues:**

- report.tsv empty [\#96](https://github.com/sanger-pathogens/ariba/issues/96)

**Merged pull requests:**

- Update card version to 1.0.9 [\#112](https://github.com/sanger-pathogens/ariba/pull/112) ([martinghunt](https://github.com/martinghunt))
- Tidy files [\#111](https://github.com/sanger-pathogens/ariba/pull/111) ([martinghunt](https://github.com/martinghunt))
- Rename clusters [\#110](https://github.com/sanger-pathogens/ariba/pull/110) ([martinghunt](https://github.com/martinghunt))
- End extend assemble flag bug [\#109](https://github.com/sanger-pathogens/ariba/pull/109) ([martinghunt](https://github.com/martinghunt))
- Use fermilite [\#108](https://github.com/sanger-pathogens/ariba/pull/108) ([martinghunt](https://github.com/martinghunt))
- General tidying [\#107](https://github.com/sanger-pathogens/ariba/pull/107) ([martinghunt](https://github.com/martinghunt))
- Put -h option back for older python versions [\#106](https://github.com/sanger-pathogens/ariba/pull/106) ([martinghunt](https://github.com/martinghunt))
- Use subcommands [\#105](https://github.com/sanger-pathogens/ariba/pull/105) ([martinghunt](https://github.com/martinghunt))
- Check dendropy found and version ok [\#104](https://github.com/sanger-pathogens/ariba/pull/104) ([martinghunt](https://github.com/martinghunt))
- Dendropy [\#103](https://github.com/sanger-pathogens/ariba/pull/103) ([martinghunt](https://github.com/martinghunt))
- Minimap remove noise [\#102](https://github.com/sanger-pathogens/ariba/pull/102) ([martinghunt](https://github.com/martinghunt))
-     Use minimap [\#101](https://github.com/sanger-pathogens/ariba/pull/101) ([martinghunt](https://github.com/martinghunt))
- allow full VFDB to be downloaded [\#99](https://github.com/sanger-pathogens/ariba/pull/99) ([andrewjpage](https://github.com/andrewjpage))

## [v1.0.1](https://github.com/sanger-pathogens/ariba/tree/v1.0.1) (2016-06-28)
[Full Changelog](https://github.com/sanger-pathogens/ariba/compare/v1.0.0...v1.0.1)

**Closed issues:**

- Error running --test with CD-HIT and SPAdes [\#95](https://github.com/sanger-pathogens/ariba/issues/95)

**Merged pull requests:**

- Spades not untrusted [\#98](https://github.com/sanger-pathogens/ariba/pull/98) ([martinghunt](https://github.com/martinghunt))
- add disclaimer to readme [\#97](https://github.com/sanger-pathogens/ariba/pull/97) ([martinghunt](https://github.com/martinghunt))
- Add tmp dir description [\#94](https://github.com/sanger-pathogens/ariba/pull/94) ([martinghunt](https://github.com/martinghunt))
- Make clearer that the env vars are exectuables, not dirs [\#93](https://github.com/sanger-pathogens/ariba/pull/93) ([martinghunt](https://github.com/martinghunt))

## [v1.0.0](https://github.com/sanger-pathogens/ariba/tree/v1.0.0) (2016-05-27)
[Full Changelog](https://github.com/sanger-pathogens/ariba/compare/wip...v1.0.0)

**Merged pull requests:**

- Readme for 1.0.0 [\#92](https://github.com/sanger-pathogens/ariba/pull/92) ([martinghunt](https://github.com/martinghunt))
- Phandango colours [\#91](https://github.com/sanger-pathogens/ariba/pull/91) ([martinghunt](https://github.com/martinghunt))
- Group snps [\#90](https://github.com/sanger-pathogens/ariba/pull/90) ([martinghunt](https://github.com/martinghunt))
- Only calculate half the matrix \(it's symmetric\) [\#89](https://github.com/sanger-pathogens/ariba/pull/89) ([martinghunt](https://github.com/martinghunt))
- No attr assembly compare bug [\#88](https://github.com/sanger-pathogens/ariba/pull/88) ([martinghunt](https://github.com/martinghunt))
- Vfdb names [\#87](https://github.com/sanger-pathogens/ariba/pull/87) ([martinghunt](https://github.com/martinghunt))
- Say type is INT in the help [\#86](https://github.com/sanger-pathogens/ariba/pull/86) ([martinghunt](https://github.com/martinghunt))
- Match gene ends [\#85](https://github.com/sanger-pathogens/ariba/pull/85) ([martinghunt](https://github.com/martinghunt))
- Always report presabs vars [\#84](https://github.com/sanger-pathogens/ariba/pull/84) ([martinghunt](https://github.com/martinghunt))
- Stop returning error when all clusters successful [\#83](https://github.com/sanger-pathogens/ariba/pull/83) ([martinghunt](https://github.com/martinghunt))
- Tmp dir cleaning [\#82](https://github.com/sanger-pathogens/ariba/pull/82) ([martinghunt](https://github.com/martinghunt))
- Die if spades error code is -7 [\#81](https://github.com/sanger-pathogens/ariba/pull/81) ([martinghunt](https://github.com/martinghunt))
- Specify cdhit clusters [\#80](https://github.com/sanger-pathogens/ariba/pull/80) ([martinghunt](https://github.com/martinghunt))
- Tmp dir option [\#79](https://github.com/sanger-pathogens/ariba/pull/79) ([martinghunt](https://github.com/martinghunt))
- Bug fix with presets. Should be y/n not yes/no [\#78](https://github.com/sanger-pathogens/ariba/pull/78) ([martinghunt](https://github.com/martinghunt))
- Update card from 1.0.5 to 1.0.6 [\#77](https://github.com/sanger-pathogens/ariba/pull/77) ([martinghunt](https://github.com/martinghunt))
- Summary fixes [\#76](https://github.com/sanger-pathogens/ariba/pull/76) ([martinghunt](https://github.com/martinghunt))
- Summary column control [\#75](https://github.com/sanger-pathogens/ariba/pull/75) ([martinghunt](https://github.com/martinghunt))
- Minimise files [\#74](https://github.com/sanger-pathogens/ariba/pull/74) ([martinghunt](https://github.com/martinghunt))
- Summary inconsistent bug [\#73](https://github.com/sanger-pathogens/ariba/pull/73) ([martinghunt](https://github.com/martinghunt))
- bug fix, files were not being deleted [\#72](https://github.com/sanger-pathogens/ariba/pull/72) ([martinghunt](https://github.com/martinghunt))
- Bug fix, now it actually deletes files as it goes [\#71](https://github.com/sanger-pathogens/ariba/pull/71) ([martinghunt](https://github.com/martinghunt))
- Various fixes [\#70](https://github.com/sanger-pathogens/ariba/pull/70) ([martinghunt](https://github.com/martinghunt))
- Various fixes [\#69](https://github.com/sanger-pathogens/ariba/pull/69) ([martinghunt](https://github.com/martinghunt))
- Various fixes [\#68](https://github.com/sanger-pathogens/ariba/pull/68) ([martinghunt](https://github.com/martinghunt))
- VFDB downloader [\#67](https://github.com/sanger-pathogens/ariba/pull/67) ([andrewjpage](https://github.com/andrewjpage))
- Rename sequences [\#66](https://github.com/sanger-pathogens/ariba/pull/66) ([martinghunt](https://github.com/martinghunt))

## [wip](https://github.com/sanger-pathogens/ariba/tree/wip) (2016-04-27)
[Full Changelog](https://github.com/sanger-pathogens/ariba/compare/v0.6.0...wip)

**Implemented enhancements:**

- Tests assume installed version of SPAdes [\#40](https://github.com/sanger-pathogens/ariba/issues/40)

**Merged pull requests:**

- Catch when no coverage from samtools [\#65](https://github.com/sanger-pathogens/ariba/pull/65) ([martinghunt](https://github.com/martinghunt))
- Summary improvements [\#64](https://github.com/sanger-pathogens/ariba/pull/64) ([martinghunt](https://github.com/martinghunt))
- Card rename [\#63](https://github.com/sanger-pathogens/ariba/pull/63) ([martinghunt](https://github.com/martinghunt))
- Better cluster naming [\#62](https://github.com/sanger-pathogens/ariba/pull/62) ([martinghunt](https://github.com/martinghunt))
- contig cov col report [\#61](https://github.com/sanger-pathogens/ariba/pull/61) ([martinghunt](https://github.com/martinghunt))
- Catch when cannot determine insert size data [\#60](https://github.com/sanger-pathogens/ariba/pull/60) ([martinghunt](https://github.com/martinghunt))
- Report all versions [\#59](https://github.com/sanger-pathogens/ariba/pull/59) ([martinghunt](https://github.com/martinghunt))
- Bug fix with free text being put into more than one column [\#58](https://github.com/sanger-pathogens/ariba/pull/58) ([martinghunt](https://github.com/martinghunt))
- Set nucmer opts to match nucmers defaults, but add --maxmatch [\#57](https://github.com/sanger-pathogens/ariba/pull/57) ([martinghunt](https://github.com/martinghunt))
- New task prepareref [\#56](https://github.com/sanger-pathogens/ariba/pull/56) ([martinghunt](https://github.com/martinghunt))
- Do not assume cluster representative comes first [\#55](https://github.com/sanger-pathogens/ariba/pull/55) ([martinghunt](https://github.com/martinghunt))
- Card update use json [\#54](https://github.com/sanger-pathogens/ariba/pull/54) ([martinghunt](https://github.com/martinghunt))
- Add files for TravisCI [\#53](https://github.com/sanger-pathogens/ariba/pull/53) ([martinghunt](https://github.com/martinghunt))
- Phandango r bug [\#52](https://github.com/sanger-pathogens/ariba/pull/52) ([martinghunt](https://github.com/martinghunt))
- Check all input files exist [\#51](https://github.com/sanger-pathogens/ariba/pull/51) ([martinghunt](https://github.com/martinghunt))
- Bug in get one variant for one contig coding [\#50](https://github.com/sanger-pathogens/ariba/pull/50) ([martinghunt](https://github.com/martinghunt))
- Check reads files exists before running pipeline [\#49](https://github.com/sanger-pathogens/ariba/pull/49) ([martinghunt](https://github.com/martinghunt))
- Provide getref prefix to run [\#48](https://github.com/sanger-pathogens/ariba/pull/48) ([martinghunt](https://github.com/martinghunt))
- Phandango fix [\#47](https://github.com/sanger-pathogens/ariba/pull/47) ([martinghunt](https://github.com/martinghunt))
- Sample reads [\#46](https://github.com/sanger-pathogens/ariba/pull/46) ([martinghunt](https://github.com/martinghunt))
- One thread not use multithreaded [\#45](https://github.com/sanger-pathogens/ariba/pull/45) ([martinghunt](https://github.com/martinghunt))
- Make filtered report [\#44](https://github.com/sanger-pathogens/ariba/pull/44) ([martinghunt](https://github.com/martinghunt))
- New task reportfilter [\#43](https://github.com/sanger-pathogens/ariba/pull/43) ([martinghunt](https://github.com/martinghunt))
- Bux fix filtering rows [\#42](https://github.com/sanger-pathogens/ariba/pull/42) ([martinghunt](https://github.com/martinghunt))
- Auto get ref genes, variant handling [\#41](https://github.com/sanger-pathogens/ariba/pull/41) ([martinghunt](https://github.com/martinghunt))
- fix typo [\#39](https://github.com/sanger-pathogens/ariba/pull/39) ([satta](https://github.com/satta))
- Implement multithreading [\#38](https://github.com/sanger-pathogens/ariba/pull/38) ([martinghunt](https://github.com/martinghunt))
- Always run refcheck; Add JS candy output [\#37](https://github.com/sanger-pathogens/ariba/pull/37) ([martinghunt](https://github.com/martinghunt))

## [v0.6.0](https://github.com/sanger-pathogens/ariba/tree/v0.6.0) (2015-10-28)
[Full Changelog](https://github.com/sanger-pathogens/ariba/compare/v0.5.0...v0.6.0)

**Merged pull requests:**

- Improvements to summary output; new flag for non-synonymous variants [\#36](https://github.com/sanger-pathogens/ariba/pull/36) ([martinghunt](https://github.com/martinghunt))
- Clarify usage: input must be tsv, not xls [\#35](https://github.com/sanger-pathogens/ariba/pull/35) ([martinghunt](https://github.com/martinghunt))

## [v0.5.0](https://github.com/sanger-pathogens/ariba/tree/v0.5.0) (2015-09-10)
[Full Changelog](https://github.com/sanger-pathogens/ariba/compare/v0.4.1...v0.5.0)

**Merged pull requests:**

- Various improvements [\#34](https://github.com/sanger-pathogens/ariba/pull/34) ([martinghunt](https://github.com/martinghunt))
- Bug fix: refcheck now dies if spaces in sequence names [\#33](https://github.com/sanger-pathogens/ariba/pull/33) ([martinghunt](https://github.com/martinghunt))
- Added AUTHORS with mh12 as author [\#32](https://github.com/sanger-pathogens/ariba/pull/32) ([aslett1](https://github.com/aslett1))

## [v0.4.1](https://github.com/sanger-pathogens/ariba/tree/v0.4.1) (2015-07-14)
[Full Changelog](https://github.com/sanger-pathogens/ariba/compare/v0.4.0...v0.4.1)

**Merged pull requests:**

- Spades use untrusted-contigs [\#31](https://github.com/sanger-pathogens/ariba/pull/31) ([martinghunt](https://github.com/martinghunt))

## [v0.4.0](https://github.com/sanger-pathogens/ariba/tree/v0.4.0) (2015-06-10)
[Full Changelog](https://github.com/sanger-pathogens/ariba/compare/v0.3.2...v0.4.0)

**Merged pull requests:**

- Flag hit both strands [\#30](https://github.com/sanger-pathogens/ariba/pull/30) ([martinghunt](https://github.com/martinghunt))
- Make cdhit optional [\#29](https://github.com/sanger-pathogens/ariba/pull/29) ([martinghunt](https://github.com/martinghunt))

## [v0.3.2](https://github.com/sanger-pathogens/ariba/tree/v0.3.2) (2015-05-12)
[Full Changelog](https://github.com/sanger-pathogens/ariba/compare/v0.3.1...v0.3.2)

**Merged pull requests:**

- Bug when samtools zero depth [\#28](https://github.com/sanger-pathogens/ariba/pull/28) ([martinghunt](https://github.com/martinghunt))

## [v0.3.1](https://github.com/sanger-pathogens/ariba/tree/v0.3.1) (2015-04-20)
[Full Changelog](https://github.com/sanger-pathogens/ariba/compare/v0.3.0...v0.3.1)

**Merged pull requests:**

- Bug fix aln score zero [\#27](https://github.com/sanger-pathogens/ariba/pull/27) ([martinghunt](https://github.com/martinghunt))
- Bug fix getting read depth when there is an indel [\#26](https://github.com/sanger-pathogens/ariba/pull/26) ([martinghunt](https://github.com/martinghunt))
- SSAPCE sd cannot exceed 1 [\#25](https://github.com/sanger-pathogens/ariba/pull/25) ([martinghunt](https://github.com/martinghunt))

## [v0.3.0](https://github.com/sanger-pathogens/ariba/tree/v0.3.0) (2015-04-07)
[Full Changelog](https://github.com/sanger-pathogens/ariba/compare/v0.2.0...v0.3.0)

**Merged pull requests:**

- Add test log file and do not gitignore .log files [\#24](https://github.com/sanger-pathogens/ariba/pull/24) ([martinghunt](https://github.com/martinghunt))
- add option bowtie2\_preset; version bump [\#23](https://github.com/sanger-pathogens/ariba/pull/23) ([martinghunt](https://github.com/martinghunt))
- Convert to uppercase [\#22](https://github.com/sanger-pathogens/ariba/pull/22) ([martinghunt](https://github.com/martinghunt))
- Use bowtie2 [\#21](https://github.com/sanger-pathogens/ariba/pull/21) ([martinghunt](https://github.com/martinghunt))
- Add ref alt read depth [\#20](https://github.com/sanger-pathogens/ariba/pull/20) ([martinghunt](https://github.com/martinghunt))
- Report read counts [\#19](https://github.com/sanger-pathogens/ariba/pull/19) ([martinghunt](https://github.com/martinghunt))
- Refcheck max length [\#18](https://github.com/sanger-pathogens/ariba/pull/18) ([martinghunt](https://github.com/martinghunt))
- Make sspace and gapfiller optional [\#17](https://github.com/sanger-pathogens/ariba/pull/17) ([martinghunt](https://github.com/martinghunt))
- write bad checked ref seqs to file; fix genetic\_code options [\#16](https://github.com/sanger-pathogens/ariba/pull/16) ([martinghunt](https://github.com/martinghunt))
- Add summary task [\#15](https://github.com/sanger-pathogens/ariba/pull/15) ([martinghunt](https://github.com/martinghunt))
- Check res genes [\#14](https://github.com/sanger-pathogens/ariba/pull/14) ([martinghunt](https://github.com/martinghunt))
- Report percent identity and number bases assembled [\#13](https://github.com/sanger-pathogens/ariba/pull/13) ([martinghunt](https://github.com/martinghunt))
- Use cd-hit-est [\#12](https://github.com/sanger-pathogens/ariba/pull/12) ([martinghunt](https://github.com/martinghunt))

## [v0.2.0](https://github.com/sanger-pathogens/ariba/tree/v0.2.0) (2015-02-20)
[Full Changelog](https://github.com/sanger-pathogens/ariba/compare/v0.1.2...v0.2.0)

**Merged pull requests:**

- Version 0.1.2 -\> 0.2.0 [\#11](https://github.com/sanger-pathogens/ariba/pull/11) ([martinghunt](https://github.com/martinghunt))
- Use cdhit [\#10](https://github.com/sanger-pathogens/ariba/pull/10) ([martinghunt](https://github.com/martinghunt))

## [v0.1.2](https://github.com/sanger-pathogens/ariba/tree/v0.1.2) (2015-02-18)
[Full Changelog](https://github.com/sanger-pathogens/ariba/compare/v0.1.1...v0.1.2)

**Merged pull requests:**

- Bux fixes velvet path [\#9](https://github.com/sanger-pathogens/ariba/pull/9) ([martinghunt](https://github.com/martinghunt))

## [v0.1.1](https://github.com/sanger-pathogens/ariba/tree/v0.1.1) (2015-02-18)
[Full Changelog](https://github.com/sanger-pathogens/ariba/compare/v0.1.0...v0.1.1)

**Merged pull requests:**

- Update version to 0.1.1 [\#8](https://github.com/sanger-pathogens/ariba/pull/8) ([martinghunt](https://github.com/martinghunt))
- Remove debugging sys.exit [\#7](https://github.com/sanger-pathogens/ariba/pull/7) ([martinghunt](https://github.com/martinghunt))

## [v0.1.0](https://github.com/sanger-pathogens/ariba/tree/v0.1.0) (2015-02-18)
[Full Changelog](https://github.com/sanger-pathogens/ariba/compare/v0.0.1...v0.1.0)

**Merged pull requests:**

- Move usage info to wiki [\#6](https://github.com/sanger-pathogens/ariba/pull/6) ([martinghunt](https://github.com/martinghunt))
- fix executables and paths [\#5](https://github.com/sanger-pathogens/ariba/pull/5) ([martinghunt](https://github.com/martinghunt))
- Fix bugs finding paths of dependencies [\#4](https://github.com/sanger-pathogens/ariba/pull/4) ([martinghunt](https://github.com/martinghunt))
- Use spades [\#3](https://github.com/sanger-pathogens/ariba/pull/3) ([martinghunt](https://github.com/martinghunt))
- Add velvet to dependencies [\#2](https://github.com/sanger-pathogens/ariba/pull/2) ([martinghunt](https://github.com/martinghunt))

## [v0.0.1](https://github.com/sanger-pathogens/ariba/tree/v0.0.1) (2015-02-12)
**Merged pull requests:**

- Initial working version [\#1](https://github.com/sanger-pathogens/ariba/pull/1) ([martinghunt](https://github.com/martinghunt))



\* *This Change Log was automatically generated by [github_changelog_generator](https://github.com/skywinder/Github-Changelog-Generator)*