// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_ENUMS_H
#define _GTKMM_ENUMS_H

#include <glibmm.h>

/* $Id: enums.h,v 1.1 2005/03/22 21:05:48 taybin Exp $ */

/* enums.h
 * 
 * Copyright (C) 2002 The gtkmm Development Team 
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


namespace Gtk
{


/** @addtogroup gtkmmEnums Enums and Flags */

/**
 * @ingroup gtkmmEnums
 * @par Bitwise operators:
 * <tt>%AccelFlags operator|(AccelFlags, AccelFlags)</tt><br>
 * <tt>%AccelFlags operator&(AccelFlags, AccelFlags)</tt><br>
 * <tt>%AccelFlags operator^(AccelFlags, AccelFlags)</tt><br>
 * <tt>%AccelFlags operator~(AccelFlags)</tt><br>
 * <tt>%AccelFlags& operator|=(AccelFlags&, AccelFlags)</tt><br>
 * <tt>%AccelFlags& operator&=(AccelFlags&, AccelFlags)</tt><br>
 * <tt>%AccelFlags& operator^=(AccelFlags&, AccelFlags)</tt><br>
 */
enum AccelFlags
{
  ACCEL_VISIBLE = 1 << 0,
  ACCEL_LOCKED = 1 << 1,
  ACCEL_MASK = 0x07
};

/** @ingroup gtkmmEnums */
inline AccelFlags operator|(AccelFlags lhs, AccelFlags rhs)
  { return static_cast<AccelFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline AccelFlags operator&(AccelFlags lhs, AccelFlags rhs)
  { return static_cast<AccelFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline AccelFlags operator^(AccelFlags lhs, AccelFlags rhs)
  { return static_cast<AccelFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline AccelFlags operator~(AccelFlags flags)
  { return static_cast<AccelFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup gtkmmEnums */
inline AccelFlags& operator|=(AccelFlags& lhs, AccelFlags rhs)
  { return (lhs = static_cast<AccelFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gtkmmEnums */
inline AccelFlags& operator&=(AccelFlags& lhs, AccelFlags rhs)
  { return (lhs = static_cast<AccelFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gtkmmEnums */
inline AccelFlags& operator^=(AccelFlags& lhs, AccelFlags rhs)
  { return (lhs = static_cast<AccelFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::AccelFlags> : public Glib::Value_Flags<Gtk::AccelFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/**
 * @ingroup gtkmmEnums
 */
enum AnchorType
{
  ANCHOR_CENTER,
  ANCHOR_NORTH,
  ANCHOR_NORTH_WEST,
  ANCHOR_NORTH_EAST,
  ANCHOR_SOUTH,
  ANCHOR_SOUTH_WEST,
  ANCHOR_SOUTH_EAST,
  ANCHOR_WEST,
  ANCHOR_EAST,
  ANCHOR_N = ANCHOR_NORTH,
  ANCHOR_NW = ANCHOR_NORTH_WEST,
  ANCHOR_NE = ANCHOR_NORTH_EAST,
  ANCHOR_S = ANCHOR_SOUTH,
  ANCHOR_SW = ANCHOR_SOUTH_WEST,
  ANCHOR_SE = ANCHOR_SOUTH_EAST,
  ANCHOR_W = ANCHOR_WEST,
  ANCHOR_E = ANCHOR_EAST
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::AnchorType> : public Glib::Value_Enum<Gtk::AnchorType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{


/** Used to indicate the direction in which a Gtk::Arrow should point.
 * @ingroup gtkmmEnums
 */
enum ArrowType
{
  ARROW_UP,
  ARROW_DOWN,
  ARROW_LEFT,
  ARROW_RIGHT
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::ArrowType> : public Glib::Value_Enum<Gtk::ArrowType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{


// TODO: There must be a better way to document the enum values.
//       Extract them from the GTK+ docs as well?

/*! @var ArrowType ARROW_UP
 * Represents an upward pointing arrow.
 */
/*! @var ArrowType ARROW_DOWN
 * Represents a downward pointing arrow.
 */
/*! @var ArrowType ARROW_LEFT
 * Represents a left pointing arrow.
 */
/*! @var ArrowType ARROW_RIGHT
 * Represents a right pointing arrow.
 */

/** Denotes the expansion properties that a widget will have when it (or its parent) is resized.
 * @ingroup gtkmmEnums
 * @par Bitwise operators:
 * <tt>%AttachOptions operator|(AttachOptions, AttachOptions)</tt><br>
 * <tt>%AttachOptions operator&(AttachOptions, AttachOptions)</tt><br>
 * <tt>%AttachOptions operator^(AttachOptions, AttachOptions)</tt><br>
 * <tt>%AttachOptions operator~(AttachOptions)</tt><br>
 * <tt>%AttachOptions& operator|=(AttachOptions&, AttachOptions)</tt><br>
 * <tt>%AttachOptions& operator&=(AttachOptions&, AttachOptions)</tt><br>
 * <tt>%AttachOptions& operator^=(AttachOptions&, AttachOptions)</tt><br>
 */
enum AttachOptions
{
  EXPAND = 1 << 0,
  SHRINK = 1 << 1,
  FILL = 1 << 2
};

/** @ingroup gtkmmEnums */
inline AttachOptions operator|(AttachOptions lhs, AttachOptions rhs)
  { return static_cast<AttachOptions>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline AttachOptions operator&(AttachOptions lhs, AttachOptions rhs)
  { return static_cast<AttachOptions>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline AttachOptions operator^(AttachOptions lhs, AttachOptions rhs)
  { return static_cast<AttachOptions>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline AttachOptions operator~(AttachOptions flags)
  { return static_cast<AttachOptions>(~static_cast<unsigned>(flags)); }

/** @ingroup gtkmmEnums */
inline AttachOptions& operator|=(AttachOptions& lhs, AttachOptions rhs)
  { return (lhs = static_cast<AttachOptions>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gtkmmEnums */
inline AttachOptions& operator&=(AttachOptions& lhs, AttachOptions rhs)
  { return (lhs = static_cast<AttachOptions>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gtkmmEnums */
inline AttachOptions& operator^=(AttachOptions& lhs, AttachOptions rhs)
  { return (lhs = static_cast<AttachOptions>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::AttachOptions> : public Glib::Value_Flags<Gtk::AttachOptions>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{


/*! @var AttachOptions EXPAND
 * The widget should expand to take up any extra space in its container that has been allocated.
 */
/*! @var AttachOptions SHRINK
 * The widget should shrink as and when possible.
 */
/*! @var AttachOptions FILL
 * The widget should fill the space allocated to it.
 */

/**
 * @ingroup gtkmmEnums
 */
enum ButtonBoxStyle
{
  BUTTONBOX_DEFAULT_STYLE,
  BUTTONBOX_SPREAD,
  BUTTONBOX_EDGE,
  BUTTONBOX_START,
  BUTTONBOX_END
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::ButtonBoxStyle> : public Glib::Value_Enum<Gtk::ButtonBoxStyle>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/**
 * @ingroup gtkmmEnums
 */
enum CurveType
{
  CURVE_TYPE_LINEAR,
  CURVE_TYPE_SPLINE,
  CURVE_TYPE_FREE
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::CurveType> : public Glib::Value_Enum<Gtk::CurveType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/**
 * @ingroup gtkmmEnums
 */
enum DeleteType
{
  DELETE_CHARS,
  DELETE_WORDS,
  DELETE_DISPLAY_LINES,
  DELETE_DISPLAY_LINE_ENDS,
  DELETE_PARAGRAPH_ENDS,
  DELETE_PARAGRAPHS,
  DELETE_WHITESPACE
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::DeleteType> : public Glib::Value_Enum<Gtk::DeleteType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/**
 * @ingroup gtkmmEnums
 */
enum DirectionType
{
  DIR_TAB_FORWARD,
  DIR_TAB_BACKWARD,
  DIR_UP,
  DIR_DOWN,
  DIR_LEFT,
  DIR_RIGHT
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::DirectionType> : public Glib::Value_Enum<Gtk::DirectionType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/**
 * @ingroup gtkmmEnums
 */
enum ExpanderStyle
{
  EXPANDER_COLLAPSED,
  EXPANDER_SEMI_COLLAPSED,
  EXPANDER_SEMI_EXPANDED,
  EXPANDER_EXPANDED
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::ExpanderStyle> : public Glib::Value_Enum<Gtk::ExpanderStyle>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/**
 * @ingroup gtkmmEnums
 */
enum BuiltinIconSize
{
  ICON_SIZE_INVALID,
  ICON_SIZE_MENU,
  ICON_SIZE_SMALL_TOOLBAR,
  ICON_SIZE_LARGE_TOOLBAR,
  ICON_SIZE_BUTTON,
  ICON_SIZE_DND,
  ICON_SIZE_DIALOG
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::BuiltinIconSize> : public Glib::Value_Enum<Gtk::BuiltinIconSize>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/**
 * @ingroup gtkmmEnums
 */
enum TextDirection
{
  TEXT_DIR_NONE,
  TEXT_DIR_LTR,
  TEXT_DIR_RTL
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::TextDirection> : public Glib::Value_Enum<Gtk::TextDirection>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/**
 * @ingroup gtkmmEnums
 */
enum Justification
{
  JUSTIFY_LEFT,
  JUSTIFY_RIGHT,
  JUSTIFY_CENTER,
  JUSTIFY_FILL
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::Justification> : public Glib::Value_Enum<Gtk::Justification>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/**
 * @ingroup gtkmmEnums
 */
enum MenuDirectionType
{
  MENU_DIR_PARENT,
  MENU_DIR_CHILD,
  MENU_DIR_NEXT,
  MENU_DIR_PREV
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::MenuDirectionType> : public Glib::Value_Enum<Gtk::MenuDirectionType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/**
 * @ingroup gtkmmEnums
 */
enum MetricType
{
  PIXELS,
  INCHES,
  CENTIMETERS
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::MetricType> : public Glib::Value_Enum<Gtk::MetricType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/**
 * @ingroup gtkmmEnums
 */
enum MovementStep
{
  MOVEMENT_LOGICAL_POSITIONS,
  MOVEMENT_VISUAL_POSITIONS,
  MOVEMENT_WORDS,
  MOVEMENT_DISPLAY_LINES,
  MOVEMENT_DISPLAY_LINE_ENDS,
  MOVEMENT_PARAGRAPHS,
  MOVEMENT_PARAGRAPH_ENDS,
  MOVEMENT_PAGES,
  MOVEMENT_BUFFER_ENDS,
  MOVEMENT_HORIZONTAL_PAGES
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::MovementStep> : public Glib::Value_Enum<Gtk::MovementStep>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/**
 * @ingroup gtkmmEnums
 */
enum Orientation
{
  ORIENTATION_HORIZONTAL,
  ORIENTATION_VERTICAL
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::Orientation> : public Glib::Value_Enum<Gtk::Orientation>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/**
 * @ingroup gtkmmEnums
 */
enum CornerType
{
  CORNER_TOP_LEFT,
  CORNER_BOTTOM_LEFT,
  CORNER_TOP_RIGHT,
  CORNER_BOTTOM_RIGHT
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::CornerType> : public Glib::Value_Enum<Gtk::CornerType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/**
 * @ingroup gtkmmEnums
 */
enum PackType
{
  PACK_START,
  PACK_END
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::PackType> : public Glib::Value_Enum<Gtk::PackType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/**
 * @ingroup gtkmmEnums
 */
enum PathPriorityType
{
  PATH_PRIO_LOWEST = 0,
  PATH_PRIO_GTK = 4,
  PATH_PRIO_APPLICATION = 8,
  PATH_PRIO_THEME = 10,
  PATH_PRIO_RC = 12,
  PATH_PRIO_HIGHEST = 15
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::PathPriorityType> : public Glib::Value_Enum<Gtk::PathPriorityType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/**
 * @ingroup gtkmmEnums
 */
enum PathType
{
  PATH_WIDGET,
  PATH_WIDGET_CLASS,
  PATH_CLASS
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::PathType> : public Glib::Value_Enum<Gtk::PathType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/**
 * @ingroup gtkmmEnums
 */
enum PolicyType
{
  POLICY_ALWAYS,
  POLICY_AUTOMATIC,
  POLICY_NEVER
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::PolicyType> : public Glib::Value_Enum<Gtk::PolicyType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/**
 * @ingroup gtkmmEnums
 */
enum PositionType
{
  POS_LEFT,
  POS_RIGHT,
  POS_TOP,
  POS_BOTTOM
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::PositionType> : public Glib::Value_Enum<Gtk::PositionType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/**
 * @ingroup gtkmmEnums
 */
enum ReliefStyle
{
  RELIEF_NORMAL,
  RELIEF_HALF,
  RELIEF_NONE
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::ReliefStyle> : public Glib::Value_Enum<Gtk::ReliefStyle>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/**
 * @ingroup gtkmmEnums
 */
enum ResizeMode
{
  RESIZE_PARENT,
  RESIZE_QUEUE,
  RESIZE_IMMEDIATE
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::ResizeMode> : public Glib::Value_Enum<Gtk::ResizeMode>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/**
 * @ingroup gtkmmEnums
 */
enum ScrollType
{
  SCROLL_NONE,
  SCROLL_JUMP,
  SCROLL_STEP_BACKWARD,
  SCROLL_STEP_FORWARD,
  SCROLL_PAGE_BACKWARD,
  SCROLL_PAGE_FORWARD,
  SCROLL_STEP_UP,
  SCROLL_STEP_DOWN,
  SCROLL_PAGE_UP,
  SCROLL_PAGE_DOWN,
  SCROLL_STEP_LEFT,
  SCROLL_STEP_RIGHT,
  SCROLL_PAGE_LEFT,
  SCROLL_PAGE_RIGHT,
  SCROLL_START,
  SCROLL_END
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::ScrollType> : public Glib::Value_Enum<Gtk::ScrollType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/**
 * @ingroup gtkmmEnums
 */
enum SelectionMode
{
  SELECTION_NONE,
  SELECTION_SINGLE,
  SELECTION_BROWSE,
  SELECTION_MULTIPLE,
  SELECTION_EXTENDED = SELECTION_MULTIPLE
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::SelectionMode> : public Glib::Value_Enum<Gtk::SelectionMode>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/**
 * @ingroup gtkmmEnums
 */
enum ShadowType
{
  SHADOW_NONE,
  SHADOW_IN,
  SHADOW_OUT,
  SHADOW_ETCHED_IN,
  SHADOW_ETCHED_OUT
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::ShadowType> : public Glib::Value_Enum<Gtk::ShadowType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/**
 * @ingroup gtkmmEnums
 */
enum StateType
{
  STATE_NORMAL,
  STATE_ACTIVE,
  STATE_PRELIGHT,
  STATE_SELECTED,
  STATE_INSENSITIVE
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::StateType> : public Glib::Value_Enum<Gtk::StateType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/**
 * @ingroup gtkmmEnums
 * @par Bitwise operators:
 * <tt>%TargetFlags operator|(TargetFlags, TargetFlags)</tt><br>
 * <tt>%TargetFlags operator&(TargetFlags, TargetFlags)</tt><br>
 * <tt>%TargetFlags operator^(TargetFlags, TargetFlags)</tt><br>
 * <tt>%TargetFlags operator~(TargetFlags)</tt><br>
 * <tt>%TargetFlags& operator|=(TargetFlags&, TargetFlags)</tt><br>
 * <tt>%TargetFlags& operator&=(TargetFlags&, TargetFlags)</tt><br>
 * <tt>%TargetFlags& operator^=(TargetFlags&, TargetFlags)</tt><br>
 */
enum TargetFlags
{
  TARGET_SAME_APP = 1 << 0,
  TARGET_SAME_WIDGET = 1 << 1
};

/** @ingroup gtkmmEnums */
inline TargetFlags operator|(TargetFlags lhs, TargetFlags rhs)
  { return static_cast<TargetFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline TargetFlags operator&(TargetFlags lhs, TargetFlags rhs)
  { return static_cast<TargetFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline TargetFlags operator^(TargetFlags lhs, TargetFlags rhs)
  { return static_cast<TargetFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline TargetFlags operator~(TargetFlags flags)
  { return static_cast<TargetFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup gtkmmEnums */
inline TargetFlags& operator|=(TargetFlags& lhs, TargetFlags rhs)
  { return (lhs = static_cast<TargetFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gtkmmEnums */
inline TargetFlags& operator&=(TargetFlags& lhs, TargetFlags rhs)
  { return (lhs = static_cast<TargetFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gtkmmEnums */
inline TargetFlags& operator^=(TargetFlags& lhs, TargetFlags rhs)
  { return (lhs = static_cast<TargetFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::TargetFlags> : public Glib::Value_Flags<Gtk::TargetFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/**
 * @ingroup gtkmmEnums
 */
enum ToolbarStyle
{
  TOOLBAR_ICONS,
  TOOLBAR_TEXT,
  TOOLBAR_BOTH,
  TOOLBAR_BOTH_HORIZ
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::ToolbarStyle> : public Glib::Value_Enum<Gtk::ToolbarStyle>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/**
 * @ingroup gtkmmEnums
 */
enum UpdateType
{
  UPDATE_CONTINUOUS,
  UPDATE_DISCONTINUOUS,
  UPDATE_DELAYED
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::UpdateType> : public Glib::Value_Enum<Gtk::UpdateType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/**
 * @ingroup gtkmmEnums
 */
enum Visibility
{
  VISIBILITY_NONE,
  VISIBILITY_PARTIAL,
  VISIBILITY_FULL
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::Visibility> : public Glib::Value_Enum<Gtk::Visibility>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/**
 * @ingroup gtkmmEnums
 */
enum WindowPosition
{
  WIN_POS_NONE,
  WIN_POS_CENTER,
  WIN_POS_MOUSE,
  WIN_POS_CENTER_ALWAYS,
  WIN_POS_CENTER_ON_PARENT
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::WindowPosition> : public Glib::Value_Enum<Gtk::WindowPosition>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/**
 * @ingroup gtkmmEnums
 */
enum WindowType
{
  WINDOW_TOPLEVEL,
  WINDOW_POPUP
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::WindowType> : public Glib::Value_Enum<Gtk::WindowType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/**
 * @ingroup gtkmmEnums
 */
enum WrapMode
{
  WRAP_NONE,
  WRAP_CHAR,
  WRAP_WORD,
  WRAP_WORD_CHAR
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::WrapMode> : public Glib::Value_Enum<Gtk::WrapMode>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/**
 * @ingroup gtkmmEnums
 */
enum SortType
{
  SORT_ASCENDING,
  SORT_DESCENDING
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::SortType> : public Glib::Value_Enum<Gtk::SortType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{


/* We use a class to implement the GtkIconSize enum, because you can register
 * new "enum" values.  The strict type rules of C++ don't allow using an enum
 * like that.  Gtk::BuiltinIconSize is the actual GtkIconSize wrapper enum.
 */

/**
 * Represents registered icon sizes.
 * You can also use a Gtk::BuiltinIconSize instead of an IconSize.
 */
class IconSize
{
private:
  int size_;

public:
  IconSize()                     : size_ (0)    {}
  IconSize(BuiltinIconSize size) : size_ (size) {}

  // Behave like an ordinary enum.
  explicit IconSize(int size) : size_ (size) {}
  operator int() const { return size_; }

  // These static methods are implement in iconfactory.ccg.
  static bool lookup(IconSize size, int& width, int& height);
  static IconSize register_new(const Glib::ustring& name, int width, int height);
  static void register_alias(const Glib::ustring& alias, IconSize target);
  static IconSize from_name(const Glib::ustring& name);
  static Glib::ustring get_name(IconSize size);
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::IconSize> : public Glib::Value_Enum<Gtk::IconSize>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

  /** Methods are overriden so you can use these simple enums, or floats for more precision.
   * @ingroup gtkmmEnums
   */
  enum AlignmentEnum
  {
    ALIGN_LEFT,   /**< Same as 0.0 */
    ALIGN_CENTER,  /**< Same as 0.5 */
    ALIGN_RIGHT,  /**< Same as 1.0 */
    ALIGN_TOP,   /**< Same as ALIGN_LEFT */
    ALIGN_BOTTOM  /**< Same as ALIGN_RIGHT */
  };

#ifndef DOXYGEN_SHOULD_SKIP_THIS
//We need this because we can't just use floats for enum value.
float _gtkmm_align_float_from_enum(AlignmentEnum value);
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} //namespace Gtk


#endif /* _GTKMM_ENUMS_H */

