/*
    Copyright (C) 2002 Paul Davis

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: panner.h,v 1.6 2003/04/10 15:43:14 pbd Exp $
*/

#ifndef __ardour_panner__
#define __ardour_panner__

#include <map>
#include <string>
#include <gtk--.h>

using std::map;
using std::string;

class Panner : public Gtk::DrawingArea
{
  public:
	Panner (int width, int height);
	~Panner ();
	
	int position (int which_target, float& x, float& y);
	int fraction (int target_a, int target_b, float&);

	void allow_x_motion(bool);
	void allow_y_motion(bool);
	void allow_target_motion (bool);

	void hide_puck ();
	void show_puck ();
	int  add_target (float x, float y);
	void hide_target (int);
	void show_target (int);
	void remove_target (int);
	void drop_targets ();
	void move_target (int, float x, float y);
	void move_puck (float x, float y);
	void reset();

	bool bypassed () { return bypassflag; }
	void set_bypassed (bool byp);
	
	SigC::Signal0<void>     PuckMoved;
	SigC::Signal1<void,int> TargetMoved;
	SigC::Signal0<void>     BypassToggled;

  protected:
	gint expose_event_impl (GdkEventExpose *);
	gint button_press_event_impl (GdkEventButton *);
	gint button_release_event_impl (GdkEventButton *);
	gint motion_notify_event_impl (GdkEventMotion *);
	void size_allocate_impl (GtkAllocation* alloc);

  private:
	struct Target {
	    float x;
	    float y;
	    bool visible;
	    Target (float xa, float ya);
	};

	typedef map<int,Target *> Targets;
	Targets targets;

	Target *puck;
	Target *drag_target;
	int     drag_index;

	bool  allow_x;
	bool  allow_y;
	bool  allow_target;
	int width;
	int height;

	bool bypassflag;
	
	gint compute_x (float);
	gint compute_y (float);

	Target *find_closest_object (gdouble x, gdouble y,int& which) const;

	gint handle_motion (gint, gint, GdkModifierType);
};

#endif /* __ardour_panner__ */
