/*
    Copyright (C) 2001 Paul Davis 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: grouped_buttons.h,v 1.3 2002/06/01 03:32:47 trutkin Exp $
*/

#ifndef __gtkmmext_grouped_buttons_h__
#define __gtkmmext_grouped_buttons_h__

#include <vector>
#include <sigc++/signal_system.h>

using namespace std;

namespace Gtk {
	class ToggleButton;
};

class GroupedButtons : public SigC::Object
{
  public:
	GroupedButtons (unsigned int nbuttons, unsigned int first_active);
	GroupedButtons (vector<Gtk::ToggleButton *>&);
	
	Gtk::ToggleButton& button (unsigned int which) {
		return *buttons[which];
	}

  private:
	vector<Gtk::ToggleButton *> buttons;
	unsigned int current_active;
	void one_clicked (unsigned int which);
};

#endif /* __gtkmmext_grouped_buttons_h__ */




