// -*- c++ -*-
//  Generated by gtkmmproc from ./../ctree.gen_h -- DO NOT MODIFY!
#include <gtk--/ctree.h>
#include <gtk--/private/ctree_p.h>
#include <gtk--/style.h>
#include <gtk--/adjustment.h>

namespace Gtk {

CTree::CTree(const Gtk::SArray& titles, gint tree_column)
  : CList((GtkCList*)(gtk_object_new(get_type(),0)))
{
  initialize_class();
  GTK_OBJECT_UNSET_FLAGS(gtkobj(), GTK_CONSTRUCTED);
  gtk_ctree_construct(GTK_CTREE(gtkobject),titles.size(),tree_column,
     const_cast<gchar**>((const gchar**)titles));
}

CTree::CTree(gint columns, gint tree_column)
  : CList((GtkCList*)(gtk_object_new(get_type(),0)))
{
  initialize_class();
  GTK_OBJECT_UNSET_FLAGS(gtkobj(), GTK_CONSTRUCTED);
  gtk_ctree_construct(GTK_CTREE(gtkobject),columns,tree_column,(gchar**)0);
}


const int default_spacing = 4;

namespace CTree_Helpers {

Element::Element(const Gtk::SArray& text, bool is_leaf, bool expanded)
   : text_(text), spacing_(default_spacing), is_leaf_(is_leaf), expanded_(expanded)
  {}

Element::Element(const Gtk::SArray& text,
              Gdk_Pixmap pixmap_closed,
              Gdk_Bitmap mask_closed,
              Gdk_Pixmap pixmap_opened,
              Gdk_Bitmap mask_opened,
              bool is_leaf,
              bool expanded)
    : text_(text),
      spacing_(default_spacing),
      pixmap_closed_(pixmap_closed), mask_closed_(mask_closed),
      pixmap_opened_(pixmap_opened), mask_opened_(mask_opened),
      is_leaf_(is_leaf), expanded_(expanded)
  {}

BranchElem::BranchElem(const Gtk::SArray& text,
              bool expanded)
    : Element(text,0,expanded)
  {}

BranchElem::BranchElem(const Gtk::SArray& text,
              Gdk_Pixmap pixmap_closed,
              Gdk_Bitmap mask_closed,
              Gdk_Pixmap pixmap_opened,
              Gdk_Bitmap mask_opened,
              bool expanded)
    : Element(text,pixmap_closed,mask_closed,
              pixmap_opened,mask_opened,0,expanded)
  {}

/******************************************************************/

Cell::Cell(GtkCTree* tree, GtkCTreeNode* node, gint column)
  : tree_(tree), node_(node), column_(column)
  {}

Cell::Cell()
  : tree_(0), node_(0), column_(0)
  {}

GtkCellType Cell::get_type() const
  {
    return gtk_ctree_node_get_cell_type(tree_,node_,column_);
  }

Gtk::Style* Cell::get_style() const
  {
    return wrap(gtk_ctree_node_get_cell_style(tree_,node_,column_));
  }

nstring Cell::get_text() const
  {
    gchar* text=0;
    switch (get_type())
      {
        case GTK_CELL_TEXT:
          gtk_ctree_node_get_text(tree_,node_,column_,&text);
          break;
        case GTK_CELL_PIXTEXT:
          gtk_ctree_node_get_pixtext(tree_,node_,column_,
                                     &text,0,0,0);
          break;
        default:
          break;
      }
    return text;
  }

Gdk_Pixmap Cell::get_pixmap() const
  {
    GdkPixmap* pixmap=0;
    switch (get_type())
      {
        case GTK_CELL_PIXMAP:
          gtk_ctree_node_get_pixmap(tree_,node_,column_,&pixmap,0);
          break;
        case GTK_CELL_PIXTEXT:
          gtk_ctree_node_get_pixtext(tree_,node_,column_,
                                     0,0,&pixmap,0);
          break;
        default:
          break;
      }
    return pixmap;
  }

Gdk_Bitmap Cell::get_mask() const
  {
    GdkBitmap* bitmap=0;
    switch (get_type())
      {
        case GTK_CELL_PIXMAP:
          gtk_ctree_node_get_pixmap(tree_,node_,column_,0,&bitmap);
          break;
        case GTK_CELL_PIXTEXT:
          gtk_ctree_node_get_pixtext(tree_,node_,column_,
                                     0,0,0,&bitmap);
          break;
        default:
          break;
      }
    return bitmap;
  }

void Cell::set_style(Gtk::Style* s)
  {
    gtk_ctree_node_set_cell_style(tree_,node_,column_,s?s->gtkobj():0);
  }

void Cell::set_style(Gtk::Style& s)
  {
    gtk_ctree_node_set_cell_style(tree_,node_,column_,s.gtkobj());
  }

void Cell::set_text(const nstring& text)
  {
    guint8 spacing=default_spacing;
    GdkPixmap* pixmap;
    GdkBitmap* mask;
    switch (get_type())
      {
        case GTK_CELL_EMPTY:
        case GTK_CELL_TEXT:
          gtk_ctree_node_set_text(tree_,node_,column_,text.gc_str());
          break;
        case GTK_CELL_PIXMAP:
          gtk_ctree_node_get_pixmap(tree_,node_,column_,&pixmap,&mask);
          gtk_ctree_node_set_pixtext(tree_,node_,column_,text.gc_str(),
               default_spacing,pixmap,mask);
          break;
        case GTK_CELL_PIXTEXT:
          gtk_ctree_node_get_pixtext(tree_,node_,column_,
                                     0,&spacing,&pixmap,&mask);
          gtk_ctree_node_set_pixtext(tree_,node_,column_,text.gc_str(),
               spacing,pixmap,mask);
          break;
        default:
          break;
      }
  }

void Cell::set_pixmap(const Gdk_Pixmap& pixmap,const Gdk_Bitmap& mask)
  {
    guint8 spacing=default_spacing;
    gchar *text;
    switch (get_type())
      {
        case GTK_CELL_EMPTY:
        case GTK_CELL_PIXMAP:
          gtk_ctree_node_set_pixmap(tree_,node_,column_,pixmap,mask);
          break;
        case GTK_CELL_TEXT:
          gtk_ctree_node_get_text(tree_,node_,column_,&text);
          gtk_ctree_node_set_pixtext(tree_,node_,column_,text,
               default_spacing,pixmap,mask);
          break;
        case GTK_CELL_PIXTEXT:
          gtk_ctree_node_get_pixtext(tree_,node_,column_,
                                     &text,0,0,0);
          gtk_ctree_node_set_pixtext(tree_,node_,column_,text,
               spacing,pixmap,mask);
          break;
        default:
          break;
      }
  }

void Cell::set_shift(gint vertical,gint horizontal)
  {
    gtk_ctree_node_set_shift(tree_,node_,column_,vertical,horizontal);
  }

void Cell::moveto(gfloat row_align, gfloat col_align)
  {
    gtk_ctree_node_moveto(tree_,node_,column_,row_align,col_align);
  }

/******************************************************************/

void Row::set_style(Gtk::Style* s)
  {
    gtk_ctree_node_set_row_style(tree_,node_,s?s->gtkobj():0);
  }

void Row::set_style(Gtk::Style& s)
  {
    gtk_ctree_node_set_row_style(tree_,node_,s.gtkobj());
  }

Gtk::Style* Row::get_style()
  {
    return wrap(gtk_ctree_node_get_row_style(tree_,node_));
  }

void Row::set_selectable(bool s)
  {
    gtk_ctree_node_set_selectable(tree_,node_,s);
  }

bool Row::get_selectable()
  {
    return gtk_ctree_node_get_selectable(tree_,node_);
  }

void Row::set_background(const Gdk_Color& c)
  {
    gtk_ctree_node_set_background(tree_,node_,const_cast<GdkColor*>(c.gdkobj()));
  }

void Row::set_foreground(const Gdk_Color& c)
  {
    gtk_ctree_node_set_foreground(tree_,node_,const_cast<GdkColor*>(c.gdkobj()));
  }

gpointer Row::get_data()
  {
    return gtk_ctree_node_get_row_data(tree_,node_);
  }

void Row::set_data(gpointer d)
  {
    gtk_ctree_node_set_row_data(tree_,node_,d);
  }

void Row::set_data(gpointer d,GtkDestroyNotify n)
  {
    gtk_ctree_node_set_row_data_full(tree_,node_,d,n);
  }

GtkVisibility Row::is_visible()
  {
    return gtk_ctree_node_is_visible(tree_,node_);
  }

bool Row::is_viewable()
  {
    return gtk_ctree_is_viewable(tree_,node_);
  }

void Row::expand()
  {
    gtk_ctree_expand(tree_,node_);
  }

void Row::expand_recursive()
  {
    gtk_ctree_expand_recursive(tree_,node_);
  }

void Row::expand_to_depth(int depth)
  {
    gtk_ctree_expand_to_depth(tree_,node_,depth);
  }

void Row::collapse()
  {
    gtk_ctree_collapse(tree_,node_);
  }

void Row::collapse_recursive()
  {
    gtk_ctree_collapse_recursive(tree_,node_);
  }

void Row::collapse_to_depth(int depth)
  {
    gtk_ctree_collapse_to_depth(tree_,node_,depth);
  }

void Row::toggle_expansion()
  {
    gtk_ctree_toggle_expansion(tree_,node_);
  }

void Row::toggle_expansion_recursive()
  {
    gtk_ctree_toggle_expansion_recursive(tree_,node_);
  }

void Row::select()
  {
    gtk_ctree_select(tree_,node_);
  }

void Row::select_recursive()
  {
    gtk_ctree_select_recursive(tree_,node_);
  }

void Row::unselect()
  {
    gtk_ctree_unselect(tree_,node_);
  }

void Row::unselect_recursive()
  {
    gtk_ctree_unselect_recursive(tree_,node_);
  }

void Row::sort()
  {
    gtk_ctree_sort_node(tree_,node_);
  }

void Row::sort_recursive()
  {
    gtk_ctree_sort_recursive(tree_,node_);
  }

#define CT_ROW(x) ((GtkCTreeRow*)(((GList*)x)->data))
#define CT_CHILD(x) (CT_ROW(x)->children)
#define CT_NEXT(x) ((GtkCTreeNode*)g_list_next(x))
#define CT_PREV(x) ((GtkCTreeNode*)g_list_previous(x))
#define CT_PARENT(x) (CT_ROW(x)->parent)
#define CT_PARENT_NEXT(x) ((GtkCTreeNode*)(((GList*)CT_PARENT(x))->next))
#define CT_PARENT_PREV(x) ((GtkCTreeNode*)(((GList*)CT_PARENT(x))->prev))

RowIterator&  RowIterator::operator++()
  {
    if (!pnode_&&!node_)
      node_= (GtkCTreeNode*)(GTK_CLIST(tree_)->row_list);
    else if (!node_)
      node_=CT_CHILD(pnode_);
    else
      node_ = CT_NEXT(node_);
    return *this;
  }

RowIterator&  RowIterator::operator--()
  {
    if (!pnode_&&!node_)
      node_= (GtkCTreeNode*)(GTK_CLIST(tree_)->row_list_end);
    else if (!node_)
      node_=(GtkCTreeNode*)(g_list_last((GList*)CT_CHILD(pnode_)));
    else
      node_ = CT_PREV(node_);
    return *this;
  }

RowIterator::reference RowIterator::operator*() const
  {
    Self& r=const_cast<Self&>(*this);
    return r;
  }

RowIterator::pointer RowIterator::operator -> () const
  {
    return &operator*();
  }

Row& SelectionIterator::operator*() const
  {
    SelectionIterator& unconst_self = const_cast<SelectionIterator&>(*this);

    Row& r = unconst_self;
    r.node_ = (GtkCTreeNode*)(glist_node_->data);
    return r;
  }

Row* SelectionIterator::operator -> () const
  {
    return &operator*();
  }

SelectionIterator&  SelectionIterator::operator++()
  {
    if (!glist_node_)
      glist_node_ = GTK_CLIST(tree_)->selection;
    else
      glist_node_ = g_list_next(glist_node_);
    return *this;
  }

SelectionIterator&  SelectionIterator::operator--()
  {
    if (!glist_node_)
      glist_node_ = GTK_CLIST(tree_)->selection_end;
    else
      glist_node_ = g_list_previous(glist_node_);
    return *this;
  }

TreeIterator::reference TreeIterator::operator*() const
  {
    Self& r=const_cast<Self&>(*this);
    return r;
  }

TreeIterator::pointer TreeIterator::operator -> () const
  {
    return &operator*();
  }


TreeIterator&  TreeIterator::operator++()
  {
    if (!node_)
      node_=(GtkCTreeNode*)(GTK_CLIST(tree_)->row_list);
    else
      {
        if (CT_CHILD(node_)) node_=CT_CHILD(node_);
        else if (CT_NEXT(node_)) node_=CT_NEXT(node_);
        else if (CT_PARENT(node_)) node_=CT_PARENT_NEXT(node_);
        else node_=0;
      }
    return *this;
  }

TreeIterator&  TreeIterator::operator--()
  {
    if (!node_)
      node_=(GtkCTreeNode*)(GTK_CLIST(tree_)->row_list_end);
    else
      {
        if (CT_CHILD(node_))
	  node_=(GtkCTreeNode *)g_list_last((GList*)CT_CHILD(node_));
	else if(CT_PREV(node_)) node_=CT_PREV(node_);
	else if(CT_PARENT(node_)) node_=CT_PARENT_PREV(node_);
	else node_=0;
      }
    return *this;
  }

/**************************************************************
*** SelectionList
**************************************************************/
SelectionList::iterator SelectionList::begin_() const
  { return iterator(parent_->gtkobj(),GTK_CLIST(parent_->gtkobj())->selection); }
SelectionList::iterator SelectionList::end_() const
  { return iterator(parent_->gtkobj(),(GList*)0); }

GList*& SelectionList::glist() const
  { return GTK_CLIST(parent_->gtkobj())->selection; }

SelectionList::value_type SelectionList::operator[](size_type l) const
  {
    return Row(parent_->gtkobj(),
                gtk_ctree_node_nth(parent_->gtkobj(), l) );
       //GPOINTER_TO_INT(g_list_nth(GTK_CLIST(parent_->gtkobj())->selection,l)->data));
  }

void SelectionList::all()
  {
    gtk_clist_select_all(GTK_CLIST(parent_->gtkobj()));
  }

void SelectionList::clear()
  {
    gtk_clist_unselect_all(GTK_CLIST(parent_->gtkobj()));
  }

void SelectionList::undo()
  {
    gtk_clist_undo_selection(GTK_CLIST(parent_->gtkobj()));
  }

SelectionList::size_type SelectionList::size() const
  {
    return g_list_length(GTK_CLIST(parent_->gtkobj())->selection);
  }


RowList::iterator RowList::begin_() const
  {
    if (!node_)
      return iterator(parent_,0,
         (GtkCTreeNode*) GTK_CLIST(parent_)->row_list);
    return iterator(parent_,node_,
         CT_CHILD(node_));
  }

/**************************************************************
*** RowList
**************************************************************/
RowList::size_type RowList::size() const
  {
    if (!node_)
       return GTK_CLIST(parent_)->rows;
    return g_list_length((GList*)CT_CHILD(node_));
  }


RowList::iterator RowList::end_() const
  {
    return iterator(parent_, node_, 0);
  }

Row RowList::operator [](size_type i) const
  {
    if (!node_)
      return *iterator(parent_, 0,
                    (GtkCTreeNode*) g_list_nth(GTK_CLIST(parent_)->row_list,i));
    return *iterator(parent_, node_,
                    (GtkCTreeNode*) g_list_nth((GList*)CT_CHILD(node_),i));
  }

RowList::iterator RowList::insert(iterator i,const Element &e)
  {
    GtkCTreeNode* node= gtk_ctree_insert_node(parent_,
                          i.pnode_,
                          i.node_,
                          const_cast<gchar**>((const char **)(e.text_)),
                          e.spacing_,
                          e.pixmap_closed_,
                          e.mask_closed_,
                          e.pixmap_opened_,
                          e.mask_opened_,
                          e.is_leaf_,
                          e.expanded_);

    return iterator(parent_,i.pnode_,node);
  }

RowList::iterator RowList::find_data(gpointer data) const
  {
    GtkCTreeNode* node=gtk_ctree_find_by_row_data(parent_,node_,data);
    GtkCTreeNode* pnode=node_;
    if (node) pnode=CT_PARENT(node); // we need to adjust the parent
    return iterator(parent_,pnode,node);
  }

RowList Row::subtree()
  {
    return RowList(tree_,node_);
  }

Row Row::get_parent()
  {
    return Row(tree_,CT_PARENT(node_));
  }

guint8 Row::get_spacing()
  {
    gchar     *text;
    guint8     spacing;
    GdkPixmap *pixmap_closed,*pixmap_opened;
    GdkBitmap *mask_closed,*mask_opened;
    gboolean   is_leaf,expanded;
    gtk_ctree_get_node_info (tree_,node_,&text,&spacing,&pixmap_closed,&mask_closed,&pixmap_opened,&mask_opened,&is_leaf,&expanded);
    return spacing;
  }

bool Row::is_leaf()
  {
    gchar     *text;
    guint8     spacing;
    GdkPixmap *pixmap_closed,*pixmap_opened;
    GdkBitmap *mask_closed,*mask_opened;
    gboolean   is_leaf,expanded;
    gtk_ctree_get_node_info (tree_,node_,&text,&spacing,&pixmap_closed,&mask_closed,&pixmap_opened,&mask_opened,&is_leaf,&expanded);
    return is_leaf;
  }

bool Row::is_expanded()
  {
    gchar     *text;
    guint8     spacing;
    GdkPixmap *pixmap_closed,*pixmap_opened;
    GdkBitmap *mask_closed,*mask_opened;
    gboolean   is_leaf,expanded;
    gtk_ctree_get_node_info (tree_,node_,&text,&spacing,&pixmap_closed,&mask_closed,&pixmap_opened,&mask_opened,&is_leaf,&expanded);
    return expanded;
  }

void Row::set_spacing(guint8 tSpacing)
  {
    gchar     *text;
    guint8     spacing;
    GdkPixmap *pixmap_closed,*pixmap_opened;
    GdkBitmap *mask_closed,*mask_opened;
    gboolean   is_leaf,expanded;
    gtk_ctree_get_node_info (tree_,node_,&text,&spacing,&pixmap_closed,&mask_closed,&pixmap_opened,&mask_opened,&is_leaf,&expanded);
    gtk_ctree_set_node_info (tree_,node_,g_strdup(text),tSpacing,pixmap_closed,mask_closed,pixmap_opened,mask_opened,is_leaf,expanded);
  }

void Row::set_leaf(bool tLeaf)
  {
    gchar     *text;
    guint8     spacing;
    GdkPixmap *pixmap_closed,*pixmap_opened;
    GdkBitmap *mask_closed,*mask_opened;
    gboolean   is_leaf,expanded;
    gtk_ctree_get_node_info (tree_,node_,&text,&spacing,&pixmap_closed,&mask_closed,&pixmap_opened,&mask_opened,&is_leaf,&expanded);
    gtk_ctree_set_node_info (tree_,node_,g_strdup(text),spacing,pixmap_closed,mask_closed,pixmap_opened,mask_opened,tLeaf,expanded);
  }

void Row::set_opened (const Gdk_Pixmap& tPix,const Gdk_Bitmap& tBit)
  {
    gchar     *text;
    guint8     spacing;
    GdkPixmap *pixmap_closed,*pixmap_opened;
    GdkBitmap *mask_closed,*mask_opened;
    gboolean   is_leaf,expanded;
    gtk_ctree_get_node_info (tree_,node_,&text,&spacing,&pixmap_closed,&mask_closed,&pixmap_opened,&mask_opened,&is_leaf,&expanded);
    gdk_pixmap_ref (tPix);
    if (tBit) gdk_pixmap_ref (tBit);
    gtk_ctree_set_node_info (tree_,node_,g_strdup(text),spacing,pixmap_closed,mask_closed,tPix,tBit,is_leaf,expanded);
  }

void Row::set_closed (const Gdk_Pixmap& tPix,const Gdk_Bitmap& tBit)
  {
    gchar     *text;
    guint8     spacing;
    GdkPixmap *pixmap_closed,*pixmap_opened;
    GdkBitmap *mask_closed,*mask_opened;
    gboolean   is_leaf,expanded;
    gtk_ctree_get_node_info (tree_,node_,&text,&spacing,&pixmap_closed,&mask_closed,&pixmap_opened,&mask_opened,&is_leaf,&expanded);
    gdk_pixmap_ref (tPix);
    if (tBit) gdk_pixmap_ref (tBit);
    gtk_ctree_set_node_info (tree_,node_,g_strdup(text),spacing,tPix,tBit,pixmap_opened,mask_opened,is_leaf,expanded);
  }

RowList::iterator RowList::erase(iterator i)
  {
    iterator ri = i;
    ++ri;

    gtk_ctree_remove_node(parent_, i.node_);

    return ri;
  }

void RowList::remove(const_reference i)
  {
    gtk_ctree_remove_node(parent_, i.node_);
  }


/**************************************************************
*** CellIterator
**************************************************************/
CellIterator&  CellIterator::operator++()
  {
    if (column_<((GtkCList*)tree_)->columns) column_++;
    return *this;
  }

CellIterator&  CellIterator::operator--()
  {
    if (column_>0) column_--;
    return *this;
  }

Cell& CellIterator::operator*() const
  {
    return const_cast<CellIterator&>(*this);
  }

Cell* CellIterator::operator -> () const
  {
    return &operator*();
  };

bool RowList::empty() const
  {
    return ((GtkCList*)parent_)->row_list==0;
  }

bool TreeList::empty() const
  {
    return ((GtkCList*)tree_)->row_list==0;
  }

TreeList::iterator TreeList::begin_() const
  {
    return TreeIterator(tree_,(GtkCTreeNode*)(((GtkCList*)tree_)->row_list));
  }

TreeList::iterator TreeList::end_() const
  {
    return TreeIterator(tree_,0);
  }


} /* namespace CTree_Helpers */

/**************************************************************
*** SIGNALS
**************************************************************/

//this is insanely hard to do
namespace {
static void tree_select_row_convert_func(
            SigC::Callback3<void,Gtk::CTree::Row,gint,GtkCTree*> *s,
            GtkCTreeNode* p1,
            gint p2,
            GtkCTree* obj)
  {
    SigC::Callback2<void,Gtk::CTree::Row,gint> *s2=
      (SigC::Callback2<void,Gtk::CTree::Row,gint>*)s;
    s2->call(Gtk::CTree::Row(obj,p1),p2);
  }
}

SigC::Connection
CTree::Proxy_tree_select_row::connect(
            const SigC::Slot2<void,Gtk::CTree::Row,gint> &s)
   {
    return BaseType::connect(
        SigC::bind(
          SigC::convert(
            (SigC::Slot3<void,Gtk::CTree::Row,gint,GtkCTree*>&)s,
            &tree_select_row_convert_func),
          obj->gtkobj()
      ));
   }

SigC::Connection
CTree::Proxy_tree_unselect_row::connect(
            const SigC::Slot2<void,Gtk::CTree::Row,gint> &s)
   {
    return BaseType::connect(
        SigC::bind(
          SigC::convert(
            (SigC::Slot3<void,Gtk::CTree::Row,gint,GtkCTree*>&)s,
            &tree_select_row_convert_func),
          obj->gtkobj()
      ));
   }


namespace {
static void tree_expand_convert_func(
            SigC::Callback2<void,Gtk::CTree::Row,GtkCTree*> *s,
            GtkCTreeNode* p1,
            GtkCTree* obj)
  {
    SigC::Callback1<void,Gtk::CTree::Row> *s2=
      (SigC::Callback1<void,Gtk::CTree::Row>*)s;
    s2->call(Gtk::CTree::Row(obj,p1));
  }
}

SigC::Connection
CTree::Proxy_tree_expand::connect(
            const SigC::Slot1<void,Gtk::CTree::Row> &s)
   {
    return BaseType::connect(
        SigC::bind(
          SigC::convert(
            (SigC::Slot2<void,Gtk::CTree::Row,GtkCTree*>&)s,
            &tree_expand_convert_func),
          obj->gtkobj()
      ));
   }

SigC::Connection
CTree::Proxy_tree_collapse::connect(
            const SigC::Slot1<void,Gtk::CTree::Row> &s)
   {
    return BaseType::connect(
        SigC::bind(
          SigC::convert(
            (SigC::Slot2<void,Gtk::CTree::Row,GtkCTree*>&)s,
            &tree_expand_convert_func),
          obj->gtkobj()
      ));
   }





} /* namespace Gtk */
namespace Gtk {
Gtk::CTree *wrap (GtkCTree *o)
  {
    return static_cast<Gtk::CTree *> (Gtk::wrap_auto ((GtkObject *) (o)));
  }
}

namespace Gtk {
CTree_Class CTree::ctree_class = {0};

Object* CTree_Class::wrap_new(GtkObject* o)
  {
    Object* cpp=manage(new CTree((GtkCTree*)(o)));
    return cpp;
  }

bool CTree::isA( Object *checkcast)
  {
    return GTK_IS_CTREE(checkcast->gtkobj());
  }

GtkType CTree::get_type()
  {
    return ctree_class.get_type();
  }

GtkType CTree_Class::get_type()
  {
    if (!type)
      {
        CppClassParent::CppObjectType::get_type();
        GtkTypeInfo info =
          {
            "Gtk__CTree",
            sizeof(BaseObjectType),
            sizeof(BaseClassType),
            (GtkClassInitFunc) class_init_function,
            (GtkObjectInitFunc) object_init_function,
            /* reserved_1 */ NULL,
            /* reserved_2 */ NULL,
            /*base_class_init_func */ (GtkClassInitFunc) NULL
          };
        type=gtk_type_unique(gtk_ctree_get_type(), &info);
      }
    return type;
  }

const char* const CTree::signal_names[]={
   "tree_select_row",
   "tree_unselect_row",
   "tree_expand",
   "tree_collapse",
   0};

void CTree::initialize_class()
  {

     ctree_self=this;

  }

void CTree_Class::class_init_function(GtkCTreeClass *klass)
  {
    CppClassParent::class_init_function((BaseClassParent*)klass);
    klass->tree_select_row=tree_select_row_callback;
    klass->tree_unselect_row=tree_unselect_row_callback;
    klass->tree_expand=tree_expand_callback;
    klass->tree_collapse=tree_collapse_callback;
  }

void CTree_Class::object_init_function(GtkCTree *)
  {}

}

Gtk::CTree::CTree(GtkCTree *castitem)
  :     Gtk::CList((GtkCList*)(castitem))
  {
    initialize_class();
  }

Gtk::CTree::~CTree() { destroy_(); }

bool Gtk::CTree::is_hot_spot(gint x,gint y)
  {
    return ((gtk_ctree_is_hot_spot(gtkobj(),x,y))?true:false);
  }

void Gtk::CTree::set_indent(gint indent)
  {
    gtk_ctree_set_indent(gtkobj(),indent);
  }

void Gtk::CTree::set_spacing(gint spacing)
  {
    gtk_ctree_set_spacing(gtkobj(),spacing);
  }

void Gtk::CTree::set_show_stub(bool show_stub)
  {
    gtk_ctree_set_show_stub(gtkobj(),(gboolean)show_stub);
  }

void Gtk::CTree::set_line_style(LineStyle style)
  {
    gtk_ctree_set_line_style(gtkobj(),style);
  }

void Gtk::CTree::set_expander_style(ExpanderStyle style)
  {
    gtk_ctree_set_expander_style(gtkobj(),style);
  }

void Gtk::CTree::set_drag_compare_func(CompareDragFunc p0)
  {
    gtk_ctree_set_drag_compare_func(gtkobj(),p0);
  }

void Gtk::CTree_Class::tree_select_row_callback(GtkCTree* p0,GtkCTreeNode* p1,gint p2)
  {
    CppObjectType *obj=
      static_cast<CppObjectType *>(static_cast<Gtk::Object *>(
        gtk_object_get_data_by_id((GtkObject*)p0,Gtk::quark_)));

    if (obj)
      obj->tree_select_row_impl(Gtk::CTree::Row(p0,p1),p2);
    else
      {
        BaseClassType* base=
          static_cast<BaseClassType*>(
            gtk_type_parent_class(((GtkObject*)p0)->klass->type));
        if (base->tree_select_row)
          (base->tree_select_row)(p0,p1,p2);
      }

  }

void Gtk::CTree::tree_select_row_impl(Gtk::CTree::Row row,gint column)
  {
    BaseClassType* base=
      static_cast<BaseClassType*>(
        gtk_type_parent_class(gtkobject->klass->type));
    if (base->tree_select_row)
      (base->tree_select_row)(gtkobj(),row.node_,column);

  }

void Gtk::CTree_Class::tree_unselect_row_callback(GtkCTree* p0,GtkCTreeNode* p1,gint p2)
  {
    CppObjectType *obj=
      static_cast<CppObjectType *>(static_cast<Gtk::Object *>(
        gtk_object_get_data_by_id((GtkObject*)p0,Gtk::quark_)));

    if (obj)
      obj->tree_unselect_row_impl(Gtk::CTree::Row(p0,p1),p2);
    else
      {
        BaseClassType* base=
          static_cast<BaseClassType*>(
            gtk_type_parent_class(((GtkObject*)p0)->klass->type));
        if (base->tree_unselect_row)
          (base->tree_unselect_row)(p0,p1,p2);
      }

  }

void Gtk::CTree::tree_unselect_row_impl(Gtk::CTree::Row row,gint column)
  {
    BaseClassType* base=
      static_cast<BaseClassType*>(
        gtk_type_parent_class(gtkobject->klass->type));
    if (base->tree_unselect_row)
      (base->tree_unselect_row)(gtkobj(),row.node_,column);

  }

void Gtk::CTree_Class::tree_expand_callback(GtkCTree* p0,GtkCTreeNode* p1)
  {
    CppObjectType *obj=
      static_cast<CppObjectType *>(static_cast<Gtk::Object *>(
        gtk_object_get_data_by_id((GtkObject*)p0,Gtk::quark_)));

    if (obj)
      obj->tree_expand_impl(Gtk::CTree::Row(p0,p1));
    else
      {
        BaseClassType* base=
          static_cast<BaseClassType*>(
            gtk_type_parent_class(((GtkObject*)p0)->klass->type));
        if (base->tree_expand)
          (base->tree_expand)(p0,p1);
      }

  }

void Gtk::CTree::tree_expand_impl(Gtk::CTree::Row row)
  {
    BaseClassType* base=
      static_cast<BaseClassType*>(
        gtk_type_parent_class(gtkobject->klass->type));
    if (base->tree_expand)
      (base->tree_expand)(gtkobj(),row.node_);

  }

void Gtk::CTree_Class::tree_collapse_callback(GtkCTree* p0,GtkCTreeNode* p1)
  {
    CppObjectType *obj=
      static_cast<CppObjectType *>(static_cast<Gtk::Object *>(
        gtk_object_get_data_by_id((GtkObject*)p0,Gtk::quark_)));

    if (obj)
      obj->tree_collapse_impl(Gtk::CTree::Row(p0,p1));
    else
      {
        BaseClassType* base=
          static_cast<BaseClassType*>(
            gtk_type_parent_class(((GtkObject*)p0)->klass->type));
        if (base->tree_collapse)
          (base->tree_collapse)(p0,p1);
      }

  }

void Gtk::CTree::tree_collapse_impl(Gtk::CTree::Row row)
  {
    BaseClassType* base=
      static_cast<BaseClassType*>(
        gtk_type_parent_class(gtkobject->klass->type));
    if (base->tree_collapse)
      (base->tree_collapse)(gtkobj(),row.node_);

  }
