type style =
  [ `Ast | `Bourbaki | `Count | `Install | `List | `Raw | `Remove | `Table ]
and fields = All | These of (string * int option) list
val initial_parse_fieldspec : string -> fields
val parse_fieldspec : (string -> fields) ref
val user_specified_config_file : bool ref
val config_file : string ref
val create_config : bool ref
val save_history : bool ref
val ast : bool ref
val interactive : bool ref
val terse : bool ref
val borders : bool ref
val style : style ref
val fields : fields ref
val queries : (style * fields * string) list ref
val use_pager : bool ref
val columns : int ref
val rows : int ref
val coalesce : bool ref
val progress : bool ref
val user_set_progress : bool ref
val wrap : bool ref
val fast : bool ref
val very_slow : bool ref
val raise_exceptions : bool ref
val batch_specs : (string * Arg.spec * string) list
val add_query : string -> unit
val common_specs : (string * Arg.spec * string) list
val specs : (Arg.key * Arg.spec * Arg.doc) list
val cli_specs : (Arg.key * Arg.spec * Arg.doc) list
