(* Help *)
(* $Id: help.ml,v 1.2 2004/10/24 20:27:24 berke Exp $ *)
(* :vim:set tw=75: *)

(*** about *)
let about = Printf.sprintf "\
This is ara version %s released on %s.

Written by Oguz Berke DURAK (http://abaababa.ouvaton.org/).

Copyright (C) 2004.  Released under the GNU General Public Licence
version 2.

Many thanks to George Danchev, Thomas Schoepf and Sven Luther for doing the
Debian packaging of ara and many helpful comments.
" Version.version Version.date
;;
(* ***)
(*** gui_about *)
let gui_about = Printf.sprintf
  "Xara version %s released on %s\n\
  by Oğuz Berke DURAK\n\
  (http://abaababa.ouvaton.org/)\n\
  Copyright (C) 2004-2005\n\
  Released under the GNU General Public Licence version 2.\n\
  Many thanks to George Danchev, Thomas Schoepf and\n\
  Sven Luther for doing the Debian packaging of ara and\n\
  many helpful comments." Version.version Version.date
;;
(* ***)
(*** syntax *)
let syntax = "\
Queries are made up of terms, which are words (or regular expressions) used to select matching packages.

By default, terms are searched in the Description field of packages.


BOOLEAN OPERATORS

The query

    apache

selects all packages which have the word Apache or apache (or any other capitalization) in their Description field, whereas

    apache & php4

selects those having both apache and php4.

Words containing spaces or special characters can be enclosed in \" double quotes.

The boolean operators are | (disjunction) which can be also be written OR, & (conjunction) which can be written AND, and ! (complementation) which can be written NOT.  Expressions can be grouped using parentheses.  Example :

    (debian | \"gnu/linux\") and not (kde or gnome)


FIELD QUALIFIERS

Instead of the Description field, you can search other fields by preceding the search term with the name of the field followed by a colon, as in : 

    depends:ocaml

In fact this changes the default search field and applies to the following term even when it is a complex term.  For example

    depends:(kde or gnome or x11 or qt) & section:graphics

will select all packages whose Depends field contains kde, gnome, x11 or qt and whose Section field contains graphics.

The field qualifier can be a star-expression.  This way you may type :

    d*:(something or \"something else\")

and this will return all packages having something or something else in any field whose name starts with a d.


REGULAR EXPRESSIONS

More complex regular expressions need to be enclosed between slashes /.  The syntax is sed-ish, the second slash can be followed by i for case-insensitivity and w for word-boundary enforcing.  (Remark: digits count as word boundaries).  The regular expression syntax is that of Ocaml's Str module, which is more or less standard.  Example :

    /[tpn]etris/iw & depends:/libqt.*/w


VARIABLES

It is possible to put the result of a query into a named variable and use that variable afterwards.  This is accomplished by including an assignment in the query, such as :

    $gui := depends:(gtk | qt | kde | gnome | xlibs)

After execution a variable named GUI will appear in the variable list.  It may then be referred
as $gui.

Variables are currently not saved.


OTHER OPERATORS

There are lexicographic comparison operators <, >, <= and >=.  These use the Debian version order, which implies that version numbers and unsigned numbers in radixes <= 10 can be compared meaningfully.  Example :

    size >= 50000

Note that these do not work well with version numbers.

Equality = and difference <> are also defined.


OLDER ARA SYNTAX

The old syntax used in ara is still fully supported, and I plan to keep it around for a while.  Note that there have been some changes in Ocaml's Str module regular expression syntax recently (this concerns things like word boundaries).


NOTES

Some syntax involving brackets [ ] has been alloted for not yet implemented relational operators.  Executing such queries will give an harmless error.
";;

let examples = "\
This is ara, a utility to search the Debian (a Linux distribution)
package database using boolean combinations of regular expressions
operating on fields of the description.

ara is written in Ocaml, the finest computer programming language
on the surface of the earth. See http://caml.inria.fr/ for details.

See the manual page for details.

EXAMPLES
        
ara -list 'section=utils'
     List the name of every package in section utils.

ara -list 'section=utils and not depends:(gnome or kde or gtk)'
     ... except those whose dependency field contains
     gnome or kde or gtk

ara -set 'section=utils and not depends:(gnome|kde|gtk) &
priority=optional'
     ... list multiple names per line, and show only optional
     packages.

ara -set 'section=utils & !depends:(gtk|gnome|kde) &
priority=optional & size<100000'
     ... exclude packages greater than 99999 bytes.

ara -set 'section=utils & (!Depends=~/gtk\\|gnome\\|kde/ |
Size<100000) & Priority=optional'
   ... well, exclude gtk,gnome or kde stuff only if 100000 bytes
   or greater.
   
ara -fields Package,Size,Maintainer:20 -table 'section=utils &
(!depends:(gtk|gnome|kde) | size<100000) & priority=optional'
   ... show Package, Size and Maintainer fields from the above
   results as a nice ascii table, limiting the maintainer field
   to 20 characters.

ara -fields Package:8,Size,Description:100 -table 'section=games &
!depends:(gtk|sdl|kde|opengl|gnome) &
!description:(/shoot|kill|destroy|blast|race|bomb/iw |
/multi\\(-\\|\\)player\\|strategy\\|conquest\\|3\\(-\\|\\)d/iw) &
depends:(xlibs|vga) & !size>1000000'
   Assuming a 125-column display, display the first eight characters of the
   package name, the size in bytes, and the first hundred characters of the
   description of all packages in the games section not exceeding one
   million bytes, not depending on fancy stuff like gtk,SDL,KDE,OpenGL or
   Gnome, not mentioning some forms of violence (to shoot, to kill, etc.)
   in its description, not described as multi-player, strategy, conquest or
   three-dimensional games, yet depending on either xlibs or svga to exclude
   console-based games.

SPEED

ara reads the whole database into memory and then processes
queries. Since the database is usually big, this takes some
time. However, queries then run quite fast. So : specify
multiple queries or use the -interactive option to amortize
the cost of reading the database.

REMARKS
   
The database lives, by default, as text files under /var/lib/apt/lists/* or
/var/lib/dpkg/available on your Debian installation. It lists all packages,
installed or not, that are known to your Debian package management system.

Searching this file using grep usually gives bad results. This utility has
been written out of the frustration of not being able to do satisfactory
searches using standard text processing tools.\n"
;;
(* ***)
(*** cli_help *)
let cli_help = "
GENERAL OPERATION

Type your query and press enter.  Ara will display packages matching your
query using the current display mode.  If the results are longer than what
your screen can handle, ara will pipe the output to a pager, which is
/etc/alternatives/pager by default.  Depending on your system, this will be
probably a link to /usr/bin/less or /bin/more : to quit the pager and
return to ara, press 'q'.

Type #syntax for help on syntax,
     #examples to see some examples,
     #quit, #bye, #q or CTRL-D (EOF) to quit,
     #version to see version information,
     #about to see copyright, thanks and dedication,
     #memory to see memory usage,
     #compact to compact the heap,

DISPLAY AND ACTION MODES

In the following, if [query] is omitted, the default action mode is
changed instead :
   #short [query]    to display results in short form
   #list [query]     to display results as a list of package
                     (and version) names
   #table [query]    to display results as a table
   #show [query]     to show results in unformatted form
   #raw [query]      same
   #all [query]      same as above, but will always show all fields
   #ast [query]      to display the abstract syntax tree
   #install [query]  to install packages in query.  If a package is
                     listed more than once, it will only install the
                     newest version.
   #remove [query]   to remove packages in query

REDIRECTIONS AND PRINTING

Output from the commands #short, #list, #table, #show and #ast can
be redirected to a file or to the printer as follows :
(examples shown with #short, which can be omitted, in which case the
current mode is used)

   >/path/file #short [query]   will write output to file /path/file
   >>/path/file #short [query]  will append output to file /path/file
   >|/path/file #short [query]  will overwrite file /path/file with
                                output
   #print #short [query]        will print output using the configuration
                                value cli.commands.print

All meaningful command-line options can be changed interactively by
typing :
     #set [options] [queries] to change options and launch queries
     #set help to display list of options
Dashes preceding option keywords can be omitted.

MISCELLANEOUS COMMANDS

APT commands:
   #update to launch apt-get update (type #reload afterwards)
   #upgrade to launch apt-get upgrade
   #dist-upgrade to launch apt-get dist-upgrade

Other commands :
   #reload to reload the database
   #shell to launch a shell
   #compact to compact the heap
   #memory to show memory usage

(Press 'q' to quit this pager and return to ara.)
";;
(* ***)
(*** cli_examples *)
let cli_examples = "\
Example 1
#fields package,maintainer:30,version:20 #table section=utils & (!depends:(gtk|gnome|kde) | size<100000) & priority=optional

Example 2
section=utils and status:/^install/

Example 3
section=utils & (!depends:(gtk|gnome|kde) | size<100000) & priority=optional

Example 4
#set new
#set borders
#set fields Package:20,Version:10,Status:10,Description:35
#table
section=games & (/[^ ]etris/i or /fall.* block/)
T := section=games & (/[^ ]etris/i or /fall.* block/)
T & !depends:(kde or qt or gnome or emacs)
>/tmp/tetrises.txt T & !depends:(kde or qt or gnome or emacs)
#bye
";;
(* ***)
