/*                                                     -*- linux-c -*-
    Copyright (C) 2004 Tom Szilagyi

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: options.c 583 2007-02-10 16:36:41Z peterszilagyi $
*/

#include <config.h>

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>
#include <libxml/xmlmemory.h>
#include <libxml/parser.h>

#ifdef HAVE_CDDA
#ifdef HAVE_CDDB
#define _TMP_HAVE_CDDB 1
#undef HAVE_CDDB
#endif /* HAVE_CDDB */
#include <cdio/cdio.h>
#include <cdio/paranoia.h>
#ifdef HAVE_CDDB
#undef HAVE_CDDB
#endif /* HAVE_CDDB */
#ifdef _TMP_HAVE_CDDB
#define HAVE_CDDB 1
#undef _TMP_HAVE_CDDB
#endif /* _TMP_HAVE_CDDB */
#endif /* HAVE_CDDA */

#ifdef HAVE_SRC
#include <samplerate.h>
#endif /* HAVE_SRC */

#include "common.h"
#include "gui_main.h"
#include "music_browser.h"
#include "search.h"
#include "playlist.h"
#include "i18n.h"
#include "options.h"


options_t options;

static int current_notebook_page = 0;

extern int src_type_parsed;

extern GtkWidget * main_window;
extern GtkWidget * playlist_window;
extern GtkWidget * play_button;
extern GtkTooltips * aqualung_tooltips;

extern PangoFontDescription *fd_playlist;
extern PangoFontDescription *fd_browser;
extern PangoFontDescription *fd_bigtimer;
extern PangoFontDescription *fd_smalltimer;
extern PangoFontDescription *fd_songtitle;
extern PangoFontDescription *fd_songinfo;
extern PangoFontDescription *fd_statusbar;

extern GtkWidget * bigtimer_label;
extern GtkWidget * smalltimer_label_1;
extern GtkWidget * smalltimer_label_2;

extern GtkWidget * label_title;
extern GtkWidget * label_format;
extern GtkWidget * label_samplerate;
extern GtkWidget * label_bps;
extern GtkWidget * label_mono;
extern GtkWidget * label_output;
extern GtkWidget * label_src_type;

extern GtkWidget * statusbar_total;
extern GtkWidget * statusbar_total_label;
extern GtkWidget * statusbar_selected;
extern GtkWidget * statusbar_selected_label;

extern GtkWidget * statusbar_ms;

extern int music_store_changed;

extern GtkWidget * music_tree;
extern GtkTreeStore * music_store;

extern GtkWidget * play_list;
extern GtkTreeViewColumn * track_column;
extern GtkTreeViewColumn * rva_column;
extern GtkTreeViewColumn * length_column;

extern GtkListStore * play_store;

extern GtkWidget* gui_stock_label_button(gchar *blabel, const gchar *bstock);
extern void disable_bold_font_in_playlist(void);
extern void playlist_selection_changed(GtkTreeSelection * sel, gpointer data);
extern void set_buttons_relief(void);
extern void show_active_position_in_playlist(void);

int rva_is_enabled_shadow;
int rva_env_shadow;
float rva_refvol_shadow;
float rva_steepness_shadow;
int rva_use_averaging_shadow;
int rva_use_linear_thresh_shadow;
float rva_avg_linear_thresh_shadow;
float rva_avg_stddev_thresh_shadow;

int appearance_changed;
int reskin_flag;
int restart_flag;
int override_shadow;
int track_name_in_bold_shadow;

GtkWidget * options_window;
GtkWidget * notebook;

GtkWidget * entry_title;
GtkWidget * entry_param;
GtkWidget * check_enable_tooltips;
GtkWidget * check_buttons_at_the_bottom;
GtkWidget * check_disable_buttons_relief;
GtkWidget * check_main_window_always_on_top;
GtkWidget * check_simple_view_in_fx;
GtkWidget * check_united_minimization;
GtkWidget * check_show_sn_title;
GtkWidget * check_show_hidden;
GtkWidget * check_tags_tab_first;

GtkWidget * check_playlist_is_embedded;
GtkWidget * check_autoplsave;
GtkWidget * check_playlist_is_tree;
GtkWidget * check_album_shuffle_mode;
GtkWidget * check_enable_playlist_statusbar;
GtkWidget * check_pl_statusbar_show_size;
GtkWidget * check_show_rva_in_playlist;
GtkWidget * check_show_length_in_playlist;
GtkWidget * check_show_active_track_name_in_bold;
GtkWidget * check_enable_pl_rules_hint;
GtkListStore * plistcol_store;

GtkWidget * check_hide_comment_pane;
GtkWidget * check_enable_mstore_toolbar;
GtkWidget * check_enable_mstore_statusbar;
GtkWidget * check_ms_statusbar_show_size;
GtkWidget * check_expand_stores;
GtkWidget * check_enable_ms_rules_hint;
GtkWidget * check_enable_ms_tree_icons;
GtkWidget * combo_cwidth;
GtkWidget * check_magnify_smaller_images;
GtkListStore * ms_pathlist_store = NULL;
GtkTreeSelection * ms_pathlist_select;
GtkWidget * entry_ms_pathlist;

#ifdef HAVE_LADSPA
GtkWidget * combo_ladspa;
#endif /* HAVE_LADSPA */
#ifdef HAVE_SRC
GtkWidget * combo_src;
#endif /* HAVE_SRC */
GtkWidget * label_src;

GtkWidget * check_rva_is_enabled;
GtkWidget * rva_drawing_area;
GdkPixmap * rva_pixmap = NULL;
GtkWidget * rva_viewport;
GtkWidget * combo_listening_env;
GtkWidget * spin_refvol;
GtkWidget * spin_steepness;
GtkWidget * check_rva_use_averaging;
GtkWidget * combo_threshold;
GtkWidget * spin_linthresh;
GtkWidget * spin_stdthresh;
GtkObject * adj_refvol;
GtkObject * adj_steepness;
GtkObject * adj_linthresh;
GtkObject * adj_stdthresh;
GtkWidget * label_listening_env;
GtkWidget * label_refvol;
GtkWidget * label_steepness;
GtkWidget * label_threshold;
GtkWidget * label_linthresh;
GtkWidget * label_stdthresh;

GtkWidget * check_auto_use_meta_artist;
GtkWidget * check_auto_use_meta_record;
GtkWidget * check_auto_use_meta_track;
GtkWidget * check_auto_use_ext_meta_artist;
GtkWidget * check_auto_use_ext_meta_record;
GtkWidget * check_auto_use_ext_meta_track;
GtkWidget * combo_replaygain;

#ifdef HAVE_CDDA
GtkWidget * cdda_drive_speed_spinner;
GtkWidget * check_cdda_mode_overlap;
GtkWidget * check_cdda_mode_verify;
GtkWidget * check_cdda_mode_neverskip;
GtkWidget * check_cdda_force_drive_rescan;
GtkWidget * check_cdda_add_to_playlist;
GtkWidget * check_cdda_remove_from_playlist;
GtkWidget * label_cdda_maxretries;
GtkWidget * cdda_paranoia_maxretries_spinner;
#endif /* HAVE_CDDA */

#ifdef HAVE_CDDB
GtkWidget * cddb_server_entry;
GtkWidget * cddb_tout_spinner;
GtkWidget * cddb_email_entry;
GtkWidget * cddb_local_entry;
GtkWidget * cddb_local_check;
GtkWidget * cddb_radio_direct;
GtkWidget * cddb_radio_proxy;
GtkWidget * cddb_proto_combo;
GtkWidget * cddb_proxy_entry;
GtkWidget * cddb_proxy_port_spinner;
GtkWidget * cddb_label_proto;
GtkWidget * cddb_label_proxy;
GtkWidget * cddb_label_proxy_port;
#endif /* HAVE_CDDB */

GtkWidget * check_override_skin;

#define DEFAULT_FONT_NAME "Sans 11"

GtkWidget * entry_pl_font;
GtkWidget * entry_ms_font;
GtkWidget * entry_bt_font;
GtkWidget * entry_st_font;
GtkWidget * entry_songt_font;
GtkWidget * entry_si_font;
GtkWidget * entry_sb_font;
GtkWidget * button_pl_font;
GtkWidget * button_ms_font;
GtkWidget * button_bt_font;
GtkWidget * button_st_font;
GtkWidget * button_songt_font;
GtkWidget * button_si_font;
GtkWidget * button_sb_font;

GdkColor color;
GtkWidget * color_picker;

void draw_rva_diagram(void);
void show_restart_info(void);

GtkListStore * restart_list_store = NULL;


void
open_font_desc(void) {

        if (fd_playlist) pango_font_description_free(fd_playlist);
	fd_playlist = pango_font_description_from_string(options.playlist_font);
        if (fd_browser) pango_font_description_free(fd_browser);
	fd_browser = pango_font_description_from_string(options.browser_font);
        if (fd_bigtimer) pango_font_description_free(fd_bigtimer);
	fd_bigtimer = pango_font_description_from_string(options.bigtimer_font);
        if (fd_smalltimer) pango_font_description_free(fd_smalltimer);
	fd_smalltimer = pango_font_description_from_string(options.smalltimer_font);
        if (fd_songtitle) pango_font_description_free(fd_songtitle);
	fd_songtitle = pango_font_description_from_string(options.songtitle_font);
        if (fd_songinfo) pango_font_description_free(fd_songinfo);
	fd_songinfo = pango_font_description_from_string(options.songinfo_font);
        if (fd_statusbar) pango_font_description_free(fd_statusbar);
	fd_statusbar = pango_font_description_from_string(options.statusbar_font);
}

void
set_option_from_toggle(GtkWidget * widget, int * opt) {

	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget))) {
		*opt = 1;
	} else {
		*opt = 0;
	}
}

void
set_option_from_combo(GtkWidget * widget, int * opt) {

	*opt = gtk_combo_box_get_active(GTK_COMBO_BOX(widget));
}

void
set_option_from_spin(GtkWidget * widget, int * opt) {

	*opt = gtk_spin_button_get_value(GTK_SPIN_BUTTON(widget));
}

void
set_option_from_entry(GtkWidget * widget, char * opt) {

	strncpy(opt, gtk_entry_get_text(GTK_ENTRY(widget)), MAXLEN-1);
}
void
options_window_accept(void) {

	int i;
	int n;
	int n_prev = 3;
	GtkTreeIter iter;
	GtkTreeIter iter2;


        if (restart_flag) {
                show_restart_info();            
        }


	/* General */

	strncpy(options.title_format, gtk_entry_get_text(GTK_ENTRY(entry_title)), MAXLEN - 1);
	strncpy(options.default_param, gtk_entry_get_text(GTK_ENTRY(entry_param)), MAXLEN - 1);

	set_option_from_toggle(check_enable_tooltips, &options.enable_tooltips);
	if (options.enable_tooltips) {
                gtk_tooltips_enable(aqualung_tooltips);
	} else {
                gtk_tooltips_disable(aqualung_tooltips);
	}

	set_option_from_toggle(check_buttons_at_the_bottom, &options.buttons_at_the_bottom_shadow);
        set_option_from_toggle(check_disable_buttons_relief, &options.disable_buttons_relief);
	set_option_from_toggle(check_main_window_always_on_top, &options.main_window_always_on_top);

#ifdef HAVE_LADSPA
        set_option_from_toggle(check_simple_view_in_fx, &options.simple_view_in_fx_shadow);
#endif /* HAVE_LADSPA */
	set_option_from_toggle(check_united_minimization, &options.united_minimization);
	set_option_from_toggle(check_show_sn_title, &options.show_sn_title);
	set_option_from_toggle(check_show_hidden, &options.show_hidden);
        set_option_from_toggle(check_tags_tab_first, &options.tags_tab_first);


	/* Playlist */

	set_option_from_toggle(check_autoplsave, &options.auto_save_playlist);
	set_option_from_toggle(check_playlist_is_embedded, &options.playlist_is_embedded_shadow);
	set_option_from_toggle(check_playlist_is_tree, &options.playlist_is_tree);
	set_option_from_toggle(check_album_shuffle_mode, &options.album_shuffle_mode);
	set_option_from_toggle(check_enable_playlist_statusbar, &options.enable_playlist_statusbar_shadow);
	set_option_from_toggle(check_pl_statusbar_show_size, &options.pl_statusbar_show_size);
	set_option_from_toggle(check_show_rva_in_playlist, &options.show_rva_in_playlist);
	gtk_tree_view_column_set_visible(GTK_TREE_VIEW_COLUMN(rva_column),
					 options.show_rva_in_playlist);
	set_option_from_toggle(check_show_length_in_playlist, &options.show_length_in_playlist);
	gtk_tree_view_column_set_visible(GTK_TREE_VIEW_COLUMN(length_column),
					 options.show_length_in_playlist);
	set_option_from_toggle(check_show_active_track_name_in_bold, &options.show_active_track_name_in_bold);
	if (!options.show_active_track_name_in_bold) {
                disable_bold_font_in_playlist();
	}

	set_option_from_toggle(check_enable_pl_rules_hint, &options.enable_pl_rules_hint);
	gtk_tree_view_set_rules_hint(GTK_TREE_VIEW(play_list), options.enable_pl_rules_hint);


	/* Music Store */

	set_option_from_toggle(check_hide_comment_pane, &options.hide_comment_pane_shadow);


        set_option_from_toggle(check_enable_mstore_toolbar, &options.enable_mstore_toolbar_shadow);
	set_option_from_toggle(check_enable_mstore_statusbar, &options.enable_mstore_statusbar_shadow);
	set_option_from_toggle(check_ms_statusbar_show_size, &options.ms_statusbar_show_size);
	set_option_from_toggle(check_expand_stores, &options.autoexpand_stores);

	set_option_from_toggle(check_enable_ms_rules_hint, &options.enable_ms_rules_hint);
	gtk_tree_view_set_rules_hint(GTK_TREE_VIEW(music_tree), options.enable_ms_rules_hint);

	set_option_from_toggle(check_enable_ms_tree_icons, &options.enable_ms_tree_icons_shadow);

	set_option_from_combo(combo_cwidth, &options.cover_width);
	set_option_from_toggle(check_magnify_smaller_images, &options.magnify_smaller_images);


	/* RVA */

	options.rva_is_enabled = rva_is_enabled_shadow;
	options.rva_env = rva_env_shadow;
	options.rva_refvol = rva_refvol_shadow;
	options.rva_steepness = rva_steepness_shadow;
	options.rva_use_averaging = rva_use_averaging_shadow;
	options.rva_use_linear_thresh = rva_use_linear_thresh_shadow;
	options.rva_avg_linear_thresh = rva_avg_linear_thresh_shadow;
	options.rva_avg_stddev_thresh = rva_avg_stddev_thresh_shadow;


	/* Metadata */

	set_option_from_toggle(check_auto_use_meta_artist, &options.auto_use_meta_artist);
	set_option_from_toggle(check_auto_use_meta_record, &options.auto_use_meta_record);
	set_option_from_toggle(check_auto_use_meta_track, &options.auto_use_meta_track);


	set_option_from_toggle(check_auto_use_ext_meta_artist, &options.auto_use_ext_meta_artist);
	set_option_from_toggle(check_auto_use_ext_meta_record, &options.auto_use_ext_meta_record);
	set_option_from_toggle(check_auto_use_ext_meta_track, &options.auto_use_ext_meta_track);

	set_option_from_combo(combo_replaygain, &options.replaygain_tag_to_use);


	/* CDDA */
#ifdef HAVE_CDDA
	set_option_from_spin(cdda_drive_speed_spinner, &options.cdda_drive_speed);
	options.cdda_paranoia_mode =
		(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check_cdda_mode_overlap)) ? PARANOIA_MODE_OVERLAP : 0) |
		(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check_cdda_mode_verify)) ? PARANOIA_MODE_VERIFY : 0) |
		(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check_cdda_mode_neverskip)) ? PARANOIA_MODE_NEVERSKIP : 0);
	set_option_from_spin(cdda_paranoia_maxretries_spinner, &options.cdda_paranoia_maxretries);
	set_option_from_toggle(check_cdda_force_drive_rescan, &options.cdda_force_drive_rescan);
	set_option_from_toggle(check_cdda_add_to_playlist, &options.cdda_add_to_playlist);
	set_option_from_toggle(check_cdda_remove_from_playlist, &options.cdda_remove_from_playlist);
#endif /* HAVE_CDDA */


	/* CDDB */
#ifdef HAVE_CDDB
	set_option_from_entry(cddb_server_entry, options.cddb_server);
	set_option_from_spin(cddb_tout_spinner, &options.cddb_timeout);
	set_option_from_entry(cddb_email_entry, options.cddb_email);
	set_option_from_entry(cddb_local_entry, options.cddb_local);
        set_option_from_toggle(cddb_local_check, &options.cddb_cache_only);
        set_option_from_toggle(cddb_radio_proxy, &options.cddb_use_proxy);
	set_option_from_combo(cddb_proto_combo, &options.cddb_use_http);
	set_option_from_entry(cddb_proxy_entry, options.cddb_proxy);
	set_option_from_spin(cddb_proxy_port_spinner, &options.cddb_proxy_port);
#endif /* HAVE_CDDB */


	/* Appearance */

        set_option_from_toggle(check_override_skin, &options.override_skin_settings);


        /* refresh GUI */

        for (i = 0; i < 3; i++) {

		GtkTreeIter iter;
		GtkTreeViewColumn * cols[4];
		char * pnumstr;

		cols[0] = track_column;
		cols[1] = rva_column;
		cols[2] = length_column;
		cols[3] = NULL;

		gtk_tree_model_iter_nth_child(GTK_TREE_MODEL(plistcol_store), &iter, NULL, i);
		
		gtk_tree_model_get(GTK_TREE_MODEL(plistcol_store), &iter, 1, &pnumstr, -1);
		n = atoi(pnumstr);
		g_free(pnumstr);

		gtk_tree_view_move_column_after(GTK_TREE_VIEW(play_list),
						cols[n], cols[n_prev]);

		options.plcol_idx[i] = n;
		n_prev = n;
	}	

        if (!track_name_in_bold_shadow && options.show_active_track_name_in_bold == 1) {
		reskin_flag = 1;
                track_name_in_bold_shadow = 0;
        }

        if (options.override_skin_settings) {

                /* apply fonts */

                open_font_desc();

                gtk_widget_modify_font (music_tree, fd_browser);
                gtk_widget_modify_font (play_list, fd_playlist);

                gtk_widget_modify_font (bigtimer_label, fd_bigtimer);
                gtk_widget_modify_font (smalltimer_label_1, fd_smalltimer);
                gtk_widget_modify_font (smalltimer_label_2, fd_smalltimer);
                gtk_widget_modify_font (label_title, fd_songtitle);

                gtk_widget_modify_font (label_format, fd_songinfo);
                gtk_widget_modify_font (label_samplerate, fd_songinfo);
                gtk_widget_modify_font (label_bps, fd_songinfo);
                gtk_widget_modify_font (label_mono, fd_songinfo);
                gtk_widget_modify_font (label_output, fd_songinfo);
                gtk_widget_modify_font (label_src_type, fd_songinfo);

		if (options.enable_playlist_statusbar) {
			gtk_widget_modify_font (statusbar_total, fd_statusbar);
			gtk_widget_modify_font (statusbar_total_label, fd_statusbar);
			gtk_widget_modify_font (statusbar_selected, fd_statusbar);
			gtk_widget_modify_font (statusbar_selected_label, fd_statusbar);
		}
		if (options.enable_mstore_statusbar) {
			gtk_widget_modify_font (statusbar_ms, fd_statusbar);
		}

		set_playlist_color();

                if (appearance_changed) {
			reskin_flag = 1;
		}

        } else if (override_shadow) {
		reskin_flag = 1;
                override_shadow = 0;
        } 
     


#ifdef HAVE_CDDA
	i = 1; /* 0-th store is STORE_CDDA, skip it */
#else
	i = 0;
#endif /* HAVE_CDDA */
	while (gtk_tree_model_iter_nth_child(GTK_TREE_MODEL(music_store),
					     &iter, NULL, i++)) {
		char * p1;
		int j;
		int has;

		gtk_tree_model_get(GTK_TREE_MODEL(music_store), &iter, 2, &p1, -1);
		
		j = 0;
		has = 0;
		while (gtk_tree_model_iter_nth_child(GTK_TREE_MODEL(ms_pathlist_store),
						     &iter2, NULL, j++)) {
			char * p2;

			gtk_tree_model_get(GTK_TREE_MODEL(ms_pathlist_store), &iter2, 0, &p2, -1);
			if (strcmp(p1, p2) == 0) {

				if (access(p2, R_OK) == 0) {
					has = 1;
				}

				g_free(p2);
				break;
			}

			g_free(p2);
		}

		if (!has) {

			float dirty;
			char * name;

			gtk_tree_model_get(GTK_TREE_MODEL(music_store), &iter,
					   0, &name, 6, &dirty, -1);

			if (dirty < 0) {
				GtkWidget * dialog;

				dialog = gtk_message_dialog_new(GTK_WINDOW(options_window),
					GTK_DIALOG_DESTROY_WITH_PARENT | GTK_DIALOG_MODAL,
					GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO, 
					_("Do you want to save store \"%s\" before removing from Music Store?"), name + 1);
				gtk_window_set_position(GTK_WINDOW(dialog), GTK_WIN_POS_CENTER);
				gtk_dialog_set_default_response(GTK_DIALOG(dialog),
								GTK_RESPONSE_YES);
				gtk_container_set_border_width(GTK_CONTAINER(dialog), 5);
		
				if (aqualung_dialog_run(GTK_DIALOG(dialog)) == GTK_RESPONSE_YES) {
					save_music_store(&iter);
				} else {
					music_store_mark_saved(&iter);
				}

				gtk_widget_destroy(dialog);
				g_free(name);
			}

			gtk_tree_store_remove(music_store, &iter);
			--i;
		}

		g_free(p1);
	}


	i = 0;
	while (gtk_tree_model_iter_nth_child(GTK_TREE_MODEL(ms_pathlist_store),
					     &iter, NULL, i++)) {
		char * p1;
		int j;
		int has;
		char sort[4];

		snprintf(sort, 4, "%03d", i);

		gtk_tree_model_get(GTK_TREE_MODEL(ms_pathlist_store), &iter, 0, &p1, -1);

		j = 0;
		has = 0;
		while (gtk_tree_model_iter_nth_child(GTK_TREE_MODEL(music_store),
						     &iter2, NULL, j++)) {
			char * p2;

			gtk_tree_model_get(GTK_TREE_MODEL(music_store),
					   &iter2, 2, &p2, -1);

			if (strcmp(p1, p2) == 0) {

				gtk_tree_store_set(music_store, &iter2, 1, sort, -1);

				if (access(p2, W_OK) == 0) {
					gtk_tree_store_set(music_store, &iter2, 7, 1.0f, -1);
				} else {
					gtk_tree_store_set(music_store, &iter2, 7, -1.0f, -1);
				}

				g_free(p2);
				has = 1;

				break;
			}

			g_free(p2);
		}

		if (!has) {
			load_music_store(p1, sort);
		}

		g_free(p1);
	}

	set_buttons_relief();
	refresh_displays();
	gtk_window_set_keep_above(GTK_WINDOW(main_window), options.main_window_always_on_top);

        playlist_content_changed();
        playlist_selection_changed(NULL, NULL);
	music_store_set_status_bar_info();

        current_notebook_page = gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook));

	playlist_size_allocate(NULL, NULL);
        show_active_position_in_playlist();

	gtk_widget_destroy(options_window);

	save_config();
}


#ifdef HAVE_LADSPA
void
changed_ladspa_prepost(GtkWidget * widget, gpointer * data) {

	int status = gtk_combo_box_get_active(GTK_COMBO_BOX(combo_ladspa));
	options.ladspa_is_postfader = status;
}
#endif /* HAVE_LADSPA */


#ifdef HAVE_SRC
void
changed_src_type(GtkWidget * widget, gpointer * data) {

	options.src_type = gtk_combo_box_get_active(GTK_COMBO_BOX(combo_src));
	gtk_label_set_text(GTK_LABEL(label_src), src_get_description(options.src_type));
	set_src_type_label(options.src_type);
}
#endif /* HAVE_SRC */


void
check_rva_is_enabled_toggled(GtkWidget * widget, gpointer * data) {

	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check_rva_is_enabled))) {
		rva_is_enabled_shadow = 1;
		gtk_widget_set_sensitive(combo_listening_env, TRUE);
		gtk_widget_set_sensitive(label_listening_env, TRUE);
		gtk_widget_set_sensitive(spin_refvol, TRUE);
		gtk_widget_set_sensitive(label_refvol, TRUE);
		gtk_widget_set_sensitive(spin_steepness, TRUE);
		gtk_widget_set_sensitive(label_steepness, TRUE);

		gtk_widget_set_sensitive(check_rva_use_averaging, TRUE);

		if (rva_use_averaging_shadow) {
			gtk_widget_set_sensitive(combo_threshold, TRUE);
			gtk_widget_set_sensitive(label_threshold, TRUE);
			gtk_widget_set_sensitive(spin_linthresh, TRUE);
			gtk_widget_set_sensitive(label_linthresh, TRUE);
			gtk_widget_set_sensitive(spin_stdthresh, TRUE);
			gtk_widget_set_sensitive(label_stdthresh, TRUE);
		}
	} else {
		rva_is_enabled_shadow = 0;
		gtk_widget_set_sensitive(combo_listening_env, FALSE);
		gtk_widget_set_sensitive(label_listening_env, FALSE);
		gtk_widget_set_sensitive(spin_refvol, FALSE);
		gtk_widget_set_sensitive(label_refvol, FALSE);
		gtk_widget_set_sensitive(spin_steepness, FALSE);
		gtk_widget_set_sensitive(label_steepness, FALSE);

		gtk_widget_set_sensitive(check_rva_use_averaging, FALSE);
		gtk_widget_set_sensitive(combo_threshold, FALSE);
		gtk_widget_set_sensitive(label_threshold, FALSE);
		gtk_widget_set_sensitive(spin_linthresh, FALSE);
		gtk_widget_set_sensitive(label_linthresh, FALSE);
		gtk_widget_set_sensitive(spin_stdthresh, FALSE);
		gtk_widget_set_sensitive(label_stdthresh, FALSE);
	}

	draw_rva_diagram();
}


void
check_rva_use_averaging_toggled(GtkWidget * widget, gpointer * data) {

	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check_rva_use_averaging))) {
		rva_use_averaging_shadow = 1;
		gtk_widget_set_sensitive(combo_threshold, TRUE);
		gtk_widget_set_sensitive(label_threshold, TRUE);
		gtk_widget_set_sensitive(spin_linthresh, TRUE);
		gtk_widget_set_sensitive(label_linthresh, TRUE);
		gtk_widget_set_sensitive(spin_stdthresh, TRUE);
		gtk_widget_set_sensitive(label_stdthresh, TRUE);
	} else {
		rva_use_averaging_shadow = 0;
		gtk_widget_set_sensitive(combo_threshold, FALSE);
		gtk_widget_set_sensitive(label_threshold, FALSE);
		gtk_widget_set_sensitive(spin_linthresh, FALSE);
		gtk_widget_set_sensitive(label_linthresh, FALSE);
		gtk_widget_set_sensitive(spin_stdthresh, FALSE);
		gtk_widget_set_sensitive(label_stdthresh, FALSE);
	}
}


void
changed_listening_env(GtkWidget * widget, gpointer * data) {

	rva_env_shadow = gtk_combo_box_get_active(GTK_COMBO_BOX(combo_listening_env));

	switch (rva_env_shadow) {
	case 0: /* Audiophile */
		gtk_adjustment_set_value(GTK_ADJUSTMENT(adj_refvol), -12.0f);
		gtk_adjustment_set_value(GTK_ADJUSTMENT(adj_steepness), 1.0f);
		break;
	case 1: /* Living room */
		gtk_adjustment_set_value(GTK_ADJUSTMENT(adj_refvol), -12.0f);
		gtk_adjustment_set_value(GTK_ADJUSTMENT(adj_steepness), 0.7f);
		break;
	case 2: /* Office */
		gtk_adjustment_set_value(GTK_ADJUSTMENT(adj_refvol), -12.0f);
		gtk_adjustment_set_value(GTK_ADJUSTMENT(adj_steepness), 0.4f);
		break;
	case 3: /* Noisy workshop */
		gtk_adjustment_set_value(GTK_ADJUSTMENT(adj_refvol), -12.0f);
		gtk_adjustment_set_value(GTK_ADJUSTMENT(adj_steepness), 0.1f);
		break;
	default:
		fprintf(stderr, "programmer error: options.c/changed_listening_env(): "
			"invalid rva_env_shadow value.\nPlease report this to the programmers!\n");
		break;
	}
}


void
draw_rva_diagram(void) {

	GdkGC * gc;
	GdkColor fg_color;
	int i;
	int width = rva_viewport->allocation.width - 4;
	int height = rva_viewport->allocation.height - 4;
	int dw = width / 24;
	int dh = height / 24;
	int xoffs = (width - 24*dw) / 2 - 1;
	int yoffs = (height - 24*dh) / 2 - 1;
	float volx, voly;
	int px1, py1, px2, py2;


	gdk_draw_rectangle(rva_pixmap,
			   rva_drawing_area->style->black_gc,
			   TRUE,
			   0, 0,
			   rva_drawing_area->allocation.width,
			   rva_drawing_area->allocation.height);
	
	gc = gdk_gc_new(rva_pixmap);
	if (rva_is_enabled_shadow) {
		fg_color.red = 10000;
		fg_color.green = 10000;
		fg_color.blue = 10000;
	} else {
		fg_color.red = 5000;
		fg_color.green = 5000;
		fg_color.blue = 5000;
	}
	gdk_gc_set_rgb_fg_color(gc, &fg_color);

	for (i = 0; i <= 24; i++) {
		gdk_draw_line(rva_pixmap, gc,
			      xoffs + i * dw, yoffs,
			      xoffs + i * dw, yoffs + 24 * dh);
	}

	for (i = 0; i <= 24; i++) {
		gdk_draw_line(rva_pixmap, gc,
			      xoffs, yoffs + i * dh,
			      xoffs + 24 * dw, yoffs + i * dh);
	}

	if (rva_is_enabled_shadow) {
		fg_color.red = 0;
		fg_color.green = 0;
		fg_color.blue = 65535;
	} else {
		fg_color.red = 0;
		fg_color.green = 0;
		fg_color.blue = 30000;
	}
	gdk_gc_set_rgb_fg_color(gc, &fg_color);
	gdk_draw_line(rva_pixmap, gc, xoffs, yoffs + 24 * dh, xoffs + 24 * dw, yoffs);

	if (rva_is_enabled_shadow) {
		fg_color.red = 65535;
		fg_color.green = 0;
		fg_color.blue = 0;
	} else {
		fg_color.red = 30000;
		fg_color.green = 0;
		fg_color.blue = 0;
	}
	gdk_gc_set_rgb_fg_color(gc, &fg_color);


	volx = -24.0f;
	voly = volx + (volx - rva_refvol_shadow) * (rva_steepness_shadow - 1.0f);
	px1 = xoffs;
	py1 = yoffs - (voly * dh);

	volx = 0.0f;
	voly = volx + (volx - rva_refvol_shadow) * (rva_steepness_shadow - 1.0f);
	px2 = xoffs + 24*dw;
	py2 = yoffs - (voly * dh);

	gdk_draw_line(rva_pixmap, gc, px1, py1, px2, py2);

	gdk_draw_drawable(rva_drawing_area->window,
			rva_drawing_area->style->fg_gc[GTK_WIDGET_STATE(rva_drawing_area)],
			rva_pixmap,
			0, 0, 0, 0,
			width, height);

	g_object_unref(gc);
}


void
refvol_changed(GtkWidget * widget, gpointer * data) {

	rva_refvol_shadow = gtk_adjustment_get_value(GTK_ADJUSTMENT(widget));
	draw_rva_diagram();
}


void
steepness_changed(GtkWidget * widget, gpointer * data) {

	rva_steepness_shadow = gtk_adjustment_get_value(GTK_ADJUSTMENT(widget));
	draw_rva_diagram();
}


static gint
rva_configure_event(GtkWidget * widget, GdkEventConfigure * event) {

	if (rva_pixmap)
		g_object_unref(rva_pixmap);

	rva_pixmap = gdk_pixmap_new(widget->window,
				    widget->allocation.width,
				    widget->allocation.height,
				    -1);
	gdk_draw_rectangle(rva_pixmap,
			   widget->style->black_gc,
			   TRUE,
			   0, 0,
			   widget->allocation.width,
			   widget->allocation.height);
	draw_rva_diagram();
	return TRUE;
}


static gint
rva_expose_event(GtkWidget * widget, GdkEventExpose * event) {

	gdk_draw_drawable(widget->window,
			widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
			rva_pixmap,
			event->area.x, event->area.y,
			event->area.x, event->area.y,
			event->area.width, event->area.height);
	return FALSE;
}


void
changed_threshold(GtkWidget * widget, gpointer * data) {

	rva_use_linear_thresh_shadow =
	        gtk_combo_box_get_active(GTK_COMBO_BOX(combo_threshold));
}


void
linthresh_changed(GtkWidget * widget, gpointer * data) {

	rva_avg_linear_thresh_shadow = gtk_adjustment_get_value(GTK_ADJUSTMENT(widget));
}


void
stdthresh_changed(GtkWidget * widget, gpointer * data) {

	rva_avg_stddev_thresh_shadow = gtk_adjustment_get_value(GTK_ADJUSTMENT(widget)) / 100.0f;
}

void
show_restart_info(void) {

	GtkWidget * info_dialog;
	GtkWidget * list;
	GtkWidget * viewport;
	GtkCellRenderer * renderer;
	GtkTreeViewColumn * column;

        info_dialog = gtk_message_dialog_new(GTK_WINDOW (options_window),
					     GTK_DIALOG_DESTROY_WITH_PARENT | GTK_DIALOG_MODAL,
					     GTK_MESSAGE_INFO,
					     GTK_BUTTONS_OK,
					     _("You will need to restart Aqualung for the following changes to take effect:"));


        list = gtk_tree_view_new_with_model(GTK_TREE_MODEL(restart_list_store));
	renderer = gtk_cell_renderer_text_new();
	column = gtk_tree_view_column_new_with_attributes("",
							  renderer,
							  "text", 0,
							  NULL);
	gtk_tree_view_append_column(GTK_TREE_VIEW(list), column);
	gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(list), FALSE);

	viewport = gtk_viewport_new(NULL, NULL);
	gtk_container_add(GTK_CONTAINER(viewport), list);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(info_dialog)->vbox), viewport, FALSE, FALSE, 6);


	gtk_widget_show_all(info_dialog);
        aqualung_dialog_run(GTK_DIALOG(info_dialog));
        gtk_widget_destroy(info_dialog);
}

void
playlist_font_select(GtkWidget *widget) {

	gchar *s;
	GtkWidget *font_selector;
	gint response;

	font_selector = gtk_font_selection_dialog_new ("Select a font...");
	gtk_window_set_modal(GTK_WINDOW(font_selector), TRUE);
	gtk_window_set_transient_for(GTK_WINDOW(font_selector), GTK_WINDOW(options_window));
	gtk_font_selection_dialog_set_font_name (GTK_FONT_SELECTION_DIALOG(font_selector), options.playlist_font);
	gtk_widget_show (font_selector);
	response = aqualung_dialog_run (GTK_DIALOG (font_selector));

	if (response == GTK_RESPONSE_OK) {

		s = gtk_font_selection_dialog_get_font_name (GTK_FONT_SELECTION_DIALOG(font_selector));
		strncpy(options.playlist_font, s, MAX_FONTNAME_LEN);
		gtk_entry_set_text(GTK_ENTRY(entry_pl_font), s);
		g_free (s);

	}

        appearance_changed = 1;
	gtk_widget_destroy (font_selector);
}

void
browser_font_select(GtkWidget *widget) {

	gchar *s;
	GtkWidget *font_selector;
	gint response;

	font_selector = gtk_font_selection_dialog_new ("Select a font...");
	gtk_window_set_modal(GTK_WINDOW(font_selector), TRUE);
	gtk_window_set_transient_for(GTK_WINDOW(font_selector), GTK_WINDOW(options_window));
	gtk_font_selection_dialog_set_font_name (GTK_FONT_SELECTION_DIALOG(font_selector), options.browser_font);
	gtk_widget_show (font_selector);
	response = aqualung_dialog_run (GTK_DIALOG (font_selector));

	if (response == GTK_RESPONSE_OK) {

		s = gtk_font_selection_dialog_get_font_name (GTK_FONT_SELECTION_DIALOG(font_selector));
		strncpy(options.browser_font, s, MAX_FONTNAME_LEN);
		gtk_entry_set_text(GTK_ENTRY(entry_ms_font), s);
		g_free (s);

	}

        appearance_changed = 1;
	gtk_widget_destroy (font_selector);
}

void
bigtimer_font_select(GtkWidget *widget) {

	gchar *s;
	GtkWidget *font_selector;
	gint response;

	font_selector = gtk_font_selection_dialog_new ("Select a font...");
	gtk_window_set_modal(GTK_WINDOW(font_selector), TRUE);
	gtk_window_set_transient_for(GTK_WINDOW(font_selector), GTK_WINDOW(options_window));
	gtk_font_selection_dialog_set_font_name (GTK_FONT_SELECTION_DIALOG(font_selector), options.bigtimer_font);
	gtk_widget_show (font_selector);
	response = aqualung_dialog_run (GTK_DIALOG (font_selector));

	if (response == GTK_RESPONSE_OK) {

		s = gtk_font_selection_dialog_get_font_name (GTK_FONT_SELECTION_DIALOG(font_selector));
		strncpy(options.bigtimer_font, s, MAX_FONTNAME_LEN);
		gtk_entry_set_text(GTK_ENTRY(entry_bt_font), s);
		g_free (s);

	}

        appearance_changed = 1;
	gtk_widget_destroy (font_selector);
}

void
smalltimer_font_select(GtkWidget *widget) {

	gchar *s;
	GtkWidget *font_selector;
	gint response;

	font_selector = gtk_font_selection_dialog_new ("Select a font...");
	gtk_window_set_modal(GTK_WINDOW(font_selector), TRUE);
	gtk_window_set_transient_for(GTK_WINDOW(font_selector), GTK_WINDOW(options_window));
	gtk_font_selection_dialog_set_font_name (GTK_FONT_SELECTION_DIALOG(font_selector), options.smalltimer_font);
	gtk_widget_show (font_selector);
	response = aqualung_dialog_run (GTK_DIALOG (font_selector));

	if (response == GTK_RESPONSE_OK) {

		s = gtk_font_selection_dialog_get_font_name (GTK_FONT_SELECTION_DIALOG(font_selector));
		strncpy(options.smalltimer_font, s, MAX_FONTNAME_LEN);
		gtk_entry_set_text(GTK_ENTRY(entry_st_font), s);
		g_free (s);

	}

        appearance_changed = 1;
	gtk_widget_destroy (font_selector);
}

void
songtitle_font_select(GtkWidget *widget) {

	gchar *s;
	GtkWidget *font_selector;
	gint response;

	font_selector = gtk_font_selection_dialog_new ("Select a font...");
	gtk_window_set_modal(GTK_WINDOW(font_selector), TRUE);
	gtk_window_set_transient_for(GTK_WINDOW(font_selector), GTK_WINDOW(options_window));
	gtk_font_selection_dialog_set_font_name (GTK_FONT_SELECTION_DIALOG(font_selector), options.songtitle_font);
	gtk_widget_show (font_selector);
	response = aqualung_dialog_run (GTK_DIALOG (font_selector));

	if (response == GTK_RESPONSE_OK) {

		s = gtk_font_selection_dialog_get_font_name (GTK_FONT_SELECTION_DIALOG(font_selector));
		strncpy(options.songtitle_font, s, MAX_FONTNAME_LEN);
		gtk_entry_set_text(GTK_ENTRY(entry_songt_font), s);
		g_free (s);

	}

        appearance_changed = 1;
	gtk_widget_destroy (font_selector);
}

void
songinfo_font_select(GtkWidget *widget) {

	gchar *s;
	GtkWidget *font_selector;
	gint response;

	font_selector = gtk_font_selection_dialog_new ("Select a font...");
	gtk_window_set_modal(GTK_WINDOW(font_selector), TRUE);
	gtk_window_set_transient_for(GTK_WINDOW(font_selector), GTK_WINDOW(options_window));
	gtk_font_selection_dialog_set_font_name (GTK_FONT_SELECTION_DIALOG(font_selector), options.songinfo_font);
	gtk_widget_show (font_selector);
	response = aqualung_dialog_run (GTK_DIALOG (font_selector));

	if (response == GTK_RESPONSE_OK) {

		s = gtk_font_selection_dialog_get_font_name (GTK_FONT_SELECTION_DIALOG(font_selector));
		strncpy(options.songinfo_font, s, MAX_FONTNAME_LEN);
		gtk_entry_set_text(GTK_ENTRY(entry_si_font), s);
		g_free (s);

	}

        appearance_changed = 1;
	gtk_widget_destroy (font_selector);
}

void
statusbar_font_select(GtkWidget *widget) {

	gchar *s;
	GtkWidget *font_selector;
	gint response;

	font_selector = gtk_font_selection_dialog_new ("Select a font...");
	gtk_window_set_modal(GTK_WINDOW(font_selector), TRUE);
	gtk_window_set_transient_for(GTK_WINDOW(font_selector), GTK_WINDOW(options_window));
	gtk_font_selection_dialog_set_font_name (GTK_FONT_SELECTION_DIALOG(font_selector), options.statusbar_font);
	gtk_widget_show (font_selector);
	response = aqualung_dialog_run (GTK_DIALOG (font_selector));

	if (response == GTK_RESPONSE_OK) {

		s = gtk_font_selection_dialog_get_font_name (GTK_FONT_SELECTION_DIALOG(font_selector));
		strncpy(options.statusbar_font, s, MAX_FONTNAME_LEN);
		gtk_entry_set_text(GTK_ENTRY(entry_sb_font), s);
		g_free (s);

	}

        appearance_changed = 1;
	gtk_widget_destroy (font_selector);
}

void
restart_active(GtkToggleButton * togglebutton, gpointer data) {

	GtkTreeIter iter;
	char * text;
	int i = 0;


        restart_flag = 1;

        while (gtk_tree_model_iter_nth_child(GTK_TREE_MODEL(restart_list_store), &iter, NULL, i++)) {

                gtk_tree_model_get(GTK_TREE_MODEL(restart_list_store), &iter, 0, &text, -1);

                if (!strcmp(text, (char *)data)) {
                        gtk_list_store_remove(restart_list_store, &iter);
                        if (!gtk_tree_model_get_iter_first(GTK_TREE_MODEL(restart_list_store), &iter)) {
                                restart_flag = 0;
                        }
                        return;
                }
        }

	gtk_list_store_append(restart_list_store, &iter);
	gtk_list_store_set(restart_list_store, &iter, 0, (char *)data, -1);
}

void
set_sensitive_part(void) {

	GtkWidget *sensitive_table[] = {
		entry_ms_font, entry_pl_font, entry_bt_font, entry_st_font,
		entry_songt_font, entry_si_font, entry_sb_font, button_ms_font,
		button_pl_font, button_bt_font, button_st_font, button_songt_font,
		button_si_font, button_sb_font, color_picker
	};

	gboolean state;
        gint items, n;
        
        if (options.override_skin_settings) {
		state = TRUE;
	} else {
		state = FALSE;
	}

        items = sizeof(sensitive_table) / sizeof(GtkWidget*);

        for (n = 0; n < items; n++) {
                gtk_widget_set_sensitive(sensitive_table[n], state);
        }
}

void
cb_toggle_override_skin(GtkToggleButton *togglebutton, gpointer user_data) {

        options.override_skin_settings = options.override_skin_settings ? 0 : 1;
        appearance_changed = 1;
        set_sensitive_part();
}

void
color_selected(GtkColorButton *widget, gpointer user_data) {

	GdkColor c;
	gchar str[MAX_COLORNAME_LEN];

        appearance_changed = 1;
        gtk_color_button_get_color(widget, &c);
        sprintf(str, "#%02X%02X%02X", c.red * 256 / 65536, c.green * 256 / 65536, c.blue * 256 / 65536);

        strncpy(options.activesong_color, str, MAX_COLORNAME_LEN-1);
}

GtkWidget *
create_notebook_tab(char * text, char * imgfile) {

	GtkWidget * vbox;
        GdkPixbuf * pixbuf;
        GtkWidget * image;
	GtkWidget * label;

        char path[MAXLEN];

	vbox = gtk_vbox_new(FALSE, 0);

	label = gtk_label_new(text);
	gtk_box_pack_end(GTK_BOX(vbox), label, FALSE, FALSE, 0);

	sprintf(path, "%s/%s", AQUALUNG_DATADIR, imgfile);

        pixbuf = gdk_pixbuf_new_from_file(path, NULL);

	if (pixbuf) {
		image = gtk_image_new_from_pixbuf(pixbuf);
		gtk_box_pack_end(GTK_BOX(vbox), image, FALSE, FALSE, 0);
	}

	gtk_widget_show_all(vbox);

	return vbox;
}


void
refresh_ms_pathlist_clicked(GtkWidget * widget, gpointer * data) {

	GtkTreeIter iter;
	char * path;
	int i = 0;

	while (gtk_tree_model_iter_nth_child(GTK_TREE_MODEL(ms_pathlist_store),
					     &iter, NULL, i++)) {

		gtk_tree_model_get(GTK_TREE_MODEL(ms_pathlist_store), &iter, 0, &path, -1);

		if (access(path, R_OK | W_OK) == 0) {
			gtk_list_store_set(ms_pathlist_store, &iter, 2, _("rw"), -1);
		} else if (access(path, R_OK) == 0) {
			gtk_list_store_set(ms_pathlist_store, &iter, 2, _("r"), -1);
		} else {
			gtk_list_store_set(ms_pathlist_store, &iter, 2, _("unreachable"), -1);
		}

		g_free(path);
	}
}


void
append_ms_pathlist(char * path, char * name) {

	GtkTreeIter iter;

	gtk_list_store_append(ms_pathlist_store, &iter);
	gtk_list_store_set(ms_pathlist_store, &iter, 0, path, 1, name, -1);

	refresh_ms_pathlist_clicked(NULL, NULL);
}


void
add_ms_pathlist_clicked(GtkWidget * widget, gpointer * data) {

	const char * pname;
	char name[MAXLEN];
	char * path;
	GtkTreeIter iter;
	int i;
	struct stat st_file;

	pname = gtk_entry_get_text(GTK_ENTRY(entry_ms_pathlist));

	if (pname[0] == '\0') return;

	if (pname[0] == '~') {
		snprintf(name, MAXLEN - 1, "%s%s", options.home, pname + 1);
	} else if (pname[0] == '/') {
		strncpy(name, pname, MAXLEN - 1);
	} else {
		GtkWidget * dialog;
		GtkWidget * label;
		
		dialog = gtk_dialog_new_with_buttons(_("Warning"),
						     GTK_WINDOW(options_window),
						     GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
						     GTK_STOCK_OK, GTK_RESPONSE_ACCEPT,
						     NULL);
		gtk_window_set_position(GTK_WINDOW(dialog), GTK_WIN_POS_CENTER);
		gtk_dialog_set_default_response(GTK_DIALOG(dialog), GTK_RESPONSE_ACCEPT);
		gtk_container_set_border_width(GTK_CONTAINER(dialog), 5);
		
		label = gtk_label_new(_("Paths must either be absolute or starting with a tilde."));

		gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), label, FALSE, TRUE, 10);
		gtk_widget_show(label);
		
		aqualung_dialog_run(GTK_DIALOG(dialog));
		gtk_widget_destroy(dialog);
		return;
	}

	if ((path = g_locale_from_utf8(name, -1, NULL, NULL, NULL)) == NULL) {
		return;
	}

	if (stat(path, &st_file) != -1 && S_ISDIR(st_file.st_mode)) {
		return;
	}

	i = 0;
	while (gtk_tree_model_iter_nth_child(GTK_TREE_MODEL(ms_pathlist_store), &iter, NULL, i++)) {
		char * p;

		gtk_tree_model_get(GTK_TREE_MODEL(ms_pathlist_store), &iter, 0, &p, -1);

		if (!strcmp(p, path)) {

			GtkWidget * dialog;

			dialog = gtk_message_dialog_new(GTK_WINDOW(options_window),
							GTK_DIALOG_DESTROY_WITH_PARENT | GTK_DIALOG_MODAL,
							GTK_MESSAGE_WARNING,
							GTK_BUTTONS_CLOSE,
							_("The specified store has already been added to the list."));
			gtk_widget_show(dialog);
			aqualung_dialog_run(GTK_DIALOG(dialog));
			gtk_widget_destroy(dialog);

			g_free(p);
			g_free(path);
			return;
		}

		g_free(p);
	}
	

	gtk_entry_set_text(GTK_ENTRY(entry_ms_pathlist), "");

	append_ms_pathlist(path, name);

	g_free(path);
}


void
remove_ms_pathlist_clicked(GtkWidget * widget, gpointer data) {

	GtkTreeIter iter;
	int i = 0;

	while (gtk_tree_model_iter_nth_child(GTK_TREE_MODEL(ms_pathlist_store), &iter, NULL, i++)) {

		if (gtk_tree_selection_iter_is_selected(ms_pathlist_select, &iter)) {
			gtk_list_store_remove(ms_pathlist_store, &iter);
			--i;
		}
	}
}


void
browse_ms_pathlist_clicked(GtkWidget * widget, gpointer data) {

        GtkWidget * dialog;
	const gchar * selected_filename = gtk_entry_get_text(GTK_ENTRY(data));


        dialog = gtk_file_chooser_dialog_new(_("Please select a Music Store database."),
                                             GTK_WINDOW(options_window),
                                             GTK_FILE_CHOOSER_ACTION_OPEN,
                                             GTK_STOCK_APPLY, GTK_RESPONSE_ACCEPT,
                                             GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
                                             NULL);

	gtk_window_set_position(GTK_WINDOW(dialog), GTK_WIN_POS_CENTER_ON_PARENT);
        gtk_window_set_default_size(GTK_WINDOW(dialog), 580, 390);
        gtk_dialog_set_default_response(GTK_DIALOG(dialog), GTK_RESPONSE_ACCEPT);

        if (strlen(selected_filename)) {
		char * locale = g_locale_from_utf8(selected_filename, -1, NULL, NULL, NULL);
		char tmp[MAXLEN];
		tmp[0] = '\0';

		if (locale == NULL) {
			gtk_widget_destroy(dialog);
			return;
		}

		normalize_filename(locale, tmp);
		gtk_file_chooser_set_filename(GTK_FILE_CHOOSER(dialog), tmp);
		g_free(locale);
	} else {
                gtk_file_chooser_set_filename(GTK_FILE_CHOOSER(dialog), options.currdir);
	}

	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check_show_hidden))) {
		gtk_file_chooser_set_show_hidden(GTK_FILE_CHOOSER(dialog), TRUE);
	}

        if (aqualung_dialog_run(GTK_DIALOG(dialog)) == GTK_RESPONSE_ACCEPT) {

		char * utf8;

                selected_filename = gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(dialog));
		utf8 = g_locale_to_utf8(selected_filename, -1, NULL, NULL, NULL);

		if (utf8 == NULL) {
			gtk_widget_destroy(dialog);
			return;
		}

                gtk_entry_set_text(GTK_ENTRY(entry_ms_pathlist), utf8);

                strncpy(options.currdir, selected_filename, MAXLEN-1);
		g_free(utf8);
        }

        gtk_widget_destroy(dialog);
}


void
display_title_format_help(void) {

	GtkWidget *help_dialog;

        help_dialog = gtk_message_dialog_new (GTK_WINDOW(options_window), 
                                              GTK_DIALOG_DESTROY_WITH_PARENT | GTK_DIALOG_MODAL,
                                              GTK_MESSAGE_INFO, GTK_BUTTONS_CLOSE, 
                                              _("\nThe template string you enter here will be used to\n"
                                              "construct a single title line from an Artist, a Record\n"
                                              "and a Track name. These are denoted by %%a, %%r and %%t,\n"
                                              "respectively. Everything else you enter here will be\n"
                                              "literally copied into the resulting string.\n"));

        gtk_window_set_title(GTK_WINDOW(help_dialog), _("Help"));
        gtk_widget_show (help_dialog);
        aqualung_dialog_run(GTK_DIALOG(help_dialog));
        gtk_widget_destroy(help_dialog);
}


void
display_implict_command_line_help(void) {

	GtkWidget *help_dialog;

        help_dialog = gtk_message_dialog_new (GTK_WINDOW(options_window), 
                                              GTK_DIALOG_DESTROY_WITH_PARENT | GTK_DIALOG_MODAL,
                                              GTK_MESSAGE_INFO, GTK_BUTTONS_CLOSE, 
                                              _("\nThe string you enter here will be parsed as a command\n"
                                              "line before parsing the actual command line parameters.\n"
                                              "What you enter here will act as a default setting and may\n"
                                              "or may not be overrided from the 'real' command line.\n"
                                              "Example: enter '-o alsa -R' below to use ALSA output\n"
                                              "running realtime as a default.\n"));

        gtk_window_set_title(GTK_WINDOW(help_dialog), _("Help"));
        gtk_widget_show (help_dialog);
        aqualung_dialog_run(GTK_DIALOG(help_dialog));
        gtk_widget_destroy(help_dialog);
}


void
display_pathlist_help(void) {

	GtkWidget *help_dialog;

        help_dialog = gtk_message_dialog_new (GTK_WINDOW(options_window), 
                                              GTK_DIALOG_DESTROY_WITH_PARENT | GTK_DIALOG_MODAL,
                                              GTK_MESSAGE_INFO, GTK_BUTTONS_CLOSE, 
	                                      _("Paths must either be absolute or starting with a tilde, which will be expanded to the user's home directory.\n\n"
						"Drag and drop entries in the list to set the store order in the Music Store."));

        gtk_window_set_title(GTK_WINDOW(help_dialog), _("Help"));
        gtk_widget_show (help_dialog);
        aqualung_dialog_run(GTK_DIALOG(help_dialog));
        gtk_widget_destroy(help_dialog);
}

#ifdef HAVE_CDDA
void
display_cdda_drive_speed_help(void) {

	GtkWidget *help_dialog;

        help_dialog = gtk_message_dialog_new (GTK_WINDOW(options_window), 
                                              GTK_DIALOG_DESTROY_WITH_PARENT | GTK_DIALOG_MODAL,
                                              GTK_MESSAGE_INFO, GTK_BUTTONS_CLOSE,
					      _("\nSet the drive speed for CD playing in CD-ROM speed units.\n"
						"One speed unit equals to 176 kBps raw data reading speed.\n"
						"Warning: not all drives honor this setting.\n\n"

						"Lower speed usually means less drive noise. However,\n"
						"when using Paranoia error correction modes for increased\n"
						"accuracy, generally much larger speeds are required to\n"
						"prevent buffer underruns (and thus audible drop-outs).\n\n"

						"Please note that these settings do not apply to CD Ripping,\n"
						"which always happens with maximum available speed and\n"
						"with error correction modes manually set before every run."));

        gtk_window_set_title(GTK_WINDOW(help_dialog), _("Help"));
        gtk_widget_show (help_dialog);
        aqualung_dialog_run(GTK_DIALOG(help_dialog));
        gtk_widget_destroy(help_dialog);
}

void
display_cdda_force_drive_rescan_help(void) {

	GtkWidget *help_dialog;

        help_dialog = gtk_message_dialog_new (GTK_WINDOW(options_window), 
                                              GTK_DIALOG_DESTROY_WITH_PARENT | GTK_DIALOG_MODAL,
                                              GTK_MESSAGE_INFO, GTK_BUTTONS_CLOSE,
					      _("\nMost drives let Aqualung know when a CD has been inserted\n"
						"or removed by providing a 'media changed' flag. However,\n"
						"some drives don't set this flag properly, and thus it may\n"
						"happen that a newly inserted CD remains unnoticed to\n"
						"Aqualung. In such cases, enabling this option should help."));

        gtk_window_set_title(GTK_WINDOW(help_dialog), _("Help"));
        gtk_widget_show (help_dialog);
        aqualung_dialog_run(GTK_DIALOG(help_dialog));
        gtk_widget_destroy(help_dialog);
}

void
cdda_toggled(GtkWidget * widget, gpointer * data) {

	gtk_widget_set_sensitive(cdda_paranoia_maxretries_spinner,
				 !gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check_cdda_mode_neverskip)));
	gtk_widget_set_sensitive(label_cdda_maxretries,
				 !gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check_cdda_mode_neverskip)));
}
#endif /* HAVE_CDDA */


#ifdef HAVE_CDDB
void
cddb_radio_direct_toggled(GtkWidget * widget, gpointer * data) {

	gboolean state = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(cddb_radio_direct));

	gtk_widget_set_sensitive(cddb_proto_combo, state);
	gtk_widget_set_sensitive(cddb_label_proto, state);
	gtk_widget_set_sensitive(cddb_proxy_entry, !state);
	gtk_widget_set_sensitive(cddb_proxy_port_spinner, !state);
	gtk_widget_set_sensitive(cddb_label_proxy, !state);
	gtk_widget_set_sensitive(cddb_label_proxy_port, !state);
}
#endif /* HAVE_CDDB */

void
create_options_window(void) {

	GtkWidget * vbox_general;
	GtkWidget * frame_title;
	GtkWidget * frame_param;
	GtkWidget * frame_misc;
	GtkWidget * frame_cart;
	GtkWidget * hbox_title;
	GtkWidget * hbox_param;
	GtkWidget * vbox_misc;
	GtkWidget * vbox_cart;
	GtkWidget * vbox_appearance;

	GtkWidget * vbox_pl;
	GtkWidget * vbox_ms;
	GtkWidget * frame_ms_pathlist;
	GtkWidget * ms_pathlist_view;
	GtkWidget * vbox_ms_pathlist;
	GtkWidget * hbox_ms_pathlist;
	GtkWidget * hbox_ms_pathlist_2;
	GtkWidget * add_ms_pathlist;
	GtkWidget * browse_ms_pathlist;
	GtkWidget * remove_ms_pathlist;
	GtkWidget * refresh_ms_pathlist;
	GtkWidget * frame_plistcol;
	GtkWidget * vbox_plistcol;
	GtkWidget * label_plistcol;
	GtkWidget * viewport;
	GtkWidget * scrolled_win;
	GtkCellRenderer * renderer;
	GtkTreeViewColumn * column;
	GtkTreeIter iter;
	GtkWidget * plistcol_list;
	GtkWidget * label;

	GtkWidget * vbox_dsp;
	GtkWidget * frame_ladspa;
	GtkWidget * frame_src;
	GtkWidget * frame_fonts;
	GtkWidget * frame_colors;
	GtkWidget * vbox_ladspa;
	GtkWidget * vbox_src;
	GtkWidget * vbox_fonts;
	GtkWidget * vbox_colors;

	GtkWidget * vbox_rva;
	GtkWidget * table_rva;
        GtkWidget * label_cwidth;
	GtkWidget * hbox_cwidth;

	GtkWidget * vbox_meta;

#ifdef HAVE_CDDA
	GtkWidget * table_cdda;
	GtkWidget * help_btn_cdda_drive_speed;
	GtkWidget * help_btn_cdda_force_drive_rescan;
	GtkWidget * frame_cdda;
	GtkWidget * vbox_cdda;
	GtkWidget * hbox_cdda;
#endif /* HAVE_CDDA */

#ifdef HAVE_CDDB
	GtkWidget * table_cddb;
#endif /* HAVE_CDDB */

        GtkSizeGroup * label_size;

	GtkWidget * hbox;
	GtkWidget * hbox_s;
       	GtkWidget * help_btn_title;
	GtkWidget * help_btn_param;
	GtkWidget * help_pathlist;

#ifdef HAVE_LADSPA
	int status;
#endif /* HAVE_LADSPA */
	int i;


        restart_flag = 0;
	reskin_flag = 0;
        appearance_changed = 0;

	if (!restart_list_store) {
		restart_list_store = gtk_list_store_new(1, G_TYPE_STRING);
	} else {
		gtk_list_store_clear(restart_list_store);
	}

	refresh_ms_pathlist_clicked(NULL, NULL);

        options_window = gtk_dialog_new_with_buttons(_("Settings"),
					     GTK_WINDOW(main_window),
					     GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT | GTK_DIALOG_NO_SEPARATOR,
					     GTK_STOCK_OK, GTK_RESPONSE_ACCEPT,
					     GTK_STOCK_CANCEL, GTK_RESPONSE_REJECT,
					     NULL);
	gtk_window_set_position(GTK_WINDOW(options_window), GTK_WIN_POS_CENTER);
        gtk_dialog_set_default_response(GTK_DIALOG(options_window), GTK_RESPONSE_ACCEPT);
        gtk_container_set_border_width(GTK_CONTAINER(options_window), 5);

	notebook = gtk_notebook_new();
	gtk_notebook_set_tab_pos(GTK_NOTEBOOK(notebook), GTK_POS_LEFT);
	gtk_container_add(GTK_CONTAINER(GTK_DIALOG(options_window)->vbox), notebook);

        label_size = gtk_size_group_new(GTK_SIZE_GROUP_BOTH);

	/* "General" notebook page */

	vbox_general = gtk_vbox_new(FALSE, 3);
        gtk_container_set_border_width(GTK_CONTAINER(vbox_general), 8);
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), vbox_general, create_notebook_tab(_("General"), "general.png"));

	frame_title = gtk_frame_new(_("Title format"));
	gtk_box_pack_start(GTK_BOX(vbox_general), frame_title, FALSE, TRUE, 0);

        hbox_title = gtk_hbox_new(FALSE, 3);
	gtk_container_set_border_width(GTK_CONTAINER(hbox_title), 5);
	gtk_container_add(GTK_CONTAINER(frame_title), hbox_title);

	entry_title = gtk_entry_new();
        gtk_entry_set_max_length(GTK_ENTRY(entry_title), MAXLEN - 1);
	gtk_entry_set_text(GTK_ENTRY(entry_title), options.title_format);
	gtk_box_pack_start(GTK_BOX(hbox_title), entry_title, TRUE, TRUE, 0);

        help_btn_title = gtk_button_new_from_stock (GTK_STOCK_HELP); 
	g_signal_connect(help_btn_title, "clicked", G_CALLBACK(display_title_format_help), NULL);
	gtk_box_pack_start(GTK_BOX(hbox_title), help_btn_title, FALSE, FALSE, 0);

	frame_param = gtk_frame_new(_("Implicit command line"));
	gtk_box_pack_start(GTK_BOX(vbox_general), frame_param, FALSE, TRUE, 5);


        hbox_param = gtk_hbox_new(FALSE, 3);
	gtk_container_set_border_width(GTK_CONTAINER(hbox_param), 5);
	gtk_container_add(GTK_CONTAINER(frame_param), hbox_param);

	entry_param = gtk_entry_new();
        gtk_entry_set_max_length(GTK_ENTRY(entry_param), MAXLEN - 1);
	gtk_entry_set_text(GTK_ENTRY(entry_param), options.default_param);
	gtk_box_pack_start(GTK_BOX(hbox_param), entry_param, TRUE, TRUE, 0);

        help_btn_param = gtk_button_new_from_stock (GTK_STOCK_HELP); 
	g_signal_connect(help_btn_param, "clicked", G_CALLBACK(display_implict_command_line_help), NULL);
	gtk_box_pack_start(GTK_BOX(hbox_param), help_btn_param, FALSE, FALSE, 0);

	frame_misc = gtk_frame_new(_("Miscellaneous"));
	gtk_box_pack_start(GTK_BOX(vbox_general), frame_misc, FALSE, TRUE, 0);

	vbox_misc = gtk_vbox_new(FALSE, 3);
	gtk_container_set_border_width(GTK_CONTAINER(vbox_misc), 8);
	gtk_container_add(GTK_CONTAINER(frame_misc), vbox_misc);

	check_enable_tooltips =	gtk_check_button_new_with_label(_("Enable tooltips"));
        gtk_widget_set_name(check_enable_tooltips, "check_on_notebook");
	if (options.enable_tooltips) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_enable_tooltips), TRUE);
	}
	gtk_box_pack_start(GTK_BOX(vbox_misc), check_enable_tooltips, FALSE, FALSE, 0);

	check_buttons_at_the_bottom =
		gtk_check_button_new_with_label(_("Put control buttons at the bottom of playlist"));
	gtk_widget_set_name(check_buttons_at_the_bottom, "check_on_notebook");
	if (options.buttons_at_the_bottom_shadow) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_buttons_at_the_bottom), TRUE);
	}
	gtk_box_pack_start(GTK_BOX(vbox_misc), check_buttons_at_the_bottom, FALSE, FALSE, 0);
	g_signal_connect (G_OBJECT (check_buttons_at_the_bottom), "toggled",
						G_CALLBACK (restart_active), _("Put control buttons at the bottom of playlist"));

        check_disable_buttons_relief =
		gtk_check_button_new_with_label(_("Disable control buttons relief"));
	gtk_widget_set_name(check_disable_buttons_relief, "check_on_notebook");
	if (options.disable_buttons_relief) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_disable_buttons_relief), TRUE);
	}
	gtk_box_pack_start(GTK_BOX(vbox_misc), check_disable_buttons_relief, FALSE, FALSE, 0);


        check_main_window_always_on_top = gtk_check_button_new_with_label(_("Keep main window always on top"));
	gtk_widget_set_name(check_main_window_always_on_top, "check_on_notebook");
	if (options.main_window_always_on_top) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_main_window_always_on_top), TRUE);
	}
	gtk_box_pack_start(GTK_BOX(vbox_misc), check_main_window_always_on_top, FALSE, FALSE, 0);


#ifdef HAVE_LADSPA
	check_simple_view_in_fx =
		gtk_check_button_new_with_label(_("Simple view in LADSPA patch builder"));
	gtk_widget_set_name(check_simple_view_in_fx, "check_on_notebook");
	if (options.simple_view_in_fx_shadow) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_simple_view_in_fx), TRUE);
	}
	gtk_box_pack_start(GTK_BOX(vbox_misc), check_simple_view_in_fx, FALSE, FALSE, 0);
	g_signal_connect(G_OBJECT (check_simple_view_in_fx), "toggled",
						G_CALLBACK (restart_active), _("Simple view in LADSPA patch builder"));
#endif /* HAVE_LADSPA */

	check_united_minimization =
		gtk_check_button_new_with_label(_("United windows minimization"));
        gtk_widget_set_name(check_united_minimization, "check_on_notebook");
	if (options.united_minimization) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_united_minimization), TRUE);
	}
	gtk_box_pack_start(GTK_BOX(vbox_misc), check_united_minimization, FALSE, FALSE, 0);

	check_show_sn_title =
		gtk_check_button_new_with_label(_("Show song name in the main window's title"));
        gtk_widget_set_name(check_show_sn_title, "check_on_notebook");
	if (options.show_sn_title) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_show_sn_title), TRUE);
	}
	gtk_box_pack_start(GTK_BOX(vbox_misc), check_show_sn_title, FALSE, FALSE, 0);


	check_show_hidden = gtk_check_button_new_with_label(_("Show hidden files and directories in file choosers"));
	gtk_widget_set_name(check_show_hidden, "check_on_notebook");
	if (options.show_hidden) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_show_hidden), TRUE);
	}
	gtk_box_pack_start(GTK_BOX(vbox_misc), check_show_hidden, FALSE, FALSE, 0);

        check_tags_tab_first = gtk_check_button_new_with_label(_("Show tags tab first in the file info dialog"));
	gtk_widget_set_name(check_tags_tab_first, "check_on_notebook");
	if (options.tags_tab_first) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_tags_tab_first), TRUE);
	}
	gtk_box_pack_start(GTK_BOX(vbox_misc), check_tags_tab_first, FALSE, FALSE, 0);


        /* "Playlist" notebook page */

	vbox_pl = gtk_vbox_new(FALSE, 3);
        gtk_container_set_border_width(GTK_CONTAINER(vbox_pl), 8);
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), vbox_pl, create_notebook_tab(_("Playlist"), "playlist.png"));
	
        check_playlist_is_embedded =
		gtk_check_button_new_with_label(_("Embed playlist into main window"));
	gtk_widget_set_name(check_playlist_is_embedded, "check_on_notebook");
	if (options.playlist_is_embedded_shadow) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_playlist_is_embedded), TRUE);
	}
	gtk_box_pack_start(GTK_BOX(vbox_pl), check_playlist_is_embedded, FALSE, TRUE, 0);
	g_signal_connect (G_OBJECT (check_playlist_is_embedded), "toggled",
		G_CALLBACK (restart_active), _("Embed playlist into main window"));

	check_autoplsave =
	    gtk_check_button_new_with_label(_("Save and restore the playlist on exit/startup"));
	gtk_widget_set_name(check_autoplsave, "check_on_notebook");
	if (options.auto_save_playlist) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_autoplsave), TRUE);
	}
        gtk_box_pack_start(GTK_BOX(vbox_pl), check_autoplsave, FALSE, TRUE, 0);

        check_playlist_is_tree =
		gtk_check_button_new_with_label(_("Album mode is the default when adding entire records"));
	gtk_widget_set_name(check_playlist_is_tree, "check_on_notebook");
	if (options.playlist_is_tree) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_playlist_is_tree), TRUE);
	}
	gtk_box_pack_start(GTK_BOX(vbox_pl), check_playlist_is_tree, FALSE, TRUE, 0);

        check_album_shuffle_mode =
		gtk_check_button_new_with_label(_("When shuffling, records added in Album mode "
						  "are played in order"));
	gtk_widget_set_name(check_album_shuffle_mode, "check_on_notebook");
	if (options.album_shuffle_mode) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_album_shuffle_mode), TRUE);
	}
	gtk_box_pack_start(GTK_BOX(vbox_pl), check_album_shuffle_mode, FALSE, TRUE, 0);

	check_enable_playlist_statusbar =
		gtk_check_button_new_with_label(_("Enable statusbar"));
	gtk_widget_set_name(check_enable_playlist_statusbar, "check_on_notebook");
	if (options.enable_playlist_statusbar_shadow) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_enable_playlist_statusbar), TRUE);
	}
	g_signal_connect(G_OBJECT(check_enable_playlist_statusbar), "toggled",
			 G_CALLBACK(restart_active), _("Enable statusbar in playlist"));
        gtk_box_pack_start(GTK_BOX(vbox_pl), check_enable_playlist_statusbar, FALSE, TRUE, 0);

	check_pl_statusbar_show_size =
		gtk_check_button_new_with_label(_("Show soundfile size in statusbar"));
	gtk_widget_set_name(check_pl_statusbar_show_size, "check_on_notebook");
	if (options.pl_statusbar_show_size) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_pl_statusbar_show_size), TRUE);
	}
        gtk_box_pack_start(GTK_BOX(vbox_pl), check_pl_statusbar_show_size, FALSE, TRUE, 0);

        check_show_rva_in_playlist =
		gtk_check_button_new_with_label(_("Show RVA values"));
	gtk_widget_set_name(check_show_rva_in_playlist, "check_on_notebook");
	if (options.show_rva_in_playlist) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_show_rva_in_playlist), TRUE);
	}
        gtk_box_pack_start(GTK_BOX(vbox_pl), check_show_rva_in_playlist, FALSE, TRUE, 0);

	check_show_length_in_playlist =
		gtk_check_button_new_with_label(_("Show track lengths"));
	gtk_widget_set_name(check_show_length_in_playlist, "check_on_notebook");
	if (options.show_length_in_playlist) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_show_length_in_playlist), TRUE);
	}
        gtk_box_pack_start(GTK_BOX(vbox_pl), check_show_length_in_playlist, FALSE, TRUE, 0);
	
	check_show_active_track_name_in_bold =
		gtk_check_button_new_with_label(_("Show active track name in bold"));
	gtk_widget_set_name(check_show_active_track_name_in_bold, "check_on_notebook");
	track_name_in_bold_shadow = options.show_active_track_name_in_bold;
	if (options.show_active_track_name_in_bold) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_show_active_track_name_in_bold), TRUE);
	}
        gtk_box_pack_start(GTK_BOX(vbox_pl), check_show_active_track_name_in_bold, FALSE, TRUE, 0);

	check_enable_pl_rules_hint =
		gtk_check_button_new_with_label(_("Enable rules hint"));
        gtk_widget_set_name(check_enable_pl_rules_hint, "check_on_notebook");
	if (options.enable_pl_rules_hint) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_enable_pl_rules_hint), TRUE);
	}
	gtk_box_pack_start(GTK_BOX(vbox_pl), check_enable_pl_rules_hint, FALSE, TRUE, 0);

        frame_plistcol = gtk_frame_new(_("Playlist column order"));
        gtk_box_pack_start(GTK_BOX(vbox_pl), frame_plistcol, FALSE, TRUE, 5);

        vbox_plistcol = gtk_vbox_new(FALSE, 0);
        gtk_container_set_border_width(GTK_CONTAINER(vbox_plistcol), 8);
        gtk_container_add(GTK_CONTAINER(frame_plistcol), vbox_plistcol);
	
	label_plistcol = gtk_label_new(_("Drag and drop entries in the list below \n\
to set the column order in the Playlist."));
        gtk_box_pack_start(GTK_BOX(vbox_plistcol), label_plistcol, FALSE, TRUE, 5);


	plistcol_store = gtk_list_store_new(2,
					    G_TYPE_STRING,   /* Column name */
					    G_TYPE_STRING);  /* Column index */

        plistcol_list = gtk_tree_view_new_with_model(GTK_TREE_MODEL(plistcol_store));
	gtk_tree_view_set_enable_search(GTK_TREE_VIEW(plistcol_list), FALSE);
	renderer = gtk_cell_renderer_text_new();
	column = gtk_tree_view_column_new_with_attributes(_("Column"),
							  renderer,
							  "text", 0,
							  NULL);
        gtk_tree_view_append_column(GTK_TREE_VIEW(plistcol_list), column);
        gtk_tree_view_set_reorderable(GTK_TREE_VIEW(plistcol_list), TRUE);

        viewport = gtk_viewport_new(NULL, NULL);
        gtk_box_pack_start(GTK_BOX(vbox_plistcol), viewport, TRUE, TRUE, 5);

        gtk_container_add(GTK_CONTAINER(viewport), plistcol_list);

	for (i = 0; i < 3; i++) {
		switch (options.plcol_idx[i]) {
		case 0:
			gtk_list_store_append(plistcol_store, &iter);
			gtk_list_store_set(plistcol_store, &iter,
					   0, _("Track titles"), 1, "0", -1);
			break;
		case 1:
			gtk_list_store_append(plistcol_store, &iter);
			gtk_list_store_set(plistcol_store, &iter,
					   0, _("RVA values"), 1, "1", -1);
			break;
		case 2:
			gtk_list_store_append(plistcol_store, &iter);
			gtk_list_store_set(plistcol_store, &iter,
					   0, _("Track lengths"), 1, "2", -1);
			break;
		}
	}


        /* "Music store" notebook page */

	vbox_ms = gtk_vbox_new(FALSE, 3);
        gtk_container_set_border_width(GTK_CONTAINER(vbox_ms), 8);
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), vbox_ms, create_notebook_tab(_("Music Store"), "music_store.png"));

	check_hide_comment_pane =
		gtk_check_button_new_with_label(_("Hide comment pane"));
	gtk_widget_set_name(check_hide_comment_pane, "check_on_notebook");
	if (options.hide_comment_pane_shadow) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_hide_comment_pane), TRUE);
	}
	gtk_box_pack_start(GTK_BOX(vbox_ms), check_hide_comment_pane, FALSE, FALSE, 0);
	g_signal_connect (G_OBJECT (check_hide_comment_pane), "toggled",
			  G_CALLBACK (restart_active), _("Hide the Music Store comment pane"));

	check_enable_mstore_toolbar =
		gtk_check_button_new_with_label(_("Enable toolbar"));
	gtk_widget_set_name(check_enable_mstore_toolbar, "check_on_notebook");
	if (options.enable_mstore_toolbar_shadow) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_enable_mstore_toolbar), TRUE);
	}
	g_signal_connect(G_OBJECT(check_enable_mstore_toolbar), "toggled",
			 G_CALLBACK(restart_active), _("Enable toolbar in Music Store"));
        gtk_box_pack_start(GTK_BOX(vbox_ms), check_enable_mstore_toolbar, FALSE, TRUE, 0);

	check_enable_mstore_statusbar =
		gtk_check_button_new_with_label(_("Enable statusbar"));
	gtk_widget_set_name(check_enable_mstore_statusbar, "check_on_notebook");
	if (options.enable_mstore_statusbar_shadow) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_enable_mstore_statusbar), TRUE);
	}
	g_signal_connect(G_OBJECT(check_enable_mstore_statusbar), "toggled",
			 G_CALLBACK(restart_active), _("Enable statusbar in Music Store"));
        gtk_box_pack_start(GTK_BOX(vbox_ms), check_enable_mstore_statusbar, FALSE, TRUE, 0);

	check_ms_statusbar_show_size =
		gtk_check_button_new_with_label(_("Show soundfile size in statusbar"));
	gtk_widget_set_name(check_ms_statusbar_show_size, "check_on_notebook");
	if (options.ms_statusbar_show_size) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_ms_statusbar_show_size), TRUE);
	}
        gtk_box_pack_start(GTK_BOX(vbox_ms), check_ms_statusbar_show_size, FALSE, TRUE, 0);


	check_expand_stores = gtk_check_button_new_with_label(_("Expand Stores on startup"));
	gtk_widget_set_name(check_expand_stores, "check_on_notebook");
	if (options.autoexpand_stores) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_expand_stores), TRUE);
	}
	gtk_box_pack_start(GTK_BOX(vbox_ms), check_expand_stores, FALSE, FALSE, 0);

	check_enable_ms_rules_hint =
		gtk_check_button_new_with_label(_("Enable rules hint"));
        gtk_widget_set_name(check_enable_ms_rules_hint, "check_on_notebook");
	if (options.enable_ms_rules_hint) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_enable_ms_rules_hint), TRUE);
	}
	gtk_box_pack_start(GTK_BOX(vbox_ms), check_enable_ms_rules_hint, FALSE, TRUE, 0);

	check_enable_ms_tree_icons =
		gtk_check_button_new_with_label(_("Enable tree node icons"));
        gtk_widget_set_name(check_enable_ms_tree_icons, "check_on_notebook");
	if (options.enable_ms_tree_icons_shadow) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_enable_ms_tree_icons), TRUE);
	}
	g_signal_connect (G_OBJECT (check_enable_ms_tree_icons), "toggled",
			  G_CALLBACK (restart_active), _("Enable Music Store tree node icons"));
	gtk_box_pack_start(GTK_BOX(vbox_ms), check_enable_ms_tree_icons, FALSE, TRUE, 0);

	frame_cart = gtk_frame_new(_("Cover art"));
	gtk_box_pack_start(GTK_BOX(vbox_ms), frame_cart, FALSE, TRUE, 5);

	vbox_cart = gtk_vbox_new(FALSE, 3);
	gtk_container_set_border_width(GTK_CONTAINER(vbox_cart), 10);
	gtk_container_add(GTK_CONTAINER(frame_cart), vbox_cart);

        hbox_cwidth = gtk_hbox_new(FALSE, 0);
        gtk_box_pack_start(GTK_BOX(vbox_cart), hbox_cwidth, FALSE, FALSE, 0);
        label_cwidth = gtk_label_new(_("Default cover width:"));
        gtk_box_pack_start(GTK_BOX(hbox_cwidth), label_cwidth, FALSE, FALSE, 0);

        hbox_s = gtk_hbox_new(FALSE, 0);
        gtk_box_pack_start(GTK_BOX(hbox_cwidth), hbox_s, TRUE, TRUE, 3);

	combo_cwidth = gtk_combo_box_new_text ();
        gtk_box_pack_start(GTK_BOX(hbox_cwidth), combo_cwidth, FALSE, FALSE, 0);
        gtk_combo_box_append_text (GTK_COMBO_BOX (combo_cwidth), _("50 pixels"));
        gtk_combo_box_append_text (GTK_COMBO_BOX (combo_cwidth), _("100 pixels"));
        gtk_combo_box_append_text (GTK_COMBO_BOX (combo_cwidth), _("200 pixels"));
        gtk_combo_box_append_text (GTK_COMBO_BOX (combo_cwidth), _("300 pixels"));
        gtk_combo_box_append_text (GTK_COMBO_BOX (combo_cwidth), _("use browser window width"));

        gtk_combo_box_set_active (GTK_COMBO_BOX (combo_cwidth), options.cover_width);

        check_magnify_smaller_images =
		gtk_check_button_new_with_label(_("Do not magnify images with smaller width"));
	gtk_widget_set_name(check_magnify_smaller_images, "check_on_notebook");
	if (!options.magnify_smaller_images) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_magnify_smaller_images), TRUE);
	}
	gtk_box_pack_start(GTK_BOX(vbox_cart), check_magnify_smaller_images, FALSE, FALSE, 0);


	frame_ms_pathlist = gtk_frame_new(_("Paths to Music Store databases"));
	gtk_box_pack_start(GTK_BOX(vbox_ms), frame_ms_pathlist, FALSE, TRUE, 0);
	
	vbox_ms_pathlist = gtk_vbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(vbox_ms_pathlist), 10);
	gtk_container_add(GTK_CONTAINER(frame_ms_pathlist), vbox_ms_pathlist);

	ms_pathlist_view = gtk_tree_view_new_with_model(GTK_TREE_MODEL(ms_pathlist_store));
	ms_pathlist_select = gtk_tree_view_get_selection(GTK_TREE_VIEW(ms_pathlist_view));

	renderer = gtk_cell_renderer_text_new();
	column = gtk_tree_view_column_new_with_attributes(_("Path"), renderer,
							  "text", 1,
							  NULL);
	gtk_tree_view_column_set_resizable(GTK_TREE_VIEW_COLUMN(column), TRUE);
	gtk_tree_view_append_column(GTK_TREE_VIEW(ms_pathlist_view), column);

	renderer = gtk_cell_renderer_text_new();
	column = gtk_tree_view_column_new_with_attributes(_("Access"), renderer,
							  "text", 2,
							  NULL);
	gtk_tree_view_append_column(GTK_TREE_VIEW(ms_pathlist_view), column);

	gtk_widget_set_size_request(ms_pathlist_view, -1, 100);
        gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(ms_pathlist_view), TRUE);
        gtk_tree_view_set_reorderable(GTK_TREE_VIEW(ms_pathlist_view), TRUE);

	viewport = gtk_viewport_new(NULL, NULL);
	gtk_box_pack_start(GTK_BOX(vbox_ms_pathlist), viewport, FALSE, TRUE, 5);

        scrolled_win = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_win),
				       GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_container_add(GTK_CONTAINER(viewport), scrolled_win);
	gtk_container_add(GTK_CONTAINER(scrolled_win), ms_pathlist_view);
	
	hbox_ms_pathlist = gtk_hbox_new(FALSE, FALSE);
	gtk_box_pack_start(GTK_BOX(vbox_ms_pathlist), hbox_ms_pathlist, FALSE, FALSE, 0);

	entry_ms_pathlist = gtk_entry_new();
	gtk_box_pack_start(GTK_BOX(hbox_ms_pathlist), entry_ms_pathlist, TRUE, TRUE, 2);

	browse_ms_pathlist = gui_stock_label_button(_("Browse"), GTK_STOCK_OPEN);
        gtk_container_set_border_width(GTK_CONTAINER(browse_ms_pathlist), 2);
	g_signal_connect (G_OBJECT(browse_ms_pathlist), "clicked",
			  G_CALLBACK(browse_ms_pathlist_clicked), (gpointer)entry_ms_pathlist);
	gtk_box_pack_end(GTK_BOX(hbox_ms_pathlist), browse_ms_pathlist, FALSE, FALSE, 0);

	hbox_ms_pathlist_2 = gtk_hbox_new(FALSE, FALSE);
	gtk_box_pack_start(GTK_BOX(vbox_ms_pathlist), hbox_ms_pathlist_2, FALSE, FALSE, 0);

        help_pathlist = gtk_button_new_from_stock (GTK_STOCK_HELP); 
        gtk_container_set_border_width(GTK_CONTAINER(help_pathlist), 2);
	g_signal_connect(help_pathlist, "clicked", G_CALLBACK(display_pathlist_help), NULL);
	gtk_box_pack_start(GTK_BOX(hbox_ms_pathlist_2), help_pathlist, FALSE, FALSE, 0);

	refresh_ms_pathlist = gui_stock_label_button(_("Refresh"), GTK_STOCK_REFRESH);
	gtk_container_set_border_width(GTK_CONTAINER(refresh_ms_pathlist), 2);
 	g_signal_connect (G_OBJECT(refresh_ms_pathlist), "clicked",
 			  G_CALLBACK(refresh_ms_pathlist_clicked), NULL);
 	gtk_box_pack_end(GTK_BOX(hbox_ms_pathlist_2), refresh_ms_pathlist, FALSE, FALSE, 0);

	remove_ms_pathlist = gui_stock_label_button(_("Remove"), GTK_STOCK_REMOVE);
        gtk_container_set_border_width(GTK_CONTAINER(remove_ms_pathlist), 2);
	g_signal_connect (G_OBJECT(remove_ms_pathlist), "clicked",
			  G_CALLBACK(remove_ms_pathlist_clicked), NULL);
	gtk_box_pack_end(GTK_BOX(hbox_ms_pathlist_2), remove_ms_pathlist, FALSE, FALSE, 0);

	add_ms_pathlist = gui_stock_label_button(_("Add"), GTK_STOCK_ADD);
        gtk_container_set_border_width(GTK_CONTAINER(add_ms_pathlist), 2);
	g_signal_connect (G_OBJECT(add_ms_pathlist), "clicked",
			  G_CALLBACK(add_ms_pathlist_clicked), NULL);
	gtk_box_pack_end(GTK_BOX(hbox_ms_pathlist_2), add_ms_pathlist, FALSE, FALSE, 0);


	/* "DSP" notebook page */

	vbox_dsp = gtk_vbox_new(FALSE, 3);
        gtk_container_set_border_width(GTK_CONTAINER(vbox_dsp), 8);
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), vbox_dsp, create_notebook_tab(_("DSP"), "dsp.png"));

	frame_ladspa = gtk_frame_new(_("LADSPA plugin processing"));
	gtk_box_pack_start(GTK_BOX(vbox_dsp), frame_ladspa, FALSE, TRUE, 0);

	vbox_ladspa = gtk_vbox_new(FALSE, 3);
	gtk_container_set_border_width(GTK_CONTAINER(vbox_ladspa), 10);
	gtk_container_add(GTK_CONTAINER(frame_ladspa), vbox_ladspa);

#ifdef HAVE_LADSPA
        combo_ladspa = gtk_combo_box_new_text (); 
        gtk_box_pack_start(GTK_BOX(vbox_ladspa), combo_ladspa, TRUE, TRUE, 0);

	gtk_combo_box_append_text (GTK_COMBO_BOX (combo_ladspa), _("Pre Fader (before Volume & Balance)"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (combo_ladspa), _("Post Fader (after Volume & Balance)"));

	status = options.ladspa_is_postfader;
	gtk_combo_box_set_active (GTK_COMBO_BOX (combo_ladspa), status);
        g_signal_connect(combo_ladspa, "changed", G_CALLBACK(changed_ladspa_prepost), NULL);
#else
	{
		GtkWidget * label = gtk_label_new(_("Aqualung is compiled without LADSPA plugin support.\n\
See the About box and the documentation for details."));
		gtk_box_pack_start(GTK_BOX(vbox_ladspa), label, FALSE, TRUE, 5);
	}
#endif /* HAVE_LADSPA */


	frame_src = gtk_frame_new(_("Sample Rate Converter type"));
	gtk_box_pack_start(GTK_BOX(vbox_dsp), frame_src, FALSE, TRUE, 5);

	vbox_src = gtk_vbox_new(FALSE, 3);
	gtk_container_set_border_width(GTK_CONTAINER(vbox_src), 10);
	gtk_container_add(GTK_CONTAINER(frame_src), vbox_src);

	label_src = gtk_label_new("");

#ifdef HAVE_SRC
	combo_src = gtk_combo_box_new_text ();
	gtk_box_pack_start(GTK_BOX(vbox_src), combo_src, TRUE, TRUE, 0);

	{
		int i = 0;

		while (src_get_name(i)) {
                        gtk_combo_box_append_text (GTK_COMBO_BOX (combo_src), src_get_name(i));
			++i;
		}

	}

	gtk_combo_box_set_active (GTK_COMBO_BOX (combo_src), options.src_type);
	g_signal_connect(combo_src, "changed", G_CALLBACK(changed_src_type), NULL);

	gtk_label_set_text(GTK_LABEL(label_src), src_get_description(options.src_type));
#else
	gtk_label_set_text(GTK_LABEL(label_src),
			   _("Aqualung is compiled without Sample Rate Converter support.\n\
See the About box and the documentation for details."));

#endif /* HAVE_SRC */

	gtk_box_pack_start(GTK_BOX(vbox_src), label_src, TRUE, TRUE, 0);


	/* "Playback RVA" notebook page */

	vbox_rva = gtk_vbox_new(FALSE, 3);
        gtk_container_set_border_width(GTK_CONTAINER(vbox_rva), 8);
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), vbox_rva, create_notebook_tab(_("Playback RVA"), "rva.png"));

	check_rva_is_enabled = gtk_check_button_new_with_label(_("Enable playback RVA"));
	gtk_widget_set_name(check_rva_is_enabled, "check_on_notebook");
	if (options.rva_is_enabled) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_rva_is_enabled), TRUE);
	}
	rva_is_enabled_shadow = options.rva_is_enabled;
	g_signal_connect(G_OBJECT(check_rva_is_enabled), "toggled",
			 G_CALLBACK(check_rva_is_enabled_toggled), NULL);
        gtk_box_pack_start(GTK_BOX(vbox_rva), check_rva_is_enabled, FALSE, TRUE, 0);


	table_rva = gtk_table_new(8, 2, FALSE);
	gtk_box_pack_start(GTK_BOX(vbox_rva), table_rva, TRUE, TRUE, 5);

	rva_viewport = gtk_viewport_new(NULL, NULL);
	gtk_widget_set_size_request(rva_viewport, 244, 244);
        gtk_table_attach(GTK_TABLE(table_rva), rva_viewport, 0, 2, 0, 1,
                         GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 2);
	
	rva_drawing_area = gtk_drawing_area_new();
	gtk_widget_set_size_request(GTK_WIDGET(rva_drawing_area), 240, 240);
	gtk_container_add(GTK_CONTAINER(rva_viewport), rva_drawing_area);
	
	g_signal_connect(G_OBJECT(rva_drawing_area), "configure_event",
			 G_CALLBACK(rva_configure_event), NULL);
	g_signal_connect(G_OBJECT(rva_drawing_area), "expose_event",
			 G_CALLBACK(rva_expose_event), NULL);
	
        hbox = gtk_hbox_new(FALSE, 0);
        label_listening_env = gtk_label_new(_("Listening environment:"));
        gtk_box_pack_start(GTK_BOX(hbox), label_listening_env, FALSE, FALSE, 0);
        gtk_table_attach(GTK_TABLE(table_rva), hbox, 0, 1, 1, 2,
                         GTK_FILL, GTK_FILL, 5, 2);

	combo_listening_env = gtk_combo_box_new_text ();
        gtk_table_attach(GTK_TABLE(table_rva), combo_listening_env, 1, 2, 1, 2,
                         GTK_FILL | GTK_EXPAND, GTK_FILL, 5, 2);


	gtk_combo_box_append_text (GTK_COMBO_BOX (combo_listening_env), _("Audiophile"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (combo_listening_env), _("Living room"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (combo_listening_env), _("Office"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (combo_listening_env), _("Noisy workshop"));

	rva_env_shadow = options.rva_env;
	gtk_combo_box_set_active (GTK_COMBO_BOX (combo_listening_env), options.rva_env);
	g_signal_connect(combo_listening_env, "changed", G_CALLBACK(changed_listening_env), NULL);

        hbox = gtk_hbox_new(FALSE, 0);
        label_refvol = gtk_label_new(_("Reference volume [dBFS] :"));
        gtk_box_pack_start(GTK_BOX(hbox), label_refvol, FALSE, FALSE, 0);
        gtk_table_attach(GTK_TABLE(table_rva), hbox, 0, 1, 2, 3,
                         GTK_FILL, GTK_FILL, 5, 2);

	rva_refvol_shadow = options.rva_refvol;
        adj_refvol = gtk_adjustment_new(options.rva_refvol, -24.0f, 0.0f, 0.1f, 1.0f, 0.0f);
        spin_refvol = gtk_spin_button_new(GTK_ADJUSTMENT(adj_refvol), 0.1, 1);
        gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin_refvol), TRUE);
        gtk_spin_button_set_wrap(GTK_SPIN_BUTTON(spin_refvol), FALSE);
	g_signal_connect(G_OBJECT(adj_refvol), "value_changed",
			 G_CALLBACK(refvol_changed), NULL);
        gtk_table_attach(GTK_TABLE(table_rva), spin_refvol, 1, 2, 2, 3,
                         GTK_FILL, GTK_FILL, 5, 2);

        hbox = gtk_hbox_new(FALSE, 0);
        label_steepness = gtk_label_new(_("Steepness [dB/dB] :"));
        gtk_box_pack_start(GTK_BOX(hbox), label_steepness, FALSE, FALSE, 0);
        gtk_table_attach(GTK_TABLE(table_rva), hbox, 0, 1, 3, 4,
                         GTK_FILL, GTK_FILL, 5, 2);

	rva_steepness_shadow = options.rva_steepness;
        adj_steepness = gtk_adjustment_new(options.rva_steepness, 0.0f, 1.0f, 0.01f, 0.1f, 0.0f);
        spin_steepness = gtk_spin_button_new(GTK_ADJUSTMENT(adj_steepness), 0.02, 2);
        gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin_steepness), TRUE);
        gtk_spin_button_set_wrap(GTK_SPIN_BUTTON(spin_steepness), FALSE);
	g_signal_connect(G_OBJECT(adj_steepness), "value_changed",
			 G_CALLBACK(steepness_changed), NULL);
        gtk_table_attach(GTK_TABLE(table_rva), spin_steepness, 1, 2, 3, 4,
                         GTK_FILL, GTK_FILL, 5, 2);



	check_rva_use_averaging =
	    gtk_check_button_new_with_label(_("Apply averaged RVA to tracks of the same record"));
	gtk_widget_set_name(check_rva_use_averaging, "check_on_notebook");
	if (options.rva_use_averaging) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_rva_use_averaging), TRUE);
	}
	rva_use_averaging_shadow = options.rva_use_averaging;
	g_signal_connect(G_OBJECT(check_rva_use_averaging), "toggled",
			 G_CALLBACK(check_rva_use_averaging_toggled), NULL);
        gtk_table_attach(GTK_TABLE(table_rva), check_rva_use_averaging, 0, 2, 4, 5,
                         GTK_FILL, GTK_FILL, 5, 2);

        hbox = gtk_hbox_new(FALSE, 0);
        label_threshold = gtk_label_new(_("Drop statistical aberrations based on"));
        gtk_box_pack_start(GTK_BOX(hbox), label_threshold, FALSE, FALSE, 0);
        gtk_table_attach(GTK_TABLE(table_rva), hbox, 0, 1, 5, 6,
                         GTK_FILL, GTK_FILL, 5, 2);

	combo_threshold = gtk_combo_box_new_text ();
        gtk_table_attach(GTK_TABLE(table_rva), combo_threshold, 1, 2, 5, 6,
                         GTK_FILL | GTK_EXPAND, GTK_FILL, 5, 2);


	gtk_combo_box_append_text (GTK_COMBO_BOX (combo_threshold), _("% of standard deviation"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (combo_threshold), _("Linear threshold [dB]"));

	rva_use_linear_thresh_shadow = options.rva_use_linear_thresh;
	gtk_combo_box_set_active (GTK_COMBO_BOX (combo_threshold), options.rva_use_linear_thresh);
	g_signal_connect(combo_threshold, "changed", G_CALLBACK(changed_threshold), NULL);

        hbox = gtk_hbox_new(FALSE, 0);
        label_linthresh = gtk_label_new(_("Linear threshold [dB] :"));
        gtk_box_pack_start(GTK_BOX(hbox), label_linthresh, FALSE, FALSE, 0);
        gtk_table_attach(GTK_TABLE(table_rva), hbox, 0, 1, 6, 7,
                         GTK_FILL, GTK_FILL, 5, 2);

	rva_avg_linear_thresh_shadow = options.rva_avg_linear_thresh;
        adj_linthresh = gtk_adjustment_new(options.rva_avg_linear_thresh, 0.0f, 60.0f, 0.1f, 1.0f, 0.0f);
        spin_linthresh = gtk_spin_button_new(GTK_ADJUSTMENT(adj_linthresh), 0.1, 1);
        gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin_linthresh), TRUE);
        gtk_spin_button_set_wrap(GTK_SPIN_BUTTON(spin_linthresh), FALSE);
	g_signal_connect(G_OBJECT(adj_linthresh), "value_changed",
			 G_CALLBACK(linthresh_changed), NULL);
        gtk_table_attach(GTK_TABLE(table_rva), spin_linthresh, 1, 2, 6, 7,
                         GTK_FILL, GTK_FILL, 5, 2);

        hbox = gtk_hbox_new(FALSE, 0);
        label_stdthresh = gtk_label_new(_("% of standard deviation :"));
        gtk_box_pack_start(GTK_BOX(hbox), label_stdthresh, FALSE, FALSE, 0);
        gtk_table_attach(GTK_TABLE(table_rva), hbox, 0, 1, 7, 8,
                         GTK_FILL, GTK_FILL, 5, 2);

	rva_avg_stddev_thresh_shadow = options.rva_avg_stddev_thresh;
        adj_stdthresh = gtk_adjustment_new(options.rva_avg_stddev_thresh * 100.0f,
					   0.0f, 500.0f, 1.0f, 10.0f, 0.0f);
        spin_stdthresh = gtk_spin_button_new(GTK_ADJUSTMENT(adj_stdthresh), 0.5, 0);
        gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin_stdthresh), TRUE);
        gtk_spin_button_set_wrap(GTK_SPIN_BUTTON(spin_stdthresh), FALSE);
	g_signal_connect(G_OBJECT(adj_stdthresh), "value_changed",
			 G_CALLBACK(stdthresh_changed), NULL);
        gtk_table_attach(GTK_TABLE(table_rva), spin_stdthresh, 1, 2, 7, 8,
                         GTK_FILL, GTK_FILL, 5, 2);


	if (!rva_use_averaging_shadow) {
		gtk_widget_set_sensitive(combo_threshold, FALSE);
		gtk_widget_set_sensitive(label_threshold, FALSE);
		gtk_widget_set_sensitive(spin_linthresh, FALSE);
		gtk_widget_set_sensitive(label_linthresh, FALSE);
		gtk_widget_set_sensitive(spin_stdthresh, FALSE);
		gtk_widget_set_sensitive(label_stdthresh, FALSE);
	}

	if (!rva_is_enabled_shadow) {
		gtk_widget_set_sensitive(combo_listening_env, FALSE);
		gtk_widget_set_sensitive(label_listening_env, FALSE);
		gtk_widget_set_sensitive(spin_refvol, FALSE);
		gtk_widget_set_sensitive(label_refvol, FALSE);
		gtk_widget_set_sensitive(spin_steepness, FALSE);
		gtk_widget_set_sensitive(label_steepness, FALSE);
		gtk_widget_set_sensitive(check_rva_use_averaging, FALSE);
		gtk_widget_set_sensitive(combo_threshold, FALSE);
		gtk_widget_set_sensitive(label_threshold, FALSE);
		gtk_widget_set_sensitive(spin_linthresh, FALSE);
		gtk_widget_set_sensitive(label_linthresh, FALSE);
		gtk_widget_set_sensitive(spin_stdthresh, FALSE);
		gtk_widget_set_sensitive(label_stdthresh, FALSE);
	}

	/* "Metadata" notebook page */

	vbox_meta = gtk_vbox_new(FALSE, 3);
        gtk_container_set_border_width(GTK_CONTAINER(vbox_meta), 8);
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), vbox_meta, create_notebook_tab(_("Metadata"), "metadata.png"));

	hbox = gtk_hbox_new(FALSE, 0);
        gtk_box_pack_start(GTK_BOX(vbox_meta), hbox, FALSE, TRUE, 0);

	label = gtk_label_new(_("When adding to playlist, use file metadata (if available) "
				"instead of\ninformation from the Music Store for:"));
        gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 3);

	hbox = gtk_hbox_new(FALSE, 0);
        gtk_box_pack_start(GTK_BOX(vbox_meta), hbox, FALSE, TRUE, 0);
	check_auto_use_meta_artist = gtk_check_button_new_with_label(_("Artist name"));
	gtk_widget_set_name(check_auto_use_meta_artist, "check_on_notebook");
	if (options.auto_use_meta_artist) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_auto_use_meta_artist), TRUE);
	}
        gtk_box_pack_start(GTK_BOX(hbox), check_auto_use_meta_artist, FALSE, TRUE, 35);

	hbox = gtk_hbox_new(FALSE, 0);
        gtk_box_pack_start(GTK_BOX(vbox_meta), hbox, FALSE, TRUE, 0);
	check_auto_use_meta_record = gtk_check_button_new_with_label(_("Record name"));
	gtk_widget_set_name(check_auto_use_meta_record, "check_on_notebook");
	if (options.auto_use_meta_record) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_auto_use_meta_record), TRUE);
	}
        gtk_box_pack_start(GTK_BOX(hbox), check_auto_use_meta_record, FALSE, TRUE, 35);

	hbox = gtk_hbox_new(FALSE, 0);
        gtk_box_pack_start(GTK_BOX(vbox_meta), hbox, FALSE, TRUE, 0);
	check_auto_use_meta_track = gtk_check_button_new_with_label(_("Track name"));
	gtk_widget_set_name(check_auto_use_meta_track, "check_on_notebook");
	if (options.auto_use_meta_track) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_auto_use_meta_track), TRUE);
	}
        gtk_box_pack_start(GTK_BOX(hbox), check_auto_use_meta_track, FALSE, TRUE, 35);


	hbox = gtk_hbox_new(FALSE, 0);
        gtk_box_pack_start(GTK_BOX(vbox_meta), hbox, FALSE, TRUE, 5);

	label = gtk_label_new(_("When adding external files to playlist, use file metadata "
				"(if available) for:"));
        gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 3);

	hbox = gtk_hbox_new(FALSE, 0);
        gtk_box_pack_start(GTK_BOX(vbox_meta), hbox, FALSE, TRUE, 0);
	check_auto_use_ext_meta_artist = gtk_check_button_new_with_label(_("Artist name"));
	gtk_widget_set_name(check_auto_use_ext_meta_artist, "check_on_notebook");
	if (options.auto_use_ext_meta_artist) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_auto_use_ext_meta_artist), TRUE);
	}
        gtk_box_pack_start(GTK_BOX(hbox), check_auto_use_ext_meta_artist, FALSE, TRUE, 35);

	hbox = gtk_hbox_new(FALSE, 0);
        gtk_box_pack_start(GTK_BOX(vbox_meta), hbox, FALSE, TRUE, 0);
	check_auto_use_ext_meta_record = gtk_check_button_new_with_label(_("Record name"));
	gtk_widget_set_name(check_auto_use_ext_meta_record, "check_on_notebook");
	if (options.auto_use_ext_meta_record) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_auto_use_ext_meta_record), TRUE);
	}
        gtk_box_pack_start(GTK_BOX(hbox), check_auto_use_ext_meta_record, FALSE, TRUE, 35);

	hbox = gtk_hbox_new(FALSE, 0);
        gtk_box_pack_start(GTK_BOX(vbox_meta), hbox, FALSE, TRUE, 0);
	check_auto_use_ext_meta_track = gtk_check_button_new_with_label(_("Track name"));
	gtk_widget_set_name(check_auto_use_ext_meta_track, "check_on_notebook");
	if (options.auto_use_ext_meta_track) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_auto_use_ext_meta_track), TRUE);
	}
        gtk_box_pack_start(GTK_BOX(hbox), check_auto_use_ext_meta_track, FALSE, TRUE, 35);


	hbox = gtk_hbox_new(FALSE, 0);
        gtk_box_pack_start(GTK_BOX(vbox_meta), hbox, FALSE, TRUE, 5);

	label = gtk_label_new(_("Replaygain tag to extract from Ogg Xiph and APE tags: "));
        gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 3);


	hbox = gtk_hbox_new(FALSE, 0);
        gtk_box_pack_start(GTK_BOX(vbox_meta), hbox, FALSE, TRUE, 0);

	combo_replaygain = gtk_combo_box_new_text ();
        gtk_box_pack_start(GTK_BOX(hbox), combo_replaygain, FALSE, FALSE, 35);

	gtk_combo_box_append_text (GTK_COMBO_BOX (combo_replaygain), _("Replaygain_track_gain"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (combo_replaygain), _("Replaygain_album_gain"));

	gtk_combo_box_set_active (GTK_COMBO_BOX (combo_replaygain), options.replaygain_tag_to_use);


	/* CDDA notebook page */
#ifdef HAVE_CDDA
	table_cdda = gtk_table_new(5, 3, FALSE);
        gtk_container_set_border_width(GTK_CONTAINER(table_cdda), 8);
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), table_cdda, create_notebook_tab(_("CD Audio"), "cdda.png"));

	label = gtk_label_new(_("CD drive speed:"));
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
        gtk_table_attach(GTK_TABLE(table_cdda), hbox, 0, 1, 0, 1, GTK_FILL, GTK_FILL, 5, 3);

	cdda_drive_speed_spinner = gtk_spin_button_new_with_range(1, 99, 1);
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(cdda_drive_speed_spinner), options.cdda_drive_speed);
        gtk_table_attach(GTK_TABLE(table_cdda), cdda_drive_speed_spinner, 1, 2, 0, 1,
                         GTK_FILL | GTK_EXPAND, GTK_FILL, 5, 3);

        help_btn_cdda_drive_speed = gtk_button_new_from_stock(GTK_STOCK_HELP); 
	g_signal_connect(help_btn_cdda_drive_speed, "clicked", G_CALLBACK(display_cdda_drive_speed_help), NULL);
        gtk_table_attach(GTK_TABLE(table_cdda), help_btn_cdda_drive_speed, 2, 3, 0, 1, GTK_FILL, GTK_FILL, 5, 3);

	frame_cdda = gtk_frame_new(_("Paranoia error correction"));
        gtk_table_attach(GTK_TABLE(table_cdda), frame_cdda, 0, 3, 1, 2,
			 GTK_FILL | GTK_EXPAND, GTK_FILL, 5, 3);

	vbox_cdda = gtk_vbox_new(FALSE, 3);
	gtk_container_set_border_width(GTK_CONTAINER(vbox_cdda), 8);
	gtk_container_add(GTK_CONTAINER(frame_cdda), vbox_cdda);

	check_cdda_mode_overlap = gtk_check_button_new_with_label(_("Perform overlapped reads"));
        gtk_widget_set_name(check_cdda_mode_overlap, "check_on_notebook");
	gtk_box_pack_start(GTK_BOX(vbox_cdda), check_cdda_mode_overlap, FALSE, FALSE, 0);

	check_cdda_mode_verify = gtk_check_button_new_with_label(_("Verify data integrity"));
        gtk_widget_set_name(check_cdda_mode_verify, "check_on_notebook");
	gtk_box_pack_start(GTK_BOX(vbox_cdda), check_cdda_mode_verify, FALSE, FALSE, 0);

	check_cdda_mode_neverskip = gtk_check_button_new_with_label(_("Unlimited retry on failed reads (never skip)"));
        gtk_widget_set_name(check_cdda_mode_neverskip, "check_on_notebook");
	if (options.cdda_paranoia_mode & PARANOIA_MODE_NEVERSKIP) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_cdda_mode_neverskip), TRUE);
	}
	gtk_box_pack_start(GTK_BOX(vbox_cdda), check_cdda_mode_neverskip, FALSE, FALSE, 0);
	g_signal_connect(check_cdda_mode_neverskip, "toggled", G_CALLBACK(cdda_toggled), NULL);

        hbox_cdda = gtk_hbox_new(FALSE, 3);
	gtk_box_pack_start(GTK_BOX(vbox_cdda), hbox_cdda, FALSE, FALSE, 0);

	label_cdda_maxretries = gtk_label_new(_("\tMaximum number of retries:"));
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox), label_cdda_maxretries, FALSE, FALSE, 5);
	gtk_box_pack_start(GTK_BOX(hbox_cdda), hbox, FALSE, FALSE, 0);

	cdda_paranoia_maxretries_spinner = gtk_spin_button_new_with_range(1, 50, 1);
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(cdda_paranoia_maxretries_spinner), options.cdda_paranoia_maxretries);
	gtk_box_pack_start(GTK_BOX(hbox_cdda), cdda_paranoia_maxretries_spinner, FALSE, FALSE, 5);

	check_cdda_force_drive_rescan =
		gtk_check_button_new_with_label(_("Force TOC re-read on every drive scan"));
        gtk_widget_set_name(check_cdda_force_drive_rescan, "check_on_notebook");
        gtk_table_attach(GTK_TABLE(table_cdda), check_cdda_force_drive_rescan, 0, 2, 2, 3,
			 GTK_FILL | GTK_EXPAND, GTK_FILL, 5, 3);

        help_btn_cdda_force_drive_rescan = gtk_button_new_from_stock(GTK_STOCK_HELP); 
	g_signal_connect(help_btn_cdda_force_drive_rescan, "clicked", G_CALLBACK(display_cdda_force_drive_rescan_help), NULL);
        gtk_table_attach(GTK_TABLE(table_cdda), help_btn_cdda_force_drive_rescan, 2, 3, 2, 3, GTK_FILL, GTK_FILL, 5, 3);

	check_cdda_add_to_playlist =
		gtk_check_button_new_with_label(_("Automatically add CDs to Playlist"));
        gtk_widget_set_name(check_cdda_add_to_playlist, "check_on_notebook");
        gtk_table_attach(GTK_TABLE(table_cdda), check_cdda_add_to_playlist, 0, 3, 3, 4,
			 GTK_FILL | GTK_EXPAND, GTK_FILL, 5, 3);

	check_cdda_remove_from_playlist =
		gtk_check_button_new_with_label(_("Automatically remove CDs from Playlist"));
        gtk_widget_set_name(check_cdda_remove_from_playlist, "check_on_notebook");
        gtk_table_attach(GTK_TABLE(table_cdda), check_cdda_remove_from_playlist, 0, 3, 4, 5,
			 GTK_FILL | GTK_EXPAND, GTK_FILL, 5, 3);

	if (options.cdda_force_drive_rescan) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_cdda_force_drive_rescan), TRUE);
	}

	if (options.cdda_paranoia_mode & PARANOIA_MODE_OVERLAP) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_cdda_mode_overlap), TRUE);
	}

	if (options.cdda_paranoia_mode & PARANOIA_MODE_VERIFY) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_cdda_mode_verify), TRUE);
	}

	if (options.cdda_paranoia_mode & PARANOIA_MODE_NEVERSKIP) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_cdda_mode_neverskip), TRUE);
		gtk_widget_set_sensitive(cdda_paranoia_maxretries_spinner, FALSE);
		gtk_widget_set_sensitive(label_cdda_maxretries, FALSE);
	}

	if (options.cdda_add_to_playlist) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_cdda_add_to_playlist), TRUE);
	}

	if (options.cdda_remove_from_playlist) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_cdda_remove_from_playlist), TRUE);
	}

#endif /* HAVE_CDDA */


	/* CDDB notebook page */

#ifdef HAVE_CDDB
	table_cddb = gtk_table_new(8, 2, FALSE);
        gtk_container_set_border_width(GTK_CONTAINER(table_cddb), 8);
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), table_cddb, create_notebook_tab(_("CDDB"), "cddb.png"));

	label = gtk_label_new(_("CDDB server:"));
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
        gtk_table_attach(GTK_TABLE(table_cddb), hbox, 0, 1, 0, 1,
                         GTK_FILL, GTK_FILL, 5, 3);

	cddb_server_entry = gtk_entry_new();
	gtk_entry_set_text(GTK_ENTRY(cddb_server_entry), options.cddb_server);
        gtk_table_attach(GTK_TABLE(table_cddb), cddb_server_entry, 1, 2, 0, 1,
                         GTK_FILL | GTK_EXPAND, GTK_FILL, 5, 3);

	label = gtk_label_new(_("Connection timeout [sec]:"));
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
        gtk_table_attach(GTK_TABLE(table_cddb), hbox, 0, 1, 1, 2,
                         GTK_FILL, GTK_FILL, 5, 3);

	cddb_tout_spinner = gtk_spin_button_new_with_range(1, 60, 1);
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(cddb_tout_spinner), options.cddb_timeout);
        gtk_table_attach(GTK_TABLE(table_cddb), cddb_tout_spinner, 1, 2, 1, 2,
                         GTK_FILL | GTK_EXPAND, GTK_FILL, 5, 3);

	label = gtk_label_new(_("Email address for submission:"));
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
        gtk_table_attach(GTK_TABLE(table_cddb), hbox, 0, 1, 2, 3,
                         GTK_FILL, GTK_FILL, 5, 3);

	cddb_email_entry = gtk_entry_new();
	gtk_entry_set_text(GTK_ENTRY(cddb_email_entry), options.cddb_email);
        gtk_table_attach(GTK_TABLE(table_cddb), cddb_email_entry, 1, 2, 2, 3,
                         GTK_FILL | GTK_EXPAND, GTK_FILL, 5, 3);

	label = gtk_label_new(_("Local CDDB directory:"));
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
        gtk_table_attach(GTK_TABLE(table_cddb), hbox, 0, 1, 3, 4,
                         GTK_FILL, GTK_FILL, 5, 3);

	cddb_local_entry = gtk_entry_new();
	gtk_entry_set_text(GTK_ENTRY(cddb_local_entry), options.cddb_local);
        gtk_table_attach(GTK_TABLE(table_cddb), cddb_local_entry, 1, 2, 3, 4,
                         GTK_FILL | GTK_EXPAND, GTK_FILL, 5, 3);

        cddb_local_check =
		gtk_check_button_new_with_label(_("Use the local database only"));
        gtk_widget_set_name(cddb_local_check, "check_on_notebook");
        gtk_table_attach(GTK_TABLE(table_cddb), cddb_local_check, 0, 2, 4, 5,
                         GTK_FILL | GTK_EXPAND, GTK_FILL, 5, 3);
	if (options.cddb_cache_only) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cddb_local_check), TRUE);
	} else {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cddb_local_check), FALSE);
	}


	cddb_radio_direct = gtk_radio_button_new_with_label(NULL, _("Direct connection to CDDB server"));
	gtk_widget_set_name(cddb_radio_direct, "check_on_notebook");
	g_signal_connect(G_OBJECT(cddb_radio_direct), "toggled",
			 G_CALLBACK(cddb_radio_direct_toggled), NULL);
        gtk_table_attach(GTK_TABLE(table_cddb), cddb_radio_direct, 0, 2, 5, 6,
                         GTK_FILL | GTK_EXPAND, GTK_FILL, 5, 3);

	cddb_label_proto = gtk_label_new(_("Protocol for querying:"));
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox), cddb_label_proto, FALSE, FALSE, 0);
        gtk_table_attach(GTK_TABLE(table_cddb), hbox, 0, 1, 6, 7,
                         GTK_FILL, GTK_FILL, 35, 3);

	cddb_proto_combo = gtk_combo_box_new_text();
	gtk_combo_box_append_text(GTK_COMBO_BOX(cddb_proto_combo), _("CDDBP (port 888)"));
	gtk_combo_box_append_text(GTK_COMBO_BOX(cddb_proto_combo), _("HTTP (port 80)"));
	if (options.cddb_use_http) {
		gtk_combo_box_set_active(GTK_COMBO_BOX(cddb_proto_combo), 1);
	} else {
		gtk_combo_box_set_active(GTK_COMBO_BOX(cddb_proto_combo), 0);
	}
        gtk_table_attach(GTK_TABLE(table_cddb), cddb_proto_combo, 1, 2, 6, 7,
                         GTK_FILL | GTK_EXPAND, GTK_FILL, 5, 3);

	cddb_radio_proxy = gtk_radio_button_new_with_label_from_widget(
		       GTK_RADIO_BUTTON(cddb_radio_direct), _("HTTP tunneling through proxy"));
	gtk_widget_set_name(cddb_radio_proxy, "check_on_notebook");
        gtk_table_attach(GTK_TABLE(table_cddb), cddb_radio_proxy, 0, 2, 7, 8,
                         GTK_FILL | GTK_EXPAND, GTK_FILL, 5, 3);

	cddb_label_proxy = gtk_label_new(_("HTTP proxy:"));
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox), cddb_label_proxy, FALSE, FALSE, 0);
        gtk_table_attach(GTK_TABLE(table_cddb), hbox, 0, 1, 8, 9,
                         GTK_FILL, GTK_FILL, 35, 3);

	cddb_proxy_entry = gtk_entry_new();
	gtk_entry_set_text(GTK_ENTRY(cddb_proxy_entry), options.cddb_proxy);
        gtk_table_attach(GTK_TABLE(table_cddb), cddb_proxy_entry, 1, 2, 8, 9,
                         GTK_FILL | GTK_EXPAND, GTK_FILL, 5, 3);

	cddb_label_proxy_port = gtk_label_new(_("Port:"));
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox), cddb_label_proxy_port, FALSE, FALSE, 0);
        gtk_table_attach(GTK_TABLE(table_cddb), hbox, 0, 1, 9, 10,
                         GTK_FILL, GTK_FILL, 35, 3);

	cddb_proxy_port_spinner = gtk_spin_button_new_with_range(0, 65535, 1);
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(cddb_proxy_port_spinner), options.cddb_proxy_port);
        gtk_table_attach(GTK_TABLE(table_cddb), cddb_proxy_port_spinner, 1, 2, 9, 10,
                         GTK_FILL | GTK_EXPAND, GTK_FILL, 5, 3);

	if (options.cddb_use_proxy) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cddb_radio_direct), TRUE);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cddb_radio_proxy), TRUE);
	} else {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cddb_radio_proxy), TRUE);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cddb_radio_direct), TRUE);
	}

#endif /* HAVE_CDDB */

        /* Appearance notebook page */

        override_shadow = options.override_skin_settings;

	vbox_appearance = gtk_vbox_new(FALSE, 3);
        gtk_container_set_border_width(GTK_CONTAINER(vbox_appearance), 8);
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), vbox_appearance, create_notebook_tab(_("Appearance"), "appearance.png"));

        check_override_skin =
		gtk_check_button_new_with_label(_("Override skin settings"));

        gtk_widget_set_name(check_override_skin, "check_on_notebook");
	if (options.override_skin_settings) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_override_skin), TRUE);
	}
	gtk_box_pack_start(GTK_BOX(vbox_appearance), check_override_skin, FALSE, FALSE, 0);
	g_signal_connect (G_OBJECT (check_override_skin), "toggled",
						G_CALLBACK (cb_toggle_override_skin), NULL);

	frame_fonts = gtk_frame_new(_("Fonts"));
	gtk_box_pack_start(GTK_BOX(vbox_appearance), frame_fonts, FALSE, TRUE, 5);

	vbox_fonts = gtk_vbox_new(FALSE, 3);
	gtk_container_set_border_width(GTK_CONTAINER(vbox_fonts), 5);
	gtk_container_add(GTK_CONTAINER(frame_fonts), vbox_fonts);

        /* playlist font */

	hbox = gtk_hbox_new(FALSE, 5);
        gtk_box_pack_start(GTK_BOX(vbox_fonts), hbox, FALSE, FALSE, 0);

	label = gtk_label_new(_("Playlist: "));
        gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 5);
        gtk_size_group_add_widget(label_size, label);
        gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);

        entry_pl_font = gtk_entry_new();
        GTK_WIDGET_UNSET_FLAGS(entry_pl_font, GTK_CAN_FOCUS);
        gtk_box_pack_start(GTK_BOX(hbox), entry_pl_font, TRUE, TRUE, 0);
        gtk_editable_set_editable(GTK_EDITABLE(entry_pl_font), FALSE);

        if (strlen(options.playlist_font)) {
		gtk_entry_set_text(GTK_ENTRY(entry_pl_font), options.playlist_font);
        } else {
                gtk_entry_set_text(GTK_ENTRY(entry_pl_font), DEFAULT_FONT_NAME);
                strcpy(options.playlist_font, DEFAULT_FONT_NAME);
        }

        button_pl_font =  gui_stock_label_button(_("Select"), GTK_STOCK_SELECT_FONT);
        gtk_box_pack_start(GTK_BOX(hbox), button_pl_font, FALSE, FALSE, 0);
	g_signal_connect (G_OBJECT (button_pl_font), "clicked",
						G_CALLBACK (playlist_font_select), NULL);

        /* music store font */

	hbox = gtk_hbox_new(FALSE, 5);
        gtk_box_pack_start(GTK_BOX(vbox_fonts), hbox, FALSE, TRUE, 0);

	label = gtk_label_new(_("Music Store: "));
        gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 5);
        gtk_size_group_add_widget(label_size, label);
        gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);

        entry_ms_font = gtk_entry_new();
        GTK_WIDGET_UNSET_FLAGS(entry_ms_font, GTK_CAN_FOCUS);
        gtk_box_pack_start(GTK_BOX(hbox), entry_ms_font, TRUE, TRUE, 0);
        gtk_editable_set_editable(GTK_EDITABLE(entry_ms_font), FALSE);

        if (strlen(options.browser_font)) {

	        gtk_entry_set_text(GTK_ENTRY(entry_ms_font), options.browser_font);

        } else {

                gtk_entry_set_text(GTK_ENTRY(entry_ms_font), DEFAULT_FONT_NAME);
                strcpy(options.browser_font, DEFAULT_FONT_NAME);

        }

        button_ms_font = gui_stock_label_button(_("Select"), GTK_STOCK_SELECT_FONT);
        gtk_box_pack_start(GTK_BOX(hbox), button_ms_font, FALSE, FALSE, 0);
	g_signal_connect (G_OBJECT (button_ms_font), "clicked",
						G_CALLBACK (browser_font_select), NULL);


        /* big timer font */

	hbox = gtk_hbox_new(FALSE, 5);
        gtk_box_pack_start(GTK_BOX(vbox_fonts), hbox, FALSE, TRUE, 0);

	label = gtk_label_new(_("Big timer: "));
        gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 5);
        gtk_size_group_add_widget(label_size, label);
        gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);

        entry_bt_font = gtk_entry_new();
        GTK_WIDGET_UNSET_FLAGS(entry_bt_font, GTK_CAN_FOCUS);
        gtk_box_pack_start(GTK_BOX(hbox), entry_bt_font, TRUE, TRUE, 0);
        gtk_editable_set_editable(GTK_EDITABLE(entry_bt_font), FALSE);

        if (strlen(options.bigtimer_font)) {

	        gtk_entry_set_text(GTK_ENTRY(entry_bt_font), options.bigtimer_font);

        } else {

                gtk_entry_set_text(GTK_ENTRY(entry_bt_font), DEFAULT_FONT_NAME);
                strcpy(options.bigtimer_font, DEFAULT_FONT_NAME);

        }

        button_bt_font = gui_stock_label_button(_("Select"), GTK_STOCK_SELECT_FONT);
        gtk_box_pack_start(GTK_BOX(hbox), button_bt_font, FALSE, FALSE, 0);
	g_signal_connect (G_OBJECT (button_bt_font), "clicked",
						G_CALLBACK (bigtimer_font_select), NULL);

        /* small timer font */

	hbox = gtk_hbox_new(FALSE, 5);
        gtk_box_pack_start(GTK_BOX(vbox_fonts), hbox, FALSE, TRUE, 0);

	label = gtk_label_new(_("Small timers: "));
        gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 5);
        gtk_size_group_add_widget(label_size, label);
        gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);

        entry_st_font = gtk_entry_new();
        GTK_WIDGET_UNSET_FLAGS(entry_st_font, GTK_CAN_FOCUS);
        gtk_box_pack_start(GTK_BOX(hbox), entry_st_font, TRUE, TRUE, 0);
        gtk_editable_set_editable(GTK_EDITABLE(entry_st_font), FALSE);

        if (strlen(options.smalltimer_font)) {

	        gtk_entry_set_text(GTK_ENTRY(entry_st_font), options.smalltimer_font);

        } else {

                gtk_entry_set_text(GTK_ENTRY(entry_st_font), DEFAULT_FONT_NAME);
                strcpy(options.smalltimer_font, DEFAULT_FONT_NAME);

        }

        button_st_font = gui_stock_label_button(_("Select"), GTK_STOCK_SELECT_FONT);
        gtk_box_pack_start(GTK_BOX(hbox), button_st_font, FALSE, FALSE, 0);
	g_signal_connect (G_OBJECT (button_st_font), "clicked",
						G_CALLBACK (smalltimer_font_select), NULL);

        /* song title font */

	hbox = gtk_hbox_new(FALSE, 5);
        gtk_box_pack_start(GTK_BOX(vbox_fonts), hbox, FALSE, TRUE, 0);

	label = gtk_label_new(_("Song title: "));
        gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 5);
        gtk_size_group_add_widget(label_size, label);
        gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);

        entry_songt_font = gtk_entry_new();
        GTK_WIDGET_UNSET_FLAGS(entry_songt_font, GTK_CAN_FOCUS);
        gtk_box_pack_start(GTK_BOX(hbox), entry_songt_font, TRUE, TRUE, 0);
        gtk_editable_set_editable(GTK_EDITABLE(entry_songt_font), FALSE);

        if (strlen(options.songtitle_font)) {

	        gtk_entry_set_text(GTK_ENTRY(entry_songt_font), options.songtitle_font);

        } else {

                gtk_entry_set_text(GTK_ENTRY(entry_songt_font), DEFAULT_FONT_NAME);
                strcpy(options.songtitle_font, DEFAULT_FONT_NAME);

        }

        button_songt_font = gui_stock_label_button(_("Select"), GTK_STOCK_SELECT_FONT);
        gtk_box_pack_start(GTK_BOX(hbox), button_songt_font, FALSE, FALSE, 0);
	g_signal_connect (G_OBJECT (button_songt_font), "clicked",
						G_CALLBACK (songtitle_font_select), NULL);

        /* song info font */

	hbox = gtk_hbox_new(FALSE, 5);
        gtk_box_pack_start(GTK_BOX(vbox_fonts), hbox, FALSE, TRUE, 0);

	label = gtk_label_new(_("Song info: "));
        gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 5);
        gtk_size_group_add_widget(label_size, label);
        gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);

        entry_si_font = gtk_entry_new();
        GTK_WIDGET_UNSET_FLAGS(entry_si_font, GTK_CAN_FOCUS);
        gtk_box_pack_start(GTK_BOX(hbox), entry_si_font, TRUE, TRUE, 0);
        gtk_editable_set_editable(GTK_EDITABLE(entry_si_font), FALSE);

        if (strlen(options.songinfo_font)) {

	        gtk_entry_set_text(GTK_ENTRY(entry_si_font), options.songinfo_font);

        } else {

                gtk_entry_set_text(GTK_ENTRY(entry_si_font), DEFAULT_FONT_NAME);
                strcpy(options.songinfo_font, DEFAULT_FONT_NAME);

        }

        button_si_font = gui_stock_label_button(_("Select"), GTK_STOCK_SELECT_FONT);
        gtk_box_pack_start(GTK_BOX(hbox), button_si_font, FALSE, FALSE, 0);
	g_signal_connect (G_OBJECT (button_si_font), "clicked",
						G_CALLBACK (songinfo_font_select), NULL);

        /* statusbar font */

	hbox = gtk_hbox_new(FALSE, 5);
        gtk_box_pack_start(GTK_BOX(vbox_fonts), hbox, FALSE, TRUE, 0);

	label = gtk_label_new(_("Statusbar: "));
        gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 5);
        gtk_size_group_add_widget(label_size, label);
        gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);

        entry_sb_font = gtk_entry_new();
        GTK_WIDGET_UNSET_FLAGS(entry_sb_font, GTK_CAN_FOCUS);
        gtk_box_pack_start(GTK_BOX(hbox), entry_sb_font, TRUE, TRUE, 0);
        gtk_editable_set_editable(GTK_EDITABLE(entry_sb_font), FALSE);

        if (strlen(options.statusbar_font)) {

	        gtk_entry_set_text(GTK_ENTRY(entry_sb_font), options.statusbar_font);

        } else {

                gtk_entry_set_text(GTK_ENTRY(entry_sb_font), DEFAULT_FONT_NAME);
                strcpy(options.statusbar_font, DEFAULT_FONT_NAME);

        }

        button_sb_font = gui_stock_label_button(_("Select"), GTK_STOCK_SELECT_FONT);
        gtk_box_pack_start(GTK_BOX(hbox), button_sb_font, FALSE, FALSE, 0);
	g_signal_connect (G_OBJECT (button_sb_font), "clicked",
						G_CALLBACK (statusbar_font_select), NULL);

        /* colors */

	frame_colors = gtk_frame_new(_("Colors"));
	gtk_box_pack_start(GTK_BOX(vbox_appearance), frame_colors, FALSE, TRUE, 5);

	vbox_colors = gtk_vbox_new(FALSE, 3);
	gtk_container_set_border_width(GTK_CONTAINER(vbox_colors), 5);
	gtk_container_add(GTK_CONTAINER(frame_colors), vbox_colors);

        /* active song */

	hbox = gtk_hbox_new(FALSE, 5);
        gtk_box_pack_start(GTK_BOX(vbox_colors), hbox, FALSE, TRUE, 0);

	label = gtk_label_new(_("Active song in playlist: "));
        gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 5);
        gtk_size_group_add_widget(label_size, label);
        gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);

	hbox_s = gtk_hbox_new(FALSE, 0);
        gtk_box_pack_start(GTK_BOX(hbox), hbox_s, TRUE, TRUE, 0);

        if (gdk_color_parse(options.activesong_color, &color) == FALSE) {

                color.red = play_list->style->fg[SELECTED].red; 
                color.green = play_list->style->fg[SELECTED].green; 
                color.blue = play_list->style->fg[SELECTED].blue; 
                color.pixel = (gulong)((color.red & 0xff00)*256 + (color.green & 0xff00) + (color.blue & 0xff00)/256); 
        }

        color_picker = gtk_color_button_new_with_color (&color);
        gtk_widget_set_size_request(GTK_WIDGET(color_picker), 60, -1);
        gtk_box_pack_start(GTK_BOX(hbox), color_picker, FALSE, TRUE, 0);
	g_signal_connect (G_OBJECT (color_picker), "color-set",
						G_CALLBACK (color_selected), NULL);


        set_sensitive_part();

        /* end of notebook */

	gtk_widget_show_all(options_window);
        gtk_notebook_set_current_page(GTK_NOTEBOOK(notebook), current_notebook_page);

	if (aqualung_dialog_run(GTK_DIALOG(options_window)) == GTK_RESPONSE_ACCEPT) {
		options_window_accept();

		if (reskin_flag) {
			change_skin(options.skin);
		}
	} else {
		gtk_widget_destroy(options_window);
	}
}


#define SAVE_STR(Var) \
        xmlNewTextChild(root, NULL, (const xmlChar *) #Var, (xmlChar *) options.Var);

#define SAVE_FONT(Font) \
	snprintf(str, MAX_FONTNAME_LEN, "%s", options.Font); \
        xmlNewTextChild(root, NULL, (const xmlChar *) #Font, (xmlChar *) str);

#define SAVE_COLOR(Color) \
	snprintf(str, MAX_COLORNAME_LEN, "%s", options.Color); \
        xmlNewTextChild(root, NULL, (const xmlChar *) #Color, (xmlChar *) str);

#define SAVE_INT(Var) \
	snprintf(str, 31, "%d", options.Var); \
        xmlNewTextChild(root, NULL, (const xmlChar *) #Var, (xmlChar *) str);

#define SAVE_INT_ARRAY(Var, Idx) \
        snprintf(str, 31, "%d", options.Var[Idx]); \
        xmlNewTextChild(root, NULL, (const xmlChar *) #Var "_" #Idx, (xmlChar *) str);

#define SAVE_INT_SH(Var) \
	snprintf(str, 31, "%d", options.Var##_shadow); \
        xmlNewTextChild(root, NULL, (const xmlChar *) #Var, (xmlChar *) str);

#define SAVE_FLOAT(Var) \
        snprintf(str, 31, "%f", options.Var); \
        xmlNewTextChild(root, NULL, (const xmlChar *) #Var, (xmlChar *) str);


void
save_config(void) {

        xmlDocPtr doc;
        xmlNodePtr root;
        int c, d;
        FILE * fin;
        FILE * fout;
        char tmpname[MAXLEN];
        char config_file[MAXLEN];
	char str[32];

	GtkTreeIter iter;
	int i = 0;
	char * path;

        sprintf(config_file, "%s/config.xml", options.confdir);

        doc = xmlNewDoc((const xmlChar *) "1.0");
        root = xmlNewNode(NULL, (const xmlChar *) "aqualung_config");
        xmlDocSetRootElement(doc, root);


	SAVE_STR(currdir);
	SAVE_STR(default_param);
	SAVE_STR(title_format);
	SAVE_STR(skin);
	SAVE_INT(src_type);
	SAVE_INT(ladspa_is_postfader);
	SAVE_INT(auto_save_playlist);
	SAVE_INT(show_rva_in_playlist);
	SAVE_INT(pl_statusbar_show_size);
	SAVE_INT(ms_statusbar_show_size);
	SAVE_INT(show_length_in_playlist);
	SAVE_INT(show_active_track_name_in_bold);
	SAVE_INT(enable_pl_rules_hint);
	SAVE_INT(enable_ms_rules_hint);
	SAVE_INT_SH(enable_ms_tree_icons);
	SAVE_INT(auto_use_meta_artist);
	SAVE_INT(auto_use_meta_record);
	SAVE_INT(auto_use_meta_track);
	SAVE_INT(auto_use_ext_meta_artist);
	SAVE_INT(auto_use_ext_meta_record);
	SAVE_INT(auto_use_ext_meta_track);
	SAVE_INT(enable_tooltips);
	SAVE_INT_SH(buttons_at_the_bottom);
	SAVE_INT(disable_buttons_relief);
	SAVE_INT_SH(simple_view_in_fx);
	SAVE_INT(show_sn_title);
	SAVE_INT(united_minimization);
	SAVE_INT(magnify_smaller_images);
	SAVE_INT(cover_width);
	SAVE_INT_SH(hide_comment_pane);
	SAVE_INT_SH(enable_mstore_toolbar);
	SAVE_INT_SH(enable_mstore_statusbar);
	SAVE_INT(autoexpand_stores);
	SAVE_INT(show_hidden);
	SAVE_INT(main_window_always_on_top);
	SAVE_INT(tags_tab_first);
	SAVE_INT(override_skin_settings);
	SAVE_INT(replaygain_tag_to_use);
	SAVE_FLOAT(vol);
	SAVE_FLOAT(bal);
	SAVE_INT(rva_is_enabled);
	SAVE_INT(rva_env);
	SAVE_FLOAT(rva_refvol);
	SAVE_FLOAT(rva_steepness);
	SAVE_INT(rva_use_averaging);
	SAVE_INT(rva_use_linear_thresh);
	SAVE_FLOAT(rva_avg_linear_thresh);
	SAVE_FLOAT(rva_avg_stddev_thresh);
	SAVE_INT(main_pos_x);
	SAVE_INT(main_pos_y);
	SAVE_INT(main_size_x);

	if (options.playlist_is_embedded && !options.playlist_is_embedded_shadow && options.playlist_on) {
		snprintf(str, 31, "%d", options.main_size_y - playlist_window->allocation.height - 6);
	} else {
		snprintf(str, 31, "%d", options.main_size_y);
	}
        xmlNewTextChild(root, NULL, (const xmlChar *) "main_size_y", (xmlChar *) str);

	SAVE_INT(browser_pos_x);
	SAVE_INT(browser_pos_y);
	SAVE_INT(browser_size_x);
	SAVE_INT(browser_size_y);
	SAVE_INT(browser_on);
	SAVE_INT(browser_paned_pos);
	SAVE_INT(playlist_pos_x);
	SAVE_INT(playlist_pos_y);
	SAVE_INT(playlist_size_x);
	SAVE_INT(playlist_size_y);
	SAVE_INT(playlist_on);
	SAVE_INT_SH(playlist_is_embedded);
	SAVE_INT(playlist_is_tree);
	SAVE_INT(album_shuffle_mode);
	SAVE_INT_SH(enable_playlist_statusbar);
	SAVE_FONT(browser_font);
	SAVE_FONT(playlist_font);
	SAVE_FONT(bigtimer_font);
	SAVE_FONT(smalltimer_font);
	SAVE_FONT(songtitle_font);
	SAVE_FONT(songinfo_font);
	SAVE_FONT(statusbar_font);
	SAVE_COLOR(activesong_color);
	SAVE_INT(repeat_on);
	SAVE_INT(repeat_all_on);
	SAVE_INT(shuffle_on);
	SAVE_INT_ARRAY(time_idx, 0);
	SAVE_INT_ARRAY(time_idx, 1);
	SAVE_INT_ARRAY(time_idx, 2);
	SAVE_INT_ARRAY(plcol_idx, 0);
	SAVE_INT_ARRAY(plcol_idx, 1);
	SAVE_INT_ARRAY(plcol_idx, 2);
	SAVE_INT(search_pl_flags);
	SAVE_INT(search_ms_flags);
	SAVE_INT(cdda_drive_speed);
	SAVE_INT(cdda_paranoia_mode);
	SAVE_INT(cdda_paranoia_maxretries);
	SAVE_INT(cdda_force_drive_rescan);
	SAVE_INT(cdda_add_to_playlist);
	SAVE_INT(cdda_remove_from_playlist);
	SAVE_STR(cddb_server);
	SAVE_INT(cddb_timeout);
	SAVE_STR(cddb_email);
	SAVE_STR(cddb_local);
	SAVE_INT(cddb_cache_only);
	SAVE_INT(cddb_use_http);
	SAVE_INT(cddb_use_proxy);
	SAVE_STR(cddb_proxy);
	SAVE_INT(cddb_proxy_port);
	SAVE_FLOAT(loop_range_start);
	SAVE_FLOAT(loop_range_end);

	i = 0;
	while (gtk_tree_model_iter_nth_child(GTK_TREE_MODEL(ms_pathlist_store), &iter, NULL, i++)) {
		char * utf8;
		gtk_tree_model_get(GTK_TREE_MODEL(ms_pathlist_store), &iter, 0, &path, -1);
		utf8 = g_locale_to_utf8(path, -1, NULL, NULL, NULL);
		xmlNewTextChild(root, NULL, (const xmlChar *) "music_store", (xmlChar *) utf8);
		g_free(path);
		g_free(utf8);
	}

	
        sprintf(tmpname, "%s/config.xml.temp", options.confdir);
        xmlSaveFormatFile(tmpname, doc, 1);
	xmlFreeDoc(doc);

        if ((fin = fopen(config_file, "rt")) == NULL) {
                fprintf(stderr, "Error opening file: %s\n", config_file);
                return;
        }
        if ((fout = fopen(tmpname, "rt")) == NULL) {
                fprintf(stderr, "Error opening file: %s\n", tmpname);
                return;
        }

        c = 0; d = 0;
        while (((c = fgetc(fin)) != EOF) && ((d = fgetc(fout)) != EOF)) {
                if (c != d) {
                        fclose(fin);
                        fclose(fout);
                        unlink(config_file);
                        rename(tmpname, config_file);
                        return;
                }
        }

        fclose(fin);
        fclose(fout);
        unlink(tmpname);
}


#define LOAD_STR(Var) \
                if ((!xmlStrcmp(cur->name, (const xmlChar *) #Var))) { \
			key = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1); \
                        if (key != NULL) \
                                strncpy(options.Var, (char *) key, MAXLEN-1); \
                        xmlFree(key); \
                }

#define LOAD_FONT(Font) \
                if ((!xmlStrcmp(cur->name, (const xmlChar *)#Font))) { \
			key = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1); \
                        if (key != NULL) \
                                strncpy(options.Font, (char *) key, MAX_FONTNAME_LEN-1); \
                        xmlFree(key); \
                }

#define LOAD_COLOR(Color) \
                if ((!xmlStrcmp(cur->name, (const xmlChar *) #Color))) { \
			key = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1); \
                        if (key != NULL) \
                                strncpy(options.Color, (char *) key, MAX_COLORNAME_LEN-1); \
                        xmlFree(key); \
                }

#define LOAD_INT(Var) \
                if ((!xmlStrcmp(cur->name, (const xmlChar *) #Var))) { \
			key = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1); \
                        if (key != NULL) \
				sscanf((char *) key, "%d", &options.Var); \
                        xmlFree(key); \
                }

#define LOAD_INT_ARRAY(Var, Idx) \
                if ((!xmlStrcmp(cur->name, (const xmlChar *) #Var "_" #Idx))) { \
			key = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1); \
                        if (key != NULL) \
				sscanf((char *) key, "%d", options.Var + Idx); \
                        xmlFree(key); \
                }

#define LOAD_INT_SH(Var) \
                if ((!xmlStrcmp(cur->name, (const xmlChar *) #Var))) { \
			key = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1); \
                        if (key != NULL) { \
				sscanf((char *) key, "%d", &options.Var); \
				options.Var##_shadow = options.Var; \
			} \
                        xmlFree(key); \
                }

#define LOAD_FLOAT(Var) \
                if ((!xmlStrcmp(cur->name, (const xmlChar *) #Var))) { \
			key = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1); \
                        if (key != NULL) { \
				options.Var = convf((char *) key); \
			} \
                        xmlFree(key); \
                }


void
load_config(void) {

        xmlDocPtr doc;
        xmlNodePtr cur;
        xmlNodePtr root;
	xmlChar * key;
        char config_file[MAXLEN];
        FILE * f;


        sprintf(config_file, "%s/config.xml", options.confdir);

        if ((f = fopen(config_file, "rt")) == NULL) {
		/* no warning -- done that in core.c::load_default_cl() */
                doc = xmlNewDoc((const xmlChar *) "1.0");
                root = xmlNewNode(NULL, (const xmlChar *) "aqualung_config");
                xmlDocSetRootElement(doc, root);
                xmlSaveFormatFile(config_file, doc, 1);
		xmlFreeDoc(doc);
                return;
        }
        fclose(f);

        doc = xmlParseFile(config_file);
        if (doc == NULL) {
                fprintf(stderr, "An XML error occured while parsing %s\n", config_file);
                return;
        }

        cur = xmlDocGetRootElement(doc);
        if (cur == NULL) {
                fprintf(stderr, "load_config: empty XML document\n");
                xmlFreeDoc(doc);
                return;
        }

        if (xmlStrcmp(cur->name, (const xmlChar *)"aqualung_config")) {
                fprintf(stderr, "load_config: XML document of the wrong type, "
			"root node != aqualung_config\n");
                xmlFreeDoc(doc);
                return;
        }


	options.src_type = 4;
	options.vol = 0.0f;
	options.bal = 0.0f;

	options.repeat_on = 0;
	options.repeat_all_on = 0;
	options.shuffle_on = 0;

	options.loop_range_start = 0.0f;
	options.loop_range_end = 1.0f;

	options.search_pl_flags = 0;
	options.search_ms_flags = SEARCH_F_AN | SEARCH_F_RT | SEARCH_F_TT | SEARCH_F_CO;

	options.browser_paned_pos = 400;

	options.skin[0] = '\0';

	options.default_param[0] = '\0';
	options.title_format[0] = '\0';
        options.enable_tooltips = 1;
        options.show_sn_title = 1;
        options.united_minimization = 1;
        options.buttons_at_the_bottom = options.buttons_at_the_bottom_shadow = 0;
	options.playlist_is_embedded = options.playlist_is_embedded_shadow = 1;
	options.playlist_is_tree = 1;

	options.enable_mstore_statusbar = options.enable_mstore_statusbar_shadow = 1;
       	options.enable_mstore_toolbar = options.enable_mstore_toolbar_shadow = 1;
        options.enable_ms_tree_icons = options.enable_ms_tree_icons_shadow = 1;
	options.ms_statusbar_show_size = 1;

        options.cover_width = 2;

	options.autoexpand_stores = 1;

	options.auto_save_playlist = 1;
	options.show_length_in_playlist = 1;
	options.enable_playlist_statusbar = options.enable_playlist_statusbar_shadow = 1;
	options.pl_statusbar_show_size = 1;

	options.rva_refvol = -12.0f;
	options.rva_steepness = 1.0f;
	options.rva_use_averaging = 1;
	options.rva_use_linear_thresh = 0;
	options.rva_avg_linear_thresh = 3.0f;
	options.rva_avg_stddev_thresh = 2.0f;

	options.auto_use_ext_meta_artist = 1;
	options.auto_use_ext_meta_record = 1;
	options.auto_use_ext_meta_track = 1;

	options.cdda_drive_speed = 4;
	options.cdda_paranoia_mode = 0; /* no paranoia */
	options.cdda_paranoia_maxretries = 20;
	options.cdda_force_drive_rescan = 0;

	options.cddb_server[0] = '\0';
	options.cddb_email[0] = '\0';
	options.cddb_local[0] = '\0';
	options.cddb_proxy[0] = '\0';
	options.cddb_timeout = 10;

	options.time_idx[0] = 0;
	options.time_idx[1] = 1;
	options.time_idx[2] = 2;

	options.plcol_idx[0] = 0;
	options.plcol_idx[1] = 1;
	options.plcol_idx[2] = 2;

	ms_pathlist_store = gtk_list_store_new(3,
					       G_TYPE_STRING,   /* path */
					       G_TYPE_STRING,   /* displayed name */
					       G_TYPE_STRING);  /* state (rw, r, unreachable) */

        cur = cur->xmlChildrenNode;
        while (cur != NULL) {
		LOAD_STR(currdir);
		LOAD_STR(default_param);
		LOAD_STR(title_format);
		LOAD_STR(skin);

		if (!src_type_parsed) {
			LOAD_INT(src_type)
		}

		LOAD_INT(ladspa_is_postfader);
		LOAD_INT(auto_save_playlist);
		LOAD_INT(auto_use_meta_artist);
		LOAD_INT(auto_use_meta_record);
		LOAD_INT(auto_use_meta_track);
		LOAD_INT(auto_use_ext_meta_artist);
		LOAD_INT(auto_use_ext_meta_record);
		LOAD_INT(auto_use_ext_meta_track);
		LOAD_INT(show_rva_in_playlist);
		LOAD_INT(pl_statusbar_show_size);
		LOAD_INT(ms_statusbar_show_size);
		LOAD_INT(show_length_in_playlist);
		LOAD_INT(show_active_track_name_in_bold);
		LOAD_INT(enable_pl_rules_hint);
		LOAD_INT(enable_ms_rules_hint);
		LOAD_INT_SH(enable_ms_tree_icons);
		LOAD_INT(enable_tooltips);
		LOAD_INT_SH(buttons_at_the_bottom);
		LOAD_INT(disable_buttons_relief);
		LOAD_INT_SH(simple_view_in_fx);
		LOAD_INT(show_sn_title);
		LOAD_INT(united_minimization);
		LOAD_INT(magnify_smaller_images);
		LOAD_INT(cover_width);
		LOAD_INT_SH(hide_comment_pane);
		LOAD_INT_SH(enable_mstore_toolbar);
		LOAD_INT_SH(enable_mstore_statusbar);
		LOAD_INT(autoexpand_stores);
		LOAD_INT(show_hidden);
		LOAD_INT(main_window_always_on_top);
		LOAD_INT(tags_tab_first);
		LOAD_INT(override_skin_settings);
		LOAD_INT(replaygain_tag_to_use);
		LOAD_FLOAT(vol);
		LOAD_FLOAT(bal);
		LOAD_INT(rva_is_enabled);
		LOAD_INT(rva_env);
		LOAD_FLOAT(rva_refvol);
		LOAD_FLOAT(rva_steepness);
		LOAD_INT(rva_use_averaging);
		LOAD_INT(rva_use_linear_thresh);
		LOAD_FLOAT(rva_avg_linear_thresh);
		LOAD_FLOAT(rva_avg_stddev_thresh);
		LOAD_INT(main_pos_x);
		LOAD_INT(main_pos_y);
		LOAD_INT(main_size_x);
		LOAD_INT(main_size_y);
		LOAD_INT(browser_pos_x);
		LOAD_INT(browser_pos_y);
		LOAD_INT(browser_size_x);
		LOAD_INT(browser_size_y);
		LOAD_INT(browser_on);
		LOAD_INT(browser_paned_pos);
		LOAD_INT(playlist_pos_x);
		LOAD_INT(playlist_pos_y);
		LOAD_INT(playlist_size_x);
		LOAD_INT(playlist_size_y);
		LOAD_INT(playlist_on);
		LOAD_INT_SH(playlist_is_embedded);
		LOAD_INT(playlist_is_tree);
		LOAD_INT(album_shuffle_mode);
		LOAD_INT_SH(enable_playlist_statusbar);
		LOAD_FONT(browser_font);
		LOAD_FONT(playlist_font);
		LOAD_FONT(bigtimer_font);
		LOAD_FONT(smalltimer_font);
		LOAD_FONT(songtitle_font);
		LOAD_FONT(songinfo_font);
		LOAD_FONT(statusbar_font);
		LOAD_COLOR(activesong_color);
		LOAD_INT(repeat_on);
		LOAD_INT(repeat_all_on);
		LOAD_INT(shuffle_on);
		LOAD_INT_ARRAY(time_idx, 0);
		LOAD_INT_ARRAY(time_idx, 1);
		LOAD_INT_ARRAY(time_idx, 2);
		LOAD_INT_ARRAY(plcol_idx, 0);
		LOAD_INT_ARRAY(plcol_idx, 1);
		LOAD_INT_ARRAY(plcol_idx, 2);
		LOAD_INT(search_pl_flags);
		LOAD_INT(search_ms_flags);
		LOAD_INT(cdda_drive_speed);
		LOAD_INT(cdda_paranoia_mode);
		LOAD_INT(cdda_paranoia_maxretries);
		LOAD_INT(cdda_force_drive_rescan);
		LOAD_INT(cdda_add_to_playlist);
		LOAD_INT(cdda_remove_from_playlist);
		LOAD_STR(cddb_server);
		LOAD_INT(cddb_timeout);
		LOAD_STR(cddb_email);
		LOAD_STR(cddb_local);
		LOAD_INT(cddb_cache_only);
		LOAD_INT(cddb_use_http);
		LOAD_STR(cddb_proxy);
		LOAD_INT(cddb_proxy_port);
		LOAD_INT(cddb_use_proxy);
		LOAD_FLOAT(loop_range_start);
		LOAD_FLOAT(loop_range_end);

                if ((!xmlStrcmp(cur->name, (const xmlChar *)"music_store"))) {
			key = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
                        if (key != NULL) {

				char path[MAXLEN];
				char * ppath;

				snprintf(path, MAXLEN - 1, "%s", (char *)key);
				ppath = g_locale_from_utf8(path, -1, NULL, NULL, NULL);

				append_ms_pathlist(ppath, path);

				g_free(ppath);
			}

                        xmlFree(key);
		}
                cur = cur->next;
        }

        xmlFreeDoc(doc);
        return;
}

// vim: shiftwidth=8:tabstop=8:softtabstop=8 :  

