# -*- coding: utf-8 -*-
# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation; either version 2 of the License, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
# details.
#
# You should have received a copy of the GNU General Public License along with
# this program; if not, write to the Free Software Foundation, Inc., 59 Temple
# Place, Suite 330, Boston, MA 02111-1307 USA

import os
import gtk
import utils
import constants
from APTonCD.core import gui
from APTonCD.core import *

class SynapticManager(controller.IController):

    def __init__(self, selectionsfile=None, sourceslist='aptoncd.list', controller = None):
        """ Call Synaptic with different configuration options """
        self.controller = controller
        parentwd = self.controller.get_main_window()
        winid = parentwd.window.xid
        desktopfile = constants.DESKTOP_FILE
        self.sourceslist= sourceslist
        if utils.fileExist(desktopfile):
        	self.manager = ["/usr/bin/gksu", "gksu", "--desktop",
            	            desktopfile, "--",
                	        "/usr/sbin/synaptic", "--hide-main-window", "--non-interactive", "--parent-window-id", "%s" % (winid), ]
        else:
        	self.manager = ["/usr/bin/gksu", "--", "/usr/sbin/synaptic", "--hide-main-window", "--non-interactive", "--parent-window-id", "%s" % (winid) ]
        	#'--parent-window-id", "%s" % (id)
        #print self.manager
             
    def update(self):
        """ Get the last packages list from repositories
        """
        self.manager.append("--update-at-startup")
        self.manager.append("&")
        #print self.manager
        process = os.popen(" ".join(self.manager), "w")
        process.close()

    def download(self, selectionsfile = None):
        """ Download packages for the apt cache
        """
        self.manager.append("-o=Volatile::Download-Only=true")
        self.manager.append("-o=Volatile::SetSelectionDoReInstall=true")
        self.manager.append("--set-selections-file")
        self.manager.append(selectionsfile)
        self.manager.append("&")
        #print self.manager
        process = os.popen(" ".join(self.manager), "w")
        process.close()
        
    def addMedia(self):
        """ Add a media as APT source
        """
        sourcesdir = "/etc/apt/sources.list.d/"
        if not utils.pathExists(sourcesdir):
        	utils.mkdir(sourcesdir)
        self.manager.append("-o=dir::etc=" + sourcesdir)
        self.manager.append("-o=dir::etc::sourcelist="+ self.sourceslist)
        self.manager.append("--ask-cdrom")
        self.manager.append("&")
        #print self.manager
        process = os.popen(" ".join(self.manager), "w")
        process.close()

#synaptic = SynapticManager(selectionsfile='/tmp/pacotes.txt')
#synaptic.update()
#synaptic.download(selectionsfile)
#synaptic.addMedia()
