#!/usr/bin/perl

use strict;
use warnings;

use FindBin qw($Bin);
use lib "$Bin/../lib";

require('apt-cacher.pl');

our $cfg = read_config('/etc/apt-cacher/apt-cacher.conf');

private_config();

my %h;

extract_sums($_, undef, \%h) foreach @ARGV;

exit;
print "$_\n" foreach keys %h;
exit;


foreach my $file (keys %h) {
    print "$file:\n";
    my $href = hashify(\$h{$file});
    foreach (keys %$href) {
	print " $_: $href->{$_}\n" if $href->{$_};
    }
}
