#!/usr/bin/perl -w
#	@(#) setup.pl -- Setup script for apt-cacher.pl
#	$ Revision: $
#	$ Source: $
#	$ Date: $
#
#	Safe to run multiple times; later versions of this script will
#	remove obsolete directories or files and not touch required
#	directories or files.
#

umask 0022;

#############################################################################
### configuration ###########################################################
# Include the library for the config file parser
require '/usr/share/apt-cacher/apt-cacher-lib.pl';

# Read in the config file and set the necessary variables
my $configfile = '/etc/apt-cacher/apt-cacher.conf';

my $configref;
eval {
        $configref = read_config($configfile);
};
my %config = %$configref;

# not sure what to do if we can't read the config file...
die "Could not read config file: $@" if $@;

# Now set some things from the config file
# $logfile used to be set in the config file: now we derive it from $logdir
$config{logfile} = "$config{logdir}/access.log";

# $errorfile used to be set in the config file: now we derive it from $logdir
$config{errorfile} = "$config{logdir}/error.log";

my $private_dir = "$config{cache_dir}/private";

################################################
# Check that the cache_dir has been set and continue on (note: this should never happen
# because cache_dir is preset to a default value prior to loading the config file)
die "Warning: config file could not be parsed ($configfile)/ (cache_dir is not set)\n" if ($config{cache_dir} eq '');


@info=getpwnam("www-data");
my @permcmd;
if(-e $config{cache_dir}) {
   @permcmd = ("chown", "--reference", $config{cache_dir});
}
elsif(@info) {
   print "Assuming www-data is the user ID used to run apt-cacher\n";
   @permcmd = ("chown", "$info[2]:$info[3]");
}
else {
   @permcmd = ("/bin/echo", "User account for apt-cacher/http daemon unknown, plese set ownership for the following files manually:");
}

for ("README", "README.txt") {
   my $file=$config{cache_dir}."/$_";
   if (-f $file) {
      print "Found obsolete file $file - removing.\n";
      unlink($file);
   }
}

foreach my $dir ($config{cache_dir}, $config{logdir}, "$config{cache_dir}/private", "$config{cache_dir}/import", "$config{cache_dir}/packages", "$config{cache_dir}/headers") {
	if (!-d $dir) {
		print "Doing mkdir($dir, 0755)\n";
		mkdir($dir, 0755);
    system (@permcmd, $dir);
	}
	if (!-w $dir) {
		die "Warning, $dir exists but is not is not writeable for apt-cacher!\n";
	}
}

# Remove these directories if they exist (obsolete)
foreach my $rmdir ("$config{cache_dir}/tmp", "$config{cache_dir}/head") {
	if (-d $rmdir) {
		print "Doing 'rm -rf $rmdir' (obsolete)\n";
		system("rm -rf $rmdir");
	}
}

# At the moment we need to create empty access and error logs so apt-cacher
# doesn't barf the first time it's run. Probably should change apt-cacher
# so it can handle missing logs, and create them itself if required.
for $file ($config{logfile}, $config{errorfile}) {
   if(!-e $file) {
      open(my $tmp, ">$file");
      close($tmp);
      system @permcmd, $file;
   }
}

# These ownership changes are a cludge: need to make them check httpd.conf for the Apache
# user and set ownership to that, and do it with Perl instead of shell
# EB: fsck that, this may simply overwritte changes by the admin
# `chown -R www-data.www-data $config{cache_dir}`;

# We used to tack a line onto the end of apache.conf. Now we just symlink into conf.d
if(-d "/etc/apache/conf.d" ){
	symlink("/etc/apt-cacher/apache.conf","/etc/apache/conf.d/apt-cacher");
}

if(-d "/etc/apache-ssl/conf.d" ){
	symlink("/etc/apt-cacher/apache.conf","/etc/apache-ssl/conf.d/apt-cacher");
}

if(-d "/etc/apache2/conf.d" ){
	rename("/etc/apache2/conf.d/apt-cacher", "/etc/apache2/conf.d/apt-cacher.conf") || symlink("/etc/apt-cacher/apache.conf","/etc/apache2/conf.d/apt-cacher.conf");
}

# Apache2 needs the cgi module installed, which it isn't by default.
if(-d "/etc/apache2/mods-enabled"){
	symlink("/etc/apache2/mods-available/cgi.load","/etc/apache2/mods-enabled/cgi.load");
}


#vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
# Just for now we still have to try nuking old entries in httpd.conf,
# because they may have been left behind previously. After a couple
# more releases this should be removed from here and remove.pl

# Remove the include lines from Apache's httpd.conf
my $httpdconf = "/etc/apache/httpd.conf";
if (-f $httpdconf) {
	$old = $httpdconf;
	$new = "$httpdconf.tmp.$$";
	$bak = "$httpdconf.bak";
	
	open(OLD, "< $old")         or die "can't open $old: $!";
	open(NEW, "> $new")         or die "can't open $new: $!";
	
	while (<OLD>) {
		s/# This line has been appended by the Apt\-cacher install script/ /;
		s/Include \/etc\/apt\-cacher\/apache.conf/ /;
		(print NEW $_)          or die "can't write to $new: $!";
	}
	
	close(OLD)                  or die "can't close $old: $!";
	close(NEW)                  or die "can't close $new: $!";
	
	rename($old, $bak)          or die "can't rename $old to $bak: $!";
	rename($new, $old)          or die "can't rename $new to $old: $!";
	if (-f "/etc/init.d/apache")
	{
		`/etc/init.d/apache restart`;
	}
}

# Remove the include lines from Apache-SSL's httpd.conf
$httpdconf = "/etc/apache-ssl/httpd.conf";
if (-f $httpdconf) {
	$old = $httpdconf;
	$new = "$httpdconf.tmp.$$";
	$bak = "$httpdconf.bak";
	
	open(OLD, "< $old")         or die "can't open $old: $!";
	open(NEW, "> $new")         or die "can't open $new: $!";
	
	while (<OLD>) {
		s/# This line has been appended by the Apt\-cacher install script/ /;
		s/Include \/etc\/apt\-cacher\/apache.conf/ /;
		(print NEW $_)          or die "can't write to $new: $!";
	}
	
	close(OLD)                  or die "can't close $old: $!";
	close(NEW)                  or die "can't close $new: $!";
	
	rename($old, $bak)          or die "can't rename $old to $bak: $!";
	rename($new, $old)          or die "can't rename $new to $old: $!";
	if (-f "/etc/init.d/apache-ssl")
	{
		`/etc/init.d/apache-ssl restart`;
	}
}

# Remove the include lines from Apache2's apache2.conf
$httpdconf = "/etc/apache2/apache2.conf";
if (-f $httpdconf) {
        $old = $httpdconf;
        $new = "$httpdconf.tmp.$$";
        $bak = "$httpdconf.bak";

        open(OLD, "< $old")         or die "can't open $old: $!";
        open(NEW, "> $new")         or die "can't open $new: $!";

        while (<OLD>) {
                s/# This line has been appended by the Apt\-cacher install script/ /;
                s/Include \/etc\/apt\-cacher\/apache.conf/ /;
                (print NEW $_)          or die "can't write to $new: $!";
        }

        close(OLD)                  or die "can't close $old: $!";
        close(NEW)                  or die "can't close $new: $!";

        rename($old, $bak)          or die "can't rename $old to $bak: $!";
        rename($new, $old)          or die "can't rename $new to $old: $!";
	if (-f "/etc/init.d/apache2")
	{
		`/etc/init.d/apache2 restart`;
	}
}
#^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

exit(0);
