#!/usr/bin/perl -w
#	@(#) remove.pl -- Remove script for apt-cacher
#	$ Revision: $
#	$ Source: $
#	$ Date: $
#

my $path = $ENV{PATH_INFO};
# This is Jons's nasty hacky config file parser, I'm sure there is a nicer way
# to do it, but this works OK until a real Perl person gives me some tips.

# First set things to default values in case items are commented out in the config file
$cache_dir='/var/log/cache/apt-cacher';
$logdir='/var/log/apt-cacher';

# Read in the config file and set the necessary variables
my $configfile = '/etc/apt-cacher/apt-cacher.conf';
chop(@configlines = `cat $configfile`);

foreach $configline (@configlines)
{
	$configline =~ s/#.*$//; 	# kill off all comment lines
	#$configline =~ s/^\s*(.*?)\s*$/$1/; 	# remove leading and trailing whitespace
	$configline =~ s/\s+//; 	# zap all spaces anywhere
	if ( $configline ) {		# this handles a trailing 0 on the last line and also blank lines
		($paraname,$paravalue) = split ("=",$configline);
		if ( !$paravalue ) {
			$paravalue = 0;		# this is the trailing-0-on-last-line handler
		}	
		$$paraname = $paravalue;
	}
}

# Now set some things from the config file
# $logfile used to be set in the config file: now we check if it's explicitly set, otherwise derive it from $logdir
if( !$logfile ) {
	$logfile = "$logdir/access.log";
}
# $errorfile used to be set in the config file: now we check if it's explicitly set, otherwise derive it from $logdir
if( !$errorfile ) {
        $errorfile = "$logdir/error.log";
}
# $errorfile used to be set in the config file: now we check if it's explicitly set, otherwise derive it from $logdir
$reportfile = "$logdir/report.html";

# Check that the cache_dir has been set and continue on
die "Warning: config file could not be parsed ($configfile)\n" if ($cache_dir eq '');


# Remove the include lines from Apache's httpd.conf
# This should really be turned into a function so I don't have to
# copy the whole lot for Apache-SSL!
my $httpdconf = "/etc/apache/httpd.conf";
if (-f $httpdconf) {
	$old = $httpdconf;
	$new = "$httpdconf.tmp.$$";
	$bak = "$httpdconf.bak";
	
	open(OLD, "< $old")         or die "can't open $old: $!";
	open(NEW, "> $new")         or die "can't open $new: $!";
	
	while (<OLD>) {
		s/# This line has been appended by the Apt\-cacher install script/ /;
		s/Include \/etc\/apt\-cacher\/apache.conf/ /;
		(print NEW $_)          or die "can't write to $new: $!";
	}
	
	close(OLD)                  or die "can't close $old: $!";
	close(NEW)                  or die "can't close $new: $!";
	
	rename($old, $bak)          or die "can't rename $old to $bak: $!";
	rename($new, $old)          or die "can't rename $new to $old: $!";
	
	# Restart Apache
	if ( -f "/etc/init.d/apache" ) {
		`/etc/init.d/apache restart`;
	} else {
		print "Apache startup script was not found. Please restart Apache manually.\n";
	}
}

# Remove the include lines from Apache-SSL's httpd.conf
# This should really be turned into a function so I don't have to
# copy the whole lot for Apache-SSL!
$httpdconf = "/etc/apache-ssl/httpd.conf";
if (-f $httpdconf) {
	$old = $httpdconf;
	$new = "$httpdconf.tmp.$$";
	$bak = "$httpdconf.bak";
	
	open(OLD, "< $old")         or die "can't open $old: $!";
	open(NEW, "> $new")         or die "can't open $new: $!";
	
	while (<OLD>) {
		s/# This line has been appended by the Apt\-cacher install script/ /;
		s/Include \/etc\/apt\-cacher\/apache.conf/ /;
		(print NEW $_)          or die "can't write to $new: $!";
	}
	
	close(OLD)                  or die "can't close $old: $!";
	close(NEW)                  or die "can't close $new: $!";
	
	rename($old, $bak)          or die "can't rename $old to $bak: $!";
	rename($new, $old)          or die "can't rename $new to $old: $!";
	
	# Restart Apache-SSL
	if ( -f "/etc/init.d/apache-ssl" ) {
		`/etc/init.d/apache-ssl restart`;
	} else {
		print "Apache-SSL startup script was not found. Please restart Apache-SSL manually.\n";
	}
}


# Delete the cache directory and everything in it
system("rm -rf $cache_dir");

# Delete the two log files (leaving the directory behind for now)
unlink($logfile);
unlink($errorfile);
unlink($reportfile);

exit(0);
