/**************************************************************************
 *
 * Copyright 2015 VMware, Inc.
 * All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 **************************************************************************/

/*
 * GUID table.
 *
 * NOTE: Entries must remain sorted, which can be achieved by doing
 *
 *   :'<,'>!sort -k 1.12,1.75 -u
 *
 * on Vim.
 *
 * TODO: Remove duplicate entries.
 */


#ifndef GUID_ENTRY
#error "GUID_ENTRY macro must be defined before including this header"
#endif

#ifndef GUID_DUPLI
#define GUID_DUPLI(l,w1,w2,b1,b2,b3,b4,b5,b6,b7,b8,name)
#endif


GUID_ENTRY(0x00000000,0x0000,0x0000,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x46,IID_IUnknown)
GUID_ENTRY(0x00cddea8,0x939b,0x4b83,0xa3,0x40,0xa6,0x85,0x22,0x66,0x66,0xcc,IID_IDXGIOutput1)
GUID_ENTRY(0x00e48f7b,0xd2c8,0x49e8,0xa8,0x6c,0x02,0x2d,0xee,0x53,0x43,0x1f,IID_ID3D10EffectScalarVariable)
GUID_ENTRY(0x012f0bd6,0xe662,0x4474,0xbe,0xfd,0xaa,0x53,0xe5,0x14,0x3c,0x6d,D3D11_AUTHENTICATED_QUERY_UNRESTRICTED_PROTECTED_SHARED_RESOURCE_COUNT)
GUID_DUPLI(0x012f0bd6,0xe662,0x4474,0xbe,0xfd,0xaa,0x53,0xe5,0x14,0x3c,0x6d,D3DAUTHENTICATEDQUERY_UNRESTRICTEDPROTECTEDSHAREDRESOURCECOUNT)
GUID_ENTRY(0x017c18ac,0x103f,0x4417,0x8c,0x51,0x6b,0xf6,0xef,0x1e,0x56,0xbe,IID_ID3DXBaseEffect)
GUID_ENTRY(0x02177241,0x69fc,0x400c,0x8f,0xf1,0x93,0xa4,0x4d,0xf6,0x86,0x1d,IID_IDirect3D9Ex)
GUID_ENTRY(0x0359dc30,0x95e6,0x4568,0x90,0x55,0x27,0x72,0x0d,0x13,0x0e,0x93,IID_ID2D1AnalysisTransform)
GUID_ENTRY(0x035f3ab4,0x482e,0x4e50,0xb4,0x1f,0x8a,0x7f,0x8b,0xd8,0x96,0x0b,IID_IDXGIResource)
GUID_ENTRY(0x037e866e,0xf56d,0x4357,0xa8,0xaf,0x9d,0xab,0xbe,0x6e,0x25,0x0e,IID_ID3D11Texture3D)
GUID_ENTRY(0x03823efb,0x8d8f,0x4e1c,0x9a,0xa2,0xf6,0x4b,0xb2,0xcb,0xfd,0xf1,IID_ID3D11DepthStencilState)
GUID_ENTRY(0x03916615,0xc644,0x418c,0x9b,0xf4,0x75,0xdb,0x5b,0xe6,0x3c,0xa0,IID_ID3D11RefDefaultTrackingOptions)
GUID_ENTRY(0x0439fc60,0xca44,0x4994,0x8d,0xee,0x3a,0x9a,0xf7,0xb7,0x32,0xec,IID_IDWriteFactory2)
GUID_ENTRY(0x04b0d117,0x1041,0x46b1,0xaa,0x8a,0x39,0x52,0x84,0x8b,0xa2,0x2e,IID_ID3DX10MeshBuffer)
GUID_ENTRY(0x05008617,0xfbfd,0x4051,0xa7,0x90,0x14,0x48,0x84,0xb4,0xf6,0xa9,IID_IDXGIDevice2)
GUID_ENTRY(0x05eec05d,0x8f7d,0x4362,0xb9,0x99,0xd1,0xba,0xf3,0x57,0xc7,0x04,IID_IDirect3DResource9)
GUID_ENTRY(0x06114bdb,0x3523,0x470a,0x8d,0xca,0xfb,0xc2,0x84,0x51,0x54,0xf0,D3D11_AUTHENTICATED_CONFIGURE_INITIALIZE)
GUID_DUPLI(0x06114bdb,0x3523,0x470a,0x8d,0xca,0xfb,0xc2,0x84,0x51,0x54,0xf0,D3DAUTHENTICATEDCONFIGURE_INITIALIZE)
GUID_ENTRY(0x06152247,0x6f50,0x465a,0x92,0x45,0x11,0x8b,0xfd,0x3b,0x60,0x07,IID_ID2D1Factory)
GUID_ENTRY(0x06675a80,0x3b9b,0x11d2,0xb9,0x2f,0x00,0x60,0x97,0x97,0xea,0x5b,IID_IDirectDrawSurface7)
GUID_ENTRY(0x06791122,0xc6f0,0x417d,0x83,0x23,0x26,0x9e,0x98,0x7f,0x59,0x54,IID_IDCompositionTranslateTransform)
GUID_ENTRY(0x06cd6e01,0x4219,0x4ebd,0x87,0x09,0x27,0xed,0x23,0x36,0x0c,0x62,DXGI_DEBUG_APP)
GUID_ENTRY(0x06eab419,0xdeed,0x4018,0x80,0xd2,0x3e,0x1d,0x47,0x1a,0xde,0xb2,CLSID_D2D1Premultiply)
GUID_ENTRY(0x0742a90b,0xc387,0x483f,0xb9,0x46,0x30,0xa7,0xe4,0xe6,0x14,0x58,IID_ID3D12InfoQueue)
GUID_ENTRY(0x0772d047,0x1b40,0x48e8,0x9c,0xa6,0xb5,0xf5,0x10,0xde,0x9f,0x01,D3D11_AUTHENTICATED_CONFIGURE_SHARED_RESOURCE)
GUID_DUPLI(0x0772d047,0x1b40,0x48e8,0x9c,0xa6,0xb5,0xf5,0x10,0xde,0x9f,0x01,D3DAUTHENTICATEDCONFIGURE_SHAREDRESOURCE)
GUID_ENTRY(0x07ddcd52,0x020e,0x4de8,0xac,0x33,0x6c,0x95,0x3d,0x83,0xf9,0x2d,IID_IDWriteTextLayout3)
GUID_ENTRY(0x07f857e7,0x077f,0x4119,0x86,0xb9,0xe7,0xae,0x71,0x04,0xcf,0x33,IID_ID3D11PartnerDevice)
GUID_ENTRY(0x0803425a,0x57f5,0x4dd6,0x94,0x65,0xa8,0x75,0x70,0x83,0x4a,0x08,IID_ID3D10StateBlock)
GUID_ENTRY(0x08256209,0x099a,0x4b34,0xb8,0x6d,0xc2,0x2b,0x11,0x0e,0x77,0x71,IID_IDWriteLocalizedStrings)
GUID_ENTRY(0x0987cb06,0xf916,0x48bf,0x8d,0x35,0xce,0x76,0x41,0x78,0x1b,0xd9,IID_IDCompositionDevice3)
GUID_ENTRY(0x09c3ca26,0x3ae2,0x4f09,0x9e,0xbc,0xed,0x38,0x65,0xd5,0x3f,0x22,CLSID_D2D1PointSpecular)
GUID_ENTRY(0x09e0bf36,0x54ac,0x484f,0x88,0x47,0x4b,0xae,0xea,0xb6,0x05,0x3a,IID_ID3D12DebugCommandQueue)
GUID_ENTRY(0x09e0bf36,0x54ac,0x484f,0x88,0x47,0x4b,0xae,0xea,0xb6,0x05,0x3f,IID_ID3D12DebugCommandList)
GUID_ENTRY(0x0a753dcf,0xc4d8,0x4b91,0xad,0xf6,0xbe,0x5a,0x60,0xd9,0x5a,0x76,IID_ID3D12Fence)
GUID_ENTRY(0x0aa1ae0a,0xfa0e,0x4b84,0x86,0x44,0xe0,0x5f,0xf8,0xe5,0xac,0xb5,IID_IDXGIAdapter2)
GUID_ENTRY(0x0b2b8630,0xad35,0x11d0,0x8e,0xa6,0x00,0x60,0x97,0x97,0xea,0x5b,IID_IDirectDrawSurface4)
GUID_ENTRY(0x0b74b9e8,0xcdd6,0x492f,0xbb,0xbc,0x5e,0xd3,0x21,0x57,0x02,0x6d,IID_IDCompositionAffineTransform2DEffect)
GUID_ENTRY(0x0c711683,0x2853,0x4846,0x9b,0xb0,0xf3,0xe6,0x06,0x39,0xe4,0x6a,IID_ID3D11Texture3D1)
GUID_ENTRY(0x0cfbaf3a,0x9ff6,0x429a,0x99,0xb3,0xa2,0x79,0x6a,0xf8,0xb8,0x9b,IID_IDirect3DSurface9)
GUID_ENTRY(0x0d85573c,0x01e3,0x4f7d,0xbf,0xd9,0x0d,0x60,0x60,0x8b,0xf3,0xc3,IID_ID2D1ComputeTransform)
GUID_ENTRY(0x0d9658ae,0xed45,0x469e,0xa6,0x1d,0x97,0x0e,0xc5,0x83,0xca,0xb4,IID_ID3D12QueryHeap)
GUID_ENTRY(0x0db207b3,0x9450,0x46a6,0x82,0xde,0x1b,0x96,0xd4,0x4f,0x9c,0xf2,D3D11_AUTHENTICATED_QUERY_RESTRICTED_SHARED_RESOURCE_PROCESS_COUNT)
GUID_DUPLI(0x0db207b3,0x9450,0x46a6,0x82,0xde,0x1b,0x96,0xd4,0x4f,0x9c,0xf2,D3DAUTHENTICATEDQUERY_RESTRICTEDSHAREDRESOURCEPROCESSCOUNT)
GUID_ENTRY(0x0e689c9a,0x053d,0x44a0,0x9d,0x92,0xdb,0x0e,0x3d,0x75,0x0f,0x86,IID_IDirect3DIndexBuffer8)
GUID_ENTRY(0x0ec870a6,0x5d7e,0x4c22,0x8c,0xfc,0x5b,0xaa,0xe0,0x76,0x16,0xed,IID_ID3D12CommandQueue)
GUID_ENTRY(0x0f4458ec,0x4b32,0x491b,0x9e,0x85,0xbd,0x73,0xf4,0x4d,0x3e,0xb6,CLSID_D2D1HueRotation)
GUID_ENTRY(0x107af0e0,0xef1a,0x4d19,0xab,0xa8,0x67,0xa1,0x63,0x07,0x3d,0x13,D3D11_DECODER_PROFILE_HEVC_VLD_MAIN10)
GUID_DUPLI(0x107af0e0,0xef1a,0x4d19,0xab,0xa8,0x67,0xa1,0x63,0x07,0x3d,0x13,DXVA2_ModeHEVC_VLD_Main10)
GUID_ENTRY(0x1093c18f,0x8d5e,0x43f0,0xb0,0x64,0x09,0x17,0x31,0x1b,0x52,0x5e,IID_IDWriteTextLayout2)
GUID_ENTRY(0x10a72a66,0xe91c,0x43f4,0x99,0x3f,0xdd,0xf4,0xb8,0x2b,0x0b,0x4a,IID_ID2D1StrokeStyle1)
GUID_ENTRY(0x10ec4d5b,0x975a,0x4689,0xb9,0xe4,0xd0,0xaa,0xc3,0x0f,0xe3,0x33,IID_ID3D11VideoDevice)
GUID_ENTRY(0x1108795c,0x2772,0x4ba9,0xb2,0xa8,0xd4,0x64,0xdc,0x7e,0x27,0x99,IID_ID3D12FunctionReflection)
GUID_ENTRY(0x119e7452,0xde9e,0x40fe,0x88,0x06,0x88,0xf9,0x0c,0x12,0xb4,0x41,IID_IDXGIDebug)
GUID_ENTRY(0x11eaa540,0xf9a6,0x4d49,0xae,0x6a,0xe1,0x92,0x21,0xf7,0x0c,0xc4,IID_ID3DXSkinInfo)
GUID_ENTRY(0x11ec5a5f,0x51dc,0x4945,0xab,0x34,0x6e,0x8c,0x21,0x30,0x0e,0xa5,IID_ID3D11VideoProcessorInputView)
GUID_ENTRY(0x1217d7a6,0x5039,0x418c,0xb0,0x42,0x9c,0xbe,0x25,0x6a,0xfd,0x6e,IID_ID3D11RasterizerState1)
GUID_ENTRY(0x126d0349,0x4787,0x4aa6,0x8e,0x1b,0x40,0xc1,0x77,0xc6,0x0a,0x01,IID_IDirect3DDxva2Container9)
GUID_ENTRY(0x13d29038,0xc3e6,0x4034,0x90,0x81,0x13,0xb5,0x3a,0x41,0x79,0x92,IID_ID2D1TransformGraph)
GUID_ENTRY(0x14885cc9,0xbab0,0x4f90,0xb6,0xed,0x5c,0x36,0x6a,0x2c,0xd0,0x3d,IID_IDWriteNumberSubstitution)
GUID_ENTRY(0x15e65ec0,0x3b9c,0x11d2,0xb9,0x2f,0x00,0x60,0x97,0x97,0xea,0x5b,IID_IDirectDraw7)
GUID_ENTRY(0x16cdff07,0xc503,0x419c,0x83,0xf2,0x09,0x65,0xc7,0xaf,0x1f,0xa6,IID_IDCompositionMatrixTransform)
GUID_ENTRY(0x174319a6,0x58e9,0x49b2,0xbb,0x63,0xca,0xf2,0xc8,0x11,0xa3,0xdb,CLSID_D2D1DirectionalBlur)
GUID_ENTRY(0x1841e5c8,0x16b0,0x489b,0xbc,0xc8,0x44,0xcf,0xb0,0xd5,0xde,0xae,IID_ID3D11DeviceChild)
GUID_ENTRY(0x187aeb13,0xaaf5,0x4c59,0x87,0x6d,0xe0,0x59,0x08,0x8c,0x0d,0xf8,IID_IDirect3D9ExOverlayExtension)
GUID_ENTRY(0x189819f1,0x1db6,0x4b57,0xbe,0x54,0x18,0x21,0x33,0x9b,0x85,0xf7,IID_ID3D12Device)
GUID_ENTRY(0x1911c771,0x1587,0x413e,0xa7,0xe0,0xfb,0x26,0xc3,0xde,0x02,0x68,IID_ID3D11TracingDevice)
GUID_ENTRY(0x191cfac3,0xa341,0x470d,0xb2,0x6e,0xa8,0x64,0xf4,0x28,0x31,0x9c,IID_IDXGIOutputDuplication)
GUID_ENTRY(0x193dacdf,0x0db2,0x4c05,0xa5,0x5c,0xef,0x06,0xca,0xc5,0x6f,0xd9,IID_ID3D11RefTrackingOptions)
GUID_ENTRY(0x1a0d8438,0x1d97,0x4ec1,0xae,0xf9,0xa2,0xfb,0x86,0xed,0x6a,0xcb,IID_IDWriteFontList)
GUID_ENTRY(0x1a28524c,0xfdd6,0x4aa4,0xae,0x8f,0x83,0x7e,0xb8,0x26,0x7b,0x37,CLSID_D2D1ColorManagement)
GUID_ENTRY(0x1a799d8a,0x69f7,0x4e4c,0x9f,0xed,0x43,0x7c,0xcc,0x66,0x84,0xcc,IID_ID2D1ConcreteTransform)
GUID_ENTRY(0x1b36bb7b,0x09b7,0x410a,0xb4,0x45,0x7d,0x14,0x30,0xd7,0xb3,0x3f,IID_IDirect3DResource8)
GUID_ENTRY(0x1b81be64,0xa0c7,0x11d3,0xb9,0x84,0x00,0xc0,0x4f,0x2e,0x73,0xc5,D3D11_DECODER_PROFILE_H264_MOCOMP_NOFGT)
GUID_DUPLI(0x1b81be64,0xa0c7,0x11d3,0xb9,0x84,0x00,0xc0,0x4f,0x2e,0x73,0xc5,DXVA2_ModeH264_A)
GUID_ENTRY(0x1b81be65,0xa0c7,0x11d3,0xb9,0x84,0x00,0xc0,0x4f,0x2e,0x73,0xc5,D3D11_DECODER_PROFILE_H264_MOCOMP_FGT)
GUID_DUPLI(0x1b81be65,0xa0c7,0x11d3,0xb9,0x84,0x00,0xc0,0x4f,0x2e,0x73,0xc5,DXVA2_ModeH264_B)
GUID_ENTRY(0x1b81be66,0xa0c7,0x11d3,0xb9,0x84,0x00,0xc0,0x4f,0x2e,0x73,0xc5,D3D11_DECODER_PROFILE_H264_IDCT_NOFGT)
GUID_DUPLI(0x1b81be66,0xa0c7,0x11d3,0xb9,0x84,0x00,0xc0,0x4f,0x2e,0x73,0xc5,DXVA2_ModeH264_C)
GUID_ENTRY(0x1b81be67,0xa0c7,0x11d3,0xb9,0x84,0x00,0xc0,0x4f,0x2e,0x73,0xc5,D3D11_DECODER_PROFILE_H264_IDCT_FGT)
GUID_DUPLI(0x1b81be67,0xa0c7,0x11d3,0xb9,0x84,0x00,0xc0,0x4f,0x2e,0x73,0xc5,DXVA2_ModeH264_D)
GUID_ENTRY(0x1b81be68,0xa0c7,0x11d3,0xb9,0x84,0x00,0xc0,0x4f,0x2e,0x73,0xc5,D3D11_DECODER_PROFILE_H264_VLD_NOFGT)
GUID_DUPLI(0x1b81be68,0xa0c7,0x11d3,0xb9,0x84,0x00,0xc0,0x4f,0x2e,0x73,0xc5,DXVA2_ModeH264_E)
GUID_ENTRY(0x1b81be69,0xa0c7,0x11d3,0xb9,0x84,0x00,0xc0,0x4f,0x2e,0x73,0xc5,D3D11_DECODER_PROFILE_H264_VLD_FGT)
GUID_DUPLI(0x1b81be69,0xa0c7,0x11d3,0xb9,0x84,0x00,0xc0,0x4f,0x2e,0x73,0xc5,DXVA2_ModeH264_F)
GUID_ENTRY(0x1b81be80,0xa0c7,0x11d3,0xb9,0x84,0x00,0xc0,0x4f,0x2e,0x73,0xc5,D3D11_DECODER_PROFILE_WMV8_POSTPROC)
GUID_DUPLI(0x1b81be80,0xa0c7,0x11d3,0xb9,0x84,0x00,0xc0,0x4f,0x2e,0x73,0xc5,DXVA2_ModeWMV8_A)
GUID_ENTRY(0x1b81be81,0xa0c7,0x11d3,0xb9,0x84,0x00,0xc0,0x4f,0x2e,0x73,0xc5,D3D11_DECODER_PROFILE_WMV8_MOCOMP)
GUID_DUPLI(0x1b81be81,0xa0c7,0x11d3,0xb9,0x84,0x00,0xc0,0x4f,0x2e,0x73,0xc5,DXVA2_ModeWMV8_B)
GUID_ENTRY(0x1b81be90,0xa0c7,0x11d3,0xb9,0x84,0x00,0xc0,0x4f,0x2e,0x73,0xc5,D3D11_DECODER_PROFILE_WMV9_POSTPROC)
GUID_DUPLI(0x1b81be90,0xa0c7,0x11d3,0xb9,0x84,0x00,0xc0,0x4f,0x2e,0x73,0xc5,DXVA2_ModeWMV9_A)
GUID_ENTRY(0x1b81be91,0xa0c7,0x11d3,0xb9,0x84,0x00,0xc0,0x4f,0x2e,0x73,0xc5,D3D11_DECODER_PROFILE_WMV9_MOCOMP)
GUID_DUPLI(0x1b81be91,0xa0c7,0x11d3,0xb9,0x84,0x00,0xc0,0x4f,0x2e,0x73,0xc5,DXVA2_ModeWMV9_B)
GUID_ENTRY(0x1b81be94,0xa0c7,0x11d3,0xb9,0x84,0x00,0xc0,0x4f,0x2e,0x73,0xc5,D3D11_DECODER_PROFILE_WMV9_IDCT)
GUID_DUPLI(0x1b81be94,0xa0c7,0x11d3,0xb9,0x84,0x00,0xc0,0x4f,0x2e,0x73,0xc5,DXVA2_ModeWMV9_C)
GUID_ENTRY(0x1b81bea0,0xa0c7,0x11d3,0xb9,0x84,0x00,0xc0,0x4f,0x2e,0x73,0xc5,D3D11_DECODER_PROFILE_VC1_POSTPROC)
GUID_DUPLI(0x1b81bea0,0xa0c7,0x11d3,0xb9,0x84,0x00,0xc0,0x4f,0x2e,0x73,0xc5,DXVA2_ModeVC1_A)
GUID_ENTRY(0x1b81bea1,0xa0c7,0x11d3,0xb9,0x84,0x00,0xc0,0x4f,0x2e,0x73,0xc5,D3D11_DECODER_PROFILE_VC1_MOCOMP)
GUID_DUPLI(0x1b81bea1,0xa0c7,0x11d3,0xb9,0x84,0x00,0xc0,0x4f,0x2e,0x73,0xc5,DXVA2_ModeVC1_B)
GUID_ENTRY(0x1b81bea2,0xa0c7,0x11d3,0xb9,0x84,0x00,0xc0,0x4f,0x2e,0x73,0xc5,D3D11_DECODER_PROFILE_VC1_IDCT)
GUID_DUPLI(0x1b81bea2,0xa0c7,0x11d3,0xb9,0x84,0x00,0xc0,0x4f,0x2e,0x73,0xc5,DXVA2_ModeVC1_C)
GUID_ENTRY(0x1b81bea3,0xa0c7,0x11d3,0xb9,0x84,0x00,0xc0,0x4f,0x2e,0x73,0xc5,D3D11_DECODER_PROFILE_VC1_VLD)
GUID_DUPLI(0x1b81bea3,0xa0c7,0x11d3,0xb9,0x84,0x00,0xc0,0x4f,0x2e,0x73,0xc5,DXVA2_ModeVC1_D)
GUID_ENTRY(0x1b81bea4,0xa0c7,0x11d3,0xb9,0x84,0x00,0xc0,0x4f,0x2e,0x73,0xc5,D3D11_DECODER_PROFILE_VC1_D2010)
GUID_DUPLI(0x1b81bea4,0xa0c7,0x11d3,0xb9,0x84,0x00,0xc0,0x4f,0x2e,0x73,0xc5,DXVA2_ModeVC1_D2010)
GUID_ENTRY(0x1b81bed0,0xa0c7,0x11d3,0xb9,0x84,0x00,0xc0,0x4f,0x2e,0x73,0xc5,DXVA2_NoEncrypt)
GUID_ENTRY(0x1b940b17,0x2642,0x4d1f,0xab,0x1f,0xb9,0x9b,0xad,0x0c,0x39,0x5f,IID_ID3D10InfoQueue)
GUID_ENTRY(0x1bc6ea02,0xef36,0x464f,0xbf,0x0c,0x21,0xca,0x39,0xe5,0x16,0x8a,IID_IDXGIFactory4)
GUID_ENTRY(0x1bf63c95,0x2650,0x405d,0x99,0xc1,0x36,0x36,0xbd,0x1d,0xa0,0xa1,IID_ID3D10ShaderReflectionVariable)
GUID_ENTRY(0x1c4820bb,0x5771,0x4518,0xa5,0x81,0x2f,0xe4,0xdd,0x0e,0xc6,0x57,IID_ID2D1ColorContext)
GUID_ENTRY(0x1c51bc64,0xde61,0x46fd,0x98,0x99,0x63,0xa5,0xd8,0xf0,0x39,0x50,IID_ID2D1DCRenderTarget)
GUID_ENTRY(0x1d7b0652,0x185f,0x41c6,0x85,0xce,0x0c,0x5b,0xe3,0xd4,0xae,0x6c,IID_ID3D11VideoProcessor)
GUID_ENTRY(0x1dbc4c88,0x94c1,0x46ee,0x90,0x76,0x2c,0x28,0x81,0x8c,0x94,0x81,DXFILEOBJ_EffectParamString)
GUID_ENTRY(0x1dd9e8da,0x1c77,0x4d40,0xb0,0xcf,0x98,0xfe,0xfd,0xff,0x95,0x12,IID_IDirect3D8)
GUID_ENTRY(0x1ddd77aa,0x9a4a,0x4cc8,0x9e,0x55,0x98,0xc1,0x96,0xba,0xfc,0x8f,IID_IDXGIFactoryDWM2)
GUID_ENTRY(0x1edd9491,0x9853,0x4299,0x89,0x8f,0x64,0x32,0x98,0x3b,0x6f,0x3a,IID_IDWriteGdiInterop)
GUID_ENTRY(0x1ef337e3,0x58e7,0x4f83,0xa6,0x92,0xdb,0x22,0x1f,0x5e,0xd4,0x7e,IID_ID3D11SwitchToRef)
GUID_ENTRY(0x1fcd2294,0xdf6d,0x4eae,0x86,0xb3,0x0e,0x91,0x60,0xcf,0xb0,0x7b,IID_ID3D10EffectBlendVariable)
GUID_ENTRY(0x1feb6d69,0x2fe6,0x4ac9,0x8c,0x58,0x1d,0x7f,0x93,0xe7,0xa6,0xa5,CLSID_D2D1GaussianBlur)
GUID_ENTRY(0x207bcecb,0xd683,0x4a06,0xa8,0xa3,0x9b,0x14,0x9b,0x9f,0x73,0xa4,IID_ID3D11FunctionReflection)
GUID_ENTRY(0x21af9f0e,0x4d94,0x4ea9,0x97,0x85,0x2c,0xb7,0x6b,0x8c,0x0b,0x34,IID_ID3D10EffectRasterizerVariable)
GUID_ENTRY(0x2411e7e1,0x12ac,0x4ccf,0xbd,0x14,0x97,0x98,0xe8,0x53,0x4d,0xc0,IID_IDXGIAdapter)
GUID_ENTRY(0x243b4c52,0x3606,0x4d3a,0x99,0xd7,0xa7,0xe7,0xb3,0x3e,0xd7,0x06,DXGI_DEBUG_D3D10)
GUID_ENTRY(0x24f416e6,0x1f67,0x4aa7,0xb8,0x8e,0xd3,0x3f,0x6f,0x31,0x28,0xa1,IID_IDirect3DVolume9)
GUID_ENTRY(0x2518526c,0xe789,0x4111,0xa7,0xb9,0x47,0xef,0x32,0x8d,0x13,0xe6,IID_IDirect3DVolumeTexture9)
GUID_ENTRY(0x25483823,0xcd46,0x4c7d,0x86,0xca,0x47,0xaa,0x95,0xb8,0x37,0xbd,IID_IDXGIFactory3)
GUID_ENTRY(0x25cddaa4,0xb1c6,0x47e1,0xac,0x3e,0x98,0x87,0x5b,0x5a,0x2e,0x2a,DXGI_DEBUG_DXGI)
GUID_ENTRY(0x2633066b,0x4514,0x4c7a,0x8f,0xd8,0x12,0xea,0x98,0x05,0x9d,0x18,IID_IDXGIDecodeSwapChain)
GUID_ENTRY(0x2634499e,0xd018,0x4d74,0xac,0x17,0x7f,0x72,0x40,0x59,0x52,0x8d,D3D11_AUTHENTICATED_QUERY_CRYPTO_SESSION)
GUID_DUPLI(0x2634499e,0xd018,0x4d74,0xac,0x17,0x7f,0x72,0x40,0x59,0x52,0x8d,D3DAUTHENTICATEDQUERY_CRYPTOSESSION)
GUID_ENTRY(0x26dc4561,0xa1ee,0x4ae7,0x96,0xda,0x11,0x8a,0x36,0xc0,0xec,0x95,IID_IDirect3DDevice9Video)
GUID_ENTRY(0x28211a43,0x7d89,0x476f,0x81,0x81,0x2d,0x61,0x59,0xb2,0x20,0xad,IID_ID2D1Effect)
GUID_ENTRY(0x28506e39,0xebf6,0x46a1,0xbb,0x47,0xfd,0x85,0x56,0x5a,0xb9,0x57,IID_ID2D1DrawingStateBlock)
GUID_ENTRY(0x28acf509,0x7f5c,0x48f6,0x86,0x11,0xf3,0x16,0x01,0x0a,0x63,0x80,IID_ID3D11UnorderedAccessView)
GUID_ENTRY(0x28ca0cc3,0xc2c9,0x40bb,0xb5,0x7f,0x67,0xb7,0x37,0x12,0x2b,0x17,IID_ID3D10EffectRenderTargetViewVariable)
GUID_ENTRY(0x29038f61,0x3839,0x4626,0x91,0xfd,0x08,0x68,0x79,0x01,0x1a,0x05,IID_IDXGIAdapter1)
GUID_ENTRY(0x29748ed6,0x8c9c,0x4a6a,0xbe,0x0b,0xd9,0x12,0xe8,0x53,0x89,0x44,IID_IDWriteFont2)
GUID_DUPLI(0x29748ed6,0x8c9c,0x4a6a,0xbe,0x0b,0xd9,0x12,0xe8,0x53,0x89,0x44,IID_IDWriteFont3) // XXX: Same as IID_IDWriteFont2!?
GUID_ENTRY(0x29da1d51,0x1321,0x4454,0x80,0x4b,0xf5,0xfc,0x9f,0x86,0x1f,0x0f,IID_ID3D11VideoDevice1)
GUID_ENTRY(0x2a2d49c0,0x4acf,0x43c7,0x8c,0x6a,0x7c,0x4a,0x27,0x87,0x4d,0x27,CLSID_D2D1Border)
GUID_ENTRY(0x2a9e9ead,0x364b,0x4b15,0xa7,0xc4,0xa1,0x99,0x7f,0x78,0xb3,0x89,IID_IDCompositionScaleTransform3D)
GUID_ENTRY(0x2b4b1cc8,0xa4ad,0x41f8,0x83,0x22,0xca,0x86,0xfc,0x3e,0xc6,0x75,IID_ID3D10DepthStencilState)
GUID_ENTRY(0x2c042b5e,0x8c07,0x46d5,0xaa,0xbe,0x8f,0x75,0xcb,0xad,0x4c,0x31,D3D11_AUTHENTICATED_QUERY_OUTPUT_ID_COUNT)
GUID_DUPLI(0x2c042b5e,0x8c07,0x46d5,0xaa,0xbe,0x8f,0x75,0xcb,0xad,0x4c,0x31,D3DAUTHENTICATEDQUERY_OUTPUTIDCOUNT)
GUID_ENTRY(0x2c1d867d,0xc290,0x41c8,0xae,0x7e,0x34,0xa9,0x87,0x02,0xe9,0xa5,IID_ID2D1PrintControl)
GUID_ENTRY(0x2cd90691,0x12e2,0x11dc,0x9f,0xed,0x00,0x11,0x43,0xa0,0x55,0xf9,IID_ID2D1Resource)
GUID_ENTRY(0x2cd90694,0x12e2,0x11dc,0x9f,0xed,0x00,0x11,0x43,0xa0,0x55,0xf9,IID_ID2D1RenderTarget)
GUID_ENTRY(0x2cd90695,0x12e2,0x11dc,0x9f,0xed,0x00,0x11,0x43,0xa0,0x55,0xf9,IID_ID2D1BitmapRenderTarget)
GUID_ENTRY(0x2cd90698,0x12e2,0x11dc,0x9f,0xed,0x00,0x11,0x43,0xa0,0x55,0xf9,IID_ID2D1HwndRenderTarget)
GUID_ENTRY(0x2cd9069b,0x12e2,0x11dc,0x9f,0xed,0x00,0x11,0x43,0xa0,0x55,0xf9,IID_ID2D1Layer)
GUID_ENTRY(0x2cd9069d,0x12e2,0x11dc,0x9f,0xed,0x00,0x11,0x43,0xa0,0x55,0xf9,IID_ID2D1StrokeStyle)
GUID_ENTRY(0x2cd9069e,0x12e2,0x11dc,0x9f,0xed,0x00,0x11,0x43,0xa0,0x55,0xf9,IID_ID2D1SimplifiedGeometrySink)
GUID_ENTRY(0x2cd9069f,0x12e2,0x11dc,0x9f,0xed,0x00,0x11,0x43,0xa0,0x55,0xf9,IID_ID2D1GeometrySink)
GUID_ENTRY(0x2cd906a1,0x12e2,0x11dc,0x9f,0xed,0x00,0x11,0x43,0xa0,0x55,0xf9,IID_ID2D1Geometry)
GUID_ENTRY(0x2cd906a2,0x12e2,0x11dc,0x9f,0xed,0x00,0x11,0x43,0xa0,0x55,0xf9,IID_ID2D1RectangleGeometry)
GUID_ENTRY(0x2cd906a3,0x12e2,0x11dc,0x9f,0xed,0x00,0x11,0x43,0xa0,0x55,0xf9,IID_ID2D1RoundedRectangleGeometry)
GUID_ENTRY(0x2cd906a4,0x12e2,0x11dc,0x9f,0xed,0x00,0x11,0x43,0xa0,0x55,0xf9,IID_ID2D1EllipseGeometry)
GUID_ENTRY(0x2cd906a5,0x12e2,0x11dc,0x9f,0xed,0x00,0x11,0x43,0xa0,0x55,0xf9,IID_ID2D1PathGeometry)
GUID_ENTRY(0x2cd906a6,0x12e2,0x11dc,0x9f,0xed,0x00,0x11,0x43,0xa0,0x55,0xf9,IID_ID2D1GeometryGroup)
GUID_ENTRY(0x2cd906a7,0x12e2,0x11dc,0x9f,0xed,0x00,0x11,0x43,0xa0,0x55,0xf9,IID_ID2D1GradientStopCollection)
GUID_ENTRY(0x2cd906a8,0x12e2,0x11dc,0x9f,0xed,0x00,0x11,0x43,0xa0,0x55,0xf9,IID_ID2D1Brush)
GUID_ENTRY(0x2cd906a9,0x12e2,0x11dc,0x9f,0xed,0x00,0x11,0x43,0xa0,0x55,0xf9,IID_ID2D1SolidColorBrush)
GUID_ENTRY(0x2cd906aa,0x12e2,0x11dc,0x9f,0xed,0x00,0x11,0x43,0xa0,0x55,0xf9,IID_ID2D1BitmapBrush)
GUID_ENTRY(0x2cd906ab,0x12e2,0x11dc,0x9f,0xed,0x00,0x11,0x43,0xa0,0x55,0xf9,IID_ID2D1LinearGradientBrush)
GUID_ENTRY(0x2cd906ac,0x12e2,0x11dc,0x9f,0xed,0x00,0x11,0x43,0xa0,0x55,0xf9,IID_ID2D1RadialGradientBrush)
GUID_ENTRY(0x2cd906bb,0x12e2,0x11dc,0x9f,0xed,0x00,0x11,0x43,0xa0,0x55,0xf9,IID_ID2D1TransformedGeometry)
GUID_ENTRY(0x2cd906c1,0x12e2,0x11dc,0x9f,0xed,0x00,0x11,0x43,0xa0,0x55,0xf9,IID_ID2D1TessellationSink)
GUID_ENTRY(0x2cd906c2,0x12e2,0x11dc,0x9f,0xed,0x00,0x11,0x43,0xa0,0x55,0xf9,IID_ID2D1Mesh)
GUID_ENTRY(0x2cdcd9e0,0x25a0,0x11cf,0xa3,0x1a,0x00,0xaa,0x00,0xb9,0x33,0x56,IID_IDirect3DTexture)
GUID_ENTRY(0x2f0da53a,0x2add,0x47cd,0x82,0xee,0xd9,0xec,0x34,0x68,0x8e,0x75,IID_IDWriteRenderingParams)
GUID_ENTRY(0x2f543dc3,0xcfc1,0x4211,0x86,0x4f,0xcf,0xd9,0x1c,0x6f,0x33,0x95,IID_ID2D1GdiMetafile)
GUID_ENTRY(0x2f642afe,0x9c68,0x4f40,0xb8,0xbe,0x45,0x74,0x01,0xaf,0xcb,0x3d,IID_IDWriteFontSetBuilder)
GUID_ENTRY(0x3014b9a0,0x62f5,0x478c,0x9b,0x86,0xe4,0xac,0x9f,0x4e,0x41,0x8b,DXFILEOBJ_EffectParamFloats)
GUID_ENTRY(0x3015a308,0xdcbd,0x47aa,0xa7,0x47,0x19,0x24,0x86,0xd1,0x4d,0x4a,IID_ID3D11AuthenticatedChannel)
GUID_ENTRY(0x30572f99,0xdac6,0x41db,0xa1,0x6e,0x04,0x86,0x30,0x7e,0x60,0x6a,IID_IDWriteFactory1)
GUID_ENTRY(0x30961379,0x4609,0x4a41,0x99,0x8e,0x54,0xfe,0x56,0x7e,0xe0,0xc1,IID_IDXGIResource1)
GUID_ENTRY(0x30c421d5,0x8cb2,0x4e9f,0xb1,0x33,0x37,0xbe,0x27,0x0d,0x4a,0xc2,IID_IDCompositionFilterEffect)
GUID_ENTRY(0x310d36a0,0xd2e7,0x4c0a,0xaa,0x04,0x6a,0x9d,0x23,0xb8,0x88,0x6a,IID_IDXGISwapChain)
GUID_ENTRY(0x313f1b4b,0xc7b0,0x4fa2,0x9d,0x9d,0x8d,0x38,0x0b,0x64,0x38,0x5e,IID_ID3DXRenderToEnvMap)
GUID_ENTRY(0x31627037,0x53ab,0x4200,0x90,0x61,0x05,0xfa,0xa9,0xab,0x45,0xf9,IID_ID3D11VideoProcessorEnumerator)
GUID_ENTRY(0x31e6e7bc,0xe0ff,0x4d46,0x8c,0x64,0xa0,0xa8,0xc4,0x1c,0x15,0xd3,IID_ID2D1Multithread)
GUID_ENTRY(0x335aa36e,0x7884,0x43a4,0x9c,0x91,0x7f,0x87,0xfa,0xf3,0xe3,0x7e,DXVA2_VideoProcBobDevice)
GUID_ENTRY(0x33ecdc0a,0x578a,0x4a11,0x9c,0x14,0x0c,0xb9,0x05,0x17,0xf9,0xc5,IID_IDCompositionBlendEffect)
GUID_ENTRY(0x344488b7,0x6846,0x474b,0xb9,0x89,0xf0,0x27,0x44,0x82,0x45,0xe0,IID_ID3D12Debug)
GUID_ENTRY(0x34ab647b,0x3cc8,0x46ac,0x84,0x1b,0xc0,0x96,0x56,0x45,0xc0,0x46,IID_ID3D12RootSignatureDeserializer)
GUID_ENTRY(0x35cdd7fc,0x13b2,0x421d,0xa5,0xd7,0x7e,0x44,0x51,0x28,0x7d,0x64,DXGI_DEBUG_DX)
GUID_ENTRY(0x36bfdcb6,0x9739,0x435d,0xa3,0x0d,0xa6,0x53,0xbe,0xff,0x6a,0x6f,IID_ID2D1DrawTransform)
GUID_ENTRY(0x38325b96,0xeffb,0x4022,0xba,0x02,0x2e,0x79,0x5b,0x70,0x27,0x5c,IID_ID3D11GeometryShader)
GUID_ENTRY(0x3b301d64,0xd678,0x4289,0x88,0x97,0x22,0xf8,0x92,0x8b,0x72,0xf3,IID_ID3D11VertexShader)
GUID_ENTRY(0x3b67dfa8,0xe3dd,0x4e61,0xb6,0x40,0x46,0xc2,0xf3,0xd7,0x39,0xdc,IID_IDCompositionArithmeticCompositeEffect)
GUID_ENTRY(0x3bba0080,0x2421,0x11cf,0xa3,0x1a,0x00,0xaa,0x00,0xb9,0x33,0x56,IID_IDirect3D)
GUID_ENTRY(0x3c305196,0x50db,0x11d3,0x9c,0xfe,0x00,0xc0,0x4f,0xd9,0x30,0xc5,CLSID_DirectDraw7)
GUID_ENTRY(0x3c9c5b51,0x995d,0x48d1,0x9b,0x8d,0xfa,0x5c,0xae,0xde,0xd6,0x5c,IID_ID3D11VideoDecoder)
GUID_ENTRY(0x3ce6cc22,0xdbf2,0x44f4,0x89,0x4d,0xf9,0xc3,0x4a,0x33,0x71,0x39,IID_ID3DX10PatchMesh)
GUID_DUPLI(0x3ce6cc22,0xdbf2,0x44f4,0x89,0x4d,0xf9,0xc3,0x4a,0x33,0x71,0x39,IID_ID3DXPatchMesh)
GUID_ENTRY(0x3cf169ce,0xff7c,0x44ab,0x93,0xc0,0xf7,0x8f,0x62,0xd1,0x72,0xe2,DXFILEOBJ_XSkinMeshHeader)
GUID_ENTRY(0x3d3e0379,0xf9de,0x4d58,0xbb,0x6c,0x18,0xd6,0x29,0x92,0xf1,0xa6,IID_IDXGIDeviceSubObject)
GUID_ENTRY(0x3d9f916b,0x27dc,0x4ad7,0xb4,0xf1,0x64,0x94,0x53,0x40,0xf5,0x63,IID_ID2D1EffectContext)
GUID_ENTRY(0x3e02c918,0xcc79,0x4985,0xb6,0x22,0x2d,0x92,0xad,0x70,0x16,0x23,IID_ID3D10EffectDepthStencilViewVariable)
GUID_ENTRY(0x3e3d67f8,0xaa7a,0x405d,0xa8,0x57,0xba,0x01,0xd4,0x75,0x84,0x26,IID_ID3DXTextureShader)
GUID_ENTRY(0x3e7efd62,0xa32d,0x46d4,0xa8,0x3c,0x52,0x78,0x88,0x9a,0xc9,0x54,CLSID_D2D1DistantDiffuse)
GUID_ENTRY(0x3ee5b968,0x2aca,0x4c34,0x8b,0xb5,0x7e,0x0c,0x3d,0x19,0xb7,0x50,IID_IDirect3DCubeTexture8)
GUID_ENTRY(0x3fe6adea,0x7643,0x4f53,0xbd,0x14,0xa0,0xce,0x63,0xf2,0x40,0x42,IID_ID2D1OffsetTransform)
GUID_ENTRY(0x3febd6dd,0x4973,0x4787,0x81,0x94,0xe4,0x5f,0x9e,0x28,0x92,0x3e,IID_ID3D12DebugDevice)
GUID_ENTRY(0x4020e5c2,0x1403,0x4929,0x88,0x3f,0xe2,0xe8,0x49,0xfa,0xc1,0x95,IID_ID3DX10Mesh)
GUID_DUPLI(0x4020e5c2,0x1403,0x4929,0x88,0x3f,0xe2,0xe8,0x49,0xfa,0xc1,0x95,IID_ID3DXMesh)
GUID_ENTRY(0x407f8c08,0x5533,0x4331,0xa3,0x41,0x23,0xcc,0x38,0x77,0x84,0x3e,CLSID_D2D1ConvolveMatrix)
GUID_ENTRY(0x409444c4,0xc419,0x41a0,0xb0,0xc1,0x8c,0xd0,0xc0,0xa1,0x8e,0x42,CLSID_D2D1GammaTransfer)
GUID_ENTRY(0x41251ab7,0x0beb,0x46f8,0x9d,0xa7,0x59,0xe9,0x3f,0xcc,0xe5,0xde,CLSID_D2D1LuminanceToAlpha)
GUID_ENTRY(0x41343a53,0xe41a,0x49a2,0x91,0xcd,0x21,0x79,0x3b,0xbb,0x62,0xe5,IID_ID2D1BitmapBrush1)
GUID_ENTRY(0x41e7d1f2,0xa591,0x4f7b,0xa2,0xe5,0xfa,0x9c,0x84,0x3e,0x1c,0x12,IID_IDXGIFactoryMedia)
GUID_ENTRY(0x41fff286,0x6ae0,0x4d43,0x9d,0x55,0xa4,0x6e,0x9e,0xfd,0x15,0x8a,D3D11_AUTHENTICATED_CONFIGURE_ENCRYPTION_WHEN_ACCESSIBLE)
GUID_DUPLI(0x41fff286,0x6ae0,0x4d43,0x9d,0x55,0xa4,0x6e,0x9e,0xfd,0x15,0x8a,D3DAUTHENTICATEDCONFIGURE_ENCRYPTIONWHENACCESSIBLE)
GUID_ENTRY(0x420bd604,0x1c76,0x4a34,0xa4,0x66,0xe4,0x5d,0x06,0x58,0xa3,0x2c,IID_ID3DX10SkinInfo)
GUID_ENTRY(0x420d5b32,0xb90c,0x4da4,0xbe,0xf0,0x35,0x9f,0x6a,0x24,0xa8,0x3a,IID_ID3D11DeviceContext2)
GUID_ENTRY(0x42757488,0x334f,0x47fe,0x98,0x2e,0x1a,0x65,0xd0,0x8c,0xc4,0x62,IID_ID3D11FunctionParameterReflection)
GUID_ENTRY(0x428c1ee5,0x77b8,0x4450,0x8a,0xb5,0x72,0x21,0x9c,0x21,0xab,0xda,CLSID_D2D1DistantSpecular)
GUID_ENTRY(0x429b8c22,0x9188,0x4b0c,0x87,0x42,0xac,0xb0,0xbf,0x85,0xc2,0x00,WKPDID_D3DDebugObjectName)
GUID_ENTRY(0x4305ee5b,0xc4a0,0x4c88,0x93,0x85,0x67,0x12,0x4e,0x01,0x76,0x83,IID_IDCompositionLinearTransferEffect)
GUID_ENTRY(0x43d3775c,0x38e5,0x4924,0x8d,0x86,0xd3,0xfc,0xcf,0x15,0x3e,0x9b,D3DKEYEXCHANGE_DXVA)
GUID_ENTRY(0x4417c142,0x33ad,0x11cf,0x81,0x6f,0x00,0x00,0xc0,0x20,0x15,0x6e,IID_IDirect3DLight)
GUID_ENTRY(0x4417c144,0x33ad,0x11cf,0x81,0x6f,0x00,0x00,0xc0,0x20,0x15,0x6e,IID_IDirect3DMaterial)
GUID_ENTRY(0x4417c145,0x33ad,0x11cf,0x81,0x6f,0x00,0x00,0xc0,0x20,0x15,0x6e,IID_IDirect3DExecuteBuffer)
GUID_ENTRY(0x4417c146,0x33ad,0x11cf,0x81,0x6f,0x00,0x00,0xc0,0x20,0x15,0x6e,IID_IDirect3DViewport)
GUID_ENTRY(0x4553d47f,0xee7e,0x4e3f,0x94,0x75,0xdb,0xf1,0x37,0x6c,0x48,0x10,DXVA2_VideoProcSoftwareDevice)
GUID_ENTRY(0x4556be70,0x3abd,0x4f70,0x90,0xbe,0x42,0x17,0x80,0xa6,0xf5,0x15,IID_IDWriteGdiInterop1)
GUID_ENTRY(0x45d4d0b7,0x1bd4,0x454e,0x88,0x94,0x2b,0xfa,0x68,0x44,0x30,0x33,IID_IDCompositionGaussianBlurEffect)
GUID_ENTRY(0x465217f2,0x5568,0x43cf,0xb5,0xb9,0xf6,0x1d,0x54,0x53,0x1c,0xa1,IID_ID3D11VideoProcessorEnumerator1)
GUID_ENTRY(0x469e07f7,0x045a,0x48d5,0xaa,0x12,0x68,0xa4,0x78,0xcd,0xf7,0x5d,IID_ID3D11ModuleInstance)
GUID_ENTRY(0x47dd575d,0xac05,0x4cdd,0x80,0x49,0x9b,0x02,0xcd,0x16,0xf4,0x4c,IID_ID2D1Device)
GUID_ENTRY(0x483473d7,0xcd46,0x4f9d,0x9d,0x3a,0x31,0x12,0xaa,0x80,0x15,0x9d,IID_ID2D1Properties)
GUID_ENTRY(0x48570b85,0xd1ee,0x4fcd,0xa2,0x50,0xeb,0x35,0x07,0x22,0xb0,0x37,IID_ID3D11Buffer)
GUID_ENTRY(0x48fc9f51,0xf6ac,0x48f1,0x8b,0x58,0x3b,0x28,0xac,0x46,0xf7,0x6d,CLSID_D2D1Composite)
GUID_ENTRY(0x4968b601,0x9d00,0x4cde,0x83,0x46,0x8e,0x7f,0x67,0x58,0x19,0xb6,IID_ID3D10PixelShader)
GUID_ENTRY(0x4998735c,0x3a19,0x473c,0x97,0x81,0x65,0x68,0x47,0xe3,0xa3,0x47,IID_ID2D1BorderTransform)
GUID_ENTRY(0x4ad18ac0,0xcfd2,0x4c2f,0xbb,0x62,0x96,0xe5,0x4f,0xdb,0x68,0x79,IID_IDCompositionShadowEffect)
GUID_ENTRY(0x4ae63092,0x6327,0x4c1b,0x80,0xae,0xbf,0xe1,0x2e,0xa3,0x2b,0x86,IID_IDXGISurface1)
GUID_ENTRY(0x4b3363f0,0x643b,0x41b7,0xb6,0xe0,0xcc,0xf2,0x2d,0x34,0x46,0x7c,IID_IDCompositionMatrixTransform3D)
GUID_ENTRY(0x4b35d0cd,0x1e15,0x4258,0x9c,0x98,0x1b,0x13,0x33,0xf6,0xdd,0x3b,IID_ID3D11Asynchronous)
GUID_ENTRY(0x4b8aaafa,0x140f,0x42ba,0x91,0x31,0x59,0x7e,0xaf,0xaa,0x2e,0xad,IID_IDirect3DVolumeTexture8)
GUID_ENTRY(0x4b99317b,0xac39,0x4aa6,0xbb,0x0b,0xba,0xa0,0x47,0x84,0x79,0x8f,DXGI_DEBUG_D3D11)
GUID_ENTRY(0x4b9f0ee0,0x0d7e,0x11d0,0x9b,0x06,0x00,0xa0,0xc9,0x03,0xa3,0xb8,IID_IDirectDrawColorControl)
GUID_ENTRY(0x4cca5fd8,0x921f,0x42c8,0x85,0x66,0x70,0xca,0xf2,0xa9,0xb7,0x41,WKPDID_D3DDebugObjectNameW)
GUID_ENTRY(0x4d93059d,0x097b,0x4651,0x9a,0x60,0xf0,0xf2,0x51,0x16,0xe2,0xf3,IID_IDCompositionVisual)
GUID_ENTRY(0x4e9e1ddc,0xcd9d,0x4772,0xa8,0x37,0x00,0x18,0x0b,0x9b,0x88,0xfd,IID_ID3D10EffectType)
GUID_ENTRY(0x4f5b196e,0xc2bd,0x495e,0xbd,0x01,0x1f,0xde,0xd3,0x8e,0x49,0x69,IID_ID3D11ComputeShader)
GUID_ENTRY(0x50455658,0x3f47,0x4362,0xbf,0x99,0xbf,0xdf,0xcd,0xe9,0xed,0x29,D3D11_AUTHENTICATED_CONFIGURE_PROTECTION)
GUID_DUPLI(0x50455658,0x3f47,0x4362,0xbf,0x99,0xbf,0xdf,0xcd,0xe9,0xed,0x29,D3DAUTHENTICATEDCONFIGURE_PROTECTION)
GUID_ENTRY(0x50666c24,0xb82f,0x4eed,0xa1,0x72,0x5b,0x6e,0x7e,0x85,0x22,0xe0,IID_ID3D10EffectMatrixVariable)
GUID_ENTRY(0x5089b68f,0xe71d,0x4d38,0xbe,0x8e,0xf3,0x63,0xb9,0x5a,0x94,0x05,IID_ID3DX11Scan)
GUID_ENTRY(0x50936643,0x13e9,0x11d1,0x89,0xaa,0x00,0xa0,0xc9,0x05,0x41,0x29,IID_IDirect3DRefDevice)
GUID_ENTRY(0x50c83a1c,0xe072,0x4c48,0x87,0xb0,0x36,0x30,0xfa,0x36,0xa6,0xd0,IID_IDXGIFactory2)
GUID_ENTRY(0x51218251,0x1e33,0x4617,0x9c,0xcb,0x4d,0x3a,0x43,0x67,0xe7,0xbb,IID_ID3D11Texture2D1)
GUID_ENTRY(0x519ae1bd,0xd19a,0x420d,0xb8,0x49,0x36,0x4f,0x59,0x47,0x76,0xb7,IID_ID2D1RenderInfo)
GUID_ENTRY(0x51b0ca8b,0xec0b,0x4519,0x87,0x0d,0x8e,0xe1,0xcb,0x50,0x17,0xc7,IID_ID3D10Effect)
GUID_ENTRY(0x51b8a949,0x1a31,0x47e6,0xbe,0xa0,0x4b,0x30,0xdb,0x53,0xf1,0xe0,IID_ID3DXEffectCompiler)
GUID_ENTRY(0x51f23923,0xf3e5,0x4bd1,0x91,0xcb,0x60,0x61,0x77,0xd8,0xdb,0x4c,IID_ID3D11ShaderReflectionVariable)
GUID_ENTRY(0x53585141,0xd9f8,0x4095,0x83,0x21,0xd7,0x3c,0xf6,0xbd,0x11,0x6b,IID_IDWriteFontSet)
GUID_ENTRY(0x53585141,0xd9f8,0x4095,0x83,0x21,0xd7,0x3c,0xf6,0xbd,0x11,0x6c,IID_IDWriteFontCollection1)
GUID_ENTRY(0x53737037,0x6d14,0x410b,0x9b,0xfe,0x0b,0x18,0x2b,0xb7,0x09,0x61,IID_IDWriteTextLayout)
GUID_ENTRY(0x54133220,0x1ce8,0x43d3,0x82,0x36,0x98,0x55,0xc5,0xce,0xec,0xff,IID_ID3D11FunctionLinkingGraph)
GUID_ENTRY(0x54384f1b,0x5b3e,0x4bb7,0xae,0x01,0x60,0xba,0x30,0x97,0xcb,0xb6,IID_ID3D11LibraryReflection)
GUID_ENTRY(0x54d7898a,0xa061,0x40a7,0xbe,0xc7,0xe4,0x65,0xbc,0xba,0x2c,0x4f,IID_ID2D1CommandSink)
GUID_ENTRY(0x54ec77fa,0x1377,0x44e6,0x8c,0x32,0x88,0xfd,0x5f,0x44,0xc8,0x4c,IID_IDXGIDevice)
GUID_ENTRY(0x553a9ff3,0x5693,0x4df7,0xb5,0x2b,0x74,0x80,0x6f,0x7f,0x2e,0xb9,IID_IDWriteTextAnalyzer2)
GUID_ENTRY(0x5598b14b,0x9fd7,0x48b7,0x9b,0xdb,0x8f,0x09,0x64,0xeb,0x38,0xbc,IID_ID2D1ComputeInfo)
GUID_ENTRY(0x55f1112b,0x1dc2,0x4b3c,0x95,0x41,0xf4,0x68,0x94,0xed,0x85,0xb6,IID_IDWriteTypography)
GUID_ENTRY(0x56648f4d,0xcc8b,0x4444,0xa5,0xad,0xb5,0xa3,0xd7,0x6e,0x91,0xb3,IID_ID3D10EffectConstantBuffer)
GUID_ENTRY(0x574ccc14,0xf0b3,0x4333,0x82,0x2d,0x93,0xe8,0xa8,0xa0,0x8e,0x4c,DXFILEOBJ_PMVSplitRecord)
GUID_ENTRY(0x576616c0,0xa231,0x494d,0xa3,0x8d,0x00,0xfd,0x5e,0xc4,0xdb,0x46,IID_IDCompositionCompositeEffect)
GUID_ENTRY(0x57805885,0x6eec,0x11cf,0x94,0x41,0xa8,0x23,0x03,0xc1,0x0e,0x27,IID_IDirectDrawSurface2)
GUID_ENTRY(0x580ca87e,0x1d3c,0x4d54,0x99,0x1d,0xb7,0xd3,0xe3,0xc2,0x98,0xce,IID_IDirect3DBaseTexture9)
GUID_ENTRY(0x5810cd44,0x0ca0,0x4701,0xb3,0xfa,0xbe,0xc5,0x18,0x2a,0xe4,0xf6,IID_IDWriteTextAnalysisSink)
GUID_ENTRY(0x593817a0,0x7db3,0x11cf,0xa2,0xde,0x00,0xaa,0x00,0xb9,0x33,0x56,CLSID_DirectDrawClipper)
GUID_ENTRY(0x595e39d1,0x2724,0x4663,0x99,0xb1,0xda,0x96,0x9d,0xe2,0x83,0x64,IID_IDXGIOutput2)
GUID_ENTRY(0x59a6cd0e,0xe10d,0x4c1f,0x88,0xc0,0x63,0xab,0xa1,0xda,0xf3,0x0e,IID_ID3D11Linker)
GUID_ENTRY(0x5a54a0c9,0xc7ec,0x4bd9,0x8e,0xde,0xf3,0xc7,0x5d,0xc4,0x39,0x3b,DXVA2_VideoProcProgressiveDevice)
GUID_ENTRY(0x5a58797d,0xa72c,0x478d,0x8b,0xa2,0xef,0xc6,0xb0,0xef,0xe8,0x8e,IID_ID3D12ShaderReflection)
GUID_ENTRY(0x5b11d51b,0x2f4c,0x4452,0xbc,0xc3,0x09,0xf2,0xa1,0x16,0x0c,0xc0,D3D11_DECODER_PROFILE_HEVC_VLD_MAIN)
GUID_DUPLI(0x5b11d51b,0x2f4c,0x4452,0xbc,0xc3,0x09,0xf2,0xa1,0x16,0x0c,0xc0,DXVA2_ModeHEVC_VLD_Main)
GUID_ENTRY(0x5b160d0f,0xac1b,0x4185,0x8b,0xa8,0xb3,0xae,0x42,0xa5,0xa4,0x55,IID_ID3D12GraphicsCommandList)
GUID_ENTRY(0x5bf818c3,0x5e43,0x48cb,0xb6,0x31,0x86,0x83,0x96,0xd6,0xa1,0xd4,CLSID_D2D1TableTransfer)
GUID_ENTRY(0x5c1e0d8a,0x7c23,0x48f9,0x8c,0x59,0xa9,0x29,0x58,0xce,0xff,0x11,IID_ID3DDeviceContextState)
GUID_ENTRY(0x5cb2d9cf,0x327d,0x459f,0xa0,0xce,0x40,0xc0,0xb2,0x08,0x6b,0xf7,CLSID_D2D1Saturation)
GUID_ENTRY(0x5cfbeb89,0x1a06,0x46e0,0xb2,0x82,0xe3,0xf9,0xbf,0xa3,0x6a,0x54,IID_ID3D10EffectPass)
GUID_ENTRY(0x5e5a32a3,0x8dff,0x4773,0x9f,0xf6,0x06,0x96,0xea,0xb7,0x72,0x67,IID_IDWriteBitmapRenderTarget)
GUID_ENTRY(0x5e7fa7ca,0xdde3,0x424c,0x89,0xf0,0x9f,0xcd,0x6f,0xed,0x58,0xcd,IID_IDWriteFontFaceReference)
GUID_ENTRY(0x5f174b49,0x0d8b,0x4cfb,0x8b,0xca,0xf1,0xcc,0xe9,0xd0,0x6c,0x67,IID_IDWriteTextFormat1)
GUID_ENTRY(0x5f4633fe,0x1e08,0x4cb8,0x8c,0x75,0xce,0x24,0x33,0x3f,0x56,0x02,IID_IDCompositionDesktopDevice)
GUID_ENTRY(0x5f49804d,0x7024,0x4d43,0xbf,0xa9,0xd2,0x59,0x84,0xf5,0x38,0x49,IID_IDWriteFontFace)
GUID_ENTRY(0x5fb6c24d,0xc6dd,0x4231,0x94,0x04,0x50,0xf4,0xd5,0xc3,0x25,0x2d,CLSID_D2D1BitmapSource)
GUID_ENTRY(0x6007896c,0x3244,0x4afd,0xbf,0x18,0xa6,0xd3,0xbe,0xda,0x50,0x23,IID_IDXGIDevice3)
GUID_ENTRY(0x6027496e,0xcb3a,0x49ab,0x93,0x4f,0xd7,0x98,0xda,0x4f,0x7d,0xa6,IID_IDCompositionBrightnessEffect)
GUID_ENTRY(0x6102dee4,0xaf59,0x4b09,0xb9,0x99,0xb4,0x4d,0x73,0xf0,0x9b,0x24,IID_ID3D12CommandAllocator)
GUID_ENTRY(0x61c23c20,0xae69,0x4d8e,0x94,0xcf,0x50,0x07,0x8d,0xf6,0x38,0xf2,CLSID_D2D1Flood)
GUID_ENTRY(0x61f21c45,0x3c0e,0x4a74,0x9c,0xea,0x67,0x10,0x0d,0x9a,0xd5,0xe4,IID_ID3D11VideoContext)
GUID_ENTRY(0x6214d9d2,0x432c,0x4abb,0x9f,0xce,0x21,0x6e,0xea,0x26,0x9e,0x3b,D3D11_AUTHENTICATED_QUERY_ACCESSIBILITY_ATTRIBUTES)
GUID_DUPLI(0x6214d9d2,0x432c,0x4abb,0x9f,0xce,0x21,0x6e,0xea,0x26,0x9e,0x3b,D3DAUTHENTICATEDQUERY_ACCESSIBILITYATTRIBUTES)
GUID_ENTRY(0x622c0ed0,0x956e,0x4da9,0x90,0x8a,0x2a,0xf9,0x4f,0x3c,0xe7,0x16,DXFILEOBJ_EffectDWord)
GUID_ENTRY(0x62b98c44,0x1f82,0x4c67,0xbc,0xd0,0x72,0xcf,0x8f,0x21,0x7e,0x81,IID_ID3D10EffectVectorVariable)
GUID_ENTRY(0x62baa2d2,0xab54,0x41b7,0xb8,0x72,0x78,0x7e,0x01,0x06,0xa4,0x21,IID_ID2D1PathGeometry1)
GUID_ENTRY(0x6316be88,0x54cd,0x4040,0xab,0x44,0x20,0x46,0x1b,0xc8,0x1f,0x68,IID_ID3D10GeometryShader)
GUID_ENTRY(0x631b4766,0x36dc,0x461d,0x8d,0xb6,0xc4,0x7e,0x13,0xe6,0x09,0x16,IID_ID3D11Query1)
GUID_ENTRY(0x6346cc54,0x2cfc,0x4ad4,0x82,0x24,0xd1,0x58,0x37,0xde,0x77,0x00,D3D11_AUTHENTICATED_CONFIGURE_CRYPTO_SESSION)
GUID_DUPLI(0x6346cc54,0x2cfc,0x4ad4,0x82,0x24,0xd1,0x58,0x37,0xde,0x77,0x00,D3DAUTHENTICATEDCONFIGURE_CRYPTOSESSION)
GUID_ENTRY(0x639cfad8,0x0fb4,0x4b21,0xa5,0x8a,0x06,0x79,0x20,0x12,0x00,0x09,IID_IDWriteTextAnalysisSource1)
GUID_ENTRY(0x63ac0b32,0xba44,0x450f,0x88,0x06,0x7f,0x4c,0xa1,0xff,0x2f,0x1b,IID_ID2D1BlendTransform)
GUID_ENTRY(0x63ee58fb,0x1268,0x4835,0x86,0xda,0xf0,0x08,0xce,0x62,0xf0,0xd6,IID_ID3D12Pageable)
GUID_ENTRY(0x64108800,0x957d,0x11d0,0x89,0xab,0x00,0xa0,0xc9,0x05,0x41,0x29,IID_IDirect3DDevice)
GUID_ENTRY(0x641ed83c,0xae96,0x46c5,0x90,0xdc,0x32,0x77,0x4c,0xc5,0xc6,0xd5,IID_IDCompositionRotateTransform)
GUID_ENTRY(0x645967a4,0x1392,0x4310,0xa7,0x98,0x80,0x53,0xce,0x3e,0x93,0xfd,IID_IDXGIAdapter3)
GUID_ENTRY(0x649bbadb,0xf0f4,0x4639,0xa1,0x5b,0x24,0x39,0x3f,0xc3,0xab,0xac,D3D11_AUTHENTICATED_QUERY_RESTRICTED_SHARED_RESOURCE_PROCESS)
GUID_DUPLI(0x649bbadb,0xf0f4,0x4639,0xa1,0x5b,0x24,0x39,0x3f,0xc3,0xab,0xac,D3DAUTHENTICATEDQUERY_RESTRICTEDSHAREDRESOURCEPROCESS)
GUID_ENTRY(0x64ac3703,0x9d3f,0x45ec,0xa1,0x09,0x7c,0xac,0x0e,0x7a,0x13,0xa7,IID_IDCompositionClip)
GUID_ENTRY(0x65019f75,0x8da2,0x497c,0xb3,0x2c,0xdf,0xa3,0x4e,0x48,0xed,0xe6,IID_ID2D1Image)
GUID_ENTRY(0x6530d5c7,0x07e9,0x4271,0xa4,0x18,0xe7,0xce,0x4b,0xd1,0xe4,0x80,IID_ID3D10EffectSamplerVariable)
GUID_ENTRY(0x6543dbb6,0x1b48,0x42f5,0xab,0x82,0xe9,0x7e,0xc7,0x43,0x26,0xf6,IID_ID3D11InfoQueue)
GUID_ENTRY(0x667ea4c7,0xf1cd,0x4386,0xb5,0x23,0x7c,0x02,0x90,0xb8,0x3c,0xc5,IID_ID3DX10SPMesh)
GUID_DUPLI(0x667ea4c7,0xf1cd,0x4386,0xb5,0x23,0x7c,0x02,0x90,0xb8,0x3c,0xc5,IID_ID3DXSPMesh)
GUID_ENTRY(0x66c66a94,0xdddd,0x4b62,0xa6,0x6a,0xf0,0xda,0x33,0xc2,0xb4,0xd0,IID_ID3D10ShaderReflectionConstantBuffer)
GUID_ENTRY(0x683a4278,0xcd5f,0x4d24,0x90,0xad,0xc4,0xe1,0xb6,0x85,0x5d,0x53,IID_ID3DXPRTEngine)
GUID_ENTRY(0x688d15c3,0x02b0,0x438d,0xb1,0x3a,0xd1,0xb4,0x4c,0x32,0xc3,0x9a,IID_ID2D1ResourceTexture)
GUID_ENTRY(0x688e1a58,0x5094,0x47c8,0xad,0xc8,0xfb,0xce,0xa6,0x0a,0xe9,0x2b,IID_IDWriteTextAnalysisSource)
GUID_ENTRY(0x689f1f85,0xc72e,0x4e33,0x8f,0x19,0x85,0x75,0x4e,0xfd,0x5a,0xce,IID_ID2D1DrawingStateBlock1)
GUID_ENTRY(0x693ce632,0x7f2f,0x45de,0x93,0xfe,0x18,0xd8,0x8b,0x37,0xaa,0x21,IID_ID2D1DrawInfo)
GUID_ENTRY(0x696442be,0xa72e,0x4059,0xbc,0x79,0x5b,0x5c,0x98,0x04,0x0f,0xad,IID_ID3D12Resource)
GUID_ENTRY(0x6985f346,0x2c3d,0x43b3,0xbe,0x8b,0xda,0xae,0x8a,0x03,0xd8,0x94,IID_ID3DXRenderToSurface)
GUID_ENTRY(0x698cfb3f,0x9289,0x4d95,0x9a,0x57,0x33,0xa9,0x4b,0x5a,0x65,0xf9,IID_ID3DXAnimationSet)
GUID_ENTRY(0x69c11c3e,0xb46b,0x11d1,0xad,0x7a,0x00,0xc0,0x4f,0xc2,0x9b,0x4e,IID_IDirectDrawGammaControl)
GUID_ENTRY(0x6aa97485,0x6354,0x4cfc,0x90,0x8c,0xe4,0xa7,0x4f,0x62,0xc9,0x6c,CLSID_D2D12DAffineTransform)
GUID_ENTRY(0x6aae1ec1,0x662a,0x11d0,0x88,0x9d,0x00,0xaa,0x00,0xbb,0xb7,0x6a,IID_IDirect3D2)
GUID_ENTRY(0x6b3b2502,0x6e51,0x45b3,0x90,0xee,0x98,0x84,0x26,0x5e,0x8d,0xf3,IID_ID3D12Heap)
GUID_ENTRY(0x6c14db80,0xa733,0x11ce,0xa5,0x21,0x00,0x20,0xaf,0x0b,0xe5,0x60,IID_IDirectDraw)
GUID_ENTRY(0x6c14db81,0xa733,0x11ce,0xa5,0x21,0x00,0x20,0xaf,0x0b,0xe5,0x60,IID_IDirectDrawSurface)
GUID_ENTRY(0x6c14db84,0xa733,0x11ce,0xa5,0x21,0x00,0x20,0xaf,0x0b,0xe5,0x60,IID_IDirectDrawPalette)
GUID_ENTRY(0x6c14db85,0xa733,0x11ce,0xa5,0x21,0x00,0x20,0xaf,0x0b,0xe5,0x60,IID_IDirectDrawClipper)
GUID_ENTRY(0x6c26c5c7,0x34e0,0x46fc,0x9c,0xfd,0xe5,0x82,0x37,0x06,0xe2,0x28,CLSID_D2D1DpiCompensation)
GUID_ENTRY(0x6c53006a,0x4450,0x4199,0xaa,0x5b,0xad,0x16,0x56,0xfe,0xce,0x5e,CLSID_D2D1OpacityMetadata)
GUID_ENTRY(0x6cc2480d,0x3808,0x4739,0x9f,0x88,0xde,0x49,0xfa,0xcd,0x8d,0x4c,IID_ID3DXCompressedAnimationSet)
GUID_ENTRY(0x6d3bdbdc,0x5b02,0x4415,0xb8,0x52,0xce,0x5e,0x8b,0xcc,0xb2,0x89,IID_IDirect3DPixelShader9)
GUID_ENTRY(0x6d4865fe,0x0ab8,0x4d91,0x8f,0x62,0x5d,0xd6,0xbe,0x34,0xa3,0xe0,IID_IDWriteFontFileStream)
GUID_ENTRY(0x6db9f920,0x0770,0x4781,0xb0,0xc6,0x38,0x19,0x12,0xf9,0xd1,0x67,IID_IDCompositionHueRotationEffect)
GUID_ENTRY(0x6e6ffa6a,0x9bae,0x4613,0xa5,0x1e,0x91,0x65,0x2d,0x50,0x8c,0x21,IID_ID3D11ShaderReflectionType)
GUID_ENTRY(0x6e8c49fb,0xa371,0x4770,0xb4,0x40,0x29,0x08,0x60,0x22,0xb7,0x41,IID_ID3D11Counter)
GUID_ENTRY(0x6f0d123b,0xbad2,0x4167,0xa0,0xd0,0x80,0x22,0x4f,0x25,0xfa,0xbb,DXFILEOBJ_SkinWeights)
GUID_ENTRY(0x6f15aaf2,0xd208,0x4e89,0x9a,0xb4,0x48,0x95,0x35,0xd3,0x4f,0x9c,IID_ID3D11Texture2D)
GUID_ENTRY(0x6f3ec719,0x3735,0x42cc,0x80,0x63,0x65,0xcc,0x3c,0xb3,0x66,0x16,D3D11_DECODER_PROFILE_MPEG1_VLD)
GUID_DUPLI(0x6f3ec719,0x3735,0x42cc,0x80,0x63,0x65,0xcc,0x3c,0xb3,0x66,0x16,DXVA2_ModeMPEG1_VLD)
GUID_ENTRY(0x6f66a9a0,0xbece,0x4ee8,0xb1,0x1b,0x99,0x0e,0xb3,0x8e,0xd9,0x76,IID_IDXGIOutputDWM)
GUID_ENTRY(0x6fbd02fb,0x209f,0x46c4,0xb0,0x59,0x2e,0xd1,0x55,0x86,0xa6,0xac,IID_ID3D11RasterizerState2)
GUID_ENTRY(0x705b9d82,0x76cf,0x49d6,0xb7,0xe6,0xac,0x88,0x72,0xdb,0x01,0x3c,D3D11_DECODER_PROFILE_H264_VLD_MULTIVIEW_NOFGT)
GUID_DUPLI(0x705b9d82,0x76cf,0x49d6,0xb7,0xe6,0xac,0x88,0x72,0xdb,0x01,0x3c,DXVA2_ModeH264_VLD_Multiview_NoFGT)
GUID_ENTRY(0x7116d91c,0xe7e4,0x47ce,0xb8,0xc6,0xec,0x81,0x68,0xf4,0x37,0xe5,IID_ID3D12CommandList)
GUID_ENTRY(0x71185722,0x246b,0x41f2,0xaa,0xd1,0x04,0x43,0xf7,0xf4,0xbf,0xc2,IID_IDCompositionTransform3D)
GUID_ENTRY(0x712bd56d,0x86ff,0x4b71,0x91,0xe1,0xc1,0x3b,0x27,0x4f,0xf2,0xa2,IID_CDXGIAdapter)
GUID_ENTRY(0x713f394e,0x92ca,0x47e7,0xab,0x81,0x11,0x59,0xc2,0x79,0x1e,0x54,IID_IDXGIFactoryDWM)
GUID_ENTRY(0x71417501,0x8df9,0x4e0a,0xa7,0x8a,0x25,0x5f,0x97,0x56,0xba,0xff,IID_ID3D10EffectStringVariable)
GUID_ENTRY(0x71fde914,0x40ef,0x45ef,0xbd,0x51,0x68,0xb0,0x37,0xc3,0x39,0xf9,IID_IDCompositionScaleTransform)
GUID_ENTRY(0x72755049,0x5ff7,0x435d,0x83,0x48,0x4b,0xe9,0x7c,0xfa,0x6c,0x7c,IID_IDWriteFontFileEnumerator)
GUID_ENTRY(0x727cad4e,0xd6af,0x4c9e,0x8a,0x08,0xd6,0x95,0xb1,0x1c,0xaa,0x49,IID_IDWriteFontFileLoader)
GUID_ENTRY(0x7385e5df,0x8fe8,0x41d5,0x86,0xb6,0xd7,0xb4,0x85,0x47,0xb6,0xcf,IID_IDirect3DDevice8)
GUID_ENTRY(0x739d886a,0xcef5,0x47dc,0x87,0x69,0x1a,0x8b,0x41,0xbe,0xbb,0xb0,IID_IDWriteFontFile)
GUID_ENTRY(0x75b68faa,0x347d,0x4159,0x8f,0x45,0xa0,0x64,0x0f,0x01,0xcd,0x9a,IID_ID3D11BlendState)
GUID_ENTRY(0x75f6468d,0x1b8e,0x447c,0x9b,0xc6,0x75,0xfe,0xa8,0x0b,0x5b,0x25,IID_IDCompositionDevice2)
GUID_ENTRY(0x765a30f3,0xf624,0x4c6f,0xa8,0x28,0xac,0xe9,0x48,0x62,0x24,0x45,IID_ID3D12PipelineState)
GUID_ENTRY(0x770aae78,0xf26f,0x4dba,0xa8,0x29,0x25,0x3c,0x83,0xd1,0xb3,0x87,IID_IDXGIFactory1)
GUID_ENTRY(0x77db970f,0x6276,0x48ba,0xba,0x28,0x07,0x01,0x43,0xb4,0x39,0x2c,IID_IDXGIDevice1)
GUID_ENTRY(0x790a45f7,0x0d42,0x4876,0x98,0x3a,0x0a,0x55,0xcf,0xe6,0xf4,0xaa,IID_IDXGISwapChain1)
GUID_ENTRY(0x791e8298,0x3ef3,0x4230,0x98,0x80,0xc9,0xbd,0xec,0xc4,0x20,0x64,IID_IDWriteBitmapRenderTarget1)
GUID_ENTRY(0x794950f2,0xadfc,0x458a,0x90,0x5e,0x10,0xa1,0x0b,0x0b,0x50,0x3b,IID_IDirect3DSwapChain9)
GUID_ENTRY(0x79aab587,0x6dbc,0x4fa7,0x82,0xde,0x37,0xfa,0x17,0x81,0xc5,0xce,IID_ID3DXEffectStateManager)
GUID_ENTRY(0x79cf2233,0x7536,0x4948,0x9d,0x36,0x1e,0x46,0x92,0xdc,0x57,0x60,IID_ID3D11Debug)
GUID_ENTRY(0x7a503555,0x4a83,0x11d1,0xa5,0xdb,0x00,0xa0,0xc9,0x03,0x67,0xf8,IID_IDirect3DVertexBuffer)
GUID_ENTRY(0x7b3b6153,0xa886,0x4544,0xab,0x37,0x65,0x37,0xc8,0x50,0x04,0x03,IID_ID3D11UnorderedAccessView1)
GUID_ENTRY(0x7b7166ec,0x21c7,0x44ae,0xb2,0x1a,0xc9,0xae,0x32,0x1a,0xe3,0x69,IID_IDXGIFactory)
GUID_ENTRY(0x7c9dd65e,0xd3f7,0x4529,0xac,0xee,0x78,0x58,0x30,0xac,0xde,0x35,IID_IDirect3DIndexBuffer9)
GUID_ENTRY(0x7d97dbf7,0xe085,0x42d4,0x81,0xe3,0x6a,0x88,0x3b,0xde,0xd1,0x18,IID_IDWriteGlyphRunAnalysis)
GUID_ENTRY(0x7ed943dd,0x52e8,0x40b5,0xa8,0xd8,0x76,0x68,0x5c,0x40,0x63,0x30,IID_ID3DX10BaseMesh)
GUID_DUPLI(0x7ed943dd,0x52e8,0x40b5,0xa8,0xd8,0x76,0x68,0x5c,0x40,0x63,0x30,IID_ID3DXBaseMesh)
GUID_ENTRY(0x7f9b00b3,0xf125,0x4890,0x87,0x6e,0x1c,0x42,0xbf,0x69,0x7c,0x4d,DXFILEOBJ_CompressedAnimationSet)
GUID_ENTRY(0x80849279,0xc799,0x4797,0x8c,0x33,0x04,0x07,0xa0,0x7d,0x9e,0x06,IID_ID3D10EffectShaderVariable)
GUID_ENTRY(0x80dad800,0xe21f,0x4e83,0x96,0xce,0xbf,0xcc,0xe5,0x00,0xdb,0x7c,IID_IDWriteTextAnalyzer1)
GUID_ENTRY(0x818a1105,0x7932,0x44f4,0xaa,0x86,0x08,0xae,0x7b,0x2f,0x2c,0x93,CLSID_D2D1SpotDiffuse)
GUID_ENTRY(0x81bdcbca,0x64d4,0x426d,0xae,0x8d,0xad,0x01,0x47,0xf4,0x27,0x5c,IID_IDirect3D9)
GUID_ENTRY(0x81c5b77b,0x13f8,0x4cdd,0xad,0x20,0xc8,0x90,0x54,0x7a,0xc6,0x5d,CLSID_D2D1Blend)
GUID_ENTRY(0x82237326,0x8111,0x4f7c,0xbc,0xf4,0xb5,0xc1,0x17,0x55,0x64,0xfe,IID_ID2D1GdiMetafileSink)
GUID_ENTRY(0x8337a8a6,0xa216,0x444a,0xb2,0xf4,0x31,0x47,0x33,0xa7,0x3a,0xea,IID_ID3D12ShaderReflectionVariable)
GUID_ENTRY(0x8339fde3,0x106f,0x47ab,0x83,0x73,0x1c,0x62,0x95,0xeb,0x10,0xb3,IID_IDWriteInlineObject)
GUID_ENTRY(0x838f01ec,0x9729,0x4527,0xaa,0xdb,0xdf,0x70,0xad,0xe7,0xfe,0xa9,IID_ID3DXTextureGutterHelper)
GUID_ENTRY(0x839d1216,0xbb2e,0x412b,0xb7,0xf4,0xa9,0xdb,0xeb,0xe0,0x8e,0xd1,IID_ID3D11View)
GUID_ENTRY(0x839ddca3,0x9b4e,0x41e4,0xb0,0x53,0x89,0x2b,0xd2,0xa1,0x1e,0xe7,D3D11_AUTHENTICATED_QUERY_OUTPUT_ID)
GUID_DUPLI(0x839ddca3,0x9b4e,0x41e4,0xb0,0x53,0x89,0x2b,0xd2,0xa1,0x1e,0xe7,D3DAUTHENTICATEDQUERY_OUTPUTID)
GUID_ENTRY(0x84e63de0,0x46aa,0x11cf,0x81,0x6f,0x00,0x00,0xc0,0x20,0x15,0x6e,IID_IDirect3DHALDevice)
GUID_ENTRY(0x85c31227,0x3de5,0x4f00,0x9b,0x3a,0xf1,0x1a,0xc3,0x8c,0x18,0xb5,IID_IDirect3DTexture9)
GUID_ENTRY(0x86695f12,0x340e,0x4f04,0x9f,0xd3,0x92,0x53,0xdd,0x32,0x74,0x60,D3D11_DECODER_PROFILE_MPEG2and1_VLD)
GUID_DUPLI(0x86695f12,0x340e,0x4f04,0x9f,0xd3,0x92,0x53,0xdd,0x32,0x74,0x60,DXVA2_ModeMPEG2and1_VLD)
GUID_ENTRY(0x8767df22,0xbacc,0x11d1,0x89,0x69,0x00,0xa0,0xc9,0x06,0x29,0xa8,IID_IDirect3DNullDevice)
GUID_ENTRY(0x881949a1,0xd6f3,0x11d0,0x89,0xab,0x00,0xa0,0xc9,0x05,0x41,0x29,IID_IDirect3DMMXDevice)
GUID_ENTRY(0x881db7d0,0xf7ee,0x4d4d,0xa6,0xd2,0x46,0x97,0xac,0xc6,0x6e,0xe8,CLSID_D2D1Histogram)
GUID_ENTRY(0x8875769a,0xd579,0x4088,0xaa,0xeb,0x53,0x4d,0x1a,0xd8,0x4e,0x96,IID_ID3DX10PMesh)
GUID_DUPLI(0x8875769a,0xd579,0x4088,0xaa,0xeb,0x53,0x4d,0x1a,0xd8,0x4e,0x96,IID_ID3DXPMesh)
GUID_ENTRY(0x89d6ac4f,0x09f2,0x4229,0xb2,0xcd,0x37,0x74,0x0a,0x6d,0xfd,0x81,D3D11_DECODER_ENCRYPTION_HW_CENC)
GUID_ENTRY(0x8a6bb301,0x7e7e,0x41f4,0xa8,0xe0,0x5b,0x32,0xf7,0xf9,0x9b,0x18,IID_IDXGIOutput3)
GUID_ENTRY(0x8aeeeac7,0x05f9,0x44d4,0xb5,0x91,0x00,0x0b,0x0d,0xf1,0xcb,0x95,IID_IDirect3DVertexBuffer8)
GUID_ENTRY(0x8ba5fb08,0x5195,0x40e2,0xac,0x58,0x0d,0x98,0x9c,0x3a,0x01,0x02,IID_ID3D10Blob)
GUID_DUPLI(0x8ba5fb08,0x5195,0x40e2,0xac,0x58,0x0d,0x98,0x9c,0x3a,0x01,0x02,IID_ID3DXBuffer)
GUID_ENTRY(0x8c3a39f0,0x916e,0x4690,0x80,0x4f,0x4c,0x80,0x01,0x35,0x5d,0x25,IID_IDirectXVideoProcessor)
GUID_ENTRY(0x8cea8d1e,0x77b0,0x4986,0xb3,0xb9,0x2f,0x0c,0x0e,0xae,0x78,0x87,CLSID_D2D1Brightness)
GUID_ENTRY(0x8d536ca1,0x0cca,0x4956,0xa8,0x37,0x78,0x69,0x63,0x75,0x55,0x84,IID_ID3D11ShaderReflection)
GUID_ENTRY(0x8e349d19,0x54db,0x4a56,0x9d,0xc9,0x11,0x9d,0x87,0xbd,0xb8,0x04,IID_ID3D12LibraryReflection)
GUID_ENTRY(0x8e5c6061,0x628a,0x4c8e,0x82,0x64,0xbb,0xe4,0x5c,0xb3,0xd5,0xdd,IID_ID3D11HullShader)
GUID_ENTRY(0x8efb471d,0x616c,0x4f49,0x90,0xf7,0x12,0x7b,0xb7,0x63,0xfa,0x51,IID_ID3D12DescriptorHeap)
GUID_ENTRY(0x8f0f30db,0x446a,0x4282,0x9f,0xa2,0x28,0xf7,0x5c,0x1f,0x39,0xad,IID_IDXGISwapChainDWM1)
GUID_ENTRY(0x905db94b,0xa00c,0x4140,0x9d,0xf5,0x2b,0x64,0xca,0x9e,0xa3,0x57,IID_ID3D12DeviceChild)
GUID_ENTRY(0x9064d822,0x80a7,0x465c,0xa9,0x86,0xdf,0x65,0xf7,0x8b,0x8f,0xeb,IID_IDWriteTextLayout1)
GUID_ENTRY(0x90866fcd,0x488e,0x454b,0xaf,0x06,0xe5,0x04,0x1b,0x66,0xc3,0x6c,CLSID_D2D1DiscreteTransfer)
GUID_ENTRY(0x90f732e2,0x5092,0x4606,0xa8,0x19,0x86,0x51,0x97,0x0b,0xac,0xcd,IID_ID2D1BoundsAdjustmentTransform)
GUID_ENTRY(0x91308b87,0x9040,0x411d,0x8c,0x67,0xc3,0x92,0x53,0xce,0x38,0x02,IID_ID3D11ShaderResourceView1)
GUID_ENTRY(0x913e2be4,0xfdcf,0x4fe2,0xa5,0xf0,0x24,0x54,0xf1,0x4f,0xf4,0x08,CLSID_D2D1Atlas)
GUID_ENTRY(0x91636d4b,0x9ba1,0x4532,0xaa,0xf7,0xe3,0x34,0x49,0x94,0xd7,0x88,IID_IDCompositionTranslateTransform3D)
GUID_ENTRY(0x917e0427,0xc61e,0x4a14,0x9c,0x64,0xaf,0xe6,0x5f,0x9e,0x98,0x44,DXFILEOBJ_PMAttributeRange)
GUID_ENTRY(0x91886caf,0x1c3d,0x4d2e,0xa0,0xab,0x3e,0x4c,0x7d,0x8d,0x33,0x03,IID_IDirect3DSwapChain9Ex)
GUID_ENTRY(0x921f03d6,0x641c,0x47df,0x85,0x2d,0xb4,0xbb,0x61,0x53,0xae,0x11,CLSID_D2D1ColorMatrix)
GUID_ENTRY(0x928c088b,0x76b9,0x4c6b,0xa5,0x36,0xa5,0x90,0x85,0x38,0x76,0xcd,IID_IDirect3DSwapChain8)
GUID_ENTRY(0x93281500,0x8cf8,0x11d0,0x89,0xab,0x00,0xa0,0xc9,0x05,0x41,0x29,IID_IDirect3DViewport2)
GUID_ENTRY(0x93281501,0x8cf8,0x11d0,0x89,0xab,0x00,0xa0,0xc9,0x05,0x41,0x29,IID_IDirect3DDevice2)
GUID_ENTRY(0x93281502,0x8cf8,0x11d0,0x89,0xab,0x00,0xa0,0xc9,0x05,0x41,0x29,IID_IDirect3DTexture2)
GUID_ENTRY(0x93281503,0x8cf8,0x11d0,0x89,0xab,0x00,0xa0,0xc9,0x05,0x41,0x29,IID_IDirect3DMaterial2)
GUID_ENTRY(0x94413cf4,0xa6fc,0x4248,0x8b,0x50,0x66,0x74,0x34,0x8f,0xca,0xd3,IID_IDWriteRenderingParams1)
GUID_ENTRY(0x94d99bdb,0xf1f8,0x4ab0,0xb2,0x36,0x7d,0xa0,0x17,0x0e,0xda,0xb1,IID_IDXGISwapChain3)
GUID_ENTRY(0x94f81a73,0x9212,0x4376,0x9c,0x58,0xb1,0x6a,0x3a,0x0d,0x39,0x92,IID_ID2D1Factory2)
GUID_ENTRY(0x9537ab04,0x3250,0x412e,0x82,0x13,0xfc,0xd2,0xf8,0x67,0x79,0x33,IID_ID3D10EffectPool)
GUID_DUPLI(0x9537ab04,0x3250,0x412e,0x82,0x13,0xfc,0xd2,0xf8,0x67,0x79,0x33,IID_ID3DXEffectPool)
GUID_ENTRY(0x9842ad7d,0xd9cf,0x4908,0xae,0xd7,0x48,0xb5,0x1d,0xa5,0xe7,0xc2,IID_IDCompositionRectangleClip)
GUID_ENTRY(0x99503cc1,0x66c7,0x45c9,0xa8,0x75,0x8a,0xd8,0xa7,0x91,0x44,0x01,CLSID_D2D1YCbCr)
GUID_ENTRY(0x9a1b41c3,0xd3bb,0x466a,0x87,0xfc,0xfe,0x67,0x55,0x6a,0x3b,0x65,IID_IDWriteFactory3)
GUID_ENTRY(0x9b32f9ad,0xbdcc,0x40a6,0xa3,0x9d,0xd5,0xc8,0x65,0x84,0x57,0x20,IID_ID3D11CryptoSession)
GUID_ENTRY(0x9b6bd711,0x4f74,0x41c9,0x9e,0x7b,0x0b,0xe2,0xd7,0xd9,0x3b,0x4f,D3D11_CRYPTO_TYPE_AES128_CTR)
GUID_DUPLI(0x9b6bd711,0x4f74,0x41c9,0x9e,0x7b,0x0b,0xe2,0xd7,0xd9,0x3b,0x4f,D3DCRYPTOTYPE_AES128_CTR)
GUID_ENTRY(0x9b7e4c00,0x342c,0x4106,0xa1,0x9f,0x4f,0x27,0x04,0xf6,0x89,0xf0,IID_ID3D10DeviceChild)
GUID_ENTRY(0x9b7e4c01,0x342c,0x4106,0xa1,0x9f,0x4f,0x27,0x04,0xf6,0x89,0xf0,IID_ID3D10Resource)
GUID_ENTRY(0x9b7e4c02,0x342c,0x4106,0xa1,0x9f,0x4f,0x27,0x04,0xf6,0x89,0xf0,IID_ID3D10Buffer)
GUID_ENTRY(0x9b7e4c03,0x342c,0x4106,0xa1,0x9f,0x4f,0x27,0x04,0xf6,0x89,0xf0,IID_ID3D10Texture1D)
GUID_ENTRY(0x9b7e4c04,0x342c,0x4106,0xa1,0x9f,0x4f,0x27,0x04,0xf6,0x89,0xf0,IID_ID3D10Texture2D)
GUID_ENTRY(0x9b7e4c05,0x342c,0x4106,0xa1,0x9f,0x4f,0x27,0x04,0xf6,0x89,0xf0,IID_ID3D10Texture3D)
GUID_ENTRY(0x9b7e4c07,0x342c,0x4106,0xa1,0x9f,0x4f,0x27,0x04,0xf6,0x89,0xf0,IID_ID3D10ShaderResourceView)
GUID_ENTRY(0x9b7e4c08,0x342c,0x4106,0xa1,0x9f,0x4f,0x27,0x04,0xf6,0x89,0xf0,IID_ID3D10RenderTargetView)
GUID_ENTRY(0x9b7e4c09,0x342c,0x4106,0xa1,0x9f,0x4f,0x27,0x04,0xf6,0x89,0xf0,IID_ID3D10DepthStencilView)
GUID_ENTRY(0x9b7e4c0a,0x342c,0x4106,0xa1,0x9f,0x4f,0x27,0x04,0xf6,0x89,0xf0,IID_ID3D10VertexShader)
GUID_ENTRY(0x9b7e4c0b,0x342c,0x4106,0xa1,0x9f,0x4f,0x27,0x04,0xf6,0x89,0xf0,IID_ID3D10InputLayout)
GUID_ENTRY(0x9b7e4c0c,0x342c,0x4106,0xa1,0x9f,0x4f,0x27,0x04,0xf6,0x89,0xf0,IID_ID3D10SamplerState)
GUID_ENTRY(0x9b7e4c0d,0x342c,0x4106,0xa1,0x9f,0x4f,0x27,0x04,0xf6,0x89,0xf0,IID_ID3D10Asynchronous)
GUID_ENTRY(0x9b7e4c0e,0x342c,0x4106,0xa1,0x9f,0x4f,0x27,0x04,0xf6,0x89,0xf0,IID_ID3D10Query)
GUID_ENTRY(0x9b7e4c0f,0x342c,0x4106,0xa1,0x9f,0x4f,0x27,0x04,0xf6,0x89,0xf0,IID_ID3D10Device)
GUID_ENTRY(0x9b7e4c10,0x342c,0x4106,0xa1,0x9f,0x4f,0x27,0x04,0xf6,0x89,0xf0,IID_ID3D10Predicate)
GUID_ENTRY(0x9b7e4c11,0x342c,0x4106,0xa1,0x9f,0x4f,0x27,0x04,0xf6,0x89,0xf0,IID_ID3D10Counter)
GUID_ENTRY(0x9b7e4c87,0x342c,0x4106,0xa1,0x9f,0x4f,0x27,0x04,0xf6,0x89,0xf0,IID_ID3D10ShaderResourceView1)
GUID_ENTRY(0x9b7e4c8f,0x342c,0x4106,0xa1,0x9f,0x4f,0x27,0x04,0xf6,0x89,0xf0,IID_ID3D10Device1)
GUID_ENTRY(0x9b7e4e00,0x342c,0x4106,0xa1,0x9f,0x4f,0x27,0x04,0xf6,0x89,0xf0,IID_ID3D10Multithread)
GUID_ENTRY(0x9b7e4e01,0x342c,0x4106,0xa1,0x9f,0x4f,0x27,0x04,0xf6,0x89,0xf0,IID_ID3D10Debug)
GUID_ENTRY(0x9b7e4e02,0x342c,0x4106,0xa1,0x9f,0x4f,0x27,0x04,0xf6,0x89,0xf0,IID_ID3D10SwitchToRef)
GUID_ENTRY(0x9b7e82e2,0x69c5,0x4eb4,0xa5,0xf5,0xa7,0x03,0x3f,0x51,0x32,0xcd,IID_IDCompositionTableTransferEffect)
GUID_ENTRY(0x9b8b1336,0x00a5,0x4668,0x92,0xb7,0xce,0xd5,0xd8,0xbf,0x9b,0x7b,IID_ID2D1VertexBuffer)
GUID_ENTRY(0x9bb4ab81,0xab1a,0x4d8f,0xb5,0x06,0xfc,0x04,0x20,0x0b,0x6e,0xe7,IID_ID3D11RasterizerState)
GUID_ENTRY(0x9c59509a,0x39bd,0x11d1,0x8c,0x4a,0x00,0xc0,0x4f,0xd9,0x30,0xc5,IID_IDirectDraw4)
GUID_ENTRY(0x9c906818,0x31d7,0x4fd3,0xa1,0x51,0x7c,0x5e,0x22,0x5d,0xb5,0x5a,IID_IDWriteTextFormat)
GUID_ENTRY(0x9d06dffa,0xd1e5,0x4d07,0x83,0xa8,0x1b,0xb1,0x23,0xf2,0xf8,0x41,IID_ID3D11Device2)
GUID_ENTRY(0x9d8e1289,0xd7b3,0x465f,0x81,0x26,0x25,0x0e,0x34,0x9a,0xf8,0x5d,IID_IDXGIKeyedMutex)
GUID_ENTRY(0x9daf9369,0x3846,0x4d0e,0xa4,0x4e,0x0c,0x60,0x79,0x34,0xa5,0xd7,CLSID_D2D1Scale)
GUID_ENTRY(0x9e415a43,0x7ba6,0x4a73,0x87,0x43,0xb7,0x3d,0x47,0xe8,0x84,0x76,DXFILEOBJ_AnimTicksPerSecond)
GUID_ENTRY(0x9eb576dd,0x9f77,0x4d86,0x81,0xaa,0x8b,0xab,0x5f,0xe4,0x90,0xe2,IID_ID3D11Predicate)
GUID_ENTRY(0x9eb767fd,0x4269,0x4467,0xb8,0xc2,0xeb,0x30,0xcb,0x30,0x57,0x43,IID_ID2D1CommandSink1)
GUID_ENTRY(0x9fdac92a,0x1876,0x48c3,0xaf,0xad,0x25,0xb9,0x4f,0x84,0xa9,0xb6,IID_ID3D11DepthStencilView)
GUID_ENTRY(0xa048285e,0x25a9,0x4527,0xbd,0x93,0xd6,0x8b,0x68,0xc4,0x42,0x54,IID_ID3D11VideoProcessorOutputView)
GUID_ENTRY(0xa04bfb29,0x08ef,0x43d6,0xa4,0x9c,0xa9,0xbd,0xbd,0xcb,0xe6,0x86,IID_ID3D11Device1)
GUID_ENTRY(0xa05c8c37,0xd2c6,0x4732,0xb3,0xa0,0x9c,0xe0,0xb0,0xdc,0x9a,0xe6,IID_ID3D11Device3)
GUID_ENTRY(0xa08debda,0x3258,0x4fa4,0x9f,0x16,0x91,0x74,0xd3,0xfe,0x93,0xb1,IID_IDCompositionSaturationEffect)
GUID_ENTRY(0xa0cade0f,0x06d5,0x4cf4,0xa1,0xc7,0xf3,0xcd,0xd7,0x25,0xaa,0x75,IID_IDirect3DDeviceManager9)
GUID_ENTRY(0xa16907d7,0xbc02,0x4801,0x99,0xe8,0x8c,0xf7,0xf4,0x85,0xf7,0x74,IID_ID2D1GeometryRealization)
GUID_ENTRY(0xa1a3c64a,0x224f,0x4a81,0x97,0x73,0x4f,0x03,0xa8,0x9d,0x3c,0x6c,IID_IDCompositionDeviceDebug)
GUID_ENTRY(0xa2296057,0xea42,0x4099,0x98,0x3b,0x53,0x9f,0xb6,0x50,0x54,0x26,IID_ID2D1Bitmap)
GUID_ENTRY(0xa248fd3f,0x3e6c,0x4e63,0x9f,0x03,0x7f,0x68,0xec,0xc9,0x1d,0xb9,IID_ID2D1EffectImpl)
GUID_ENTRY(0xa24bc4d1,0x769e,0x43f7,0x80,0x13,0x98,0xff,0x56,0x6c,0x18,0xe2,IID_ID3D11CommandList)
GUID_ENTRY(0xa2a07292,0x89af,0x4345,0xbe,0x2e,0xc5,0x3d,0x9f,0xbb,0x6e,0x9f,IID_ID3D10RasterizerState)
GUID_ENTRY(0xa3eb5d44,0xfc22,0x429d,0x9a,0xfb,0x32,0x21,0xcb,0x97,0x19,0xa6,DXFILEOBJ_Patch)
GUID_ENTRY(0xa4665c60,0x2673,0x11cf,0xa3,0x1a,0x00,0xaa,0x00,0xb9,0x33,0x56,IID_IDirect3DRGBDevice)
GUID_ENTRY(0xa64c844a,0xe282,0x4756,0x8b,0x80,0x25,0x0c,0xde,0x04,0x39,0x8c,DXFILEOBJ_FaceAdjacency)
GUID_ENTRY(0xa6a55bda,0xc09c,0x49f3,0x91,0x93,0xa4,0x19,0x22,0xc8,0x97,0x15,IID_IDCompositionTurbulenceEffect)
GUID_ENTRY(0xa6cd7faa,0xb0b7,0x4a2f,0x94,0x36,0x86,0x62,0xa6,0x57,0x97,0xcb,IID_ID3D11ClassInstance)
GUID_ENTRY(0xa71efdb4,0x9fdb,0x4838,0xad,0x90,0xcf,0xc3,0xbe,0x8c,0x3d,0xaf,IID_IDWriteFontFace1)
GUID_ENTRY(0xa758d465,0xfe8d,0x45ad,0x9c,0xf0,0xd0,0x1e,0x56,0x26,0x6a,0x07,IID_ID3DXPRTCompBuffer)
GUID_ENTRY(0xa7929a74,0xe6b2,0x4bd6,0x8b,0x95,0x40,0x40,0x11,0x9c,0xa3,0x4d,IID_IDCompositionEffectGroup)
GUID_ENTRY(0xa7f026da,0xa5f8,0x4487,0xa5,0x64,0x15,0xe3,0x43,0x57,0x65,0x1e,IID_ID3D11VideoContext1)
GUID_ENTRY(0xa84cee02,0x3eea,0x4eee,0xa8,0x27,0x87,0xc1,0xa0,0x2a,0x0f,0xcc,IID_IDWriteFontCollection)
GUID_ENTRY(0xa84eb584,0xc495,0x48aa,0xb9,0x4d,0x8b,0xd2,0xd6,0xfb,0xce,0x05,D3D11_AUTHENTICATED_QUERY_PROTECTION)
GUID_DUPLI(0xa84eb584,0xc495,0x48aa,0xb9,0x4d,0x8b,0xd2,0xd6,0xfb,0xce,0x05,D3DAUTHENTICATEDQUERY_PROTECTION)
GUID_ENTRY(0xa898a84c,0x3873,0x4588,0xb0,0x8b,0xeb,0xbf,0x97,0x8d,0xf0,0x41,IID_ID2D1Bitmap1)
GUID_ENTRY(0xa8be2ac4,0x199f,0x4946,0xb3,0x31,0x79,0x59,0x9f,0xb9,0x8d,0xe7,IID_IDXGISwapChain2)
GUID_ENTRY(0xa915128c,0xd954,0x4c79,0xbf,0xe1,0x64,0xdb,0x92,0x31,0x94,0xd6,IID_ID3DX11SegmentedScan)
GUID_ENTRY(0xab3c758f,0x093e,0x4356,0xb7,0x62,0x4d,0xb1,0x8f,0x1b,0x3a,0x01,IID_ID3DXConstantTable)
GUID_ENTRY(0xab4e9afd,0x1d1c,0x46e6,0xa7,0x2f,0x08,0x69,0x91,0x7b,0x0d,0xe8,D3DCRYPTOTYPE_PROPRIETARY)
GUID_ENTRY(0xab998b5b,0x4258,0x44a9,0x9f,0xeb,0x94,0xe5,0x97,0xa6,0xba,0xae,D3D11_DECODER_PROFILE_MPEG4PT2_VLD_ADVSIMPLE_GMC)
GUID_DUPLI(0xab998b5b,0x4258,0x44a9,0x9f,0xeb,0x94,0xe5,0x97,0xa6,0xba,0xae,DXVA2_ModeMPEG4pt2_VLD_AdvSimple_GMC)
GUID_ENTRY(0xaba496dd,0xb617,0x4cb8,0xa8,0x66,0xbc,0x44,0xd7,0xeb,0x1f,0xa2,IID_IDXGISurface2)
GUID_ENTRY(0xac8948ec,0xf86d,0x43e2,0x96,0xde,0x31,0xfc,0x35,0xf9,0x6d,0x9e,IID_ID3DXAnimationController)
GUID_ENTRY(0xacd16696,0x8c14,0x4f5d,0x87,0x7e,0xfe,0x3f,0xc1,0xd3,0x27,0x37,IID_IDWriteFont)
GUID_ENTRY(0xacd16696,0x8c14,0x4f5d,0x87,0x7e,0xfe,0x3f,0xc1,0xd3,0x27,0x38,IID_IDWriteFont1)
GUID_ENTRY(0xad47c8fd,0x63ef,0x4acc,0x9b,0x51,0x67,0x97,0x9c,0x03,0x6c,0x06,CLSID_D2D1LinearTransfer)
GUID_ENTRY(0xae02eedb,0xc735,0x4690,0x8d,0x52,0x5a,0x8d,0xc2,0x02,0x13,0xaa,IID_IDXGIOutput)
GUID_ENTRY(0xae1572f4,0x5dd0,0x4777,0x99,0x8b,0x92,0x79,0x47,0x2a,0xe6,0x3b,IID_ID2D1GradientStopCollection1)
GUID_ENTRY(0xae471c51,0x5f53,0x4a24,0x8d,0x3e,0xd0,0xc3,0x9c,0x30,0xb3,0xf0,IID_IDCompositionVirtualSurface)
GUID_ENTRY(0xae897105,0x00e6,0x45bf,0xbb,0x8e,0x28,0x1d,0xd6,0xdb,0x8e,0x1b,IID_ID3D10EffectVariable)
GUID_ENTRY(0xaec22fb8,0x76f3,0x4639,0x9b,0xe0,0x28,0xeb,0x43,0xa6,0x7a,0x2e,IID_IDXGIObject)
GUID_ENTRY(0xaf482368,0x330a,0x46a5,0x9a,0x5c,0x01,0xc7,0x1a,0xf2,0x4c,0x8d,IID_ID3D10EffectDepthStencilVariable)
GUID_ENTRY(0xb02d7a1a,0x05e0,0x4a71,0x8e,0xf4,0x5c,0x5b,0xbf,0x47,0x50,0x86,IID_IDXGISwapChainXAML)
GUID_ENTRY(0xb06fe5b9,0x43ec,0x4393,0x88,0x1b,0xdb,0xe4,0xdc,0x72,0xfd,0xa7,IID_IDWriteFontDownloadListener)
GUID_ENTRY(0xb0784138,0x3b76,0x4bc5,0xb1,0x3b,0x0f,0xa2,0xad,0x02,0x65,0x9f,CLSID_D2D1Tile)
GUID_ENTRY(0xb07c4fe5,0x310d,0x4ba8,0xa2,0x3c,0x4f,0x0f,0x20,0x6f,0x21,0x8b,IID_IDirect3DStateBlock9)
GUID_ENTRY(0xb0ab3b60,0x33d7,0x11d1,0xa9,0x81,0x00,0xc0,0x4f,0xd7,0xb1,0x74,IID_IDirect3DDevice3)
GUID_ENTRY(0xb0ab3b61,0x33d7,0x11d1,0xa9,0x81,0x00,0xc0,0x4f,0xd7,0xb1,0x74,IID_IDirect3DViewport3)
GUID_ENTRY(0xb0d941a0,0x85e7,0x4d8b,0x9f,0xd3,0x5c,0xed,0x99,0x34,0x48,0x2a,IID_IDWriteTextAnalysisSink1)
GUID_ENTRY(0xb0e06fe0,0x8192,0x4e1a,0xb1,0xca,0x36,0xd7,0x41,0x47,0x10,0xb2,IID_ID3D11ShaderResourceView)
GUID_ENTRY(0xb1170d8a,0x628d,0x4da3,0xad,0x3b,0x82,0xdd,0xb0,0x8b,0x49,0x70,D3D11_KEY_EXCHANGE_HW_PROTECTION)
GUID_ENTRY(0xb18b10ce,0x2649,0x405a,0x87,0x0f,0x95,0xf7,0x77,0xd4,0x31,0x3a,IID_IDirect3DDevice9Ex)
GUID_ENTRY(0xb2d9f3ec,0xc9fe,0x4a11,0xa2,0xec,0xd8,0x62,0x08,0xf7,0xc0,0xa2,IID_IDWriteLocalFontFileLoader)
GUID_ENTRY(0xb2daad8b,0x03d4,0x4dbf,0x95,0xeb,0x32,0xab,0x4b,0x63,0xd0,0xab,IID_ID3DUserDefinedAnnotation)
GUID_ENTRY(0xb2efe1e7,0x729f,0x4102,0x94,0x9f,0x50,0x5f,0xa2,0x1b,0xf6,0x66,IID_ID2D1TransformNode)
GUID_ENTRY(0xb30f7066,0x203c,0x4b07,0x93,0xfc,0xce,0xaa,0xfd,0x61,0x24,0x1e,D3D11_AUTHENTICATED_QUERY_ENCRYPTION_WHEN_ACCESSIBLE_GUID_COUNT)
GUID_DUPLI(0xb30f7066,0x203c,0x4b07,0x93,0xfc,0xce,0xaa,0xfd,0x61,0x24,0x1e,D3DAUTHENTICATEDQUERY_ENCRYPTIONWHENACCESSIBLEGUIDCOUNT)
GUID_ENTRY(0xb3a6f3e0,0x2b43,0x11cf,0xa2,0xde,0x00,0xaa,0x00,0xb9,0x33,0x56,IID_IDirectDraw2)
GUID_ENTRY(0xb3f7a938,0x4c93,0x4310,0xa6,0x75,0xb3,0x0d,0x6d,0xe5,0x05,0x53,IID_ID3DX11FFT)
GUID_ENTRY(0xb4211cfa,0x51b9,0x4a9f,0xab,0x78,0xdb,0x99,0xb2,0xbb,0x67,0x8e,IID_IDirect3DBaseTexture8)
GUID_ENTRY(0xb4e3c01d,0xe79e,0x4637,0x91,0xb2,0x51,0x0e,0x9f,0x4c,0x9b,0x8f,IID_ID3D11DeviceContext3)
GUID_ENTRY(0xb4f34a19,0x2383,0x4d76,0x94,0xf6,0xec,0x34,0x36,0x57,0xc3,0xdc,IID_ID2D1CommandList)
GUID_ENTRY(0xb64bb1b5,0xfd70,0x4df6,0xbf,0x91,0x19,0xd0,0xa1,0x24,0x55,0xe3,IID_IDirect3DVertexBuffer9)
GUID_ENTRY(0xb6c3e656,0xec8b,0x4b92,0x9b,0x62,0x68,0x16,0x59,0x52,0x29,0x47,DXFILEOBJ_PMInfo)
GUID_ENTRY(0xb6e70a0e,0x8ef9,0x4e83,0x94,0xad,0xec,0xc8,0xb0,0xc0,0x48,0x97,DXFILEOBJ_FVFData)
GUID_ENTRY(0xb71e6052,0x5aea,0x4fa3,0x83,0x2e,0xf6,0x0d,0x43,0x1f,0x7e,0x91,IID_IDWriteFontDownloadQueue)
GUID_ENTRY(0xb7924baa,0x391b,0x412a,0x8c,0x5c,0xe4,0x4c,0xc2,0xd8,0x67,0xdc,IID_IDWriteRenderingParams3)
GUID_ENTRY(0xb79cc8da,0x337f,0x400f,0xb0,0x9d,0xb2,0xed,0xf8,0xa8,0x4e,0x47,IID_ID2DPrivateInfo)
GUID_ENTRY(0xb7e6163e,0x7f46,0x43b4,0x84,0xb3,0xe4,0xe6,0x24,0x9c,0x36,0x5d,IID_IDWriteTextAnalyzer)
GUID_ENTRY(0xb7f916dd,0xdb3b,0x49c1,0x84,0xd7,0xe4,0x5e,0xf9,0x9e,0xc7,0x26,IID_IDirectXVideoMemoryConfiguration)
GUID_ENTRY(0xb859ee5a,0xd838,0x4b5b,0xa2,0xe8,0x1a,0xdc,0x7d,0x93,0xdb,0x48,IID_IDWriteFactory)
GUID_ENTRY(0xb8d65549,0xd7c9,0x4995,0x89,0xcf,0x53,0xa9,0xa8,0xb0,0x31,0xe3,DXFILEOBJ_VertexDuplicationIndices)
GUID_ENTRY(0xb96eebca,0xb326,0x4ea5,0x88,0x2f,0x2f,0xf5,0xba,0xe0,0x21,0xdd,IID_IDirect3DSurface8)
GUID_ENTRY(0xb9e303c3,0xc08c,0x4f91,0x8b,0x7b,0x38,0x65,0x6b,0xc4,0x8c,0x20,CLSID_D2D1PointDiffuse)
GUID_ENTRY(0xb9ec94e1,0xb9a6,0x4251,0xba,0x18,0x94,0x89,0x3f,0x02,0xc0,0xea,DXFILEOBJ_PatchMesh9)
GUID_ENTRY(0xba0b762d,0x7d28,0x43ec,0xb9,0xdc,0x2f,0x84,0x44,0x3b,0x06,0x14,IID_ID3DXSprite)
GUID_ENTRY(0xba0b762d,0x8d28,0x43ec,0xb9,0xdc,0x2f,0x84,0x44,0x3b,0x06,0x14,IID_ID3DX10Sprite)
GUID_ENTRY(0xbb12d362,0xdaee,0x4b9a,0xaa,0x1d,0x14,0xba,0x40,0x1c,0xfa,0x1f,IID_ID2D1Factory1)
GUID_ENTRY(0xbb223240,0xe72b,0x11d0,0xa9,0xb4,0x00,0xaa,0x00,0xc0,0x99,0x3e,IID_IDirect3D3)
GUID_ENTRY(0xbb2c6faa,0xb5fb,0x4082,0x8e,0x6b,0x38,0x8b,0x8c,0xfa,0x90,0xe1,IID_ID3D11DeviceContext1)
GUID_ENTRY(0xbb8a4953,0x2c99,0x4f5a,0x96,0xf5,0x48,0x19,0x02,0x7f,0xa3,0xac,IID_IDCompositionSurface)
GUID_ENTRY(0xbc1b18a5,0xb1fb,0x42ab,0xbd,0x94,0xb5,0x82,0x8b,0x4b,0xf7,0xbe,D3D11_AUTHENTICATED_QUERY_CHANNEL_TYPE)
GUID_DUPLI(0xbc1b18a5,0xb1fb,0x42ab,0xbd,0x94,0xb5,0x82,0x8b,0x4b,0xf7,0xbe,D3DAUTHENTICATEDQUERY_CHANNELTYPE)
GUID_ENTRY(0xbd7349f5,0x14f1,0x42e4,0x9c,0x79,0x97,0x23,0x80,0xdb,0x40,0xc0,IID_IDirect3DVolume8)
GUID_ENTRY(0xbf22ad00,0x03ea,0x4690,0x80,0x77,0x47,0x33,0x46,0x20,0x9b,0x7e,D3D11_DECODER_PROFILE_MPEG2_IDCT)
GUID_DUPLI(0xbf22ad00,0x03ea,0x4690,0x80,0x77,0x47,0x33,0x46,0x20,0x9b,0x7e,DXVA2_ModeMPEG2_IDCT)
GUID_ENTRY(0xbf22e553,0x292c,0x4781,0x9f,0xea,0x62,0xbd,0x55,0x4b,0xdd,0x93,DXFILEOBJ_DeclData)
GUID_ENTRY(0xc0a7157b,0xd872,0x4b1d,0x80,0x73,0xef,0xc2,0xac,0xd4,0xb1,0xfc,IID_ID3D10EffectShaderResourceVariable)
GUID_ENTRY(0xc0bfa96c,0xe089,0x44fb,0x8e,0xaf,0x26,0xf8,0x79,0x61,0x90,0xda,IID_ID3D11DeviceContext)
GUID_ENTRY(0xc0c5fda1,0x8899,0x4194,0xb1,0xf6,0x54,0x3c,0x6d,0x2e,0xd3,0x14,IID_IDXGIDeviceDWM)
GUID_ENTRY(0xc1170a22,0x3ce2,0x4966,0x90,0xd4,0x55,0x40,0x8b,0xfc,0x84,0xc4,IID_IDCompositionColorMatrixEffect)
GUID_ENTRY(0xc1949895,0xd72a,0x4a1d,0x8e,0x5d,0xed,0x85,0x7d,0x17,0x15,0x20,D3D11_KEY_EXCHANGE_RSAES_OAEP)
GUID_DUPLI(0xc1949895,0xd72a,0x4a1d,0x8e,0x5d,0xed,0x85,0x7d,0x17,0x15,0x20,D3DKEYEXCHANGE_RSAES_OAEP)
GUID_ENTRY(0xc2844d0b,0x3d86,0x46e7,0x85,0xba,0x52,0x6c,0x92,0x40,0xf3,0xfb,CLSID_D2D13DPerspectiveTransform)
GUID_ENTRY(0xc2931aea,0x2a85,0x4f20,0x86,0x0f,0xfb,0xa1,0xfd,0x25,0x6e,0x18,IID_ID3D11VideoDecoderOutputView)
GUID_ENTRY(0xc3457783,0xa846,0x47ce,0x95,0x20,0xce,0xa6,0xf6,0x6e,0x74,0x47,IID_ID3D10ShaderReflection1)
GUID_ENTRY(0xc36a797c,0xec80,0x4f0a,0x89,0x85,0xa7,0xb2,0x47,0x50,0x82,0xd1,IID_ID3D12CommandSignature)
GUID_ENTRY(0xc37ea93a,0xe7aa,0x450d,0xb1,0x6f,0x97,0x46,0xcb,0x04,0x07,0xf3,IID_IDCompositionDevice)
GUID_ENTRY(0xc40a00f2,0xb93a,0x4d80,0xae,0x8c,0x5a,0x1c,0x63,0x4f,0x58,0xe4,IID_IMFSample)
GUID_ENTRY(0xc4fec28f,0x7966,0x4e95,0x9f,0x94,0xf4,0x31,0xcb,0x56,0xc3,0xb8,IID_ID3D12Object)
GUID_ENTRY(0xc530ad7d,0x9b16,0x4395,0xa9,0x79,0xba,0x2e,0xcf,0xf8,0x3a,0xdd,IID_ID3D10ShaderReflectionType)
GUID_ENTRY(0xc54a6b66,0x72df,0x4ee8,0x8b,0xe5,0xa9,0x46,0xa1,0x42,0x92,0x14,IID_ID3D12RootSignature)
GUID_ENTRY(0xc59598b4,0x48b3,0x4869,0xb9,0xb1,0xb1,0x61,0x8b,0x14,0xa8,0xb7,IID_ID3D12ShaderReflectionConstantBuffer)
GUID_ENTRY(0xc5a05f0c,0x16f2,0x4adf,0x9f,0x4d,0xa8,0xc4,0xd5,0x8a,0xc5,0x50,IID_IDXGIDebug1)
GUID_ENTRY(0xc67ea361,0x1863,0x4e69,0x89,0xdb,0x69,0x5d,0x3e,0x9a,0x5b,0x6b,CLSID_D2D1Shadow)
GUID_ENTRY(0xc7885ba7,0xf990,0x4fe7,0x92,0x2d,0x85,0x15,0xe4,0x77,0xdd,0x85,IID_ID3DXMatrixStack)
GUID_ENTRY(0xc902b03f,0x60a7,0x49ba,0x99,0x36,0x2a,0x3a,0xb3,0x7a,0x7e,0x33,IID_ID3D10View)
GUID_DUPLI(0xc93fecfa,0x6967,0x478a,0xab,0xbc,0x40,0x2d,0x90,0x62,0x1f,0xcb,IID_ID3DX10ThreadPump)
GUID_ENTRY(0xc93fecfa,0x6967,0x478a,0xab,0xbc,0x40,0x2d,0x90,0x62,0x1f,0xcb,IID_ID3DX11ThreadPump)
GUID_ENTRY(0xca9c46f4,0xd3c5,0x11d1,0xb7,0x5a,0x00,0x60,0x08,0x52,0xb3,0x12,IID_IDirect3DMaterial3)
GUID_ENTRY(0xcac701ee,0x80fc,0x4122,0x82,0x42,0x10,0xb3,0x9c,0x8c,0xec,0x34,IID_ID3D11Module)
GUID_ENTRY(0xcafcb56c,0x6ac3,0x4889,0xbf,0x47,0x9e,0x23,0xbb,0xd2,0x60,0xec,IID_IDXGISurface)
GUID_ENTRY(0xcbfd91d9,0x51b2,0x45e4,0xb3,0xde,0xd1,0x9c,0xcf,0xb8,0x63,0xc5,IID_IDCompositionAnimation)
GUID_ENTRY(0xcc86fabe,0xda55,0x401d,0x85,0xe7,0xe3,0xc9,0xde,0x28,0x77,0xe9,IID_ID3D11BlendState1)
GUID_ENTRY(0xcca920e4,0x52f0,0x492b,0xbf,0xa8,0x29,0xc7,0x2e,0xe0,0xa4,0x68,IID_IDWriteFontCollectionLoader)
GUID_ENTRY(0xcef08cf9,0x7b4f,0x4429,0x96,0x24,0x2a,0x69,0x0a,0x93,0x32,0x01,IID_ID3DXFile)
GUID_ENTRY(0xcef08cfa,0x7b4f,0x4429,0x96,0x24,0x2a,0x69,0x0a,0x93,0x32,0x01,IID_ID3DXFileSaveObject)
GUID_ENTRY(0xcef08cfb,0x7b4f,0x4429,0x96,0x24,0x2a,0x69,0x0a,0x93,0x32,0x01,IID_ID3DXFileSaveData)
GUID_ENTRY(0xcef08cfc,0x7b4f,0x4429,0x96,0x24,0x2a,0x69,0x0a,0x93,0x32,0x01,IID_ID3DXFileEnumObject)
GUID_ENTRY(0xcef08cfd,0x7b4f,0x4429,0x96,0x24,0x2a,0x69,0x0a,0x93,0x32,0x01,IID_ID3DXFileData)
GUID_ENTRY(0xcf2bb6ae,0x889a,0x4ad7,0xba,0x29,0xa2,0xfd,0x73,0x2c,0x9f,0xc9,CLSID_D2D1Turbulence)
GUID_ENTRY(0xcf59a98c,0xa950,0x4326,0x91,0xef,0x9b,0xba,0xa1,0x7b,0xfd,0x95,DXGI_DEBUG_D3D12)
GUID_ENTRY(0xcfee3140,0x1157,0x47ca,0x8b,0x85,0x31,0xbf,0xcf,0x3f,0x2d,0x0e,IID_IDWriteStringList)
GUID_ENTRY(0xd0149dc0,0x90e8,0x4ec8,0x81,0x44,0xe9,0x00,0xad,0x26,0x6b,0xb2,WKPDID_CommentStringW)
GUID_ENTRY(0xd0223b96,0xbf7a,0x43fd,0x92,0xbd,0xa4,0x3b,0x0d,0x82,0xb9,0xeb,IID_IDirect3DDevice9)
GUID_ENTRY(0xd02c95cc,0xedba,0x4305,0x9b,0x5d,0x18,0x20,0xd7,0x70,0x4b,0xbf,DXFILEOBJ_PatchMesh)
GUID_ENTRY(0xd21768e1,0x23a4,0x4823,0xa1,0x4b,0x7c,0x3e,0xba,0x85,0xd6,0x58,IID_ID2D1Device1)
GUID_ENTRY(0xd31fbe17,0xf157,0x41a2,0x8d,0x24,0xcb,0x77,0x9e,0x05,0x60,0xe8,IID_IDWriteColorGlyphRunEnumerator)
GUID_ENTRY(0xd379ba7f,0x9042,0x4ac4,0x9f,0x5e,0x58,0x19,0x2a,0x4c,0x6b,0xd8,IID_ID3DXLine)
GUID_ENTRY(0xd37d7598,0x09be,0x4222,0xa2,0x36,0x20,0x81,0x34,0x1c,0xc1,0xf2,IID_IDWriteFontFace3)
GUID_ENTRY(0xd37f57e4,0x6908,0x459f,0xa1,0x99,0xe7,0x2f,0x24,0xf7,0x99,0x87,IID_ID2D1DeviceContext1)
GUID_ENTRY(0xd3e0e934,0x22a0,0x427e,0xaa,0xe4,0x7d,0x95,0x74,0xb5,0x9d,0xb1,IID_IDWriteTextRenderer1)
GUID_ENTRY(0xd40e20b6,0xf8f7,0x42ad,0xab,0x20,0x4b,0xaf,0x8f,0x15,0xdf,0xaa,IID_ID3D10ShaderReflection)
GUID_ENTRY(0xd55b097e,0xbdb6,0x4c52,0xb0,0x3d,0x60,0x51,0xc8,0x9d,0x0e,0x42,DXFILEOBJ_EffectString)
GUID_ENTRY(0xd5f04ff9,0x3418,0x45d8,0x95,0x61,0x32,0xa7,0x6a,0xae,0x2d,0xdd,D3D11_DECODER_PROFILE_H264_VLD_WITHFMOASO_NOFGT)
GUID_DUPLI(0xd5f04ff9,0x3418,0x45d8,0x95,0x61,0x32,0xa7,0x6a,0xae,0x2d,0xdd,DXVA2_ModeH264_VLD_WithFMOASO_NoFGT)
GUID_ENTRY(0xd67441c7,0x672a,0x476f,0x9e,0x82,0xcd,0x55,0xb4,0x49,0x49,0xce,IID_IDXGIInfoQueue)
GUID_ENTRY(0xd6c00747,0x87b7,0x425e,0xb8,0x4d,0x44,0xd1,0x08,0x56,0x0a,0xfd,IID_ID3D11Query)
GUID_ENTRY(0xd722fb4d,0x7a68,0x437a,0xb2,0x0c,0x58,0x04,0xee,0x24,0x94,0xa6,GUID_DeviceType)
GUID_ENTRY(0xd79be8da,0x0cf1,0x4c81,0xb8,0x2a,0x69,0xa4,0xe2,0x36,0xf4,0x3d,D3D11_DECODER_PROFILE_H264_VLD_STEREO_PROGRESSIVE_NOFGT)
GUID_DUPLI(0xd79be8da,0x0cf1,0x4c81,0xb8,0x2a,0x69,0xa4,0xe2,0x36,0xf4,0x3d,DXVA2_ModeH264_VLD_Stereo_Progressive_NoFGT)
GUID_ENTRY(0xd79dbb70,0x5f21,0x4d36,0xbb,0xc2,0xff,0x52,0x5c,0x21,0x3c,0xdc,IID_ID3DX10Font)
GUID_DUPLI(0xd79dbb70,0x5f21,0x4d36,0xbb,0xc2,0xff,0x52,0x5c,0x21,0x3c,0xdc,IID_ID3DXFont)
GUID_ENTRY(0xd7b70ee0,0x4340,0x11cf,0xb0,0x63,0x00,0x20,0xaf,0xc2,0xcd,0x35,CLSID_DirectDraw)
GUID_ENTRY(0xd80dd70c,0x8d2f,0x4751,0x94,0xa1,0x03,0xc7,0x9b,0x35,0x56,0xdb,IID_ID3D11LinkingNode)
GUID_ENTRY(0xd8b768ff,0x64bc,0x4e66,0x98,0x2b,0xec,0x8e,0x87,0xf6,0x93,0xf7,IID_IDWriteFontFace2)
GUID_ENTRY(0xd8f5b23f,0xd429,0x4a91,0xb5,0x5a,0xd2,0xf4,0x5f,0xd7,0x5b,0x18,IID_IDCompositionRotateTransform3D)
GUID_ENTRY(0xd9771460,0xa695,0x4f26,0xbb,0xd3,0x27,0xb8,0x40,0xb5,0x41,0xcc,IID_IDirect3DQuery9)
GUID_ENTRY(0xda044e00,0x69b2,0x11d0,0xa1,0xd5,0x00,0xaa,0x00,0xb8,0xdf,0xbb,IID_IDirectDrawSurface3)
GUID_ENTRY(0xda20d8ef,0x812a,0x4c43,0x98,0x02,0x62,0xec,0x4a,0xbd,0x7a,0xdd,IID_IDWriteFontFamily)
GUID_ENTRY(0xda20d8ef,0x812a,0x4c43,0x98,0x02,0x62,0xec,0x4a,0xbd,0x7a,0xde,IID_IDWriteFontList1)
GUID_ENTRY(0xda20d8ef,0x812a,0x4c43,0x98,0x02,0x62,0xec,0x4a,0xbd,0x7a,0xdf,IID_IDWriteFontFamily1)
GUID_ENTRY(0xda6fea51,0x564c,0x4487,0x98,0x10,0xf0,0xd0,0xf9,0xb4,0xe3,0xa5,IID_ID3D11SamplerState)
GUID_ENTRY(0xdb122ce8,0xd1c9,0x4292,0xb2,0x37,0x24,0xed,0x3d,0xe8,0xb1,0x75,IID_ID3D10EffectTechnique)
GUID_ENTRY(0xdb1800dd,0x0c34,0x4cf9,0xbe,0x90,0x31,0xcc,0x0a,0x56,0x53,0xe1,IID_ID2D1SourceTransform)
GUID_ENTRY(0xdb6f6ddb,0xac77,0x4e88,0x82,0x53,0x81,0x9d,0xf9,0xbb,0xf1,0x40,IID_ID3D11Device)
GUID_ENTRY(0xdc7dca35,0x2196,0x414d,0x9f,0x53,0x61,0x78,0x84,0x03,0x2a,0x60,IID_IDXGIOutput4)
GUID_ENTRY(0xdc8e63f3,0xd12b,0x4952,0xb4,0x7b,0x5e,0x45,0x02,0x6a,0x86,0x2d,IID_ID3D11Resource)
GUID_ENTRY(0xdd13c59c,0x36fa,0x4098,0xa8,0xfb,0xc7,0xed,0x39,0xdc,0x85,0x46,IID_IDirect3DVertexDeclaration9)
GUID_ENTRY(0xdd95b90b,0xf05f,0x4f6a,0xbd,0x65,0x25,0xbf,0xb2,0x64,0xbd,0x84,IID_IDXGISwapChainMedia)
GUID_ENTRY(0xddf57cba,0x9543,0x46e4,0xa1,0x2b,0xf2,0x07,0xa0,0xfe,0x7f,0xed,IID_ID3D11ClassLinkage)
GUID_ENTRY(0xdfdba067,0x0b8d,0x4865,0x87,0x5b,0xd7,0xb4,0x51,0x6c,0xc1,0x64,IID_ID3D11RenderTargetView)
GUID_ENTRY(0xe0db51c3,0x6f77,0x4bae,0xb3,0xd5,0xe4,0x75,0x09,0xb3,0x58,0x38,IID_ID2D1GdiInteropRenderTarget)
GUID_ENTRY(0xe13963bc,0xae51,0x4c5d,0xb0,0x0f,0xcf,0xa3,0xa9,0xd9,0x7c,0xe5,DXFILEOBJ_EffectParamDWord)
GUID_ENTRY(0xe23f7110,0x0e9a,0x4324,0xaf,0x47,0x6a,0x2c,0x0c,0x46,0xf3,0x5b,CLSID_D2D1Crop)
GUID_ENTRY(0xe331f7e4,0x0559,0x4cc2,0x8e,0x99,0x1c,0xec,0x16,0x57,0x92,0x8f,DXFILEOBJ_EffectInstance)
GUID_ENTRY(0xe334bc12,0x3937,0x4e02,0x85,0xeb,0xfc,0xf4,0xeb,0x30,0xd2,0xc8,IID_IDCompositionSurfaceFactory)
GUID_ENTRY(0xe4819ddc,0x4cf0,0x4025,0xbd,0x26,0x5d,0xe8,0x2a,0x3e,0x07,0xb7,IID_ID3D11InputLayout)
GUID_ENTRY(0xe48ae283,0xda80,0x490b,0x87,0xe6,0x43,0xe9,0xa9,0xcf,0xda,0x08,DXGI_DEBUG_ALL)
GUID_ENTRY(0xe4a36723,0xfdfe,0x4b22,0xb1,0x46,0x3c,0x04,0xc0,0x7f,0x4c,0xc8,IID_HelperName)
GUID_ENTRY(0xe4cdd575,0x2866,0x4f01,0xb1,0x2e,0x7e,0xec,0xe1,0xec,0x93,0x58,IID_IDirect3DTexture8)
GUID_ENTRY(0xe57aa735,0xdcdb,0x4c72,0x9c,0x61,0x05,0x91,0xf5,0x88,0x89,0xee,IID_IDCompositionSkewTransform)
GUID_ENTRY(0xe6078b20,0x5ee1,0x44ce,0x85,0x8a,0x0a,0x9e,0xcf,0x2f,0x26,0x81,IID_ID3D11DebugTest)
GUID_ENTRY(0xe6a9f44b,0x61b0,0x4563,0x9e,0xa4,0x63,0xd2,0xa3,0xc6,0xfe,0x66,D3D11_DECODER_PROFILE_MPEG2_MOCOMP)
GUID_DUPLI(0xe6a9f44b,0x61b0,0x4563,0x9e,0xa4,0x63,0xd2,0xa3,0xc6,0xfe,0x66,DXVA2_ModeMPEG2_MoComp)
GUID_ENTRY(0xe8467b04,0xec61,0x4b8a,0xb5,0xde,0xd4,0xd7,0x3d,0xeb,0xea,0x5a,CLSID_D2D13DTransform)
GUID_ENTRY(0xe8de1639,0x4331,0x4b26,0xbc,0x5f,0x6a,0x32,0x1d,0x34,0x7a,0x85,IID_IDCompositionVisual2)
GUID_ENTRY(0xe8f7fe7a,0x191c,0x466d,0xad,0x95,0x97,0x56,0x78,0xbd,0xa9,0x98,IID_ID2D1DeviceContext)
GUID_ENTRY(0xe913c351,0x783d,0x48ca,0xa1,0xd1,0x4f,0x30,0x62,0x84,0xad,0x56,IID_ID3D12ShaderReflectionType)
GUID_ENTRY(0xea82e40d,0x51dc,0x4f33,0x93,0xd4,0xdb,0x7c,0x91,0x25,0xae,0x8c,IID_ID3D11PixelShader)
GUID_ENTRY(0xea9dbf1a,0xc88e,0x4486,0x85,0x4a,0x98,0xaa,0x01,0x38,0xf3,0x0c,IID_IDXGIDisplayControl)
GUID_ENTRY(0xeacdd04c,0x117e,0x4e17,0x88,0xf4,0xd1,0xb1,0x2b,0x0e,0x3d,0x89,IID_IDCompositionTarget)
GUID_ENTRY(0xeae6c40d,0x626a,0x4c2d,0xbf,0xcb,0x39,0x10,0x01,0xab,0xe2,0x02,CLSID_D2D1Morphology)
GUID_ENTRY(0xeaf3a2da,0xecf4,0x4d24,0xb6,0x44,0xb3,0x4f,0x68,0x42,0x02,0x4b,IID_IDWritePixelSnapping)
GUID_ENTRY(0xeb62d63d,0x93dd,0x4318,0x8a,0xe8,0xc6,0xf8,0x3a,0xd3,0x71,0xb8,IID_ID3D11ShaderReflectionConstantBuffer)
GUID_ENTRY(0xec1791c7,0xdad3,0x4f15,0x9e,0xc3,0xfa,0xa9,0x3d,0x60,0xd4,0xf0,D3D11_AUTHENTICATED_QUERY_CURRENT_ENCRYPTION_WHEN_ACCESSIBLE)
GUID_DUPLI(0xec1791c7,0xdad3,0x4f15,0x9e,0xc3,0xfa,0xa9,0x3d,0x60,0xd4,0xf0,D3DAUTHENTICATEDQUERY_CURRENTENCRYPTIONWHENACCESSIBLE)
GUID_ENTRY(0xec1c539d,0x8cff,0x4e2a,0xbc,0xc4,0xf5,0x69,0x2f,0x99,0xf4,0x80,D3D11_AUTHENTICATED_QUERY_DEVICE_HANDLE)
GUID_DUPLI(0xec1c539d,0x8cff,0x4e2a,0xbc,0xc4,0xf5,0x69,0x2f,0x99,0xf4,0x80,D3DAUTHENTICATEDQUERY_DEVICEHANDLE)
GUID_ENTRY(0xec25f42d,0x7006,0x4f2b,0xb3,0x3e,0x02,0xcc,0x33,0x75,0x73,0x3f,IID_ID3D12FunctionParameterReflection)
GUID_ENTRY(0xec81b08f,0xbfcb,0x4e8d,0xb1,0x93,0xa9,0x15,0x58,0x79,0x99,0xe8,IID_IDCompositionEffect)
GUID_ENTRY(0xed418a9f,0x010d,0x4eda,0x9a,0xe3,0x9a,0x65,0x35,0x8d,0x8d,0x2e,D3D11_DECODER_PROFILE_MPEG4PT2_VLD_ADVSIMPLE_NOGMC)
GUID_DUPLI(0xed418a9f,0x010d,0x4eda,0x9a,0xe3,0x9a,0x65,0x35,0x8d,0x8d,0x2e,DXVA2_ModeMPEG4pt2_VLD_AdvSimple_NoGMC)
GUID_ENTRY(0xedad8d19,0x8a35,0x4d6d,0x85,0x66,0x2e,0xa2,0x76,0xcd,0xe1,0x61,IID_ID3D10BlendState)
GUID_ENTRY(0xedad8d99,0x8a35,0x4d6d,0x85,0x66,0x2e,0xa2,0x76,0xcd,0xe1,0x61,IID_ID3D10BlendState1)
GUID_ENTRY(0xedae421e,0x7654,0x4a37,0x9d,0xb8,0x71,0xac,0xc1,0xbe,0xb3,0xc1,CLSID_D2D1SpotSpecular)
GUID_ENTRY(0xedc48364,0x0417,0x4111,0x94,0x50,0x43,0x84,0x5f,0xa9,0xf8,0x90,CLSID_D2D1DisplacementMap)
GUID_ENTRY(0xee27417f,0x5e28,0x4e65,0xbe,0xea,0x1d,0x26,0xb5,0x08,0xad,0xc9,D3D11_DECODER_PROFILE_MPEG2_VLD)
GUID_DUPLI(0xee27417f,0x5e28,0x4e65,0xbe,0xea,0x1d,0x26,0xb5,0x08,0xad,0xc9,DXVA2_ModeMPEG2_VLD)
GUID_ENTRY(0xef1a287d,0x342a,0x4f76,0x8f,0xdb,0xda,0x0d,0x6e,0xa9,0xf9,0x2b,IID_ID2D1Transform)
GUID_ENTRY(0xef8a8135,0x5cc6,0x45fe,0x88,0x25,0xc5,0xa0,0x72,0x4e,0xb8,0x19,IID_IDWriteTextRenderer)
GUID_ENTRY(0xefa008f9,0xf7a1,0x48bf,0xb0,0x5c,0xf2,0x24,0x71,0x3c,0xc0,0xff,IID_IDWriteFontFallback)
GUID_ENTRY(0xefc5557e,0x6265,0x4613,0x8a,0x94,0x43,0x85,0x78,0x89,0xeb,0x36,IID_IDirect3DVertexShader9)
GUID_ENTRY(0xefd64d74,0xc9e8,0x41d7,0xa5,0xe9,0xe9,0xb0,0xe3,0x9f,0xa3,0x19,D3D11_DECODER_PROFILE_MPEG4PT2_VLD_SIMPLE)
GUID_DUPLI(0xefd64d74,0xc9e8,0x41d7,0xa5,0xe9,0xe9,0xb0,0xe3,0x9f,0xa3,0x19,DXVA2_ModeMPEG4pt2_VLD_Simple)
GUID_ENTRY(0xf13ebcd1,0x672c,0x4f8b,0xa6,0x31,0x95,0x39,0xca,0x74,0x8d,0x71,IID_IWarpPrivateAPI)
GUID_ENTRY(0xf1827e47,0x00a8,0x49cd,0x90,0x8c,0x9d,0x11,0x95,0x5f,0x87,0x28,IID_ID3DXPRTBuffer)
GUID_ENTRY(0xf1cfe2b3,0x0de3,0x4e28,0xaf,0xa1,0x15,0x5a,0x75,0x0a,0x28,0x2d,DXFILEOBJ_EffectFloats)
GUID_ENTRY(0xf2086b20,0x259f,0x11cf,0xa3,0x1a,0x00,0xaa,0x00,0xb9,0x33,0x56,IID_IDirect3DRampDevice)
GUID_ENTRY(0xf2b0810a,0xfd00,0x43c9,0x91,0x8c,0xdf,0x94,0xe2,0xd8,0xef,0x7d,IID_IDirectXVideoDecoder)
GUID_ENTRY(0xf5049e77,0x4861,0x11d2,0xa4,0x07,0x00,0xa0,0xc9,0x06,0x29,0xa8,IID_IDirect3D7)
GUID_ENTRY(0xf5049e78,0x4861,0x11d2,0xa4,0x07,0x00,0xa0,0xc9,0x06,0x29,0xa8,IID_IDirect3DTnLHalDevice)
GUID_ENTRY(0xf5049e79,0x4861,0x11d2,0xa4,0x07,0x00,0xa0,0xc9,0x06,0x29,0xa8,IID_IDirect3DDevice7)
GUID_ENTRY(0xf5049e7d,0x4861,0x11d2,0xa4,0x07,0x00,0xa0,0xc9,0x06,0x29,0xa8,IID_IDirect3DVertexBuffer7)
GUID_ENTRY(0xf582c508,0x0f36,0x490c,0x99,0x77,0x31,0xee,0xce,0x26,0x8c,0xfa,IID_ID3D11DomainShader)
GUID_ENTRY(0xf67e0edd,0x9e3d,0x4ecc,0x8c,0x32,0x41,0x83,0x25,0x3d,0xfe,0x70,IID_IDWriteTextFormat2)
GUID_ENTRY(0xf69f223b,0x45d3,0x4aa0,0x98,0xc8,0xc4,0x0c,0x2b,0x23,0x10,0x29,IID_IDXGISwapChainDWM)
GUID_ENTRY(0xf6ceb4b3,0x4e4c,0x40dd,0xb8,0x83,0x8d,0x8d,0xe5,0xea,0x0c,0xd5,IID_ID3DXEffect)
GUID_ENTRY(0xf752461c,0x1e23,0x48f6,0xb9,0xf8,0x83,0x50,0x85,0x0f,0x33,0x6f,DXFILEOBJ_VertexElement)
GUID_ENTRY(0xf83a5958,0xe986,0x4bda,0xbe,0xb0,0x41,0x1f,0x6a,0x7a,0x01,0xb7,D3D11_AUTHENTICATED_QUERY_ENCRYPTION_WHEN_ACCESSIBLE_GUID)
GUID_DUPLI(0xf83a5958,0xe986,0x4bda,0xbe,0xb0,0x41,0x1f,0x6a,0x7a,0x01,0xb7,D3DAUTHENTICATEDQUERY_ENCRYPTIONWHENACCESSIBLEGUID)
GUID_ENTRY(0xf898b024,0xb5c8,0x42cd,0xa1,0x4f,0xac,0x5a,0xdb,0xf4,0xbe,0x22,IID_IDXGIDeviceXAML)
GUID_ENTRY(0xf8fb5c27,0xc6b3,0x4f75,0xa4,0xc8,0x43,0x9a,0xf2,0xef,0x56,0x4c,IID_ID3D11Texture1D)
GUID_ENTRY(0xf9aaccbb,0xc2b6,0x4cfc,0x87,0x79,0x57,0x07,0xb1,0x76,0x05,0x52,D3D11_DECODER_PROFILE_H264_VLD_STEREO_NOFGT)
GUID_DUPLI(0xf9aaccbb,0xc2b6,0x4cfc,0x87,0x79,0x57,0x07,0xb1,0x76,0x05,0x52,DXVA2_ModeH264_VLD_Stereo_NoFGT)
GUID_ENTRY(0xf9d711c3,0x9777,0x40ae,0x87,0xe8,0x3e,0x5a,0xf9,0xbf,0x09,0x48,IID_IDWriteRenderingParams2)
GUID_ENTRY(0xfa0ab799,0x7a9c,0x48ca,0x8c,0x5b,0x23,0x7e,0x71,0xa5,0x44,0x34,IID_IDirect3DCryptoSession9)
GUID_ENTRY(0xfa4e8e3a,0x9786,0x407d,0x8b,0x4c,0x59,0x95,0x89,0x37,0x64,0xaf,IID_ID3DXKeyframedAnimationSet)
GUID_ENTRY(0xfb3a8e1a,0x2e3c,0x4de1,0x84,0x42,0x40,0x43,0xe0,0xb0,0x94,0x95,_D2D_INTERNAL_DEVICE_CREATION_OPTIONS)
GUID_ENTRY(0xfb9ac489,0xad8d,0x41ed,0x99,0x99,0xbb,0x63,0x47,0xd1,0x10,0xf7,CLSID_D2D1UnPremultiply)
GUID_ENTRY(0xfc151437,0x049a,0x4784,0xa2,0x4a,0xf1,0xc4,0xda,0xf2,0x09,0x87,CLSID_D2D1ArithmeticComposite)
GUID_ENTRY(0xfc51a550,0xd5e7,0x11d9,0xaf,0x55,0x00,0x05,0x4e,0x43,0xff,0x02,IID_IDirectXVideoAccelerationService)
GUID_ENTRY(0xfc51a551,0xd5e7,0x11d9,0xaf,0x55,0x00,0x05,0x4e,0x43,0xff,0x02,IID_IDirectXVideoDecoderService)
GUID_ENTRY(0xfc51a552,0xd5e7,0x11d9,0xaf,0x55,0x00,0x05,0x4e,0x43,0xff,0x02,IID_IDirectXVideoProcessorService)
GUID_ENTRY(0xfd55faa7,0x37e0,0x4c20,0x95,0xd2,0x9b,0xe4,0x5b,0xc3,0x3f,0x55,IID_IDCompositionTransform)
GUID_ENTRY(0xfd882d06,0x8aba,0x4fb8,0xb8,0x49,0x8b,0xe8,0xb7,0x3e,0x14,0xde,IID_IDWriteFontFallbackBuilder)
GUID_ENTRY(0xfe9e984d,0x3f95,0x407c,0xb5,0xdb,0xcb,0x94,0xd4,0xe8,0xf8,0x7c,IID_ID2D1ImageBrush)
GUID_ENTRY(0xfed2b808,0x5eb4,0x43a0,0xae,0xa3,0x35,0xf6,0x52,0x80,0xf9,0x1b,IID_IDCompositionVisualDebug)
GUID_ENTRY(0xff24beee,0xda21,0x4beb,0x98,0xb5,0xd2,0xf8,0x99,0xf9,0x8a,0xf9,IID_IDirect3DAuthenticatedChannel9)
GUID_ENTRY(0xffbe2e23,0xf011,0x418a,0xac,0x56,0x5c,0xee,0xd7,0xc5,0xb9,0x4b,IID_ID3D11RenderTargetView1)
GUID_ENTRY(0xfff32f81,0xd953,0x473a,0x92,0x23,0x93,0xd6,0x52,0xab,0xa9,0x3f,IID_IDirect3DCubeTexture9)


#undef GUID_ENTRY
#undef GUID_DUPLI
