#include "apachetop.h"

/* string to hash map, and vice versa; for quick string lookups */

extern Circle *c;
extern time_t now;

int map::create(int passed_size)
{
	size = passed_size;

	tab = (struct hash_struct *)malloc(size * sizeof(struct hash_struct));

	/* initialise map to be empty */
	this->empty(0, size);

	/* a hash for quick string lookups */
	tab_hash = new OAHash;
	tab_hash->create(size*9);
	
	return 0;
}

void map::empty(int from, int to)
{
	int x;
	struct hash_struct *ptr;

	for(ptr = &tab[from], x = from; x < to; ++ptr, ++x)
	{
		ptr->pos = x;
		ptr->string = NULL;
		ptr->time = 0;
	}

	return;
}

int map::destroy(void)
{
	free(tab);

	tab_hash->destroy();
	delete tab_hash;

	return 0;
}

int map::resize(int newsize)
{
	int x;
	struct hash_struct *newtab;

	/* we have to resize the tab, then clear the hash, remake the hash
	 * at the newsize*5, then re-populate the hash. Remaking the hash is
	 * quite expensive, so we'd like to do this as infrequently as
	 * possible */
	newtab = (struct hash_struct *)
	    realloc(tab, newsize * sizeof(struct hash_struct));
	
	/* did it work? */
	if (!newtab)
	{
		perror("realloc map");
		exit(1);
	}

	tab = newtab;

	/* empty the new area */
	this->empty(size, newsize);

	delete tab_hash;

	/* remake the hash since memory addresses will have moved */
	tab_hash = new OAHash;
	tab_hash->create(newsize*9);
	for (x = 0 ; x < size ; ++x)
	{
		tab_hash->insert(tab[x].string, &tab[x]);
	}

	size = newsize;

	return 0;
}

int map::insert(char *string)
{
	int x; 
	struct hash_struct *ptr;
	time_t oldest = c->oldest();

	/* find free table slot FIXME make this more efficient */
	for (ptr = &tab[0], x = 0; x <= size; ++ptr, ++x)
	{
		if (x == size)
		{
			/* none free, make room */
			this->resize(size * 2);

			/* realloc may well move the table in
			 * memory so update the pointer */
			ptr = &tab[x];

			break;
		}

		if (ptr->time == 0)
			break;

		/* "free" = older than the oldest entry in the circular
		 * table; any string thats indexed but not referenced to is no
		 * use, so we re-use the slot
		 */
		if (ptr->time < oldest)
			break;
	}

	/* if we are re-using, free up the old data */
	if (ptr->string)
	{
	//	this->remove(ptr->string);
		tab_hash->remove(ptr->string);
		free(ptr->string);
	}

	/* make entry in our table */
	ptr->time = now;
	ptr->string = strdup(string);

	/* add into hash */
	tab_hash->insert(ptr->string, ptr);

	return x;
}

int map::remove(char *string)
{
	struct hash_struct *ptr;

	/* find string in hash */
	if ((ptr = (struct hash_struct *)tab_hash->lookup(string)))
	{
		/* remove from table */
		free(ptr->string);
		ptr->string = NULL;
		ptr->time = 0;

		/* remove from hash */
		tab_hash->remove(string);
	}

	return 0;
}

int map::lookup(char *string)
{
	struct hash_struct *ptr;

	if ((ptr = (struct hash_struct *)tab_hash->lookup(string)))
	{
		ptr->time = now; /* touch it, so insert won't remove */
		return ptr->pos;
	}

	return -1;
}

char *map::reverse(int pos)
{
	/* return pointer to char for this string pos */
	return tab[pos].string;
}
