/*
 * anypaper.c
 * This file is part of anyPaper
 *
 * Copyright (C) 2008 - Sergio Rodrigues de Oliveira Filho 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * "You should have received a copy of the GNU General Public License 
 * along with this program.  If not, see http://www.gnu.org/licenses/.
 */

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include "config.h"
#include "image.h"
#include "variables.h"

static int state = 0;
static GSource *source = NULL;
#define WINDOW_FULLSCREEN_TIMEOUT 5
#define WINDOW_FULLSCREEN_STATE 1
#define WINDOW_NORMAL_STATE 0
#define DELTA 30

static void timeout_destroy (GSource *source)
{
	if (source != NULL) {
		g_source_destroy (source);
	}
	source = NULL;
}

static gboolean fullscreen_timeout_cb (gpointer data)
{
	GtkWidget *hbox = GTK_WIDGET (data);

	gtk_widget_hide (hbox);

	timeout_destroy (source);

	return FALSE;
}

static void image_fullscreen ( GtkWidget *widget, gpointer data)
{
	GtkWidget *window;

	window = GTK_WIDGET (data);

	if (state == WINDOW_NORMAL_STATE) gtk_window_fullscreen (GTK_WINDOW(window));
	if (state == WINDOW_FULLSCREEN_STATE)
	{
		timeout_destroy(source);
		gtk_window_unfullscreen (GTK_WINDOW(window));
	}
}

static void image_fullscreen_button ( GtkWidget *widget, gpointer data)
{
	GtkWidget *button, *image_button, *hbox;

	hbox = GTK_WIDGET (data);
	button = widget;

	if (state == WINDOW_NORMAL_STATE)
	{
		gtk_button_set_label (GTK_BUTTON(button), GTK_STOCK_LEAVE_FULLSCREEN);
		image_button = gtk_button_get_image (GTK_BUTTON(button));
		gtk_image_set_from_stock (GTK_IMAGE(image_button), GTK_STOCK_LEAVE_FULLSCREEN, GTK_ICON_SIZE_BUTTON);
		gtk_widget_show(image_button);gtk_widget_hide(hbox);
		state = WINDOW_FULLSCREEN_STATE;
	}
	else
	{
		gtk_button_set_label (GTK_BUTTON(button), GTK_STOCK_FULLSCREEN);
		image_button = gtk_button_get_image (GTK_BUTTON(button));
		gtk_image_set_from_stock (GTK_IMAGE(image_button), GTK_STOCK_FULLSCREEN, GTK_ICON_SIZE_BUTTON);
		gtk_widget_show(image_button);gtk_widget_show(hbox);
		state = WINDOW_NORMAL_STATE;
	}
}

static gboolean mouse_motion (GtkWidget *widget, GdkEventMotion *event, gpointer user_data)
{
	GtkWidget *hbox;

	hbox = GTK_WIDGET (user_data);

	if (!GTK_WIDGET_VISIBLE (hbox)) gtk_widget_show(hbox);

	if (state == WINDOW_FULLSCREEN_STATE)
	{

		timeout_destroy(source);

		source = g_timeout_source_new_seconds (WINDOW_FULLSCREEN_TIMEOUT);
		g_source_set_callback (source, fullscreen_timeout_cb, hbox, NULL);
	
		g_source_attach (source, NULL);
	}
}

static gboolean window_key_press (GtkWidget *widget, GdkEventKey *event, gpointer user_data)
{
	GtkWidget *button;

	button = GTK_WIDGET (user_data);

	switch (event->keyval)
	{
		case GDK_Escape:
			{
				if (state == 1)	gtk_widget_activate(GTK_WIDGET(button));
				else gtk_object_destroy(GTK_OBJECT(widget));
				timeout_destroy(source);
			}
		break;
	}
}

static void show_preview_quit ( GtkWidget *widget, gpointer data )
{
	GtkWidget *window;

	window = GTK_WIDGET (data);
	timeout_destroy(source);
	gtk_object_destroy(GTK_OBJECT(window));
}

void show_preview_window ( GtkWidget *widget, gpointer data )
{
	GtkWidget *window, *window2, *event_box;
	GtkWidget *fixed, *hbox;
	GtkWidget *image, *button, *image_button;
	GdkScreen *screen;
	int screen_width, screen_height;

	screen = gdk_screen_get_default();
	screen_width = gdk_screen_get_width(screen);
	screen_height = gdk_screen_get_height(screen);

	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_widget_add_events (GTK_WIDGET (window), GDK_KEY_PRESS_MASK);

	window2 = gtk_scrolled_window_new(NULL, NULL);
	gtk_window_set_title(GTK_WINDOW(window), "preview");

	fixed = gtk_vbox_new(FALSE, 0);

	event_box = gtk_event_box_new ();
	gtk_widget_show (event_box);

	image = gtk_image_new_from_pixbuf(pixbuf); 
	gtk_container_add (GTK_CONTAINER (event_box), image);
	gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW(window2), event_box);
	gtk_widget_add_events (GTK_WIDGET (event_box), GDK_POINTER_MOTION_MASK);
	gtk_box_pack_start (GTK_BOX(fixed), window2, TRUE, TRUE, 2);

	hbox = gtk_hbox_new(FALSE, 0);

	button = gtk_button_new_from_stock (GTK_STOCK_CLOSE);
	image_button = gtk_image_new_from_stock (GTK_STOCK_CLOSE, GTK_ICON_SIZE_BUTTON);
	gtk_button_set_image (GTK_BUTTON(button), image_button);
	gtk_widget_show(image_button);
	g_signal_connect (G_OBJECT (button), "clicked",	G_CALLBACK (show_preview_quit), G_OBJECT(window));
	gtk_box_pack_end (GTK_BOX(hbox), button, FALSE, FALSE, 2);

	button = gtk_button_new_from_stock (GTK_STOCK_FULLSCREEN);
	image_button = gtk_image_new_from_stock (GTK_STOCK_FULLSCREEN, GTK_ICON_SIZE_BUTTON);
	gtk_button_set_image (GTK_BUTTON(button), image_button);
	gtk_widget_show(image_button);
	g_signal_connect (G_OBJECT (button), "clicked",	G_CALLBACK (image_fullscreen), G_OBJECT(window));
	g_signal_connect_after (G_OBJECT (button), "clicked",	G_CALLBACK (image_fullscreen_button), G_OBJECT(hbox));
	gtk_box_pack_start (GTK_BOX(hbox), button, FALSE, FALSE, 2);

	gtk_box_pack_end (GTK_BOX(fixed), hbox, FALSE, FALSE, 2);
	gtk_container_add(GTK_CONTAINER(window), fixed);

	g_signal_connect (G_OBJECT (window), "key-press-event", G_CALLBACK (window_key_press), G_OBJECT(button));
	g_signal_connect (G_OBJECT (event_box), "motion-notify-event", G_CALLBACK (mouse_motion), G_OBJECT(hbox));

	gtk_widget_show_all(window);
	gtk_window_resize(GTK_WINDOW(window), MIN (screen_width/2, (window->allocation.width - window2->allocation.width + screenw + DELTA)), MIN (screen_height/2, (window->allocation.height - window2->allocation.height + screenh + DELTA)));
}

