/* Copyright (C) 2002, 2003, 2004 Jan Wedekind.
   This file is part of the recipe database application AnyMeal.

   AnyMeal is free software; you can redistribute it and/or modify it under
   the terms of the GNU GENERAL PUBLIC LICENSE as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   AnyMeal is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTIBILITY or FITNESS
   FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
   details.

   You should have received a copy of the GNU General Public License along
   with AnyMeal; if not, contact one of the authors of this software. */
#ifndef __UNITMAP_HPP
#define __UNITMAP_HPP

#include <map>
#include <string>
#include <qstringlist.h>

/** Create an unit map.
    Creates a map, which maps unit-names on the abbreviations, which
    are used for representation in the mealmaster file-format.
    @return Map for mapping unit-names of the current language to mealmaster's
    abbreviations.
    @date Sat Feb 05 2005
    @author Jan Wedekind (wedesoft@users.sourceforge.net) */
std::map< std::string, std::string > createUnitMap(void);

/** Create an inverse unit map.
    Creates a map, which maps mealmaster's unit-abbreviations on unit-names.
    @return Map for mapping unit-abbreviations to unit-names in the current
    language.
    @date Sat Feb 05 2005
    @author Jan Wedekind (wedesoft@users.sourceforge.net) */
std::map< std::string, std::string > createInverseUnitMap(void);

/** Method for creating list of unit names.
    Creates a list for Qt, which contains the allowed units.
    @return List of unit names in the current language.
    @date Sat Feb 05 2005
    @author Jan Wedekind (wedesoft@users.sourceforge.net) */
QStringList createUnitStringList(void);


#endif
