/* Copyright (C) 2006 Jan Wedekind.
   This file is part of the recipe database application AnyMeal.

   AnyMeal is free software; you can redistribute it and/or modify it under
   the terms of the GNU GENERAL PUBLIC LICENSE as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   AnyMeal is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTIBILITY or FITNESS
   FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
   details.

   You should have received a copy of the GNU General Public License along
   with AnyMeal; if not, contact one of the authors of this software. */
#ifndef __RECODER_HPP
#define __RECODER_HPP

#include <stdio.h>
#ifndef __RECODE_H
#define __RECODE_H
#include <recodext.h>
#endif
#include "config.h"
#include "compiler.hpp"

/** @addtogroup compilers
    @{ */

/// Global variable for recode library.
extern const char *program_name;

/** Character recoding.
    Compiler using the recode library to perform a character recoding.
    Before instantiating this class, the global variable for the recode
    library has to be initialised:
    \verbatim
    Recoder::outer = recode_new_outer( false );
    ERRORMACRO( Recoder::outer != NULL, Error, ,
                "Failure initialising recoder library." );
    \endverbatim
    When terminating, the destructing function has to be called:
    \verbatim
    if ( Recoder::outer != NULL ) {
      recoder_delete_outer( Recoder::outer );
      Recoder::outer = NULL;
    };
    \endverbatim
    @date Thu Jan 10 2006
    @author Jan Wedekind (wedesoft@users.sourceforge.net) */
class Recoder: public Compiler
{
 public:
  /// Constructor
  Recoder( const std::string &_request ) throw (Error);
  /// Destructor
  virtual ~Recoder(void);
  ///
  virtual void translate( std::istream &inputStream,
                          std::ostream &outputStream ) const
    throw (Error);
  ///
  static RECODE_OUTER outer;
 protected:
  ///
  RECODE_REQUEST request;
};

///
typedef boost::shared_ptr< Recoder > RecoderPtr;

///@}

#endif
