/* Copyright (C) 2002, 2003, 2004 Jan Wedekind.
   This file is part of the recipe database application AnyMeal.

   AnyMeal is free software; you can redistribute it and/or modify it under
   the terms of the GNU GENERAL PUBLIC LICENSE as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   AnyMeal is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTIBILITY or FITNESS
   FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
   details.

   You should have received a copy of the GNU General Public License along
   with AnyMeal; if not, contact one of the authors of this software. */
#ifndef __DATABASE_HPP
#define __DATABASE_HPP

#include "include.hpp"
#include <boost/smart_ptr.hpp>
#include "error.hpp"
#include "server.hpp"
#include "statement.hpp"

/** @addtogroup mysqlCpp
    @{ */
/** Abstract class for accessing databases.
    @date Thu Mar 03 2005
    @author Jan Wedekind (wedesoft@users.sourceforge.net) */
class Database: public Object
{
public:
  /** Constructor.
      The user name is just copied to the member variable.
      @param _server Server object. */
  Database( ServerPtr _server ): server( _server ) {}
  /** Execute single query.
      The returned \c Statement object allows requesting the
      results of the query. */
  virtual StatementPtr execQuery( const std::string &query )
    throw (Error) = 0;
  /// Execute list of queries.
  void execScript( const std::string &script ) throw (Error);
  /// Execute list of queries.
  void execScript( std::istream &stream ) throw (Error);
  /// Get server object.
  ServerPtr getServer(void) const { return server; }
protected:
  ///
  ServerPtr server;
};

/// Smart-Pointer referencing a database-object.
typedef boost::shared_ptr< Database > DatabasePtr;

///@}

#endif
