/*  cvs_gui.c (c) Johannes Schmid 2002
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <time.h>

#include "cvs_gui.h"
#include "cvs_cbs.h"
#include "anjuta.h"

/* Lables for server types */
gchar *server_types[4] =
	{ N_("Local"), N_("Password"), N_("Extern(rsh)"), N_("Server") };

/* Utility:
	Get the filename of the current open file from aneditor.
	Do not free return string!
*/

static gchar* get_cur_filename()
{
	TextEditor *te = anjuta_get_current_text_editor ();
	if (te == NULL || te->full_filename == NULL)
		return "";
	else
		return te->full_filename;
}

/* 
	Create a dialog in which a filename can be specified.
	If the user clicks the Update/Commit/Status button cvs is invoked.
	Default for the filename is the current open file.
*/
void
create_cvs_gui (CVS *cvs, int dialog_type, gchar* filename, gboolean is_project)
{
	gchar *title;
	gchar *button_label;

	GtkWidget *label_file;
	GtkWidget *label_branch;
	GtkWidget *label_msg;
	GtkWidget *label_misc = NULL;
	GtkWidget *table;
	GtkWidget *gtkentry;
	GtkWidget *text_frame;

	CVSFileGUI *gui;

	g_return_if_fail (cvs != NULL);

	switch (dialog_type)
	{
	case CVS_ACTION_UPDATE:
		title = _("CVS: Update");
		button_label = _("Update");
		break;
	case CVS_ACTION_COMMIT:
		title = _("CVS: Commit");
		button_label = _("Commit");
		break;
	case CVS_ACTION_STATUS:
		title = _("CVS: Status");
		button_label = _("Show status");
		break;
	case CVS_ACTION_LOG:
		title = _("CVS: Log");
		button_label = _("Show log");
		break;
	case CVS_ACTION_ADD:
		title = _("CVS: Add file");
		button_label = _("Add");
		break;
	case CVS_ACTION_REMOVE:
		title = _("CVS: Remove file");
		button_label = _("Remove");
		label_misc = gtk_label_new (
		_("WARNING: The file will be removed on disc. Use \"cvs commit\" .\n"
		"to apply to the repository. It will still be possible to retrieve older revisions of the file."));
		gtk_widget_show (label_misc);
		break;
	default:
		return;
	}

	gui = g_new0 (CVSFileGUI, 1);
	gui->type = dialog_type;

	gui->dialog =
		gtk_dialog_new_with_buttons (title, GTK_WINDOW(app->widgets.window),
	                                 GTK_DIALOG_DESTROY_WITH_PARENT,
	                                 GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
	                                 button_label, GTK_RESPONSE_OK, NULL);
	gtk_window_set_wmclass (GTK_WINDOW (gui->dialog), "cvs-file", "anjuta");
	gtk_window_set_transient_for (GTK_WINDOW(gui->dialog),
	                              GTK_WINDOW(app->widgets.window));
	gtk_dialog_set_default_response (GTK_DIALOG (gui->dialog), GTK_RESPONSE_OK);
	
	table = gtk_table_new (5, 2, FALSE);
	gtk_container_add (GTK_CONTAINER (GTK_DIALOG (gui->dialog)->vbox), table);
	gtk_widget_show (table);

	label_file = gtk_label_new (_("File: "));
	if (gui->type != CVS_ACTION_COMMIT)
		label_branch = gtk_label_new (_("Branch: "));
	else
		label_branch = gtk_label_new (_("Revision: ")); 
	label_msg = gtk_label_new (_("Log message: "));
	gtk_widget_show (label_file);

	gui->entry_file = gnome_file_entry_new ("cvs-file", _("Select file"));
	gtk_widget_show (gui->entry_file);
	gtk_widget_set_size_request (gui->entry_file, 400, -1);
	
	text_frame = gtk_frame_new (NULL);
	gtk_frame_set_shadow_type (GTK_FRAME (text_frame), GTK_SHADOW_IN);
	
	gui->text_message = gtk_text_view_new ();
	gtk_widget_set_size_request (gui->text_message, 400, 150);
	gtk_container_add (GTK_CONTAINER (text_frame), gui->text_message);
	
	gui->entry_branch = gnome_entry_new ("cvs-branch");
	if (gui->type == CVS_ACTION_UPDATE || gui->type == CVS_ACTION_COMMIT)
	{
		gtk_widget_show (label_branch);
		gtk_widget_show (gui->entry_branch);
	}

	if (gui->type == CVS_ACTION_COMMIT || gui->type == CVS_ACTION_ADD)
	{
		gtk_widget_show (label_msg);
		gtk_widget_show (text_frame);
		gtk_widget_show (gui->text_message);
		//gtk_text_set_editable (GTK_TEXT (gui->text_message), TRUE);
	}
	
	gtk_misc_set_alignment (GTK_MISC(label_file), 0, -1);	
	gtk_misc_set_alignment (GTK_MISC(label_branch), 0, -1);	
	gtk_misc_set_alignment (GTK_MISC(label_msg), 0, 0);	
	
	gtk_table_attach (GTK_TABLE (table),
	                  label_file,
	                  0, 1, 0, 1,
	                  GTK_FILL, 0, 3, 3);
	gtk_table_attach (GTK_TABLE (table),
	                  gui->entry_file,
	                  1, 2, 0, 1,
	                  GTK_FILL | GTK_EXPAND, 0, 3, 3);
	gtk_table_attach (GTK_TABLE (table),
	                  label_branch,
	                  0, 1, 1, 2,
	                  GTK_FILL, 0, 3, 3);
	gtk_table_attach (GTK_TABLE (table),
	                  gui->entry_branch,
	                  1, 2, 1, 2,
	                  GTK_FILL | GTK_EXPAND, 0, 3, 3);
	gtk_table_attach (GTK_TABLE (table),
	                  label_msg,
	                  0, 1, 2, 3,
	                  GTK_FILL, GTK_FILL, 3, 3);
	gtk_table_attach (GTK_TABLE (table),
	                  text_frame,
	                  1, 2, 2, 3,
	                  GTK_FILL | GTK_EXPAND, 0, 3, 3);
	if (label_misc != NULL)
		gtk_table_attach (GTK_TABLE (table),
		                  label_misc,
		                  0, 2, 3, 4,
		                  GTK_FILL | GTK_EXPAND, 0, 3, 3);
	gtkentry = gnome_file_entry_gtk_entry (GNOME_FILE_ENTRY (gui->entry_file));
	
	if(filename == NULL)
	{
		gtk_entry_set_text (GTK_ENTRY (gtkentry), get_cur_filename());
	} else
	{
		gtk_entry_set_text (GTK_ENTRY (gtkentry), filename);
	}
	g_signal_connect (G_OBJECT (gui->dialog), "response",
	                  G_CALLBACK (on_cvs_dialog_response), gui); 

	// FIXED: Show dialog for project to be able to change branch
	if (is_project)
	{
		gtk_widget_set_sensitive (gui->entry_file, FALSE);
	}
	gtk_widget_show (gui->dialog);
}

/*
	Create a window to where the user can choose options for
	a diff between the working copy of a file and the repositry
*/
void
create_cvs_diff_gui (CVS *cvs, gchar *filename, gboolean is_project)
{
	CVSFileDiffGUI *gui;

	GtkWidget *table;
	GtkWidget *label_file;
	GtkWidget *label_rev;
	GtkWidget *label_date;
	GtkWidget *gtkentry;
	GtkWidget *date_hbox;

	gui = g_new0 (CVSFileDiffGUI, 1);

	gui->dialog = gtk_dialog_new_with_buttons (_("CVS: Diff file"),
	                              GTK_WINDOW (app->widgets.window),
	                              GTK_DIALOG_DESTROY_WITH_PARENT,
	                              GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
	                              _("Diff"), GTK_RESPONSE_OK, NULL);
	gtk_dialog_set_default_response (GTK_DIALOG (gui->dialog), GTK_RESPONSE_OK);
	gtk_window_set_transient_for (GTK_WINDOW(gui->dialog),
	                              GTK_WINDOW(app->widgets.window));

	table = gtk_table_new (3, 2, FALSE);
	gtk_container_add (GTK_CONTAINER (GTK_DIALOG (gui->dialog)->vbox), table);
	gtk_widget_show (table);

	label_file = gtk_label_new (_("File: "));
	gtk_misc_set_alignment (GTK_MISC (label_file), 0, -1);	

	gui->entry_file = gnome_file_entry_new ("cvs-file", _("Select file"));
	gtkentry = gnome_file_entry_gtk_entry (GNOME_FILE_ENTRY (gui->entry_file));
	gtk_widget_set_size_request (gtkentry, 400, -1);
	
	if(filename == NULL)
	{
		gtk_entry_set_text (GTK_ENTRY (gtkentry), get_cur_filename());
	}
	else
	{
		gtk_entry_set_text (GTK_ENTRY (gtkentry), filename);
	}

	gtk_widget_show (label_file);
	gtk_widget_show (gui->entry_file);
	gtk_table_attach (GTK_TABLE (table),
	                  label_file,
	                  0, 1, 0, 1,
	                  GTK_FILL, 0, 3, 3);
	gtk_table_attach (GTK_TABLE (table),
	                  gui->entry_file,
	                  1, 2, 0, 1,
	                  GTK_FILL | GTK_EXPAND, 0, 3, 3);

	label_date = gtk_label_new (_("Date: "));
	gtk_widget_show (label_date);
	gtk_misc_set_alignment (GTK_MISC(label_date), 0, -1);
	
	date_hbox = gtk_hbox_new (FALSE, 5);
	gtk_widget_show (date_hbox);
	
	gui->check_date = gtk_check_button_new_with_label ("Use date");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(gui->check_date),
	                             cvs_get_diff_use_date(cvs));
	gtk_widget_show (gui->check_date);
	gtk_box_pack_start_defaults (GTK_BOX(date_hbox), gui->check_date);
	gui->entry_date = gnome_date_edit_new (time (NULL), TRUE, TRUE);
	gtk_widget_show (gui->entry_date);
	gtk_widget_set_sensitive (gui->entry_date, cvs_get_diff_use_date(cvs));
	gtk_box_pack_start_defaults (GTK_BOX(date_hbox), gui->entry_date);
	
	gtk_table_attach (GTK_TABLE (table),
	                  label_date,
	                  0, 1, 1, 2,
	                  GTK_FILL, 0, 3, 3);
	gtk_table_attach (GTK_TABLE (table),
	                  date_hbox,
	                  1, 2, 1, 2,
	                  GTK_FILL | GTK_EXPAND, 0, 3, 3);

	label_rev = gtk_label_new (_("Revision: "));
	gtk_misc_set_alignment(GTK_MISC(label_rev), 0, -1);	
	gui->entry_rev = gnome_entry_new ("cvs-revision");
	gtk_widget_show (label_rev);
	gtk_widget_show (gui->entry_rev);
	gtk_table_attach (GTK_TABLE (table),
	                  label_rev,
	                  0, 1, 2, 3,
	                  GTK_FILL, 0, 3, 3);
	gtk_table_attach (GTK_TABLE (table),
	                  gui->entry_rev,
	                  1, 2, 2, 3,
	                  GTK_FILL | GTK_EXPAND, 0, 3, 3);

	g_signal_connect (G_OBJECT (gui->dialog), "response",
	                  G_CALLBACK (on_cvs_diff_dialog_response), gui);
	g_signal_connect (G_OBJECT(gui->check_date), "toggled",
	                  G_CALLBACK (on_cvs_diff_use_date_toggled), gui);

	if (is_project) 
	{
		gtk_widget_set_sensitive (gui->entry_file, FALSE);
	}
	gtk_widget_show (gui->dialog);
}

void 
create_cvs_login_gui (CVS *cvs)
{
	GtkWidget* type_label;
	GtkWidget* user_label;
	GtkWidget* server_label;
	GtkWidget* dir_label;
	GtkWidget* table;
	
	GList* strings;
	int i;
	CVSLoginGUI* gui;
	
	gui = g_new0(CVSLoginGUI, 1);
	
	gui->dialog =
		gtk_dialog_new_with_buttons (_("CVS Login"),
	                    GTK_WINDOW (app->widgets.window),
		                GTK_DIALOG_DESTROY_WITH_PARENT,
		                GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
		                _("Login"), GTK_RESPONSE_OK, NULL);
	gtk_dialog_set_default_response (GTK_DIALOG (gui->dialog), GTK_RESPONSE_OK);
	gtk_window_set_transient_for (GTK_WINDOW(gui->dialog),
	                              GTK_WINDOW(app->widgets.window));
	
	gui->combo_type = gtk_combo_new();
	gui->entry_user = gnome_entry_new ("cvs-user");
	gui->entry_server = gnome_entry_new ("cvs-server");
	gui->entry_dir = gnome_entry_new ("cvs-server-dir");
	
	type_label = gtk_label_new (_("Server type: "));
	user_label = gtk_label_new (_("Username: "));
	server_label = gtk_label_new (_("Server: "));
	dir_label = gtk_label_new (_("Directory on the server: "));
	
	gtk_misc_set_alignment(GTK_MISC(type_label), 0, -1);	
	gtk_misc_set_alignment(GTK_MISC(user_label), 0, -1);	
	gtk_misc_set_alignment(GTK_MISC(server_label), 0, -1);	
	gtk_misc_set_alignment(GTK_MISC(dir_label), 0, -1);	

	table = gtk_table_new (4, 2, FALSE);
	gtk_container_add (GTK_CONTAINER(GTK_DIALOG (gui->dialog)->vbox), table);
	gtk_table_attach (GTK_TABLE (table),
	                  type_label,
	                  0, 1, 0, 1,
	                  GTK_FILL, 0, 3, 3);
	gtk_table_attach (GTK_TABLE (table),
	                  server_label,
	                  0, 1, 1, 2,
	                  GTK_FILL, 0, 3, 3);
	gtk_table_attach (GTK_TABLE (table),
	                  dir_label,
	                  0, 1, 2, 3,
	                  GTK_FILL, 0, 3, 3);
	gtk_table_attach (GTK_TABLE (table),
	                  user_label,
	                  0, 1, 3, 4,
	                  GTK_FILL, 0, 3, 3);
	
	gtk_table_attach (GTK_TABLE (table),
	                  gui->combo_type, 1, 2, 0, 1,
	                  GTK_EXPAND | GTK_FILL, 0, 3, 3);
	gtk_table_attach (GTK_TABLE (table),
	                  gui->entry_server,
	                  1, 2, 1, 2,
	                  GTK_EXPAND | GTK_FILL, 0, 3, 3);
	gtk_table_attach (GTK_TABLE (table),
	                  gui->entry_dir,
	                  1, 2, 2, 3,
	                  GTK_EXPAND | GTK_FILL, 0, 3, 3);
	gtk_table_attach (GTK_TABLE (table),
	                  gui->entry_user,
	                  1, 2, 3, 4,
	                  GTK_EXPAND | GTK_FILL, 0, 3, 3);
	
	strings = g_list_alloc ();
	for (i = 0; i < 4; i++)
	{
		strings = g_list_append (strings, server_types[i]);
	}
	
	gtk_editable_set_editable (GTK_EDITABLE (GTK_COMBO
	                           (gui->combo_type)->entry), FALSE);
	gtk_combo_set_popdown_strings (GTK_COMBO (gui->combo_type), strings);
	gtk_combo_set_value_in_list (GTK_COMBO (gui->combo_type), TRUE, FALSE);

	g_signal_connect (G_OBJECT (gui->dialog), "response",
	                  G_CALLBACK (on_cvs_login_dialog_response), gui);
	gtk_widget_show_all (gui->dialog);
}

void create_cvs_import_gui (CVS *cvs)
{
	GtkWidget* type_label;
	GtkWidget* server_label;
	GtkWidget* dir_label;
	GtkWidget* user_label;
	GtkWidget* module_label;
	GtkWidget* message_label;
	GtkWidget* release_label;
	GtkWidget* vendor_label;
	GtkWidget* table;
	GtkWidget* server_frame;
	GtkWidget* server_table;
	GtkWidget* import_frame;
	GtkWidget* import_table;
	GList* strings;
	guint i;
	CVSImportGUI* gui = g_new0 (CVSImportGUI, 1);
	
	gui->dialog = gtk_dialog_new_with_buttons (_("CVS: Import Project"),
	                              GTK_WINDOW (app->widgets.window),
	                              GTK_DIALOG_DESTROY_WITH_PARENT,
	                              GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
	                              _("Import"), GTK_RESPONSE_OK, NULL);
	gtk_dialog_set_default_response (GTK_DIALOG (gui->dialog), GTK_RESPONSE_OK);
	gtk_window_set_transient_for (GTK_WINDOW(gui->dialog), GTK_WINDOW(app->widgets.window));
	
	table = gtk_table_new (2, 1, FALSE);
	gtk_container_add (GTK_CONTAINER (GTK_DIALOG (gui->dialog)->vbox), table);
	server_table = gtk_table_new (4, 2, FALSE);
	import_table = gtk_table_new (5, 2, FALSE);
	
	type_label = gtk_label_new (_("Server type: "));
	server_label = gtk_label_new (_("Server: "));
	dir_label = gtk_label_new (_("Dir on the server: "));
	user_label = gtk_label_new (_("Username: "));
	
	gtk_misc_set_alignment(GTK_MISC(type_label), 0, -1);	
	gtk_misc_set_alignment(GTK_MISC(user_label), 0, -1);	
	gtk_misc_set_alignment(GTK_MISC(server_label), 0, -1);	
	gtk_misc_set_alignment(GTK_MISC(dir_label), 0, -1);	
	
	gtk_table_attach (GTK_TABLE (server_table),
	                  type_label,
	                  0, 1, 0, 1,
	                  GTK_FILL, 0, 3, 3);
	gtk_table_attach (GTK_TABLE (server_table),
	                  server_label,
	                  0, 1, 1, 2,
	                  GTK_FILL, 0, 3, 3);
	gtk_table_attach (GTK_TABLE (server_table),
	                  dir_label,
	                  0, 1, 2, 3,
	                  GTK_FILL, 0, 3, 3);
	gtk_table_attach (GTK_TABLE (server_table),
	                  user_label,
	                  0, 1, 3, 4,
	                  GTK_FILL, 0, 3, 3);
	
	module_label = gtk_label_new (_("Module name: "));
	release_label = gtk_label_new (_("Release name: "));
	vendor_label = gtk_label_new (_("Vendor tag: "));
	message_label = gtk_label_new (_("Log message: "));
	
	gtk_misc_set_alignment(GTK_MISC(module_label), 0, -1);
	gtk_misc_set_alignment(GTK_MISC(release_label), 0, -1);
	gtk_misc_set_alignment(GTK_MISC(vendor_label), 0, -1);
	gtk_misc_set_alignment(GTK_MISC(message_label), 0, 0);
	
	gtk_table_attach (GTK_TABLE (import_table),
	                  module_label,
	                  0, 1, 0, 1,
	                  GTK_FILL, 0, 3, 3);
	gtk_table_attach (GTK_TABLE (import_table),
	                  release_label,
	                  0, 1, 1, 2,
	                  GTK_FILL, 0, 3, 3);
	gtk_table_attach (GTK_TABLE (import_table),
	                  vendor_label,
	                  0, 1, 2, 3,
	                  GTK_FILL, 0, 3, 3);
	gtk_table_attach (GTK_TABLE (import_table),
	                  message_label,
	                  0, 1, 3, 4,
	                  GTK_FILL, GTK_EXPAND | GTK_FILL, 3, 3);
	
	gui->combo_type = gtk_combo_new ();
	gui->entry_server = gnome_entry_new ("cvs-server");
	gui->entry_dir = gnome_entry_new ("cvs-server-dir");
	gui->entry_user = gnome_entry_new ("cvs-user");
	
	strings = g_list_alloc();
	for (i = 0; i < 4; i++)
	{
		strings = g_list_append (strings, server_types[i]);
	}
	
	gtk_editable_set_editable (GTK_EDITABLE (GTK_COMBO (gui->combo_type)->entry), FALSE);
	gtk_combo_set_popdown_strings (GTK_COMBO (gui->combo_type), strings);
	gtk_combo_set_value_in_list (GTK_COMBO (gui->combo_type), TRUE, FALSE);

	gtk_table_attach (GTK_TABLE (server_table),
	                  gui->combo_type, 1, 2, 0, 1,
	                  GTK_EXPAND | GTK_FILL, 0, 3, 3);
	gtk_table_attach (GTK_TABLE (server_table),
	                  gui->entry_server,
	                  1, 2, 1, 2,
	                  GTK_EXPAND | GTK_FILL, 0, 3, 3);
	gtk_table_attach (GTK_TABLE (server_table),
	                  gui->entry_dir,
	                  1, 2, 2, 3,
	                  GTK_EXPAND | GTK_FILL, 0, 3, 3);
	gtk_table_attach (GTK_TABLE (server_table),
	                  gui->entry_user,
	                  1, 2, 3, 4,
	                  GTK_EXPAND | GTK_FILL, 0, 3, 3);
	
	server_frame = gtk_frame_new (_("Server settings"));
	gtk_container_set_border_width (GTK_CONTAINER (server_frame), 5);
	gtk_container_add (GTK_CONTAINER (server_frame), server_table);

	import_frame = gtk_frame_new (_("Import settings"));
	gtk_container_set_border_width (GTK_CONTAINER (import_frame), 5);
	gtk_container_add (GTK_CONTAINER (import_frame), import_table);

	gui->entry_module = gnome_entry_new ("cvs-module");
	gui->entry_release = gnome_entry_new ("cvs-release");
	gui->entry_vendor = gnome_entry_new ("cvs-vendor");
	gui->text_message = gtk_text_view_new ();
	// gtk_text_set_editable (GTK_TEXT (gui->text_message), TRUE);
	gtk_widget_set_size_request (GTK_WIDGET(gui->text_message), 400, 150);
	
	gtk_table_attach (GTK_TABLE (import_table),
	                  gui->entry_module,
	                  1, 2, 0, 1,
	                  GTK_EXPAND | GTK_FILL, 0, 3, 3);
	gtk_table_attach (GTK_TABLE (import_table),
	                  gui->entry_release,
	                  1, 2, 1, 2,
	                  GTK_EXPAND | GTK_FILL, 0, 3, 3);
	gtk_table_attach (GTK_TABLE (import_table),
	                  gui->entry_vendor,
	                  1, 2, 2, 3,
	                  GTK_EXPAND | GTK_FILL, 0, 3, 3);
	gtk_table_attach (GTK_TABLE (import_table),
	                  gui->text_message,
	                  1, 2, 3, 4,
	                  GTK_EXPAND | GTK_FILL, GTK_EXPAND | GTK_FILL, 3, 3);
	
	gtk_table_attach_defaults (GTK_TABLE (table), server_frame, 0, 1, 0, 1);
	gtk_table_attach_defaults (GTK_TABLE (table), import_frame, 0, 1, 1, 2);
	
			
	g_signal_connect (G_OBJECT (gui->dialog), "response",
			          G_CALLBACK (on_cvs_import_dialog_response), gui);
	g_signal_connect (G_OBJECT (GTK_COMBO (gui->combo_type)->entry), "changed",
			          G_CALLBACK (on_cvs_type_combo_changed), gui);
	
	gtk_widget_show_all (gui->dialog);
}
