/*
 * =============================================================================
 *
 * D I S T A N C E   T R A N S F O R M   R O U T I N E S  --  HEADER
 *
 * $Revision: 1.5 $ $Date: 2003/02/26 15:26:10 $
 *
 * ANIMAL - ANIMAL IMage Processing LibrarY
 * Copyright (C) 2002,2003  Ricardo Fabbri <rfabbri@if.sc.usp.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * =============================================================================
 */ 
#ifndef DT_H
#define DT_H 1

#include <animal/common.h>
#include <animal/img.h>
#include <animal/adjacency.h>

BEGIN_C_DECLS

// Dinstance Transform algorithm options
typedef enum {
   DT_LOTUFO_ZAMPIROLLI, // R. Lotufo & F. Zampirolli 1999 algorithm 
                         // (exact; very fast)

   DT_MAURER2003,            // C. Maurer et. al. 2003 algorithm (exact, very fast)

   DT_CUISENAIRE_PMN_1999,   // O. Cuisenaire CVIU 1999 (exact, very fast)
   DT_CUISENAIRE_PMON_1999,  // O. Cuisenaire CVIU 1999 (exact, very fast)
   DT_CUISENAIRE_PSN4_1999,  // Inexact, very fast
   DT_CUISENAIRE_PSN8_1999,  // A little less inexact, very fast

   DT_SAITO_1994,        // Fast & exact but not-always-linear algorithm
   DT_IFT, DT_IFT_8,     // Falcao & Da Cunha algorithm (almost exact; fast)    
   DT_IFT_4,             // Same alg, w/4-neighborhood. You may call this alg. 
                         // with arbitrary neighborhood using its function directly.
   DT_EXACT_DILATIONS,   // Costa & Estrozi 1999 algorithm  (exact; slow)
   DT_BRUTE_FORCE,        // O(n^4) direct algorithm just for benchmarks
   DT_BRUTE_FORCE_WITH_LIST, // O(n^4) direct algorithm just for benchmarks
} dt_algorithm;

AnimalExport ImgPUInt32
   *distance_transform(Img *bin, dt_algorithm alg);

AnimalExport bool
   edt_lz (ImgPUInt32 *im),
   edt_maurer2003(ImgPUInt32 *im),
   edt_ift(ImgPUInt32 *im, nhood *adj),
   edt_saito(ImgPUInt32 *im),
   edt_exact_dilations(ImgPUInt32 *im),
   edt_cuisenaire_psn4(ImgPUInt32 *im),  // simple 4-neighborhood approx. EDT
   edt_cuisenaire_psn8(ImgPUInt32 *im),  // simple 8-nhood approx. EDT
   edt_cuisenaire_pmn (ImgPUInt32 *im),  // multiple nhood, exact EDT
   edt_cuisenaire_pmon(ImgPUInt32 *im),  // multiple oriented nhood,
   edt_brute_force (ImgPUInt32 *im),     // O(n^4) algorithm just for benchmarks
   edt_brute_force_with_list (ImgPUInt32 *im), // O(n^2)-O(n^4) algorithm
   smallest_error_location(// generates a table of numbers for Cuisenaire.
         nhood *N, 
         puint32 *Derr_p, 
         puint32 *derr_x, puint32 *derr_y,
         puint32 start_dpx, puint32 start_dpy),
   closest_non_propagating_pixel (
         puint32 n, 
         puint32 *Dnp, puint32 *Derr, 
         puint32 *npx_p, puint32 *npy_p,
         puint32 *derr_x, puint32 *derr_y, 
         puint32 start_dpx, puint32 start_dpy); 

END_C_DECLS

#endif /* !DT_H */
