# E.3 Can private property rights protect the environment?

Environmental issues have become increasingly important over the decades. When
Murray Bookchin wrote his first works on our ecological problems in the 1950s,
he was only one of a small band. Today, even right-wing politicians have to
give at least some lip-service to environmental concerns while corporations
are keen to present their green credentials to the general public (even if
they do not, in fact, have any).

As such, there has been a significant change. This is better late than never,
considering that the warnings made by the likes of Bookchin in the 1950s and
1960s have come true to a threateningly worrying degree. Sadly, eco-anarchist
solutions are still ignored but that is unsurprising as they go to the heart
of the ecological problem, namely domination within humanity as the
precondition for the domination of nature and the workings of the capitalist
economy. It is hardly likely that those who practice and benefit from that
oppression and exploitation will admit that they are causing the problems!
Hence the need to appear green in order to keep a fundamentally anti-green
system going.

Of course, some right-wingers are totally opposed to ecological issues. They
seriously seem to forget without a viable ecology, there would be no
capitalism. Ayn Rand, for example, dismissed environmental concerns as being
anti-human and had little problem with factory chimneys belching smoke into
the atmosphere (her fondness for chimneys and skyscrapers would have have made
Freud reach for his notepad). As Bob Black once noted, _"Rand remarked that
she **worshipped** smokestacks. For her . . . they not only stood for, they
**were** the epitome of human accomplishment. She must have meant it since she
was something of a human smokestack herself; she was a chain smoker, as were
the other rationals in her entourage. In the end she abolished her own
breathing: she died of lung cancer."_ [_"Smokestack Lightning,"_ **Friendly
Fire**, p. 62] The fate of this guru of capitalism is a forewarning for our
collective one if we ignore the environment and our impact on it.

The key to understanding why so many on the right are dismissive of ecological
concerns is simply that ecology cannot be squeezed into their narrow
individualistic property based politics. Ecology is about interconnectiveness,
about change and interaction, about the sources of life and how we interact
with them and they with us. Moreover, ecology is rooted in the **quality** of
life and goes not automatically view quantity as the key factor. As such, the
notion that more is better does not strike the ecologist as, in itself, a good
thing. The idea that growth is good as such is the principle associated with
cancer. Ecology also destroys the individualistic premise of capitalist
economics. It exposes the myth that the market ensures everyone gets exactly
what they want -- for if you consume eco-friendly products but others do not
then you are affected by their decisions as the environmental impact affects
all. Equally, the notion that the solution to GM crops should letting "the
market" decide fails to take into account that such crops spread into local
eco-systems and contaminate whole areas (not to mention the issue of corporate
power enclosing another part of the commons). The market "solution" in this
case would result in everyone, to some degree, consuming GM crops eventually.
None of this can be fitted into the capitalist ideology.

However, while vocal irrational anti-green perspectives lingers on in some
sections of the right (particularly those funded by the heaviest polluters),
other supporters of capitalism have considered the problems of ecological
destruction in some degree. Some of this is, of course, simply greenwashing
(i.e., using PR and advertising to present a green image while conducting
business as usual). Some of it is funding think tanks which use green-sounding
names, imagery and rhetoric to help pursue a decidedly anti-ecological
practice and agenda. Some of is, to some degree, genuine. Al Gore's campaign
to make the world aware of the dangers of climate change is obviously sincere
and important work (although it is fair to point out the lack of green
policies being raised during his 2000 Presidential election campaign and the
poverty of his proposed solutions and means of change). Nicholas Stern's 2006
report on climate change produced for the UK government is another example and
it gives an insight into the mentality of such environmentalists. The report
did produce quite an impact (plus its dismissal by the usual suspects). The
key reason for that was, undoubtedly, due to it placing a money sum on the
dangers of environmental disruption. Such is capitalism -- people and planet
can go to the dogs, but any threat to profits must be acted upon. As the
British PM at the time put it, any Climate Change Bill must be _"fully
compatible with the interests of businesses and consumers as well."_ Which is
ironic, as it is the power of money which is causing the bulk of the problems
we face.

Which is what we will discuss here, namely whether private property can be
used to solve our environmental problems. Liberal environmentalists base their
case on capitalist markets aided with some form of state intervention. Neo-
liberal and right-"libertarian" environmentalists base their case purely on
capitalist markets and reject any role for the state bar that of defining and
enforcing private property rights. Both, however, assume that capitalism will
remain and tailor their policies around it. Anarchists question that
particularly assumption particularly given, as we discussed in [section
E.1](secE1.html), the fundamental reason why capitalism cannot be green is its
irrational "grow-or-die" dynamic. However, there are other aspects of the
system which contribute to capitalism bringing ecological crisis sooner rather
than later. These flow from the nature of private property and the market
competition it produces (this discussion, we should stress, ignores such
factors as economic power which will be addressed in [section
E.3.2](secE3.html#sece32)).

The market itself causes ecological problems for two related reasons:
externalities and the price mechanism. It is difficult making informed
consumption decisions under capitalism because rather than provide enough
information to make informed decisions, the market hinders the flow of
relevant information and suppresses essential knowledge. This is particularly
the case with environmental information and knowledge. Simply put, we have no
way of knowing from a given price the ecological impact of the products we
buy. One such area of suppressed information is that involving externalities.
This is a commonly understood problem. The market actively rewards those
companies which inflict externalities on society. This is the _"routine and
regular harms caused to **others** \-- workers, consumers, communities, the
environment."_ These are termed _"externalities"_ in _"the coolly technical
jargon of economics"_ and the capitalist company is an _"externalising
machine"_ and it is _"no exaggeration to say that the corporation's built in
compulsion to externalise its costs is at the root of many of the world's
social and environmental ills."_ [Joel Bakan, **The Corporation**, p. 60 and
p. 61]

The logic is simple, by externalising (imposing) costs on others (be it
workers, customers or the planet) a firm can reduce its costs and make higher
profits. Thus firms have a vested interest in producing externalities. To put
it crudely, pollution pays while ecology costs. Every pound a business spends
on environmental protections is one less in profits. As such, it makes
economic sense to treat the environment like a dump and externalise costs by
pumping raw industrial effluent into the atmosphere, rivers, and oceans. The
social cost of so doing weighs little against the personal profits that result
from inflicting diffuse losses onto the general public. Nor should we discount
the pressure of market forces in this process. In order to survive on the
market, firms may have to act in ways which, while profitable in the short-
run, are harmful in the long term. For example, a family-owned farm may be
forced to increase production using environmentally unsound means simply in
order to avoid bankruptcy.

As well as economic incentives, the creation of externalities flows from the
price mechanism itself. The first key issue, as green economist E. F.
Schumacher stressed, is that the market is based on _"total quantification at
the expense of qualitative differences; for private enterprise is not
concerned with what it produces but only what it gains from production."_ This
means that the _"judgement of economics . . . is an extremely **fragmentary**
judgement; out of the large number of aspects which in real life have to be
seen and judged together before a decision can be taken, economics supplies
only one -- whether a thing yields a profit **to those who undertake it** or
not."_ [**Small is Beautiful**, p. 215 and p. 28] This leads to a simplistic
decision making perspective:

> _ "Everything becomes crystal clear after you have reduced reality to one --
one only -- of its thousand aspects. You know what to do -- whatever produces
profits; you know what to avoid -- whatever reduces them or makes a loss. And
there is at the same time a perfect measuring rod for the degree of success or
failure. Let no-one befog the issue by asking whether a particular action is
conducive to the wealth and well-being of society, whether it leads to moral,
aesthetic, or cultural enrichment. Simply find out whether it pays."_ [**Op.
Cit.**, p. 215]

This means that key factors in decision making are, at best, undermined by the
pressing need to make profits or, at worse, simply ignored as a handicap. So
_"in the market place, for practical reasons, innumerable qualitative
distinctions which are of vital importance for man and society are suppressed;
they are not allowed to surface. Thus the reign of quantity celebrates its
greatest triumphs in 'The Market.'"_ This feeds the drive to externalise
costs, as it is _"based on a definition of cost which excludes all 'free
goods,' that is to say, the entire God-given environment, except for those
parts of it that have been privately appropriated. This means that an activity
can be economic although it plays hell with the environment, and that a
competing activity, if at some cost it protects and conserves the environment,
will be uneconomic."_ To summarise: _"it is inherent in the methodology of
economics to **ignore man's dependence on the natural world.**"_ [**Op.
Cit.**, p. 30 and p. 29]

Ultimately, should our decision-making be limited to a single criteria, namely
whether it makes someone a profit? Should our environment be handed over to a
system which bases itself on confusing efficient resource allocation with
maximising profits in an economy marked by inequalities of wealth and,
consequently, on unequal willingness and ability to pay? In other words,
biodiversity, eco-system stability, clean water and air, and so forth only
become legitimate social goals when the market places a price on them
sufficient for a capitalist to make money from them. Such a system can only
fail to achieve a green society simply because ecological concerns cannot be
reduced to one criteria (_"The discipline of economics achieves its formidable
resolving power by transforming what might otherwise be considered qualitative
matters into quantitative issues with a single metric and, as it were, a
bottom line: profit or loss."_ [James C. Scott, **Seeing like a State**, p.
346]). This is particularly the case when even economists admit that the
market under-supplies public goods, of which a clean and aesthetically
pleasing environment is the classic example. Markets may reflect, to some
degree, individual consumer preferences distorted by income distribution but
they are simply incapable of reflecting collective values (a clean environment
and spectacular views are inherently collective goods and cannot be enclosed).
As a result, capitalists will be unlikely to invest in such projects as they
cannot make everyone who uses them pay for the privilege.

Then there is the tendency for the market to undermine and destroy practical
and local knowledge on which truly ecological decisions need to be based.
Indigenous groups, for example, have accumulated an enormous body of knowledge
about local ecological conditions and species which are ignored in economic
terms or eliminated by competition with those with economic power. Under
markets, in other words, unarticulated knowledge of soil conditions and bio-
diversity which have considerable value for long-term sustainability is
usually lost when it meets agribusiness.

Practical knowledge, i.e. local and tacit knowledge which James C. Scott terms
metis, is being destroyed and replaced _"by standardised formulas legible from
the centre"_ and this _"is virtually inscribed in the activities of both the
state and large-scale bureaucratic capitalism."_ The _"logic animating the
project . . . is one of control and appropriation. Local knowledge, because it
is dispersed and relatively autonomous, is all but unappropriable. The
reduction or, more utopian still, the elimination of metis and the local
control its entails are preconditions, in the case of the state, of
administrative order and fiscal appropriation and, in the case of the large
capitalism firm, of worker discipline and profit."_ [**Op. Cit.**, pp. 335-6]
Green socialist John O'Neill provides a similar analysis:

> _ "far from fostering the existence of practical and local knowledge, the
spread of markets often appears to do the opposite: the growth of global
markets is associated with the disappearance of knowledge that is local and
practical, and the growth of abstract codifiable information . . . the market
as a mode of co-ordination appears to foster forms of abstract codifiable
knowledge . . . The knowledge of weak and marginal actors in markets, such as
peasant and marginalised indigenous communities, tends to be lost to those who
hold market power. The epistemic value of knowledge claims bear no direct
relation to their market value. Local and often unarticulated knowledge of
soil conditions and crop varieties that have considerable value for long-term
sustainability of agriculture has no value in markets and hence is always
liable to loss when it comes into contact with oil-based agricultural
technologies of those who do have market power. The undermining of local
practical knowledge in market economies has also been exacerbated by the
global nature of both markets and large corporate actors who require knowledge
that is transferable across different cultures and contexts and hence abstract
and codifiable . . . Finally, the demand for commensurability and
calculability runs against the defence of local and practical knowledge. This
is not just a theoretical problem but one with real institutional embodiments.
The market encourages a spirit of calculability . . . That spirit is the
starting point for the algorithmic account of practical reason which requires
explicit common measures for rational choice and fails to acknowledge the
existence of choice founded upon practical judgement. More generally it is not
amicable to forms of knowledge that are practical, local and uncodifiable."_
[**Markets, Deliberation and Environment**, pp. 192-3]

Thus the market tends to replace traditional forms of agriculture and working
practices (and the complex knowledge and expertises associated with both) with
standardised techniques which aim to extract as much profit in the short-term
as possible by concentrating power into the hands of management and their
appointed experts. That they cannot even begin to comprehend the local
conditions and practical knowledge and skills required to effectively use the
resources available in a sustainable manner should go without saying.
Unfortunately, the economic clout of big business is such that it can defeat
traditional forms of knowledge in the short-term (the long-term effect of such
exploitation is usually considered someone else's problem).

So, given this analysis, it comes as no surprise to anarchists that private
property has not protected the environment. In fact, it is one of the root
causes of our ecological problems. Markets hide the ecological and health
information necessary for environmentally sound decisions. Ultimately,
environmental issues almost always involve value judgements and the market
stops the possibility of producing a public dialogue in which these values can
be discussed and enriched. Instead, it replaces this process by an aggregation
of existing preferences (shaped by economic pressures and necessity) skewed in
favour of this generation's property owners. An individual's interest, like
that of the public as a whole, is not something which exists independently of
the decision-making processes used but rather is something which is shaped by
them. Atomistic processes focused on a simplistic criteria will produce
simplistic decisions which have collectively irrational results. Collective
decision making based on equal participation of all will produce decisions
which reflect **all** the concerns of **all** affected in a process which will
help produce empowered and educated individuals along with informed decisions.

Some disagree. For these the reason why there is environmental damage is not
due to too much private property but because there is too little. This
perspective derives from neo-classical and related economic theory and it
argues that ecological harm occurs because environmental goods and bads are
unpriced. They come free, in other words. This suggests that the best way to
protect the environment is to privatise everything and to create markets in
all areas of life. This perspective, needless to say, is entirely the opposite
of the standard eco-anarchist one which argues that our environmental problems
have their root in market mechanisms, private property and the behaviour they
generate. As such, applying market norms even more rigorously and into areas
of life that were previously protected from markets will tend to make
ecological problems worse, not better.

As would be expected, the pro-property perspective is part of the wider turn
to free(r) market capitalism since the 1970s. With the apparent success of
Thatcherism and Reaganism (at least for the people who count under capitalism,
i.e. the wealthy) and the fall of Stalinism in the Eastern Block, the 1980s
and 1990s saw a period of capitalist triumphantism. This lead to an increase
in market based solutions to every conceivable social problem, regardless of
how inappropriate and/or insane the suggestions were. This applies to
ecological issues as well. The publication of **Free Market Environmentalism**
by Terry L. Anderson and Donald R. Leal in 1991 saw ideas previously
associated with the right-"libertarian" fringe become more mainstream and,
significantly, supported by corporate interests and the think-tanks and
politicians they fund.

Some see it as a deliberate plan to counteract a growing ecological movement
which aims to change social, political and economic structures in order to get
at the root cases of our environmental problems. Activist Sara Diamond
suggested that _"[s]ome farsighted corporations are finding that the best
'bulwark' against 'anti-corporation' environmentalism is the creation and
promotion of an alternative model called 'free market environmentalism.'"_
[_"Free Market Environmentalism,"_ **Z Magazine**, December 1991] Whatever the
case, the net effect of this reliance on markets is to depoliticise
environmental debates, to transform issues which involve values and affect
many people into ones in which the property owner is given priority and where
the criteria for decision making becomes one of profit and loss. It means,
effectively, ending debates over **why** ecological destruction happens and
what we should do about it and accepting the assumptions, institutions and
social relationships of capitalism as a given as well as privatising yet more
of the world and handing it over to capitalists. Little wonder it is being
proposed as an alternative by corporations concerned about their green image.
At the very least, it is fair to say that the corporations who punt free
market environmentalism as an alternative paradigm for environmental policy
making are not expecting to pay more by internalising their costs by so doing.

As with market fundamentalism in general, private property based
environmentalism appears to offer solutions simply because it fails to take
into account the reality of any actual capitalist system. The notion that all
we have to do is let markets work ignores the fact that any theoretical claim
for the welfare superiority of free-market outcomes falls when we look at any
real capitalist market. Once we introduce, say, economic power, imperfect
competition, public goods, externalities or asymmetric information then the
market quickly becomes a god with feet of clay. This is what we will explore
in the rest of this section while the [next section](secE4.html) will discuss
a specific example of how laissez-faire capitalism cannot be ecological as
proved by one of its most fervent ideologues. Overall, anarchists feel we have
a good case on why is unlikely that private property can protect the
environment.

## E.3.1 Will privatising nature save it?

No, it will not. To see why, it is only necessary to look at the arguments and
assumptions of those who advocate such solutions to our ecological problems.

The logic behind the notion of privatising the planet is simple. Many of our
environmental problems stem, as noted in the [last section](secE3.html), from
externalities. According to the "market advocates" this is due to there being
unowned resources for if someone owned them, they would sue whoever or
whatever was polluting them. By means of private property and the courts,
pollution would end. Similarly, if an endangered species or eco-system were
privatised then the new owners would have an interest in protecting them if
tourists, say, were willing to pay to see them. Thus the solution to
environmental problems is simple. Privatise everything and allow people's
natural incentive to care for their own property take over.

Even on this basic level, there are obvious problems. Why assume that
**capitalist** property rights are the only ones, for example? However, the
crux of the problem is clear enough. This solution only works if we assume
that the "resources" in question make their owners a profit or if they are
willing and able to track down the polluters. Neither assumption is robust
enough to carry the weight that capitalism places on our planet's environment.
There is no automatic mechanism by which capitalism will ensure that
environmentally sound practices will predominate. In fact, the opposite is far
more likely.

At its most basic, the underlying rationale is flawed. It argues that it is
only by giving the environment a price can we compare its use for different
purposes. This allows the benefits from preserving a forest to be compared to
the benefits of cutting it down and building a shopping centre over it. Yet by
"benefits" it simply means economic benefits, i.e. whether it is profitable
for property owners to do so, rather than ecologically sensible. This is an
important difference. If more money can be made in turning a lake into a toxic
waste dump then, logically, its owners will do so. Similarly, if timber prices
are not rising at the prevailing profit or interest rate, then a self-
interested firm will seek to increase its profits and cut-down its trees as
fast as possible, investing the returns elsewhere. They may even sell such
cleared land to other companies to develop. This undermines any claim that
private property rights and environmental protection go hand-in-hand.

As Glenn Albrecht argues, such a capitalist "solution" to environmental
problems is only _"likely to be effective in protecting species [or
ecosystems] which are commercially important only if the commercial value of
that species [or ecosystem] exceeds that of other potential sources of income
that could be generated from the same 'natural capital' that the species
inhabits If, for example, the conservation of species for ecotourism generates
income which is greater than that which could be gained by using their habit
for the growing of cash crops, then the private property rights of the owners
of the habitat will effectively protect those species . . . However, this
model becomes progressively less plausible when we are confronted with rare
but commercially unimportant species [or ecosystems] versus very large
development proposals that are inconsistent with their continual existence.
The less charismatic the species, the more 'unattractive' the ecosystem, the
more likely it will be that the development proposal will proceed. The
'rights' of developers will eventually win out over species and ecosystems
since . . . bio-diversity itself has no right to exist and even if it did, the
clash of rights between an endangered species and multi-national capital would
be a very uneven contest."_ [_"Ethics, Anarchy and Sustainable Development"_,
pp. 95-118, **Anarchist Studies**, vol. 2, no. 2, pp. 104-5]

So the conservation of endangered species or eco-systems is not automatically
achieved using the market. This is especially the case when there is little,
or no, economic value in the species or eco-system in question. The most
obvious example is when there is only a limited profit to be made from a piece
of land by maintaining it as the habitat of a rare species. If any alternative
economic uses for that land yields a greater profit then that land will be
developed. Moreover, if a species looses its economic value as a commodity
then the property owners will become indifferent to its survival. Prices
change and so an investment which made sense today may not look so good
tomorrow. So if the market price of a resource decreases then it becomes
unlikely that its ecological benefits will outweigh its economic ones.
Overall, regardless of the wider ecological importance of a specific eco-
system or species it is likely that their owner will prioritise short-term
profits over environmental concerns. It should go without saying that
threatened or endangered eco-systems and species will be lost under a
privatised regime as it relies on the willingness of profit-orientated
companies and individuals to take a loss in order to protect the environment.

Overall, advocates of market based environmentalism need to present a case
that **all** plants, animals and eco-systems are valuable commodities in the
same way as, say, fish are. While a case for market-based environmentalism can
be made by arguing that fish have a market price and, as such, owners of
lakes, rivers and oceans would have an incentive to keep their waters clean in
order to sell fish on the market, the same cannot be said of all species and
habitats. Simply put, not all creatures, plants and eco-systems with an
ecological value will have an economic one as well.

Moreover, markets can send mixed messages about the environmental policies
which should be pursued. This may lead to over investment in some areas and
then a slump. For example, rising demand for recycled goods may inspire an
investment boom which, in turn, may lead to over-supply and then a crash, with
plants closing as the price falls due to increased supply. Recycling may then
become economically unviable, even though it remains ecologically essential.
In addition, market prices hardly provide an accurate signal regarding the
"correct" level of ecological demands in a society as they are constrained by
income levels and reflect the economic pressures people are under. Financial
security and income level play a key role, for in the market not all votes are
equal. A market based allocation of environmental goods and bads does not
reflect the obvious fact the poor may appear to value environmental issues
less than the wealthy in this scheme simply because their preferences (as
expressed in the market) are limited by lower budgets.

Ultimately, market demand can change without the underlying demand for a
specific good changing. For example, since the 1970s the real wages of most
Americans have stagnated while inequality has soared. As a result, fewer
households can afford to go on holidays to wilderness areas or buy more
expensive ecologically friendly products. Does that imply that the people
involved now value the environment less simply because they now find it harder
to make ends meet? Equally, if falling living standards force people to take
jobs with dangerous environmental consequences does than really provide an
accurate picture of people's desires? It takes a giant leap of faith (in the
market) to assume that falling demand for a specific environmental good
implies that reducing environmental damage has become less valuable to people.
Economic necessity may compel people to act against their best impulses, even
strongly felt natural values (an obvious example is that during recessions
people may be more willing to tolerate greenhouse gas emissions simply because
they need the work).

Nor can it be claimed that all the relevant factors in ecological decision
making can take the commodity form, i.e. be given a price. This means that
market prices do not, in fact, actually reflect people's environmental values.
Many aspects of our environment simply cannot be given a market price (how can
you charge people to look at beautiful scenery?). Then there is the issue of
how to charge a price which reflects the demand of people who wish to know
that, say, the rainforest or wilderness exists and is protected but who will
never visit either? Nor are future generations taken into account by a value
that reflects current willingness to pay and might not be consistent with
long-term welfare or even survival. And how do you factor in the impact a
cleaner environment has on protecting or extending human lives? Surely a
healthy environment is worth much more than simply lost earnings and the
medical bills and clean-up activities saved? At best, you could factor this in
by assuming that the wage premium of workers in dangerous occupations reflects
it but a human life is, surely, worth more than the wages required to attract
workers into dangerous working conditions. Wages are **not** an objective
measure of the level of environmental risks workers are willing to tolerate as
they are influenced by the overall state of the economy, the balance of class
power and a whole host of other factors. Simply put, fear of unemployment and
economic security will ensure that workers tolerate jobs that expose them and
their communities to high levels of environmental dangers.

Economic necessity drives decisions in the so-called "free" market (given a
choice between clean air and water and having a job, many people would choose
the latter simply because they have to in order to survive). These factors can
only be ignored which means that environmental values **cannot** be treated
like commodities and market prices **cannot** accurately reflect environmental
values. The key thing to remember is that the market does not meet demand, it
meets **effective** demand (i.e. demands backed up with money). Yet people
want endangered species and eco-systems protected even if there is no
effective demand for them on the market (nor could be). We will return to this
critical subject in the [next section](secE3.html#sece32).

Then there are the practicalities of privatising nature. How, for example, do
we "privatise" the oceans? How do we "privatise" whales and sharks in order to
conserve them? How do we know if a whaling ship kills "your" whale? And what
if "your" shark feeds on "my" fish? From whom do we buy these resources in the
first place? What courts must be set up to assess and try crimes and define
damages? Then there are the costs of defining and enforcing private rights by
means of the courts. This would mean individual case-by-case adjudications
which increase transaction costs. Needless to say, such cases will be
influenced by the resources available to both sides. Moreover, the judiciary
is almost always the least accountable and representative branch of the state
and so turning environmental policy decisions over to them will hardly ensure
that public concerns are at the foremost of any decision (such a move would
also help undermine trial by jury as juries often tend to reward sizeable
damages against corporations in such cases, a factor corporations are all too
aware of).

This brings us to the problem of actually proving that the particles of a
specific firm has inflicted a specific harm on a particular person and their
property. Usually, there are multiple firms engaging in polluting the
atmosphere and it would be difficult, if not impossible, to legally establish
the liability of any particular firm. How to identify which particular
polluter caused the smog which damaged your lungs and garden? Is it an
individual company? A set of companies? All companies? Or is it
transportation? In which case, is it the specific car which finally caused
your cancer or a specific set of car uses? Or all car users? Or is it the
manufacturers for producing such dangerous products in the first place?

Needless to say, even this possibility is limited to the current generation.
Pollution afflicts future generations as well and it is impossible for their
interests to be reflected in court for "future harm" is not the question, only
present harm counts. Nor can non-human species or eco-systems sue for damage,
only their owners can and, as noted above, they may find it more profitable to
tolerate (or even encourage) pollution than sue. Given that non-owners cannot
sue as they are not directly harmed, the fate of the planet will rest in the
hands of the property-owning class and so the majority are effectively
dispossessed of any say over their environment beyond what their money can
buy. Transforming ecological concerns into money ensures a monopoly by the
wealthy few:

> _ "In other words, the environment is assumed to be something that can be
'valued,' in a similar way that everything else is assigned a value within the
market economy.  
>  _

>

> _"However, apart from the fact that there is no way to put an 'objective'
value on most of the elements that constitute the environment (since they
affect a subjective par excellence factor, i.e. the quality of life), the
solution suggested . . . implies the extension of the marketisation process to
the environment itself. In other words, it implies the assignment of a market
value to the environment . . . so that the effects of growth onto it are
'internalised' . . . The outcome of such a process is easily predictable: the
environment will either be put under the control of the economic elites that
control the market economy (in case an actual market value be assigned to it)
or the state (in case an imputed value is only possible). In either case, not
only the arrest of the ecological damage is -- at least -- doubtful, but the
control over Nature by elites who aim to dominate it -- using 'green'
prescriptions this time -- is perpetuated."_ [Takis Fotopoulous, _"Development
or Democracy?"_, pp. 57-92, **Society and Nature**, No. 7, pp. 79-80]

Another key problem with using private property in regard to environmental
issues is that they are almost always reactive, almost never proactive. Thus
the pollution needs to have occurred before court actions are taken as strict
liability generally provides after-the-fact compensation for injuries
received. If someone does successfully sue for damages, the money received can
hardly replace an individual or species or eco-system. At best, it could be
argued that the threat of being sued will stop environmentally damaging
activities but there is little evidence that this works. If a company
concludes that the damages incurred by court action is less than the potential
profits to be made, then they will tolerate the possibility of court action
(particularly if they feel that potential victims do not have the time or
resources available to sue). This kind of decision was most infamously done by
General Motors when it designed its Malibu car. The company estimated that the
cost of court awarded damages per car was less than ensuring that the car did
not explode during certain kinds of collusion and so allowed people to die in
fuel-fed fires rather than alter the design. Unfortunately for GM, the jury
was horrified (on appeal, the damages were substantially reduced). [Joel
Bakan, **The Corporation**, pp. 61-5]

So this means that companies seeking to maximise profits have an incentive to
cut safety costs on the assumption that the risk of so doing will be
sufficiently low to make it worthwhile and that any profits generated will
more than cover the costs of any trial and damages imposed. As eco-anarchist
David Watson noted in regards to the Prudhoe Bay disaster, it _"should go
without saying that Exxon and its allies don't try their best to protect the
environment or human health. Capitalist institutions produce to accumulate
power and wealth, not for any social good. Predictably, in order to cut costs,
Exxon steadily dismantled what emergency safeguards it had throughout the
1980s, pointing to environmental studies showing a major spill as so unlikely
that preparation was unnecessary. So when the inevitable came crashing down,
the response was complete impotence and negligence."_ [**Against the
Megamachine**, p. 57] As such, it cannot be stressed too much that the only
reason companies act any different (if and when they do) is because outside
agitators -- people who understand and cared about the planet and people more
than they did about company profits -- eventually forced them to.

So given all this, it is clear that privatising nature is no guarantee that
environmental problems will be reduced. In fact, it is more likely to have the
opposite effect. Even its own advocates suggest that their solution may
produce **more** pollution than the current system of state regulation. Terry
L. Anderson and Donald R. Leal put it this way:

> _ "If markets produce 'too little' clean water because dischargers do not
have to pay for its use, then political solutions are equally likely to
produce 'too much' clean water because those who enjoy the benefits do not pay
the cost . . . Just as pollution externalities can generate too much dirty
air, political externalities can generate too much water storage, clear-
cutting, wilderness, or water quality . . . Free market environmentalism
emphasises the importance of market process in determining optimal amounts of
resource use."_ [**Free Market Environmentalism**, p. 23]

What kind of environmentalism considers the possibility of "too much" clean
air and water? This means, ironically, that from the perspective of free-
market "environmentalism" that certain ecological features may be over-
protected as a result of the influence of non-economic goals and priorities.
Given that this model is proposed by many corporate funded think tanks, it is
more than likely that their sponsors think there is "too much" clean air and
water, "too much" wilderness and "too much" environmental goods. In other
words, the "optimal" level of pollution is currently too low as it doubtful
that corporations are seeking to increase their costs of production by
internalising even more externalities.

Equally, we can be sure that "too much" pollution _"is where the company
polluting the water has to pay too much to clean up the mess they make. It
involves a judgement that costs to the company are somehow synonymous with
costs to the community and therefore can be weighed against benefits to the
community."_ Such measures _"grant the highest decision-making power over
environmental quality to those who currently make production decisions. A
market system gives power to those most able to pay. Corporations and firms,
rather than citizens or environmentalists, will have the choice about whether
to pollute (and pay the charges or buy credits to do so)."_ [Sharon Beder,
**Global Spin**, p. 104]

The surreal notion of "too much" clean environment does indicate another key
problem with this approach, namely its confusion of need and demand with
**effective** demand. The fact is that people may desire a clean environment,
but they may not be able to afford to pay for it on the market. In a similar
way, there can be "too much" food while people are starving to death simply
because people cannot afford to pay for it (there is no effective demand for
food, but an obvious pressing need). Much the same can be said of environment
goods. A lack of demand for a resource today does **not** mean it is not
valued by individuals nor does it mean that it will not be valued in the
future. However, in the short-term focus produced by the market such goods
will be long-gone, replaced by more profitable investments.

The underlying assumption is that a clean environment is a luxury which we
must purchase from property owners rather than a right we have as human
beings. Even if we assume the flawed concept of self-ownership, the principle
upon which defenders of capitalism tend to justify their system, the principle
should be that our ownership rights in our bodies excludes it being harmed by
the actions of others. In other words, a clean environment should be a basic
right for all. Privatising the environment goes directly against this basic
ecological insight.

The state's environmental record **has** often been terrible, particularly as
its bureaucrats have been influenced by private interest groups when
formulating and implementing environmental policies. The state is far more
likely to be "captured" by capitalist interests than by environmental groups
or even the general community. Moreover, its bureaucrats have all too often
tended to weight the costs and benefits of specific projects in such a way as
to ensure that any really desired ones will go ahead, regardless of what local
people want or what the environmental impact will really be. Such projects,
needless to say, will almost always have powerful economic interests behind
them and will seek to ensure that "development" which fosters economic growth
is pursued. This should be unsurprising. If we assume, as "market advocates"
do, that state officials seek to further their own interests then classes with
the most economic wealth are most likely to be able to do that the best. That
the state will reflect the interests of those with most private property and
marginalise the property-less should, therefore, come as no surprise.

Yet the state is not immune to social pressure from the general public or the
reality of environmental degradation. This is proved, in its own way, by the
rise of corporate PR, lobbying and think-tanks into multi-million pound
industries. So while the supporters of the market stress its ability to change
in the face of consumer demand, their view of the alternatives is extremely
static and narrow. They fail, unsurprisingly, to consider the possibility of
alternative forms of social organisation. Moreover, they also fail to mention
that popular struggles can influence the state by means of direct action. For
them, state officials will always pursue their own private interests,
irrespective of popular pressures and social struggles (or, for that matter,
the impact of corporate lobbying). While it is possible that the state will
favour specific interests and policies, it does not mean that it cannot be
forced to consider wider ones by the general public (until such time as it can
be abolished, of course).

As we discussed in [section D.1.5](secD1.html#secd15), the fact the state can
be pressured by the general public is precisely why certain of its secondary
functions have been under attack by corporations and the wealthy (a task which
their well-funded think-tanls provide the rationales for). If all this is the
case (and it is), then why expect cutting out the middle-person by privatising
nature to improve matters? By its own logic, therefore, privatising nature is
hardly going to produce a better environment as it is unlikely that
corporations would fund policies which would result in more costs for
themselves and less access to valuable natural resources. As free market
environmentalism is premised on economic solutions to ecological problems and
assumes that economic agents will act in ways which maximise their own
benefit, such an obvious conclusion should come naturally to its advocates.
For some reason, it does not.

Ultimately, privatising nature rests on the ridiculous notion that a clean
environment is a privilege which we must buy rather than a right. Under "free
market environmentalism" private property is assumed to be the fundamental
right while there is no right to a clean and sustainable environment. In other
words, the interests of property owners are considered the most important
factor and the rest of us are left with the possibility of asking them for
certain environmental goods which they may supply if they make a profit from
so doing. This prioritisation and categorisation is by no means obvious and
uncontroversial. Surely the right to a clean and liveable environment is more
fundamental than those associated with property? If we assume this then the
reduction of pollution, soil erosion, and so forth are not goods for which we
must pay but rather rights to which we are entitled. In other words,
protecting species and ecosystem as well as preventing avoidable deaths and
illnesses are fundamental issues which simply transcend the market. Being
asked to put a price on nature and people is, at best, meaningless, or, at
worse, degrading. It suggests that the person simply does not understand why
these things are important.

But why should we be surprised? After all, private property bases itself on
the notion that we must buy access to land and other resources required for a
fully human life. Why should a clean environment and a healthy body be any
different? Yet again, we see the derived rights (namely private property)
trumping the fundamental base right (namely the right of self-ownership which
should automatically exclude harm by pollution). That this happens so
consistently should not come as too great a surprise, given that the theory
was invented to justify the appropriation of the fruits of the worker's labour
by the property owner (see [section B.4.2](secB4.html#secb42)). Why should we
be surprised that this is now being used to appropriate the rights of
individuals to a clean environment and turn it into yet another means of
expropriating them from their birthrights?

## E.3.2 How does economic power contribute to the ecological crisis?

So far in this section we have discussed why markets fail to allocate
environmental resources. This is due to information blocks and costs, lack of
fully internalised prices (externalities) and the existence of public goods.
Individual choices are shaped by the information available to them about the
consequences of their actions, and the price mechanism blocks essential
aspects of this and so information is usually partial at best within the
market. Worse, it is usually distorted by advertising and the media as well as
corporate and government spin and PR. Local knowledge is undermined by market
power, leading to unsustainable practices to reap maximum short term profits.
Profits as the only decision making criteria also leads to environmental
destruction as something which may be ecologically essential may not be
economically viable. All this means that the price of a good cannot indicate
its environmental impact and so that market failure is pervasive in the
environmental area. Moreover, capitalism is as unlikely to produce their fair
distribution of environmental goods any more than any other good or resource
due to differences in income and so demand (particularly as it takes the
existing distribution of wealth as the starting point). The reality of our
environmental problems provides ample evidence for this analysis.

During this discussion we have touched upon another key issue, namely how
wealth can affect how environmental and other externalities are produced and
dealt with in a capitalist system. Here we extend our critique by addressed an
issue we have deliberately ignored until now, namely the distribution and
wealth and its resulting economic power. The importance of this factor cannot
be stressed too much, as "market advocates" at best downplay it or, at worse,
ignore it or deny it exists. However, it plays the same role in environmental
matters as it does in, say, evaluating individual freedom within capitalism.
Once we factor in economic power the obvious conclusion is the market based
solutions to the environment will result in, as with freedom, people selling
it simply to survive under capitalism (as we discussed in [section
B.4](secB4.html), for example).

It could be argued that strictly enforcing property rights so that polluters
can be sued for any damages made will solve the problem of externalities. If
someone suffered pollution damage on their property which they had not
consented to then they could issue a lawsuit in order to get the polluter to
pay compensation for the damage they have done. This could force polluters to
internalise the costs of pollution and so the threat of lawsuits can be used
as an incentive to avoid polluting others.

While this approach could be considered as **part** of any solution to
environmental problems under capitalism, the sad fact is it ignores the
realities of the capitalist economy. The key phrase here is "not consented to"
as it means that pollution would be fine if the others agree to it (in return,
say, for money). This has obvious implications for the ability of capitalism
to reduce pollution. For just as working class people "consent" to hierarchy
within the workplace in return for access to the means of life, so to would
they "consent" to pollution. In other words, the notion that pollution can be
stopped by means of private property and lawsuits ignores the issue of class
and economic inequality. Once these are factored in, it soon becomes clear
that people may put up with externalities imposed upon them simply because of
economic necessity and the pressure big business can inflict.

The first area to discuss is inequalities in wealth and income. Not all
economic actors have equal resources. Corporations and the wealthy have far
greater resources at their disposal and can spend millions of pounds in
producing PR and advertising (propaganda), fighting court cases, influencing
the political process, funding "experts" and think-tanks, and, if need be,
fighting strikes and protests. Companies can use _"a mix of cover-up,
publicity campaigns and legal manoeuvres to continue operations unimpeded."_
They can go to court to try an _"block more stringent pollution controls."_
[David Watson, **Against the Megamachine**, p. 56] Also while, in principle,
the legal system offers equal protection to all in reality, wealthy firms and
individuals have more resources than members of the general public. This means
that they can employ large numbers of lawyers and draw out litigation
procedures for years, if not decades.

This can be seen around us today. Unsurprisingly, the groups which bear a
disproportionate share of environmental burdens are the poorest ones. Those at
the bottom of the social hierarchy have less resources available to fight for
their rights. They may not be aware of their rights in specific situations and
not organised enough to resist. This, of course, explains why companies spend
so much time attacking unions and other forms of collective organisation which
change that situation. Moreover as well as being less willing to sue, those on
lower income may be more willing to be bought-off due to their economic
situation. After all, tolerating pollution in return for some money is more
tempting when you are struggling to make ends meet.

Then there is the issue of effective demand. Simply put, allocation of
resources on the market is based on money and not need. If more money can be
made in, say, meeting the consumption demands of the west rather than the
needs of local people then the market will "efficiently" allocate resources
away from the latter to the former regardless of the social and ecological
impact. Take the example of Biofuels which have been presented by some as a
means of fuelling cars in a less environmentally destructive way. Yet this
brings people and cars into direct competition over the most "efficient" (i.e.
most profitable) use of land. Unfortunately, effective demand is on the side
of cars as their owners usually live in the developed countries. This leads to
a situation where land is turned from producing food to producing biofuels,
the net effect of which is to reduce supply of food, increase its price and so
produce an increased likelihood of starvation. It also gives more economic
incentive to destroy rainforests and other fragile eco-systems in order to
produce more biofuel for the market.

Green socialist John O'Neill simply states the obvious:

> _ "[The] treatment of efficiency as if it were logically independent of
distribution is at best misleading, for the determination of efficiency
already presupposes a given distribution of rights . . . [A specific outcome]
is always relative to an initial starting point . . . If property rights are
changed so also is what is efficient. Hence, the opposition between
distributional and efficiency criteria is misleading. Existing costs and
benefits themselves are the product of a given distribution of property
rights. Since costs are not independent of rights they cannot guide the
allocation of rights. Different initial distributions entail differences in
whose preferences are to count. Environmental conflicts are often about who
has rights to environment goods, and hence who is to bear the costs and who is
to bear the benefits . . . Hence, environmental policy and resource decision-
making cannot avoid making normative choices which include questions of
resource distribution and the relationships between conflicting rights claims
. . . The monetary value of a 'negative externality' depends on social
institutions and distributional conflicts -- willing to pay measures, actual
or hypothetical, consider preferences of the higher income groups [as] more
important than those of lower ones. If the people damaged are poor, the
monetary measure of the cost of damage will be lower -- 'the poor sell
cheap.'"_ [**Markets, Deliberation and Environment**, pp. 58-9]

Economic power also impacts on the types of contracts people make. It does not
take too much imagination to envision the possibility that companies may make
signing waivers that release it from liability a condition for working there.
This could mean, for example, a firm would invest (or threaten to move
production) only on condition that the local community and its workers sign a
form waiving the firm of any responsibility for damages that may result from
working there or from its production process. In the face of economic
necessity, the workers may be desperate enough to take the jobs and sign the
waivers. The same would be the case for local communities, who tolerate the
environmental destruction they are subjected to simply to ensure that their
economy remains viable. This already happens, with some companies including a
clause in their contracts which states the employee cannot join a union.

Then there is the threat of legal action by companies. _"Every year,"_ records
green Sharon Beder, _"thousands of Americans are sued for speaking out against
governments and corporations. Multi-million dollar law suits are being filed
against individual citizens and groups for circulating petitions, writing to
public officials, speaking at, or even just attending, public meetings,
organising a boycott and engaging in peaceful demonstrations."_ This trend has
spread to other countries and the intent is the same: to silence opposition
and undermine campaigns. This tactic is called a SLAPP (for _**"Strategic
Lawsuits Against Public Participation"**_) and is a civil court action which
does not seek to win compensation but rather aims _"to harass, intimidate and
distract their opponents . . . They win the political battle, even when they
lose the court case, if their victims and those associated with them stop
speaking out against them."_ This is an example of economic power at work, for
the cost to a firm is just part of doing business but could bankrupt an
individual or environmental organisation. In this way _"the legal system best
serves those who have large financial resources at their disposal"_ as such
cases take _"an average of three years to be settled, and even if the person
sued wins, can cost tens of thousands of dollars in legal fees. Emotional
stress, disillusionment, diversion of time and energy, and even divisions
within families, communities and groups can also result."_ [**Global Spin**,
pp. 63-7]

A SLAPP usually deters those already involved from continuing to freely
participate in debate and protest as well as deterring others from joining in.
The threat of a court case in the face of economic power usually ensures that
SLAPPS do not go to trial and so its objective of scaring off potential
opponents usually works quickly. The reason can be seen from the one case in
which a SLAPP backfired, namely the McLibel trial. After successfully forcing
apologies from major UK media outlets like the BBC, Channel 4 and the Guardian
by threatening legal action for critical reporting of the company, McDonald's
turned its attention to the small eco-anarchist group London Greenpeace (which
is not affiliated with Greenpeace International). This group had produced a
leaflet called _"What's Wrong with McDonald's"_ and the company sent spies to
its meetings to identify people to sue. Two of the anarchists refused to be
intimidated and called McDonald's bluff. Representing themselves in court, the
two unemployed activists started the longest trial in UK history. After three
years and a cost of around £10 million, the trial judge found that some of the
claims were untrue (significantly, McDonald's had successfully petitioned the
judge not to have a jury for the case, arguing that the issues were too
complex for the public to understand). While the case was a public relations
disaster for the company, McDonald's keeps going as before using the working
practices exposed in the trial and remains one of the world's largest
corporations confident that few people would have the time and resources to
fight SLAPPs (although the corporation may now think twice before suing
anarchists!).

Furthermore, companies are known to gather lists of known "trouble-makers"
These "black lists" of people who could cause companies "trouble" (i.e., by
union organising or suing employers over "property rights" issues) would often
ensure employee "loyalty," particularly if new jobs need references. Under
wage labour, causing one's employer "problems" can make one's current and
future position difficult. Being black-listed would mean no job, no wages, and
little chance of being re-employed. This would be the result of continually
suing in defence of one's property rights -- assuming, of course, that one had
the time and money necessary to sue in the first place. Hence working-class
people are a weak position to defend their rights under capitalism due to the
power of employers both within and without the workplace. All these are strong
incentives **not** to rock the boat, particularly if employees have signed a
contract ensuring that they will be fired if they discuss company business
with others (lawyers, unions, media, etc.).

Economic power producing terrible contracts does not affect just labour, it
also effects smaller capitalists as well. As we discussed in [section
C.4](secC4.html), rather than operating "efficiently" to allocate resources
within perfect competition any real capitalist market is dominated by a small
group of big companies who make increased profits at the expense of their
smaller rivals. This is achieved, in part, because their size gives such firms
significant influence in the market, forcing smaller companies out of business
or into making concessions to get and maintain contracts.

The negative environmental impact of such a process should be obvious. For
example, economic power places immense pressures towards monoculture in
agriculture. In the UK the market is dominated by a few big supermarkets.
Their suppliers are expected to produce fruits and vegetables which meet the
requirements of the supermarkets in terms of standardised products which are
easy to transport and store. The large-scale nature of the operations ensure
that farmers across Britain (indeed, the world) have to turn their farms into
suppliers of these standardised goods and so the natural diversity of nature
is systematically replaced by a few strains of specific fruits and vegetables
over which the consumer can pick. Monopolisation of markets results in the
monoculture of nature.

This process is at work in all capitalist nations. In American, for example,
the _"centralised purchasing decisions of the large restaurant chains and
their demand for standardised products have given a handful of corporations an
unprecedented degree of power over the nation's food supply . . . obliterating
regional differences, and spreading identical stores throughout the country .
. . The key to a successful franchise . . . can be expressed in one world:
'uniformity.'"_ This has resulted in the industrialisation of food production,
with the _"fast food chains now stand[ing] atop a huge food-industrial complex
that has gained control of American agriculture . . . large multinationals . .
. dominate one commodity market after another . . . The fast food chain's vast
purchasing power and their demand for a uniform product have encouraged
fundamental changes in how cattle are raised, slaughter, and processed into
ground beef. These changes have made meatpacking . . . into the most dangerous
job in the United States . . . And the same meat industry practices that
endanger these workers have facilitated the introduction of deadly pathogens .
. . into America's hamburger meat."_ [Eric Schlosser, **Fast Food Nation**, p.
5 and pp. 8-9]

Award winning journalist Eric Schlosser has presented an excellent insight in
this centralised and concentrated food-industrial complex in his book **Fast
Food Nation**. Schlosser, of course, is not alone in documenting the
fundamentally anti-ecological nature of the capitalism and how an alienated
society has created an alienated means of feeding itself. As a non-anarchist,
he does fail to drawn the obvious conclusion (namely abolish capitalism) but
his book does present a good overview of the nature of the processed at work
and what drives them. Capitalism has created a world where even the smell and
taste of food is mass produced as the industrialisation of agriculture and
food processing has lead to the product (it is hard to call it food) becoming
bland and tasteless and so chemicals are used to counteract the effects of
producing it on such a scale. It is standardised food for a standardised
society. As he memorably notes: _"Millions of . . . people at that very moment
were standing at the same counter, ordering the same food from the same menu,
food that tasted everywhere the same."_ The Orwellian world of modern
corporate capitalism is seen in all its glory. A world in which the industry
group formed to combat Occupational Safety and Health Administration
regulation is called _"Alliance for Workplace Safety"_ and where the processed
food's taste has to have the correct _"mouthfeel."_ Unsurprisingly, the
executives of these companies talk about _"the very essence of freedom"_ and
yet their corporation's _"first commandant is that only production counts . .
. The employee's duty is to follow orders. Period."_ In this irrational world,
technology will solve all our problems, even the ones it generates itself. For
example, faced with the serious health problems generated by the
industrialisation of meat processing, the meatpacking industry advocated yet
more technology to "solve" the problems caused by the existing technology.
Rather than focusing on the primary causes of meat contamination, they
proposed irradiating food. Of course the firms involved want to replace the
word _"irradiation"_ with the phrase _"cold pasteurisation"_ due to the public
being unhappy with the idea of their food being subject to radiation.

All this is achievable due to the economic power of fewer and fewer firms
imposing costs onto their workers, their customers and, ultimately, the
planet.

The next obvious factor associated with economic power are the pressures
associated with capital markets and mobility. Investors and capitalists are
always seeking the maximum return and given a choice between lower profits due
to greater environmental regulation and higher profits due to no such laws,
the preferred option will hardly need explaining. After all, the investor is
usually concerned with the returns they get in their investment, **not** in
its physical condition nor in the overall environmental state of the planet
(which is someone else's concern). This means that investors and companies
interest is in moving their capital to areas which return most money, not
which have the best environmental impact and legacy. Thus the mobility of
capital has to be taken into account. This is an important weapon in ensuring
that the agenda of business is untroubled by social concerns and environmental
issues. After all, if the owners and managers of capital consider that a
state's environmental laws too restrictive then it can simply shift
investments to states with a more favourable business climate. This creates
significant pressures on communities to minimise environmental protection both
in order to retain existing business and attract new ones.

Let us assume that a company is polluting a local area. It is usually the case
that capitalist owners rarely live near the workplaces they own, unlike
workers and their families. This means that the decision makers do not have to
live with the consequences of their decisions. The "free market" capitalist
argument would be, again, that those affected by the pollution would sue the
company. We will assume that concentrations of wealth have little or no effect
on the social system (which is a **highly** unlikely assumption, but never
mind). Surely, if local people did successfully sue, the company would be
harmed economically -- directly, in terms of the cost of the judgement,
indirectly in terms of having to implement new, eco-friendly processes. Hence
the company would be handicapped in competition, and this would have obvious
consequences for the local (and wider) economy.

This gives the company an incentive to simply move to an area that would
tolerate the pollution if it were sued or even threatened with a lawsuit. Not
only would existing capital move, but fresh capital would not invest in an
area where people stand up for their rights. This -- the natural result of
economic power -- would be a "big stick" over the heads of the local
community. And when combined with the costs and difficulties in taking a large
company to court, it would make suing an unlikely option for most people. That
such a result would occur can be inferred from history, where we see that
multinational firms have moved production to countries with little or no
pollution laws and that court cases take years, if not decades, to process.

This is the current situation on the international market, where there is
competition in terms of environment laws. Unsurprisingly, industry tends to
move to countries which tolerate high levels of pollution (usually because of
authoritarian governments which, like the capitalists themselves, simply
ignore the wishes of the general population). Thus we have a market in
pollution laws which, unsurprisingly, supplies the ability to pollute to meet
the demand for it. This means that developing countries _"are nothing but a
dumping ground and pool of cheap labour for capitalist corporations. Obsolete
technology is shipped there along with the production of chemicals, medicines
and other products banned in the developed world. Labour is cheap, there are
few if any safety standards, and costs are cut. But the formula of cost-
benefit still stands: the costs are simply borne by others, by the victims of
Union Carbide, Dow, and Standard Oil."_ [David Watson, **Op. Cit.**, p. 44]
This, it should be noted, makes perfect economic sense. If an accident
happened and the poor actually manage to successfully sue the company, any
payments will reflect their lost of earnings (i.e., not very much).

As such, there are other strong economic reasons for doing this kind of
pollution exporting. You can estimate the value of production lost because of
ecological damage and the value of earnings lost through its related health
problems as well as health care costs. This makes it more likely that
polluting industries will move to low-income areas or countries where the
costs of pollution are correspondingly less (particularly compared to the
profits made in selling the products in high-income areas). Rising incomes
makes such goods as safety, health and the environment more valuable as the
value of life is, for working people, based on their wages. Therefore, we
would expect pollution to be valued less when working class people are
affected by it. In other words, toxic dumps will tend to cluster around poorer
areas as the costs of paying for the harm done will be much less. The same
logic underlies the arguments of those who suggest that Third World countries
should be dumping grounds for toxic industrial wastes since life is cheap
there

This was seen in early 1992 when a memo that went out under the name of the
then chief economist of the World Bank, Lawrence Summers, was leaked to the
press. Discussing the issue of _"dirty"_ Industries, the memo argued that the
World Bank should _"be encouraging MORE migration of the dirty industries"_ to
Less Developed Countries and provided three reasons. Firstly, the
_"measurements of the costs of health impairing pollution depends on the
foregone earnings from increased morbidity and mortality"_ and so _"pollution
should be done in the country with the lowest cost, which will be the country
with the lowest wages."_ Secondly, _"that under-populated countries in Africa
are vastly UNDER-polluted, their air quality is probably vastly inefficiently
low compared to Los Angeles or Mexico City."_ Thirdly, the _"demand for a
clean environment for aesthetic and health reasons is likely to have very high
income elasticity."_ Concern over pollution related illness would be higher in
a country where more children survive to get them. _"Also, much of the concern
over industrial atmosphere discharge is about visibility impairing
particulates . . . Clearly trade in goods that embody aesthetic pollution
concerns could be welfare enhancing. While production is mobile the
consumption of pretty air is a non-tradable."_ The memo notes _"the economic
logic behind dumping a load of toxic waste in the lowest wage country is
impeccable and we should face up to that"_ and ends by stating that the
_"problem with the arguments against all of these proposals for more
pollution"_ in the third world _"could be turned around and used more or less
effectively against every Bank proposal for liberalisation."_ [**The
Economist**, 08/02/1992]

While Summers accepted the criticism for the memo, it was actually written by
Lant Pritchett, a prominent economist at the Bank. Summers claimed he was
being ironic and provocative. **The Economist**, unsurprisingly, stated _"his
economics was hard to answer"_ while criticising the language used. This was
because clean growth may slower than allowing pollution to occur and this
would stop _"helping millions of people in the third world to escape their
poverty."_ [15/02/1992] So not only is poisoning the poor with pollution is
economically correct, it is in fact required by morality. Ignoring the false
assumption that growth, any kind of growth, always benefits the poor and the
utter contempt shown for both those poor themselves and our environment what
we have here is the cold logic that drives economic power to move location to
maintain its right to pollute our common environment. Economically, it is
perfectly logical but, in fact, totally insane (this helps explain why making
people "think like an economist" takes so many years of indoctrination within
university walls and why so few achieve it).

Economic power works in other ways as well. A classic example of this at work
can be seen from the systematic destruction of public transport systems in
America from the 1930s onwards (see David St. Clair's **The Motorization of
American Cities** for a well-researched account of this). These systems were
deliberately bought by automotive (General Motors), oil, and tire corporations
in order to eliminate a less costly (both economically **and** ecologically)
competitor to the automobile. This was done purely to maximise sales and
profits for the companies involved yet it transformed the way of life in
scores of cities across America. It is doubtful that if environmental concerns
had been considered important at the time that they would have stopped this
from happening. This means that individual consumption decisions will be made
within an market whose options can be limited simply by a large company buying
out and destroying alternatives.

Then there is the issue of economic power in the media. This is well
understood by corporations, who fund PR, think-tanks and "experts" to
counteract environmental activism and deny, for example, that humans are
contributing to global warming. Thus we have the strange position that only
Americans think that there is a debate on the causes of global warming rather
than a scientific consensus. The actions of corporate funded "experts" and PR
have ensured **that** particular outcome. As Sharon Beder recounts in her book
**Global Spin: The Corporate Assault on Environmentalism**, a large amount of
money is being spent on number sophisticated techniques to change the way
people think about the environment, what causes the problems we face and what
we can and should do about it. Compared to the resources of environmental and
green organisations, it is unsurprising that this elaborate multi-billion
pound industry has poisoned public debate on such a key issue for the future
of humanity by propaganda and dis-information.

Having substantial resources available means that the media can be used to
further an anti-green agenda and dominate the debate (at least for a while).
Take, as an example, **The Skeptical Environmentalist**, a book by Bjørn
Lomborg (a political scientist and professor of statistics at the University
of Aarhus in Denmark). When it was published in 2001, it caused a sensation
with its claims that scientists and environmental organisations were making,
at best, exaggerated and, at worse, false claims about the world's
environmental problems. His conclusion was panglossian in nature, namely that
there was not that much to worry about and we can continue as we are. That, of
course, was music to the ears of those actively destroying the environment as
it reduces the likelihood that any attempt will be made to stop them.

Unsurprisingly, the book was heavily promoted by the usual suspects and, as a
result received significant attention from the media. However, the
**extremely** critical reviews and critiques it subsequently produced from
expert scientists on the issues Lomborg discussed were less prominently
reviewed in the media, if at all. That critics of the book argued that it was
hardly an example of good science based on objectivity, understanding of the
underlying concepts, appropriate statistical methods and careful peer review
goes without saying. Sadly, the fact that numerous experts in the fields
Lomborg discussed showed that his book was seriously flawed, misused data and
statistics and marred by flawed logic and hidden value judgements was not
given anything like the same coverage even though this information is far more
important in terms of shaping public perception. Such works and their
orchestrated media blitz provides those with a vested interest in the status
quo with arguments that they should be allowed to continue their anti-
environmental activities and agenda. Moreover, it takes up the valuable time
of those experts who have to debunk the claims rather than do the research
needed to understand the ecological problems we face and propose possible
solutions.

As well as spin and propaganda aimed at adults, companies are increasingly
funding children's education. This development implies obvious limitations on
the power of education to solve ecological problems. Companies will hardly
provide teaching materials or fund schools which educate their pupils on the
**real** causes of ecological problems. Unsurprisingly, a 1998 study in the US
by the Consumers Union found that 80% of teaching material provided by
companies was biased and provided students with incomplete or slanted
information that favoured its sponsor's products and views [Schlosser, **Op.
Cit.**, p. 55] The more dependent a school is on corporate funds, the less
likely it will be to teach its students the necessity to question the
motivations and activities of business. That business will not fund education
which it perceives as anti-business should go without saying. As Sharon Beder
summarises, _"the infiltration of school curricula through banning some texts
and offering corporate-based curriculum material and lesson plans in their
place can conflict with educational objectives, and also with the attainment
of an undistorted understanding of environmental problems."_ [**Op. Cit.**,
pp. 172-3]

This indicates the real problem of purely "educational" approaches to solving
the ecological crisis, namely that the ruling elite controls education (either
directly or indirectly). This is to be expected, as any capitalist elite must
control education because it is an essential indoctrination tool needed to
promote capitalist values and to train a large population of future wage-
slaves in the proper habits of obedience to authority. Thus capitalists cannot
afford to lose control of the educational system. And this means that such
schools will not teach students what is really necessary to avoid ecological
disaster: namely the dismantling of capitalism itself. And we may add,
alternative schools (organised by libertarian unions and other associations)
which used libertarian education to produce anarchists would hardly be
favoured by companies and so be effectively black-listed - a real deterrent to
their spreading through society. Why would a capitalist company employ a
graduate of a school who would make trouble for them once employed as their
wage slave?

Finally, needless to say, the combined wealth of corporations and the rich
outweighs that of even the best funded environmental group or organisation (or
even all of them put together). This means that the idea of such groups
buying, say, rainforest is unlikely to succeed as they simply do not have the
resources needed -- they will be outbid by those who wish to develop
wilderness regions. This is particularly the case once we accept the framework
of economic self-interest assumed by market theory. This implies that
organisations aiming to increase the income of individual's will be better
funded than those whose aim is to preserve the environment for future
generations. As recent developments show, companies can and do use that
superior resources to wage a war for hearts and minds in all aspects of
society, staring in the schoolroom. Luckily no amount of spin can nullify
reality or the spirit of freedom and so this propaganda war will continue as
long as capitalism does.

In summary, market solutions to environmental problems under capitalism will
always suffer from the fact that real markets are marked by economic
inequalities and power.

## E.3.3 Can capitalism's focus on short-term profitability deal with the
ecological crisis?

No a word, no. This is another key problem associated with capitalism's
ability to deal with the ecological crisis it helps create. Due to the nature
of the market, firms are forced to focus on short-term profitability rather
than long-term survival. This makes sense. If a company does not make money
now, it will not be around later.

This, obviously, drives the creation of "externalities" discussed in previous
sections. Harmful environmental effects such as pollution, global warming,
ozone depletion, and destruction of wildlife habitat are not counted as "costs
of production" in standard methods of accounting because they are borne by
everyone in the society. This gives companies a strong incentive to ignore
such costs as competition forces firms to cut as many costs as possible in
order to boost short-term profits.

To give an obvious example, if a firm has to decide between installing a piece
of costly equipment which reduces its pollution and continuing as it currently
is, then it is more likely to do the latter. If the firm **does** invest then
its costs are increased and it will lose its competitive edge compared to its
rivals who do not make a similar investment. The "rational" decision is,
therefore, not to invest, particularly if by externalising costs it can
increase its profits or market share by cutting prices. In other words, the
market rewards the polluters and this is a powerful incentive to maximise such
activities. The market, in other words, provides incentives to firms to
produce externalities as part their drive for short-term profitability. While
this is rational from the firm's position, it is collectively irrational as
the planet's ecology is harmed.

The short-term perspective can also be seen by the tendency of firms to under-
invest in developing risky new technologies. This is because basic research
which may take years, if not decades, to develop and most companies are
unwilling to take on that burden. Unsurprisingly, most advanced capitalist
countries see such work funded by the state (as we noted in [section
D.8](secD8.html), over 50% of total R&amp;D funding has been provided by the
federal state in the USA). Moreover, the state has provided markets for such
products until such time as markets have appeared for them in the commercial
sector. Thus capitalism, by itself, will tend to under-invest in long term
projects:

> _ "in a competitive system you do **short-term planning only** . . . Let's
take corporate managers, where there's no real confusion about what they're
doing. They are maximising profit and market share in the short term. In fact,
if they were not to do that, they would no longer exist. Let's be concrete.
Suppose that some automobile company, say General Motors, decides to devote
their resources to planning for something that will be profitable ten years
from now. Suppose that's where they divert their resources: they want to think
in some long-term conception of market dominance. Their rivals are going to
maximising profit and power in the short term, and they're going to take over
the market, and General Motors won't be in business. That's true for the
owners and also for the managers. The managers want to stay managers. They can
fight off hostile take-over bids, they can keep from being replaced, as long
as they contribute to short-term profitability. As a result, long-term
considerations are rarely considered in competitive systems."_ [Noam Chomsky,
**Language and Politics**, p. 598]

This does not mean that firms will not look into future products nor do
research and development. Many do (particularly if helped by the state). Nor
does it imply that some industries do not have a longer-term perspective. It
simply shows that such activity is not the normal state of affairs. Moreover,
any such "long-term" perspective is rarely more than a decade while an
ecological perspective demands much more than this. This also applies to
agriculture, which is increasingly being turned into agribusiness as small
farmers are being driven out of business. Short-termism means that progress in
agriculture is whatever increases the current yield of a crop even if means
destroying the sources of fertility in the long run in order to maintain
current fertility by adding more and more chemicals (which run off into
rivers, seep into the water table and end up in the food itself.

This kind of irrational short-term behaviour also afflicts capital markets as
well. The process works in the same way Chomsky highlights. Suppose there are
3 companies, X, Y, and Z and suppose that company X invests in the project of
developing a non-polluting technology within ten years. At the same time its
competitors, Y and Z, will be putting their resources into increasing profits
and market share in the coming days and months and over the next year. During
that period, company X will be unable to attract enough capital from investors
to carry out its plans, since investors will flock to the companies that are
most immediately profitable. This means that the default position under
capitalism is that the company (or country) with the lowest standards enjoys a
competitive advantage, and drags down the standards of other companies (or
countries). Sometimes, though, capital markets experience irrational bubbles.
During the dot.com boom of the 1990s, investors did plough money into internet
start-ups and losses were tolerated for a few years in the expectation of high
profits in the near future. When that did not happen, the stock market crashed
and investors turned away from that market in droves. If something similar
happened to eco-technologies, the subsequent aftermath may mean that funding
essential for redressing our interaction with the environment would not be
forthcoming until the memories of the crash had disappeared in the next bubble
frenzy.

Besides, thanks to compound interest benefits far in the future have a very
small present value. If $1 were left in a bank at 5% annual interest, it would
be worth more than $2 million after 300 years. So if it costs $1 today to
prevent ecological damage worth $2 million in the 24th century then economic
theory argues that our descendants would be better off with us putting that $1
in the bank. This would suggest that basing our responsibility to future
generations on economics may not be the wisest course.

The supporter of capitalism may respond by arguing that business leaders are
as able to see long-term negative environmental effects as the rest of us. But
this is to misunderstand the nature of the objection. It is not that business
leaders **as individuals** are any less able to see what's happening to the
environment. It is that if they want to keep their jobs they have to do what
the system requires, which is to concentrate on what is most profitable in the
short term. Thus if the president of company X has a mystical experience of
oneness with nature and starts diverting profits into pollution control while
the presidents of Y and Z continue with business as usual, the stockholders of
company X will get a new president who is willing to focus on short-term
profits like Y and Z. As Joel Bakan stresses, managers of corporations _"have
a legal duty to put shareholders' interests above all others . . . Corporate
social responsibility is thus illegal -- at least when it is genuine."_ Ones
which _"choose social and environmental goals over profits -- who try and act
morally -- are, in fact, immoral"_ as their role in both the economy and
economic ideology is to _"make much as much money as possible for
shareholders."_ [**The Corporation**, pp. 36-7 and p. 34]

In general, then, if one company tries to devote resources to develop products
or processes that are ecologically responsible, they will simply be undercut
by other companies which are not doing so (assuming such products or processes
are more expensive, as they generally are as the costs are not inflicted on
other people and the planet). While some products may survive in small niche
markets which reflect the fact that many people are willing and able to pay
more to protect their world, in general they will not be competitive in the
market and so the ecologically damaging products will have the advantage. In
other words, capitalism has a built-in bias toward short-term gain, and this
bias -- along with its inherent need for growth -- means the planet will
continue its free-fall toward ecological disaster so long as capitalism
exists.

This suggests that attempts to address ecological problems like pollution and
depletion of resources by calling for public education are unlikely to work.
While it is true that this will raise people's awareness to the point of
creating enough demand for environment-friendly technologies and products that
they will be profitable to produce, it does not solve the problem that the
costs involved in doing such research now cannot be met by a possible future
demand. Moreover, the costs of such technology can initially be quite high and
so the effective demand for such products may not be sufficient. For example,
energy-saving light bulbs have been around for some time but have been far
more expensive that traditional ones. This means that for those on lower-
incomes who would, in theory, benefit most from lower-energy bills cannot
afford them. Thus their short-term income constrains undermine long-term
benefits.

Even if the research is completed, the market itself can stop products being
used. For example, the ability to produce reasonably inexpensive solar
photovoltaic power cells has existed for some time. The problem is that they
are currently very expensive and so there is a limited demand for them. This
means that no capitalist wants to risk investing in factory large enough to
take advantage of the economies of scale possible. The net effect is that
short-term considerations ensure that a viable eco-technology has been
margainalised.

This means that no amount of education can countermand the effects of market
forces and the short-term perspective they inflict on us all. If faced with a
tight budget and relatively expensive "ecological" products and technology,
consumers and companies may be forced to choose the cheaper, ecologically
unfriendly product to make ends meet or survive in the market. Under
capitalism, we may be free to choose, but the options are usually lousy
choices, and not the only ones potentially available in theory (this is a key
problem with green consumerism -- see [section E.5](secE5.html)).

The short-termism of capitalism has produced, in effect, a system which is _"a
massive pyramid scheme that will collapse somewhere down the line when all the
major players have already retired from the game. Of course when the last of
these hustlers cash in their chips, there won't be any place left to retire
to."_ [David Watson, **Op. Cit.**, p. 57]

[‹ E.2 What do eco-anarchists propose instead of capitalism?](/afaq/secE2.html
"Go to previous page" ) [up](/afaq/secEcon.html "Go to parent page" ) [E.4 Can
laissez-faire capitalism protect the environment? ›](/afaq/secE4.html "Go to
next page" )

