# D.2 What influence does wealth have over politics?

The short answer is: a great deal of influence, directly and indirectly. We
have already touched on this in [section B.2.3](secB2.html#secb23). Here we
will expand on those remarks.

State policy in a capitalist democracy is usually well-insulated from popular
influence but very open to elite influence and money interests. Let's consider
the possibility of direct influence first. It's obvious that elections cost
money and that only the rich and corporations can realistically afford to take
part in a major way. Even union donations to political parties cannot
effectively compete with those from the business classes. For example, in the
1972 US presidential elections, of the $500 million spent, only about $13
million came from trade unions. The vast majority of the rest undoubtedly came
from Big Business and wealthy individuals. For the 1956 elections, the last
year for which direct union-business comparisons are possible, the
contributions of 742 businessmen matched those of unions representing 17
million workers. This, it should be stressed was at a time when unions had
large memberships and before the decline of organised labour in America. Thus
the evidence shows that it is _"irrefutable"_ that _"businessmen contribute
vastly greater sums of money to political campaigns than do other groups [in
society]. Moreover, they have special ease of access to government officials,
and they are disproportionately represented at all upper levels of
government."_ [David Schweickart, **Against Capitalism**, pp. 210-1]

Therefore, logically, politics will be dominated by the rich and powerful --
in fact if not in theory -- since, in general, only the rich can afford to run
and only parties supported by the wealthy will gain enough funds and
favourable press coverage to have a chance (see [section D.3](secD3.html) for
the wealthy's control of the mass media). Of course, there are many countries
which do have labour-based parties, often allied with union movements, as is
the case in Western Europe, for example. Yet even here, the funds available
for labour parties are always less than those of capitalist supported parties,
meaning that the ability of the former to compete in "fair" elections is
hindered. In addition, the political agenda is dominated by the media and as
the media are owned by and dependent upon advertising from business, it is
hardly surprising that independent labour-based political agendas are
difficult to follow or be taken seriously. Unsurprisingly, many of these so-
called labour or social-democratic parties have moved to the right
(particularly since the 1980s). In Britain, for example, the New Labour
government which was elected in 1997 simply, in the main, followed the
policies of the previous Conservative Governments and saw its main funding
switch from unions to wealthy business men (sometimes in the form of "loans"
which could be hidden from the accounts). Significantly, New Labour's success
was in part dependent on support from the right-wing media empire of Rupert
Murdoch (Blair even consulted with him on policy, indicating his hold over the
government).

Then there are the barriers involved once a party has gained office. Just
because a party has become the government, it does not mean that they can
simply implement their election promises. There are also significant pressures
on politicians from the state bureaucracy itself. The state structure is
designed to ensure that real power lies not in the hands of elected
representatives but rather in the hands of officials, of the state bureaucracy
which ensures that any pro-labour political agenda will be watered down and
made harmless to the interests of the ruling class. We discuss this in
[section J.2.2](secJ2.html#secj22) and will not do so here.

To this it must be added that wealth has a massive **indirect** influence over
politics (and so over society and the law). We have noted above that wealth
controls the media and its content. However, beyond this there is what can be
called "Investor Confidence," which is another important source of influence.
This is _"the key to capitalist stability,"_ notes market socialist David
Schweickart. _"If a government initiates policies that capitalists perceive to
be opposed to their interests, they may, with neither organisation nor even
spitefulness, become reluctant to invest [or actually dis-invest] in the
offending country (or region or community), not if 'the climate for business
is bad.' The outcome of such isolated acts is an economic downturn, and hence
political instability. So a government . . . has no real choice but to regard
the interests of business as privileged. In a very real sense, what is good
for business really is good for the country. If business suffers, so will
everyone else."_ [**Op. Cit.**, pp. 214-5]

Hence Chomsky's comment that when _"popular reform candidates . . . get
elected . . . you get [a] capital strike -- investment capital flows out of
the country, there's a lowering of investment, and the economy grinds to a
halt . . . The reason is quite simple. In our society, real power does not
happen to lie in the political system, it lies in the private economy; that's
were the decisions are made about what's produced, how much is produced,
what's consumed, where investment takes place, who has jobs, who controls the
resources, and so on and so forth. And as long as that remains the case,
changes inside the political system can make **some** difference -- I don't
want to say it's zero -- but the differences are going to be very slight."_
This means that government policy is forced to make _"the rich folk happy"_
otherwise _"everything's going to grind to a halt."_ [**Understanding Power**,
pp. 62-3] As we discuss in the [next section](secD2.html#secd21), this is
precisely what **has** happened.

David Noble provides a good summary of the effects of such indirect pressures
when he writes firms _"have the ability to transfer production from one
country to another, to close a plant in one and reopen it elsewhere, to direct
and redirect investment wherever the 'climate' is most favourable [to
business]. . . . [I]t has enabled the corporation to play one workforce off
against another in the pursuit of the cheapest and most compliant labour
(which gives the misleading appearance of greater efficiency). . . [I]t has
compelled regions and nations to compete with one another to try and attract
investment by offering tax incentives, labour discipline, relaxed
environmental and other regulations and publicly subsidised infrastructure. .
. Thus has emerged the great paradox of our age, according to which those
nations that prosper most (attract corporate investment) by most readily
lowering their standard of living (wages, benefits, quality of life, political
freedom). The net result of this system of extortion is a universal lowering
of conditions and expectations in the name of competitiveness and
prosperity."_ [**Progress Without People**, pp. 91-92]

And, we must note, even when a country **does** lower its standard of living
to attract investment or encourage its own business class to invest (as the
USA and UK did by means of recession to discipline the workforce by high
unemployment) it is no guarantee that capital will stay. US workers have seen
their companies' profits rise while their wages have stagnated and (in reward)
hundreds of thousands have been "down-sized" or seen their jobs moved to
Mexico or South East Asia sweatshops. In the far east, Japanese, Hong Kong,
and South Korean workers have also seen their manufacturing jobs move to low
wage (and more repressive/authoritarian) countries such as China and
Indonesia.

As well as the mobility of capital, there is also the threat posed by public
debt. As Doug Henwood notes, _"[p]ublic debt is a powerful way of assuring
that the state remains safely in capital's hands. The higher a government's
debt, the more it must please its bankers. Should bankers grow displeased,
they will refuse to roll over old debts or to extend new financing on any but
the most punishing terms (if at all). The explosion of [US] federal debt in
the 1980s vastly increased the power of creditors to demand austere fiscal and
monetary policies to dampen the US economy as it recovered . . . from the
1989-92 slowdown."_ [**Wall Street**, pp. 23-24] And, we must note, Wall
street made a fortune on the debt, directly and indirectly.

This analysis applies within countries as well. Commenting on Clinton's plans
for the devolution of welfare programmes from Federal to State government in
America, Noam Chomsky makes the important point that _"under conditions of
relative equality, this could be a move towards democracy. Under existing
circumstances, devolution is intended as a further blow to the eroding
democratic processes. Major corporations, investment firms, and the like, can
constrain or directly control the acts of national governments and can set one
national workforce against another. But the game is much easier when the only
competing player that might remotely be influenced by the 'great beast' is a
state government, and even middle-sized enterprise can join in. The shadow
cast by business [over society and politics] can thus be darker, and private
power can move on to greater victories in the name of freedom."_ [Noam
Chomsky, _"Rollback III"_, **Z Magazine**, March, 1995]

Economic blackmail is a very useful weapon in deterring freedom. Little wonder
Proudhon argued that the _"Revolutionary principle . . . is Liberty. In other
words, no more government of man by man through the accumulation of capital."_
[quoted by Jack Hayward, **After the French Revolution**, p. 177]

## D.2.1 Is capital flight really that powerful?

Yes. By capital flight, business can ensure that any government which becomes
too independent and starts to consider the interests of those who elected it
will be put back into its place. Therefore we cannot expect a different group
of politicians to react in different ways to the same institutional influences
and interests. It's no coincidence that the Australian Labour Party and the
Spanish Socialist Party introduced "Thatcherite" policies at the same time as
the "Iron Lady" implemented them in Britain. The New Zealand Labour government
is a case in point, where _"within a few months of re-election [in 1984],
finance minister Roger Douglas set out a programme of economic 'reforms' that
made Thatcher and Reagan look like wimps. . . .[A]lmost everything was
privatised and the consequences explained away in marketspeak. Division of
wealth that had been unknown in New Zealand suddenly appeared, along with
unemployment, poverty and crime."_ [John Pilger, _"Breaking the one party
state,"_ **New Statesman**, 16/12/94]

An extreme example of capital flight being used to "discipline" a naughty
administration can be seen from Labour governments in Britain during the 1960s
and 1970s. Harold Wilson, the Labour Prime Minister between 1964 and 1970,
recorded the pressures his government was under from "the markets":

> _ "We were soon to learn that decisions on pensions and taxation were no
longer to be regarded, as in the past, as decisions for parliament alone. The
combination of tax increases with increased social security benefits provoked
the first of a series of attacks on sterling, by speculators and others, which
beset almost every section of the government for the next five years."_ [**The
Labour Government 1964-1970**, p. 31]

He also had to _"listen night after night to demands that there should be cuts
in government expenditure, and particularly in those parts of government
expenditure which related to social services. It was not long before we were
being asked, almost at pistol-point to cut back on expenditure"_ by the
Governor of the Bank of England, the stock exchange's major mouthpiece. [**Op.
Cit.**, p. 34] One attempt to pressurise Wilson resulted in him later
reflecting:

> _ "Not for the first time, I said that we had now reached the situation
where a newly elected government with a mandate from the people was being
told, not so much by the Governor of the Bank of England but by international
speculators, that the policies on which we had fought the election could not
be implemented; that the government was to be forced into the adoption of Tory
policies to which it was fundamentally opposed. The Governor confirmed that
that was, in fact, the case."_ [**Op. Cit.**, p. 37]

Only the bluff of threatening to call another general election allowed Wilson
to win that particular battle but his government was constrained. It
implemented only some of the reforms it had won the election on while
implementing many more policies which reflected the wishes of the capitalist
class (for example, attempts to shackle the rank and file of the unions).

A similar process was at work against the 1974 to 1979 Labour government. In
January, 1974, the FT Index for the London Stock Exchange stood at 500 points.
In February, the Miner's went on strike, forcing Heath (the Tory Prime
Minister) to hold (and lose) a general election. The new Labour government
(which included some left-wingers in its cabinet) talked about nationalising
the banks and much heavy industry. In August, 1974, Tony Benn announced plans
to nationalise the ship building industry. By December, the FT index had
fallen to 150 points. [John Casey, _"The Seventies"_, **The Heavy Stuff**, no.
3, p. 21] By 1976 the Treasury was _"spending $100 million a day buying back
its own money on the markets to support the pound."_ [**The Times**, 10/6/76]

**The Times** [27/5/76] noted that _"the further decline in the value of the pound has occurred despite the high level of interest rates. . . . [D]ealers said that selling pressure against the pound was not heavy or persistent, but there was an almost total lack of interest amongst buyers. The drop in the pound is extremely surprising in view of the unanimous opinion of bankers, politicians and officials that the currency is undervalued."_ While there was much talk of private armies and military intervention, this was not needed. As anarchist John Casey argues, the ruling class _"chose to play the economic card . . . They decided to subdue the rogue Labour administration by pulling the financial plugs out of the economy . . . This resulted in the stock market and the pound plummeting . . . This was a much neater solution than bullets and forced the Wilson government to clean up the mess by screwing the working class with public spending cuts and a freeze on wage claims . . . The whole process of economic sabotage was neatly engineering through third parties like dealers in the currency markets."_ [**Op. Cit.**, p. 23]

The Labour government, faced with the power of international capital, ended up
having to receive a temporary "bailing out" by the IMF, which imposed a
package of cuts and controls, to which Labour's response was, in effect,
_"We'll do anything you say,"_ as one economist described it. The social costs
of these policies were disastrous, with unemployment rising to the then
unheard-of-height of one million. And let's not forget that they _"cut
expenditure by twice the amount the IMF were promised"_ in an attempt to
appear business-friendly. [Peter Donaldson, **A Question of Economics**, p.
89] By capital flight, a slightly radical Labour government was brought to
heel.

Capital will not invest in a country that does not meet its approval. In 1977,
the Bank of England failed to get the Labour government to abolish its
exchange controls. Between 1979 and 1982 the Tories abolished them and ended
restrictions on lending for banks and building societies:

> _ "The result of the abolition of exchange controls was visible almost
immediately: capital hitherto invested in the U.K. began going abroad. In the
**Guardian** of 21 September, 1981, Victor Keegan noted that 'Figures
published last week by the Bank of England show that pension funds are now
investing 25% of their money abroad (compared with almost nothing a few years
ago) and there has been no investment at all (net) by unit trusts in the UK
since exchange controls were abolished.'"_ [Robin Ramsay, _"Mrs Thatcher,
North Sea and the Hegemony of the City"_, pp. 2-9, **Lobster**, no. 27, p. 3]

This contributed to the general mismanagement of the economy by Thatcher's
Monetarist government. While Milton Friedman had predicted _"only a modest
reduction in output and employment will be a side effect of reducing inflation
to single figures by 1982,"_ the actual results of applying his ideas were
drastically different. [quoted by Michael Stewart, **Keynes and After**, p.
179] Britain experienced its deepest recession since the 1930s, with
unemployment nearly tripling between 1979 and 1985 (officially, from around 5%
to 13% but the real figure was even higher as the government changed the
method of measuring it to reduce the figures!). Total output fell by 2.5% in
1980 and another 1.5% in 1981. By 1984 manufacturing investment was still 30%
lower in 1979. [Steward, **Op. Cit.**, p. 180] Poverty and inequality soared
as unemployment and state repression broke the back of the labour movement and
working class resistance.

Eventually, capital returned to the UK as Thatcher's government had subdued a
militant working class, shackled the trade unions by law and made the welfare
state difficult to live on. It reversed many of the partial gains from
previous struggles and ended a situation where people had enough dignity not
to accept any job offered or put up with an employer's authoritarian
practices. These factors created "inflexibility" in the labour market, so that
the working class had to be taught a lesson in "good" economics (in part,
ironically, by mismanaging the economy by applying neoclassical dogmas in
their Monetarist form!).

Needless to say, the situation in the 21st century has become worse. There has
been a _"huge rise in international borrowing . . . in international capital
markets since the liberalisation moves of the 1970s, and [a] significant
increase in foreign penetration of national central government bond markets."_
This means that it is _"obvious that no central government today may follow
economic policies that are disapproved of by the capital markets, which have
the power to create an intolerable economic pressure on the respective
country's borrowing ability, currency value and investment flows."_ [Takis
Fotopoulos, **Toward an Inclusive Democracy**, p. 42] We discuss globalisation
in more detail in [section D.5](secD5.html).

Unsurprisingly, when left-wing governments have been elected into office after
the 1980s, they have spent a lot of time during the election showing how
moderate they are to the capitalist class ("the markets"). This moderation
continued once in office and any reforms implemented have been of a minor
nature and placed within a general neo-liberal context. This was the fate of
the British Labour government of Tony Blair, while in Brazil the government of
Lula (a former lathe operator, labour union leader and Brazil's first working-
class president) was termed "Tropical Blairism" by left-wing critics. Rather
than use popular mandate to pursue social justice, they have governed for the
rich. Given the role of the state and the pressures governments experience
from capital, anarchists were not surprised.

Of course, exceptions can occur, with popular governments implementing
significant reforms when economic and political circumstances are favourable.
However, these generally need popular movements at the same time to be really
effective and these, at some stage, come into conflict with the reformist
politicians who hold them back. Given the need for such extra-parliamentary
movements to ensure reforms anarchists consider their time better spent
building these than encouraging illusions about voting for radical politicians
to act for us (see [section J.2](secJ2.html) for details).

## D.2.2 How extensive is business propaganda?

Business spends a lot of money to ensure that people accept the status quo.
Referring again to the US as an example (where such techniques are common),
various means are used to get people to identify "free enterprise" (meaning
state-subsidised private power with no infringement of managerial
prerogatives) as "the American way." The success of these campaigns is clear,
since many American working people (for example) now object to unions ing too
much power or irrationally rejecting all radical ideas as "Communism" (i.e.
Stalinism) regardless of their content. By the 1990s, it had even made
"liberal" (i.e. mildly reformist centre-left policies) into a swear word in
some parts of the country.

This is unsurprising and its roots can be found in the success of sort of
popular movements business propaganda was created to combat. As Chomsky
argues, due to popular struggles, _"the state has limited capacity to coerce"_
in the advanced capitalist countries (although it is always there, to be used
when required). This meant that _"elite groups -- the business world, state
managers and so on -- recognised early on that they are going to have to
develop massive methods of control of attitude and opinion, because you cannot
control people by force anymore and therefore you have to modify their
consciousness so that they don't perceive that they are living under
conditions of alienation, oppression, subordination and so on. In fact, that's
what probably a couple trillion dollars are spent on each year in the US, very
self-consciously, from the framing of television advertisements for two-year
olds to what you are taught in graduate school economics programs. It's
designed to create a consciousness of subordination and it's also intended
specifically and pretty consciously to suppress normal human emotions."_
[**Chomsky on Anarchism**, p. 223]

This process became apparent in the 1960s. In the words of Edward Herman:

> _ "The business community of the United States was deeply concerned over the
excesses of democracy in the United States in the 1960s, and it has tried hard
to rectify this problem by means of investments in both politicians and
informing public opinion. The latter effort has included massive institutional
advertising and other direct and indirect propaganda campaigns, but it has
extended to attempts to influence the content of academic ideas . . . [With] a
significant portion of academic research coming from foundations based on
business fortunes . . . [and money] intended to allow people with preferred
viewpoints to be aided financially in obtaining academic status and influence
and in producing and disseminating books."_ [_"The Selling of Market
Economics,"_ pp. 173-199, **New Ways of Knowing**, Marcus G. Raskin and
Herbert J. Bernstein (eds.), p. 182]

Wealth, in other words, is employed to shape the public mind and ensure that
challenges to that wealth (and its source) are reduced. These include funding
private foundations and institutes ("think-tanks") which can study, promote
and protect ways to advance the interests of the few. It can also include the
private funding of university chairs as well as the employment of PR companies
to attack opponents and sell to the public the benefits not only of specific
companies their activities but also the whole socio-economic system. In the
words of Australian Social Scientist Alex Carey the _"twentieth century has
been characterised by three developments of great political importance: the
growth of democracy, the growth of corporate power, and the growth of
corporate propaganda as a means of protecting corporate power against
democracy."_ [quoted by Noam Chomsky, **World Orders, Old and New**, p. 89]

By 1978, American business was spending $1 billion a year on grassroots
propaganda. [Chomsky, **Op. Cit.**, p. 93] This is known as _"Astroturf"_ by
PR insiders, to reflect the appearance of popular support, without the
substance, and _"grasstops"_ whereby influential citizens are hired to serve
as spokespersons for business interests. In 1983, there existed 26 general
purpose foundations for this purpose with endowments of $100 million or more,
as well as dozens of corporate foundations. One extremely wealth conservative,
Richard Mellon Scaife, was giving $10 million a year through four foundations
and trusts. [G. William Domhoff, **Who Rules America Now?**, p. 92 and p. 94]
These, along with media power, ensure that force -- always an inefficient
means of control -- is replaced by (to use a term associated with Noam
Chomsky) the _"manufacture of consent"_: the process whereby the limits of
acceptable expression are defined by the wealthy.

Various institutions are used to get Big Business's message across, for
example, the Joint Council on Economic Education, ostensibly a charitable
organisation, funds economic education for teachers and provides books,
pamphlets and films as teaching aids. In 1974, 20,000 teachers participated in
its workshops. The aim is to induce teachers to present corporations in an
uncritical light to their students. Funding for this propaganda machine comes
from the American Bankers Association, AT&amp;T, the Sears Roebuck Foundation
and the Ford Foundation. As Domhoff points out, _"[a]lthough it [and other
bodies like it] has not been able to bring about active acceptance of all
power elite policies and perspectives, on economic or other domestic issues,
it has been able to ensure that opposing opinions have remained isolated,
suspect and only partially developed."_ [**Op. Cit.**, pp. 103-4]

In other words, "unacceptable" ideas are marginalised, the limits of
expression defined, and all within a society apparently based on "the free
marketplace of ideas."

This process has been going on for some time. For example _"[i]n April 1947,
the Advertising Council announced a $100 million campaign to use all media to
'sell' the American economic system -- as they conceived it -- to the American
people; the program was officially described as a 'major project of educating
the American people about the economic facts of life.' Corporations 'started
extensive programs to indoctrinate employees,' the leading business journal
**Fortune** reported, subjected their captive audiences to 'Courses in
Economic Education' and testing them for commitment to the 'free enterprise
system -- that is, Americanism.' A survey conducted by the American Management
Association (AMA) found that many corporate leaders regarded 'propaganda' and
'economic education' as synonymous, holding that 'we want our people to think
right'. . . [and that] 'some employers view. . . [it] as a sort of 'battle of
loyalties' with the unions' -- a rather unequal battle, given the resources
available."_ These huge PR campaigns _"employed the media, cinema, and other
devices to identify 'free enterprise' -- meaning state-subsidised private
power with no infringement on managerial prerogatives -- as 'the American
way,' threatened by dangerous subversives."_ [Noam Chomsky, **Op. Cit.**, pp.
89-90 and p. 89]

By 1995, $10 billion was considered a _"conservative estimate"_ on how much
money was spent on public relations. The actual amount is unknown, as PR
industry (and their clients, of course) _"carefully conceals most of its
activities from public view. This invisibility is part of a deliberate
strategy for manipulating public opinion and government policy."_ The net
effect is that the wealth of _"large corporations, business associations and
governments"_ is used to _"out-manoeuvre, overpower and outlast true citizen
reformers."_ In other words: _"Making the World Safe from Democracy."_ [John
Stauber and Sheldon Rampton, **Toxic Sludge is Good for You!**, p. 13, p. 14
and p. 13] The public relations industry, as Chomsky notes, is a means by
which _"the oppressors . . . instil their assumptions as the perspective from
which you [should] look at the world"_ and is _"done extremely consciously."_
[**Propaganda and the Public Mind**, p. 166]

The effects of this business propaganda are felt in all other aspects of life,
ensuring that while the US business class is extremely class conscious, the
rest of the American population considers "class" a swear word! It does have
an impact. The rise of, say, "supply-side" economics in the late 1970s can be
attributed to the sheer power of its backers rather than its intellectual or
scientific merit (which, even in terms of mainstream economics, were slim).
Much the same can be said for Monetarism and other discredited free-market
dogmas. Hence the usual targets for these campaigns: taxes, regulation of
business, welfare (for the poor, not for business), union corruption (when
facing organising drives), and so on. All, of course, wrapped up in populist
rhetoric which hides the real beneficiaries of the policies (for example, tax
cut campaigns which strangely fail to mention that the elite will benefit
most, or entirely, from the proposed legislation).

Ironically, the apparent success of this propaganda machine shows the inherent
contradiction in the process. Spin and propaganda, while influential, cannot
stop people experiencing the grim consequences when the business agenda is
applied. While corporate propaganda has shaped the American political scene
significantly to the right since the 1970s, it cannot combat the direct
experience of stagnating wages, autocratic bosses, environmental degradation,
economic insecurity and wealth polarisation indefinitely. The actual objective
reality of neo-liberal capitalism will always come into glaring contrast with
the propaganda used to justify and extend it. Hence the rising budgets for
these activities cannot counteract the rising unease the American people feel
about the direction their country is taking. The task of anarchists is to help
the struggle, in America and across the globe, by which they can take their
country and lives back from the elite.

[‹ D.1 Why does state intervention occur?](/afaq/secD1.html "Go to previous
page" ) [up](/afaq/secDcon.html "Go to parent page" ) [D.3 How does wealth
influence the mass media? ›](/afaq/secD3.html "Go to next page" )

