# What caused the degeneration of the Russian Revolution?

As is well known, the Russian Revolution failed. Rather than produce
socialism, the Bolshevik revolution gave birth to an autocratic party
dictatorship residing over a state capitalist economy. In turn, this regime
gave rise to the horrors of Stalin's system. While Stalinism was denounced by
all genuine socialists, a massive debate has existed within the Marxist
movement over when, exactly, the Russian Revolution failed and why it did.
Some argue around 1924, others say around 1928, some (libertarian Marxists)
argue from the Bolshevik seizure of power. The reasons for the failure tend to
be more readily agreed upon: isolation, the economic and social costs of civil
war, the _"backward"_ nature of Russian society and economy are usually listed
as the key factors. Moreover, what the Stalinist regime was is also discussed
heatedly in such circles. Some (orthodox Trotskyists) claiming it was a
_"degenerated workers state,"_ others (such as the neo-Trotskyist UK SWP) that
it was _"state capitalist."_

For anarchists, however, the failure of Bolshevism did not come as a surprise.
In fact, just as with the reformist fate of the Social Democrats, the failure
of the Russian Revolution provided empirical evidence for Bakunin's critique
of Marx. As Emma Goldman recounts in her memoirs

> _"Professor Harold Laski . . . expressed the opinion that I ought to take
some comfort in the vindication anarchism had received by the Bolsheviki. I
agreed, adding that not only their regime, but their stepbrothers as well, the
Socialists in power in other countries, had demonstrated the failure of the
Marxian State better than any anarchist argument. Living proof was always more
convincing than theory. Naturally I did not regret the Socialist failure but I
could not rejoice in it in the face of the Russian tragedy."_ [**Living My
Life**, vol. 2, p. 969]

Given that Leninists claim that the Russian revolution was a success (at least
initially) and so proves the validity of their ideology, anarchists have a
special duty to analysis and understand what went wrong. Simply put, if the
Russian Revolution was a "success," Leninism does not need "failures"!

This section of the FAQ will discuss these explanations for the failure of
Bolshevism. Simply put, anarchists are not convinced by Leninist explanations
on why Bolshevism created a new class system, not socialism.

This subject is very important. Unless we learn the lessons of history we will
be doomed to repeat them. Given the fact that many people who become
interested in socialist ideas will come across the remnants of Leninist
parties it is important that anarchists explains clearly and convincingly why
the Russian Revolution failed and the role of Bolshevik ideology in that
process. We need to account why a popular revolution became in a few short
years a state capitalist party dictatorship. As Noam Chomsky put it:

> _ "In the stages leading up to the Bolshevik coup in October 1917, there
**were** incipient socialist institutions developing in Russia -- workers'
councils, collectives, things like that. And they survived to an extent once
the Bolsheviks took over -- but not for very long; Lenin and Trotsky pretty
much eliminated them as they consolidated their power. I mean, you can argue
about the **justification** for eliminating them, but the fact is that the
socialist initiatives were pretty quickly eliminated. _

>

> _"Now, people who want to justify it say, 'The Bolsheviks had to do it' --
that's the standard justification: Lenin and Trotsky had to do it, because of
the contingencies of the civil war, for survival, there wouldn't have been
food otherwise, this and that. Well, obviously the question is, was that true.
To answer that, you've got to look at the historical facts: I don't think it
was true. In fact, I think the incipient socialist structures in Russia were
dismantles **before** the really dire conditions arose . . . But reading their
own writings, my feeling is that Lenin and Trotsky knew what they were doing,
it was conscious and understandable."_ [**Understanding Power**, p. 226]

As we discussed in the appendix on ["What happened during the Russian
Revolution?"](append41.html), Chomsky's feelings are more than supported by
the historical record. The elimination of meaningful working class freedom and
self-management started from the start and was firmly in place before the
start of the civil war at the end of May, 1918. The civil war simply
accelerated processes which had already started, strengthened policies that
had already been applied. And it could be argued that rather than impose alien
policies onto Bolshevism, the civil war simply brought the hidden (and not-so-
hidden) state capitalist and authoritarian politics of Marxism and Leninism to
the fore.

Which is why analysing the failure of the revolution is important. If the
various arguments presented by Leninists on why Bolshevism failed (and,
consequently, Stalinism developed) can be refuted, then we are left with the
key issues of revolutionary politics -- whether Bolshevik politics had a
decisive negative impact on the development of the Russian Revolution and, if
so, there is an alternative to those politics. As regards the first issue, as
we discussed in the appendix on ["How did Bolshevik ideology contribute to the
failure of the Revolution?"](append44.html), anarchists argue that this was
the case. Bolshevik ideology itself played a key role in the degeneration of
the revolution. And as regards the second one, anarchists can point to the
example of the Makhnovists, which proves that alternative policies were
possible and could be applied with radically different outcomes (see the
appendix on ["Why does the Makhnovist movement show there is an alternative to
Bolshevism?"](append46.html) for more on the Makhnovist movement).

This means that anarchists stress the interplay between the "objective
factors" and the subjective one (i.e. party ideology). Faced with difficult
circumstances, people and parties react in different ways. If they did not
then it would imply what they thought has no impact at all on their actions.
It also means that the politics of the Bolsheviks played no role in their
decisions. As we discussed in the appendix on ["What happened during the
Russian Revolution?"](append41.html), this position simply cannot be
maintained. Leninist ideology itself played a key role in the rise of
Stalinism. A conclusion Leninists reject. They, of course, try to distance
themselves from Stalinism, correctly arguing that it was a brutal and
undemocratic system. The problem is that it was Lenin and Trotsky rather then
Stalin who first shot strikers, banned left papers, radical organisations and
party factions, sent workers and revolutionaries to the gulags, advocated and
introduced one-man management and piece-work in the workplace, eliminated
democracy in the military and shut down soviets elected with the "wrong" (i.e.
non-Bolshevik) delegates.

Many Leninists know nothing of these facts. Their parties simply do not tell
them the whole story of when Lenin and Trotsky were in power. Others do know
and attempt to justify these actions. When anarchists discuss why the Russian
Revolution failed, these Leninists have basically one reply. They argue that
anarchists never seem to consider the objective forces at play during the
Russian revolution, namely the civil war, the legacy of World War One, the
international armies of counter-revolution and economic disruption. These
_"objective factors"_ meant that the revolution was, basically, suffocated and
where the overriding contribution to the rise of militarism and the crushing
of democracy within the soviets.

For anarchists such _"objective factors"_ do not (and must not) explain why
the Russian Revolution failed. This is because, as we argue in the following
sections, almost all revolutions will face the same, or similar, problems.
Indeed, in sections [1](append43.html#app1) and [2](append43.html#app2) both
anarchists like Kropotkin and Marxists like Lenin argued that this was the
case. As we discussed in [section H.2.1](secH2.html#sech21), Leninists like to
claim that they are _"realistic"_ (unlike the _"utopian"_ anarchists) and
recognise civil war is inevitable in a revolution. As [section
3](append43.html#app3) indicates, any defence of Bolshevism based on blaming
the impact of the civil war is both factually and logically flawed. As far as
economic disruption goes, as we discuss in [section 4](append43.html#app4)
this explanation of Bolshevik authoritarianism is unconvincing as **every**
revolution will face this problem. Then [section 5](append43.html#app5)
analyses the common Leninist argument that the revolution failed because the
Russian working class became _"atomised"_ or _"declassed."_ As that section
indicates, the Russian working class was more than capable of collective
action throughout the 1918 to 1921 period (and beyond). The problem was that
it was directed **against** the Bolshevik party. Finally, [section
6](append43.html#app6) indicates whether the Bolshevik leaders explained their
actions in terms of the "objective factors" they faced.

It should be stressed that we are discussing this factors individually simply
because it is easier to do so. It reality, it is less hard to do so. For
example, civil war will, undoubtedly, mean economic disruption. Economic
disruption will mean unemployment and that will affect the working class via
unemployment and less goods available (for example). So just because we
separate the specific issues for discussion purposes, it should not be taken
to imply that we are not aware of their combined impact on the Russian
Revolution.

Of course there is the slight possibility that the failure of Bolshevism can
be explained **purely** in these terms. Perhaps a future revolution will be
less destructive, less isolated, less resisted than the Russian (although, as
we noted in the [section 2](append43.html#app2), leading Bolsheviks like
Lenin, Trotsky and Bukharin doubted this). That **is** a possibility. However,
should we embrace an ideology whose basic, underlying, argument is based on
the hope that fate will be kinder to them this time? As Lenin argued against
the Russian left-communists in early 1918:

> _ "Yes, we shall see the world revolution, but for the time being it is a
very good fairy-tale . . . But I ask, is it proper for a serious revolutionary
to believe in fairy-tales? . . . [I]f you tell the people that civil war will
break out in German and also guarantee that instead of a clash with
imperialism we shall have a field revolution on a world-wide scale, the people
will say you are deceiving them. In doing this you will be overcoming the
difficulties with which history has confronted us only in your minds, by your
wishes . . . You are staking everything on this card! If the revolution breaks
out, everything is saved . . . But if it does not turn out as we desire, if it
does not achieve victory tomorrow -- what then? Then the masses will say to
you, you acted like gamblers -- you staked everything on a fortunate turn of
events that did not take place . . ."_ [**Collected Works**, vol. 27, p. 102]

Anarchists have always recognised that a revolution would face problems and
difficult "objective factors" and has developed our ideas accordingly. We
argue that to blame "objective factors" on the failure of the Russian
Revolution simply shows that believing in fairy-tales is sadly far too common
on the "serious" Leninist "revolutionary" left. And as we discuss in the
appendix on ["How did Bolshevik ideology contribute to the failure of the
Revolution?"](append44.html), the impact of Bolshevik ideology on the failure
of the revolution was important and decisive. Even **if** the next revolution
is less destructive, it cannot be argued that socialism will be the result if
Bolshevik ideology is reapplied. And as Cornelius Castoriadis argues, _"this
'response' [of explaining the failure of the Russian Revolution on "objective
factors"] teaches us nothing we could extend beyond the confines of the
Russian situation in 1920. The sole conclusion to be drawn from this kind of
'analysis' is that revolutionaries should ardently hope that future
revolutions break out in more advanced countries, that they should not remain
isolated, and that civil wars should not in the least be devastating."_ [**The
Role of Bolshevik Ideology in the Birth of the Bureaucracy**, p. 92] While
this may be sufficient for the followers of Bolshevism, it cannot be
sufficient for anyone who wants to learn from history, not to repeat it.

Ultimately, if difficult times back in 1918-21 justified suppressing working
class freedom and self-management, imprisoning and shooting anarchists and
other socialists, implementing and glorifying party dictatorship, what might
we expect in difficult times in the future? Simply put, if your defence of the
Bolsheviks rests simply on "difficult circumstances" then it can only mean one
thing, namely if "difficult circumstances" occur again we can expect the same
outcome.

One last point. We should stress that libertarians do not think any future
revolution will suffer as terrible conditions as that experienced by the
Russian one. However, it might and we need to base our politics on the worse
case possibility. That said, we argue that Bolshevik policies made things
worse -- by centralising economic and political power, they automatically
hindered the participation of working class people in the revolution,
smothering any creative self-activity under the dead-weight of state
officialdom. As a libertarian revolution would be based on maximising working
class self-activity (at all levels, locally and upwards) we would argue that
it would be better placed to respond to even the terrible conditions facing
the Russian Revolution.

That is not all. As we argue in the appendix on ["How did Bolshevik ideology
contribute to the failure of the Revolution?"](append44.html) we are of the
opinion that Bolshevism itself undermined the socialist potential of the
revolution, irrespective of the actual circumstances involved (which, to some
degree, will affect **any** revolution). For example, the Bolshevik preference
for centralisation and nationalisation would negatively affect a revolution
conducted in even the best circumstances, as would the seizure of state power
rather than its destruction. As is clear from the appendix on ["How did
Bolshevik ideology contribute to the failure of the
Revolution?"](append44.html), only the elimination of what makes Bolshevism
Bolshevik would ensure that a revolution would be truly libertarian. So
anarchists stress that rather than be forced upon them by _"objective
factors"_ many of these policies were, in fact, in line with pre-civil war
Bolshevik ideas. The Bolshevik vision of socialism, in other words, ensured
that they smothered the (libertarian) socialist tendencies and institutions
that existed at the time. As Chomsky summarises, _"Lenin and Trotsky, shortly
after seizing state power in 1917, moved to dismantle organs of popular
control, including factory committees and Soviets, thus proceeding to deter
and overcome socialist tendencies."_ [**Deterring Democracy**, p. 361] That
they **thought** their system of state capitalism was a form of "socialism" is
irrelevant -- they systematically combated (real) socialist tendencies in
favour of state capitalist ones and did so knowingly and deliberately (see
sections [H.3.1](secH3.html#sech31) and [H.3.13](secH3.html#sech313) on the
differences between real socialism and Marxism in its Bolshevik mode and, of
course, ["What happened during the Russian Revolution?"](append41.html) on
Bolshevik practice itself).

So it is important to stress that even **if** the Russian Revolution had
occurred in better circumstances, it is unlikely that Bolshevism would have
resulted in socialism rather than state capitalism. Certain Bolshevik
principles ensure that any revolution lead by a vanguard party would not have
succeeded. This can be seen from the experience of Bolshevism immediately
after it seized power, before the start of the civil war and major economic
collapse. In the circumstances of post-world war I Russia, these principles
were attenuated but their application in even the best of situations would
have undermined socialist tendencies in the revolution. Simply put, a statist
revolution will have statist, not libertarian, ends.

The focusing on "objective factors" (particularly the civil war) has become
the traditional excuse for people with a romantic attachment to Leninism but
who are unwilling to make a stand over what the Bolsheviks actually did in
power. This excuse is not viable if you seek to build a revolutionary movement
today: you need to choose between the real path of Lenin and the real,
anarchist, alternative. As Lenin constantly stressed, a revolution will be
difficult -- fooling ourselves about what will happen now just undermines our
chances of success in the future and ensure that history will repeat itself.

Essentially, the "objective factors" argument is not a defence of Leninism,
but rather one that seeks to evade having to make such a defence. This is very
typical of Leninist parties today. Revolutionary politics would be much better
served by confronting this history and the politics behind it head on.
Perhaps, if Leninists did do this, they would probably remain Leninists, but
at least then their party members and those who read their publications would
have an understanding of what this meant. And they would have to dump Lenin's
**State and Revolution** into the same place Lenin himself did when in power
-- into the rubbish bin -- and admit that democracy and Bolshevik revolution
do not go together.

It is precisely these rationalisations for Bolshevism based on "objective
factors" which this section of the FAQ discusses and refutes. However, it is
important to stress that it was **not** a case of the Bolshevik regime wanting
to introduce communism but, being isolated, ended up imposing state capitalism
instead. Indeed, the idea that "objective factors" caused the degeneration of
the revolution is only valid if and only if the Bolsheviks were implementing
socialist policies during the period immediately after the October revolution.
That was not the case. Rather than objective factors undermining socialist
policies, the facts of the matter are that the Bolsheviks pursued a statist
and (state) capitalist policy from the **start.** As we discuss in the
appendix on ["How did Bolshevik ideology contribute to the failure of the
Revolution?"](append44.html) the likes of Lenin explicitly argued for these
policies as essential for building socialism (or, at best, the preconditions
of socialism) in Russia and Bolshevik practice flowed from these comments. As
we discuss in more detail in the appendix on ["What happened during the
Russian Revolution?"](append41.html), the Bolsheviks happily introduced
authoritarian and state capitalist policies **from the start.** Many of the
policies denounced as "Stalinist" by Leninists were being advocated and
implemented by Lenin in the spring of 1918, i.e. before the start of the civil
war and massive economic chaos. In other words, the usual excuses for
Bolshevik tyranny do not hold much water, both factually and logically -- as
this section of the FAQ seeks to show.

And, ironically, the framework which Leninists use in this discussion shows
the importance of Bolshevik ideology and the key role it played in the outcome
of the revolution. After all, pro-Bolsheviks argue that the _"objective
factors"_ forced the **Bolsheviks** to act as they did. However, the
proletariat is meant to be the _"ruling class"_ in the _"dictatorship of the
proletariat."_ As such, to argue that the Bolsheviks were forced to act as
they did due to circumstances means to implicitly acknowledge that the party
held power in Russia, **not** the working class. That a ruling party could
become a party dictatorship is not that unsurprising. Nor that **its** vision
of what "socialism" was would be given preference over the desires of the
working class in whose name it ruled.

Ultimately, the discussion on why the Bolshevik party failed shows the
validity of Bakunin's critique of Marxism. As he put it:

> _ "Nor can we comprehend talk of freedom of the proletariat or true
deliverance of the masses within the State and by the State. State signifies
domination, and all domination implies subjection of the masses, and as a
result, their exploitation to the advantage of some governing minority. _

>

> _"Not even as revolutionary transition will we countenance national
Conventions, nor Constituent Assemblies, nor provisional governments, nor so
called revolutionary dictatorships: because we are persuaded that revolution
is sincere, honest and real only among the masses and that, whenever it is
concentrated in the hands of a few governing individuals, it inevitably and
immediately turns into reaction."_ [**No Gods, No Masters**, vol. 1, p. 160]

The degeneration of the Russian Revolution can be traced from when the
Bolsheviks seized power **on behalf of** the Russian working class and
peasantry. The state implies the delegation of power and initiative into the
hands of a few leaders who form the "revolutionary government." Yet the power
of any revolution, as Bakunin recognised, derives from the decentralisation of
power, from the active participation of the masses in the collective social
movement and the direct action it generates. As soon as this power passes out
of the hands of the working class, the revolution is doomed: the counter-
revolution has begun and it matters little that it is draped in a red flag.
Hence anarchist opposition to the state.

Sadly, many socialists have failed to recognise this. Hopefully this section
of our FAQ will show that the standard explanations of the failure of the
Russian revolution are, at their base, superficial and will only ensure that
history will repeat itself.

## 1 Do anarchists ignore the objective factors facing the Russian revolution?

It is often asserted by Leninists that anarchists simply ignore the "objective
factors" facing the Bolsheviks when we discuss the degeneration of the Russian
Revolution. Thus, according to this argument, anarchists present a basically
idealistic analysis of the failure of Bolshevism, one not rooted in the
material conditions facing (civil war, economic chaos, etc.) facing Lenin and
Trotsky.

According to one Trotskyist, anarchists _"do not make the slightest attempt at
a serious analysis of the situation"_ and so _"other considerations, of a
different, 'theoretical' nature, are to be found in their works."_ Thus:

> _ "Bureaucratic conceptions beget bureaucracy just as opium begets sleep by
virtue of its sleep-inducing properties. Trotsky was wrong to explain the
proliferation and rise of the bureaucracy on the basis of the country's
backwardness, low cultural level, and the isolation of the revolution. No,
what have rise to a social phenomenon like Stalinism was a conception or idea
. . . it is ideas, or deviations from them, that determine the character of
revolutions. The most simplistic kind of philosophical idealism has laid low
historical materialism."_ [Pierre Frank, _"Introduction,"_ Lenin and Trotsky,
**Kronstadt**, pp. 22-3]

Many other Trotskyists take a similar position (although most would include
the impact of the Civil War on the rise of Bolshevik authoritarianism and the
bureaucracy). Duncan Hallas, for example, argues that the account of the
Bolshevik counter-revolution given in the Cohn-Bendit brothers' **Obsolete
Communism** is marked by a _"complete omission of any consideration of the
circumstances in which they [Bolshevik decisions] took place. The ravages of
war and civil war, the ruin of Russian industry, the actual disintegration of
the Russian working class: all of this, apparently, has no bearing on the
outcome."_ [**Towards a Revolutionary Socialist Party**, p. 41] Thus the
_"degree to which workers can 'make their own history' depends on the weight
of objective factors bearing down on them . . . To decide in any given
circumstance the weight of the subjective and objective factors demands a
concrete analysis of the balance of forces."_ The conditions in Russia meant
that the _"subjective factor"_ of Bolshevik ideology _"was reduced to a choice
between capitulation to the Whites or defending the revolution with whatever
means were at hands. Within these limits Bolshevik policy was decisive. But it
could not wish away the limits and start with a clean sheet. It is a tribute
to the power of the Bolsheviks' politics and organisation that they took the
measures necessary and withstood the siege for so long."_ [John Rees, _"In
Defence of October,"_ pp. 3-82, **International Socialism**, no. 52, p. 30]

So, it is argued, by ignoring the problems facing the Bolsheviks and
concentrating on their **ideas,** anarchists fail to understand **why** the
Bolsheviks acted as they did. Unsurprisingly anarchists are not impressed with
this argument. This is for a simple reason. According to anarchist theory the
_"objective factors"_ facing the Bolsheviks are to be expected in **any**
revolution. Indeed, the likes of Bakunin and Kropotkin predicted that a
revolution would face the very _"objective factors"_ which Leninists use to
justify and rationalise Bolshevik actions (see [next
section](append43.html#app2)). As such, to claim that anarchists ignore the
_"objective factors"_ facing the Bolsheviks during the Russian Revolution is
simply a joke. How can anarchists be considered to ignore what they consider
to be the inevitable results of a revolution? Moreover, these Bolshevik
assertions ignore the fact that the anarchists who wrote extensively about
their experiences in Russia never failed to note that difficult objective
factors facing it. Alexander Berkman in **The Bolshevik Myth** paints a clear
picture of the problems facing the revolution, as does Emma Goldman in her
**My Disillusionment in Russia**. This is not to mention anarchists like
Voline, Arshinov and Maximoff who took part in the Revolution, experiencing
the _"objective factors"_ first hand (and in the case of Voline and Arshinov,
participating in the Makhnovist movement which, facing the same factors,
managed **not** to act as the Bolsheviks did).

However, as the claim that anarchists ignore the _"objective circumstances"_
facing the Bolsheviks is relatively common, it is important to refute it once
and for all. This means that while have we discussed this issue in association
with Leninist justifications for repressing the Kronstadt revolt (see [section
12](append42.html#app12) of the appendix ["What was the Kronstadt
Rebellion?"](append42.html)), it is worthwhile repeating them here. We are
sorry for the duplication.

Anarchists take it for granted that, to quote Bakunin, revolutions _"are not
child's play"_ and that they mean _"war, and that implies the destruction of
men and things."_ The _"Social Revolution must put an end to the old system of
organisation based upon violence, giving full liberty to the masses, groups,
communes, and associations, and likewise to individuals themselves, and
destroying once and for all the historic cause of all violences, the power and
existence of the State."_ This meant a revolution would be _"spontaneous,
chaotic, and ruthless, always presupposes a vast destruction of property."_
[**The Political Philosophy of Bakunin**, p. 372, p. 373, p. 380] In other
words:

> _ "The way of the anarchist social revolution, which will come from the
people themselves, is an elemental force sweeping away all obstacles. Later,
from the depths of the popular soul, there will spontaneously emerge the new
creative forms of life."_ [**Bakunin on Anarchism**, p. 325]

He took it for granted that counter-revolution would exist, arguing that it
was necessary to _"constitute the federation of insurgent associations,
communes and provinces . . . to organise a revolutionary force capable of
defeating reaction"_ and _"for the purpose of self-defence."_ [**Selected
Writings**, p. 171]

It would, of course, be strange if this necessity for defence and
reconstruction would have little impact on the economic conditions in the
revolutionised society. The expropriation of the means of production and the
land by a free federation of workers' associations would have an impact on the
economy. Kropotkin built upon Bakunin's arguments, stressing that a **social**
revolution would, by necessity, involve major difficulties and harsh objective
circumstances. It is worth quoting one of his many discussions of this at
length:

> _ "Suppose we have entered a revolutionary period, with or without civil war
-- it does not matter, -- a period when old institutions are falling into
ruins and new ones are growing in their place. The movement may be limited to
one State, or spread over the world, -- it will have nevertheless the same
consequence: an immediate slackening of individual enterprise all over Europe.
Capital will conceal itself, and hundreds of capitalists will prefer to
abandon their undertakings and go to watering-places rather than abandon their
unfixed capital in industrial production. And we know how a restriction of
production in any one branch of industry affects many others, and these in
turn spread wider and wider the area of depression. _

>

> _"Already, at this moment, millions of those who have created all riches
suffer from want of what must be considered **necessaries** for the life of a
civilised man. . . Let the slightest commotion be felt in the industrial
world, and it will take the shape of a general stoppage of work. Let the first
attempt at expropriation be made, and the capitalist production of our days
will at once come to a stop, and millions and millions of 'unemployed' will
join the ranks of those who are already unemployed now. _

>

> _"More than that . . . The very first advance towards a Socialist society
will imply a thorough reorganisation of industry as **to what we have to
produce.** Socialism implies . . . a transformation of industry so that it may
be adapted to the needs of the customer, not those of the profit-maker. Many a
branch of industry must disappear, or limits its production; many a new one
must develop. We are now producing a great deal for export. But the export
trade will be the first to be reduced as soon as attempts at Social Revolution
are made anywhere in Europe . . . _

>

> _"All that **can** be, and **will** be reorganised in time -- not by the
State, of course (why, then, not say by Providence?), but by the workers
themselves. But, in the meantime, the worker . . . cannot wait for the gradual
reorganisation of industry. . . _

>

> _"The great problem of how to supply the wants of millions will thus start
up at once in all its immensity. And the necessity of finding an **immediate
solution** for it is the reason we consider that a step in the direction of
[libertarian] Communism will be imposed on the revolted society -- not in the
future, but as soon as it applies its crowbar to the first stones of the
capitalist edifice."_ [**Act for Yourselves**, pp. 57-9]

As noted in [section 12](append42.html#app12) of the appendix on ["What was
the Kronstadt Uprising?"](append42.html), the perspective was at the core of
Kropotkin's politics. His classic work **Conquest of Bread** was based on this
clear understanding of the nature of a social revolution and the objective
problems it will face. As he put it, while a _"political revolution can be
accomplished without shaking the foundations of industry"_ a revolution
_"where the people lay hands upon property will inevitably paralyse exchange
and production . . . This point cannot be too much insisted upon; the
reorganisation of industry on a new basis . . . cannot be accomplished in a
few days."_ Indeed, he considered it essential to _"show how tremendous this
problem is."_ [**The Conquest of Bread**, pp. 72-3]

Therefore, _"[o]ne of the great difficulties in every Revolution is the
feeding of the large towns."_ This was because the _"large towns of modern
times are centres of various industries that are developed chiefly for the
sake of the rich or for the export trade"_ and these _"two branches fail
whenever any crisis occurs, and the question then arises of how these great
urban agglomerations are to be fed."_ This crisis, rather than making
revolution impossible, spurred the creation of what Kropotkin terms _"the
communist movement"_ in which _"the Parisian proletariat had already formed a
conception of its class interests and had found men to express them well."_
[Kropotkin, **The Great French Revolution**, vol. II, p. 457 and p. 504]

As for self-defence, he reproached the authors of classic syndicalist utopia
**How we shall bring about the Revolution** for _"considerably attenuat[ing]
the resistance that the Social Revolution will probably meet with on its
way."_ He stressed that the _"check of the attempt at Revolution in Russia has
shown us all the danger that may follow from an illusion of this kind."_
[_"preface,"_ Emile Pataud and Emile Pouget, **How we shall bring about the
Revolution**, p. xxxvi]

It must, therefore, be stressed that the very _"objective factors"_ supporters
of Bolshevism use to justify the actions of Lenin and Trotsky were predicted
correctly by anarchists decades before hand. Indeed, rather than ignore them
anarchists like Kropotkin based their political and social ideas on these
difficulties. As such, it seems ironic for Leninists to attack anarchists for
allegedly ignoring these factors. It is even more ironic as these very same
Leninists are meant to know that **any** revolution will involve these exact
same _"objective factors,"_ something that Lenin and other leading Bolsheviks
acknowledged (see [next section](append43.html#app2)).

Therefore, as noted, when anarchists like Emma Goldman and Alexander Berkman
arrived in Russia they were aware of the problems it, like any revolution,
would face. In the words of Berkman, _"what I saw and learned as in such
crying contrast with my hopes and expectations as to shake the very foundation
of my faith in the Bolsheviki. Not that I expected to find Russia a
proletarian Eldorado. By no means. I knew how great the travail of a
revolutionary period, how stupendous the difficulties to be overcome. Russia
was besieged on numerous fronts; there was counter-revolution within and
without; the blockade was starving the country and denying even medical aid to
sick women and children. The people were exhausted by long war and civil
strive; industry was disorganised, the railroads broken down. I fully realised
the dire situation, with Russia shedding her blood on the alter of the
Revolution."_ [**The Bolshevik Myth**, p. 329] Emma Goldman expressed similar
opinions. [**My Disillusionment in Russia**, pp. xlvii-xlix]

Unsurprisingly, therefore this extremely realistic perspective can be found in
their later works. Berkman, for example, stressed that _"when the social
revolution had become thoroughly organised and production is functioning
normally there will be enough for everybody. But in the first stages of the
revolution, during the process of re-construction, we must take care to supply
the people the best we can, and equally, which means rationing."_ This was
because the _"first effect of the revolution is reduced production."_ This
would be initially due to the general strike which is its _"starting point."_
However, _"[w]hen the social revolution begins in any land, its foreign
commerce stops: the importation of raw materials and finished products is
suspended. The country may even be blockaded by the bourgeois governments."_
In addition, he thought it important not to suppress _"small scale
industries"_ as they would be essential when _"a country in revolution is
attacked by foreign governments, when it is blockaded and deprived of imports,
when its large-scale industries threaten to break down or the railways do
break down."_ [**ABC of Anarchism**, p. 67, p. 74 p. 78-9 and p. 79]

He, of course, considered it essential that to counteract isolation workers
must understand _"that their cause is international"_ and that _"the
organisation of labour"_ must develop _"beyond national boundaries."_ However,
_"the probability is not to be discounted that the revolution may break out in
one country sooner than in another"_ and _"in such a case it would become
imperative . . . not to wait for possible aid from outside, but immediately to
exert all her energies to help herself supply the most essential needs of her
people by her own efforts."_ [**Op. Cit.**, p. 78]

Emma Goldman, likewise, noted that it was _"a tragic fact that all revolutions
have sprung from the loins of war. Instead of translating the revolution into
social gains the people have usually been forced to defend themselves against
warring parties."_ _"It seems,"_ she noted, _"nothing great is born without
pain and travail"_ as well as _"the imperative necessity of defending the
Revolution."_ However, in spite of these inevitable difficulties she point to
how the Spanish anarchists _"have shown the first example in history **how
Revolutions should be made**"_ by _"the constructive work"_ of _"socialising
of the land, the organisation of the industries."_ [**Vision on Fire**, p.
218, p. 222 and p. 55-56]

These opinions were, as can be seen, to be expected from revolutionary
anarchists schooled in the ideas of Bakunin and Kropotkin. Clearly, then, far
from ignoring the _"objective factors"_ facing the Bolsheviks, anarchists have
based their politics around them. We have always argued that a social
revolution would face isolation, economic disruption and civil war and have,
for this reason, stressed the importance of mass participation in order to
overcome them. As such, when Leninists argue that these inevitable _"objective
factors"_ caused the degeneration of Bolshevism, anarchists simply reply that
if it cannot handle the inevitable then Bolshevism should be avoided. Just as
we would avoid a submarine which worked perfectly well until it was placed in
the sea or an umbrella which only kept you dry when it was not raining.

Moreover, what is to be made of this Leninist argument against anarchism? In
fact, given the logic of their claims we have to argument we have to draw the
conclusion that the Leninists seem to think a revolution **could** happen
**without** civil war and economic disruption. As such it suggests that the
Leninists have the _"utopian"_ politics in this matter. After all, if they
argue that civil war is inevitable then how can they blame the degeneration of
the revolution on it? Simply put, if Bolshevism cannot handle the inevitable
it should be avoided at all costs.

Ironically, as indicated in the [next section](append43.html#app2), we can
find ample arguments to refute the Trotskyist case against the anarchist
analysis in the works of leading Bolsheviks like Lenin, Trotsky aand Bukharin.
Indeed, their arguments provide a striking confirmation of the anarchist
position as they, like Kropotkin, stress that difficult _"objective factors"_
will face **every** revolution. This means to use these factors to justify
Bolshevik authoritarianism simply results in proving that Bolshevism is simply
non-viable or that a liberatory social revolution is, in fact, impossible
(and, as a consequence, genuine socialism).

There are, of course, other reasons why the Leninist critique of the anarchist
position is false. The first is theoretical. Simply put, the Leninist position
is the crudest form of economic determinism. Ideas **do** matter and, as Marx
himself stressed, can play a key in how a social process develops. As we
discuss in the appendix on ["How did Bolshevik ideology contribute to the
failure of the Revolution?"](append44.html), Marxist ideology played a key
role in the degeneration of the revolution and in laying the groundwork for
the rise of Stalinism.

Ultimately, any Leninist defence of Bolshevism based purely on stressing the
_"objective factor"_ implies that Bolshevik ideology played **no role** in the
decisions made by the party leaders, that they simply operated on autopilot
from October 1917 onwards. Yet, at the same time, they stress the importance
of Leninist ideology in ensuring the "victory" of the revolution. They seek to
have it both ways. However, as Samuel Farber puts it:

> _ "determinism's characteristic and systemic failure is to understand that
what the masses of people do and think politically is as much part of the
process determining the outcome of history as are the objective obstacles that
most definitely limit peoples' choices."_ [**Before Stalinism**, p. 198]

This is equally applicable when discussing the heads of a highly centralised
state who have effectively expropriated political, economic and social power
from the working class and are ruling in their name. Unsurprisingly, rather
than just select policies at random the Bolshevik leadership pursued
consistently before, during and after the civil war policies which reflected
their ideology. Hence there was a preference in policies which centralised
power in the hands of a few (politically **and** economically), that saw
socialism as being defined by nationalisation rather than self-management,
that stressed that role and power of the vanguard above that of the working
class, that saw class consciousness as being determined by how much a worker
agreed with the party leadership rather than whether it expressed the actual
needs and interests of the class as a whole.

Then there is the empirical evidence against the Trotskyist explanation.

As we indicate in [section 3](append43.html#app3), soviet democracy and
workers' power in the workplace was **not** undermined by the civil war.
Rather, the process had began before the civil war started and, equally
significantly, continued after its end in November 1920. Moreover, the
_"gains"_ of October Trotskyists claim that Stalinism destroyed were, in fact,
long dead by 1921. Soviet democracy, working class freedom of speech,
association and assembly, workers' self-management or control in the
workplace, trade union freedom, the ability to strike, and a host of other,
elementary, working class rights had been eliminated long before the end of
the civil war (indeed, often before it started) and, moreover, the Bolsheviks
did not lament this. Rather, _"there is no evidence indicating that Lenin or
any mainstream Bolshevik leaders lamented the loss of workers' control or of
democracy in the soviets , or at least referred to these losses as a retreat,
as Lenin declared with the replacement of War Communism by NEP in 1921."_
[Samuel Farber, **Op. Cit.**, p. 44]

And then there is the example of the Makhnovist movement. Operating in the
same _"objective circumstances,"_ facing the same _"objective factors,"_ the
Makhnovists did **not** implement the same policies as the Bolsheviks. As we
discussed in the appendix on ["Why does the Makhnovist movement show there is
an alternative to Bolshevism?"](append46.html), rather than undermine soviet,
soldier and workplace democracy and replace all with party dictatorship, the
Makhnovists applied these as fully as they could. Now, if _"objective
factors"_ explain the actions of the Bolsheviks, then why did the Makhnovists
not pursue identical policies?

Simply put, the idea that Bolshevik policies did not impact on the outcome of
the revolution is a false assertion, as the Makhnovists show. Beliefs are
utopian if subjective ideas are not grounded in objective reality. Anarchists
hold that part of the subjective conditions required before socialism can
exist is the existence of free exchange of ideas and working class democracy
(i.e. self-management). To believe that revolution is possible without
freedom, to believe those in power can, through their best and genuine
intentions, impose socialism from above, as the Bolsheviks did, is indeed
utopian. As the Bolsheviks proved. The Makhnovists shows that the received
wisdom is that there was no alternative open to the Bolsheviks is false.

So while it cannot be denied that objective factors influenced how certain
Bolshevik policies were shaped and applied, the inspiration of those policies
came from Bolshevik ideology. An acorn will grow and develop depending on the
climate and location it finds itself in, but regardless of the _"objective
factors"_ it will grow into an oak tree. Similarly with the Russian
revolution. While the circumstances it faced influenced its growth, Bolshevik
ideology could not help but produce an authoritarian regime with no
relationship with **real** socialism.

In summary, anarchists do not ignore the objective factors facing the
Bolsheviks during the revolution. As indicated, we predicted the problems they
faced and developed our ideas to counter them. As the example of the
Makhnovists showed, our ideas were more than adequate for the task. Unlike the
Bolsheviks.

## 2 Can _"objective factors"_ really explain the failure of Bolshevism?

As noted in the [previous section](append43.html#app1) Leninists tend to argue
that anarchists downplay (at best) or ignore (at worse) the _"objective
factors"_ facing the Bolsheviks during the Russian Revolution. As noted in the
same section, this argument is simple false. For anarchists have long expected
the _"objective factors"_ usually used to explain the degeneration of the
revolution.

However, there is more to it than that. Leninists claim to be revolutionaries.
They claim to know that revolutions face problems, the civil war is inevitable
and so forth. It therefore strikes anarchists as being somewhat hypocritical
for Leninists to blame these very same _"objective"_ but allegedly inevitable
factors for the failure of Bolshevism in Russia.

Ironically enough, Lenin and Trotsky agree with these anarchist arguments.
Looking at Trotsky, he dismissed the CNT's leaderships' arguments in favour of
collaborating with the bourgeois state:

> _ "The leaders of the Spanish Federation of Labour (CNT) . . . became, in
the critical hour, bourgeois ministers. They explained their open betrayal of
the theory of anarchism by the pressure of 'exceptional circumstances.' But
did not the leaders of the German social democracy invoke, in their time, the
same excuse? Naturally, civil war is not a peaceful and ordinary but an
'exceptional circumstance.' Every serious revolutionary organisation, however,
prepares precisely for 'exceptional circumstances' . . . We have not the
slightest intention of blaming the anarchists for not having liquidated the
state with the mere stroke of a pen. A revolutionary party , even having
seized power (of which the anarchist leaders were incapable in spite of the
heroism of the anarchist workers), is still by no means the sovereign ruler of
society. But all the more severely do we blame the anarchist theory, which
seemed to be wholly suitable for times of peace, but which had to be dropped
rapidly as soon as the 'exceptional circumstances' of the... revolution had
begun. In the old days there were certain generals - and probably are now -
who considered that the most harmful thing for an army was war. Little better
are those revolutionaries who complain that revolution destroys their
doctrine."_ [**Stalinism and Bolshevism**]

Thus to argue that the _"exceptional circumstances"_ caused by the civil war
are the only root cause of the degeneration of the Russian Revolution is a
damning indictment of Bolshevism. After all, Lenin did not argue in **State
and Revolution** that the application of soviet democracy was dependent only
in _"times of peace."_ Rather, he stressed that they were for the
_"exceptional circumstance"_ of revolution and the civil war he considered its
inevitable consequence. As such, we must note that Trotsky's followers do not
apply this critique to their own politics, which are also a form of the
"exceptional circumstances" excuse. Given how quickly Bolshevik "principles"
(as expressed in **The State and Revolution**) were dropped, we can only
assume that Bolshevik ideas are also suitable purely for _"times of peace"_ as
well. As such, we must note the irony of Leninist claims that _"objective
circumstances"_ explains the failure of the Bolshevik revolution.

Saying that, we should not that Trotsky was not above using such arguments
himself (making later-day Trotskyists at least ideologically consistent in
their hypocrisy). In the same essay, for example, he justifies the prohibition
of other Soviet parties in terms of a "measure of defence of the dictatorship
in a backward and devastated country, surrounded by enemies on all sides." In
other words, an appeal to the exceptional circumstances facing the Bolsheviks!
Perhaps unsurprisingly, his followers have tended to stress this
(contradictory) aspect of his argument rather than his comments that those
_"who propose the abstraction of Soviets to the party dictatorship should
understand that only thanks to the party dictatorship were the Soviets able to
lift themselves out of the mud of reformism and attain the state form of the
proletariat. The Bolshevik party achieved in the civil war the correct
combination of military art and Marxist politics."_ [**Op. Cit.**] Which, of
course, suggests that the prohibition of other parties had little impact on
levels of soviet "democracy" allowed under the Bolsheviks (see [section
6](append41.html#app6) of the appendix on ["What happened during the Russian
Revolution?"](append41.html)for more on this).

This dismissal of the _"exceptional circumstances"_ argument did not originate
with Trotsky. Lenin repeatedly stressed that any revolution would face civil
war and economic disruption. In early January, 1918, he was pointing to _"the
incredibly complications of war and economic ruin"_ in Russia and noting that
_"the fact that Soviet power has been established . . . is why civil war has
acquired predominance in Russia at the present time."_ [**Collected Works**,
vol. 26, p. 453 and p. 459]

A few months later he states quite clearly that _"it will never be possible to
build socialism at a time when everything is running smoothly and tranquilly;
it will never be possible to realise socialism without the landowners and
capitalists putting up a furious resistance."_ He reiterated this point,
acknowledging that the _"country is poor, the country is poverty-stricken, and
it is impossible just now to satisfy all demands; that is why it is so
difficult to build the new edifice in the midst of disruption. But those who
believe that socialism can be built at a time of peace and tranquillity are
profoundly mistake: it will be everywhere built at a time of disruption, at a
time of famine. That is how it must be."_ [**Op. Cit.**, vol. 27, p. 520 and
p. 517]

As regards civil war, he noted that _"not one of the great revolutions of
history has take place"_ without one and _"without which not a single serious
Marxist has conceived the transition from capitalism to socialism."_ Moreover,
_"there can be no civil war -- the inevitable condition and concomitant of
socialist revolution -- without disruption."_ [**Op. Cit.**, p. 496 and p.
497] He considered this disruption as being applicable to advanced capitalist
nations as well:

> _ "In Germany, state capitalism prevails, and therefore the revolution in
Germany will be a hundred times more devastating and ruinous than in a petty-
bourgeois country -- there, too, there will be gigantic difficulties and
tremendous chaos and imbalance."_ [**Op. Cit.**, vol. 28, p. 298]

And from June, 1918:

> _ "We must be perfectly clear in our minds about the new disasters that
civil war brings for every country. The more cultured a country is the more
serious will be these disasters. Let us picture to ourselves a country
possessing machinery and railways in which civil war is raging., and this
civil war cuts off communication between the various parts of the country.
Picture to yourselves the condition of regions which for decades have been
accustomed to living by the interchange of manufactured goods and you will
understand that every civil war brings forth disasters."_ [**Op. Cit.**, vol.
27, p. 463]

As we discuss in [section 4](append43.html#app4), the economic state of
Germany immediately after the end of the war suggests that Lenin had a point.
Simply put, the German economy was in a serious state of devastation, a state
equal to that of Russia during the equivalent period of its revolution. If
economic conditions made party dictatorship inevitable in Bolshevik Russia (as
pro-Leninists argue) it would mean that soviet democracy and revolution cannot
go together.

Lenin reiterated this point again and again. He argued that _"we see famine
not only in Russia, but in the most cultured, advanced countries, like Germany
. . . it is spread over a longer period than in Russia, but it is famine
nevertheless, still more severe and painful than here."_ In fact, _"today even
the richest countries are experiencing unprecedented food shortages and that
the overwhelming majority of the working masses are suffering incredible
torture."_ [**Op. Cit.**, vol. 27, p. 460 and p. 461]

Lenin, unlike many of his latter day followers, did not consider these grim
objective conditions are making revolution impossible. Rather, for him, there
was _"no other way out of this war"_ which is causing the problems _"except
revolution, except civil war . . . a war which always accompanies not only
great revolutions but every serious revolution in history."_ He continued by
arguing that we _"must be perfectly clear in our minds about the new disasters
that civil war brings for every country. The more cultured a country is the
more serious will be these disasters. Let us picture to ourselves a country
possessing machinery and railways in which civil war is raging, and this civil
war cuts communication between the various parts of the country. Picture to
yourselves the condition of regions which for decades have been accustomed to
living by interchange of manufactured goods and you will understand that every
civil war brings fresh disasters."_ [**Op. Cit.**, p. 463] The similarities to
Kropotkin's arguments made three decades previously are clear (see [section
1](append43.html#app1) for details).

Indeed, he mocked those who would argue that revolution could occur with
_"exceptional circumstances"_:

> _ "A revolutionary would not 'agree' to a proletarian revolution only 'on
the condition' that it proceeds easily and smoothly, that there is, from the
outset, combined action on the part of proletarians of different countries,
that there are guarantees against defeats, that the road of the revolution is
broad, free and straight, that it will not be necessary during the march to
victory to sustain the heaviest casualties, to 'bide one's time in a besieged
fortress,' or to make one's way along extremely narrow, impassable, winding
and dangerous mountain tracks. Such a person is no revolutionary."_
[**Selected Works**, vol. 2, p. 709]

He then turned his fire on those who failed to recognise the problems facing a
revolution and instead simply blamed the Bolsheviks:

> _ "The revolution engendered by the war cannot avoid the terrible
difficulties and suffering bequeathed it by the prolonged, ruinous,
reactionary slaughter of the nations. To blame us for the 'destruction' of
industry, or for the 'terror', is either hypocrisy or dull-witted pedantry; it
reveals an inability to understand the basic conditions of the fierce class
struggle, raised to the highest degree of intensity, that is called
revolution."_ [**Op. Cit.**, pp. 709-10]

Thus industrial collapse and terrible difficulties would face any revolution.
It goes without saying that if it was _"hypocrisy"_ to blame Bolshevik
politics for these problems, it would be the same to blame these problems for
Bolshevik politics. As Lenin noted, _"in revolutionary epochs the class
struggle has always, inevitably, and in every country, assumed the form of
**civil war,** and civil war is inconceivable without the severest
destruction, terror and the restriction of formal democracy in the interests
of this war."_ Moreover, _"[w]e know that fierce resistance to the socialist
revolution on the part of the bourgeoisie is inevitable in all countries, and
that this resistance will **grow** with the growth of the revolution."_ [**Op.
Cit.**, p. 710 and p. 712] To blame the inevitable problems of a revolution
for the failings of Bolshevism suggests that Bolshevism is simply not suitable
for revolutionary situations.

At the 1920 Comintern Congress Lenin lambasted a German socialist who argued
against revolution because _"Germany was so weakened by the War"_ that if it
had been _"blockaded again the misery of the German masses would have been
even more dreadful."_ Dismissing this argument, Lenin argued as follows:

> _ "A revolution . . . can be made only if it does not worsen the workers'
conditions 'too much.' Is it permissible, in a communist party, to speak in a
tone like this, I ask? This is the language of counter-revolution. The
standard of living in Russia is undoubtedly lower than in Germany, and when we
established the dictatorship, this led to the workers beginning to go more
hungry and to their conditions becoming even worse. The workers' victory
cannot be achieved without sacrificing, without a temporary deterioration of
their conditions. . . If the German workers now want to work for the
revolution, they must make sacrifices and not be afraid to do so . . . The
labour aristocracy, which is afraid of sacrifices, afraid of 'too great'
impoverishment during the revolutionary struggle, cannot belong to the party.
Otherwise the dictatorship is impossible, especially in western European
countries."_ [**Proceedings and Documents of the Second Congress 1920**, pp.
382-3]

In 1921 he repeated this, arguing that _"every revolution entails enormous
sacrifice on the part of the class making it. . . The dictatorship of the
proletariat in Russia has entailed for the ruling class -- the proletariat --
sacrifices, want and privation unprecedented in history, and the case will, in
all probability, be the same in every other country."_ [**Collected Works**,
vol. 32, p. 488] Thus Lenin is on record as saying these "objective factors"
will always be the circumstances facing a socialist revolution. Indeed, in
November 1922 he stated that _"Soviet rule in Russia is celebrating its fifth
anniversary, It is now sounder than ever."_ [**Op. Cit.**, vol. 33, p. 417]

All of which must be deeply embarrassing to Leninists. After all, here is
Lenin arguing that the factors Leninist's list as being responsible for the
degeneration of the Russian Revolution were inevitable side effects of **any**
revolution!

Nor was this perspective limited to Lenin. The inevitability of economic
collapse being associated with a revolution was not lost on Trotsky either
(see [section 12](append42.html#app12) of the appendix on ["What was the
Kronstadt Rebellion?"](append42.html)). Nikolai Bukharin even wrote the
(infamous) **The Economics of the Transition Period** to make theoretical
sense of (i.e. rationalise and justify) the party's changing policies and
their social consequences since 1918 in terms of the inevitability of bad
"objective factors" facing the revolution. While some Leninists like to paint
Bukharin's book (like most Bolshevik ideas of the time) as _"making a virtue
out of necessity,"_ Bukharin (like the rest of the Bolshevik leadership) did
not. As one commentator notes, Bukharin _"belive[d] that he was formulating
universal laws of proletarian revolution."_ [Stephan F. Cohen, **In Praise of
War Communism: Bukharin's The Economics of the Transition Period**, p. 195]

Bukharin listed four _"real costs of revolution,"_ namely _"the physical
destruction or deterioration of material and living elements of production,
the atomisation of these elements and of sectors of the economy, and the need
for unproductive consumption (civil war materials, etc.). These costs were
interrelated and followed sequentially. Collectively they resulted in '**the
curtailment of the process of reproduction**' (and 'negative expanded
reproduction') and Bukharin's main conclusion: 'the production _"anarchy"_ . .
. , _"the revolutionary disintegration of industry,"_ is an historically
inevitable stage which no amount of lamentation will prevent.'"_ This was part
of a general argument and his _"point was that great revolutions were always
accompanied by destructive civil wars . . . But he was more intent on proving
that a proletarian revolution resulted in an even greater temporary fall in
production than did its bourgeois counterpart."_ To do this he formulated the
_"costs of revolution"_ as _"a law of revolution."_ [**Op. Cit.**, pp. 195-6
and p. 195]

Cohen notes that while this _"may appear to have been an obvious point, but it
apparently came as something of a revelation to many Bolsheviks. It directly
opposed the prevailing Social Democratic assumption that the transition to
socialism would be relatively painless . . . Profound or not, Bolsheviks
generally came to accept the 'law' and to regard it as a significant discovery
by Bukharin."_ [**Op. Cit.**, p. 196] To quote Bukharin:

> _ "during the transition period the labour apparatus of society inevitably
disintegrates, that reorganisation presupposes disorganisation, and that there
the temporary collapse of productive forces is a law inherent to revolution."_
[quoted by Cohen, **Op. Cit.**, p. 196]

It would appear that this _"obvious point"_ would **still** come _"as
something of a revelation to many Bolsheviks"_ today! Significantly, of
course, Kropotkin had formulated this law decades previously! How the
Bolsheviks sought to cope with this inevitable law is what signifies the
difference between anarchism and Leninism. Simply put, Bukharin endorsed the
coercive measures of war communism as the means to go forward to socialism. As
Cohen summarises, _"force and coercion . . . were the means by which
equilibrium was to be forged out of disequilibrium."_ [**Op. Cit.**, p. 198]
Given that Bukharin argued that a workers' state, by definition, could not
exploit the workers, he opened up the possibility for rationalising all sorts
of abuses as well as condoning numerous evils because they were
_"progressive."_ Nor was Bukharin alone in this, as Lenin and Trotsky came out
with similar nonsense.

It should be noted that Lenin showed _"ecstatic praise for the most 'war
communist' sections"_ of Bukharin's work. _"Almost every passage,"_ Cohen
notes, _"on the role of the new state, statisation in general, militarisation
and mobilisation met with 'very good,' often in three languages, . . . Most
striking, Lenin's greatest enthusiasm was reserved for the chapter on the role
of coercion . . . at the end [of which] he wrote, 'Now this chapter is
superb!'"_ [**Op. Cit.**, pp. 202-3] Compare this to Kropotkin's comment that
the _"revolutionary tribunal and the guillotine could not make up for the lack
of a constructive communist theory."_ [**The Great French Revolution**, vol.
II, p. 519]

Ultimately, claims that "objective factors" caused the degeneration of the
revolution are mostly attempts to let the Bolsheviks of the hook for
Stalinism. This approach was started by Trotsky and continued to this day.
Anarchists, unsurprisingly, do not think much of these explanations. For
anarchists, the list of "objective factors" listed to explain the degeneration
of the revolution are simply a list of factors **every** revolution would (and
has) faced -- as Lenin, Bukharin and Trotsky all admitted at the time!

So we have the strange paradox of Leninists dismissing and ignoring the
arguments of their ideological gurus. For Trotsky, just as for Lenin, it was a
truism that revolutionary politics had to handle _"objective"_ factors and
_"exceptional circumstances."_ And for both, they thought they had during the
Russian revolution. Yet for their followers, these explain the failure of
Bolshevism. Tony Cliff, one of Trotsky's less orthodox followers, gives us a
means of understanding this strange paradox. Discussing the **Platform of the
United Opposition** he notes that it _"also suffered from the inheritance of
the exceptional conditions of the civil war, when the one-party system was
transformed from a necessity into a virtue."_ [**Trotsky**, vol. 3, pp. 248-9]
Clearly, _"exceptional circumstances"_ explain nothing and are simply an
excuse for bad politics while _"exceptional conditions"_ explain everything
and defeat even the best politics!

As such, it seems to us extremely ironic that Leninists blame the civil war
for the failure of the revolution as they continually raise the inevitability
of civil war in a revolution to attack anarchism (see [section
H.2.1](secH2.html#sech21) for an example). Did Lenin not explain in **State
and Revolution** that his _"workers' state"_ was designed to defend the
revolution and suppress capitalist resistance? If it cannot do its proclaimed
task then, clearly, it is a flawed theory. Ultimately, if _"civil war"_ and
the other factors listed by Leninists (but considered inevitable by Lenin)
preclude the implementation of the radical democracy Lenin argued for in 1917
as the means to suppress the resistance of the capitalists then his followers
should come clean and say that that work has no bearing on their vision of
revolution. Therefore, given that the usual argument for the _"dictatorship of
the proletariat"_ is that it is required to repress counter-revolution, it
seems somewhat ironic that the event it was said to be designed for (i.e.
revolution) should be responsible for its degeneration!

As such, anarchists tend to think these sorts of explanations of Bolshevik
dictatorship are incredulous. After all, as **revolutionaries** the people who
expound these _"explanations"_ are meant to know that civil war, imperialist
invasion and blockade, economic disruption, and a host of other _"extremely
difficult circumstances"_ are part and parcel of a revolution. They seem to be
saying, "if only the ruling class had not acted as our political ideology
predicts they would then the Bolshevik revolution would have been fine"! As
Bertrand Russell argued after his trip to Soviet Russia, while since October
1917 _"the Soviet Government has been at war with almost all the world, and
has at the same time to face civil war at home"_ this was _"not to be regarded
as accidental, or as a misfortune which could not be foreseen. According to
Marxian theory, what has happened was bound to happen."_ [**The Theory and
Practice of Bolshevism**, p. 103]

In summary, anarchists are not at all convinced by the claims that _"objective
factors"_ can explain the failure of the Russian Revolution. After all,
according to Lenin and Trotsky these factors were to be expected in **any**
revolution -- civil war and invasion, economic collapse and so forth were not
restricted to the Russian revolution. That is why they say they want a
"dictatorship of the proletariat," to defend against counter-revolution (see
[section H.3.8](secH3.html#sech38) on how, once in power, Lenin and Trotsky
revised this position). Now, if Bolshevism cannot handle what it says is
inevitable, then it should be avoided. To use an analogy:

> **Bolshevik: _"Join with us, we have a great umbrella which will keep us
dry."_ **

>

> **Anarchist: _"Last time it was used, it did not work. We all got soaked!"_
**

>

> **Bolshevik: _"But what our anarchist friend fails to mention is that it was
raining at the time!"_ **

Not very convincing! Yet, sadly, this is the logic of the common Leninist
justification of Bolshevik authoritarianism during the Russian Revolution.

## 3 Can the civil war explain the failure of Bolshevism?

One of the most common assertions against the anarchists case against
Bolshevism is that while we condemn the Bolsheviks, we fail to mention the
civil war and the wars of intervention. Indeed, for most Leninists the civil
war is usually considered the key event in the development of Bolshevism,
explaining and justifying all anti-socialist acts conducted by them after they
seized power.

For anarchists, such an argument is flawed on two levels, namely logical and
factual. The logical flaw is that Leninist argue that civil war is inevitable
after a revolution. They maintain, correctly, that it is unlikely that the
ruling class will disappear without a fight. Then they turn round and complain
that because the ruling class did what the Marxists predicted, the Russian
Revolution failed! And they (incorrectly) harp on about anarchists ignoring
civil war (see [section H.2.1](secH2.html#sech21)).

So, obviously, this line of defence is nonsense. If civil war is inevitable,
then it cannot be used to justify the failure of the Bolshevism. Marxists
simply want to have their cake and eat it to. You simply cannot argue that
civil war is inevitable and then blame it for the failure of the Russian
Revolution.

The other flaw in this defence of Bolshevism is the factual one, namely the
awkward fact that Bolshevik authoritarianism started **before** the civil war
broke out. Simply put, it is difficult to blame a course of actions on an
event which had not started yet. Moreover, Bolshevik authoritarianism
**increased** after the civil war finished. This, incidentally, caused
anarchists like Alexander Berkman to re-evaluate their support for Bolshevism.
As he put it, _"I would not concede the appalling truth. Still the hope
persisted that the Bolsheviki, though absolutely wrong in principle and
practice, yet grimly held on to **some** shreds of the revolutionary banner.
'Allied interference,' 'the blockade and civil war,' 'the necessity of the
transitory stage' -- thus I sought to placate my outraged conscience . . . At
last the fronts were liquidated, civil war ended, and the country at peace.
But Communist policies did not change. On the contrary . . . The party groaned
under the unbearable yoke of the Party dictatorship. . . . Then came Kronstadt
and its simultaneous echoes throughout the land . . . Kronstadt was crushed as
ruthlessly as Thiers and Gallifet slaughtered the Paris Communards. And with
Kronstadt the entire country and its last hope. With it also my faith in the
Bolsheviki."_ [**The Bolshevik Myth**, p. 331]

If Berkman had been in Russia in 1918, he may have realised that the Bolshevik
tyranny during the civil war (which climaxed, post civil war, with the attack
on Kronstadt -- see the appendix on ["What was the Kronstadt
Rebellion?"](append42.html) for more on the Kronstadt rebellion) was not at
odds with their pre-civil war activities to maintain their power. The simple
fact is that Bolshevik authoritarianism was **not** caused by the pressures of
the civil war, rather they started before then. All the civil war did was
strengthen certain aspects of Bolshevik ideology and practice which had
existed from the start (see the appendix on ["How did Bolshevik ideology
contribute to the failure of the Revolution?"](append44.html)).

While we discuss the Russian Revolution in more detail in the appendix on
["What happened during the Russian Revolution?"](append41.html), it is useful
to summarise the Bolshevik attacks on working class power and autonomy before
the civil war broke out (i.e. before the end of May 1918).

The most important development during this period was the suppression of
soviet democracy and basic freedoms. As we discuss in [section
6](append41.html#app6) of the appendix on ["What happened during the Russian
Revolution?"](append41.html), the Bolsheviks pursued a policy of
systematically undermining soviet democracy from the moment they seized power.
The first act was the creation of a Bolshevik government over the soviets, so
marginalising the very organs they claimed ruled in Russia. The process was
repeated in the local soviets, with the executive committees holding real
power while the plenary sessions become infrequent and of little consequence.
Come the spring of 1918, faced with growing working class opposition they
started to delay soviet elections. When finally forced to hold elections, the
Bolsheviks responded in two ways to maintain their power. Either they
gerrymandered the soviets, packing them with representatives of Bolshevik
dominated organisation or they simply disbanded them by force if they lost the
soviet elections (and repressed by force any protests against this). This was
the situation at the grassroots. At the summit of the soviet system, the
Bolsheviks simply marginalised the Central Executive Committee of the soviets.
Real power was held by the Bolshevik government. The power of the soviets had
simply become a fig-leaf for a "soviet power" -- the handful of Bolsheviks who
made up the government and the party's central committee.

It should be stressed that the Bolshevik assault on the soviets occurred in
March, April and May 1918. That is, **before** the Czech uprising and the
onset of full-scale civil war. So, to generalise, it cannot be said that it
was the Bolshevik party that alone whole-heartedly supported Soviet power. The
facts are that the Bolsheviks only supported _"Soviet power"_ when the soviets
were Bolshevik. As recognised by the left-Menshevik Martov, who argued that
the Bolsheviks loved Soviets only when they were _"in the hands of the
Bolshevik party."_ [quoted by Getzler, **Martov**, p. 174] If the workers
voted for others, _"soviet power"_ was quickly replaced by party power (the
real aim). The Bolsheviks had consolidated their position in early 1918,
turning the Soviet State into a de facto one party state by gerrymandering and
disbanding of soviets before the start of the Civil War.

Given this legacy of repression, Leninist Tony Cliff's assertion that it was
only _"under the iron pressure of the civil war [that] the Bolshevik leaders
were forced to move, as the price of survival, to **a one-party system**"_
needs serious revising. Similarly, his comment that the _"civil war undermined
the operation of the local soviets"_ is equally inaccurate, as his is claim
that _"for some time -- i.e. until the armed uprising of the Czechoslovak
Legion -- the Mensheviks were not much hampered in their propaganda work."_
Simply put, Cliff's statement that _"it was about a year after the October
Revolution before an actual monopoly of political power was held by one
party"_ is false. Such a monopoly existed **before** the start of the civil
war, with extensive political repression existing **before** the uprising of
the Czechoslovak Legion which began it. There was a **de facto** one-party
state by the spring of 1918. [**Lenin**, vol. 3, p. 163, p. 150, p. 167 and p.
172]

The suppression of Soviet democracy reached it logical conclusion in 1921 when
the Kronsdadt soviet, heart of the 1917 revolution, was stormed by Bolshevik
forces, its leaders executed or forced into exile and the rank and file
imprisoned, and scattered all over the USSR. Soviet democracy was not just an
issue of debate but one many workers died in fighting for. As can be seen,
similar events to those at Kronstadt had occurred three years previously.

Before turning to other Bolshevik attacks on working class power and freedom,
we need to address one issue. It will be proclaimed that the Mensheviks (and
SRs) were _"counter-revolutionaries"_ and so Bolshevik actions against them
were justified. However, the Bolsheviks' started to suppress opposition
soviets **before** the civil war broke out, so at the time neither group could
be called _"counter-revolutionary"_ in any meaningful sense of the word. The
Civil War started on the 25th of May and the SRs and Mensheviks were expelled
from the Soviets on the 14th of June. While the Bolsheviks _"offered some
formidable fictions to justify the expulsions"_ there was _"of course no
substance in the charge that the Mensheviks had been mixed in counter-
revolutionary activities on the Don, in the Urals, in Siberia, with the
Czechoslovaks, or that they had joined the worst Black Hundreds."_ [Getzler,
**Op. Cit.**, p. 181] The charge that the Mensheviks _"were active supporters
of intervention and of counter-revolution"_ was _"untrue . . . and the
Communists, if they ever believed it, never succeeded in establishing it."_
[Schapiro, **Op. Cit.**, p. 193] The Bolsheviks expelled the Mensheviks in the
context of political loses before the Civil War. As Getzler notes the
Bolsheviks _"drove them underground, just on the eve of the elections to the
Fifth Congress of Soviets in which the Mensheviks were expected to make
significant gains."_ [**Op. Cit.**, p. 181]

Attacks on working class freedoms and democracy were not limited to the
soviets. As well as the gerrymandering and disbanding of soviets, the
Bolsheviks had already presented economic visions much at odds with what most
people consider as fundamentally socialist. Lenin, in April 1918, was arguing
for one-man management and _"[o]bedience, and unquestioning obedience at that,
during work to the one-man decisions of Soviet directors, of the dictators
elected or appointed by Soviet institutions, vested with dictatorial powers."_
[**Six Theses on the Immediate Tasks of the Soviet Government**, p. 44] His
support for a new form of wage slavery involved granting state appointed
_"individual executives dictatorial powers (or 'unlimited' powers)."_ Large-
scale industry (_"the foundation of socialism"_) required _"thousands
subordinating their will to the will of one,"_ and so the revolution "demands"
that _"the people **unquestioningly** obey the single will of the leaders of
labour."_ Lenin's _"superior forms of labour discipline"_ were simply hyper-
developed capitalist forms. The role of workers in production was the same,
but with a novel twist, namely _"unquestioning obedience to the orders of
individual representatives of the Soviet government during the work."_ [Lenin,
**Selected Writings**, vol. 2, p. 610, p. 611, p. 612]

This simply replaced private capitalism with **state** capitalism. _"In the
shops where one-man management (Lenin's own preference) replaced collegial
management,"_ notes Diane Koenker, _"workers faced the same kinds of
authoritarian management they thought existed only under capitalism."_
[**Labour Relations in Socialist Russia**, p. 177] If, as many Leninists
claim, one-man management was a key factor in the rise of Stalinism and/or _
"state-capitalism"_ in Russia, then, clearly, Lenin's input in these
developments cannot be ignored. After advocating _"one-man management"_ and
_"state capitalism"_ in early 1918, he remained a firm supporter of them. In
the light of this it is bizarre that some later day Leninists claim that the
Bolsheviks only introduced one-man management because of the Civil War.
Clearly, this was **not** the case. It was **this** period (before the civil
war) that saw Lenin advocate and start to take the control of the economy out
of the hands of the workers and placed into the hands of the Bolshevik party
and the state bureaucracy.

Needless to say, the Bolshevik undermining of the factory committee movement
and, consequently, genuine worker's self-management of production in favour of
state capitalism cannot be gone into great depth here (see the appendix on
["What happened during the Russian Revolution?"](append41.html), for a fuller
discussion). Suffice to say, the factory committees were deliberately
submerged in the trade unions and state control replaced workers' control.
This involved practising one-man management and, as Lenin put in at the start
of May 1918, _"our task is to study the state capitalism of the Germans, to
spare **no effort** in copying it and not to shrink from adopting
**dictatorial** methods to hasten the copying of it."_ He stressed that this
was no new idea, rather he _"gave it **before** the Bolsheviks seized power."_
[**Selected Writings**, vol. 2, p. 635 and p. 636]

It will be objected that Lenin advocated _"workers' control."_ This is true,
but a _"workers' control"_ of a **very** limited nature. As we discuss in
[section H.3.14](secH3.html#sech314), rather than seeing "workers' control" as
workers managing production directly, he always saw it in terms of workers'
_"controlling"_ those who did and his views on this matter were **radically**
different to those of the factory committees. This is not all, as Lenin always
placed his ideas in a statist context -- rather than base socialist
reconstruction on working class self-organisation from below, the Bolsheviks
started _"to build, from the top, its 'unified administration'"_ based on
central bodies created by the Tsarist government in 1915 and 1916. [Maurice
Brinton, **The Bolsheviks and Workers' Control**, p. 36] The institutional
framework of capitalism would be utilised as the principal (almost exclusive)
instruments of "socialist" transformation. Lenin's support for _"one-man
management"_ must be seen in this context, namely his vision of "socialism."

Bolshevik advocating and implementing of _"one-man management"_ was not
limited to the workplace. On March 30th Trotsky, as Commissar of Military
Affairs, set about reorganising the army. The death penalty for disobedience
under fire was reintroduced, as was saluting officers, special forms of
address, separate living quarters and privileges for officers. Officers were
no longer elected. Trotsky made it clear: _"The elective basis is politically
pointless and technically inexpedient and has already been set aside by
decree."_ [quoted by Brinton, **Op. Cit.**, pp. 37-8] The soldiers were given
no say in their fate, as per bourgeois armies.

Lenin's proposals also struck at the heart of workers' power in other ways.
For example, he argued that _"we must raise the question of piece-work and
apply it . . . in practice."_ [**The Immediate Tasks Of The Soviet
Government**, p. 23] As Leninist Tony Cliff (of all people) noted, _"the
employers have at their disposal a number of effective methods of disrupting
th[e] unity [of workers as a class]. Once of the most important of these is
the fostering of competition between workers by means of piece-work systems."_
He notes that these were used by the Nazis and the Stalinists _"for the same
purpose."_ [**State Capitalism in Russia**, pp. 18-9] Obviously piece-work is
different when Lenin introduces it!

Finally, there is the question of general political freedom. It goes without
saying that the Bolsheviks suppressed freedom of the press (for left-wing
opposition groups as well as capitalist ones). It was also in this time period
that the Bolsheviks first used the secret police to attack opposition groups.
Unsurprisingly, this was not directed against the right. The anarchists in
Moscow were attacked on the night of April 11-12, with armed detachments of
the Cheka raiding 26 anarchist centres, killing or wounding 40 and jailing
500. Shortly afterwards the Cheka carried out similar raids in Petrograd and
in the provinces. In May **Burevestnik**, **Anarkhiia**, **Golos Truda** and
other leading anarchist periodicals closed down. [Paul Avrich, **The Russian
Anarchists**, pp. 184-5] It must surely be a coincidence that there had been a
_"continued growth of anarchist influence among unskilled workers"_ after the
October revolution and, equally coincidentally, that _"[b]y the spring of
1918, very little was heard from the anarchists in Petrograd."_ [David Mandel,
**The Petrograd Workers and the Soviet Seizure of Power**, p. 357]

All this **before** the Trotsky provoked revolt of the Czech legion at the end
of May, 1918, and the consequent "democratic counter-revolution" in favour of
the Constituent Assembly (which the right-Socialist Revolutionaries led).
This, to repeat, was months before the rise of the White Armies and Allied
intervention. In summary, it was **before** large-scale civil war took place,
in an interval of relative peace, that we see the introduction of most of the
measures Leninists now try and pretend were necessitated by the Civil War
itself.

So if anarchists appear to "downplay" the effects of the civil war it is not
because we ignore. We simply recognise that if you think it is inevitable, you
cannot blame it for the actions of the Bolsheviks. Moreover, when the
Bolsheviks eliminated military democracy, undermined the factory committees,
started to disband soviets elected with the "wrong" majority, repress the
anarchists and other left-wing opposition groups, and so on, **the civil war
had not started yet.** So the rot had started before civil war (and consequent
White Terror) and "imperialist intervention" started. Given that Lenin said
that civil war was inevitable, blaming the inevitable (which had not even
started yet!) for the failure of Bolshevism is **not** very convincing.

This factual problem with the _"civil war caused Bolshevik authoritarianism"_
is the best answer to it. If the Bolsheviks pursued authoritarian policies
before the civil war started, it is hard to justify their actions in terms of
something that had not started yet. This explains why some Leninists have
tried to muddy the waters somewhat by obscuring when the civil war started.
For example, John Rees states that _"[m]ost historians treat the revolution
and the civil war as separate processes"_ yet _"[i]n reality they were one."_
He presents a catalogue of _"armed resistance to the revolution,"_ including
such _"precursors of civil war before the revolution"_ as the suppression
after the July days and the Kornilov revolt in 1917. [John Rees, _"In Defence
of October,"_ pp. 3-82, **International Socialism**, no. 52, p. 31-2]

Ironically, Rees fails to see how this blurring of when the civil war started
actually **harms** Leninism. After all, most historians place the start of the
civil war when the Czech legion revolted **because** it marked large-scale
conflict between armies. It is one thing to say that authoritarianism was
caused by large-scale conflict, another to say **any** form of conflict caused
it. Simply put, if the Bolshevik state could not handle relatively minor forms
of counter-revolution then where does that leave Lenin's **State and
Revolution**? So while the period from October to May of 1918 was not trouble
free, it was not one where the survival of the new regime looked to be
seriously threatened as it was after that, particularly in 1919 and 1920. Thus
"civil war" will be used, as it is commonly done, to refer to the period from
the Czech revolt (late May 1918) to the final defeat of Wrangel (November
1920).

So, the period from October to May of 1918, while not trouble free, was not
one where the survival of the new regime looked to be seriously threatened as
it was to be in 1919 and 1920. This means attempts to push the start of the
civil war back to October 1917 (or even earlier) simply weakens the Leninist
argument. It still leaves the major problem for the _"blame it on the civil
war"_ Leninists, namely to explain why the months **before** May of 1918 saw
soviets being closed down, the start of the suppression of the factory
committees, restrictions on freedom of speech and association, plus the
repression of opposition groups (like the anarchists). Either any level of
"civil war" makes Lenin's **State and Revolution** redundant or the source of
Bolshevik authoritarianism must be found elsewhere.

That covers the period **before** the start of the civil war. we now turn to
the period **after** it finished. Here we find the same problem, namely an
**increase** of authoritarianism even after the proclaimed cause for it (civil
war) had ended.

After the White General Wrangel was forced back into the Crimea, he had to
evacuate his forced to Constantinople in November 1920. With this defeat the
Russian civil war had come to an end. Those familiar with the history of the
revolution will realise that it was some 4 months **later** that yet another
massive strike wave occurred, the Kronstadt revolt took place and the 10th
Party Congress banned the existence of factions within the Bolshevik party
itself. The repression of the strikes and Kronstadt revolt effectively
destroying hope for mass pressure for change from below and the latter closing
off the very last "legal" door for those who opposed the regime from the left.

It could be argued that the Bolsheviks were still fighting peasant
insurrections and strikes across the country, but this has everything to do
with Bolshevik policies and could only be considered _"counter-revolutionary"_
if you think the Bolsheviks had a monopoly of what socialism and revolution
meant. In the case of the Makhnovists in the Ukraine, the Bolsheviks started
that conflict by betraying them once Wrangel had been defeated. As such, any
resistance to Bolshevik rule by the working class and peasantry of Russia
indicated the lack of democracy within the country rather than some sort of
"counter-revolutionary" conflict.

So even the end of the Civil War causes problems for this defence of the
Bolsheviks. Simply put, with the defeat of the Whites it would be expected
that some return to democratic norms would happen. It did not, in fact the
reverse happened. Factions were banned, even the smallest forms of opposition
was finally eliminated from both the party and society as a whole. Those
opposition groups and parties which had been tolerated during the civil war
were finally smashed. Popular revolts for reform, such as the Kronstadt
rebellion and the strike wave which inspired it, were put down by force (see
["What was the Kronstadt Rebellion?"](append42.html) on these events). No form
of opposition was tolerated, no freedom allowed. If civil war **was** the
cause of Bolshevik authoritarianism, it seems strange that it got worse after
it was finished.

So, to conclude. Bolshevik authoritarianism did not begun with the start of
the civil war. Anti-socialist policies were being implemented before it
started. Similarly, these policies did not stop when the civil war ended,
indeed the reverse happened. This, then, is the main factual problem with the
_"blame the civil war"_ approach. Much of the worst of the suppression of
working class democracy either happened **before** the Civil War started or
**after** it had finished.

As we discuss in ["How did Bolshevik ideology contribute to the failure of the
Revolution?"](append44.html), the root causes for Bolshevik authoritarian
post-October was Bolshevik ideology combined with state power. After all, how
"democratic" is it to give all power to the Bolshevik party central committee?
Surely socialism involves more than voting for a new government? Is it not
about mass participation, the kind of participation centralised government
precludes and Bolshevism fears as being influenced by _"bourgeois ideology"_?
In such circumstances, moving from party rule to party dictatorship is not
such leap.

That "civil war" cannot explain what happened can be shown by a counter-
example which effectively shows that civil war did not inevitably mean party
dictatorship over a state capitalist economy (and protesting workers and
peasants!). The Makhnovists (an anarchist influenced partisan army) managed to
defend the revolution and encourage soviet democracy, freedom of speech, and
so on, while doing so (see the appendix ["Why does the Makhnovist movement
show there is an alternative to Bolshevism?"](append46.html) discusses the
Makhnovists in some detail). In fact, the Bolsheviks tried to **ban** their
soviet congresses. Which, of course, does not really fit in with the
Bolsheviks being forced to be anti-democratic due to the pressures of civil
war.

So, in summary, civil war and imperialist intervention cannot be blamed for
Bolshevik authoritarianism simply because the latter had started before the
former existed. Moreover, the example of the Makhnovists suggests that
Bolshevik policies during the civil war were also not driven purely by the
need for survival. As Kropotkin argued at the time, _"all foreign armed
intervention necessarily strengthens the dictatorial tendencies of the
government . . . The evils inherent in a party dictatorship have been
accentuated by the conditions of war in which this party maintains its power.
This state of war has been the pretext for strengthening dictatorial methods
which centralise the control of every detail of life in the hands of the
government, with the effect of stopping an immense part of the ordinary
activity of the country. The evils natural to state communism have been
increased ten-fold under the pretext that all our misery is due to foreign
intervention."_ [**Kropotkin's Revolutionary Pamphlets**, p. 253]

In other words, while the civil war may have increased Bolshevik
authoritarianism, it did not create it nor did it end with the ending of
hostilities.

## 4 Did economic collapse and isolation destroy the revolution?

One of the most common explanations for the failure revolution is that the
Bolsheviks faced a terrible economic conditions, which forced them to be less
than democratic. Combined with the failure of the revolution to spread to more
advanced countries, party dictatorship, it is argued, was inevitable. In the
words of one Leninist:

> _ "In a country where the working class was a minority of the population,
where industry had been battered by years of war and in conditions of White
and imperialist encirclement, the balance gradually titled towards greater
coercion. Each step of the way was forced on the Bolsheviks by dire and
pressing necessities."_ [John Rees, _"In Defence of October,"_ **International
Socialism**, no. 52, p. 41]

He talks of _"economic devastation"_ [p. 31] and quotes various sources,
including Victor Serge. According to Serge, the _"decline in production was
uninterrupted. It should be noted that this decline had already begun before
the revolution. In 1916 the output of agricultural machinery, for example, was
down by 80 per cent compared with 1913. The year 1917 had been marked by a
particularly general, rapid and serious downturn. The production figures for
the principal industries in 1913 and 1918 were, in millions of **poods**:
coal, from 1,738 to 731 (42 per cent); iron ore, from 57, 887 to 1,686; cast-
iron, from 256 to 31.5 (12.3 per cent); steel, from 259 to 24.5; rails, from
39.4 to 1.1. As a percentage of 1913 production, output of linen fell to 75
per cent, of sugar to 24 per cent, and tobacco to 19 per cent."_ Moreover,
production continued _"to fall until the end of civil war . . . For 1920, the
following indices are given as a percentage of output in 1913: coal, 27 per
cent; cast iron, 2.4 per cent; linen textiles, 38 per cent."_ [**Year One of
the Russian Revolution**, p. 352 and p. 425]

According to Tony Cliff (another of Rees's references), the war-damaged
industry _"continued to run down"_ in the spring of 1918: _"One of the causes
of famine was the breakdown of transport . . . Industry was in a state of
complete collapse. Not only was there no food to feed the factory workers;
there was no raw material or fuel for industry . . . The collapse of industry
meant unemployment for the workers."_ Cliff provides economic indexes. For
large scale industry, taking 1913 as the base, 1917 saw production fall to
77%. In 1918, it was at 35% of the 1913 figure, 1919 it was 26% and 1920 was
18%. Productivity per worker also fell, from 85% in 1917, to 44% in 1918, 22%
in 1919 and then 26% in 1920. [**Lenin**, vol. 3, pp. 67-9, p. 86 and p. 85]

In such circumstances, it is argued, how can you expect the Bolsheviks to
subscribe to democratic and socialist norms? This meant that the success or
failure of the revolution depended on whether the revolution spread to more
advanced countries. Leninist Duncan Hallas argues that the _"failure of the
German Revolution in 1918-19 . . . seems, in retrospect, to have been decisive
. . . for only substantial economic aid from an advanced economy, in practice
from a socialist Germany, could have reversed the disintegration of the
Russian working class."_ [_"Towards a revolutionary socialist party,"_ pp.
38-55, **Party and Class**, Alex Callinicos (ed.), p. 44]

Anarchists are not convinced by these arguments. This is for two reasons.

Firstly, we are aware that revolutions are disruptive no matter where they
occur (see [section 1](append43.html#app1)) Moreover, Leninists are meant to
know this to. Simply put, there is a certain incredulous element to these
arguments. After all, Lenin himself had argued that _"[e]very revolution . . .
by its very nature implies a crisis, and a very deep crisis at that, both
political and economic. This is irrespective of the crisis brought about by
the war."_ [**Collected Works**, vol. 30, p. 341] Serge also considered crisis
as inevitable, arguing that the _"conquest of production by the proletariat
was in itself a stupendous victory, one which saved the revolution's life.
Undoubtedly, so thorough a recasting of all the organs of production is
impossible without a substantial decline in output; undoubtedly, too, a
proletariat cannot labour and fight at the same time."_ [**Op. Cit.**, p. 361]
As we discussed in detail in [section 2](append43.html#app2), this was a
common Bolshevik position at the time (which, in turn, belatedly echoed
anarchist arguments -- see [section 1](append43.html#app1)). And if we look at
other revolutions, we can say that this is the case.

Secondly, and more importantly, every revolution or near revolutionary
situation has been accompanied by economic crisis. For example, as we will
shortly prove, Germany itself was in a state of serious economic collapse in
1918 and 1919, a collapse which would have got worse is a Bolshevik-style
revolution had occurred there. This means that **if** Bolshevik
authoritarianism is blamed on the state of the economy, it is not hard to
conclude that **every** Bolshevik-style revolution will suffer the same fate
as the Russian one.

As we noted in [section 1](append43.html#app1), Kropotkin had argued from the
1880s that a revolution would be accompanied by economic disruption. Looking
at subsequent revolutions, he has been vindicated time and time again. Every
revolution has been marked by economic disruption and falling production. This
suggests that the common Leninist idea that a successful revolution in, say,
Germany would have ensured the success of the Russian Revolution is flawed.
Looking at Europe during the period immediately after the first world war, we
discover great economic hardship. To quote one Trotskyist editor:

> _ "In the major imperialist countries of Europe, production still had not
recovered from wartime destruction. A limited economic upswing in 1919 and
early 1920 enabled many demobilised soldiers to find work, and unemployment
fell somewhat. Nonetheless, in 'victorious' France overall production in 1920
was still only two-thirds its pre-war level. In Germany industrial production
was little more than half its 1914 level, human consumption of grains was down
44 per cent, and the economy was gripped by spiralling inflation. Average per
capita wages in Prague in 1920, adjusted for inflation, were just over one-
third of pre-war levels."_ [John Riddell, _"Introduction,"_ **Proceedings and
Documents of the Second Congress, 1920**, vol. I, p. 17]

Now, if economic collapse was responsible for Bolshevik authoritarianism and
the subsequent failure of the revolution, it seems hard to understand why an
expansion of the revolution into similarly crisis ridden countries would have
had a major impact in the development of the revolution. Since most Leninists
agree that the German Revolution, we will discuss this in more detail before
going onto other revolutions.

By 1918, Germany was in a bad state. Victor Serge noted _"the famine and
economic collapse which caused the final ruin of the Central Powers."_ [**Op.
Cit.**, p. 361] The semi-blockade of Germany during the war badly effected the
economy, the _"dynamic growth"_ of which before the war _"had been largely
dependent on the country's involvement in the world market"_. The war _"proved
catastrophic to those who had depended on the world market and had been
involved in the production of consumer goods . . . Slowly but surely the
country slithered into austerity and ultimately economic collapse."_ Food
production suffered, with _"overall food production declined further after
poor harvests in 1916 and 1917. Thus grain production, already well below its
prewar levels, slumped from 21.8 million to 14.9 million tons in those two
years."_ [V. R. Berghahn, **Modern Germany**, p. 47, pp. 47-8, p. 50]

The parallels with pre-revolution Russia are striking and it is hardly
surprising that revolution did break out in Germany in November 1918. Workers'
councils sprang up all across the country, inspired in part by the example of
the Russian soviets (and what people **thought** was going on in Russia under
the Bolsheviks). A Social-Democratic government was founded, which used the
Free Corps (right-wing volunteer troops) to crush the revolution from January
1919 onwards. This meant that Germany in 1919 was marked by extensive civil
war within the country. In January 1920, a state of siege was re-introduced
across half the country.

This social turmoil was matched by economic turmoil. As in Russia, Germany
faced massive economic problems, problems which the revolution inherited.
Taking 1928 as the base year, the index of industrial production in Germany
was slightly lower in 1913, namely 98 in 1913 to 100 in 1928. In other words,
Germany effectively lost 15 years of economic activity. In 1917, the index was
63 and by 1918 (the year of the revolution), it was 61 (i.e. industrial
production had dropped by nearly 40%). In 1919, it fell again to 37, rising to
54 in 1920 and 65 in 1921. Thus, in 1919, the _"industrial production reached
an all-time low"_ and it _"took until the late 1920s for [food] production to
recover its 1912 level . . . In 1921 grain production was still . . . some 30
per cent below the 1912 figure."_ Coal production was 69.1% of its 1913 level
in 1920, falling to 32.8% in 1923. Iron production was 33.1% in 1920 and 25.6%
in 1923. Steel production likewise fell to 48.5% in 1920 and fell again to 36%
in 1923. [V. R. Berghahn, **Op. Cit.**, p. 258, pp. 67-8, p. 71 and p. 259]

Significantly, one of the first acts of the Bolshevik government towards the
new German government was to _"the offer by the Soviet authorities of two
trainloads of grain for the hungry German population. It was a symbolical
gesture and, in view of desperate shortages in Russia itself, a generous
one."_ The offer, perhaps unsurprisingly, was rejected in favour of grain from
America. [E.H. Carr, **The Bolshevik Revolution**, vol. 3, p. 106]

The similarities between Germany and Russia are clear. As noted above, in
Russia, the index for large scale industry fell to 77 in 1917 from 100 in
1913, falling again to 35 in 1918, 26 in 1919 and 18 in 1920. [Tony Cliff,
**Lenin**, vol. 3, p. 86] In other words, a fall of 23% between 1913 and 1917,
54.5% between 1917 and 1918, 25.7% in 1918 and 30.8% in 1919. A similar
process occurred in Germany, where the fall production was 37.7% between 1913
and 1917, 8.2% between 1917 and 1918 and 33.9% between 1918 and 1919 (the year
of revolution). While production did rise in 1920 by 45.9%, production was
still around 45% less than before the war.

Thus, comparing the two countries we discover a similar picture of economic
collapse. In the year the revolution started, production had fallen by 23% in
Russia (from 1913 to 1917) and by 43% in Germany (from 1913 to 1918). Once
revolution had effectively started, production fell even more. In Russia, it
fell to 65% of its pre-war level in 1918, in Germany it fell to 62% of its
pre-war level in 1919. Of course, in Germany revolution did not go as far as
in Russia, and so production did rise somewhat in 1920 and afterwards. What is
significant is that in 1923, production fell dramatically by 34% (from around
70% of its pre-war level to around 45% of that level). This economic collapse
did not deter the Communists from trying to provoke a revolution in Germany
that year, so suggesting that economic disruption played no role in their
evaluation of the success of a revolution.

This economic chaos in Germany is never mentioned by Leninists when they
discuss the _"objective factors"_ facing the Russian Revolution. However, once
these facts are taken into account, the superficiality of the typical Leninist
explanation for the degeneration of the revolution becomes obvious. The very
problems which, it is claimed, forced the Bolsheviks to act as they did also
were rampant in Germany. If economic collapse made socialism impossible in
Russia, it would surely have had the same effect in Germany (and any social
revolution would also have faced more disruption than actually faced post 1919
in Germany). This means, given that the economic collapse in both 1918/19 and
1923 was as bad as that facing Russia in 1918 and that the Bolsheviks had
started to undermine soviet and military democracy along with workers' control
by spring and summer of that year (see [section 5](append43.html#app5)), to
blame Bolshevik actions on economic collapse would mean that any German
revolution would have been subject to the same authoritarianism **if** the
roots of Bolshevik authoritarianism were forced by economic events rather than
a product of applying a specific political ideology via state power. Few
Leninists draw this obvious conclusion from their own arguments although there
is no reason for them not to.

So the German Revolution was facing the same problems the Russian one was. It
seems unlikely, therefore, that a successful German revolution would have been
that much aid to Russia. This means that when John Rees argues that giving
machinery or goods to the peasants in return for grain instead of simply
seizing it required _"revolution in Germany, or at least the revival of
industry"_ in Russia, he completely fails to indicate the troubles facing the
German revolution. _"Without a successful German revolution,"_ he writes,
_"the Bolsheviks were thrown back into a bloody civil war with only limited
resources. The revolution was under siege."_ [John Rees, _"In Defence of
October,"_ pp. 3-82, **International Socialism**, no. 52, p. 40 and p. 29] Yet
given the state of the German economy at the time, it is hard to see how much
help a successful German revolution would have been. As such, his belief that
a successful German Revolution would have mitigated Bolshevik authoritarianism
seems exactly that, a belief without any real evidence to support it (and let
us not forget, Bolshevik authoritarianism had started before the civil war
broke out -- see [section 3](append43.html#app3)). Moreover, **if** the pro-
Bolshevik argument Rees is expounding **is** correct, then the German
Revolution would have been subject to the same authoritarianism as befell the
Bolshevik one simply because it was facing a similar economic crisis. Luckily,
anarchists argue, that this need not be the case if libertarian principles are
applied in a revolution:

> _ "The first months of emancipation will inevitably increase consumption of
goods and production will diminish. And, furthermore, any country achieving
social revolution will be surrounded by a ring of neighbours either unfriendly
or actually enemies . . . The demands upon products will increase while
production decreases, and finally famine will come. There is only one way of
avoiding it. We should understand that as soon as a revolutionary movement
begins in any country the only possible way out will consist in the workingmen
[and women] and peasants from the beginning taking the whole national economy
into their hands and organising it themselves . . . But they will not be
convinced of this necessity except when all responsibility for national
economy, today in the hands of a multitude of ministers and committees, is
presented in a simple form to each village and city, in every factory and
shop, as their own affair, and when they understand that they must direct it
themselves."_ [**Kropotkin's Revolutionary Pamphlets**, pp. 77-8]

So, as regards the Russian and German revolution, Kropotkin's arguments were
proven correct. The same can be said of other revolutions as well. Basing
himself on the actual experiences of both the French Revolution and the Paris
Commune, we can see why Kropotkin argued as he did. The Paris Commune, for
example, was born after a four-month-long siege _"had left the capital in a
state of economic collapse. The winter had been the severest in living memory.
Food and fuel had been the main problems . . . Unemployment was widespread.
Thousands of demobilised soldiers wandered loose in Paris and joined in the
general hunt for food, shelter and warmth. For most working men the only
source of income was the 1.50 francs daily pay of the National Guard, which in
effect had become a form of unemployment pay."_ The city was _"near starving"_
and by March it was _"in a state of economic and political crisis."_ [Stewart
Edwards, _"Introduction,"_ **The Communards of Paris, 1871**, p. 23] Yet this
economic collapse and isolation did not stop the commune from introducing and
maintaining democratic forms of decision making, both political and economic.
A similar process occurred during the French Revolution, where mass
participation via the _"sections"_ was not hindered by economic collapse. It
was finally stopped by state action organised by the Jacobins to destroy
popular participation and initiative (see Kropotkin's **The Great French
Revolution** for details).

During the Spanish Revolution, _"overall Catalan production fell in the first
year of war by 30 per cent, and in the cotton-working sector of the textile
industry by twice as much. Overall unemployment (complete and partial) rose by
nearly a quarter in the first year, and this despite the military mobilisation
decreed in September 1936. The cost of living quadrupled in just over two
years; wages . . . only doubled."_ [Ronald Fraser, **Blood of Spain**, p. 234]
Markets, both internally and externally, for goods and raw materials were
disrupted, not to mention the foreign blockade and the difficulties imposed in
trying to buy products from other countries. These difficulties came on top of
problems caused by the great depression of the 1930s which affected Spain
along with most other countries. Yet, democratic norms of economic and social
decision making continued in spite of economic disruption. Ironically, given
the subject of this discussion, it was only once the Stalinist counter-
revolution got going were they fatally undermined or destroyed.

Thus economic disruption need not automatically imply authoritarian policies.
And just as well, given the fact that revolution and economic disruption seem
to go hand in hand.

Looking further afield, even **revolutionary** situations can be accompanied
with economic collapse. For example, the Argentine revolt which started in
2001 took place in the face of massive economic collapse. The economy was a
mess, with poverty and unemployment at disgusting levels. Four years of
recession saw the poverty rate balloon from 31 to 53 percent of the population
of 37 million, while unemployment climbed from 14 to 21.4 percent, according
to official figures. Yet in the face of such economic problems, working class
people acted collectively, forming popular assemblies and taking over
workplaces.

The Great Depression of the 1930s in America saw a much deeper economic
contradiction. Indeed, it was as bad as that associated with revolutionary
Germany and Russia after the first world war. According to Howard Zinn, after
the stock market crash in 1929 _"the economy was stunned, barely moving. Over
five thousand banks closed and huge numbers of businesses, unable to get
money, closed too. Those that continued laid off employees and cut the wages
of those who remained, again and again. Industrial production fell by 50
percent, and by 1933 perhaps 15 million (no knew exactly) -- one-forth or one-
third of the labour force -- were out of work."_ [**A People's History of the
United States**, p. 378]

Specific industries were badly affected. For example, total GNP fell to 53.6%
in 1933 compared to its 1929 value. The production of basic goods fell by much
more. Iron and Steel saw a 59.3% decline, machinery a 61.6% decline and _"non-
ferrous metals and products"_ a 55.9% decline. Transport was also affected,
with transportation equipment declining by 64.2% railroad car production
dropping by 73.6% and locomotion production declining by 86.4%. Furniture
production saw a decline of 57.9%. The workforce was equally affected, with
unemployment reaching 25% in 1933. In Chicago 40% of the workforce was
unemployed. Union membership, which had fallen from 5 million in 1920 to 3.4
million in 1929 fell to less than 3 million by 1933. [Lester V. Chandler,
**America's Greatest Depression, 1929-1941**, p. 20, p. 23, p. 34, p. 45 and
p. 228]

Yet in the face of this economic collapse, no Leninist proclaimed the
impossibility of socialism. In fact, the reverse what the case. Similar
arguments could apply to, say, post-world war two Europe, when economic
collapse and war damage did not stop Trotskyists looking forward to, and
seeking, revolutions there. Nor did the massive economic that occurred after
the fall of Stalinism in Russia in the early 1990s deter Leninist calls for
revolution. Indeed, you can rest assured that any drop in economic activity,
no matter how large or small, will be accompanied by Leninist articles arguing
for the immediate introduction of socialism. And this was the case in 1917 as
well, when economic crisis had been a fact of Russian life throughout the
year. Lenin, for example, argued at the end of September of that _"Russia is
threatened with an inevitable catastrophe . . .A catastrophe of extraordinary
dimensions, and a famine, are unavoidably threatening . . . Half a year of
revolution has passed. The catastrophe has come still closer. Things have come
to a state of mass unemployment. Think of it: the country is suffering from a
lack of commodities."_ [**The Threatening Catastrophe and how to Fight It**,
p. 5] This did not stop him calling for revolution and seizing power. Nor did
this crisis stop the creation of democratic working class organisations, such
as soviets, trade unions and factory committees being formed. It did not stop
mass collective action to combat those difficulties. It appears, therefore,
that while the economic crisis of 1917 did not stop the development of
socialist tendencies to combat it, the seizure of power by a socialist party
did.

Given that no Leninist has argued that a revolution could take place in
Germany after the war or in the USA during the darkest months of the Great
Depression, the argument that the grim economic conditions facing Bolshevik
Russia made soviet democracy impossible seem weak. By arguing that both
Germany and the USA could create a viable socialist revolution in economic
conditions just as bad as those facing Soviet Russia, the reasons why the
Bolsheviks created a party dictatorship must be looked for elsewhere. Given
this support for revolution in 1930s America and post-world war I and II
Europe, you would have to conclude that, for Leninists, economic collapse only
makes socialism impossible once **they** are in power! Which is hardly
convincing, or inspiring.

## 5 Was the Russian working class atomised or _"declassed"_?

A standard Leninist explanation for the dictatorship of the Bolshevik party
(and subsequent rise of Stalinism) is based on the _"atomisation"_ or
_"declassing"_ of the proletariat. John Rees summarises this argument as
follows:

> _ "The civil war had reduced industry to rubble. The working class base of
the workers' state, mobilises time and again to defeat the Whites, the rock on
which Bolshevik power stood, had disintegrated. The Bolsheviks survived three
years of civil war and wars in intervention, but only at the cost of reducing
the working class to an atomised, individualised mass, a fraction of its
former size, and no longer able to exercise the collective power that it had
done in 1917 . . . The bureaucracy of the workers' state was left suspended in
mid-air, its class base eroded and demoralised. Such conditions could not help
but have an effect on the machinery of the state and organisation of the
Bolshevik Party."_ [_"In Defence of October,"_ pp. 3-82, **International
Socialism**, no. 52, p. 65]

It is these objective factors which, it is argued, explain why the Bolshevik
party substituted itself for the Russian working class. _"Under such
conditions,"_ argues Tony Cliff, _"the class base of the Bolshevik Party
disintegrated -- not because of some mistakes in the policies of Bolshevism,
not because of one or another conception of Bolshevism regarding the role of
the party and its relation to the class -- but because of mightier historical
factors. The working class had become declassed . . . Bolshevik
'substitutionism' . . . did not jump out of Lenin's head as Minerva out of
Zeus's, but was born of the objective conditions of civil war in a peasant
country, where a small working class, reduced in weight, became fragmented and
dissolved into the peasant masses."_ [**Trotsky on Substitutionism**, pp.
62-3] In other words, because the working class was so decimated the
replacement of class power by party power was inevitable.

Before discussing this argument, we should point out that this argument dates
back to Lenin. For example, he argued in 1921 that the proletariat, _"owning
to the war and to the desperate poverty and ruin, has become declassed, i.e.
dislodged from its class groove, and had ceased to exist as proletariat . . .
the proletariat has disappeared."_ [**Collected Works**, vol. 33, p. 66]
However, unlike his later-day followers, Lenin was sure that while it _"would
be absurd and ridiculous to deny that the fact that the proletariat is
declassed is a handicap"_ it could still _"fulfil its task of wining and
holding state power."_ [**Op. Cit.**, vol. 32, p. 412] As we will see, the
context in which Lenin started to make these arguments is important.

Anarchists do not find these arguments particularly convincing. This is for
two reasons. Firstly, it seems incredulous to blame the civil war for the
_"substitution"_ of Bolshevik power for working class power as party power had
been Lenin's stated aim in 1917 and October saw the seizure of power by the
Bolsheviks, **not** the soviets. As we saw in [section 3](append43.html#app3),
the Bolsheviks started to gerrymander and disband soviets to remain in power
**before** the civil war started. As such, to blame the civil war and the
problems it caused for the usurpation of power by the Bolsheviks seems
unconvincing. Simply put, the Bolsheviks had _"substituted"_ itself for the
proletariat from the start, from the day it seized power in the October
revolution.

Secondly, the fact is the Russian working class was far from _"atomised."_
Rather than being incapable of collective action, as Leninists assert,
Russia's workers were more than capable of taking collective action throughout
the civil war period. The problem is, of course, that any such collective
action was directed **against** the Bolshevik party. This caused the party no
end of problems. After all, if the working class **was** the ruling class
under the Bolsheviks, then who was it striking against? Emma Goldman explains
the issue well:

> _ "In my early period the question of strikes had puzzled me a great deal.
People had told me that the least attempt of that kind was crushed and the
participants sent to prison. I had not believed it, and, as in all similar
things, I turned to Zorin [a Bolshevik] for information. 'Strikes under the
dictatorship of the proletariat!' he had proclaimed; 'there's no such thing.'
He had even upbraided me for crediting such wild and impossible tales. Against
whom, indeed, should the workers strike in Soviet Russia, he argued. Against
themselves? They were the masters of the country, politically as well as
industrially. To be sure, there were some among the toilers who were not yet
fully class-conscious and aware of their own true interests. These were
sometimes disgruntled, but they were elements incited by . . . self-seekers
and enemies of the Revolution."_ [**Living My Life**, vol. 2, p. 872]

This, unfortunately, still seems to be the case in pro-Bolshevik accounts of
the Revolution and its degeneration. After the Bolshevik seizure of power, the
working class as an active agent almost immediately disappears from the
accounts. This is unsurprising, as it does not bode well for maintaining the
Bolshevik Myth to admit that workers were resisting the so-called
_"proletarian dictatorship"_ from the start. The notion that the working class
had _"disappeared"_ fits into this selective blindness well. Why discuss the
actions of a class which did not exist? Thus we have a logical circle from
which reality can be excluded: the working class is _"atomised"_ and so cannot
take industrial action, evidence of industrial action need not be looked for
because the class is _"atomised."_

This can be seen from Lenin. For example, he proclaimed in October 1921 that
_"the proletariat had disappeared."_ Yet this non-existent class had, in early
1921, taken collective action which _"encompassed most of the country's
industrial regions."_ [J. Aves, **Workers Against Lenin**, p. 111]
Significantly, the Communists (then and now) refused to call the movement a
strike, preferring the word _"volynka"_ which means _"go-slow."_ The Menshevik
leader Dan explained why: _"The Bolshevik press carefully tried, at first, to
hush up the movement, then to hide its real size and character. Instead of
calling the strike a strike, they thought up various new terms -- **yolynka,**
**buza** and so on."_ [quoted by Aves, **Op. Cit.**, p. 112] As Russian
anarchist Ida Mett succinctly put it: _"And if the proletariat was that
exhausted how come it was still capable of waging virtually total general
strikes in the largest and most heavily industrialised cities?"_ [Ida Mett,
**The Kronstadt Rebellion**, p. 81]

The year after Lenin proclaimed the proletariat _"disappeared"_ we discover
similar evidence of working class collective action. Ironically, it is
Leninist Tony Cliff who presents the evidence that _"the number of workers
involved in labour conflicts was three and a half million, and in 1923,
1,592,800."_ Strikes in state-owned workplaces in 1922 involved 192,000
workers. [**State Capitalism in Russia**, p. 28] Given that Cliff states that
in 1921 there was only _"one and a quarter million"_ industrial workers
_"proper"_ (compared to over three million in 1917), this level of strikes is
extremely large -- particular for members of a class which did not, according
to Lenin which had _"disappeared"_!

Before providing more evidence for the existence of working class collective
struggle throughout the period 1918 to 1923, it is necessary to place Lenin's
comments on the _"declassing"_ of the working class in context. Rather than
being the result of a lack of industrial protest, Lenin's arguments were the
product of its opposite -- the rise in collective struggle by the Russian
working class. As one historian notes: _"As discontent amongst workers became
more and more difficult to ignore, Lenin . . . began to argue that the
consciousness of the working class had deteriorated . . . workers had become
'declassed.'"_ _"Lenin's analysis,"_ he continues, _"had a superficial logic
but it was based on a false conception of working-class consciousness. There
is little evidence to suggest that the demands that workers made at the end of
1920 . . . represented a fundamental change in aspirations since 1917 . . .
[Moreover] an analysis of the industrial unrest in 1921 shows that long-
standing workers were prominent in protest."_ [J. Aves, **Op. Cit.**, p. 90
and pp. 90-1]

Lenin's pessimistic analysis of 1921 is in sharp contrast to the optimistic
mood of early 1920, reproduced by the defeat of the White armies, in Bolshevik
ranks. For example, writing in May, 1920, Trotsky seemed oblivious to the
_"atomisation"_ of the Russian working class, arguing that _"in spite of
political tortures, physical sufferings and horrors, the labouring masses are
infinitely distinct from political decomposition, from moral collapse, or from
apathy . . . Today, in all branches of industry, there is going on an
energetic struggle for the establishment of strict labour discipline, and for
the increase of the productivity of labour. The party organisations, the trade
unions, the factory and workshop administrative committees, rival each one
another in this respect, with the undivided support of the working class as a
whole."_ Indeed, they _"concentrate their attention and will on collective
problems"_ (_"Thanks to a regime which . . . given their life a pursue"_!).
Needless to say, the party had _"the undivided support of the public opinion
of the working class as a whole."_ [**Terrorism and Communism**, p. 6]

The turn around in perspective after this period did not happen by accident,
independently of the working class resistance to Bolshevik rule. After all,
the defeat of the Whites in early of 1920 saw the Bolsheviks take _"victory as
a sign of the correctness of its ideological approach and set about the task
of reconstruction on the basis of an intensification of War Communism policies
with redoubled determination."_ This led to _"an increase in industrial unrest
in 1920,"_ including _"serious strikes."_ The resistance was _"becoming
increasingly politicised."_ Thus, the stage was set for Lenin's turn around
and his talk of _"declassing."_ In early 1921 _"Lenin argued that workers, who
were no more demoralised than they were in early 1920, had become 'declassed'
in order to justify a political clamp-down."_ [J. Aves, **Op. Cit.**, p. 37,
p. 80 and p. 18]

Other historians also note this context. For example, while the _"working
class had decreased in size and changed in composition, . . . the protest
movement from late 1920 made clear that it was not a negligible force and that
in an inchoate way it retained a vision of socialism which was not identified
entirely with Bolshevik power . . . Lenin's arguments on the declassing of the
proletariat was more a way of avoiding this unpleasant truth than a real
reflection of what remained, in Moscow at least, a substantial physical and
ideological force."_ [Richard Sakwa, Soviet Communists in Power, p. 261] In
the words of Diane Koenker, _"[i]f Lenin's perceptions of the situation were
at all representative, it appears that the Bolshevik party made deurbanisation
and declassing the scapegoat for its political difficulties, when the party's
own policies and its unwillingness to accept changing proletarian attitudes
were also to blame."_ Ironically, this was not the first time that the
Bolsheviks had blamed its problems on the lack of a _"true"_ proletariat and
its replacement by "petty-bourgeois" elements, _"[t]his was the same argument
used to explain the Bolsheviks' lack of success in the early months of 1917 --
that the cadres of conscious proletarians were diluted by non-proletarian
elements."_ [_"Urbanisation and Deurbanisation in the Russian Revolution and
Civil War,"_ pp. 424-450, **The Journal of Modern History**, vol. 57, no. 3,
p. 449 and p. 428]

It should be noted that the _"declassing"_ argument does have a superficial
validity if you accept the logic of vanguardism. After all, if you accept the
premise that the party alone represents socialist consciousness and that the
working class, by its own efforts, can only reach a reformist level of
political conscious (at best), then any deviation in working class support for
the party obviously represents a drop in class consciousness or a
_"declassing"_ of the proletariat (see section H.5.1 -- _["Why are vanguard
parties anti-socialist?"](secH5.html#sech51)_). Thus working class protest
against the party can be dismissed as evidence of _"declassing"_ which has to
be suppressed rather than what it really is, namely evidence of working class
autonomy and collective struggle for what it considers **its** interests to be
against a new master class. In fact, the _"declassing"_ argument is related to
the vanguardist position which, in turn, justifies the dictatorship of the
party **over** the class (see section H.5.3 -- _["Why does vanguardism imply
party power?"](secH5.html#sech53)_).

So the _"declassing"_ argument is not some neutral statement of fact. It was
developed as a weapon on the class struggle, to justify Bolshevik repression
of collective working class struggle. To justify the continuation of Bolshevik
party dictatorship **over** the working class. This in turn explains why
working class struggle during this period generally fails to get mentioned by
later day Bolsheviks -- it simply undermines their justifications for
Bolshevik dictatorship. After all, how can they say that the working class
could not exercise _"collective power"_ when it was conducting mass strikes
throughout Russia during the period 1918 to 1923?

As such, it does not seem that strange that in most Leninist account of the
revolution post-October rarely, if ever, mention what the working class was
actually doing. We do get statistics on the drop of the numbers of industrial
workers in the cities (usually Petrograd and Moscow), but any discussion on
working class protest and strikes is generally, at best, mentioned in passing
or, usually, ignored utterly. Given this was meant to be a _"proletarian"_
dictatorship, it seems strange this silence. It could be argued that this
silence is due to the working class being decimated in number and/or
_"declassed"_ in terms of itself perspective. This, however, seems unlikely,
as collective working class protest was common place in Bolshevik Russia. The
silence can be better understood by the fact this protest was directed
**against** the Bolsheviks.

Which shows the bankruptcy of what can be called the _"statistical tendency"_
of analysing the Russian working class. While statistics can tell us how many
workers remained in Russia in, say, 1921, it does not prove any idea of their
combativeness or their ability to take collective decisions and action. If
numbers alone indicated the ability of workers to take part in collective
struggle, then the massive labour struggles in 1930s American would not have
taken place. Millions had been made redundant. At the Ford Motor Company,
128,000 workers had been employed in the spring of 1929. There were only
37,000 by August of 1931 (only 29% of the 1929 figure). By the end of 1930,
almost half of the 280,000 textile mill workers in New England were out of
work. [Howard Zinn, **A People's History of the United States**, p. 378] Yet
in the face of these massive redundancies, the workers organised themselves
and fought back. As we will indicate, the reduction in the number of Russian
workers did not restrict their ability to make collective decisions and act
collectively on them -- Bolshevik repression **did.**

Moreover, while Leninists usually point to the fall in population in Petrograd
and Moscow during the civil war, concentrating on these cities can be
misleading. _"Using the Petrograd figures,"_ notes Daniel R. Bower,
_"historians have painted a lurid picture of flight from the cities. In 1918
alone the former capital lost 850,000 people and was by itself responsible for
one-half of the total urban population decline of the Civil War years. If one
sets aside aggregate figures to determine the trend characteristic of most
cities, however, the experiences of Petrograd appears exception. Only a
handful of cities . . . lost half their population between 1917 and 1920, and
even Moscow, which declined by over 40 percent, was not typical of most towns
in the northern, food-importing areas. A study of all cities . . . found that
the average decline in the north (167 towns in all, excluding the capital
cities) amounted to 24 percent between 1917 and 1920. Among the towns in the
food-producing areas in the southern and eastern regions of the Russian
Republic (a total of 128), the average decline came to only 14 percent."_
[_"'The city in danger': The Civil War and the Russian Urban Population,"_
**Party, State, and Society in the Russian Civil War**, Diane P. Koenker,
William G. Rosenberg and Ronald Grigor Suny (eds.), p. 61] Does this mean that
the possibility of soviet democracy declined less in these towns? Yet the
Bolsheviks applied their dictatorships even there, suggesting that declining
urban populations was not the source of their authoritarianism.

Equally, what are we to make of towns and cities which increased their
populations? Some towns and cites actually grew in size. For example, Minsk,
Samara, Khar'kov, Tiflis, Baku, Rostov-on-don, Tsaritsyn and Perm all grew in
population (often by significant amounts) between 1910 and 1920 while other
cities shrunk. [Diane Koenker, _"Urbanisation and Deurbanisation in the
Russian Revolution and Civil War,"_ pp. 424-450, **The Journal of Modern
History**, vol. 57, no. 3, p. 425] Does that mention soviet democracy was
possible in those towns but not in Petrograd or Moscow? Or does the fact that
the industrial workforce grew by 14.8% between October 1920 and April 1921
mean that the possibility for soviet democracy also grew by a similar
percentage? [J. Aves, **Workers Against Lenin**, p. 159]

Then there is the question of when the reduction of workers makes soviet
democracy impossible. After all, between May 1917 and April 1918 the city of
Moscow lost 300,000 of its two million inhabitants. Was soviet democracy
impossible in April 1918 because of this? During the civil war, Moscow lost
another 700,000 by 1920 (which is basically the same amount per year). [Diane
Koenker, **Op. Cit.**, p. 424] When did this fall in population mean that
soviet democracy was impossible? Simply put, comparing figures of one year to
another simply fails to understand the dynamics at work, such as the impact of
_"reasons of state"_ and working class resistance to Bolshevik rule. It, in
effect, turns the attention away from the state of working class autonomy and
onto number crunching.

Ultimately, the question of whether the working class was too _"atomised"_ to
govern can only be answered by looking at the class struggle in Russia during
this period, by looking at the strikes, demonstrations and protests that
occurred. Something Leninists rarely do. Needless to say, certain strike waves
just cannot be ignored. The most obvious case is in Petrograd just before the
Kronstadt revolt in early 1921. After all, the strikes (and subsequent
Bolshevik repression) inspired the sailors to revolt in solidarity with them.
Faced with such events, the scale of the protest and Bolshevik repression is
understated and the subject quickly changed. As we noted in [section
10](append42.html#app10) of the appendix on ["What was the Kronstadt
Rebellion?"](append42.html), John Rees states that Kronstadt was _"preceded by
a wave of serious but quickly resolved strikes."_ [Rees, **Op. Cit.**, p. 61]
Needless to say, he does not mention that the strikes were _"resolved"_ by
_"serious"_ force. Nor does he explain how _"an atomised, individualised
mass"_ **could** conduct such _"serious"_ strikes, strikes which required
martial law to break. Little wonder, then, Rees does expound on the strikes
and what they meant in terms of the revolution and his own argument.

Similarly, we find Victor Serge arguing that the _"working class often fretted
and cursed; sometimes it lent an ear to the Menshevik agitators, as in the
great strikes at Petrograd in the spring of 1919. But once the choice was
posed as that between the dictatorship of the White Generals and the
dictatorship of its own party -- and there was not and could not be any other
choice -- every fit man . . . came to stand . . . before the windows of the
local party offices."_ [**Year One of the Russian Revolution**, pp. 365-6] An
exhausted and atomised working class capable of _"great strikes"_? That seems
unlikely. Significantly, Serge does not mention the Bolshevik acts of
repression used against the rebel workers (see below). This omission cannot
help distort any conclusions to be drawn from his account.

Which, incidentally, shows that the civil war was not all bad news for the
Bolsheviks. Faced with working class protest, they could play the _"White
card"_ \-- unless the workers went back to work, the Whites would win. This
explains why the strikes of early 1921 were larger than before and explains
why they were so important. As the _"White card"_ could no longer be played,
the Bolshevik repression could not be excused in terms of the civil war.
Indeed, given working class opposition to the party, it would be fair to say
that civil war actually **helped** the Bolsheviks remain in power. Without the
threat of the Whites, the working class would **not** have tolerated the
Bolsheviks longer than the Autumn of 1918.

The fact is that working class collective struggle against the new regime and,
consequently, Bolshevik repression, started before the outbreak of the civil
war. It continued throughout the civil war period and reached a climax in the
early months of 1921. Even the repression of the Kronstadt rebellion did not
stop it, with strikes continuing into 1923 (and, to a lesser degree,
afterward). Indeed, the history of the _"workers' state"_ is a history of the
state repressing the revolt of the workers.

Needless to say, it would be impossible to give a full account of working
class resistance to Bolshevism. All we can do here is give a flavour of what
was happening and the sources for further information. What should be clear
from our account is that the idea that the working class in this period was
incapable of collective organisation and struggle is false. As such, the idea
that Bolshevik _"substitutionism"_ can be explained in such term is also
false. In addition, it will become clear that Bolshevik repression explicitly
aimed to break the ability of workers to organise and exercise collective
power. As such, it seems hypocritical for modern-day Leninists to blame
Bolshevik power on the _"atomisation"_ of the working class when Bolshevik
power was dependent on smashing working class collective organisation and
resistance. Simply put, to remain in power Bolshevism, from the start, had to
crush working class power. This is to be expected, given the centralised
nature of the state and the assumptions of vanguardism. If you like, October
1917 did not see the end of _"dual power."_ Rather the Bolshevik state
replaced the bourgeois state and working class power (as expressed in its
collective struggle) came into conflict with it.

This struggle of the _"workers' state"_ against the workers started early in
1918. _"By the early summer of 1918,"_ records one historian, _"there were
widespread anti-Bolshevik protests. Armed clashes occurred in the factory
districts of Petrograd and other industrial centres. Under the aegis of the
Conference of Factory and Plant Representatives . . . a general strike was set
for July 2."_ [William Rosenberg, _"Russian labour and Bolshevik Power,"_ pp.
98-131, **The Workers' revolution in Russia**, 1917, Daniel H. Kaiser (ed.),
p. 107] According to another historian, economic factors _"were soon to erode
the standing of the Bolsheviks among Petrograd workers . . . These
developments, in turn, led in short order to worker protests, which then
precipitated violent repressions against hostile workers. Such treatment
further intensified the disenchantment of significant segments of Petrograd
labour with Bolshevik-dominated Soviet rule."_ [Alexander Rabinowitch, **Early
Disenchantment with Bolshevik Rule**, p. 37]

The reasons for these protest movement were both political and economic. The
deepening economic crisis combined with protests against Bolshevik
authoritarianism to produce a wave of strikes aiming for political change.
Feeling that the soviets were distant and unresponsive to their needs (with
good reason, given Bolshevik postponement of soviet elections and
gerrymandering of the soviets), workers turned to direct action and the
initially Menshevik inspired _"Conference of Factory and Plant
Representatives"_ (also known as the _"Extraordinary Assembly of Delegates
from Petrograd Factories and Plants"_) to voice their concerns. At its peak,
reports _"estimated that out of 146,000 workers still in Petrograd, as many as
100,000 supported the conference's goals."_ [**Op. Cit.**, p. 127] The aim of
the Conference (as per Menshevik policy) was to reform the existing system
_"from within"_ and, as such, the Conference operated openly. As Alexander
Rabinowitch notes, _"[F]or the Soviet authorities in Petrograd, the rise of
the Extraordinary Assembly of Delegates from Petrograd Factories and Plants
was an ominous portent of worker defection."_ [**Op. Cit.**, p. 37]

The first wave of outrage and protests occurred after Bolshevik Red Guards
opened fire on a demonstration for the Constituent Assembly in early January
(killing 21, according to Bolshevik sources). This demonstration _"was notable
as the first time workers came out actively against the new regime. More
ominously, it was also the first time forces representing soviet power used
violence against workers."_ [David Mandel, **The Petrograd Workers and the
Soviet Seizure of Power**, p. 355] It would not be the last -- indeed
repression by the _"workers' state"_ of working class protest became a
recurring feature of Bolshevism.

By April _"it appeared that the government was now ready to go to whatever
extremes it deemed necessary (including sanctioning the arrest and even
shooting of workers) to quell labour unrest. This in turn led to intimidation,
apathy, lethargy and passivity of other workers. In these circumstances,
growth in support of the Assembly slowed down."_ [Rabinowitch, **Op. Cit.**,
p. 40] The Assembly aborted its plans for a May Day demonstration to protest
the government's policies were cancelled because of workers did not respond to
the appeals to demonstrate (in part because of _"Bolshevik threats against
'protesters'"_ [**Op. Cit.**, pp. 40-1]).

This apathy did not last long. After early May events _"served to reinvigorate
and temporarily radicalise the Assembly. These developments included yet
another drastic drop in food supplies, the shooting of protesting housewives
and workers in the Petrograd suburb of Kolpino, the arbitrary arrest and abuse
of workers in another Petrograd suburb, Sestroresk, the closure of newspapers
and the arrests of individuals who had denounced the Kolpino and Sestroresk
events, the intensification of labour unrest and conflict with the authorities
in the Obukhov plant and in other Petrograd factories and districts."_ [**Op.
Cit.**, p. 41]

So the next major protest wave occurred in early May, 1918, after armed guards
opened fire on protesting workers in Kolpino -- _"while the incident was
hardly the first of its kind, it triggered a massive wave of indignation."_
Work temporarily stopped in a number of plants. Between Kolpino and early
July, more than seventy incidents occurred in Petrograd, including strikes,
demonstrations and anti-Bolshevik meetings. Many of these meetings _"were
protests against some form of Bolshevik repression: shootings, incidents of
'terroristic activities,' and arrests."_ In some forty incidents _"worker's
protests focused on these issues, and the data is surely understate the actual
number by a wide margin. There were as well some eighteen separate strikes or
some other work stoppages with an explicitly anti-Bolshevik character."_
[Rosenberg, **Op. Cit.**, p. 123 and pp. 123-4] Then, _"[a]t the very end of
May and the beginning of June, when a wave of strikes to protest at bread
shortages broke out in the Nevskii district, a majority of Assembly delegates
. . . resolved to call on striking Nevskii district workers to return to work
and continue preparation for a general city-wide strike."_ [Rabinowitch, **Op.
Cit.**, p. 42] Unfortunately, for the Assembly postponing the strikes until a
_"better time"_ rather than encouraging them gave the authorities time to
prepare.

Things came to a head during and after the soviet elections in June. On June
20th the Obukhov works issued an appeal to the Conference of Factory and Plant
Representatives _"to declare a one-day strike of protest on June 25th"_
against Bolshevik reprisals for the assassination of a leading Bolshevik.
_"The Bolsheviks responded by 'invading' the whole Nevskii district with
troops and shutting down Obukhov completely. Meetings everywhere were
forbidden."_ The workers were not intimidated and _"[i]n scores of additional
factories and shops protests mounted and rapidly spread along the railroads."_
At the June 26th _"extraordinary session"_ of the Conference a general strike
was declared for July 2nd. Faced with this, the Bolsheviks set up _"machine
guns . . . at main points throughout the Petrograd and Moscow railroad
junctions, and elsewhere in both cities as well. Controls were tightened in
factories. Meetings were forcefully dispersed."_ [Rosenberg, **Op. Cit.**, pp.
126-7 and p. 127] In other words, _"as a result of extreme government
intimidation, the response to the Assembly's strike call on 2 July was
negligible."_ [Rabinowitch, **Op. Cit.**, p. 42] This repression was not
trivial:

> _"Among other things, all newspapers were forced to print on their front
pages Petrograd soviet resolutions condemning the Assembly as part of the
domestic and foreign counter-revolution. Factories participating in the strike
were warned that they would be shut down and individual strikers were
threatened with the loss of work -- threats that were subsequently made good.
Printing plants suspected of opposition sympathies were sealed, the offices of
hostile trade unions were raided, martial law declared on rail lines, and
armed strike-breaking patrols with authority to take whatever action was
necessary to prevent work stoppages were formed and put on 24-hour duty at key
points throughout Petrograd."_ [**Op. Cit.**, p. 45]

Needless to say, _"the Petrograd authorities drew on the dubious mandate
provided by the stacked soviet elections to justify banning the Extraordinary
Assembly."_ [**Op. Cit.**, p. 42] While the Bolsheviks had won around 50% of
workplace votes, as we note in [section 6](append41.html#app6) of the appendix
on ["What happened during the Russian Revolution?"](append41.html) they had
gerrymandered the soviet making the election results irrelevant. The fact the
civil war had started undoubtedly aided the Bolsheviks during this election
and the fact that the Mensheviks and SRs had campaigned on a platform to win
the soviet elections as the means of replacing soviet democracy by the
Constituent Assembly. Many workers still viewed the soviets are **their**
organisations and aimed for a functioning soviet system rather than its end.

The Bolsheviks turned on the Conference, both locally and nationally, and
arrested its leading activists, so decapitating the only independent working
class organisation left in Russia. As Rabinowitch argues, _"the Soviet
authorities were profoundly worried by the threat posed by the Assembly and
fully aware if their growing isolation from workers (their only real social
base) . . . Petrograd Bolsheviks developed a siege mentality and a
corresponding disposition to consider any action -- from suppression of the
opposition press and manipulation of elections to terror even against workers
-- to be justified in the struggle to retain power until the start of the
imminent world revolution."_ [**Op. Cit.**, pp. 43-4]

Similar events happened in other cities. As we discuss in [section
6](append41.html#app6) of the appendix on ["What happened during the Russian
Revolution?"](append41.html), the Bolsheviks had disbanded soviets elected
with non-Bolshevik majorities all across Russia and suppressed the resulting
working class protest. In Moscow, workers also organised a _"Conference"_
movement and _"[r]esentment against the Bolsheviks was expressed through
strikes and disturbances, which the authorities treated as arising from supply
difficulties, from 'lack of consciousness,' and because of the 'criminal
demagogy' of certain elements. Lack of support for current Bolshevik practices
was treated as the absence of worker consciousness altogether, but the causes
of the unrest was more complicated. In 1917 political issues gradually came to
be perceived through the lens of party affiliation, but by mid-1918 party
consciousness was reversed and a general consciousness of workers' needs
restored. By July 1918 the protest movement had lost its momentum in the face
of severe repression and was engulfed by the civil war."_ In the light of the
fate of workers' protest, the May 16th resolution by the Bogatyr' Chemical
Plant calling (among other things) for _"freedom of speech and meeting, and an
end to the shooting of citizens and workers"_ seems to the point.
Unsurprisingly, _"[f]aced with political opposition within the soviets and
worker dissatisfaction in the factories Bolshevik power increasingly came to
reply on the party apparatus itself."_ [Richard Sakwa, _"The Commune State in
Moscow in 1918,"_ pp. 429-449, **Slavic Review**, vol. 46, no. 3/4, p. 442-3,
p. 442 and p. 443]

Repression occurred elsewhere: _"In June 1918 workers in Tula protested a cut
in rations by boycotting the local soviet. The regime declared martial law and
arrested the protestors. Strikes followed and were suppressed by violence. In
Sormovo, when a Menshevik-Social Revolutionary newspaper was closed, 5,000
workers went on strike. Again firearms were used to break the strike."_ Other
techniques were used to break resistance. For example, the regime often
threatened rebellious factories with a lock out, which involved numerous
layouts, new rules of discipline, purges of workers' organisations and the
introduction of piece work. [Thomas F. Remington, **Building Socialism in
Bolshevik Russia**, p. 105 and p. 107]

Rather than the Civil War disrupting the relationship between the vanguard
party and the class it claimed to lead, it was in fact the Bolsheviks who did
so in face of rising working class dissent and disillusionment in the spring
of 1918. In fact, _"after the initial weeks of 'triumph' . . . Bolshevik
labour relations after October"_ changed and _"soon lead to open conflict,
repression, and the consolidation of Bolshevik dictatorship over the
proletariat in place of proletarian dictatorship itself."_ [Rosenberg, **Op.
Cit.**, p. 117]

Given this, the outbreak of the civil war consolidated workers support for the
Bolsheviks and saved it from even more damaging workers' unrest. As Thomas F.
Remington puts it:

> _"At various times groups of workers rebelled against Bolshevik rule But for
the most part, forced to choose between 'their' regime and the unknown horrors
of a White dictatorship, most willingly defended the Bolshevik cause. The
effect of this dilemma may be seen in the periodic swings in the workers'
political temper. When Soviet rule stood in peril, the war simulated a spirit
of solidarity and spared the regime the defection of its proletarian base.
During lulls in the fighting, strikes and demonstrations broke out."_ [**Op.
Cit.**, p. 101]

Which, as we will discuss, explains the increased repression in 1921 and
onwards. Without the Whites, the Bolsheviks had to enforce their rule directly
onto workers who did not want it. Ironically, the Whites **helped** the
Bolsheviks remain in power. Without the start of the civil war, labour protest
would have either ended Bolshevik rule or exposed it as a dictatorial regime.

This process of workers protest and state repression continued in 1919 and
subsequent years. It followed a cyclical pattern. There was a _"new outbreak
of strikes in March 1919 after the collapse of Germany and the Bolshevik re-
conquest of the Ukraine. The pattern of repression was also repeated. A strike
at a galosh factory in early 1919 was followed by the closing of the factory,
the firing of a number of workers, and the supervised re-election of its
factory committee. The Soviet garrison at Astrakhan mutinied after its bread
ration was cut. A strike among the city's workers followed in support. A
meeting of 10,000 Astrakhan workers was suddenly surrounded by loyal troops,
who fired on the crowd with machine guns and hand grenades, killing 2,000.
Another 2,000, taken prisoner, were subsequently executed. In Tula, when
strikes at the defence factories stopped production for five days, the
government responded by distributing more grain and arresting the strike
organisers . . . strikes at Putilov again broke out, at first related to the
food crisis . . . The government treated the strike as an act of counter-
revolution and responded with a substantial political purge and re-
organisation. An official investigation . . . concluded that many shop
committees were led by [Left] Social Revolutionaries . . . These committees
were abolished and management representatives were appointed in their stead."_
[Remington, **Op. Cit.**, pp. 109-10]

The strikes in Petrograd centred around the Putilov shows the response of the
authorities to the _"atomised"_ workers who were taking collective action.
_"In March fifteen factories struck together (roughly 35,000 workers were
involved) . . . workers at Putilov assembled and sent a delegation to the
works committee . . .and put forward a number of demands . . . On 12 March
Putilov stopped work. Its workers called to others to join them, and some of
them came out in a demonstration where they were fired upon by Cheka troops.
Strikes then broke out at fourteen other enterprises . . . On Sunday 16 March
an appeal was made to the Putilovtsy to return to normal working the following
day or . . . the sailors and soldiers would be brought in. After a poor
showing on the Monday, the sailor went in, and 120 workers were arrested; the
sailors remained until the 21st and by the 22nd normal work had been
resumed."_ In July strikes broke out again in response to the cancellation of
holidays which involved 25,000 workers in 31 strikes. [Mary McAuley, **Bread
and Justice**, pp. 251-253 and p. 254]

In the Moscow area, while it is _"impossible to say what proportion of workers
were involved in the various disturbances,"_ following the lull after the
defeat of the workers' conference movement in mid-1918 _"each wave of unrest
was more powerful than the last, culminating in the mass movement from late
1920."_ For example, at the end of June 1919, _"a Moscow committee of defence
(KOM) was formed to deal with the rising tide of disturbances . . . KOM
concentrated emergency power in its hands, overriding the Moscow Soviet, and
demanding obedience from the population. The disturbances died down under the
pressure of repression."_ [Richard Sakwa, **Soviet Communists in Power**, p.
94 and pp. 94-5]

Vladimir Brovkin summarises the data he provides in his essay _"Workers'
Unrest and the Bolshevik Response in 1919"_ (reproduced along with data from
other years in his book **Behind the Front Lines of the Civil War**) as
follows:

> _"Data on one strike in one city may be dismissed as incidental. When,
however, evidence is available from various sources on simultaneous
independent strikes in different cities and overall picture begins to emerge .
. . Workers' unrest took place in Russia's biggest and most important
industrial centres: Moscow, Petrograd, Tver', Tula, Briansk, and Sormovo.
Strikes affected the largest industries . . . Workers' demands reflected their
grievances . . . The greatest diversity was in workers' explicitly political
demands or expression of political opinion . . . all workers' resolutions
demanded free and fair elections to the soviets . . . some workers . . .
demanded the Constituent Assembly . . . _

>

> _"The strikes of 1919 . . . fill an important gap in the development of the
popular movement between October 1917 and February 1921. On the one hand, they
should be seen as antecedents of similar strikes in February 1921, which
forced the Communists to abandon war communism. In the capitals, workers, just
as the Kronstadt sailors had, still wanted fairly elected soviets and not a
party dictatorship. On the other hand, the strikes continued the protests that
had began in the summer of 1918. The variety of behavioural patterns displayed
during the strikes points to a profound continuity. . . _

>

> _"In all known cases the Bolsheviks' initial response to strikes was to ban
public meetings and rallies . . . In several cities . . . the authorities
confiscated strikers' food rations in order to suppress the strike. In at
least five cities . . . the Bolsheviks occupied the striking plant and
dismissed the strikers en masse . . . In all known cases the Bolsheviks
arrested strikers . . . In Petrograd, Briansk, and Astrakhan' the Bolsheviks
executed striking workers."_ [**Slavic Review**, vol. 49, no. 3, pp. 370-2]

Nor was this collective struggle stop in 1919 -- _"strike action remained
endemic in the first nine months of 1920"_ and _"in the first six months of
1920 strikes had occurred in seventy-seven per cent of middle-sized and large
works."_ For the Petrograd province, soviet figures state that in 1919 there
were 52 strikes with 65,625 participants and in 1920 73 strikes with 85,645,
both high figures as according to one set of figures, which are by no means
the lowest, there were 109,100 workers there. _"Strikes in 1920,"_ recounts
Aves, _"were frequently a direct protest against the intensification of War
Communist labour policies, the militarisation of labour, the implementation of
one-man management and the struggle against absenteeism, as well as food
supply difficulties. The Communist Party press carried numerous articles
attacking the slogan of 'free labour.'"_ [J. Aves, **Workers Against Lenin**,
p. 69 and p. 74]

The spring of 1920 _"saw discontent on the railways all over the country."_
This continued throughout the year. For example, the Aleksansrovskii
locomotive works at the end of August, workers sent three representatives to
the works commissar who had them arrested. Three days later, the workers
stopped work and demanded their release. The authorities locked the workers
out of the works and a guard of 70 sailors were placed outside the enterprise.
The Cheka arrested the workers' soviet delegates (who were from the SR
(Minority) list) as well as thirty workers. _"The opportunity was taken to
carry out a general round-up"_ and arrests were made at other works. After the
arrests, _"a meeting was held to elect new soviet delegates but the workers
refused to co-operate and a further 150 were arrested and exiled to Murmansk
or transferred to other workshops."_ [Aves, **Op. Cit.**, p. 44 and pp. 46-7]

Strikes occurred in other places, such as Tula were the workforce _"contained
a high proportion of skilled, long-standing, hereditary workers."_ The _"all-
out strike"_ started at the start of June and on 8 June the local newspaper
published a declaration from the Tula soviet threatening the strikers with
_"the most repressive measures, including the application of the highest
measure of punishment"_ (i.e. executions). The following day the city was
declared to be under a _"state of siege"_ by the local military authorities.
The strikers lost ration cards and by 11 June there had been a return to work.
Twenty-three workers were sentenced to a forced labour camp until the end of
the war. However, the _"combined impact of these measures did not prevent
further unrest and the workers put forward new demands."_ On 19 June, the
soviet approved _"a programme for the suppression of counter-revolution"_ and
_"the transfer of Tula to the position of an armed camp."_ The Tula strike
_"highlights the way in which workers, particularly skilled workers who were
products of long-standing shop-floor subcultures and hierarchies, retained the
capability as well as the will to defend their interests."_ [Aves, **Op.
Cit.**, p. 50-55]

While strike activity _"was most common in Petrograd, where there had been 2.5
strikers for every workman,"_ the figure for Moscow was 1.75 and 1.5 in Kazan.
In early March _"a wave of strikes hit the Volga town of Samara"_ when a
strike by printers in spread to other enterprises. _"Strike action in Moscow
did not just include traditionally militant male metal workers."_ Textile
workers, tram workers and printers all took strike action. [Aves, **Op.
Cit.**, p. 69, p. 72 and pp. 77-8]

Thus strike action was a constant feature of civil war Bolshevik Russia.
Rather than being an _"atomised"_ mass, the workers repeatedly organised
themselves, made their demands and took collective action to achieve them. In
response, the Bolshevik regime used state repression to break this collective
activity. As such, **if** the rise of Stalinism can, as modern-day Leninists
argue, be explained by the _"atomisation"_ of the working class during the
civil war then the Bolshevik regime and its repression should be credited with
ensuring this happened.

The end of the civil war did not see the end of working class protest. Quite
the reverse. In February and March 1921 _"industrial unrest broke out in a
nation-wide wave of discontent . . . General strikes, or very widespread
unrest, hit Petrograd, Moscow, Saratov and Ekaterinoslavl."_ Only one major
industrial region was unaffected. As noted above, the Bolsheviks refused to
call this movement a strike wave, preferring the term **volynka** (which means
"go-slow"), yet _"the continued use of the term can be justified not to hide
its significance but to show that workers' protest consisted not just of
strikes but also of factory occupations, 'Italian strikes,' demonstrations,
mass meetings, the beating up of communists and so on."_ [Aves, **Op. Cit.**,
p. 109 and p. 112]

In Petrograd in the beginning of February _"strikes were becoming an everyday
occurrence"_ and by _"the third week of February the situation rapidly
deteriorated."_ The city was rocked by strikes, meetings and demonstrations.
In response to the general strike the Bolsheviks replied with a _"military
clamp-down, mass arrests and other coercive measures, such as the closure of
enterprises, the purging of the workforce and stopping of rations which
accompanied them."_ As we discuss in ["What was the Kronstadt
Rebellion?"](append42.html), these strikes produced the Kronstadt revolt (and,
as noted in [section 10](append42.html#app10) of that appendix, the Bolshevik
repression ensured the Petrograd workers did not act with the sailors). [Aves,
**Op. Cit.**, p. 113, p. 120]

A similar process of workers revolt and state repression occurred in Moscow at
the same time. There _"industrial unrest"_ also _"turned into open
confrontation and protest spilled on to the streets."_ Meetings were held,
followed by demonstrations and strikes. Over the next few days strikes spread
to other districts. Workers demanded now elections to the soviets be held.
Striking railway workers sent emissaries along the railway to spread the
strike and strikes spread to outside Moscow city itself and into the
surrounding provinces. Unsurprisingly, Moscow and Moscow province were put
under martial law and SR and menshevik leaders were arrested. [Aves, **Op.
Cit.**, p. 130 pp. 139-144] However, _"military units called in"_ against
striking workers _"refused to open fire, and they were replaced by the armed
communist detachments"_ who did. _"The following day several factories went on
strike"_ and troops _"disarmed and locked in as a precaution"_ by the
government against possible fraternising. On February 23rd, _"Moscow was
placed under martial law with a 24-hour watch on factories by the communist
detachments and trustworthy army units."_ [Richard Sakwa, **Soviet Communists
in Power**, p. 94 and pp. 94-5 and p. 245] The mixture of (economic)
concessions and coercion broke the will of the strikers.

Strikes and protests occurred all across Russia at this time (see Aves, **Op.
Cit.**). In Saratov, the strike started on March 3 when railroad shop workers
did not return to their benches and instead rallied to discuss an anticipated
further reduction in food rations. _"Led by a former Communist, the railroad
workers debated resolutions recently carried by the Moscow proletariat . . .
The next day the strike spread to the metallurgical plants and to most other
large factories, as Saratov workers elected representatives to an independent
commission charged with evaluating the functioning of all economic organs.
When it convened, the body called for the re-election of the soviets and
immediate release of political prisoners."_ The ration cut _"represent[ed] the
catalyst, but not the cause, of the labour unrest."_ While _"the turmoil
touched all strata of the proletariat, male and female alike, the initiative
for the disturbances came from the skilled stratum that the Communists
normally deemed the most conscious."_ The Communists shut down the commission
and they _"expected workers to protest the dissolution of their elected
representatives"_ and so they _"set up a Provincial Revolutionary Committee .
. . which introduced martial law both in the city and the garrison. It
arrested the ringleaders of the workers' movement . . . the police crackdown
depressed the workers' movement and the activities of the rival socialist
parties."_ The Cheka sentenced 219 people to death. [Donald J. Raleigh,
**Experiencing Russia's Civil War**, p. 379, p. 387, p. 388, pp. 388-9]

A similar _"little Kronstadt"_ broke out in the Ukrainian town of
Ekaterinoslavl at the end of May. The workers there _"clearly had strong
traditions of organisation"_ and elected a strike committee of fifteen which
_"put out a series of political ultimatums that were very similar in content
to the demands of the Kronstadt rebels."_ On 1 June, _"by a pre-arranged
signal"_ workers went on strike throughout the town, with workers joining a
meeting of the railway workers. The local Communist Party leader was
instructed _"to put down the rebellion without mercy . . . Use Budennyi's
cavalry."_ The strikers prepared a train and its driver instructed to spread
the strike throughout the network. Telegraph operators were told to send
messages throughout the Soviet Republic calling for _"free soviets"_ and soon
an area up to fifty miles around the town was affected. The Communists used
the Cheka to crush the movement, carrying out mass arrests and shooting 15
workers (and dumping their bodies in the River Dnepr). [Aves, **Op. Cit.**,
pp. 171-3]

So faced with an _"atomised"_ working class during the period of 1918 and
1921, the Bolsheviks had to respond with martial law, mass arrests and
shootings:

> _"It is not possible to estimate with any degree of accuracy how many
workers were shot by the Cheka during 1918-1921 for participation in labour
protest. However, an examination of individual cases suggests that shootings
were employed to inspire terror and were not simply used in the occasional
extreme case."_ [Aves, **Op. Cit.**, p. 35]

Post-Kronstadt, similar Bolshevik responses to labour unrest continued. The
economic crisis of 1921 which accompanied the introduction of the NEP saw
unemployment rise yet _"[d]espite the heavy toll of redundancies, the ability
to organise strikes did not disappear. Strike statistics for 1921 continue to
provide only a very rough indicator of the true scale of industrial unrest and
appear not to include the first half of the year."_ The spring of 1922 saw
Soviet Russia _"hit by a new strike wave"_ and the strikes _"continued to
reflect enterprise traditions."_ That year saw 538 strikes with 197,022
participants recorded. [Aves, **Op. Cit.**, p. 183 and p. 184]

The following year saw more strikes: _"In July 1923 more than 100 enterprises
employing a total of some 50,000 people were on strike. In August figures
totalled some 140 enterprises and 80,00 workers. In September and November the
strike wave continued unabated."_ As in the civil war, the managers shut down
plants, fired the workers and rehired them on an individual basis. In this
way, trouble-makers were dismissed and _"order"_ restored. _"The pattern of
workers' action and Bolshevik reaction played itself out frequently in dozens
of other strikes. The Bolsheviks acted with the explicit purpose of rooting
out the possibility of further protest. They tried to condition workers that
labour protest was futile."_ The GPU _"used force to disperse workers
demonstrating with the arrested strike leaders."_ [Vladimir Brovkin, **Russia
After Lenin**, p. 174, pp. 174-5 and p. 175]

In Moscow, for example, _"[b]etween 1921 and 1926, all branches of industry
and transport . . . experienced wildcat strikes or other spontaneous labour
disturbances. Strike waves peaked in the winter of 1920-21 . . . and in the
summer and fall of 1922 and 1923 . . . during July-December 1922, for example,
65 strikes and 209 other industrial disturbances were recorded in Moscow's
state enterprises."_ Metalworkers were arguably the most active sector at this
time while _"a number of large strikes"_ took place in the textile industry
(where _"strikes were sometimes co-ordinated by spontaneously organised strike
committees or 'parallel' factory committees"_). And in spite of repression,
_"politicisation continued to characterise many labour struggles"_ and, as
before, _"spontaneous labour activism hindered not only the party's economic
program but also the political and social stabilisation of the factories."_
[John B. Hatch, **Labour Conflict in Moscow, 1921-1925**, p. 62, p. 63, p. 65,
pp. 66-7 and p. 67]

Given this collective rebellion all across the industrial centres of Russia
throughout the Civil War and after, it hard to take seriously claims that
Bolshevik authoritarian was the product of an _"atomisation"_ or
_"declassing"_ of the working class or that it had ceased to exist in any
meaningful sense. Clearly it had and was capable of collective action and
organisation -- until it was repressed by the Bolsheviks and even then it keep
returning. This implies that a key factor in rise of Bolshevik authoritarian
was political -- the simple fact that the workers would not vote Bolshevik in
free soviet and union elections and so they were not allowed to. As one Soviet
Historian put it, _"taking the account of the mood of the workers, the demand
for free elections to the soviets [raised in early 1921] meant the
implementation in practice of the infamous slogan of soviets without
communists,"_ although there is little evidence that the strikers actually
raised that _"infamous"_ slogan. [quoted by Aves, **Op. Cit.**, p. 123] It
should also be noted that Bolshevik orthodoxy at the time stressed the
necessity of Party dictatorship **over** the workers (see [section
H.1.2](secH1.html#sech12) for details).

Nor can it be said that this struggle can be blamed on _"declassed"_ elements
within the working class itself. In her study of this question, Diane Koenker
notes that 90% of the change in the number of workers in Moscow _"is accounted
for by men. Working women did not leave the city,"_ their numbers dropping
from 90,000 in 1918 to 80,000 in 1920. Why these 80,000 women workers should
be denied a say in their own revolution is not clear, given the arguments of
the pro-Bolshevik left. After all, the same workers remained in roughly the
same numbers. Looking at the male worker population, their numbers fell from
215,000 to 124,000 during the same period. However, _"the skilled workers
whose class consciousness and revolutionary zeal had helped win the October
revolution did not entirely disappear, and the women who remained were likely
to be family members of these veterans of 1917."_ It was _"the loss of young
activists rather than all skilled and class conscious urban workers that
caused the level of Bolshevik support to decline during the civil war."_
Indeed _"the workers who remained in the city were among the most urbanised
elements."_ In summary, _"the deurbanisation of those years represented a
change in quantity but not entirely in quality in the cities. The proletariat
declined in the city, but it did not wither away . . . a core of the city's
working class remained."_ [**Op. Cit.**, p. 440, p. 442, p. 447 and p. 449]

As Russian anarchist Ida Mett argued decades before in relation to the strikes
in early 1921:

> _"The population was drifting away from the capital. All who had relatives
in the country had rejoined them. The authentic proletariat remained till the
end, having the most slender connections with the countryside. _

>

> _"This fact must be emphasised, in order to nail the official lies seeking
to attribute the Petrograd strikes that were soon to break out to peasant
elements, 'insufficiently steeled in proletarian ideas.' The real situation
was the very opposite. A few workers were seeking refuge in the countryside.
The bulk remained. There was certainly no exodus of peasants into the starving
towns! . . . It was the famous Petrograd proletariat, the proletariat which
had played such a leading role in both previous revolutions, that was finally
to resort to the classical weapon of the class struggle: the strike."_ [**The
Kronstadt Uprising**, p. 36]

In terms of struggle, links between the events in 1917 and those during the
civil war also exist. For example Jonathan Aves writes that there were
_"distinct elements of continuity between the industrial unrest in 1920 and
1917. This is not surprising since the form of industrial unrest in 1920, as
in the pre-revolutionary period and in 1917, was closely bound up with
enterprise traditions and shop-floor sub-cultures. The size of the Russian
industrial workforce had declined steeply during the Civil War but where
enterprises stayed open . . . their traditions of industrial unrest in 1920
shows that such sub-cultures were still capable of providing the leaders and
shared values on which resistance to labour policies based on coercion and
Communist Party enthusiasm could be organised. As might be anticipated, the
leaders of unrest were often to be found amongst the skilled male workers who
enjoyed positions of authority in the informal shop-floor hierarchies."_
Moreover, _"despite intense repression, small groups of politicised activists
were also important in initiating protest and some enterprises developed
traditions of opposition to the communists."_ [**Op. Cit.**, p. 39]

Looking at the strike wave of early 1921 in Petrograd, the _"strongest reason
for accepting the idea that it was established workers who were behind the
**volynka** [i.e. the strike wave] is the form and course of protest.
Traditions of protest reaching back through the spring of 1918 to 1917 and
beyond were an important factor in the organisation of the **volynka.** . . .
There was also a degree of organisation . . . which belies the impression of a
spontaneous outburst."_ [Aves, **Op. Cit.**, p. 126]

Clearly, then, the idea that the Russian working class was atomised or
declassed cannot be defended given this series of struggles and state
repression. In fact, as noted, the notion that the workers were _"declassed"_
was used to justify state repression of collective working class struggle.
_"The thought oppressed me,"_ wrote Emma Goldman, _"that what [the Bolsheviks]
called 'defence of the Revolution' was really only the defence of [their]
party in power."_ [**My Disillusionment in Russia**, p. 57] She was right --
the class struggle in Bolshevik Russia did not stop, it continued except the
ruling class had changed from bourgeoisie to Bolshevik dictatorship.

Faced with this collective resistance to Bolshevism, the Leninist could argue
that while the working class was capable of collective decision making and
action, the nature of that action was suspect. This arguments rests on the
premise that the _"advanced"_ workers (i.e. party members) left the workplace
for the front or for government posts, leaving the _"backward"_ workers
behind. This argument is often used, particularly in regard to the Kronstadt
revolt of 1921 (see [section 8](append42.html#app8) of the appendix on ["What
was the Kronstadt Rebellion?"](append42.html)).

Of course, this argument raises more problems that its solves. In **any**
revolution the _"most politically consciousness"_ tend to volunteer to go to
the front first and, of course, tend to be elected as delegates to committees
of various kinds (local, regional and national). There is little that can be
done about it. Needless to say, if _"soviet democracy"_ depends on the
_"advanced"_ workers being there in order for it to work, then it suggests
that the commitment to democracy is lacking in those who argue along these
lines. It suggests that if the _"backward"_ masses reject the _"advanced"_
ones then the latter have the right, even the duty, to impose their will on
the former. And it also begs the question of who determines what constitutes
_"backward"_ \-- if it means _"does not support the party"_ then it becomes
little more than a rationale for party dictatorship (as it did under Lenin and
Trotsky).

Writing in 1938, Trotsky inadvertently exposes the logic of this position.
Asserting that a _"revolution is 'made' directly by a **minority**,"_ he
argued that the _"success"_ of a revolution is _"possible"_ when _"this
minority finds more or less support, or at least friendly neutrality, on the
part of the majority."_ So what happens if the majority expresses opposition
to the party? Unfortunately Trotsky does not raise this question, but he does
answer it indirectly. As we discuss in [section 15](append42.html#app15) of
the appendix on ["What was the Kronstadt Rebellion?"](append42.html%22),
Trotsky argues that _"to free the soviets from the leadership [sic!] of the
Bolsheviks would have meant within a short time to demolish the soviets
themselves. The experience of the Russian soviets during the period of
Menshevik and SR domination and, even more clearly, the experience of the
German and Austrian soviets under the domination of the Social Democrats,
proved this. Social Revolutionary-anarchist soviets could only serve as a
bridge from the proletarian dictatorship. They could play no other role,
regardless of the 'ideas' of their participants."_ [Lenin and Trotsky,
**Kronstadt**, p. 85 and p. 90]

Thus to let the working masses (the _"majority"_) have free soviet elections
and reject the vanguard (the _"minority"_) would mean the end of soviet power.
Thus allowing the proletariat a say in progress of the revolution means the
end of the _"proletarian dictatorship"_! Which, of course, is interesting
logic. The authoritarian core of the Bolshevik vision of revolution is thus
exposed.

Victor Serge also presents an insight into the Bolshevik perspective on the
revolution. He states that _"[a]gitation conducted by the SRs and Mensheviks
called demonstrations in the streets and prepared for a general strike. The
demands were: free trade, wage increases, payment of wages one, two or three
months in advance and 'democracy.' The intention was to incite the working
class itself against the revolution."_ Which only makes sense once you realise
that by _"the revolution"_ Serge simply meant _"the Bolsheviks"_ and the
obvious truth that the working class was **not** managing the revolution at
all, was **not,** in any sense, "in power." _"The best elements among the
workers,"_ explains Serge, _"were away fighting; those in the factories were
precisely the less energetic, less revolutionary sections, along with the
petty folk, yesterday's small shopkeepers and artisans, who had come there to
find refuge. This proletariat of the reserve often allowed itself to fall
under the sway of Menshevik propaganda."_ [**Year One of the Russian
Revolution**, p. 229]

Given that Serge is discussing the period **before** the Czechoslovak revolt,
a greater indictment of Bolshevism cannot be found. After all, what does
_"workers' democracy"_ mean unless the proletariat can vote for its own
delegates? Little wonder Daniel Guerin described Serge's book as _"largely a
justification of the liquidation of the soviets by Bolshevism."_
[**Anarchism**, p. 97] After all, what point is there having genuine soviet
elections if the _"less revolutionary sections"_ (i.e. Trotsky's _"majority"_)
will not vote for the vanguard? And can socialism exist without democracy? Can
we expect an unaccountable vanguard to govern in the interests of anyone but
its own? Of course not!

Thus the Bolsheviks did not solve the answer the questions Malatesta raised in
1891, namely _"if you consider these worthy electors as unable to look after
their own interests themselves, how is it that they will know how to choose
for themselves the shepherds who must guide them? And how will they be able to
solve this problem of social alchemy, of producing the election of a genius
from the votes of a mass of fools?"_ [**Anarchy**, p. 53]

Given this, is it surprising that the Bolsheviks revised the Marxist theory of
the state to justify elite rule? As discussed in [section
H.3.8](secH3.html#sech38), once in power Lenin and Trotsky stressed that the
"workers' state" had to be independent of the working class in order to
overcome the _"wavering"_ and _"vacillation of the masses themselves."_ Or, to
quote Serge, the _"party of the proletariat must know, at hours of decision,
how to break the resistance of the backward elements among the masses; it must
know how to stand firm sometimes against the masses . . . it must know how to
go against the current, and cause proletarian consciousness to prevail against
lack of consciousness and against alien class influences."_ [**Op. Cit.**, p.
218] Of course, by definition, **every** group is _"backward"_ compared to the
vanguard and so Serge's argument amounts to little more than a justification
for party dictatorship **over** the proletariat.

The reason why such a system would not result in socialism does not take long
to discover. For anarchists, freedom is not just a goal, a noble end to be
achieved, but rather a necessary part of the process of creating socialism.
Eliminate freedom (and, as a necessary result, workplace and community self-
management) and the end result will be anything **but** socialism. Ultimately,
as Malatesta argued, _"the only way that the masses can raise themselves"_ is
by freedom _"for it is only through freedom that one educates oneself to be
free."_ [**Op. Cit.**, p. 52] Ironically, by using state repression to combat
_"backward"_ elements, the Bolsheviks ensured that they stayed that way and,
more importantly, disempowered the **whole** working class so ensuring that
Bolshevik dictatorship came into constant conflict with it and its continuing
struggle for autonomy. Rather than base itself on the creative powers of the
masses, Bolshevism crushed it as a threat to its power and so ensured that the
economic and social problems affecting Russia increased.

And need it be pointed out that _"low"_ culture and/or _"backward"_ social
life have been used by numerous imperialist and authoritarian states to
justify their rule over a given population? It matters little whether the
population are of the same nationality of the rulers or from a subjugated
people, the arguments and the logic are the same. Whether dressed up in racist
or classist clothing, the same elitist pedigree lies behind the pro-Bolshevik
argument that democracy would have brought _"chaos"_ or _"capitalist
restoration."_ The implicit assumption that working class people are not fit
for self-government is clear from these rationales. Equally obvious is the
idea that the party knows better than working class people what is best for
them.

Sounding like Bolshevik Henry Kissingers, the Leninists argue that Lenin and
Trotsky had to enforce their dictatorship **over** the proletariat to stop a
_"capitalist restoration"_ (Kissinger was the US state's liaison with the
Chilean military when it helped their coup in 1973 and infamously stated that
the country should not be allowed to turn communist due to the stupidity of
its own people). Needless to say, anarchists argue that even if the Bolshevik
regime had not already need capitalist (specifically, **state** capitalist)
this logic simply represents an elitist position based on _"socialism from
above."_ Yes, soviet democracy **may** have resulted in the return of
(private) capitalism but by maintaining party dictatorship the possibility of
socialism was automatically nullified. Simply put, the pro-Leninist argument
implies that socialism can be implemented from above as long as the right
people are in power. The authoritarian core of Leninism is exposed by these
arguments and the repression of working class revolt which they justified.

Given this, it seems incredulous for Leninists like Chris Harman to argue that
it was the _"decimation of the working class"_ which caused (by _"necessity"_)
the _"Soviet institutions"_ to take _"on a life independently of the class
they had arisen from. Those workers and peasants who fought the Civil War
could not govern themselves collectively from their places in the factories."_
[**How the revolution was lost**] Given that this _"independent"_ life is
required to allow the party to _"go against the current,"_ Harman simply fails
to understand the dynamics of the revolution, the position of the vanguard and
the resistance of the working class subject to it. Moreover, the reason
**why** the _"workers and peasants"_ could not govern themselves collectively
was because the party had seized power for itself and systematically destroyed
soviet, workplace and military democracy to remain there. Then there is the
way the Bolsheviks reacted to such collective unrest. Simply put, they sought
to break the workers as a collective force. The use of lockouts, re-
registration was typical, as was the arresting of _"ringleaders."_ It seems
ironic, therefore, to blame _"objective factors"_ for the _"atomisation"_ of
the working class when, in fact, this was a key aim of Bolshevik repression of
labour protest.

Little wonder, then, that the role of the masses in the Russian Revolution
after October 1917 is rarely discussed by pro-Bolshevik writers. Indeed, the
conclusion to be reached is simply that their role is to support the party,
get it into power and then do what it tells them. Unfortunately for the
Bolsheviks, the Russian working class refused to do this. Instead they
practised collective struggle in defence of their economic **and** political
interests, struggle which inevitably brought them into conflict both with the
"workers' state" and their role in Bolshevik ideology. Faced with this
collective action, the Bolshevik leaders (starting with Lenin) started to talk
about the _"declassing"_ of the proletariat to justify their repression of
(and power **over**) the working class. Ironically, it was the aim of
Bolshevik repression to _"atomise"_ the working class as, fundamentally, their
rule depended on it. While Bolshevik repression did, in the end, win out it
cannot be said that the working class in Russia did not resist the usurpation
of power by the Bolshevik party. As such, rather than _"atomisation"_ or
_"declassing"_ being the cause for Bolshevik power and repression, it was, in
fact, one of **results** of them.



## 6 Did the Bolsheviks blame _"objective factors"_ for their actions?

In a word, no. At the time of the revolution and for some period afterwards,
the idea that _"objective factors"_ were responsible for their policies was
one which few, if any, Bolshevik leaders expressed. As we discussed in
[section 2](append43.html#app2), Bolsheviks like Lenin, Trotsky and Bukharin
argued that **any** revolution would face civil war and economic crisis. Lenin
**did** talk about the _"declassing"_ of the proletariat from 1920 onwards,
but that did not seem to affect the proletarian and socialist character of his
regime (as we noted in [section 5](append43.html#app5), Lenin's argument was
developed in the context of **increasing** working class collective action,
**not** its absence).

This is not to say that the Bolshevik leaders were 100% happy with the state
of their revolution. Lenin, for example, expressed concern about the rising
bureaucratic deformations he saw in the soviet state (particularly after the
end of the civil war). Yet Lenin, while concerned about the bureaucracy, was
not concerned about the Party's monopoly of power. Unsurprisingly, he fought
the bureaucracy by "top-down" and, ironically, bureaucratic methods, the only
ones left to him. A similar position was held by Trotsky, who was quite
explicit in supporting the party dictatorship throughout the 1920s (and,
indeed, the 1930s). Needless to say, both failed to understand how bureaucracy
arises and how it could be effectively fought.

This position started to change, however, as the 1920s drew on and Trotsky was
increasingly sidelined from power. Then, faced with the rise of Stalinism,
Trotsky had to find a theory which allowed him to explain the degeneration of
the revolution and, at the same time, absolve Bolshevik ideology (and his own
actions and ideas!) from all responsibility for it. He did so by invoking the
objective factors facing the revolution. Since then, his various followers
have utilised this argument, with various changes in emphasis, to attack
Stalinism while defending Bolshevism.

The problem with this type of argument is that all the major evils usually
associated with Stalinism already existed under Lenin and Trotsky. Party
dictatorship, one-man management, repression of opposition groups and working
class protest, state bureaucracy and so on all existed before Stalin
manoeuvred himself into absolute power. And with the exception of state
bureaucracy, none of the mainstream Bolshevik leaders found anything to
complain about. Indeed, the reverse. Whether it is Lenin or Trotsky, the sad
fact of the matter is that a party dictatorship presiding over an essentially
state capitalism economy was not considered a bad thing. Which, of course,
causes problems for those who seek to distance Lenin and Trotsky from
Stalinism and claim that Bolshevism is fundamentally _"democratic"_ in nature.

The knots Leninists get into to do this can be ludicrous. A particularly crazy
example of this can be seen from the UK's Socialist Workers' Party. For John
Rees, it is a truism that _"it was overwhelmingly the force of circumstance
which obliged the Bolsheviks to retreat so far from their own goals. They
travelled this route in opposition to their own theory, not because of it --
no matter what rhetorical justifications were given at the time."_ [_"In
Defence of October,"_ pp. 3-82, **International Socialism**, no. 52, p. 70]

However, this sort of position has little substance to it. It is both
logically and factually flawed. Logically, it simply makes little sense as
anything but an attempt to narrow political discussion and whitewash Bolshevik
practice and politics. Rees, in effect, is saying that not only are we **not**
to judge the Bolsheviks by their actions, we must also discount what they said
-- unless it was something modern day Leninists approve of! Given that
Leninists constantly quote from Lenin's (and Trotsky's) post-1918 works, it
seems strange that they try to stop others so doing! Strange, but not
surprising, given their task is to perpetuate the Bolshevik Myth. Where that
leaves revolutionary politics is left unsaid, but it seems to involve
worshipping at the shrine of October and treating as a heretic anyone who
dares suggest we analysis it in any depth and perhaps learn lessons from it
and the Bolshevism that dominated it.

Of course Rees' comments are little more than assertions. Given that he
dismisses the idea that we can actually take what any Bolshevik says at face
value, we are left with little more than a mind reading operation in trying to
find out what the likes of Lenin and Trotsky _"really"_ thought. Perhaps the
root explanation of Rees' position is the awkward fact that there are no
quotes from any of the leading Bolsheviks which support it? After all, if they
were quotes from the hallowed texts expounding the position Rees says the
Bolshevik leaders _"really"_ held then he would have provided them. The simple
fact is that Lenin and Trotsky, like all the Bolshevik leaders, considered a
one-party dictatorship ruling over a state capitalist economy as some form of
_"socialism."_ That was certainly Trotsky's position and he was **not** shy in
expressing. But, of course, we can dismiss this simply as _"rhetorical
justifications"_ rather than an expression of _"their own theory"_! We will
never know, as they never expressed _"their own theory"_ and instead made do
with the _"rhetorical justifications"_ Rees is at such pains for us to ignore!

Which shows that a major problem in discussing the failure of the Russian
Revolution is the attitude of modern day Leninists. Rees presents us with
another example when he asserts that _"what is required of historians,
particularly Marxists, is to separate phrase from substance."_ The Bolsheviks,
Rees argues, were _"inclined to make a virtue of necessity, to claim that the
harsh measures of the civil war were the epitome of socialism."_ Thus the
Bolsheviks cannot be blamed either for what they did or what they said.
Indeed, he states that non-Leninists _"take Lenin or Trotsky's shouts of
command in the midst of battle and portray them as considered analyses of
events."_ [**Op. Cit.**, p. 46]

This argument is simply incredulous. After all, neither Lenin nor Trotsky
could be said to be anything **but** political activists who took the time to
consider events and analyse them in detail. Moreover, they defended their
arguments in terms of Marxism. Would Rees consider Lenin's **State and
Revolution** as an unimportant work? After all, this was produced in the midst
of the events of 1917, in often difficult circumstances. If so, then why not
his other, less appealing, political proclamations (never mind actions)?
Moreover, looking at some of the works produced in this period it is clear
that they are anything **but** _"shouts of command in the midst of battle."_
Trotsky's **Terrorism and Communism** is a substantial book, for example It
was not an ad hoc comment made during a conference or _"in the midst of
battle."_ Quite the reverse, it was a detailed, substantial and thought-out
reply to the criticism by the influential German social democrat Karl Kaustky
(and, before Lenin, the most internationally respected Marxist thinker).
Indeed, Trotsky explicitly asks the question _"[i]s there still theoretical
necessity to justify revolutionary terrorism?"_ and answers yes, his _"book
must serve the ends of an irreconcilable struggle against the cowardice, half-
measures, and hypocrisy of Kautskianism in all countries."_ [**Terrorism and
Communism**, p. 9 and p. 10]

Therefore, on the face of it, Rees's comments are hard to take seriously. It
is even harder to take when it becomes clear that Rees does not apply his
comments consistently or logically. He does not object to quoting Lenin and
Trotsky during this period when they say something he **approves** of,
regardless of how well it fits into their actions. It would be no exaggeration
to say that his _"argument"_ is simply an attempt to narrow the area of
debate, marking off limits any comments by his heroes which would place his
ideology in a bad light. It is hardly convincing, particularly when their
_"good"_ quotes are so at odds with their practice and their _"bad"_ quotes so
in line with them. And as Marx argued, we should judge people by what they do,
**not** by what they say. This seems a basic principle of scientific analysis
and it is significant, if not surprising, that Leninists like Rees want to
reject it.

Ultimately, the theoretical problem with this position is that it denies the
importance of implementing ideas. After all, even if it where true that the
_"theory"_ of Bolshevism was different to its practice and the justifications
for that practice, it would leave us with the conclusion that this _"theory"_
was not sufficient when faced with the rigours of reality. In other words,
that it is impractical. A conclusion that Leninists do not want to draw, hence
the stress on _"objective factors"_ to explain the failure of Bolshevism. As
Marx said, judge people by what they do, not what they say (unless, of course,
as with the Bolsheviks post-October, what they said reflects what they did!)

Similarly, there seems to be an idealist tint to Leninist accounts of the
Russian Revolution. After all, they seem to think that the Lenin of 1921 was,
essentially, the same person as the Lenin of 1917! That seems to violate the
basic ideas of materialism. As Herbert Read points out, _"the phrase 'the
dictatorship of the proletariat' . . . became fatal through the interventions
of two political expedients -- the identification of the proletariat with the
Bolshevik Party, and the use of the State as an instrument of revolution.
Expedients and compromises may have been necessary for the defeat of the
reactionary forces; but there is no doubt whatsoever that what took place was
a progressive brutalisation of Lenin's own mind under the corrupting influence
of the exercise of power."_ [**A One-Man Manifesto**, p. 51] It seems common
sense that if a political strategy exposes its followers to the corrupting
effects of power we should factor this into any evaluation of it. Sadly,
Leninists fail to do this -- even worse, they attempt to whitewash the post-
October Lenin (and Trotsky) by excluding the "bad" quotes which reflect their
practice, a practice which they are at pains to downplay (or ignore)!

Then, of course, there is the attitude of the Bolshevik leaders themselves to
these so-called _"shouts of command in the midst of battle."_ Rather than
dismiss them as irrelevant, they continued to subscribe to them years later.
For example, Trotsky was still in favour of party dictatorship in the late
1930s (see [section H.1.2](secH1.html#sech12)). Looking at his justly infamous
**Terrorism and Communism**, we discover Trotsky in the 1930s reiterating his
support for his arguments of 1920. His preface to the 1936 French edition sees
him state that it was _"devoted to a clarification of the methods of the
proletariat's revolutionary policy in our epoch."_ He concluded as follows:
_"Victory is conceivable only on the basis of Bolshevik methods, to the
defence of which the present work is devoted."_ The previous year, in his
introduction to the second English edition, he was equally unrepentant. _"The
British proletariat,"_ he argued, _"will enter upon a period of political
crisis and theoretical criticism . . . The teachings of Marx and Lenin for the
first time will find the masses as their audience. Such being the case, it may
be also that the present book will turn out to be not without its use."_ He
dismissed the _"consoling illusion"_ that _"the arguments of this book [were]
true for backward Russia"_ but _"utterly without application to advanced
lands."_ The _"wave of Fascist or militarised police dictatorships"_ in the
1920s and 1930s was the reason. It seems ironic that Trotsky's self-proclaimed
followers are now repeating the arguments of what he termed "incurable
Fabians." [**Terrorism and Communism**, p. xix, p. xxxv, p. xlvii and p.
xxxix]

Rather than distance himself from the authoritarian and state capitalist
policies modern day Leninists claim were thrust upon an unwilling Bolshevik
party by _"objective factors,"_ Trotsky defends them! Moreover, as we noted in
[section 12](append42.html#app12) of the appendix on ["What was the Kronstadt
Rebellion?"](append42.html), Trotsky himself argues that these _"objective
factors"_ would face **every** revolution. As it is, he argues that it was
only the _"slow development of the revolution in the West"_ which stopped _"a
direct passage from military Communism to a Socialistic system of
production."_ Rather than admit to _"illusions"_ caused by the "iron
necessity" of willing the civil war, he talks about _"those economic hopes
which were bound up with the development of the world revolution."_ He even
links Bolshevik practice with Stalinism, noting that the _"idea of five-year
plans was not only formulated in that period [1918-1920], but in some economic
departments it was also technically worked out."_ [**Op. Cit.**, p. xliii]

Even his essay outlining what he considers the differences between Stalinism
and Bolshevism does not see him fundamentally distancing himself from the
positions modern day Leninists like to explain by "objective factors." He
stated that the _"Bolshevik party achieved in the civil war the correct
combination of military art and Marxist politics."_ What did that involve?
Immediately before making that claim he argued that the _"Bolshevik party has
shown the entire world how to carry out armed insurrection and the seizure of
power. Those who propose the abstraction of the Soviets from the party
dictatorship should understand that only thanks to the party dictatorship were
the Soviets able to lift themselves out of the mud of reformism and attain the
state form of the proletariat."_ Thus the _"party dictatorship"_ is seen as
being an example of _"Marxist politics"_ being successfully applied and not
something to be opposed. Moreover, _"the Bolshevik party was able to carry on
its magnificent 'practical' work only because it illuminated all its steps
with theory."_ [**Stalinism and Bolshevism**] Clearly, rather than denounce
the power of the party as being against Bolshevik theory, as Rees claims, for
Trotsky it represented its application. While he excuses some Bolshevik
actions (such as the banning of opposition groups) as a product of _"objective
factors,"_ he clearly sees the degeneration of the revolution coming **after**
the civil war and its _"correct combination"_ of _"Marxist politics"_ and
_"military art,"_ which included _"party dictatorship"_ over the soviets.

This lack of distancing is to be expected. After, the idea that "objective
factors" caused the degeneration of the Russian Revolution was first developed
by Trotsky to explain, after his fall from power) the rise of Stalinism. While
**he** was head of the Soviet state no such "objective" factors seemed to be
required to "explain" the party dictatorship over the working class. Indeed,
quite the reverse. As he argued in 1923 _"[i]f there is one question which
basically not only does not require revision but does not so much as admit the
thought of revision, it is the question of the dictatorship of the Party."_
[**Leon Trotsky Speaks**, p. 158]

Trotsky was just stating mainstream Bolshevik ideology, echoing a statement
made in March 1923 by the Central Committee (of which he and Lenin were
members) to mark the 25th anniversary of the founding of the Communist Party.
It sums up the lessons gained from the revolution and states that _"the party
of the Bolsheviks proved able to stand out fearlessly against the vacillations
within its own class, vacillations which, with the slightest weakness in the
vanguard, could turn into an unprecedented defeat for the proletariat."_
Vacillations, of course, are expressed by workers' democracy. Little wonder
the statement rejects it: _"The dictatorship of the working class finds its
expression in the dictatorship of the party."_ [_"To the Workers of the USSR"_
in G. Zinoviev, **History of the Bolshevik Party**, p. 213, p. 214] It should
be noted that Trotsky had made identical comments before and immediately after
the civil war -- as well as long after (see [section H.3.8](secH3.html#sech38)
for details).

So, as with all the leading Bolsheviks, he considered the party dictatorship
as an inevitable result of any proletarian revolution Moreover, he did not
question the social relationships within production either. One-man management
held no fears for him and he called the state capitalist regime under himself
and Lenin as _"socialist"_ and defended it as such. He was fully supportive of
one-man management. Writing in 1923, he argued that the _"system of actual
one-man management must be applied in the organisation of industry from top to
bottom. For leading economic organs of industry to really direct industry and
to bear responsibility for its fate, it is essential for them to have
authority over the selection of functionaries and their transfer and
removal."_ These economic organs must _"in actual practice have full freedom
of selection and appointment."_ [quoted by Robert V. Daniels, **A Documentary
History of Communism**, vol. 1, p. 237]

All of these post-civil war opinions of course, fit in well with his civil war
opinions on the matter. Which, incidentally, explains why, to quote a
Leninist, Trotsky _"continued to his death to harbour the illusion that
somehow, despite the lack of workers' democracy, Russia was a 'workers'
state.'"_ Simply put, there had been no workers' democracy under Lenin and
Trotsky and he considered that regime a _"workers' state."_ The question
arises why Harman thinks Lenin's Russia was some kind of "workers' state" if
workers' democracy is the criteria by which such things are to be judged. But,
then again, he thinks Trotsky's **Left Opposition** _"framed a policy along
[the] lines"_ of _"returning to genuine workers' democracy"_! [Chris
Harman,**Bureaucracy and Revolution in Eastern Europe**, p. 20 and p. 19]

Now, it seems strange that rather than present what he _"really"_ thought,
Trotsky expounded what presumably is the **opposite** of it. Surely the
simplistic conclusion to draw is that Trotsky said what he really did think
and that this was identical to his so-called _"shouts of command"_ made during
the civil war? But, of course, all these comments can be dismissed as
_"rhetorical justifications"_ and not reflective of Trotsky's real _"theory."_
Or can they? Ultimately, either you subscribe to the idea that Lenin and
Trotsky were able to express their ideas themselves or you subscribe to the
notion that they hid their _"real"_ politics and only modern-day Leninists can
determine what they, in fact, _"really"_ meant to say and what they "really"
stood for. And as for all those "awkward" quotes which express the
**opposite** of the divined true faith, well, they can be ignored.

Which is, of course, hardly a convincing position to take. Particularly as
Lenin and Trotsky were hardly shy in justifying their authoritarian policies
and expressing a distinct lack of concern over the fate of any **meaningful**
working class conquest of the revolution like, say, soviet democracy. As
Samuel Farber notes that _"there is no evidence indicating that Lenin or any
of the mainstream Bolshevik leaders lamented the loss of workers' control or
of democracy in the soviets, or at least referred to these losses as a
retreat, as Lenin declared with the replacement of War Communism by NEP in
1921."_ [**Before Stalinism**, p. 44]

The sad fact is that the inter-party conflicts of the 1920s were **not** about
_"workers' democracy,"_ rather party democracy. The Bolsheviks simply
relabelled _"party democracy"_ as _"workers' democracy."_ Little wonder in
1925 that Max Eastman, one of Trotsky's main supporters at the time, stated
_"this programme of democracy within the party [was] called 'Workers'
Democracy' by Lenin"_ and that _"Trotsky merely revived this original plea."_
[**Since Lenin Died**, p. 35] Trotsky held this position throughout the 1920s
and 1930s. As we noted in [section 13](append42.html#app13) of the appendix on
["What was the Kronstadt Rebellion?"](append42.html), the 1927 **Platform of
the Opposition** restated its belief in party dictatorship and argued that
Stalin was undermining it in favour of rule by the bureaucracy. Ironically,
Trotskyists in soviet prisons in the early 1930s _"continued to consider that
'Freedom to choose one's party -- that is Menshevism'"_ and this was their
_"final verdict."_ [Ante Ciliga, **The Russian Enigma**, p. 280] No wonder
they seemed surprised to be there!

Trotsky's issue with Stalinism was not based on **real** socialist principles,
such as meaningful working class freedoms and power. Rather it was a case of
_"the political centre of gravity ha[ving] shifted from the proletarian
vanguard to the bureaucracy"_ and this caused _"the party"_ to change _"its
social structure as well as in its ideology."_ [**Stalinism and Bolshevism**]
The party dictatorship had been replaced by the dictatorship of the state
bureaucracy, in other words. Once this happened, Trotsky sought to explain it.
As analysing the impact of Bolshevik ideology and practice were, by
definition, out of the question, that left the various objective factors
Trotsky turned to to explain developments after 1923. Now the concern for
_"objective factors"_ appeared, to explain Stalinism while keeping true to
Bolshevik ideology **and** practice.

So, in summary, the leading Bolsheviks did not view "objective factors" as
explaining the failure of the revolution. Indeed, until Trotsky was squeezed
out of power they did not think that the revolution **had** failed. Party
dictatorship and one-man management were **not** considered as expressions of
a failed revolution, rather a successful one. Trotsky's issue with Stalinism
was simply that the bureaucracy had replaced the _"the proletarian vanguard"_
(i.e. himself and his followers) as the dominant force in the Soviet State and
it had started to use the techniques of political repression developed against
opposition parties and groups against him. The idea that "objective factors"
caused the failure of the revolution was not used until the late 1920s and
even then not used to explain the party dictatorship but rather the usurpation
of **its** power by the bureaucracy.

[‹ What was the Kronstadt Rebellion?](/afaq/append42.html "Go to previous
page" ) [up](/afaq/append4.html "Go to parent page" ) [How did Bolshevik
ideology contribute to the failure of the Revolution? ›](/afaq/append44.html
"Go to next page" )

