# What happened during the Russian Revolution?

This appendix of the FAQ is not a full history of the Russian Revolution. The
scope of such a work would simply be too large. Instead, this section will
concentrate on certain key issues which matter in evaluating whether the
Bolshevik revolution and regime were genuinely socialist or not. This is not
all. Some Leninists acknowledge that that Bolshevik policies had little to do
with socialism as such were the best that were available at the time. As such,
this section will look at possible alternatives to Bolshevik policies and see
whether they were, in fact, inevitable.

So for those seeking a comprehensive history of the revolution will have to
look elsewhere. Here, we concentrate on those issues which matter when
evaluating the socialist content of the revolution and of Bolshevism. In other
words, the development of working class self-activity and self-organisation,
workers' resistance to their bosses (whether capitalist or "red"), the
activity of opposition groups and parties and the fate of working class
organisations like trade unions, factory committees and soviets. Moreover, the
role of the ruling party and its ideals also need to be indicated and
evaluated somewhat (see ["How did Bolshevik ideology contribute to the failure
of the Revolution?"](append44.html) for a fuller discussion of the role of
Bolshevik ideology in the defeat of the revolution).

This means that this section is about two things, what Alexander Berkman
termed _**"the Bolshevik Myth"**_ and what Voline called _**"the Unknown
Revolution"**_ (these being the titles of their respective books on the
revolution). After his experiences in Bolshevik Russia, Berkman came to the
conclusion that it was _"[h]igh time the truth about the Bolsheviki were told.
The whited sepulchre must unmasked, the clay feet of the fetish beguiling the
international proletariat to fatal will o' wisps exposed. The Bolshevik myth
must be destroyed."_ By so doing, he aimed to help the global revolutionary
movement learn from the experience of the Russian revolution. Given that
_"[t]o millions of the disinherited and enslaved it became a new religion, the
beacon of social salvation"_ it was an _"imperative to unmask the great
delusion, which otherwise might lead the Western workers to the same abyss as
their brothers in Russia."_ Bolshevism had _"failed, utterly and absolutely"_
and so it was _"incumbent upon those who have seen though the myth to expose
its true nature . . . Bolshevism is of the past. The future belongs to man and
his liberty."_ [**The Bolshevik Myth**, p. 318 and p. 342]

Subsequent events proved Berkman correct. Socialism became linked to Soviet
Russia and as it fell into Stalinism, the effect was to discredit socialism,
even radical change as such, in the eyes of millions. And quite rightly too,
given the horrors of Stalinism. If more radicals had had the foresight of
Berkman and the other anarchists, this association of socialism and revolution
with tyranny would have been combated and an alternative, libertarian, form of
socialism would have risen to take the challenge of combating capitalism in
the name of a **genuine** socialism, rooted in the ideals of liberty, equality
and solidarity.

However, in spite of the horrors of Stalinism many people seeking a radical
change in society are drawn to Leninism. This is partly to do with the fact
that in many countries Leninist parties have a organised presence and many
radicalised people come across them first. It is also partly to do with the
fact that many forms of Leninism denounce Stalinism for what it was and raise
the possibility of the "genuine" Leninism of the Bolshevik party under Lenin
and Trotsky. This current of Leninism is usually called "Trotskyism" and has
many offshoots. For some of these parties, the differences between Trotskyism
and Stalinism is pretty narrow. The closer to orthodox Trotskyism you get, the
more Stalinist it appears. As Victor Serge noted of Trotsky's "Fourth
International" in the 1930s, _"in the hearts of the persecuted I encountered
the same attitudes as in their persecutors [the Stalinists] . . . Trotskyism
was displaying symptoms of an outlook in harmony with the very Stalinism
against which it had taken its stand . . . any person in the circles of the
'Fourth International' who went so far as to object to [Trotsky's]
propositions was promptly expelled and denounced in the same language that the
bureaucracy had] employed against us in the Soviet Union."_ [**Memoirs of a
Revolutionary**, p. 349] As we discuss in [section 3](append45.html#app3) of
the appendix on ["Were any of the Bolshevik oppositions a real
alternative?"](append45.html), perhaps this is unsurprising given how much
politically Trotsky's "Left Opposition" had shared with Stalinism.

Other Trotskyist parties have avoided the worse excesses of orthodox
Trotskyism. Parties associated with the **International Socialists**, for
example portray themselves as defending what they like to term _"socialism
from below"_ and the democratic promise of Bolshevik as expressed during 1917
and in the early months of Bolshevik rule. While anarchists are somewhat
sceptical that Leninism can be called _"socialism from below"_ (see [section
H.3.3](secH3.html#sech33)), we need to address the claim that the period
between February 1917 to the start of the Russian civil war at the end of May
1918 shows the real nature of Bolshevism. In order to do that we need to
discuss what the Russian anarchist Voline called _"The Unknown Revolution."_

So what is the _"Unknown Revolution"_? Voline, an active participant in 1917
Russian Revolution, used that expression as the title of his classic account
of the Russian revolution. He used it to refer to the rarely acknowledged
independent, creative actions of the revolutionary people themselves. As
Voline argued, _"it is not known how to study a revolution"_ and most
historians _"mistrust and ignore those developments which occur silently in
the depths of the revolution . . . at best, they accord them a few words in
passing . . . [Yet] it is precisely these hidden facts which are important,
and which throw a true light on the events under consideration and on the
period."_ This section of the FAQ will try and present this _"unknown
revolution,"_ those movements _"which fought the Bolshevik power in the name
of true liberty and of the principles of the Social Revolution which that
power had scoffed at and trampled underfoot."_ [**The Unknown Revolution**, p.
19 and p. 437] Voline gives the Kronstadt rebellion (see the appendix on
["What was the Kronstadt Rebellion?"](append42.html)) and the Makhnovist
movement (see the appendix on ["Why does the Makhnovist movement show there is
an alternative to Bolshevism?"](append46.html)) pride of place in his account.
Here we discuss other movements and the Bolshevik response to them.

Leninist accounts of the Russian Revolution, to a surprising extent, fall into
the official form of history -- a concern more with political leaders than
with the actions of the masses. Indeed, the popular aspects of the revolution
are often distorted to accord with a predetermined social framework of
Leninism. Thus the role of the masses is stressed during the period before the
Bolshevik seizure of power. Here the typical Leninist would agree, to a large
extend, with summarised history of 1917 we present in [section
1](append41.html#app1). They would undoubtedly disagree with the downplaying
of the role of the Bolshevik party (although as we discuss in [section
2](append41.html#app2), that party was far from the ideal model of the
vanguard party of Leninist theory and modern Leninist practice). However, the
role of the masses in the revolution would be praised, as would the Bolsheviks
for supporting it.

The real difference arises once the Bolsheviks seize power in November 1917
(October, according to the Old Style calendar then used). After that, the
masses simply disappear and into the void steps the leadership of the
Bolshevik party. For Leninism, the _"unknown revolution"_ simply stops. The
sad fact is that very little is known about the dynamics of the revolution at
the grassroots, particularly after October. Incredible as it may sound, very
few Leninists are that interested in the realities of "workers' power" under
the Bolsheviks or the actual performance and fate of such working class
institutions as soviets, factory committees and co-operatives. What is written
is often little more than vague generalities that aim to justify authoritarian
Bolshevik policies which either explicitly aimed to undermine such bodies or,
at best, resulted in their marginalisation when implemented.

This section of the FAQ aims to make known the _"unknown revolution"_ that
continued under the Bolsheviks and, equally important, the Bolshevik response
to it. As part of this process we need to address some of the key events of
that period, such as the role of foreign intervention and the impact of the
civil war. However, we do not go into these issues in depth here and instead
cover them in depth in the appendix on ["What caused the degeneration of the
Russian Revolution?"](append43.html). This is because most Leninists excuse
Bolshevik authoritarianism on the impact of the civil war, regardless of the
facts of the matter. As we discuss in the appendix on ["How did Bolshevik
ideology contribute to the failure of the Revolution?"](append44.html), the
ideology of Bolshevism played its role as well -- something that modern day
Leninists strenuously deny (again, regardless of the obvious). As we indicate
in this section, the idea that Bolshevism came into conflict with the
_"unknown revolution"_ is simply not viable. Bolshevik ideology and practice
made it inevitable that this conflict erupted, as it did **before** the start
of the civil war (also see [section 3](append43.html#app3) of the appendix on
["What caused the degeneration of the Russian Revolution?"](append43.html)).

Ultimately, the reason why Leninist ideas still have influence on the
socialist movement is due to the apparent success of the Russian Revolution.
Many Leninist groups, mainly Trotskyists and derivatives of Trotskyism, point
to "Red October" and the creation of the first ever workers state as concrete
examples of the validity of their ideas. They point to Lenin's **State and
Revolution** as proving the "democratic" (even "libertarian") nature of
Leninism while, at the same time, supporting the party dictatorship he created
and, moreover, rationalising the utter lack of working class freedom and power
under it. We will try to indicate the falseness of such claims. As will become
clear from this section, the following summation of an anonymous revolutionary
is totally correct:

> _** "Every notion about revolution inherited from Bolshevism is false."**_

In this, they were simply repeating the conclusions of anarchists. As
Kropotkin stressed in 1920:

> _ "It seems to me that this attempt to build a communist republic on the
basis of a strongly centralised state, under the iron law of the dictatorship
of one party, has ended in a terrible fiasco. Russia teaches us how not to
impose communism."_ [Peter Kropotkin, quoted by Guerin, **Anarchism**, p. 106]

Ultimately, the experience of Bolshevism was a disaster. And as the
Makhnovists in the Ukraine proved, Bolshevik ideology and practice was **not**
the only option available (see the appendix on ["Why does the Makhnovist
movement show there is an alternative to Bolshevism?"](append46.html)). There
**were** alternatives, but Bolshevik ideology simply excluded using them (we
will discuss some possibilities in this various sub-sections below). In other
words, Bolshevik ideology is simply not suitable for a real revolutionary
movement and the problems it will face. In fact, its ideology and practice
ensures that any such problems will be magnified and made worse, as the
Russian revolution proves.

Sadly many socialists cannot bring themselves to acknowledge this. While
recognising the evils of the Stalinist bureaucracy, these socialists deny that
this degeneration of Bolshevism was inevitable and was caused by outside
factors (namely the Russian Civil War or isolation). While not denying that
these factors did have an effect in the outcome of the Russian Revolution, the
seeds for bureaucracy existed from the first moment of the Bolshevik
insurrection. These seeds where from three sources: Bolshevik politics, the
nature of the state and the post-October economic arrangements favoured and
implemented by the ruling party.

As we will indicate, these three factors caused the new "workers' state" to
degenerate long before the out break of the Civil war in May of 1918. This
means that the revolution was **not** defeated primarily because of isolation
or the effects of the civil war. The Bolsheviks had already seriously
undermined it from within **long before** the effects of isolation or civil
war had a chance to take hold. The civil war which started in the summer of
1918 did take its toll in what revolutionary gains survived, not least because
it allowed the Bolsheviks to portray themselves and their policies as the
lessor of two evils. However, Lenin's regime was already defending (state)
capitalism against genuine socialist tendencies before the outbreak of civil
war. The suppression of Kronstadt in March 1921 was simply the logical end
result of a process that had started in the spring of 1918, at the latest. As
such, isolation and civil war are hardly good excuses -- particularly as
anarchists had predicted they would affect every revolution decades previously
and Leninists are meant to realise that civil war and revolution are
inevitable. Also, it must be stressed that Bolshevik rule was opposed by the
working class, who took collective action to resist it and the Bolsheviks
justified their policies in ideological terms and **not** in terms of measures
required by difficult circumstances (see the appendix on ["What caused the
degeneration of the Russian Revolution?"](append43.html)).

One last thing. We are sure, in chronicling the "excesses" of the Bolshevik
regime, that some Leninists will say "they sound exactly like the right-wing."
Presumably, if we said that the sun rises in the East and sets in the West we
would also "sound like the right-wing." That the right-wing also points to
certain **facts** of the revolution does not in any way discredit these facts.
How these facts are used is what counts. The right uses the facts to discredit
socialism and the revolution. Anarchists use them to argue for libertarian
socialism and support the revolution while opposing the Bolshevik ideology and
practice which distorted it. Similarly, unlike the right we take into account
the factors which Leninists urge us to use to excuse Bolshevik
authoritarianism (such as civil war, economic collapse and so on). We are
simply not convinced by Leninist arguments.

Needless to say, few Leninists apply their logic to Stalinism. To attack
Stalinism by describing the facts of the regime would make one sound like the
"right-wing." Does that mean socialists should defend one of the most horrific
dictatorships that ever existed? If so, how does that sound to non-socialists?
Surely they would conclude that socialism **is** about Stalinism,
dictatorship, terror and so on? If not, why not? If "sounding like the right"
makes criticism of Lenin's regime anti-revolutionary, then why does this not
apply to Stalinism? Simply because Lenin and Trotsky were not at the head of
the dictatorship as they were in the early 1920s? Does the individuals who are
in charge override the social relations of a society? Does dictatorship and
one-man management become less so when Lenin rules? The apologists for Lenin
and Trotsky point to the necessity created by the civil war and isolation
within international capitalism for their authoritarian policies (while
ignoring the fact they started **before** the civil war, continued after it
**and were justified at the time** in terms of Bolshevik ideology). Stalin
could make the same claim.

Other objections may be raised. It may be claimed that we quote "bourgeois"
(or even worse, **Menshevik**) sources and so our account is flawed. In reply,
we have to state that you cannot judge a regime based purely on what it says
about itself. As such, critical accounts are required to paint a full picture
of events. Moreover, it is a sad fact that few, if any, Leninist accounts of
the Russian Revolution actually discuss the class and social dynamics (and
struggles) of the period under Lenin and Trotsky. This means we have to
utilise the sources which **do,** namely those historians who do not identify
with the Bolshevik regime. And, of course, any analysis (or defence) of the
Bolshevik regime will have to account for critical accounts, either by
refuting them or by showing their limitations. As will become obvious in our
discussion, the reason why latter day Bolsheviks talk about the class dynamics
post-October in the most superficial way is that it would be hard, even
impossible, to maintain that Lenin's regime was remotely socialist or based on
working class power. Simply put, from early 1918 (at the latest) conflict
between the Bolsheviks and the Russian working masses was a constant feature
of the regime. It is only when that conflict reached massive proportions that
Leninists do not (i.e. cannot) ignore it. In such cases, as the Kronstadt
rebellion proves, history is distorted in order to defend the Bolshevik state
(see the appendix on ["What was the Kronstadt Rebellion?"](append42.html) for
details).

The fact that Leninists try to discredit anarchists by saying that we sound
like the right is sad. In effect, it **blocks** any real discussion of the
Russian Revolution and Bolshevism (as intended, probably). This ensures that
Leninism remains above critique and so no lessons can be learnt from the
Russian experience. After all, if the Bolsheviks had no choice then what
lessons **are** there to learn? None. And if we are to learn no lessons (bar,
obviously, mimic the Bolsheviks) we are doomed to repeat the same mistakes --
mistakes that are partly explained by the objective circumstances at the time
and partly by Bolshevik politics. But given that most of the circumstances the
Bolsheviks faced, such as civil war and isolation, are likely to reappear in
any future revolution, modern-day Leninists are simply ensuring that Karl Marx
was right -- history repeats itself, first time as tragedy, second time as
farce.

Such a position is, of course, wonderful for the pro-Leninist. It allows them
to quote Lenin and Trotsky and use the Bolsheviks as the paradigm of
revolution while washing their hands of the results of that revolution. By
arguing that the Bolsheviks were _"making a virtue of necessity,"_ (to use the
expression of Leninist Donny Gluckstein [**The Tragedy of Bukharin**, p. 41]),
they are automatically absolved of proving their arguments about the
"democratic" essence of Bolshevism in power. Which is useful as, logically, no
such evidence could exist and, in fact, there is a whole host of evidence
pointing the other way which can, by happy co-incidence, be ignored. Indeed,
from this perspective there is no point even discussing the revolution at all,
beyond praising the activities and ideology of the Bolsheviks while sadly
noting that "fate" (to quote Leninist Tony Cliff) ensured that they could not
fulfil their promises. Which, of course, almost Leninist accounts **do** boil
down to. Thus, for the modern Leninist, the Bolsheviks cannot be judged on
what they did nor what they said while doing it (or even after). They can only
be praised for what they said and did **before** they seized power.

However, anarchists have a problem with this position. It smacks more of
religion than theory. Karl Marx was right to argue that you cannot judge
people by what they say, only by what they do. It is in this revolutionary
spirit that this section of the FAQ analyses the Russian revolution and the
Bolshevik role within it. We need to analyse what they did when they held
power as well as the election manifesto. As we will indicate in this section,
neither was particularly appealing.

Finally, we should note that Leninists today have various arguments to justify
what the Bolsheviks did once in power. We discuss these in the appendix on
["What caused the degeneration of the Russian Revolution?"](append43.html). We
also discuss in the appendix on ["How did Bolshevik ideology contribute to the
failure of the Revolution?"](append44.html) the ideological roots of the
counter-revolutionary role of the Bolsheviks during the revolution. That the
politics of the Bolsheviks played its role in the failure of the revolution
can be seen from the example of the anarchist influenced Makhnovist movement
which applied basic libertarian principles in the same difficult circumstances
of the Russian Civil War (see ["Why does the Makhnovist movement show there is
an alternative to Bolshevism?"](append46.html) on this important movement).

## 1 Can you give a short summary of what happened in 1917?

## 2 How did the Bolsheviks gain mass support?

## 3 Surely the Russian Revolution proves that vanguard parties work?

No, far from it. Looking at the history of vanguardism we are struck by its
failures, not its successes. Indeed, the proponents of _"democratic
centralism"_ can point to only one apparent success of their model, namely the
Russian Revolution. However, we are warned by Leninists that failure to use
the vanguard party will inevitably condemn future revolutions to failure:

> _ "The proletariat can take power only through its vanguard. . . Without the
confidence of the class in the vanguard, without support of the vanguard by
the class, there can be no talk of the conquest of power . . . The Soviets are
the only organised form of the tie between the vanguard and the class. A
revolutionary content can be given this form only by the party. This is proved
by the positive experience of the October Revolution and by the negative
experience of other countries (Germany, Austria, finally, Spain). No one has
either shown in practice or tried to explain articulately on paper how the
proletariat can seize power without the political leadership of a party that
knows what it wants."_ [Trotsky, **Stalinism and Bolshevism**]

To anarchist ears, such claims seem out of place. After all, did the Russian
Revolution actually result in socialism or even a viable form of soviet
democracy? Far from it. Unless you picture revolution as simply the changing
of the party in power, you have to acknowledge that while the Bolshevik party
**did** take power in Russian in November 1917, the net effect of this was
**not** the stated goals that justified that action. Thus, if we take the term
_"effective"_ to mean "an efficient means to achieve the desired goals" then
vanguardism has not been proven to be effective, quite the reverse (assuming
that your desired goal is a socialist society, rather than party power).
Needless to say, Trotsky blames the failure of the Russian Revolution on
_"objective"_ factors rather than Bolshevik policies and practice, an argument
we address in detail in ["What caused the degeneration of the Russian
Revolution?"](append43.html) and will not do so here.

So while Leninists make great claims for the effectiveness of their chosen
kind of party, the hard facts of history are against their positive evaluation
of vanguard parties. Ironically, even the Russian Revolution disproves the
claims of Leninists. The fact is that the Bolshevik party in 1917 was very far
from the _"democratic centralist"_ organisation which supporters of
_"vanguardism"_ like to claim it is. As such, its success in 1917 lies more in
its divergence from the principles of _"democratic centralism"_ than in their
application. The subsequent degeneration of the revolution and the party is
marked by the increasing **application** of those principles in the life of
the party.

Thus, to refute the claims of the _"effectiveness"_ and _"efficiency"_ of
vanguardism, we need to look at its one and only success, namely the Russian
Revolution. As the Cohen-Bendit brothers argue, _"far from leading the Russian
Revolution forwards, the Bolsheviks were responsible for holding back the
struggle of the masses between February and October 1917, and later for
turning the revolution into a bureaucratic counter-revolution -- in both cases
because of the party's very nature, structure and ideology."_ Indeed, _"[f]rom
April to October, Lenin had to fight a constant battle to keep the Party
leadership in tune with the masses."_ [**Obsolete Communism**, p. 183 and p.
187] It was only by continually violating its own _"nature, structure and
ideology"_ that the Bolshevik party played an important role in the
revolution. Whenever the principles of _"democratic centralism"_ were applied,
the Bolshevik party played the role the Cohen-Bendit brothers subscribed to it
(and once in power, the party's negative features came to the fore).

Even Leninists acknowledge that, to quote Tony Cliff, throughout the history
of Bolshevism, _"a certain conservatism arose."_ Indeed, _"[a]t practically
all sharp turning points, Lenin had to rely on the lower strata of the party
machine against the higher, or on the rank and file against the machine as a
whole."_ [**Lenin**, vol. 2, p. 135] This fact, incidentally, refutes the
basic assumptions of Lenin's party schema, namely that the broad party
membership, like the working class, was subject to bourgeois influences so
necessitating central leadership and control from above.

Looking at both the 1905 and 1917 revolutions, we are struck by how often this
_"conservatism"_ arose and how often the higher bodies were behind the
spontaneous actions of the masses and the party membership. Looking at the
1905 revolution, we discover a classic example of the inefficiency of
"democratic centralism." Facing in 1905 the rise of the soviets, councils of
workers' delegates elected to co-ordinate strikes and other forms of struggle,
the Bolsheviks did not know what to do. _"The Petersburg Committee of the
Bolsheviks,"_ noted Trotsky, _"was frightened at first by such an innovation
as a non-partisan representation of the embattled masses, and could find
nothing better to do than to present the Soviet with an ultimatum: immediately
adopt a Social-Democratic program or disband. The Petersburg Soviet as a
whole, including the contingent of Bolshevik workingmen as well ignored this
ultimatum without batting an eyelash."_ [**Stalin**, vol. 1, p. 106] More than
that, _"[t]he party's Central Committee published the resolution on October
27, thereby making it the binding directive for all other Bolshevik
organisations."_ [Oskar Anweiler, **The Soviets**, p. 77] It was only the
return of Lenin which stopped the Bolshevik's open attacks against the Soviet
(also see [section 8](append44.html#app8) of the appendix on ["How did
Bolshevik ideology contribute to the failure of the
Revolution?"](append44.html)).

The rationale for these attacks is significant. The St. Petersburg Bolsheviks
were convinced that _"only a strong party along class lines can guide the
proletarian political movement and preserve the integrity of its program,
rather than a political mixture of this kind, an indeterminate and vacillating
political organisation such as the workers council represents and cannot help
but represent."_ [quoted by Anweiler, **Op. Cit.**, p. 77] In other words, the
soviets could not reflect workers' interests because they were elected by the
workers! The implications of this perspective came clear in 1918, when the
Bolsheviks gerrymandered and disbanded soviets to remain in power (see
[section 6](append41.html#app6)). That the Bolshevik's position flowed
naturally from Lenin's arguments in **What is to be Done?** is clear. Thus the
underlying logic of Lenin's vanguardism ensured that the Bolsheviks played a
negative role with regards the soviets which, combined with "democratic
centralism" ensured that it was spread far and wide. Only by ignoring their
own party's principles and staying in the Soviet did rank and file Bolsheviks
play a positive role in the revolution. This divergence of top and bottom
would be repeated in 1917.

Given this, perhaps it is unsurprising that Leninists started to rewrite the
history of the 1905 revolution. Victor Serge, a "Left Oppositionist" and anti-
Stalinist asserted in the late 1920s that in 1905 the Petrograd Soviet was
_"led by Trotsky and inspired by the Bolsheviks."_ [**Year One of the Russian
Revolution**, p. 36]. While the former claim is correct, the latter is not. As
noted, the Bolsheviks were initially opposed the soviets and systematically
worked to undermine them. Unsurprisingly, Trotsky at that time was a
Menshevik, not a Bolshevik. After all, how could the most revolutionary party
that ever existed have messed up so badly? How could democratic centralism
faired so badly in practice? Best, then, to suggest that it did not and give
the Bolsheviks a role better suited to the rhetoric of Bolshevism than its
reality.

Trotsky was no different. He, needless to say, denied the obvious implications
of these events in 1905. While admitting that the Bolsheviks _"adjusted
themselves more slowly to the sweep of the movement"_ and that the Mensheviks
_"were preponderant in the Soviet,"_ he tries to save vanguardism by asserting
that _"the general direction of the Soviet's policy proceeded in the main
along Bolshevik lines."_ So, in spite of the lack of Bolshevik influence, in
spite of the slowness in adjusting to the revolution, Bolshevism was, in fact,
the leading set of ideas in the revolution! Ironically, a few pages later, he
mocks the claims of Stalinists that Stalin had _"isolated the Mensheviks from
the masses"_ by noting that the _"figures hardly bear [the claims] out."_
[**Op. Cit.**, p. 112 and p. 117] Shame he did not apply this criteria to his
own claims.

Of course, every party makes mistakes. The question is, how did the _"most
revolutionary party of all time"_ fare in 1917. Surely that revolution proves
the validity of vanguardism and "democratic centralism"? After all, there was
a successful revolution, the Bolshevik party did seize power. However, the
apparent success of 1917 was not due to the application of "democratic
centralism," quite the reverse. While the myth of 1917 is that a highly
efficient, democratic centralist vanguard party ensured the overthrow of the
Provisional Government in November 1917 in favour of the Soviets (or so it
seemed at the time) the facts are somewhat different. Rather, the Bolshevik
party throughout 1917 was a fairly loose collection of local organisations
(each more than willing to ignore central commands and express their
autonomy), with much internal dissent and infighting and no discipline beyond
what was created by common loyalty. The "democratic centralist" party, as
desired by Lenin, was only created in the course of the Civil War and the
tightening of the party dictatorship. In other words, the party became more
like a "democratic centralist" one as the revolution degenerated. As such, the
various followers of Lenin (Stalinists, Trotskyists and their multitude of
offshoots) subscribe to a myth, which probably explains their lack of success
in reproducing a similar organisation since. So assuming that the Bolsheviks
did play an important role in the Russian revolution, it was because it was
**not** the centralised, disciplined Bolshevik party of Leninist myth. Indeed,
when the party **did** operate in a vanguardist manner, failure was soon to
follow.

This claim can be proven by looking at the history of the 1917 revolution. The
February revolution started with a spontaneous protests and strikes. As Murray
Bookchin notes, _"the Petrograd organisation of the Bolsheviks opposed the
calling of strikes precisely on the eve of the revolution which was destined
to overthrow the Tsar. Fortunately, the workers ignored the Bolshevik
'directives' and went on strike anyway. In the events which followed, no one
was more surprised by the revolution than the 'revolutionary' parties,
including the Bolsheviks."_ [**Post-Scarcity Anarchism**, p. 194] Trotsky
quotes one of the Bolshevik leaders at the time:

> _ "Absolutely no guiding initiative from the party centres was felt . . .
the Petrograd Committee had been arrested and the representative of the
Central Committee . . . was unable to give any directives for the coming
day."_ [quoted by Trotsky, **History of the Russian Revolution**, vol. 1, p.
147]

Not the best of starts. Of course rank and file Bolsheviks took part in the
demonstrations, street fights and strikes and so violated the principles their
party was meant to be based on. As the revolution progressed, so did the dual
nature of the Bolshevik party (i.e. its practical divergence from "democratic
centralism" in order to be effective and attempts to force it back into that
schema which handicapped the revolution). However, during 1917, "democratic
centralism" was ignored in order to ensure the the Bolsheviks played any role
at all in the revolution. As one historian of the party makes clear, in 1917
and until the outbreak of the Civil War, the party operated in ways that few
modern "vanguard" parties would tolerate:

> _ "The committees were a law unto themselves when it came to accepting
orders from above. Democratic centralism, as vague a principle of internal
administration as there ever has been, was commonly held at least to enjoin
lower executive bodies that they should obey the behests of all higher bodies
in the organisational hierarchy. But town committees in practice had the
devil's own job in imposing firm leadership . . . Insubordination was the rule
of the day whenever lower party bodies thought questions of importance were at
stake. _

>

> _"Suburb committees too faced difficulties in imposing discipline. Many a
party cell saw fit to thumb its nose at higher authority and to pursue
policies which it felt to be more suited to local circumstances or more
desirable in general. No great secret was made of this. In fact, it was openly
admitted that hardly a party committee existed which did not encounter
problems in enforcing its will even upon individual activists."_ [Robert
Service, **The Bolshevik Party in Revolution 1917-1923**, pp. 51-2]

So while Lenin's ideal model of a disciplined, centralised and top-down party
had been expounded since 1902, the operation of the party never matched his
desire. As Service notes, _"a disciplined hierarchy of command stretching down
from the regional committees to party cells"_ had _"never existed in Bolshevik
history."_ In the heady days of the revolution, when the party was flooded by
new members, the party ignored what was meant to be its guiding principles. As
Service constantly stresses, Bolshevik party life in 1917 was the exact
opposite of that usually considered (by both opponents and supporters of
Bolshevism) as it normal mode of operation. _"Anarchist attitudes to higher
authority,"_ he argues, _"were the rule of the day"_ and _"no Bolshevik leader
in his right mind could have contemplated a regular insistence upon rigid
standards of hierarchical control and discipline unless he had abandoned all
hope of establishing a mass socialist party."_ This meant that _"in the Russia
of 1917 it was the easiest thing in the world for lower party bodies to rebut
the demands and pleas by higher authority."_ He stresses that _"[s]uburb and
town committees . . . often refused to go along with official policies . . .
they also . . . sometimes took it into their heads to engage in active
obstruction."_ [**Op. Cit.**, p. 80, p. 62 p. 56 and p. 60]

This worked both ways, of course. Town committees did _"snub their nose at
lower-echelon viewpoints in the time before the next election. Try as hard as
they might, suburb committees and ordinary cells could meanwhile do little to
rectify matters beyond telling their own representative on their town
committee to speak on their behalf. Or, if this too failed, they could resort
to disruptive tactics by criticising it in public and refusing it all
collaboration."_ [**Op. Cit.**, pp. 52-3] Even by early 1918, the Bolshevik
party bore little resemblance to the "democratic centralist" model desires by
Lenin:

> _ "The image of a disciplined hierarchy of party committees was therefore
but a thin, artificial veneer which was used by Bolshevik leaders to cover up
the cracked surface of the real picture underneath. Cells and suburb
committees saw no reason to kow-tow to town committees; nor did town
committees feel under compulsion to show any greater respect to their
provincial and regional committees then before."_ [**Op. Cit.**, p. 74]

It is this insubordination, this local autonomy and action in spite of central
orders which explains the success of the Bolsheviks in 1917. Rather than a
highly centralised and disciplined body of "professional" revolutionaries, the
party in 1917 saw a _"significant change . . . within the membership of the
party at local level . . . From the time of the February revolution
requirements for party membership had been all but suspended, and now
Bolshevik ranks swelled with impetuous recruits who knew next to nothing about
Marxism and who were united by little more than overwhelming impatience for
revolutionary action."_ [Alexander Rabinowitch, **Prelude to Revolution**, p.
41]

This mass of new members (many of whom were peasants who had just recently
joined the industrial workforce) had a radicalising effect on the party's
policies and structures. As even Leninist commentators argue, it was this
influx of members who allowed Lenin to gain support for his radical revision
of party aims in April. However, in spite of this radicalisation of the party
base, the party machine still was at odds with the desires of the party. As
Trotsky acknowledged, the situation _"called for resolute confrontation of the
sluggish Party machine with masses and ideas in motion."_ He stressed that
_"the masses were incomparably more revolutionary than the Party, which in
turn was more revolutionary than its committeemen."_ Ironically, given the
role Trotsky usually gave the party, he admits that _"[w]ithout Lenin, no one
had known what to make of the unprecedented situation."_ [**Stalin**, vol. 1,
p. 301, p. 305 and p. 297]

Which is significant in itself. The Bolshevik party is usually claimed as
being the most "revolutionary" that ever existed, yet here is Trotsky
admitting that its leading members did not have a clue what to do. He even
argued that _"[e]very time the Bolshevik leaders had to act without Lenin they
fell into error, usually inclining to the Right."_ [**Op. Cit.**, p. 299] This
negative opinion of the Bolsheviks applied even to the _"left Bolsheviks,
especially the workers"_ whom we are informed _"tried with all their force to
break through this quarantine"_ created by the Bolshevik leaders policy _"of
waiting, of accommodation, and of actual retreat before the Compromisers"_
after the February revolution and before the arrival of Lenin. Trotsky argues
that _"they did not know how to refute the premise about the bourgeois
character of the revolution and the danger of an isolation of the proletariat.
They submitted, gritting their teeth, to the directions of their leaders."_
[**History of the Russian Revolution**, vol. 1, p. 273] It seems strange, to
say the least, that without one person the whole of the party was reduced to
such a level given that the aim of the "revolutionary" party was to develop
the political awareness of its members.

Lenin's arrival, according to Trotsky, allowed the influence of the more
radical rank and file to defeat the conservatism of the party machine. By the
end of April, Lenin had managed to win over the majority of the party
leadership to his position. However, as Trotsky argues, this _"April conflict
between Lenin and the general staff of the party was not the only one of its
kind. Throughout the whole history of Bolshevism . . . all the leaders of the
party at all the most important moments stood to the **right** of Lenin."_
[**Op. Cit.**, p. 305] As such, if "democratic centralism" had worked as
intended, the whole party would have been arguing for incorrect positions the
bulk of its existence (assuming, of course, that Lenin was correct most of the
time).

For Trotsky, _"Lenin exerted influence not so much as an individual but
because he embodied the influence of the class on the Party and of the Party
on its machine."_ [**Stalin**, vol. 1, p. 299] Yet, this was the machine which
Lenin had forged, which embodied his vision of how a "revolutionary" party
should operate and was headed by him. In other words, to argue that the party
machine was behind the party membership and the membership behind the class
shows the bankruptcy of Lenin's organisational scheme. This _"backwardness,"_
moreover, indicates an independence of the party bureaucracy from the
membership and the membership from the masses. As Lenin's constantly repeated
aim was for the party to seize power (based on the dubious assumption that
class power would only be expressed, indeed was identical to, party power)
this independence held serious dangers, dangers which became apparent once
this goal was achieved.

Trotsky asks the question _"by what miracle did Lenin manage in a few short
weeks to turn the Party's course into a new channel?"_ Significantly, he
answers as follows: _"Lenin's personal attributes and the objective
situation."_ [**Ibid.**] No mention is made of the democratic features of the
party organisation, which suggests that without Lenin the rank and file party
members would not have been able to shift the weight of the party machine in
their favour. Trotsky seems close to admitting this:

> _ "As often happens, a sharp cleavage developed between the classes in
motion and the interests of the party machines. Even the Bolshevik Party
cadres, who enjoyed the benefit of exceptional revolutionary training, were
definitely inclined to disregard the masses and to identify their own special
interests and the interests of the machine on the very day after the monarchy
was overthrown."_ [**Stalin**, vol. 1, p. 298]

Thus the party machine, which embodied the principles of "democratic
centralism" proved less than able to the task assigned it in practice. Without
Lenin, it is doubtful that the party membership would have over come the party
machine:

> _ "Lenin was strong not only because he understood the laws of the class
struggle but also because his ear was faultlessly attuned to the stirrings of
the masses in motion. He represented not so much the Party machine as the
vanguard of the proletariat. He was definitely convinced that thousands from
among those workers who had borne the brunt of supporting the underground
Party would now support him. The masses at the moment were more revolutionary
than the Party, and the Party more revolutionary than its machine. As early as
March the actual attitude of the workers and soldiers had in many cases become
stormily apparent, and it was widely at variance with the instructions issued
by all the parties, including the Bolsheviks."_ [**Op. Cit.**, p. 299]

Little wonder the local party groupings ignored the party machine, practising
autonomy and initiative in the face of a party machine inclined to
conservatism, inertia, bureaucracy and remoteness. This conflict between the
party machine and the principles it was based on and the needs of the
revolution and party membership was expressed continually throughout 1917:

> _ "In short, the success of the revolution called for action against the
'highest circles of the party,' who, from February to October, utterly failed
to play the revolutionary role they ought to have taken in theory. The masses
themselves made the revolution, with or even against the party -- this much at
least was clear to Trotsky the historian. But far from drawing the correct
conclusion, Trotsky the theorist continued to argue that the masses are
incapable of making a revolution without a leader."_ [Daniel &amp; Gabriel
Cohn-Bendit, **Op. Cit.**, p. 188]

Looking at the development of the revolution from April onwards, we are struck
by the sluggishness of the party hierarchy. At every revolutionary upsurge,
the party simply was not to the task of responding to the needs of masses and
the local party groupings closest to them. The can be seen in June, July and
October itself. At each turn, the rank and file groupings or Lenin had to
constantly violate the principles of their own party in order to be effective.
The remoteness and conservatism of the party even under Lenin can be
constantly seen.

For example, when discussing the cancellation by the central committee of a
demonstration planned for June 10th by the Petrograd Bolsheviks, the
unresponsiveness of the party hierarchy can be seen. The _"speeches by Lenin
and Zinoviev [justifying their actions] by no means satisfied the Petersburg
Committee. If anything, it appears that their explanations served to
strengthen the feeling that at best the party leadership had acted
irresponsibly and incompetently and was seriously out of touch with reality."_
Indeed, many _"blamed the Central Committee for taking so long to respond to
Military Organisation appeals for a demonstration."_ [Rabinowitch, **Op.
Cit.**, p. 88 and p. 92]

During the discussions in late June, 1917, on whether to take direct action
against the Provisional Government there was a _"wide gulf"_ between lower
organs evaluations of the current situation and that of the Central Committee.
[Rabinowitch, **Op. Cit.**, p. 129] Indeed, among the delegates from the
Bolshevik military groups, only Lashevich (an old Bolshevik) spoke in favour
of the Central Committee position and he noted that _"[f]requently it is
impossible to make out where the Bolshevik ends and the Anarchist begins."_
[quoted by Rabinowitch, **Op. Cit.**, p. 129]

In the July days, the breach between the local party groups and the central
committee increased. As we noted in the [section 1](append41.html#app1), this
spontaneous uprising was opposed to by the Bolshevik leadership, in spite of
the leading role of their own militants (along with anarchists) in fermenting
it. While calling on their own militants to restrain the masses, the party
leadership was ignored by the rank and file membership who played an active
role in the event. Sickened by being asked to play the role of _"fireman,"_
the party militants rejected party discipline in order to maintain their
credibility with the working class. Rank and file activists, pointing to the
snowballing of the movement, showed clear dissatisfaction with the Central
Committee. One argued that it _"was not aware of the latest developments when
it made its decision to oppose the movement into the streets."_ Ultimately,
the Central Committee appeal _"for restraining the masses . . . was removed
from . . . **Pravda** . . . and so the party's indecision was reflected by a
large blank space on page one."_ [Rabinowitch, **Op. Cit.**, p. 150, p. 159
and P. 175] Ultimately, the indecisive nature of the leadership can be
explained by the fact it did not think it could seize state power for itself.
As Trotsky noted, _"the state of popular consciousness . . . made impossible
the seizure of power by the Bolsheviks in July."_ [**History of the Russian
Revolution**, vol. 2, p. 81]

The indecision of the party hierarchy did have an effect, of course. While the
anarchists at Kronstadt looked at the demonstration as the start of an
uprising, the Bolsheviks there were _"wavering indecisively in the middle"_
between them and the Left-Social Revolutionaries who saw it as a means of
applying pressure on the government. This was because they were _"hamstrung by
the indecision of the party Central Committee."_ [Rabinowitch, **Op. Cit.**,
p. 187] Little wonder so many Bolshevik party organisations developed and
protected their own autonomy and ability to act!

Significantly, one of the main Bolshevik groupings which helped organise and
support the July uprising, the Military Organisation, started their own paper
after the Central Committee had decreed after the failed revolt that neither
it, nor the Petersburg Committee, should be allowed to have one. It _"angrily
insisted on what it considered its just prerogatives"_ and in _"no uncertain
terms it affirmed its right to publish an independent newspaper and formally
protested what is referred to as 'a system of persecution and repression of an
extremely peculiar character which had begun with the election of the new
Central Committee.'"_ [Rabinowitch, **Op. Cit.**, p. 227] The Central
Committee backed down, undoubtedly due to the fact it could not enforce its
decision.

As the Cohn-Bendit brothers argue, _"five months after the Revolution and
three months before the October uprising, the masses were still governing
themselves, and the Bolshevik vanguard simply had to toe the line."_ [**Op.
Cit.**, p. 186] Within that vanguard, the central committee proved to be out
of touch with the rank and file, who ignored it rather than break with their
fellow workers.

Even by October, the party machine still lagged behind the needs of the
revolution. In fact, Lenin could only impose his view by going over the head
of the Central Committee. According to Trotsky's account, _"this time he [wa]s
not satisfied with furious criticism"_ of the _"ruinous Fabianism of the
Petrograd leadership"_ and _"by way of protest he resign[ed] from the Central
Committee."_ [**History of the Russian Revolution**, vol. 3, p. 131] Trotsky
quotes Lenin as follows:

> _ "I am compelled to request permission to withdraw from the Central
Committee, which I hereby do, and leave myself freedom of agitation in the
lower ranks of the party and at the party congress."_ [quoted by Trotsky,
**Op. Cit.**, p. 131]

Thus the October revolution was precipitated by a blatant violation of the
principles Lenin spent his life advocating. Indeed, if someone else other than
Lenin had done this we are sure that Lenin, and his numerous followers, would
have dismissed it as the action of a _"petty-bourgeois intellectual"_ who
cannot handle party _"discipline."_ This is itself is significant, as is the
fact that he decided to appeal to the _"lower ranks"_ of the party. Simply
put, rather than being "democratic" the party machine effectively blocked
communication and control from the bottom-up. Looking at the more radical
party membership, he _"could only impose his view by going over the head of
his Central Committee."_ [Daniel and Gabriel Cohn-Bendit, **Op. Cit.**, p.
187] He made sure to send his letter of protest to _"the Petrograd and Moscow
committees"_ and also made sure that _"copies fell into the hands of the more
reliable party workers of the district locals."_ By early October (and _"over
the heads of the Central Committee"_) he wrote _"directly to the Petrograd and
Moscow committees"_ calling for insurrection. He also _"appealed to a
Petrograd party conference to speak a firm word in favour of insurrection."_
[Trotsky, **Op. Cit.**, p. 131 and p. 132]

In October, Lenin had to fight what he called _"a wavering"_ in the _"upper
circles of the party"_ which lead to a _"sort of dread of the struggle for
power, an inclination to replace this struggle with resolutions protests, and
conferences."_ [quoted by Trotsky, **Op. Cit.**, p. 132] For Trotsky, this
represented _"almost a direct pitting of the party against the Central
Committee,"_ required because _"it was a question of the fate of the
revolution"_ and so _"all other considerations fell away."_ [Trotsky, **Op.
Cit.**, pp. 132-3] On October 8th, when Lenin addressed the Bolshevik
delegates of the forthcoming Northern Congress of Soviets on this subject, he
did so _"personally"_ as there _"was no party decision"_ and the _"higher
institutions of the party had not yet expressed themselves."_ [Trotsky, **Op.
Cit.**, p. 133] Ultimately, the Central Committee came round to Lenin's
position but they did so under pressure of means at odds with the principles
of the party.

This divergence between the imagine and reality of the Bolsheviks explains
their success. If the party had applied or had remained true to the principles
of "democratic centralism" it is doubtful that it would have played an
important role in the movement. As Alexander Rabinowitch argues, Bolshevik
organisational unity and discipline is _"vastly exaggerated"_ and, in fact,
Bolshevik success in 1917 was down to _"the party's internally relatively
democratic, tolerant, and decentralised structure and method of operation, as
well as its essentially open and mass character -- in striking contrast to the
traditional Leninist model."_ In 1917, he goes on, _"subordinate party bodies
with the Petersburg Committee and the Military Organisation were permitted
considerable independence and initiative . . . Most importantly, these lower
bodies were able to tailor their tactics and appeals to suit their own
particular constituencies amid rapidly changing conditions. Vast numbers of
new members were recruited into the party . . . The newcomers included tens of
thousands of workers and soldiers . . . who knew little, if anything, about
Marxism and cared nothing about party discipline."_ For example, while the
slogan _"All Power to the Soviets"_ was _"officially withdrawn by the Sixth
[Party] Congress in late July, this change did not take hold at the local
level."_ [**The Bolsheviks Come to Power**, p. 311, p. 312 and p. 313]

It is no exaggeration to argue that if any member of a current vanguard party
acted as the Bolshevik rank and file did in 1917, they would quickly be
expelled (this probably explains why no such party has been remotely
successful since). However, this ferment from below was quickly undermined
within the party with the start of the Civil War. It is from this period when
"democratic centralism" was actually applied within the party and clarified as
an organisational principle:

> _ "It was quite a turnabout since the anarchic days before the Civil War.
The Central Committee had always advocated the virtues of obedience and co-
operation; but the rank-and-filers of 1917 had cared little about such
entreaties as they did about appeals made by other higher authorities. The
wartime emergency now supplied an opportunity to expatiate on this theme at
will."_ [Service, **Op. Cit.**, p. 91]

Service stresses that _"it appears quite remarkable how quickly the
Bolsheviks, who for years had talked idly about a strict hierarchy of command
inside the party, at last began to put ideas into practice."_ [**Op. Cit.**,
p. 96]

In other words, the conversion of the Bolshevik party into a fully fledged
_"democratic centralist"_ party occurred during the degeneration of the
Revolution. This was both a consequence of the rising authoritarianism within
the party and society as well as one of its causes. As such, it is quite
ironic that the model used by modern day followers of Lenin is that of the
party during the decline of the revolution, not its peak. This is not
surprising. Once in power, the Bolshevik party imposed a state capitalist
regime onto the Russian people. Can it be surprising that the party structure
which it developed to aid this process was also based on bourgeois attitudes
and organisation? Simply put, the party model advocated by Lenin may not have
been very effective during a revolution but it was exceedingly effective at
prompting hierarchy and authority in the post-revolutionary regime. It simply
replaced the old ruling elite with another, made up of members of the radical
intelligentsia and odd ex-worker or ex-peasant.

This was due to the hierarchical and top-down nature of the party Lenin had
created. While the party base was largely working class, the leadership was
not. Full-time revolutionaries, they were either middle-class intellectuals or
(occasionally) ex-workers and (even rarer) ex-peasants who had left their
class to become part of the party machine. Even the delegates at the party
congresses did not truly reflect class basis of the party membership. For
example, the number of delegates was still dominated by white-collar or others
(59.1% to 40.9%) at the sixth party congress at the end of July 1917. [Cliff,
**Lenin**, vol. 2, p. 160] So while the party gathered more working class
members in 1917, it cannot be said that this was reflected in the party
leadership which remained dominated by non-working class elements. Rather than
being a genuine working class organisation, the Bolshevik party was a
hierarchical group headed by non-working class elements whose working class
base could not effectively control them even during the revolution in 1917. It
was only effective because these newly joined and radicalised working class
members ignored their own party structure and its defining ideology.

After the revolution, the Bolsheviks saw their membership start to decrease.
Significantly, _"the decline in numbers which occurred from early 1918
onwards"_ started happening _"contrary to what is usually assumed, some months
before the Central Committee's decree in midsummer that the party should be
purged of its 'undesirable' elements."_ These lost members reflected two
things. Firstly, the general decline in the size of the industrial working
class. This meant that the radicalised new elements from the countryside which
had flocked to the Bolsheviks in 1917 returned home. Secondly, the lost of
popular support the Bolsheviks were facing due to the realities of their
regime. This can be seen from the fact that while the Bolsheviks were losing
members, the Left SRS almost doubled in size to 100,000 (the Mensheviks
claimed to have a similar number). Rather than non-proletarians leaving,
_"[i]t is more probable by far that it was industrial workers who were leaving
in droves. After all, it would have been strange if the growing unpopularity
of Sovnarkom in factory milieu had been confined exclusively to non-
Bolsheviks."_ Unsurprisingly, given its position in power, _"[a]s the
proportion of working-class members declined, so that of entrants from the
middle-class rose; the steady drift towards a party in which industrial
workers no longer numerically predominated was under way."_ By late 1918
membership started to increase again but _"[m]ost newcomers were not of
working-class origin . . . the proportion of Bolsheviks of working-class
origin fell from 57 per cent at the year's beginning to 48 per cent at the
end."_ It should be noted that it was not specified how many were classed as
having working-class origin were still employed in working-class jobs. [Robert
Service, **Op. Cit.**, p. 70, pp. 70-1 and p. 90] A new ruling elite was thus
born, thanks to the way vanguard parties are structured and the application of
vanguardist principles which had previously been ignored.

In summary, the experience of the Russian Revolution does not, in fact, show
the validity of the "vanguard" model. The Bolshevik party in 1917 played a
leading role in the revolution only insofar as its members violated its own
organisational principles (Lenin included). Faced with a real revolution and
an influx of more radical new members, the party had to practice anarchist
ideas of autonomy, local initiative and the ignoring of central orders which
had no bearing to reality on the ground. When the party did try to apply the
top-down and hierarchical principles of "democratic centralism" it failed to
adjust to the needs of the moment. Moreover, when these principles were
finally applied they helped ensure the degeneration of the revolution. As we
discussed in [section H.5](secH5.html), this was to be expected.

## 4 Was Lenin's "State and Revolution" applied after October?

In a nutshell, no. In fact the opposite was the case. Post-October, the
Bolsheviks not only failed to introduce the ideas of Lenin's **State and
Revolution**, they in fact introduced the exact opposite. As one historian
puts it:

> _ "To consider 'State and Revolution' as the basic statement of Lenin's
political philosophy -- which non-Communists as well as Communists usually do
-- is a serious error. Its argument for a utopian anarchism never actually
became official policy. The Leninism of 1917 . . . came to grief in a few
short years; it was the revived Leninism of 1902 which prevailed as the basis
for the political development of the USSR."_ [Robert V. Daniels, **The
Conscience of the Revolution**, pp. 51-2]

Daniels is being far too lenient with the Bolsheviks. It was not, in fact, _"a
few short years"_ before the promises of 1917 were forgotten. In some cases,
it was a few short hours. In others, a few short months. However, in a sense
Daniels is right. It did take until 1921 before all hope for saving the
Russian Revolution finally ended. With the crushing of the Kronstadt
rebellion, the true nature of the regime became obvious to all with eyes to
see. Moreover, the banning of factions within the party at the same time did
mark a return to the pattern of _"What is to be Done?"_ rather than the more
fluid practice Bolshevism exhibited in, say, 1917 (see [section
3](append41.html#app3)). However, as we discuss in the appendix ["Were any of
the Bolshevik oppositions a real alternative?"](append45.html), the various
Bolshevik oppositions were, in their own way, just as authoritarian as the
mainstream of the party.

In order to show that this is the case, we need to summarise the main ideas
contained in Lenin's work. Moreover, we need to indicate what the Bolsheviks
did, in fact, do. Finally, we need to see if the various rationales justifying
these actions hold water.

So what did Lenin argue for in **State and Revolution**? Writing in the mid-
1930s, anarchist Camillo Berneri summarised the main ideas of that work as
follows:

> _ "The Leninist programme of 1917 included these points: the discontinuance
of the police and standing army, abolition of the professional bureaucracy,
elections for all public positions and offices, revocability of all officials,
equality of bureaucratic wages with workers' wages, the maximum of democracy,
peaceful competition among the parties within the soviets, abolition of the
death penalty."_ [_"The Abolition and Extinction of the State,"_ **Cienfuegos
Press Anarchist Review**, no. 4, p. 50]

As he noted, _"[n]ot a single one of the points of this programme has been
achieved."_ This was, of course, under Stalinism and most Leninists will
concur with Berneri. However what Leninists tend not to mention is that in the
7 month period from November 1917 to May 1918 none of these points was
achieved. So, as an example of what Bolshevism "really" stands for it seems
strange to harp on about a work which was never implemented when the its
author was in a position to do so (i.e. before the onslaught of a civil war
Lenin thought was inevitable anyway!).

To see that Berneri's summary is correct, we need to quote Lenin directly.
Obviously the work is a wide ranging defence of Lenin's interpretation of
Marxist theory on the state. As it is an attempt to overturn decades of
Marxist orthodoxy, much of the work is quotes from Marx and Engels and Lenin's
attempts to enlist them for his case (we discuss this issue in [section
H.3.10](secH3.html#sech310)). Equally, we need to discount the numerous straw
men arguments about anarchism Lenin inflicts on his reader (see sections
[H.1.3](secH1.html#sech13), [H.1.4](secH1.html#sech14) and
[H.1.5](secH1.html#sech15) for the truth about his claims). Here we simply
list the key points as regards Lenin's arguments about his "workers' state"
and how the workers would maintain control of it:

1) Using the Paris Commune as a prototype, Lenin argued for the abolition of
_"parliamentarianism"_ by turning _"representative institutions from mere
'talking shops' into working bodies."_ This would be done by removing _"the
division of labour between the legislative and the executive."_ [**Essential
Works of Lenin**, p. 304 and p. 306]

2) _"All officials, without exception, to be elected and subject to recall
**at any time**"_ and so _"directly responsible to their constituents."_
_"Democracy means equality."_ [**Op. Cit.**, p. 302, p. 306 and p. 346]

3) The _"immediate introduction of control and superintendence by **all,** so
that **all** shall become 'bureaucrats' for a time and so that, therefore,
**no one** can become a 'bureaucrat'."_ Proletarian democracy would _"take
immediate steps to cut bureaucracy down to the roots . . . to the complete
abolition of bureaucracy"_ as the _"**essence** of bureaucracy"_ is officials
becoming transformed _"into privileged persons divorced from the masses and
**superior to** the masses."_ [**Op. Cit.**, p. 355 and p. 360]

4) There should be no _"special bodies of armed men"_ standing apart from the
people _"since the majority of the people itself suppresses its oppressors, a
'special force' is no longer necessary."_ Using the example of the Paris
Commune, Lenin suggested this meant _"abolition of the standing army."_
Instead there would be the _"armed masses."_ [**Op. Cit.**, p. 275, p. 301 and
p. 339]

5) The new (workers) state would be _"the organisation of violence for the
suppression of . . . the exploiting class, i.e. the bourgeoisie. The toilers
need a state only to overcome the resistance of the exploiters"_ who are _"an
insignificant minority,"_ that is _"the landlords and the capitalists."_ This
would see _"an immense expansion of democracy . . . for the poor, democracy
for the people"_ while, simultaneously, imposing _"a series of restrictions on
the freedom of the oppressors, the exploiters, the capitalists. . . their
resistance must be broken by force: it is clear that where is suppression
there is also violence, there is no freedom, no democracy."_ [**Op. Cit.**, p.
287 and pp. 337-8]

This would be implemented after the current, bourgeois, state had been
smashed. This would be the _"dictatorship of the proletariat"_ and be _"the
introduction of complete democracy for the people."_ [**Op. Cit.**, p. 355]
However, the key practical ideas on what the new "semi-state" would be are
contained in these five points. He generalised these points, considering them
valid not only for Russia in 1917 but in all countries. In this his followers
agree. Lenin's work is considered valid for today, in advanced countries as it
was in revolutionary Russia.

Three things strike anarchist readers of Lenin's work. Firstly, as we noted in
[section H.1.7](secH1.html#sech17), much of it is pure anarchism. Bakunin had
raised the vision of a system of workers' councils as the framework of a free
socialist society in the 1860s and 1870s. Moreover, he had also argued for the
election of mandated and recallable delegates as well as for using a popular
militia to defend the revolution (see [section H.2.1](secH2.html#sech21)).
What is not anarchist is the call for centralisation, equating the council
system with a state and the toleration of a "new" officialdom. Secondly, the
almost utter non-mention of the role of the party in the book is deeply
significant. Given the emphasis that Lenin had always placed on the party,
it's absence is worrying. Particularly (as we indicate in [section
5](append41.html#app5)) he had been calling for the party to seize power all
through 1917. When he does mention the party he does so in an ambiguous way
which suggests that it, not the class, would be in power. As subsequent events
show, this was indeed what happened in practice. And, finally, the anarchist
reader is struck by the fact that every one of these key ideas were not
implemented under Lenin. In fact, the opposite was done. This can be seen from
looking at each point in turn.

The first point as the creation of "working bodies", the combining of
legislative and executive bodies. The first body to be created by the
Bolshevik revolution was the "Council of People's Commissars" (CPC) This was a
government separate from and above the Central Executive Committee (CEC) of
the soviets congress. It was an executive body elected by the soviet congress,
but the soviets themselves were not turned into "working bodies." Thus the
promises of Lenin's **State and Revolution** did not last the night.

As indicated in [section 5](append41.html#app5), the Bolsheviks clearly knew
that the Soviets had alienated their power to this body. However, it could be
argued that Lenin's promises were kept as this body simply gave itself
legislative powers four days later. Sadly, this is not the case. In the Paris
Commune the delegates of the people took executive power into their own hands.
Lenin reversed this. His executive took legislative power from the hands of
the people's delegates. In the former case, power was decentralised into the
hands of the population. In the latter case, it was centralised into the hands
of a few. This concentration of power into executive committees occurred at
all levels of the soviet hierarchy (see [section 6](append41.html#app6) for
full details). Simply put, legislative and executive power was taken **from**
the soviets assemblies and handed to Bolshevik dominated executive committees.

What of the next principle, namely the election and recall of all officials?
This lasted slightly longer, namely around 5 months. By March of 1918, the
Bolsheviks started a systematic campaign against the elective principle in the
workplace, in the military and even in the soviets. In the workplace, Lenin
was arguing for appointed one-man managers _"vested with dictatorial powers"_
by April 1918 (see [section 10](append41.html#app10)). In the military,
Trotsky simply decreed the end of elected officers in favour of appointed
officers (see [section 14](append41.html#app14)). And as far as the soviets
go, the Bolsheviks were refusing to hold elections because they _"feared that
the opposition parties would show gains."_ When elections were held,
_"Bolshevik armed force usually overthrew the results"_ in provincial towns.
Moreover, the Bolsheviks _"pack[ed] local soviets"_ with representatives of
organisations they controlled _"once they could not longer count on an
electoral majority."_ [Samuel Farber, **Before Stalinism**, p. 22, p. 24 and
p. 33] This gerrymandering was even practised at the all-Russian soviet
congress (see [section 6](append41.html#app6) for full details of this
Bolshevik onslaught against the soviets). So much for competition among the
parties within the soviets! And as far as the right of recall went, the
Bolsheviks only supported this when the workers were recalling the opponents
of the Bolsheviks, not when the workers were recalling them.

In summary, in under six months the Bolsheviks had replaced election of _"all
officials"_ by appointment from above in many areas of life. Democracy had
simply being substituted by appointed from above (see [section
4](append44.html#app4) of the appendix on ["How did Bolshevik ideology
contribute to the failure of the Revolution?"](append44.html)for the deeply
undemocratic reasoning used to justify this top-down and autocratic system of
so-called democracy). The idea that different parties could compete for votes
in the soviets (or elsewhere) was similarly curtailed and finally abolished.

Then there was the elimination of bureaucracy. As we show in [section
7](append44.html#app7) of the appendix on ["How did Bolshevik ideology
contribute to the failure of the Revolution?"](append44.html), a new
bureaucratic and centralised system quickly emerged. Rather than immediately
cutting the size and power of the bureaucracy, it steadily grew. It soon
became the real power in the state (and, ultimately, in the 1920s became the
social base for the rise of Stalin). Moreover, with the concentration of power
in the hands of the Bolshevik government, the _"essence"_ of bureaucracy
remained as the party leaders became _"privileged persons divorced from the
masses and **superior to** the masses."_ They were, for example, more than
happy to justify their suppression of military democracy in terms of them
knowing better than the general population what was best for them (see
[section 4](append44.html#app4) of the appendix on ["How did Bolshevik
ideology contribute to the failure of the Revolution?"](append44.html) for
details).

Then there is the fourth point, namely the elimination of the standing army,
the suppression of _"special bodies of armed men"_ by the _"armed masses."_
This promise did not last two months. On the 20th of December, 1917, the
Council of People's Commissars decreed the formation of a political (secret)
police force, the _"Extraordinary Commission to Fight Counter-Revolution."_
This was more commonly known by the Russian initials of the first two terms of
its official name: The Cheka. Significantly, its founding decree stated it was
to _"watch the press, saboteurs, strikers, and the Socialist-Revolutionaries
of the Right."_ [contained in Robert V. Daniels, **A Documentary History of
Communism**, vol. 1, p. 133]

While it was initially a small organisation, as 1918 progressed it grew in
size and activity. By April 1918, it was being used to break the anarchist
movement across Russia (see [section 23](append41.html#app23) for details).
The Cheka soon became a key instrument of Bolshevik rule, with the full
support of the likes of Lenin and Trotsky. The Cheka was most definitely a
_"special body of armed men"_ and not the same as the _"armed workers."_ In
other words, Lenin's claims in **State and Revolution** did not last two
months and in under six months the Bolshevik state had a mighty group of
_"armed men"_ to impose its will.

This is not all. The Bolsheviks also conducted a sweeping transformation of
the military within the first six months of taking power. During 1917, the
soldiers and sailors (encouraged by the Bolsheviks and other revolutionaries)
had formed their own committees and elected officers. In March 1918, Trotsky
simply abolished all this by decree and replaced it with appointed officers
(usually ex-Tsarist ones). In this way, the Red Army was turned from a
workers' militia (i.e. an armed people) into a _"special body"_ separate from
the general population (see [section 15](append41.html#app15) for further
discussion on this subject).

So instead of eliminating a _"special force"_ above the people, the Bolsheviks
did the opposite by creating a political police force (the Cheka) and a
standing army (in which elections were a set aside by decree). These were
special, professional, armed forces standing apart from the people and
unaccountable to them. Indeed, they were used to repress strikes and working
class unrest, a topic we now turn to.

Then there is the idea of that Lenin's "workers' state" would simple be an
instrument of violence directed at the exploiters. This was not how it turned
out in practice. As the Bolsheviks lost popular support, they turned the
violence of the "worker's state" against the workers (and, of course, the
peasants). As noted above, when the Bolsheviks lost soviet elections they used
force to disband them (see [section 6](append41.html#app6) for further
details). Faced with strikes and working class protest during this period, the
Bolsheviks responded with state violence (see [section 5](append43.html#app5)
of the appendix on ["What caused the degeneration of the Russian
Revolution?"](append43.html) for details). We will discuss the implications of
this for Lenin's theory below. So, as regards the claim that the new
("workers") state would repress only the exploiters, the truth was that it was
used to repress whoever opposed Bolshevik power, including workers and
peasants.

As can be seen, after the first six months of Bolshevik rule not a single
measure advocated by Lenin in **State and Revolution** existed in
"revolutionary" Russia. Some of the promises were broken in quiet quickly
(overnight, in one case). Most took longer. For example, the democratisation
of the armed forces had been decreed in late December 1917. However, this was
simply acknowledging the existing revolutionary gains of the military
personnel. Similarly, the Bolsheviks passed a decree on workers' control
which, again, simply acknowledged the actual gains by the grassroots (and, in
fact, limited them for further development -- see [section
9](append41.html#app9)). This cannot be taken as evidence of the democratic
nature of Bolshevism as most governments faced with a revolutionary movement
will acknowledge and "legalise" the facts on the ground (until such time as
they can neutralise or destroy them). For example, the Provisional Government
created after the February Revolution also legalised the revolutionary gains
of the workers (for example, legalising the soviets, factory committees,
unions, strikes and so forth). The real question is whether Bolshevism
continued to encourage these revolutionary gains once it had consolidated its
power. Which they did not. Indeed, it can be argued that the Bolsheviks simply
managed to do what the Provisional Government it replaced had failed to do,
namely destroy the various organs of popular self-management created by the
revolutionary masses. So the significant fact is not that the Bolsheviks
recognised the gains of the masses but that their toleration of the
application of what their followers say were their real principles did not
last long and was quickly ended. Moreover, when the leading Bolsheviks looked
back at this abolition they did not consider it in any way in contradiction to
the principles of "communism" (see [section 14](append41.html#app14)).

We have stressed this period for a reason. This was the period **before** the
out-break of major Civil War and thus the policies applied show the actual
nature of Bolshevism, it's essence if you like. This is a significant date as
most Leninists blame the failure of Lenin to live up to his promises on this
even. In reality, the civil war was **not** the reason for these betrayals --
simply because it had not started yet (see [section 16](append41.html#app16)
on when the civil war started and its impact). Each of the promises were
broken in turn months before the civil war happened. _"All Power to the
Soviets"_ became, very quickly, _"All Power to the Bolsheviks."_ In the words
of historian Marc Ferro:

> _ "In a way, **The State and Revolution** even laid the foundations and
sketched out the essential features of an alternative to Bolshevik power, and
only the pro-Leninist tradition has used it, almost to quieten its conscience,
because Lenin, once in power, ignored its conclusions. The Bolsheviks, far
from causing the state to wither away, found endless reasons for justifying
its enforcement."_ [**October 1917**, pp. 213-4]

Where does that leave Lenin's **State and Revolution**? Well, modern-day
Leninists still urge us to read it, considering it his greatest work and the
best introduction to what Leninism really stands for. For example, we find
Leninist Tony Cliff calling that book _"Lenin's real testament"_ while, at the
same time, acknowledging that its _"message . . . which was the guide for the
first victorious proletarian revolution, was violated again and again during
the civil war."_ Not a very good _"guide"_ or that convincing a _"message"_ if
it was not applicable in the very circumstances it was designed to be applied
in (a bit like saying you have an excellent umbrella but it only works when it
is not raining). Moreover, Cliff is factually incorrect. The Bolsheviks
_"violated"_ that _"guide"_ before the civil war started (i.e. when _"the
victories of the Czechoslovak troops over the Red Army in June 1918, that
threatened the greatest danger to the Soviet republic,"_ to quote Cliff).
Similarly, much of the economic policies implemented by the Bolsheviks had
their roots in that book and the other writings by Lenin from 1917 (see
[section 5](append44.html#app5) of the appendix on ["How did Bolshevik
ideology contribute to the failure of the Revolution?"](append44.html)).
[**Lenin**, vol. 3, p. 161 and p. 18]

Given this, what use is Lenin's **State and Revolution**? If this really was
the _"guide"_ it is claimed to be, the fact that it proved totally impractical
suggests it should simply be ignored. Simply put, if the side effects of a
revolution (such as civil war) require it to be ripped up then modern
Leninists should come clean and admit that revolution and workers' democracy
simply do not go together. This was, after all, the conclusion of Lenin and
Trotsky (see [section H.3.8](secH3.html#sech38)). As such, they should not
recommend Lenin's work as an example of what Bolshevism aims for. If, however,
the basic idea of workers' democracy and freedom are valid and considered the
only way of achieving socialism then we need to wonder **why** the Bolsheviks
did not apply them when they had the chance, particularly when the Makhnovists
in the Ukraine did. Such an investigation would only end up by concluding the
validity of anarchism, **not** Leninism.

This can be seen from the trajectory of Bolshevik ideology post-October.
Simply put, it was not bothered by the breaking of the promises of **State and
Revolution** and 1917 in general. As such, Cliff is just wrong to assert that
while the message of **State and Revolution** was _"violated again and again"_
it _"was also invoked again and again against bureaucratic degeneration."_
[Cliff, **Op. Cit.**, p. 161] Far from it. Lenin's **State and Revolution**
was rarely invoked against degeneration by the mainstream Bolshevik
leadership. Indeed, they happily supported party dictatorship and one-man
management. Ironically for Cliff, it **was** famously invoked against the
state capitalist policies being implemented in early 1918. This was done by
the "Left Communists" around Bukharin in their defence of workers' self-
management against Lenin's policy! Lenin told them to reread it (along with
his other 1917 works) to see that "state capitalism" was his aim all along!
Not only that, he quoted from **State and Revolution**. He argued that
_"accounting and control"_ was required _"for the proper functioning of the
first stage of communist society."_ _"And this control,"_ he continued, _"must
be established not only over 'the insignificant capitalist minority, over the
gentry . . . ', but also over the workers who 'have been thoroughly corrupted
by capitalism . . . '"_ He ended by saying it was _"significant that Bukharin
did **not** emphasise **this**."_ [**Collected Works**, vol. 27, pp. 353-4]
Needless to say, the Leninists who urge us to read Lenin's work do not
emphasis that either.

As the Bolsheviks lost more and more support, the number of workers
_"thoroughly corrupted by capitalism"_ increased. How to identify them was
easy: they did not support the party. As historian Richard summarises, a
_"lack of identification with the Bolshevik party was treated as the absence
of political consciousness altogether."_ [**Soviet Communists in Power**, p.
94] This is the logical conclusion of vanguardism, of course (see [section
H.5.3](secH5.html#sech53)). However, to acknowledge that state violence was
also required to "control" the working class totally undermines the argument
of **State and Revolution**.

This is easy to see and to prove theoretically. For example, by 1920, Lenin
was more than happy to admit that the "workers' state" used violence against
the masses. At a conference of his political police, the Cheka, Lenin argued
as follows:

> _ "Without revolutionary coercion directed against the avowed enemies of the
workers and peasants, it is impossible to break down the resistance of these
exploiters. On the other hand, revolutionary coercion is bound to be employed
towards the wavering and unstable elements among the masses themselves."_
[**Collected Works**, vol. 42, p. 170]

This was simply summarising Bolshevik practice from the start. However, in
**State and Revolution** Lenin had argued for imposing _"a series of
restrictions on the freedom of the oppressors, the exploiters, the
capitalists."_ In 1917 he was _"clear that where is suppression there is also
violence, there is no freedom, no democracy."_ [**Op. Cit.**, pp. 337-8] So if
violence is directed against the working class then, obviously, there can be
_"no freedom, no democracy"_ for that class. And who identifies who the
_"wavering and unstable"_ elements are? Only the party. Thus any expression of
workers' democracy which conflicts with the party is a candidate for
_"revolutionary coercion."_ So it probably just as well that the Bolsheviks
had eliminated military democracy in March, 1918.

Trotsky expands on the obvious autocratic implications of this in 1921 when he
attacked the Workers' Opposition's ideas on economic democracy:

> _ "The Party . . . is . . . duty bound to retain its dictatorship,
regardless of the temporary vacillations of the amorphous masses, regardless
of the temporary vacillations even of the working class. This awareness is
essential for cohesion; without it the Party is in danger of perishing . . .
At any given moment, the dictatorship does not rest on the formal principle of
workers' democracy . . . if we look upon workers' democracy as something
unconditional . . . then . . . every plant should elect its own administrative
organs and so on . . . From a formal point of view this is the clearest link
with workers' democracy. But we are against it. Why? . . . Because, in the
first place, we want to retain the dictatorship of the Party, and, in the
second place, because we think that the [democratic] way of managing important
and essential plants is bound to be incompetent and prove a failure from an
economic point of view . . ."_ [quoted by Jay B. Sorenson, **The Life and
Death of Soviet Trade Unionism**, p. 165]

Thus the Russian Revolution and the Bolshevik regime confirmed anarchist
theory and predictions about state socialism. In the words of Luigi Fabbri:

> _ "It is fairly certain that between the capitalist regime and the socialist
there will be an intervening period of struggle, during which proletariat
revolutionary workers will have to work to uproot the remnants of bourgeois
society . . . But if the object of this struggle and this organisation is to
free the proletariat from exploitation and state rule, then the role of guide,
tutor or director cannot be entrusted to a new state, which would have an
interest in pointing the revolution in a completely opposite direction. . . _

>

> _"The outcome would be that a new government - battening on the revolution
and acting throughout the more or less extended period of its 'provisional'
powers - would lay down the bureaucratic, military and economic foundations of
a new and lasting state organisation, around which a compact network of
interests and privileges would, naturally, be woven. Thus in a short space of
time what one would have would not be the state abolished, but a state
stronger and more energetic than its predecessor and which would come to
exercise those functions proper to it - the ones Marx recognised as being such
- 'keeping the great majority of producers under the yoke of a numerically
small exploiting minority.' _

>

> _"This is the lesson that the history of all revolutions teaches us, from
the most ancient down to the most recent; and it is confirmed . . . by the
day-to-day developments of the Russian revolution . . . _

>

> _"Certainly, [state violence] starts out being used against the old power .
. . But as the new power goes on consolidating its position . . . ever more
frequently and ever more severely, the mailed fist of dictatorship is turned
against the proletariat itself in whose name that dictatorship was set up and
is operated! . . . the actions of the present Russian government [of Lenin and
Trotsky] have shown that in real terms (and it could not be otherwise) the
'dictatorship of the proletariat' means police, military, political and
economic dictatorship exercised over the broad mass of the proletariat in city
and country by the few leaders of the political party. _

>

> _"The violence of the state always ends up being used AGAINST ITS SUBJECTS,
of whom the vast majority are always proletarians . . . The new government
will be able to expropriate the old ruling class in whole or in part, but only
so as to establish a new ruling class that will hold the greater part of the
proletariat in subjection. _

>

> _"That will come to pass if those who make up the government and the
bureaucratic, military and police minority that upholds it end up becoming the
real owners of wealth when the property of everyone is made over exclusively
to the state. In the first place, the failure of the revolution will be self
evident. In the second, in spite of the illusions that many people create, the
conditions of the proletariat will always be those of a subject class."_
[_"Anarchy and 'Scientific' Communism"_, in **The Poverty of Statism**, pp.
13-49, Albert Meltzer (ed.), pp. 26-31]

The standard response by most modern Leninists to arguments like this about
Bolshevism is simply to downplay the authoritarianism of the Bolsheviks by
stressing the effects of the civil war on shaping their ideology and actions.
However, this fails to address the key issue of why the reality of Bolshevism
(even before the civil war) was so different to the rhetoric. Anarchists, as
we discuss in ["How did Bolshevik ideology contribute to the failure of the
Revolution?"](append44.html), can point to certain aspects of Bolshevik
ideology and the social structures its favoured which can explain it. The
problems facing the revolution simply brought to the fore the limitations and
dangers inherent in Leninism and, moreover, shaping them in distinctive ways.
We draw the conclusion that a future revolution, as it will face similar
problems, would be wise to avoid applying Leninist ideology and the
authoritarian practices it allows and, indeed, promotes by its support of
centralisation, confusion of party power with class power, vanguardism and
equation of state capitalism with socialism. Leninists, in contrast, can only
stress the fact that the revolution was occurring in difficult circumstances
and hope that "fate" is more kind to them next time -- as if a revolution, as
Lenin himself noted in 1917, would not occur during nor create "difficult"
circumstances! Equally, they can draw no lessons (bar repeat what the
Bolsheviks did in 1917 and hope for better objective circumstances!) from the
Russian experience simply because they are blind to the limitations of their
politics. They are thus doomed to repeat history rather than make it.

So where does this analysis of Lenin's **State and Revolution** and the
realities of Bolshevik power get us? The conclusions of dissent Marxist Samuel
Farber seem appropriate here. As he puts it, _"the very fact that a Sovnarkom
had been created as a separate body from the CEC [Central Executive Committee]
of the soviets clearly indicates that, Lenin's **State and Revolution**
notwithstanding, the separation of at least the top bodies of the executive
and the legislative wings of the government remained in effect in the new
Soviet system."_ This suggests _"that **State and Revolution** did not play a
decisive role as a source of policy guidelines for 'Leninism in power.'"_
After all, _"immediately after the Revolution the Bolsheviks established an
executive power . . . as a clearly separate body from the leading body of the
legislature. . . Therefore, some sections of the contemporary Left appear to
have greatly overestimated the importance that **State and Revolution** had
for Lenin's government. I would suggest that this document . . . can be better
understood as a distant, although doubtless sincere [!], socio-political
vision . . . as opposed to its having been a programmatic political statement,
let alone a guide to action, for the period immediately after the successful
seizure of power."_ [Farber, **Op. Cit.**, pp. 20-1 and p. 38]

That is **one** way of looking at it. Another would be to draw the conclusion
that a _"distant . . . socio-political vision"_ drawn up to sound like a
_"guide to action"_ which was then immediately ignored is, at worse, little
more than a deception, or, at best, a theoretical justification for seizing
power in the face of orthodox Marxist dogma. Whatever the rationale for Lenin
writing his book, one thing is true -- it was never implemented. Strange,
then, that Leninists today urge use to read it to see what "Lenin really
wanted." Particularly given that so few of its promises were actually
implemented (those that were just recognised the facts on the ground) and
**all** of were no longer applied in less than six months after the seize of
power.

The best that can be said is that Lenin did want this vision to be applied but
the realities of revolutionary Russia, the objective problems facing the
revolution, made its application impossible. This is the standard Leninist
account of the revolution. They seem unconcerned that they have just admitted
that Lenin's ideas were utterly impractical for the real problems that any
revolution is most likely to face. This was the conclusion Lenin himself drew,
as did the rest of the Bolshevik leadership. This can be seen from the actual
practice of "Leninism in power" and the arguments it used. And yet, for some
reason, Lenin's book is still recommended by modern Leninists!

## 5 Did the Bolsheviks really aim for Soviet power?

It seems a truism for modern day Leninists that the Bolsheviks stood for
"soviet power." For example, they like to note that the Bolsheviks used the
slogan _"All Power to the Soviets"_ in 1917 as evidence. However, for the
Bolsheviks this slogan had a radically different meaning to what many people
would consider it to mean.

As we discuss in [section 25](append41.html#app25), it was the anarchists (and
those close to them, like the SR-Maximalists) who first raised the idea of
soviets as the means by which the masses could run society. This was during
the 1905 revolution. At that time, neither the Mensheviks nor the Bolsheviks
viewed the soviets as the possible framework of a socialist society. This was
still the case in 1917, until Lenin returned to Russia and convinced the
Bolshevik Party that the time was right to raise the slogan _"All Power to the
Soviets."_

However, as well as this, Lenin also advocated a somewhat different vision of
what a Bolshevik revolution would result in. Thus we find Lenin in 1917
continually repeating the basic idea: _"The Bolsheviks must assume power."_
The Bolsheviks _"can and **must** take state power into their own hands."_ He
raised the question of _"will the Bolsheviks dare take over full state power
alone?"_ and answered it: _"I have already had occasion . . . to answer this
question in the affirmative."_ Moreover, _"a political party . . . would have
no right to exist, would be unworthy of the name of party . . . if it refused
to take power when opportunity offers."_ [**Selected Works**, vol. 2, p 328,
p. 329 and p. 352]

He equated party power with popular power: _"the power of the Bolsheviks --
that is, the power of the proletariat."_ Moreover, he argued that Russia _"was
ruled by 130,000 landowners . . . and they tell us that Russia will not be
able to be governed by the 240,000 members of the Bolshevik Party -- governing
in the interest of the poor and against the rich."_ He stresses that the
Bolsheviks _"are not Utopians. We know that just any labourer or any cook
would be incapable of taking over immediately the administration of the
State."_ Therefore they _"demand that the teaching should be conducted by the
class-consciousness workers and soldiers, that this should be started
immediately."_ Until then, the _"conscious workers must be in control."_
[**Will the Bolsheviks Maintain Power?** p. 102, pp. 61-62, p. 66 and p. 68]

As such, given this clear and unambiguous position throughout 1917 by Lenin,
it seems incredulous, to say the least, for Leninist Tony Cliff to assert that
_"[t]o start with Lenin spoke of the **proletariat,** the **class** \-- not
the Bolshevik Party -- assuming state power."_ [**Lenin**, vol. 3, p. 161]
Surely the title of one of Lenin's most famous pre-October essays, usually
translated as _"Can the Bolsheviks Retain State Power?"_, should have given
the game away? As would, surely, quoting numerous calls by Lenin for the
Bolsheviks to seize power? Apparently not.

This means, of course, Lenin is admitting that the working class in Russia
would **not** have power under the Bolsheviks. Rather than "the poor"
governing society directly, we would have **the Bolsheviks** governing in
their interests. Thus, rather than soviet power as such, the Bolsheviks aimed
for "party power through the soviets" -- a radically different position. And
as we discuss in the [next section](append41.html#app6), when soviet power
clashed with party power the former was always sacrificed to ensure the
latter. As we indicate in [section H.1.2](secH1.html#sech12), this support for
party power before the revolution was soon transformed into a defence for
party dictatorship after the Bolsheviks had seized power. However, we should
not forget, to quote one historian, that the Bolshevik leaders _"anticipated a
'dictatorship of the proletariat,' and that concept was a good deal closer to
a party dictatorship in Lenin's 1917 usage than revisionist scholars sometimes
suggest."_ [Sheila Fitzpatrick, _"The Legacy of the Civil War,"_ pp. 385-398,
**Party, State, and Society in the Russian Civil War**, Diane P. Koenker,
William G. Rosenberg and Ronald Grigor Suny (eds.), p. 388]

While modern-day Leninists tend to stress the assumption of power by the
soviets as the goal of the Bolshevik revolution, the Bolsheviks themselves
were more honest about it. For example, Trotsky quotes Lenin at the first
soviet congress stating that it was _"not true to say that no party exists
which is ready to assume power; such a party exists: this is our party."_
Moreover, _"[o]ur party is ready to assume power."_ As the Second Congress
approached, Lenin _"rebuked those who connected the uprising with the Second
Congress of the Soviets."_ He protested against Trotsky's argument that they
needed a Bolshevik majority at the Second Congress, arguing (according to
Trotsky) that _"[w]e have to win power and not tie ourselves to the Congress.
It was ridiculous and absurd to warn the enemy about the date of the rising .
. . First the party must seize power, arms in hand, and then we could talk
about the Congress."_ [**On Lenin**, p. 71, p. 85]

Trotsky argued that _"the party could not seize power by itself, independently
of the Soviets and behind its back. This would have been a mistake . . . [as
the] soldiers knew their delegates in the Soviet; it was through the Soviet
that they knew the party. If the uprising had taken place behind the back of
the Soviet, independently of it, without its authority . . . there might have
been a dangerous confusion among the troops."_ Significantly, Trotsky made no
mention of the proletariat. Finally, Lenin came over to Trotsky's position,
saying _"Oh, all right, one can proceed in this fashion as well, provided we
seize power."_ [**Op. Cit.**, p. 86 and p. 89]

Trotsky made similar arguments in his **History of the Russian Revolution**
and his article **Lessons of October**. Discussing the July Days of 1917, for
example, Trotsky discusses whether (to quote the title of the relevant
chapter) _"Could the Bolsheviks have seized the Power in July?"_ and noted, in
passing, the army _"was far from ready to raise an insurrection in order to
give the power to the Bolshevik Party."_ As far as the workers were concerned,
although _"inclining toward the Bolsheviks in its overwhelming majority, had
still not broken the umbilical cord attaching it to the Compromisers"_ and so
the Bolsheviks could not have _"seized the helm in July."_ He then lists other
parts of the country where the soviets were ready to take power. He states
that in _"a majority of provinces and county seats, the situation was
incomparably less favourable"_ simply because the Bolsheviks were not as well
supported. Later he notes that _"[m]any of the provincial soviets had already,
before the July days, become organs of power."_ Thus Trotsky was only
interested in whether the workers could have put the Bolsheviks in power or
not rather than were the soviets able to take power themselves. Party power
was the decisive criteria. [**History of the Russian Revolution**, vol. 2, p.
78, p. 77, p. 78, p. 81 and p. 281]

This can be seen from the October insurrection. Trotsky again admits that the
_"Bolsheviks could have seized power in Petrograd at the beginning of July"_
but _"they could not have held it."_ However, by September the Bolsheviks had
gained majorities in the Petrograd and Moscow soviets. The second Congress of
Soviets was approaching. The time was considered appropriate to think of
insurrection. By in whose name and for what end? Trotsky makes it clear. _"A
revolutionary party is interested in legal coverings,"_ he argued and so the
party could use the defending the second Congress of Soviets as the means to
justify its seizure of power. He raises the question: _"Would it not have been
simpler . . . to summon the insurrection directly in the name of the party?"_
and answers it in the negative. _"It would be an obvious mistake,"_ he argued,
_"to identify the strength of the Bolshevik party with the strength of the
soviets led by it. The latter was much greater than the former. However,
without the former it would have been mere impotence."_ He then quotes
numerous Bolshevik delegates arguing that the masses would follow the soviet,
not the party. Hence the importance of seizing power in the name of the
soviets, regardless of the fact it was the Bolshevik party who would in
practice hold _"all power."_ Trotsky quotes Lenin are asking _"Who is to seize
power?"_ _"That is now of no importance,"_ argued Lenin. _"Let the Military
Revolutionary Committee take it, or 'some other institution,' which will
declare that it will surrender the power only to the genuine representatives
of the interests of the people."_ Trotsky notes that _"some other
institution"_ was a _"conspirative designation for the Central Committee of
the Bolsheviks."_ And who turned out to be the _"genuine representatives of
the interests of the people"_? By amazing co-incidence the Bolsheviks, the
members of whose Central Committee formed the first "soviet" government.
[**Op. Cit.**, vol. 3, p. 265, p. 259, p. 262, p. 263 and p. 267]

As we discuss in [section H.3.11](secH3.html#sech311), Trotsky was simply
repeating the same instrumentalist arguments he had made earlier. Clearly, the
support for the soviets was purely instrumental, simply a means of securing
party power. For Bolshevism, the party was the key institution of proletarian
revolution:

> _ "The party set the soviets in motion, the soviets set in motion the
workers, soldiers, and to some extent the peasantry . . . If you represent
this conducting apparatus as a system of cog-wheels -- a comparison which
Lenin had recourse at another period on another theme -- you may say that the
impatient attempt to connect the party wheel directly with the gigantic wheel
of the masses -- omitting the medium-sized wheel of the soviets -- would have
given rise to the danger of breaking the teeth of the party wheel."_ [Trotsky,
**Op. Cit.**, p. 264]

Thus the soviets existed to allow the party to influence the workers. What of
the workers running society directly? What if the workers reject the decisions
of the party? After all, **before** the revolution Lenin _"more than once
repeated that the masses are far to the left of the party, just as the party
is to the left of the Central Committee."_ [Trotsky, **Op. Cit.**, p. 258]
What happens when the workers refuse to be set in motion by the party but
instead set themselves in motion and reject the Bolsheviks? What then for the
soviets? Looking at the logic of Trotsky's instrumentalist perspective, in
such a case we would predict that the soviets would have to be tamed (by
whatever means possible) in favour of party power (the real goal). And this is
what did happen. The fate of the soviets after October prove that the
Bolsheviks did not, in fact, seek soviet power without doubt (see [next
section](append41.html#app6)). And as we discuss in [section
4](append44.html#app4) of the appendix on ["How did Bolshevik ideology
contribute to the failure of the Revolution?"](append44.html), the peculiar
Bolshevik definition of "soviet power" allowed them to justify the elimination
of from the bottom-up grassroots democracy in the military and in the
workplace with top-down appointments.

Thus we have a distinctly strange meaning by the expression _"All Power to the
Soviets."_ In practice, it meant that the soviets alienate its power to a
Bolshevik government. This is what the Bolsheviks considered as "soviet
power," namely party power, pure and simple. As the Central Committee argued
in November 1917, _"it is impossible to refuse a purely Bolshevik government
without treason to the slogan of the power of the Soviets, since a majority at
the Second All-Russian Congress of Soviets . . . handed power over to this
government."_ [contained in Robert v. Daniels (ed.), **A Documentary History
of Communism**, vol. 1, pp. 128-9] Lenin was clear, arguing mere days after
the October Revolution that _"our present slogan is: No Compromise, i.e. for a
homogeneous Bolshevik government."_ [quoted by Daniels, **Conscience of the
Revolution**, p. 65]

In other words, "soviet power" exists when the soviets hand power over the
someone else (namely the Bolshevik leaders)! The difference is important,
_"for the Anarchists declared, if 'power' really should belong to the soviets,
it could not belong to the Bolshevik party, and if it should belong to that
Party, as the Bolsheviks envisaged, it could not belong to the soviets."_
[Voline, **The Unknown Revolution**, p. 213]

Which means that while anarchists and Leninists both use the expression _"All
Power to the Soviets"_ it does not mean they mean exactly the same thing by
it. In practice the Bolshevik vision simply replaced the power of the soviets
with a "soviet power" above them:

> _ "The success of the Bolsheviks in the October Revolution -- that is to
say, the fact that they found themselves in power and from there subordinated
the whole Revolution to their Party is explained by their ability to
substitute the idea of a Soviet power for the social revolution and the social
emancipation of the masses. A priori, these two ideas appear as non-
contradictory for it was possible to understand Soviet power as the power of
the soviets, and this facilitated the substitution of the idea of Soviet power
for that of the Revolution. Nevertheless, in their realisation and
consequences these ideas were in violent contraction to each other. The
conception of Soviet Power incarnated in the Bolshevik state, was transformed
into an entirely traditional bourgeois power concentrated in a handful of
individuals who subjected to their authority all that was fundamental and most
powerful in the life of the people -- in this particular case, the social
revolution. Therefore, with the help of the 'power of the soviets' -- in which
the Bolsheviks monopolised most of the posts - they effectively attained a
total power and could proclaim their dictatorship throughout the revolutionary
territory . . . All was reduced to a single centre, from where all
instructions emanated concerning the way of life, of thought, of action of the
working masses."_ [Peter Arshinov, **The Two Octobers**]

Isolated from the masses, holding power on their behalf, the Bolshevik party
could not help being influenced by the realities of their position in society
and the social relationships produced by statist forms. Far from being the
servants of the people, they become upon the seizing of power their masters.
As we argue in [section 7](append44.html#app7) of the appendix on ["How did
Bolshevik ideology contribute to the failure of the
Revolution?"](append44.html), the experience of Bolshevism in power confirmed
anarchist fears that the so-called "workers' state" would quickly become a
danger to the revolution, corrupting those who held power and generating a
bureaucracy around the new state bodies which came into conflict with both the
ruling party and the masses. Placed above the people, isolated from them by
centralisation of power, the Bolsheviks pre-revolutionary aim for party power
unsurprising became in practice party dictatorship.

In less than a year, by July 1918, the soviet regime was a **de facto** party
dictatorship. The theoretical revisions soon followed. Lenin, for example, was
proclaiming in early December 1918 that while legalising the Mensheviks the
Bolsheviks would _"reserve state power for ourselves, **and for ourselves
alone.**"_ [**Collected Works**, vol. 28, p. 213] Victor Serge records how
when he arrived in Russia in the following month he discovered _"a colourless
article"_ signed by Zinoviev on _"The Monopoly of Power"_ which said _"Our
Party rules alone . . . it will not allow anyone . . . The false democratic
liberties demanded by the counter-revolution."_ [**Memoirs of a
Revolutionary**, p. 69] Serge, like most Bolsheviks, embraced this perspective
wholeheartedly. For example, when the Bolsheviks published Bakunin's
"confession" to the Tsar in 1921 (in an attempt to discredit anarchism)
_"Serge seized on Bakunin's passage concerning the need for dictatorial rule
in Russia, suggesting that 'already in 1848 Bakunin had presaged Bolshevism.'"
_ [Lawrence D. Orton, _"introduction,"_ **The Confession of Mikhail Bakunin**,
p. 21] At the time Bakunin wrote his "confession" he was not an anarchist. At
the time Serge wrote his comments, he was a leading Bolshevik and reflecting
mainstream Bolshevik ideology.

Indeed, so important was it considered by them, the Bolsheviks revised their
theory of the state to include this particular lesson of their revolution (see
[section H.3.8](secH3.html#sech38) for details). As noted in [section
H.1.2](secH1.html#sech12), all the leading Bolsheviks were talking about the
_"dictatorship of the party"_ and continued to do so until their deaths. Such
a position, incidentally, is hard to square with support for soviet power in
any meaningful term (although it is easy to square with an instrumentalist
position on workers' councils as a means to party power). It was only in the
mid-30s that Serge started to revise his position for this position (Trotsky
still subscribed to it). By the early 1940s, he wrote that _"[a]gainst the
Party the anarchists were right when they inscribed on their black banners,
'There is no worse poison than power' -- meaning absolute power. From now on
the psychosis of power was to captive the great majority of the leadership,
especially at the lower levels."_ [Serge, **Op. Cit.**, p. 100]

Nor can the effects of the civil war explain this shift. As we discuss in the
[next section](append41.html#app6), the Bolshevik assault on the soviets and
their power started in the spring of 1918, months before the start of large
scale civil war. And it should be stressed that the Bolsheviks were not at all
bothered by the creation of party dictatorship over the soviets. Indeed, in
spite of ruling over a one party state Lenin was arguing in November 1918 that
_"Soviet power is a million times more democratic than the most democratic
bourgeois republic."_ How can that be when the workers do not run society nor
have a say in who rules them? When Karl Kautsky raised this issue, Lenin
replied by saying he _"fails to see the **class** nature of the state
apparatus, of the machinery of state . . . The Soviet government is the
**first** in the world . . . to **enlist** the people, specifically the
**exploited** people in the work of administration."_ [**Collected Works**,
vol. 28, p. 247 and p. 248]

However, the key issue is not whether workers take part in the state machinery
but whether they determine the policies that are being implemented, i.e.
whether the masses are running their own lives. After all, as Ante Ciliga
pointed out, the Stalinist GPU (secret police) _"liked to boast of the working
class origin of its henchmen."_ One of his fellow prisoners retorted to such
claims by pointing out they were _"wrong to believe that in the days the Tsar
the gaolers were recruited from among the dukes and the executioners from
among the princes!"_ [**The Russian Engima**, pp. 255-6] Simply put, just
because the state administration is made up of bureaucrats who were originally
working class does not mean that the working class, as a class, manages
society.

In December of that year Lenin went one further and noted that at the Sixth
Soviet Congress _"the Bolsheviks had 97 per cent"_ of delegates, i.e.
"practically all representatives of the workers and peasants of the whole of
Russia." This was proof of _"how stupid and ridiculous is the bourgeois fairy-
tale about the Bolsheviks only having minority support."_ [**Op. Cit.**, pp.
355-6] Given that the workers and peasants had no real choice in who to vote
for, can this result be surprising? Of course not. While the Bolsheviks
**had** mass support a year previously, pointing to election results under a
dictatorship where all other parties and groups are subject to state
repression is hardly convincing evidence for current support. Needless to say,
Stalin (like a host of other dictators) made similar claims on similarly
dubious election results. If the Bolsheviks were sincere in their support for
soviet power then they would have tried to organise genuine soviet elections.
This was possible even during the civil war as the example of the Makhnovists
showed.

So, in a nutshell, the Bolsheviks did not fundamentally support the goal of
soviet power. Rather, they aimed to create a "soviet power," a Bolshevik power
above the soviets which derived its legitimacy from them. However, if the
soviets conflicted with that power, it were the soviets which were repudiated
**not** party power. Thus the result of Bolshevik ideology was the
marginalisation of the soviets and their replacement by Bolshevik
dictatorship. This process started before the civil war and can be traced to
the nature of the state as well as the underlying assumptions of Bolshevik
ideology (see ["How did Bolshevik ideology contribute to the failure of the
Revolution?"](append44.html)).

## 6 What happened to the soviets after October?

As indicated in the last question, the last thing which the Bolsheviks wanted
was _**"all power to the soviets."**_ Rather they wanted the soviets to hand
over that power to a Bolshevik government. As the people in liberal capitalist
politics, the soviets were "sovereign" in name only. They were expected to
delegate power to a government. Like the "sovereign people" of bourgeois
republics, the soviets were much praised but in practice ignored by those with
real power.

In such a situation, we would expect the soviets to play no meaningful role in
the new "workers' state." Under such a centralised system, we would expect the
soviets to become little more than a fig-leaf for party power. Unsurprisingly,
this is **exactly** what they did become. As we discuss in [section
7](append44.html#app7) of the appendix on ["How did Bolshevik ideology
contribute to the failure of the Revolution?"](append44.html), anarchists are
not surprised by this as the centralisation so beloved by Marxists is designed
to empower the few at the centre and marginalise the many at the
circumference.

The very first act of the Bolshevik revolution was for the Second Congress of
Soviets to alienate its power and hand it over to the "Council of People's
Commissars." This was the new government and was totally Bolshevik in make-up
(the Left SRs later joined it, although the Bolsheviks always maintained
control). Thus the first act of the revolution was the creation of a power
**above** the soviets. Although derived from the soviet congress, it was not
identical to it. Thus the Bolshevik "workers' state" or "semi-state" started
to have the same characteristics as the normal state (see [section
H.3.7](secH3.html#sech37) for a discussion of what marks a state).

The subsequent marginalisation of the soviets in the "soviet" state occurred
from top to bottom should not, therefore be considered an accident or a
surprise. The Bolshevik desire for party power within a highly centralised
state could have no other effect. At the top, the Central Executive Committee
(CEC or VTsIK) was quickly marginalised from power. This body was meant to be
the highest organ of soviet power but, in practice, it was sidelined by the
Bolshevik government. This can be seen when, just four days after seizing
power, the Bolshevik Council of People's Commissars (CPC or Sovnarkom)
_"unilaterally arrogated to itself legislative power simply by promulgating a
decree to this effect. This was, effectively, a Bolshevik **coup d'etat** that
made clear the government's (and party's) pre-eminence over the soviets and
their executive organ. Increasingly, the Bolsheviks relied upon the
appointment from above of commissars with plenipotentiary powers, and they
split up and reconstituted fractious Soviets and intimidated political
opponents."_ [Neil Harding, **Leninism**, p. 253] Strange actions for a party
proclaiming it was acting to ensure "All power to the soviets" (as we
discussed in the [last section](append41.html#app5), this was always
considered by Lenin as little more than a slogan to hide the fact that the
party would be in power).

It is doubtful that when readers of Lenin's **State and Revolution** read his
argument for combining legislative and executive powers into one body, they
had this in mind! But then, as we discussed in [section
4](append41.html#app4), that work was never applied in practice so we should
not be too surprised by this turn of events. One thing is sure, four days
after the "soviet" revolution the soviets had been replaced as the effective
power in society by a handful of Bolshevik leaders. So the Bolsheviks
immediately created a power **above** the soviets in the form of the CPC.
Lenin's argument in **The State and Revolution** that, like the Paris Commune,
the workers' state would be based on a fusion of executive and administrative
functions in the hands of the workers' delegates did not last one night. In
reality, the Bolshevik party was the **real** power in "soviet" Russia.

Given that the All-Russian central Executive Committee of Soviets (VTsIK) was
dominated by Bolsheviks, it comes as no surprise to discover it was used to
augment this centralisation of power into the hands of the party. The VTsIK
(_"charged by the October revolution with controlling the government,"_ the
Sovnarkom) was _"used not to control but rather extend the authority and
centralising fiat of the government. That was the work of Iakov Sverdlov, the
VTsIK chairman, who -- in close collaboration with Lenin as chairman of the
Sovnarkom -- ensured that the government decrees and ordinances were by the
VTsIK and that they were thus endowed with Soviet legitimacy when they were
sent to provincial soviet executive committees for transmission to all local
soviets . . . To achieve that, Sverdlov had to reduce the 'Soviet Parliament'
to nothing more than an 'administrative branch' (as Sukhanov put it) of the
Sovnarkom. Using his position as the VTsIK chairman and his tight control over
its praesidium and the large, disciplined and compliant Bolshevik majority in
the plenary assembly, Sverdlov isolated the opposition and rendered it
impotent. So successful was he that, by early December 1917, Sukhanov had
already written off the VTsIK as 'a sorry parody of a revolutionary
parliament,' while for the Bolshevik, Martin Latsis-Zurabs, the VTsIL was not
even a good rubberstamp. Latsis campaigned vigorously in March and April 1918
for the VTsIK's abolition: with its 'idle, long-winded talk and its incapacity
for productive work' the VTsIK merely held up the work of government, he
claimed. And he may have had a point: during the period of 1917 to 1918, the
Sovnarkom issued 474 decrees, the VTsIK a mere 62."_ [Israel Getzler,
**Soviets as Agents of Democratisation**, p. 27]

This process was not an accident. Far from it. In fact, the Bolshevik chairman
Sverdlov knew exactly what he was doing. This included modifying the way the
CEC worked:

> _ "The structure of VTsIK itself began to change under Sverdlov. He began to
use the presidium to circumvent the general meeting, which contained eloquent
minority spokesmen . . . Sverdlov's used of the presidium marked a decisive
change in the status of that body within the soviet hierarchy. In mid-1917 . .
. [the] plenum had directed all activities and ratified bureau decisions which
had a 'particularly important social-political character.' The bureau . . .
served as the executive organ of the VTsIK plenum . . . Only in extraordinary
cases when the bureau could no be convened for technical reason could the
presidium make decisions. Even then such actions remained subject to review by
the plenum."_ [Charles Duval, _"Yakov M. Sverdlov and the All-Russian Central
Executive Committee of Soviets (VTsIK)"_, pp. 3-22, **Soviet Studies**, vol.
XXXI, no. 1, January 1979, pp. 6-7]

Under the Bolsheviks, the presidium was converted _"into the **de facto**
centre of power within VTsIK."_ It _"began to award representations to groups
and factions which supported the government. With the VTsIK becoming ever more
unwieldy in size by the day, the presidium began to expand its activities."_
The presidium was used _"to circumvent general meetings."_ Thus the Bolsheviks
were able _"to increase the power of the presidium, postpone regular sessions,
and present VTsIK with policies which had already been implemented by the
Sovnarkon. Even in the presidium itself very few people determined policy."_
[Charles Duval, **Op. Cit.**, p.7, p. 8 and p. 18]

So, from the very outset, the VTsIK was overshadowed by the "Council of
People's Commissars" (CPC). In the first year, only 68 of 480 decrees issued
by the CPC were actually submitted to the Soviet Central Executive Committee,
and even fewer were actually drafted by it. The VTsIK functions _"were never
clearly delineated, even in the constitution, despite vigorous attempts by the
Left SRs . . . that Lenin never saw this highest soviet organ as the genuine
equal of his cabin and that the Bolsheviks deliberated obstructed efforts at
clarification is [a] convincing"_ conclusion to draw. It should be stressed
that this process started before the outbreak of civil war in late May, 1918.
After that the All-Russian Congress of soviets, which convened every three
months or so during the first year of the revolution, met annually thereafter.
Its elected VTsIK _"also began to meet less frequently, and at the height of
the civil war in late 1918 and throughout 1919, it never once met in full
session."_ [Carmen Sirianni, **Workers' Control and Socialist Democracy**, pp.
203-4]

The marginalisation of the soviets can be seen from the decision on whether to
continue the war against Germany. As Cornelius Castoriadis notes, under Lenin
_"[c]ollectively, the only real instance of power is the Party, and very soon,
only the summits of the Party. Immediately after the seizure of power the
soviets as institutions are reduced to the status of pure window-dressing (we
need only look at the fact that, already at the beginning of 1918 in the
discussions leading up to the Brest-Litovsk Peace Treaty, their role was
absolutely nil)."_ [**The role of Bolshevik Ideology in the birth of the
Bureaucracy**, p. 97] In fact, on the 26th of February, 1918, the Soviet
Executive _"began a survey of 200 local soviets; by 10 March 1918 a majority
(105-95) had come out in favour of a revolutionary war, although the soviets
in the two capitals voted . . . to accept a separate peace."_ [Geoffrey Swain,
**The Origins of the Russian Civil War**, p. 128] This survey was ignored by
the Bolshevik Central Committee which voted 4 against, 4 abstain and 5 for it.
This took Russia out of the Great War but handed over massive areas to
imperialist Germany. The controversial treaty was ratified at the Fourth
Soviet Congress, unsurprisingly as the Bolshevik majority simply followed the
orders of their Central Committee. It would be pointless to go over the
arguments of the rights and wrongs of the decision here, the point is that the
13 members of the Bolshevik Central Committee decided the future faith of
Russia in this vote. The soviets were simply ignored in spite of the fact it
was possible to consult them fully. Clearly, "soviet power" meant little more
than window-dressing for Bolshevik power.

Thus, at the top summits of the state, the soviets had been marginalised by
the Bolsheviks from day one. Far from having "all power" their CEC had given
that to a Bolshevik government. Rather than exercise real power, it's basic
aim was to control those who did exercise it. And the Bolsheviks successfully
acted to undermine even this function.

If this was happening at the top, what was the situation at the grassroots?
Here, too, oligarchic tendencies in the soviets increased post-October, with
_"[e]ffective power in the local soviets relentlessly gravitated to the
executive committees, and especially their presidia. Plenary sessions became
increasingly symbolic and ineffectual."_ The party was _"successful in gaining
control of soviet executives in the cities and at **uezd** and **guberniya**
levels. These executive bodies were usually able to control soviet congresses,
though the party often disbanded congresses that opposed major aspects of
current policies."_ Local soviets _"had little input into the formation of
national policy" and "[e]ven at higher levels, institutional power shifted
away from the soviets."_ [C. Sirianni, **Op. Cit.**, p. 204 and p. 203] The
soviets quickly had become rubber-stamps for the Communist government, with
the Soviet Constitution of 1918 codifying the centralisation of power and top-
down decision making. Local soviets were expected to _"carry out all orders of
the respective higher organs of the soviet power"_ (i.e. to carry out the
commands of the central government).

This was not all. While having popular support in October 1917, the realities
of "Leninism in power" soon saw a backlash develop. The Bolsheviks started to
loose popular support to opposition groups like the Mensheviks and SRs (left
and right). This growing opposition was reflected in two ways. Firstly, a rise
in working class protests in the form of strikes and independent
organisations. Secondly, there was a rise in votes for the opposition parties
in soviet elections. Faced with this, the Bolsheviks responded in three ways,
delaying elections. gerrymandering or force. We will discuss each in turn.

Lenin argued in mid-April 1918 that the _"socialist character of Soviet, i.e.
**proletarian**, democracy"_ lies, in part, in because _"the people themselves
determine the order and time of elections."_ [**The Immediate Tasks of the
Soviet Government**, pp. 36-7] However, the reality in the grassroots was
somewhat different. There _"the government [was] continually postponed the new
general elections to the Petrograd Soviet, the term of which had ended in
March 1918"_ because it _"feared that the opposition parties would show gains.
This fear was well founded since in the period immediately preceding 25
January, in those Petrograd factories where the workers had decided to hold
new elections, the Mensheviks, SRs, and non-affiliated candidates had won
about half the seats."_ [Samuel Farber, **Before Stalinism**, p. 22] In
Yaroslavl, the _more the Bolsheviks tried to postpone the elections, the more
the idea of holding new elections became an issue itself."_ When the
Bolsheviks gave in and held elections in early April, the Mensheviks won 47 of
the 98 seats, the Bolsheviks 38 and the SRs 13. [_"The Mensheviks' Political
Comeback: The Elections to the Provincial City Soviets in Spring 1918"_, **The
Russian Review**, vol. 42, pp. 1-50, p. 18] The fate of the Yaroslavl soviet
will be discussed shorted. As Geoffrey Swain summaries, Menshevik and SR
_"successes in recalling Bolshevik delegates from the soviets had forced the
Bolsheviks increasingly to delay by-elections."_ [**The Origins of the Russian
Civil War**, p. 91]

As well as postponing elections and recall, the Bolsheviks also quickly turned
to gerrymandering the soviets to ensure the stability of their majority in the
soviets. In this they made use of certain institutional problems the soviets
had had from the start. On the day which the Petrograd soviet was formed in
1917, the Bolshevik Shlyapnikov _"proposed that each socialist party should
have the right to two seats in the provisional executive committee of the
soviet."_ This was _"designed, initially, to give the Bolsheviks a decent
showing, for they were only a small minority of the initiating group."_ It was
agreed. However, the _"result was that members of a dozen different parties
and organisations (trades unions, co-operative movements, etc.) entered the
executive committee. They called themselves 'representatives' (of their
organisations) and, by virtue of this, they speedily eliminated from their
discussions the committee members chosen by the general assembly although they
were the true founders of the Soviet."_ This meant, for example, Bolshevik co-
founders of the soviet made way for such people as Kamenev and Stalin. Thus
the make-up of the soviet executive committee was decided upon by _"the
leadership of each organisation, its executive officers, and not with the
[soviet] assembly. The assembly had lost its right to control."_ Thus, for
example, the Bolshevik central committee member Yoffe became the presidium of
the soviet of district committees without being elected by anyone represented
at those soviets. _"After October, the Bolsheviks were more systematic in
their use of these methods, but there was a difference: there were now no
truly free elections that might have put a brake to a procedure that could
only benefit the Bolshevik party."_ [Marc Ferro, **October 1917**, p. 191 and
p. 195]

The effects of this can be seen in Petrograd soviet elections of June 1918. In
these the Bolsheviks _"lost the absolute majority in the soviet they had
previously enjoyed"_ but remained its largest party. However, the results of
these elections were irrelevant. This was because _"under regulations prepared
by the Bolsheviks and adopted by the 'old' Petrograd soviet, more than half of
the projected 700-plus deputies in the 'new' soviet were to be elected by the
Bolshevik-dominated district soviets, trade unions, factory committees, Red
Army and naval units, and district worker conferences: thus, the Bolsheviks
were assured of a solid majority even before factory voting began."_
[Alexander Rabinowitch, **Early Disenchantment with Bolshevik Rule**, p. 45]
To be specific, the number of delegates elected directly from the workplace
made up a mere third of the new soviet (i.e. only 260 of the 700 plus deputies
in the new soviet were elected directly from the factories): _"It was this
arbitrary 'stacking' of the new soviet, much more than election of 'dead
souls' from shut-down factories, unfair campaign practices, falsification of
the vote, or direct repression, that gave the Bolsheviks an unfair advantage
in the contest."_ [Alexander Rabinowitch, **The Petrograd First City District
Soviet during the Civil War**, p. 140]

In other words, the Bolsheviks gerrymandered and packed soviets to remain in
power, so distorting the soviet structure to ensure Bolshevik dominance. This
practice seems to have been commonplace. In Saratov, as in Petrograd, _"the
Bolsheviks, fearing that they would lose elections, changed the electoral
rules . . . in addition to the delegates elected directly at the factories,
the trade unions -- but only those in favour of soviet power, in other words
supporters of the Bolsheviks and Left SRs -- were given representation.
Similarly, the political parties supporting Soviet power automatically
received twenty-five seats in the soviets. Needless to say, these rules
heavily favoured the ruling parties"_ as the Mensheviks and SRs _"were
regarded by the Bolsheviks as being against Soviet power."_ [Brovkin, **Op.
Cit.**, p. 30]

A similar situation existed in Moscow. For example, the largest single union
in the soviet in 1920 was that of soviet employees with 140 deputies (9% of
the total), followed by the metal workers with 121 (8%). In total, the
bureaucracies of the four biggest trade unions had 29.5% of delegates in the
Moscow soviet. This packing of the soviet by the trade union bureaucracy
existed in 1918 as well, ensuring the Bolsheviks were insulated from popular
opposition and the recall of workplace delegates by their electors. Another
form of gerrymandering was uniting areas of Bolshevik strength _"for electoral
purposes with places where they were weak, such as the creation of a single
constituency out of the Moscow food administration (MPO) and the Cheka in
February 1920."_ [Richard Sakwa, **Soviet Communists in Power**, p. 179 and p.
178]

However, this activity was mild compared to the Bolshevik response to soviet
elections which did not go their way. According to one historian, by the
spring of 1918 _"Menshevik newspapers and activists in the trade unions, the
Soviets, and the factories had made a considerable impact on a working class
which was becoming increasingly disillusioned with the Bolshevik regime, so
much so that in many places the Bolsheviks felt constrained to dissolve
Soviets or prevent re-elections where Mensheviks and Socialist Revolutionaries
had gained majorities."_ [Israel Getzler, **Martov**, p. 179] This is
confirmed by other sources. _"By the middle of 1918,"_ notes Leonard Schapiro,
_"the Mensheviks could claim with some justification that large numbers of the
industrial working class were now behind them, and that for the systematic
dispersal and packing of the soviets, and the mass arrests at workers'
meetings and congresses, their party could eventually have won power by its
policy of constitutional opposition. In the elections to the soviets which
were taking place in the spring of 1918 throughout Russia, arrests, military
dispersal, even shootings followed whenever Mensheviks succeeded in winning
majorities or a substantial representation."_ [**The Origin of the Communist
Autocracy**, p. 191]

For example, the Mensheviks _"made something of a comeback about Saratov
workers in the spring of 1918, for which the Bolsheviks expelled them from the
soviet."_ [Donald J. Raleigh, **Experiencing Russia's Civil War**, p. 187]
Izhevsk, a town of 100,000 with an armaments industry which was the main
suppliers of rifles to the Tzar's Army, experienced a swing to the left by the
time of the October revolution. The Bolsheviks and SR-Maximalists became the
majority and with a vote 92 to 58 for the soviet to assume power. After a
revolt by SR-Maximalist Red Guards against the Bolshevik plans for a
centralised Red Army in April, 1918, the Bolsheviks became the sole power.
However, in the May elections the Mensheviks and [right] SRs _"experienced a
dramatic revival"_ and for _"the first time since September 1917, these two
parties constituted a majority in the Soviet by winning seventy of 135
seats."_ The Bolsheviks _"simply refused to acquiesce to the popular mandate
of the Mensheviks and Socialist Revolutionaries."_ In June, the Bolshevik
leadership _"appealed to the Karzan' Soviet . . . for assistance."_ The troops
sent along with the Bolshevik dominated Red Guards _"abrogated the results of
the May and June elections"_ and imprisoned the SR and Menshevik soviet
delegates. The summer of 1918 also saw victories for the SRs and Mensheviks in
the soviet elections in Votkinsk, a steel town near Izhevsk. _"As in Izhevsk
the Bolsheviks voided the elections."_ [Stephan M. Merk, _"The 'Class-Tragedy'
of Izhevsk: Working Class Opposition to Bolshevism in 1918"_, pp. 176-90,
**Russian History**, vol. 2, no. 2, p. 181 and p. 186]

However, the most in depth account of this destruction of soviet is found in
the research of Vladimir Brovkin. According to him, there _"are three
factors"_ which emerge from the soviet election results in the spring of 1918.
These are, firstly, _"the impressive success of the Menshevik-SR opposition"_
in those elections in all regions in European Russia. The second _"is the
Bolshevik practice of outright disbandment of the Menshevik-SR-controlled
soviets. The third is the subsequent wave of anti-Bolshevik uprisings."_ In
fact, _"in all provincial capitals of European Russia where elections were
held on which there are data, the Mensheviks and the SRs won majorities on the
city soviets in the spring of 1918."_ Brovkin stresses that the _"process of
the Menshevik-SR electoral victories threatened Bolshevik power. That is why
in the course of the spring and summer of 1918, the soviet assemblies were
disbanded in most cities and villages. To stay in power, the Bolsheviks had to
destroy the soviets. . . These steps generated a far-reaching transformation
in the soviet system, which remained 'soviet' in name only."_ Brovkin presents
accounts from numerous towns and cities. As an example, he discusses Tver'
where the _"escalation of political tensions followed the already familiar
pattern"_ as the _"victory of the opposition at the polls"_ in April 1918
_"brought about an intensification of the Bolshevik repression. Strikes,
protests, and marches in Tver' lead to the imposition of martial law."_
[Brovkin, **Op. Cit.**, p. 46, p. 47, p. 48 and p. 11] Thus Bolshevik armed
force not only overthrew the election results, it also suppressed working
class protest against such actions. (Brovkin's book **The Mensheviks after
October** contains the same information as his article).

This Bolshevik attack on the soviets usually started with attempts to stop new
elections. For example, after a demonstration in Petrograd in favour of the
Constituent Assembly was repressed by the Bolsheviks in mid-January 1918,
calls for new elections to the soviet occurred in many factories. _"Despite
the efforts of the Bolsheviks and the Factory Committees they controlled, the
movement for new elections to the soviet spread to more than twenty factories
by early February and resulted in the election of fifty delegates: thirty-six
SRs, seven Mensheviks and seven non-party."_ However, the Bolsheviks
_"unwillingness to recognise the elections and to seat new delegates pushed a
group of Socialists to . . . lay plans for an alternative workers' forum . . .
what was later to become the Assembly of Workers' Plenipotentiaries."_ [Scott
Smith, _"The Social-Revolutionaries and the Dilemma of Civil War"_, **The
Bolsheviks in Russian Society**, pp. 83-104, Vladimir N. Brovkin (Ed.), pp.
85-86] This forum, like all forms of working class protest, was crushed by the
Bolshevik state. By the time the elections were held, in June 1918, the civil
war had started (undoubtedly favouring the Bolsheviks) and the Bolsheviks had
secured their majority by packing the soviet with non-workplace
"representatives."

In Tula, again in the spring of 1918, local Bolsheviks reported to the
Bolshevik Central Committee that the _"Bolshevik deputies began to be recalled
one after another . . . our situation became shakier with passing day. We were
forced to block new elections to the soviet and even not to recognise them
where they had taken place not in our favour."_ In the end, the local party
leader was forced to abolish the city soviet and to vest power in the
Provincial Executive Committee. This refused to convene a plenum of the city
soviet for more than two months, knowing that newly elected delegates were
non-Bolshevik. [Smith, **Op. Cit.**, p. 87]

In Yaroslavl', the newly elected soviet convened on April 9th, 1918, and when
it elected a Menshevik chairman, _"the Bolshevik delegation walked out and
declared the soviet dissolved. In response, workers in the city went out on
strike, which the Bolsheviks answered by arresting the strike committee and
threatening to dismiss the strikers and replace them with unemployed
workers."_ This failed and the Bolsheviks were forced to hold new elections,
which they lost. Then _"the Bolsheviks dissolved this soviet as well and
places the city under martial law."_ A similar event occurred in Riazan'
(again in April) and, again, the Bolsheviks _"promptly dissolved the soviet
and declared a dictatorship under a Military-Revolutionary Committee."_ [**Op.
Cit.**, pp. 88-9]

The opposition parties raised such issues at the All-Russian Central Executive
Committee of Soviets (VTsIK), to little avail. On the 11th of April, one
_"protested that non-Bolshevik controlled soviets were being dispersed by
armed force, and wanted to discuss the issue."_ The chairman _"refus[ed] to
include it in the agenda because of lack of supporting material"_ and such
information be submitted to the presidium of the soviet. The majority (i.e.
the Bolsheviks) _"supported their chairman"_ and the facts were _"submitted .
. . to the presidium, where they apparently remained."_ It should be noted
that the _"same fate befell attempts to challenge the arrests of Moscow
anarchists by the government on 12 April."_ The chairman's _"handling of the
anarchist matter ended its serious discussion in the VTsIK."_ [Charles Duval,
**Op. Cit.**, pp. 13-14] Given that the VTsIK was **meant** to be the highest
soviet body between congresses, the lack of concern for Bolshevik repression
against soviets and opposition groups clearly shows the Bolshevik contempt for
soviet democracy.

Needless to say, this destruction of soviet democracy continued during the
civil war. For example, the Bolsheviks simply rejected the voice of people and
would refuse to accept an election result. Emma Goldman attended an election
meeting of bakers in Moscow in March, 1920. _"It was,"_ she said, _"the most
exciting gathering I had witnessed in Russia."_ However the _"chosen
representative, an Anarchist, had been refused his mandate by the Soviet
authorities. It was the third time the workers gathered to re-elect their
delegate . . . and every time they elected the same man. The Communist
candidate opposing him was Semashko, the Commissar of the Department of Health
. . . [who] raved against the workers for choosing a non-Communist, called
anathema upon their heads, and threatened them with the Tcheka and the
curtailment of their rations. But he had no effect on the audience except to
emphasise their opposition to him, and to arouse antagonism against the party
he represented. The workers' choice was repudiated by the authorities by the
authorities and later even arrested and imprisoned."_ After a hunger strike,
they were released. In spite of chekists with loaded guns attending union
meetings, the bakers _"would not be intimidated"_ and threatened a strike
unless they were permitted to elect their own candidate. This ensured the
bakers' demands were met. [**My Disillusionment in Russia**, pp. 88-9]

Unsurprisingly, _"there is a mass of evidence to support the Menshevik
accusations of electoral malpractice"_ during elections in May 1920. And in
spite of Menshevik _"declaration of support for the Soviet regime against the
Poles"_ the party was _"still subject to harassment."_ [Skawa, **Op. Cit.**,
p. 178]

This gerrymandering was not limited to just local soviets. The Bolsheviks used
it at the fifth soviet congress as well.

First, it should be noted that in the run up to the congress, _"on 14 June
1918, they expelled Martov and his five Mensheviks together with the Socialist
Revolutionaries from the Central Executive Committee, closed down their
newspapers . . and drove them underground, just on the eve of the elections to
the Fifth Congress of Soviets in which the Mensheviks were expected to make
significant gains."_ [Israel Getzler, **Martov**, p. 181] The rationale for
this action was the claim that the Mensheviks had taken part in anti-soviet
rebellions (as we discuss in [section 23](append41.html#app23), this was not
true). The action was opposed by the Left SRs, who correctly questioned the
legality of the Bolshevik expulsion of opposition groupings. They _"branded
the proposed expulsion bill illegal, since the Mensheviks and SRs had been
sent to the CEC by the Congress of Soviets, and only the next congress had the
right to withdraw their representation. Furthermore, the Bolsheviks had no
right to pose as defenders of the soviets against the alleged SR counter-
revolution when they themselves has been disbanding the peasants' soviets and
creating the committees of the poor to replace them."_ [Brovkin, **The
Mensheviks After October**, p. 231] When the vote was taken, only the
Bolsheviks supported it. Their votes were sufficient to pass it.

Given that the Mensheviks had been winning soviet elections across Russia, it
is clear that this action was driven far more by political needs than the
truth. This resulted in the Left Social Revolutionaries (LSRs) as the only
significant party left in the run up to the fifth Congress. The LSR author
(and ex-commissar for justice in the only coalition soviet government) of the
only biography of LSR leader (and long standing revolutionary who suffered
torture and imprisonment in her fight against Tsarism) Maria Spiridonova
states that _"[b]etween 900 and 100 delegates were present. Officially the LSR
numbered 40 percent of the delegates. They own opinion was that their number
were even higher. The Bolsheviks strove to keep their majority by all the
means in their power."_ He quotes Spiridonova's address to the Congress: _"You
may have a majority in this congress, but you do have not a majority in the
country."_ [I. Steinberg, **Spiridonova**, p. 209]

Historian Geoffrey Swain indicates that the LSRs had a point:

> _ "Up to the very last minute the Left SRs had been confident that, as the
voice of Russia's peasant masses, they would receive a majority when the Fifth
Congress of Soviets assembled . . . which would enable them to deprive Lenin
of power and launch a revolutionary war against Germany. Between April and the
end of June 1918 membership of their party had almost doubled, from 60,000 to
100,000, and to prevent them securing a majority at the congress Lenin was
forced to rely on dubious procedures: he allowed so-called committees of poor
peasants to be represented at the congress. Thus as late as 3 July 1918
returns suggested a majority for the Left SRs, but a Congress of Committees of
Poor Peasants held in Petrograd the same day 'redressed the balance in favour
of the Bolsheviks,' to quote the **Guardian**'s Philips-Price, by deciding it
had the right to represent the all those districts where local soviets had not
been 'cleansed of kulak elements and had not delivered the amount of food laid
down in the requisitioning lists of the Committees of Poor Peasants.' This
blatant gerrymandering ensured a Bolshevik majority at the Fifth Congress of
Soviets."_ [**The Origins of the Russian Civil War**, p. 176]

Historian Alexander Rabinowitch confirms this gerrymandering. As he put it, by
the summer of 1918 _"popular disenchantment with Bolshevik rule was already
well advanced, not only in rural but also in urban Russia"_ and the _"primary
beneficiaries of this nationwide grass-roots shift in public opinion were the
Left SRs. During the second half of June 1918, it was an open question which
of the two parties would have a majority at the Fifth All-Russian Congress of
Soviets . . . On the evening of 4 July, virtually from the moment the Fifth
Congress of Soviets opened in Moscow's Bolshoi Theatre, it was clear to the
Left SRs that the Bolsheviks had effectively 'fabricated' a sizeable majority
in the congress and consequently, that there was no hope whatever of utilising
it to force a fundamental change in the government's pro-German, anti-peasant
policies."_ While he acknowledges that an _"exact breakdown of properly
elected delegates may be impossible to ascertain"_ it was possible (_"based on
substantial but incomplete archival evidence"_) to conclude that _"it is quite
clear that the Bolshevik majority was artificially inflated and highly
suspect."_ He quotes the report of one leading LSR, based on data from LSR
members of the congress's Credentials Committee, saying that the Bolsheviks
_"conjured up"_ 299 voting delegates. _"The Bible tells us,"_ noted the
report's author, _"that God created the heavens and the earth from nothing . .
. In the twentieth century the Bolsheviks are capable of no lesser miracles:
out of nothing, they create legitimate credentials."_ [_"Maria Spiridonova's
'Last Testament'"_, **The Russian Review**, pp. 424-46, vol. 54, July 1995, p.
426]

This gerrymandering played a key role in the subsequent events. _"Deprived of
their democratic majority,"_ Swain notes, _"the Left SRs resorted to terror
and assassinated the German ambassador Mirbach."_ [Swain, **Op. Cit.**, p.
176] The LSR assassination of Mirbach and the events which followed were soon
labelled by the Bolsheviks an _"uprising"_ against "soviet power" (see
[section 23](append41.html#app23) for more details). Lenin _"decided that the
killing of Mirbach provided a fortuitous opportunity to put an end to the
growing Left SR threat."_ [Rabinowitch, **Op. Cit.**, p. 427] After this, the
LSRs followed the Mensheviks and Right SRs and were expelled from the soviets.
This in spite of the fact that the rank and file knew nothing of the plans of
the central committees and that their soviet delegates had been elected by the
masses. The Bolsheviks had finally eliminated the last of their more left-wing
opponents (the anarchists had been dealt with the in April, see [section
24](append41.html#app24) for details).

As discussed in [section 21](append41.html#app21), the Committees of Poor
Peasants were only supported by the Bolsheviks. Indeed, the Left SRs opposed
then as being utterly counter-productive and an example of Bolshevik ignorance
of village life. Consequently, we can say that the "delegates" from the
committees were Bolsheviks or at least Bolshevik supporters. Significantly, by
early 1919 Lenin admitted the Committees were failures and ordered them
disbanded. The new policy reflected Left SR arguments against the Committees.
It is hard not to concur with Vladimir Brovkin that by _"establishing the
committees of the poor to replace the [rural] soviets . . . the Bolsheviks
were trying to create some institutional leverage of their own in the
countryside for use against the SRs. In this light, the Bolshevik measures
against the Menshevik-led city soviets . . . and against SR-led village
soviets may be seen as a two-pronged attempt to stem the tide that threatened
to leave them in the minority at the Fifth Congress of Soviets."_ [**The
Mensheviks after October**, p. 226]

Thus, by July 1918, the Bolsheviks had effectively secured a monopoly of
political power in Russia. When the Bolsheviks (rightly, if hypocritically)
disbanded the Constituent Assembly in January 1918, they had claimed that the
soviets (rightly) represented a superior form of democracy. Once they started
losing soviet elections, they could find no better way to "secure" workers'
democracy than to destroy it by gerrymandering soviets, disbanding them and
expelling opposition parties from them. All peaceful attempts to replace them
had been destroyed. The soviet CEC was marginalised and without any real
power. Opposition parties had been repressed, usually on little or no
evidence. The power of the soviets had been replaced by a soviet power in less
than a year. However, this was simply the culmination of a process which had
started when the Bolsheviks seized power in November 1917. Simply put, the
Bolsheviks had always aimed for "all power to the party via the soviets" and
once this had been achieved, the soviets could be dispensed with. Maurice
Brinton simply stated the obvious when he wrote that _"when institutions such
as the soviets could no longer be influenced by ordinary workers, the regime
could no longer be called a soviet regime."_ [**The Bolsheviks and Workers'
Control**, p. xiii] By this obvious criteria, the Bolshevik regime was no
longer soviet by the spring of 1918, i.e. before the outbreak of civil war.
While opposition groups were not finally driven out of the soviets until 1923
(i.e. three years **after** the end of the civil war) their presence _"does
not indicate the existence of a multi-party system since they in no way
threatened the dominating role of the Bolsheviks, and they had not done so
from mid-1918."_ [Richard Sakwa, **Op. Cit.**, p. 168]

Tony Cliff, leader of the British Leninist party the SWP, justified the
repression of the Mensheviks and SRs on the grounds that they were not
prepared to accept the Soviet system and rejected the role of _"constitutional
opposition."_ He tries to move forward the repression until after the outbreak
of full civil war by stating that _"[d]espite their strong opposition to the
government, for some time, i.e. until after the armed uprising of the
Czechoslovakian Legion [in late May, 1918] -- the Mensheviks were not much
hampered in their propaganda work."_ If having papers banned every now and
then, members arrested and soviets being disbanded as soon as they get a
Menshevik majority is _"not much hampered"_ then Cliff does seem to be giving
that phrase a new meaning. Similarly, Cliff's claim that the _"civil war
undermined the operation of the local soviets"_ also seems lacking based on
this new research. [**Lenin: Revolution Besieged**, vol. 3, p. 163, p. 167 and
p. 150]

However, the Bolshevik assault on the soviets started during the spring of
1918 (i.e. in March, April and May). That is **before** the Czech rising and
the onset of full scale civil war which occurred in late May (see [section
3](append43.html#app3) of the appendix on ["What caused the degeneration of
the Russian Revolution?"](append43.html) on Bolshevik repression before the
Czech revolt). Nor is it true that the Mensheviks rejected constitutional
methods. Though they wished to see a re-convocation of the Constituent
Assembly they believed that the only way to do this was by winning a majority
of the soviets (see [section 23](append41.html#app23)). Clearly, attempts to
blame the Civil War for the elimination of soviet power and democracy seems
woefully weak given the actions of the Bolsheviks in the spring of 1918. And,
equally clearly, the reduction of local soviet influence cannot be fully
understood without factoring in the Bolshevik prejudice in favour of
centralisation (as codified in the Soviet Constitution of 1918) along with
this direct repression.

The simple fact is that the soviets were marginalised and undermined after the
October Revolution simply because they **did** reflect the wishes of the
working class, in spite of their defects (defects the Bolsheviks exploited to
consolidate their power). The problem was that the workers no longer supported
Lenin. Few Leninists would support such an obvious conclusion. For example,
John Rees states that _"[i]n the cities the Reds enjoyed the fierce and
virtually undivided loyalty of the masses throughout the civil war period."_
[_"In Defence of October"_, pp. 3-82, **International Socialism**, no. 52, p.
47] Which, of course, explains the vast number of strikes and protests
directed against the Bolshevik regime and the workers' resolutions calling its
end! It also explains why the Bolsheviks, in the face of such _"undivided
loyalty"_, had to suppress opposition parties and impose a party dictatorship!

Simply put, **if** the Bolsheviks did have the support Rees states they did
then they had no need to repress soviet democracy and opposition parties. Such
_"fierce"_ loyalty would not have been amenable to opposition arguments.
Strange, then, that the Bolsheviks continually explained working class unrest
in terms of the influence of Mensheviks, Left SRs and so on during the civil
war. Moreover, Rees contradicts himself by arguing that if the Kronstadt
revolt had succeeded, then it would have resulted in _"the fall of the
Bolsheviks."_ [**Op. Cit.**, p. 63] Now, given that the Kronstadt revolt
called for free soviet elections (and **not** _"soviets without parties"_ as
Rees asserts), why did the Bolsheviks not agree to them (at least in the
cities)? If, as Rees argues, the Reds had the fierce loyalty of the city
workers, then why did the Bolsheviks not introduce soviet democracy in the
cities after the end of the Civil War? Simply because they knew that such
"loyalty" did not, in fact, exist. Zinoviev, for example, declared that the
Bolsheviks' support had been reduced to 1 per cent in early 1920. [Farber,
**Before Stalinism**, p. 188]

So much for working class "loyalty" to the Bolsheviks. And, needless to say,
Rees' comments totally ignore the election results **before** the start of the
civil war which prompted the Bolsheviks to pack or disband soviets. As
Bertrand Russell summarised from his experiences in Lenin's Russia during the
civil war (in 1920): _"No conceivable system of free elections would give
majorities to the Communists, either in the town or country."_ [**The Practice
and Theory of Bolshevism**, pp. 40-1] Thus we have a major contradiction in
the pro-Leninist argument. On the one hand, they stress that the workers
supported the Bolsheviks wholeheartedly during the civil war. On the other,
they argue that party dictatorship had to be imposed. If the Bolsheviks had
the support they claimed they had, then they would have won soviet elections
easily. They did not and so free soviet elections were not held.

This fact also explains the fate of the so-called _"non party"_ conferences
favoured by the Bolsheviks in late 1920. In spite of praising the soviets as
_"more democratic"_ than anything in the _"best democratic republics of the
bourgeois world,"_ Lenin also argued that non-Party conferences were also
required _"to be able to watch the mood of the masses, to come closer to them,
to respond to their demands."_ [**Left-Wing Communism**, p. 33 and p. 32] If
the soviets were as democratic as Lenin claimed, then the Bolsheviks would
have no need of "non-party" conferences. Significantly, the Bolsheviks
"responded" to these conferences and "their demands" by disbanding them. This
was because _"[d]uring the disturbances"_ of late 1920, _"they provided an
effective platform for criticism of Bolshevik policies."_ Their frequency was
decreased and they "were discontinued soon afterward." [Richard Sakwa,
**Soviet Communists in Power**, p. 203] In other words, they meet the same
fate as the soviets in the spring and summer of 1918.

Perhaps we should not be too surprised by these developments. After all, as we
discuss in [section 8](append44.html#app8) of the appendix on ["How did
Bolshevik ideology contribute to the failure of the
Revolution?"](append44.html), the Bolsheviks had long had a distinctly
undemocratic political ideology. Their support for democratic norms were less
than consistent. The one thing they **were** consistent was their hypocrisy.
Thus democratic decisions were to be binding on their opponents (even if that
majority had to be manipulated into being) but not upon them. Before the
revolution Lenin had openly espoused a double standard of discipline. _"We
will not permit,"_ he argued, _"the idea of unity to tie a noose around our
necks, and we shall under no circumstances permit the Mensheviks to lead us by
the rope."_ [quoted by Robert V. Daniels, **The Conscience of the
Revolution**, p. 17] Once in power, their political perspectives had little
trouble ignoring the will of the working class when it classed with what they,
as that class's self-proclaimed vanguard, had decided what was in its best
interests. As we discussed in [section H.5](secH5.html), such a autocratic
perspective is at the heart of vanguardism. If you aim for party power, it
comes as no surprise that the organs used to achieve it will wither under it.
Just as muscles only remain strong if you use them, so soviets can only work
if it is used to run society, not nominate the handful of party leaders who
do. As Kropotkin argued in 1920:

> _ "The idea of soviets . . . of councils of workers and peasants . . .
controlling the economic and political life of the country is a great idea.
All the more so, since it necessarily follows that these councils should be
composed of all who take part in the production of natural wealth by their own
efforts. _

>

> _"But as long as the country is governed by a party dictatorship, the
workers' and peasants' councils evidently lose their entire significance. They
are reduced to . . . [a] passive role . . . A council of workers ceases to be
free and of any use when liberty of the press no longer exists . . . [and
they] lose their significance when the elections are not preceded by a free
electoral campaign, and when the elections are conducted under pressure of a
party dictatorship . . . It means the death-knell of the new system."_
[**Kropotkin's Revolutionary Pamphlets**, pp. 254-5]

Clearly, the fate of the soviets after October shows the dangers of Bolshevism
to popular self-management and autonomy. We should be try and learn the
lessons from the experience rather than, as pro-Bolsheviks do, rationalise and
justify the usurpation of power by the party. The most obvious lesson to learn
is to oppose the creation of any power **above** the soviets. This was not
lost on Russian anarchists active in the revolution. For this reason, anarcho-
syndicalists resolved, in August 1918, that they _"were for the soviets but
categorically against the Soviet of People's Commissars as an organ which does
not stem from the soviet structure but only interferes with its work."_ Thus
they were _"for the establishment of **free soviets** of workers' and
peasants' representatives, and the abolition of the Soviet of People's
Commissars as an organisation inimical to the interests of the working
class."_ [contained in Paul Avrich, **The Anarchists in the Russian
Revolution**, p. 118 and p. 117] This resolution was driven by the experience
of the Bolshevik dominated "soviet" regime.

It is also worth quoting Rudolf Rocker at length on this issue:

> _ "Let no one object that the 'dictatorship of the proletariat' cannot be
compared to run of the mill dictatorship because it is the dictatorship of a
class. Dictatorship of a class cannot exist as such, for it ends up, in the
last analysis, as being the dictatorship of a given party which arrogates to
itself the right to speak for that class. Thus, the liberal bourgeoisie, in
their fight against despotism, used to speak in the name of the 'people'. . .
_

>

> _"We already know that a revolution cannot be made with rosewater. And we
know, too, that the owning classes will never yield up their privileges
spontaneously. On the day of victorious revolution the workers will have to
impose their will on the present owners of the soil, of the subsoil and of the
means of production, which cannot be done -- let us be clear on this --
without the workers taking the capital of society into their own hands, and,
above all, without their having demolished the authoritarian structure which
is, and will continue to be, the fortress keeping the masses of the people
under dominion. Such an action is, without doubt, an act of liberation; a
proclamation of social justice; the very essence of social revolution, which
has nothing in common with the utterly bourgeois principle of dictatorship. _

>

> _"The fact that a large number of socialist parties have rallied to the idea
of councils, which is the proper mark of libertarian socialist and
revolutionary syndicalists, is a confession, recognition that the tack they
have taken up until now has been the product of a falsification, a distortion,
and that with the councils the labour movement must create for itself a single
organ capable of carrying into effect the unmitigated socialism that the
conscious proletariat longs for. On the other hand, it ought not to be
forgotten that this abrupt conversion runs the risk of introducing many alien
features into the councils concept, features, that is, with no relation to the
original tasks of socialism, and which have to be eliminated because they pose
a threat to the further development of the councils. These alien elements are
able only to conceive things from the dictatorial viewpoint. It must be our
task to face up to this risk and warn our class comrades against experiments
which cannot bring the dawn of social emancipation any nearer -- which indeed,
to the contrary, positively postpone it. _

>

> _"Consequently, our advice is as follows: Everything for the councils or
soviets! No power above them! A slogan which at the same time will be that of
the social revolutionary."_ [**Anarchism and Sovietism**]

The validity of this argument can be seen, for example, from the expulsion of
opposition parties from the soviets in June and July 1918. This act exposes
the hollowness of Bolshevik claims of their soviet system presented a form of
"higher" democracy. If the Bolshevik soviet system was, as they claimed, based
on instant recall then why did they, for example, have to expel the Mensheviks
and Right SRs from the soviet CEC in the first place? Why did the electors not
simply recall them? It was two weeks after the Czech revolt before the
Bolsheviks acted, surely enough time for voters to act? Perhaps this did not
happen because the CEC was not, in fact, subject to instant recall at all?
Being nominated at the quarterly soviet congress, they were effectively
isolated from popular control. It also means that the Bolshevik government was
even more insulated from popular control and accountability. To "recall" it,
electors would have to either wait for the next national soviet congress or
somehow convince the CEC to call an emergency one. As an example of workers'
running society, the Bolshevik system leaves much to be desired.

Another obvious lesson to learn was the use of appointments to the soviets and
their executives from other organisations. As seen above, the Bolsheviks used
the "representation" of other bodies they control (such as trade unions) to
pack soviet assemblies in their favour. Similarly, allowing political parties
to nominate representatives in soviet executives also marginalised the soviet
assemblies and those delegates actually elected in the workplaces.

This was obvious to the Russian anarchists, who argued _"for effective soviets
organised on collective lines with the direct delegation of workers and
peasants from every factory, workshop, village, etc., and not political
chatterboxes gaining entry through party lists and turning the soviets into
talking shops."_ [contained in Paul Avrich, **The Anarchists in the Russian
Revolution**, p. 118] The Makhnovists, likewise, argued that _"[o]nly
labourers who are contributing work necessary to the social economy should
participate in the soviets. Representatives of political organisations have no
place in worker-peasant soviets, since their participation in a workers'
soviet will transform the latter into deputies of the party and can lead to
the downfall of the soviet system."_ [contained in Peter Arshinov's **History
of the Makhnovist Movement**, p. 266] As we discuss in [section
15](append46.html#app15) of the appendix on ["Why does the Makhnovist movement
show there is an alternative to Bolshevism?"](append46.html), Leninists
sometimes distort this into a claim that the Makhnovists opposed members of
political standing for election.

This use of party lists meant that soviet delegates could be anyone. For
example, the leading left-wing Menshevik Martov recounts that in early 1920
Bolsheviks in a chemical factory _"put up Lenin against me as a candidate [to
the Moscow soviet]. I received seventy-six votes he-eight (in an open vote)."_
[quoted by Israel Getzler, **Martov**, p. 202] How would either of these two
intellectuals actually know and reflect the concerns and interests of the
workers they would be "delegates" of? If the soviets were meant to be the
delegates of working people, then why should non-working class members of
political parties be elected to a soviet?

However, in spite of these problems, the Russian soviets were a key means of
ensuring working class participation in the revolution. As recognised by all
the socialist oppositions to the Bolsheviks, from the anarchists to the
Mensheviks. As one historian put it:

> _ "Small wonder that the principal political demand of Mensheviks, Left SRs,
SR Maximalists, Kronstadt sailors and of many oppositionists . . . has been
for freely elected soviets which would this be restored to their original role
as agents of democratisation."_ [Israel Getzler, **Soviets as Agents of
Democratisation**, p. 30]

The sad fate of the soviets after the Bolshevik seizure of power simply
confirms the opinion of the left Menshevik Martov who had _"rubbed it in to
the Bolsheviks . . . at the first All-Russian Congress of Trade Unions [in
January 1918], that they who were now extolling the Soviets as the 'highest
forms of the socialist development of the proletariat,' had shown little love
of them in 1905 or in 1917 after the July days; they loved Soviets only when
they were 'in the hands of the Bolshevik party.'"_ [Getlzer, **Martov**, p.
174] As the next few months showed, once the soviets left those hands, then
the soviets themselves were destroyed. The civil war did not start this
process, it just gave the latter-day supporters of Bolshevism something to use
to justify these actions.

## 7 How did the factory committee movement develop?

## 8 What was the Bolshevik position on "workers' control" in 1917?

## 9 What happened to the factory committees after October?

## 10 What were the Bolshevik economic policies in 1918?

## 11 Did Bolshevik economic policies work?

## 12 Was there an alternative to Lenin's "state capitalism" and "war
communism"?

## 13 Did the Bolsheviks allow independent trade unions?

## 14 Was the Red Army really a revolutionary army?

## 15 Was the Red Army "filled with socialist consciousness"?

## 16 How did the civil war start and develop?

## 17 Was the civil war between just Reds and Whites?

## 18 How extensive was imperialist intervention?

## 19 Did the end of the civil war change Bolshevik policies?

## 20 Can the Red Terror and the Cheka be justified?

## 21 Did Bolshevik peasant policies work?

## 22 Was there an alternative to grain requisition?

## 23 Was the repression of the socialist opposition justified?

## 24 What did the anarchists do during the revolution?

## 25 Did the Russian revolution refute anarchism?



[‹ Appendix - The Russian Revolution](/afaq/append4.html "Go to previous page"
) [up](/afaq/append4.html "Go to parent page" ) [What was the Kronstadt
Rebellion? ›](/afaq/append42.html "Go to next page" )

