//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/// Name:         AlcPix Class
///
/// Purpose:      aMule ed2k link creator
///
/// Author:       ThePolish <thepolish@vipmail.ru>
///
/// Copyright (C) 2004 by ThePolish
///
/// Pixmaps from http://jimmac.musichall.cz/ikony.php3 | http://www.everaldo.com | http://www.icomania.com
///
/// This program is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// This program is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with this program; if not, write to the
/// Free Software Foundation, Inc.,
/// 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifdef __GNUG__
#pragma implementation "alcpix.h"
#endif

// For compilers that support precompilation, includes "wx/wx.h"
#include "wx/wxprec.h"

#ifdef __BORLANDC__
    #pragma hdrstop
#endif

// For all others, include the necessary headers
#ifndef WX_PRECOMP
    #include "wx/wx.h"
#endif

#include "alcpix.h"

wxBitmap AlcPix::getPixmap(const wxString& name)
{
  if (name == wxT("about"))
    {
      wxBitmap bitmap(m_about_xpm);
      return bitmap;
    }
  else if (name == wxT("alc"))
    {
      wxBitmap bitmap(m_alc_xpm);
      return bitmap;
    }
  else if (name == wxT("copy"))
    {
      wxBitmap bitmap(m_copy_xpm);
      return bitmap;
    }
  else if (name == wxT("open"))
    {
      wxBitmap bitmap(m_open_xpm);
      return bitmap;
    }
  else if (name == wxT("saveas"))
    {
      wxBitmap bitmap(m_saveas_xpm);
      return bitmap;
    }
  else
    {
      return wxNullBitmap;
    }
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///
/// Several themes follow. Switch them by CPP macro in alcpix.h
///
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifdef WANT_KDE_THEME
const char *
AlcPix::m_about_xpm[]=
  { /* XPM */
    /* columns rows colors chars-per-pixel */
    "32 32 251 2",
    "   c black",
    ".  c #890000",
    "X  c #8A0000",
    "o  c #8B0000",
    "O  c #8C0000",
    "+  c #8D0000",
    "@  c #8E0000",
    "#  c #8F0000",
    "$  c #900000",
    "%  c #910000",
    "&  c #920000",
    "*  c #930000",
    "=  c #940000",
    "-  c #950000",
    ";  c #960000",
    ":  c #970000",
    ">  c #980000",
    ",  c #990000",
    "<  c #9A0000",
    "1  c #9B0000",
    "2  c #9B0202",
    "3  c #9C0000",
    "4  c #9D0000",
    "5  c #9E0000",
    "6  c #9F0000",
    "7  c #9B0909",
    "8  c #9C0B0B",
    "9  c #A00000",
    "0  c #A20000",
    "q  c #A30000",
    "w  c #A40000",
    "e  c #A50000",
    "r  c #A60000",
    "t  c #A70000",
    "y  c #A80000",
    "u  c #A90000",
    "i  c #AA0000",
    "p  c #AB0000",
    "a  c #AC0000",
    "s  c #AD0000",
    "d  c #AE0000",
    "f  c #AF0000",
    "g  c #A90B0B",
    "h  c #AD0909",
    "j  c #B00000",
    "k  c #B10000",
    "l  c #B20000",
    "z  c #B30000",
    "x  c #B40000",
    "c  c #B50000",
    "v  c #B60000",
    "b  c #B70000",
    "n  c #B80000",
    "m  c #B90000",
    "M  c #BA0000",
    "N  c #BB0000",
    "B  c #BB0202",
    "V  c #BC0000",
    "C  c #BD0000",
    "Z  c #BE0000",
    "A  c #BF0000",
    "S  c #C00000",
    "D  c #C10000",
    "F  c #C20000",
    "G  c #C30000",
    "H  c #C40000",
    "J  c #C50000",
    "K  c #C60000",
    "L  c #C70000",
    "P  c #C60F0F",
    "I  c #C80000",
    "U  c #C90000",
    "Y  c #CA0000",
    "T  c #CB0000",
    "R  c #CC0000",
    "E  c #CD0000",
    "W  c #CC0B0B",
    "Q  c #D20000",
    "!  c #D50000",
    "~  c #D60000",
    "^  c #D70000",
    "/  c #D50505",
    "(  c #D20E0E",
    ")  c #D70F0F",
    "_  c #D80000",
    "`  c #D90000",
    "'  c #DD0000",
    "]  c #D51111",
    "[  c #D21818",
    "{  c #D41A1A",
    "}  c #DC1D1D",
    "|  c #C02626",
    " . c #C62020",
    ".. c #C72626",
    "X. c #CF3E3E",
    "o. c #D22020",
    "O. c #D42121",
    "+. c #D92222",
    "@. c #D92323",
    "#. c #DA2626",
    "$. c #DE2121",
    "%. c #D53030",
    "&. c #DB3030",
    "*. c #DD3C3C",
    "=. c #DF3C3C",
    "-. c #E10000",
    ";. c #E20000",
    ":. c #E30000",
    ">. c #E30505",
    ",. c #E40000",
    "<. c #E30D0D",
    "1. c #EA0101",
    "2. c #EA0404",
    "3. c #E01A1A",
    "4. c #EC1919",
    "5. c #F20000",
    "6. c #F30707",
    "7. c #F40000",
    "8. c #F70000",
    "9. c #F50808",
    "0. c #F50D0D",
    "q. c #F80000",
    "w. c #FA0101",
    "e. c #FB0000",
    "r. c #FC0000",
    "t. c #FD0000",
    "y. c #FD0101",
    "u. c #FE0000",
    "i. c #FE0101",
    "p. c #FF0202",
    "a. c #FF0808",
    "s. c #FE0E0E",
    "d. c #FF0F0F",
    "f. c #F41010",
    "g. c #FF1414",
    "h. c #FF1818",
    "j. c #E52020",
    "k. c #EB2F2F",
    "l. c #EB3E3E",
    "z. c #F42020",
    "x. c #F72E2E",
    "c. c #FF2020",
    "v. c #FF2222",
    "b. c #F82F2F",
    "n. c #FF2B2B",
    "m. c #FF2D2D",
    "M. c #F23030",
    "N. c #F43030",
    "B. c #F63030",
    "V. c #F73232",
    "C. c #F53E3E",
    "Z. c #F93030",
    "A. c #FF3434",
    "S. c #FF3737",
    "D. c #F83838",
    "F. c #DA4B4B",
    "G. c #D45252",
    "H. c #DA5252",
    "J. c #EB4848",
    "K. c #EC4848",
    "L. c #F64545",
    "P. c #FF4343",
    "I. c #FF4646",
    "U. c #FB4848",
    "Y. c #FF4E4E",
    "T. c #F75858",
    "R. c #FB5656",
    "E. c #FF5050",
    "W. c #FE5252",
    "Q. c #FF5858",
    "!. c #FF5A5A",
    "~. c #EB6F6F",
    "^. c #F56C6C",
    "/. c #FA6262",
    "(. c #FF6060",
    "). c #FF6666",
    "_. c #FF6767",
    "`. c #F96F6F",
    "'. c #FA6C6C",
    "]. c #FF6969",
    "[. c #FF6C6C",
    "{. c #F97676",
    "}. c #FF7272",
    "|. c #FF7676",
    " X c #FD7A7A",
    ".X c #FF7B7B",
    "XX c #FF7E7E",
    "oX c #D98181",
    "OX c #E48383",
    "+X c #E58383",
    "@X c #E88B8B",
    "#X c #E88C8C",
    "$X c #E99292",
    "%X c #EB9090",
    "&X c #EE9393",
    "*X c #ED9C9C",
    "=X c #F58282",
    "-X c #FA8181",
    ";X c #FF8080",
    ":X c #FF8B8B",
    ">X c #FD8D8D",
    ",X c #FF8C8C",
    "<X c #F19E9E",
    "1X c #F59D9D",
    "2X c #FB9090",
    "3X c #FF9494",
    "4X c #FD9B9B",
    "5X c #FF9C9C",
    "6X c #FF9E9E",
    "7X c #EDA0A0",
    "8X c #EEAFAF",
    "9X c #EFAEAE",
    "0X c #E8BFBF",
    "qX c #E9BFBF",
    "wX c #EABFBF",
    "eX c #EDBABA",
    "rX c #FBA3A3",
    "tX c #FFA3A3",
    "yX c #FCA4A4",
    "uX c #FDA9A9",
    "iX c #FFA9A9",
    "pX c #FFACAC",
    "aX c #FFAFAF",
    "sX c #F0B2B2",
    "dX c #F3B7B7",
    "fX c #F9B7B7",
    "gX c #FEB3B3",
    "hX c #FCBFBF",
    "jX c #ECCFCF",
    "kX c #EFCFCF",
    "lX c #F6C1C1",
    "zX c #FDC2C2",
    "xX c #FFC0C0",
    "cX c #FDC4C4",
    "vX c #FFC5C5",
    "bX c #FFC9C9",
    "nX c #FECFCF",
    "mX c #FCD3D3",
    "MX c #FFD1D1",
    "NX c #FFD9D9",
    "BX c #FEDFDF",
    "VX c #FFE1E1",
    "CX c #FAEFEF",
    "ZX c #FFECEC",
    "AX c #FEEFEF",
    "SX c #FFF0F0",
    "DX c #FFF1F1",
    "FX c #FFF3F3",
    "GX c #FFF5F5",
    "HX c gray100",
    "JX c None",
    /* pixels */
    "JXJXJXJXJXJXJXJXJXJXJXJXJXJXJXJXJXJXJXJXJXJXJXJXJXJXJXJXJXJXJXJX",
    "JXJXJXJXJXJXJXJXJXJXJXJXL L L A A A A A JXJXJXJXJXJXJXJXJXJXJXJX",
    "JXJXJXJXJXJXJXJXJXT T L L L A A A A M M M v M JXJXJXJXJXJXJXJXJX",
    "JXJXJXJXJXJXJXJXT T L E ` -.k.C.C.l.-.Q A M f f JXJXJXJXJXJXJXJX",
    "JXJXJXJXJXJXT T T E -.T.rXSXSXSXSXSXSXzX{.} A f f p JXJXJXJXJXJX",
    "JXJXJXJXJXT T T ' L.cXVXVXmX*X$XsX9XdXVXVXVX'.( f p i JXJXJXJXJX",
    "JXJXJXJXT T L <.;XmXmXfX$X9XHXHXHXHXHXeXlXmXmXiX#.p i i JXJXJXJX",
    "JXJXJXJXT T -.4XhXhX1X#XHXHXHXHXHXHXHXHXHXNXhXhXaX@.e e JXJXJXJX",
    "JXJXJXT T ` '.aXaXyX#XHXHXHXHXHXHXHXHXHXHXHXbXpXaX,XW e q JXJXJX",
    "JXJXT T T x.6X6X6X~.HXHXHXHXNXtX6XiXAXHXHXHXGX6X6XtX/.i q 4 JXJX",
    "JXJXL L -..X,X,X,X&XHXHXHXSX,X,X:X:X=XCXHXHXHX3X,X,X,X] 4 4 JXJX",
    "JXJXL T x..X.X.X.X<XHXHXHXpX.X.X.X.X^.wXHXHXHX6X.XR.D.f.i 4 JXJX",
    "JXL L ~ U.].].].].2XHXHXGX}.].].].].G.HXHXHXHXM.6.5.5.5.A < < JX",
    "JXL L -.W.Q.Q.Q.Q.Q.:XiX[.Q.Q.Q.Q.H.kXHXHXHXhX5.5.5.5.5.~ < < JX",
    "JXA L 2.I.I.I.I.I.I.I.I.I.I.I.I.F.CXHXHXHXAXz.5.5.5.5.5.-.< * JX",
    "JXA A 0.A.A.A.A.A.A.A.A.A.A.A.X.CXHXHXHXAXM.5.5.5.5.5.5.5.* * JX",
    "JXA A 9.c.c.c.c.c.c.v.c.c.c.@.CXHXHXHXAXM.5.5.5.5.5.5.5.5.* % JX",
    "JXA A 2.s.g.s.g.g.s.g.s.g.s.oXHXHXHXVXx.5.8.8.5.5.8.5.8.-.% % JX",
    "JXA M :.i.i.i.i.i.i.i.i.e.8.wXHXHXHXx.8.8.8.8.8.8.8.8.8.~ # # JX",
    "JXM M ~ i.i.i.i.i.i.e.e.e.e.0XHXHXmXe.e.e.e.e.e.e.e.e.e.A # # JX",
    "JXJXM A i.i.i.i.i.i.i.i.i.i.7XHXHXXXi.i.i.i.i.i.i.i.i.i.4 # JXJX",
    "JXJXv v >.a.a.a.a.a.a.a.a.a.h..X).a.a.a.a.a.a.a.a.a.a./ # X JXJX",
    "JXJXf v B g.g.g.g.g.g.g.g.g.[ OXOXx.g.g.g.g.g.g.g.g.g.< # X JXJX",
    "JXJXJXf f ] c.c.c.c.c.h.h.4.kXHXHXSXm.c.h.c.c.c.c.h.P X X JXJXJX",
    "JXJXJXJXp f 3.n.m.n.n.m.m.j.HXHXHXHX(.m.m.m.n.m.m.{ X X JXJXJXJX",
    "JXJXJXJXp p i $.S.A.A.S.A.M.GXHXHXHXW.A.A.S.A.A.O.X X X JXJXJXJX",
    "JXJXJXJXJXi i e o.P.P.P.I.P.).cXmXXXP.P.I.P.P. .X X X JXJXJXJXJX",
    "JXJXJXJXJXJXe e q h &.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.%.7 X X X JXJXJXJXJXJX",
    "JXJXJXJXJXJXJXJXq q 4 g | l.K.Q.Q.K.*.| 8 # X X JXJXJXJXJXJXJXJX",
    "JXJXJXJXJXJXJXJXJX4 4 < < < * * % % % # # X X JXJXJXJXJXJXJXJXJX",
    "JXJXJXJXJXJXJXJXJXJXJXJX* < * * % # # # JXJXJXJXJXJXJXJXJXJXJXJX",
    "JXJXJXJXJXJXJXJXJXJXJXJXJXJXJXJXJXJXJXJXJXJXJXJXJXJXJXJXJXJXJXJX"
  };

const char *
AlcPix::m_alc_xpm[]=
  { /* XPM */
    /* columns rows colors chars-per-pixel */
    "32 32 142 2",
    "   c #000000",
    ".  c #0C0B00",
    "X  c #0B0B0B",
    "o  c #131313",
    "O  c #121318",
    "+  c #1A1A1A",
    "@  c #2D1A00",
    "#  c #292100",
    "$  c #29251E",
    "%  c #222222",
    "&  c #292929",
    "*  c #323232",
    "=  c #36383B",
    "-  c #393836",
    ";  c #3E3E3E",
    ":  c #5F3F06",
    ">  c #534400",
    ",  c #594400",
    "<  c #584A00",
    "1  c #6F4700",
    "2  c #604418",
    "3  c #7F6F00",
    "4  c gray26",
    "5  c #4A4A4A",
    "6  c #4D4D58",
    "7  c #505052",
    "8  c #5A5A5A",
    "9  c #5B5C63",
    "0  c #786448",
    "q  c #646464",
    "w  c #696B6F",
    "e  c #747474",
    "r  c #77797D",
    "t  c #7C7C7C",
    "y  c #7C7D82",
    "u  c #995B0A",
    "i  c #9A7700",
    "p  c #8D682E",
    "a  c #AA7900",
    "s  c #9B7F4C",
    "d  c #867C6A",
    "f  c #817D7A",
    "g  c #9A8B00",
    "h  c #A38002",
    "j  c #AC8800",
    "k  c #A59200",
    "l  c #BE8D2D",
    "z  c #B5A200",
    "x  c #97876C",
    "c  c #958873",
    "v  c #9F9079",
    "b  c #B3B272",
    "n  c #BFB97D",
    "m  c #D59700",
    "M  c #C5B500",
    "N  c #E4AA14",
    "B  c #FBB904",
    "V  c #E9AB38",
    "C  c #FCBC20",
    "Z  c #D1AB66",
    "A  c #F0B355",
    "S  c #E0B96A",
    "D  c #D6C500",
    "F  c #D9C300",
    "G  c #DED100",
    "H  c #E4D700",
    "J  c #EDDE00",
    "K  c #F1C500",
    "L  c #FFC604",
    "P  c #FCC90B",
    "I  c #FFD600",
    "U  c #FFDB00",
    "Y  c #FFD81D",
    "T  c #FFCF2A",
    "R  c #FFD32C",
    "E  c #FFD433",
    "W  c #FFD23A",
    "Q  c #F0E500",
    "!  c #FEE300",
    "~  c #FFE800",
    "^  c #FDE114",
    "/  c #FFF000",
    "(  c #FEFB01",
    ")  c #FDFC28",
    "_  c #FFD541",
    "`  c #FFD64A",
    "'  c #E0E046",
    "]  c #858585",
    "[  c #83868D",
    "{  c #86888C",
    "}  c #8B8B8B",
    "|  c #8A8C91",
    " . c #8E9197",
    ".. c #939393",
    "X. c #9B9B9B",
    "o. c #9D9EA0",
    "O. c #9FA1A6",
    "+. c #AB9B82",
    "@. c #AAA297",
    "#. c #B6A588",
    "$. c #BBAC94",
    "%. c #A3A3A3",
    "&. c #ABABAB",
    "*. c #B2B2B2",
    "=. c #BABABA",
    "-. c #BCBEC0",
    ";. c #BFC1C4",
    ":. c #CBBCA4",
    ">. c #C6C6A3",
    ",. c #D9C8AE",
    "<. c #D8D9BA",
    "1. c #EBDB9F",
    "2. c #F9D78E",
    "3. c #F3D598",
    "4. c #FDD790",
    "5. c #FBDE9E",
    "6. c #EDDEBE",
    "7. c #FFEAAB",
    "8. c #F7EAB4",
    "9. c #FEE6B1",
    "0. c #FFEBB2",
    "q. c #FFF1B2",
    "w. c #C3C3C3",
    "e. c #C5C5C9",
    "r. c #CCCCCC",
    "t. c #CDCFD3",
    "y. c #D0D0C0",
    "u. c #D4D4D3",
    "i. c #D2D2D8",
    "p. c #DBDBDB",
    "a. c #EEDFD0",
    "s. c #EDE7DD",
    "d. c #FCFBD4",
    "f. c #FEF8D9",
    "g. c #E3E3E3",
    "h. c #E7E9ED",
    "j. c #EAEAEA",
    "k. c #E8EBF3",
    "l. c #F2F2F2",
    "z. c #F0F1F8",
    "x. c #FDFDFD",
    "c. c None",
    /* pixels */
    "c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.",
    "c.c.c.c.c.c.c.c.c.c.c.c.    X o + o     c.c.c.c.c.c.c.c.c.c.c.c.",
    "c.c.c.c.c.c.c.c.c.c.  $ q X.=.r.w.w.&.t *   c.c.c.c.c.c.c.c.c.c.",
    "c.c.c.c.c.c.c.c.c.X q w.p.r.=.=.=.w.=.w.=.t +   c.c.c.c.c.c.c.c.",
    "c.c.c.c.c.c.c.  X t j.x.x.x.u.%.%.X.%.&.&.&...%   c.c.c.c.c.c.c.",
    "c.c.c.c.c.c.c.  7 p.x.x.x.x.x.w.} =.g.x.l.u.%.e X   c.c.c.c.c.c.",
    "c.c.c.c.c.c.  o } x.x.x.x.l.=.%.*.x.x.x.x.l.r.] *   c.c.c.c.c.c.",
    "c.c.c.c.c.    & X.x.x.x.l.r.e & } ..x.x.j.p.u.} ;     c.c.c.c.c.",
    "c.c.c.c.c.    % t x.x.l.g.r.9 6 y } x.j.p.r.w.t *     c.c.c.c.c.",
    "c.c.c.c.      o 4 p.x.g.p.y.>.b n f.s.p.t.e.%.5 +       c.c.c.c.",
    "c.c.c.c.        + q p.p.e.' ( ( U L A r.*.] 4 %         c.c.c.c.",
    "c.c.c.c.            ; r.i.<.) / I C s.h.%.&   X         c.c.c.c.",
    "c.c.c.c.          X %.x.x.x.d.^ P a.h.g.s.*.&             c.c.c.",
    "c.c.            X *.x.x.x.x.x.8.1.k.s.p.u.p.*.%   X       c.c.c.",
    "c.    X X X X   ] x.x.x.x.x.x.k.h.g.i.u.r.w.e...o X   X X     c.",
    "    o o o o X 4 l.x.x.x.x.x.j.j.g.p.u.r.w.=.=.=.8     X o X     ",
    "  X X o o + X X.x.x.x.x.x.l.j.g.p.u.r.e.w.=.*.*...o X X         ",
    "          + * h.x.x.x.l.l.j.g.p.t.r.e.w.=.*.&.%.%.5 +           ",
    "c.c.c.c.  o e x.x.x.x.l.j.s.p.u.r.w.-.=.*.&.%.%.@.e %   c.c.c.c.",
    "c.c.c.c.  o &.x.x.x.l.h.g.p.u.r.y.=.=.*.&.%.%.X...[ %   c.c.c.c.",
    "c.c.c.c.  X r.x.x.l.j.s.a.i.t.e.;.=.*.&.&.O.....} } +   c.c.c.c.",
    "c.c.c.c.c.X s.x.l.j.g.p.u.r.e.;.*.*.&.%.O.X.....} } +   c.c.c.c.",
    "c.c.c.c.c.X p.x.h.g.p.i.r.e.-.=.*.&.&.@.......} } 8   c.c.c.c.c.",
    "c.c.c.c.c.c.6 h.s.p.u.r.e.-.=.*.&.%.o.X.....] ] t o   c.c.c.c.c.",
    "c.c.c.c.c.c.c.9 t.r.;.;.-.=.*.&.%.o.X...{ ] r w O   c.c.c.c.c.c.",
    "c.c.c.c.c.c.u 2 #.,.:.$.@.o.O.X.X.| [ f c v $.v 0 p : c.c.c.c.c.",
    "c.c.c.c.1 V 4.0.0.0.9.9.3.Z x | } t s S 5.7.7.q.q.7.2.l @ c.c.c.",
    "c.c.c.  m E ` _ _ _ W _ ` T N }  .d B R E E E E E E W Y a   c.c.",
    "c.c.c.  i U U U ~ U ~ U U U a - = $ j U ~ ~ ~ ~ ~ ~ U K ,   c.c.",
    "c.c.c.c.  > k D J Q J F k <       c.  > g M G H D z 3 #   c.c.c.",
    "c.c.c.c.c.c.    . . . .     c.c.c.c.c.c.    . .         c.c.c.c.",
    "c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c."
  };

const char *
AlcPix::m_copy_xpm[]=
  { /* XPM */
    /* columns rows colors chars-per-pixel */
    "32 32 71 1",
    "  c black",
    ". c #9A99A3",
    "X c #A1A2B5",
    "o c #ACACB0",
    "O c #AEAEB1",
    "+ c #AFAFB2",
    "@ c #ACADBE",
    "# c #ADAFBE",
    "$ c #B1B0B3",
    "% c #B2B1B3",
    "& c #B3B2B4",
    "* c #B3B3B6",
    "= c #B4B4B6",
    "- c #B6B6B7",
    "; c #B7B7B7",
    ": c #B2B3C3",
    "> c #C0BEC3",
    ", c #C4C3D1",
    "< c #DBDADF",
    "1 c #D3D3E3",
    "2 c #D4D3E3",
    "3 c #D6D6E4",
    "4 c #D8D7E6",
    "5 c #D9D8E7",
    "6 c #DCDBE0",
    "7 c #DCDCE1",
    "8 c #DEDEE2",
    "9 c #DCDAE8",
    "0 c #DDDCE9",
    "q c #DEDDE9",
    "w c #DFDEEA",
    "e c #E0DFE4",
    "r c #E1DFEC",
    "t c #E1E0E5",
    "y c #E2E1E5",
    "u c #E2E1E7",
    "i c #E4E2E5",
    "p c #E5E4E6",
    "a c #E2E1ED",
    "s c #E3E2ED",
    "d c #E4E2E8",
    "f c #E4E3EE",
    "g c #E5E5E8",
    "h c #E6E4EF",
    "j c #E7E6EF",
    "k c #E8E6E9",
    "l c #EAEAEA",
    "z c #E8E7F1",
    "x c #E9E8F2",
    "c c #EAE9F3",
    "v c #ECEAF3",
    "b c #EEEDF3",
    "n c #EDECF4",
    "m c #EEEDF6",
    "M c #EFEEF6",
    "N c #F1EFF7",
    "B c #F2F1F7",
    "V c #F3F2F8",
    "C c #F4F3F9",
    "Z c #F6F4FA",
    "A c #F6F6FA",
    "S c #F7F6FA",
    "D c #F8F7FC",
    "F c #F9F8FD",
    "G c #FAF9FD",
    "H c #FCFAFE",
    "J c #FDFCFF",
    "K c #FEFDFF",
    "L c #FEFEFF",
    "P c gray100",
    "I c None",
    /* pixels */
    "IIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII",
    "I555555555555XIIIIIIIIIIIIIIIIII",
    "I5PPPPPPPPPP5bXIIIIIIIIIIIIIIIII",
    "I5PPPPPGZBmM5b@XIIIIIIIIIIIIIIII",
    "I4PPPPPDZZBM4c0#XIIIIIIIIIIIIIII",
    "I4PPPPPHHZBM5Pms:XIIIIIIIIIIIIII",
    "I4PPPPPHHZZMXXXXXX IIIIIIIIIIIII",
    "I4PPPPPPHDVMMc021X IIIIIIIIIIIII",
    "I4PPPPPHGDZVba423X.,55555XIIIIII",
    "I4PPPPPPPDZmh0044X-lPPPP5mXIIIII",
    "I5PPPPPHGZmzsrr0aX*iZBmm5v#XIIII",
    "I5PPPPHDGVvjssarhX*iSZBM5b4#XIII",
    "I5PPPPPDBmzzjjjshX*iGZBM5PMs:XII",
    "I5PPPPDVmmmcczjjjX-iHSZMXXXXXX I",
    "I5PPPGVVBmmbczzjcX*pHZVmmz011X I",
    "I5PPHZVZBmMbMczjcX=pHGZBma423X I",
    "I4PPGAZVNNMMbczzmX*iPGZmh0055X I",
    "I4PPGZZZVVMMmcmzmX-pGZmzaa00aX I",
    "I4PPDAZVVNMMbczzbX%yGBbjhssasX I",
    "I4PPAZZVNNMMbczzcX*eBmzzhhhshX I",
    "I4PPZZZVCMMcmzzhbX%<MMmzvzjjzX I",
    "I4PPPPPHPHHSDVZBAXO<BMmbvzjjcX I",
    "IXXXXXXXXXXXXXXXXXoeBmmbmzzjcX I",
    "II           .--%O:pBBmmmvcjcX I",
    "IIIIIIIIIIIII,lgi8pbVBBMmccjbX I",
    "IIIIIIIIIIIII5PPDZZVVBMMbccccX I",
    "IIIIIIIIIIIII5PPZZVZBMmmMccjmX I",
    "IIIIIIIIIIIII5PPAZZZNNmmcccjcX I",
    "IIIIIIIIIIIII5PPPPJJHGGDZZVBZX I",
    "IIIIIIIIIIIIIXXXXXXXXXXXXXXXXX I",
    "IIIIIIIIIIIIII                 I",
    "IIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII"
  };

const char *
AlcPix::m_open_xpm[]=
  { /* XPM */
    /* columns rows colors chars-per-pixel */
    "32 32 240 2",
    "   c black",
    ".  c #000823",
    "X  c #001240",
    "o  c #00114D",
    "O  c #001552",
    "+  c #001C74",
    "@  c #001B78",
    "#  c #002375",
    "$  c #373C5B",
    "%  c #4D5376",
    "&  c #001BAE",
    "*  c #001EB2",
    "=  c #00248E",
    "-  c #00239B",
    ";  c #002D9A",
    ":  c #053596",
    ">  c #05389B",
    ",  c #0026A4",
    "<  c #0023AD",
    "1  c #0029A3",
    "2  c #002BAA",
    "3  c #0025B2",
    "4  c #012AB6",
    "5  c #032CB8",
    "6  c #082AB1",
    "7  c #0033A4",
    "8  c #0034AA",
    "9  c #083AAA",
    "0  c #0632BE",
    "q  c #003DB1",
    "w  c #1038BC",
    "e  c #002EC0",
    "r  c #053AC7",
    "t  c #073CC9",
    "y  c #0936C0",
    "u  c #083FCC",
    "i  c #133EC2",
    "p  c #0344A6",
    "a  c #0D43AE",
    "s  c #0043B7",
    "d  c #0044B8",
    "f  c #064DBB",
    "g  c #0B47B6",
    "h  c #0D4DBA",
    "j  c #0851BE",
    "k  c #1442AC",
    "l  c #1349A4",
    "z  c #1253BF",
    "x  c #1D58BF",
    "c  c #2C4C98",
    "v  c #2F56B0",
    "b  c #2A58B5",
    "n  c #2C5BB8",
    "m  c #305EBA",
    "M  c #3362BE",
    "N  c #0840CD",
    "B  c #0745D3",
    "V  c #0946D4",
    "C  c #094DDB",
    "Z  c #0752C1",
    "A  c #0B54C1",
    "S  c #0950DF",
    "D  c #1A44C3",
    "F  c #1D4CCB",
    "G  c #134CD4",
    "H  c #1D4FD3",
    "J  c #1358C2",
    "K  c #1E53D4",
    "L  c #1F5ADC",
    "P  c #1F65C9",
    "I  c #1C66DF",
    "U  c #1F62E2",
    "Y  c #2758D4",
    "T  c #215ADD",
    "R  c #2361C4",
    "E  c #2366CA",
    "W  c #2A63C2",
    "Q  c #2B6ACB",
    "!  c #2B65DF",
    "~  c #316FCD",
    "^  c #3867C2",
    "/  c #3B6CC5",
    "(  c #3C6FC8",
    ")  c #3472CE",
    "_  c #3C73CC",
    "`  c #3E79D1",
    "'  c #2262E3",
    "]  c #2865E0",
    "[  c #2B6CE9",
    "{  c #316DE3",
    "}  c #306FEA",
    "|  c #386FE0",
    " . c #3877EC",
    ".. c #3C7AEA",
    "X. c #4D5B98",
    "o. c #596190",
    "O. c #5C6BAE",
    "+. c #536FB8",
    "@. c #606AA4",
    "#. c #6D77AC",
    "$. c #757EB3",
    "%. c #4074CB",
    "&. c #4379CE",
    "*. c #447CD1",
    "=. c #4A7FD4",
    "-. c #427DED",
    ";. c #3D80D8",
    ":. c #7C85B3",
    ">. c #7F85B8",
    ",. c #7A8ABE",
    "<. c #4780D3",
    "1. c #4A80D3",
    "2. c #5282D5",
    "3. c #5389D6",
    "4. c #518DDB",
    "5. c #5D8EDC",
    "6. c #5892DD",
    "7. c #4582F0",
    "8. c #4C87F1",
    "9. c #4D96FA",
    "0. c #568FE7",
    "q. c #588DED",
    "w. c #518DF2",
    "e. c #5D98E0",
    "r. c #5F9CEF",
    "t. c #5590F3",
    "y. c #509EFF",
    "u. c #5C96F3",
    "i. c #55A1FF",
    "p. c #5BA5FF",
    "a. c #6391DB",
    "s. c #7193D4",
    "d. c #769EDD",
    "f. c #7899D8",
    "g. c #639CF5",
    "h. c #689CF2",
    "j. c #64AAFF",
    "k. c #6CA3F6",
    "l. c #6BAEFF",
    "z. c #73ACE9",
    "x. c #70A6F7",
    "c. c #76A8F5",
    "v. c #74ABF9",
    "b. c #7AAAF0",
    "n. c #7AAFFA",
    "m. c #7CB4F3",
    "M. c #79B9FF",
    "N. c #868BB7",
    "B. c #848CBA",
    "V. c #9198AA",
    "C. c #9FA2AC",
    "Z. c #A2A4AE",
    "A. c #A4A8B0",
    "S. c #ABADB6",
    "D. c #B3B5BE",
    "F. c #838CC0",
    "G. c #8C94C0",
    "H. c #919BC3",
    "J. c #979FC9",
    "K. c #989FC7",
    "L. c #99A0C4",
    "P. c #9CA2C8",
    "I. c #9CAFD4",
    "U. c #9FB2D6",
    "Y. c #84AEE2",
    "T. c #85B7F3",
    "R. c #81B5FA",
    "E. c #82B8F3",
    "W. c #86BCFE",
    "Q. c #89BDFC",
    "!. c #A2A9CD",
    "~. c #A8ADCD",
    "^. c #ACB3D4",
    "/. c #B5B5CA",
    "(. c #BABDC4",
    "). c #BBBBCD",
    "_. c #BEBED1",
    "`. c #B9BEDD",
    "'. c #86C2FF",
    "]. c #8DC2FF",
    "[. c #92C3FD",
    "{. c #96CBFF",
    "}. c #99C7F2",
    "|. c #9CCCFE",
    " X c #A0C0EC",
    ".X c #A3C5F2",
    "XX c #ABCAF3",
    "oX c #A4D3FD",
    "OX c #A4DBFF",
    "+X c #AAD6FB",
    "@X c #AEDBFF",
    "#X c #BCCBEB",
    "$X c #B4CEF2",
    "%X c #B3D2F3",
    "&X c #B5D9FF",
    "*X c #BAD6F5",
    "=X c #BFDAF3",
    "-X c #BADDFF",
    ";X c #ADE1FF",
    ":X c #B5E4FF",
    ">X c #BAE4FE",
    ",X c #BCE9FF",
    "<X c #C2C4CB",
    "1X c #C3C3D4",
    "2X c #C1C6DE",
    "3X c #CBCCD3",
    "4X c #CBCBDA",
    "5X c #D1D2DD",
    "6X c #CACEE4",
    "7X c #C6D5EA",
    "8X c #C5D9F6",
    "9X c #D5D5E1",
    "0X c #D2D5E9",
    "qX c #DADAE5",
    "wX c #DEDEEA",
    "eX c #D8DFF1",
    "rX c #C6E3F9",
    "tX c #C2EBFF",
    "yX c #C8EDFF",
    "uX c #C7F1FF",
    "iX c #CDF3FF",
    "pX c #D7E5FA",
    "aX c #DEE1F2",
    "sX c #D3F3FF",
    "dX c #D8F5FF",
    "fX c #DCFAFF",
    "gX c #E2E3EC",
    "hX c #EAEBEF",
    "jX c #E5E5F3",
    "kX c #EAEAF4",
    "lX c #EDEDF9",
    "zX c #E1F4FF",
    "xX c #E4FCFF",
    "cX c #E8F1FB",
    "vX c #EBFDFF",
    "bX c #F1F1F5",
    "nX c #F3F3FB",
    "mX c #F3FFFF",
    "MX c #FEFEFE",
    "NX c None",
    /* pixels */
    "NXNXNXNXNXNXNXNXNXNXNXNXNXNXNXNXNXNXNXNXNXNXNXNXNXNXNXNXNXNXNXNX",
    "NXNXNXNXNXNXNXNXNXNXNXNXNXNXNXNXNXNXNXNXNXNXNXNXNXNXNXNXNXNXNXNX",
    "NXNXNXNXNXNXNXNXNXNXNXNXNXNXNXNXNXNXNX:.N.$.    NXNXNXNXNXNXNXNX",
    "NXNXNXNXNXNXNXNXNXNXNXNXNXNXNXNXNXNXB.B.0XB.%     NXNXNXNXNXNXNX",
    "NXNXNXNXNXNXNXNXNXNXNXNXNXNXNXNXB.B.!.lXnX0X#.    NXNXNXNXNXNXNX",
    "NXNXNXNXNXNXNXNXNXNXNXNXNXNXB.B.G.wXMXlXlXMXJ.o.    NXNXNXNXNXNX",
    "NXA j j f f f f f f p     B.B.^.MXnXcXlXkXlXcX$.$     NXNXNXNXNX",
    "NX1.MXvXvXfXdXsXyXT.J l N.P.eXMXcXnXnXlXkXkXnX`.@.    NXNXNXNXNX",
    "NX<.vXsXuXuXuX,X,X:Xz.>.2XMXMXMXnXnXcXlXkXjXjXMXF.c #     NXNXNX",
    "NX<.vXiXiXuX,X,X:XU.P.kXMXMXMXnXnXnXnXlXkXkXjXlXaXO.:     NXNXNX",
    "NX*.vXiXiXuX,X%XH.6XMXMXMXMXMXMXnXnXlXlXkXkXjXjXMX^.X.    NXNXNX",
    "NX*.vXiXiXtXU.!.nXMXMXMXMXMXnXnXnXnXlXlXkX#Xs.s.s.f.v > 7 8 7 7 ",
    "NX*.xXiXiX>XL.MXMXMXMXMXMXMXnXMXnXnXnXnX#Xh _ a.5.5.6.1.1.2.g ; ",
    "NX*.xXiXiXuXU.6XMXMXMXMXMXMXMXMXnXnXnXaXW =.&XQ.W.Q.[.n.r.0.q # ",
    "NX` fXiXiXuX6.m <.<.*.*.&.&.&._ _ _ ( F <.-Xj.y.i.y.y.i.U 3 8   ",
    "NX_ dXiXiX@XZ XX#X8X8X=X*X%X$XXXXXXX XXX-Xl.i.y.y.y.p.{ 5 2 ;   ",
    "NX` dXiXiXz.) mXaXcXmXxXdXiX>X&XoX{.W.M.l.p.y.y.9...i 3 * 2 #   ",
    "NX_ sXiXiXE  XmXdX7XvXfXsXtX@X[.M.h.t.7. .{ ! Y i 5 3 & & 2 X   ",
    "NX) sXiXoXZ vXvXxXrX=XsX@XQ.R.x.g.w...} ' T H y 0 e * & < ;     ",
    "NX~ iXiX6.3.MXxXdX,X}.|.{.Q.n.k.u.8...[ ' G r u t e * & 2 =     ",
    "NX) uXiXE  XmXdX,XOX{.T.Q.W.c.g.t.7. .U V B V u t e * & 2 O     ",
    "NXQ tX+XJ cXsX>X;XOX{.E.E.R.v.g.w.7.U C S C V u t e * < 1       ",
    "NXQ tX4.a.sXyXtX>X@XoX{.b.R.c.h.q.| ] U L K F D D w 6 < =       ",
    "NXQ ,XJ $XMXMXMXMXMXnXnXlXhXhXgXwXqX9X9X4X4X1X_.)././.9 +     NX",
    "NXQ m.z MXMXMXMXMXMXMXnXbXkXhXgXwXqX9X9X4X4X4X1X_.).H., .     NX",
    "NXE ;.d.MXMXMXMXMXMXMXnXbXkXhXhXgXwXqX9X4X4X4X1X_.).+.-       NX",
    "NXE j pXMXMXMXMXMXMXMXnXnXbXbXhXgXwXqX9X9X4X4X1X1X).k @     NXNX",
    "NXs R MXMXMXMXMXMXMXMXMXbXhXgX5X5X3X<X(.(.S.A.Z.Z.V., o     NXNX",
    "NXd z &.&._ _ _ _ ( ( / ^ M M m n b a 2 2 1 1 , , , -       NXNX",
    "NX                                                          NXNX",
    "NX                                                        NXNXNX",
    "NXNXNXNXNXNXNXNXNXNXNXNXNXNXNXNXNXNXNXNXNXNXNXNXNXNXNXNXNXNXNXNX"
  };

const char *
AlcPix::m_saveas_xpm[]=
  { /* XPM */
    /* columns rows colors chars-per-pixel */
    "32 32 257 2",
    "   c #000030",
    ".  c #03033F",
    "X  c #0C0D35",
    "o  c #11143C",
    "O  c #050541",
    "+  c #0A0A45",
    "@  c #0F0F4B",
    "#  c #11114D",
    "$  c #191C45",
    "%  c #171B45",
    "&  c #161651",
    "*  c #1B1B54",
    "=  c #1F224D",
    "-  c #1C2A54",
    ";  c #18366F",
    ":  c #12316B",
    ">  c #072764",
    ",  c #202254",
    "<  c #232359",
    "1  c #212F58",
    "2  c #2A2B5B",
    "3  c #262954",
    "4  c #23315A",
    "5  c #2B325D",
    "6  c #2F2F64",
    "7  c #2B3862",
    "8  c #203C74",
    "9  c #323B65",
    "0  c #3E3E70",
    "q  c #3A426B",
    "w  c #33416A",
    "e  c #304B7E",
    "r  c #3A4771",
    "t  c #284479",
    "y  c #42456E",
    "u  c #444C74",
    "i  c #444776",
    "p  c #48567D",
    "a  c #485178",
    "s  c #51537D",
    "d  c #54587E",
    "f  c #4D5C82",
    "g  c #595C83",
    "h  c #555884",
    "j  c #536186",
    "k  c #5A648B",
    "l  c #5B698E",
    "z  c #5A6388",
    "x  c #5E6C90",
    "c  c #526893",
    "v  c #666788",
    "b  c #6B6D94",
    "n  c #616E93",
    "m  c #6C728E",
    "M  c #637194",
    "N  c #65759A",
    "B  c #697699",
    "V  c #6C799B",
    "C  c #6D7193",
    "Z  c #73738D",
    "A  c #74749A",
    "S  c #7C7C93",
    "D  c #7A7B9E",
    "F  c #737799",
    "G  c #6B7EA3",
    "H  c #7D7DA2",
    "J  c #76809F",
    "K  c #7484A4",
    "L  c #7B87A7",
    "P  c #BB4400",
    "I  c #AE6139",
    "U  c #9A6047",
    "Y  c #8F786E",
    "T  c #996C6A",
    "R  c #9C7971",
    "E  c #AB6749",
    "W  c #A6745E",
    "Q  c #B46946",
    "!  c #A77D72",
    "~  c #B47A61",
    "^  c #C15414",
    "/  c #C16C39",
    "(  c #C1703A",
    ")  c #D5742B",
    "_  c #E67A1C",
    "`  c #E67F27",
    "'  c #C47E52",
    "]  c #C67545",
    "[  c #AB8876",
    "{  c #B9A176",
    "}  c #DD8032",
    "|  c #DFA93D",
    " . c #EC9A00",
    ".. c #EC9100",
    "X. c #EE8521",
    "o. c #FF9A2C",
    "O. c #FF9F34",
    "+. c #F79834",
    "@. c #FFA81F",
    "#. c #FFBD02",
    "$. c #FFB908",
    "%. c #F5BD01",
    "&. c #FFB719",
    "*. c #FFBE18",
    "=. c #F6BD1F",
    "-. c #FFA321",
    ";. c #FFA73D",
    ":. c #FFB12C",
    ">. c #F8BA36",
    ",. c #D78853",
    "<. c #DD9A6E",
    "1. c #DDB145",
    "2. c #E6984E",
    "3. c #FBA444",
    "4. c #FFB14E",
    "5. c #FDB058",
    "6. c #FFB75A",
    "7. c #EAAE6E",
    "8. c #EEB472",
    "9. c #FFBD68",
    "0. c #F0B86E",
    "q. c #F7C701",
    "w. c #FFCA04",
    "e. c #FFC10D",
    "r. c #FBC414",
    "t. c #FFC51B",
    "y. c #FFDD0F",
    "u. c #F9D30E",
    "i. c #FFD314",
    "p. c #FFC723",
    "a. c #FFC629",
    "s. c #FFC92A",
    "d. c #FFCC33",
    "f. c #FFCD3A",
    "g. c #FFD927",
    "h. c #FDDC3A",
    "j. c #FEE302",
    "k. c #FFEB01",
    "l. c #FFEC0B",
    "z. c #FFE818",
    "x. c #FCE117",
    "c. c #FFED2F",
    "v. c #FEE828",
    "b. c #FFF03D",
    "n. c #FCC545",
    "m. c #FFCC5C",
    "M. c #FDD345",
    "N. c #FDD24D",
    "B. c #FFD95C",
    "V. c #FFD556",
    "C. c #F5C262",
    "Z. c #FFC16F",
    "A. c #F7C56B",
    "S. c #F7CA7F",
    "D. c #FFC779",
    "F. c #FFDB68",
    "G. c #FFD766",
    "H. c #FFDD71",
    "J. c #FFD87B",
    "K. c #FFE651",
    "L. c #FFF147",
    "P. c #FFF25F",
    "I. c #FFF255",
    "U. c #FFEB68",
    "Y. c #FFE26D",
    "T. c #FFE07B",
    "R. c #FFF46E",
    "E. c #FFF27B",
    "W. c #86869B",
    "Q. c #9A878B",
    "!. c #8383A4",
    "~. c #808EAC",
    "^. c #8A8AA4",
    "/. c #8C8CAA",
    "(. c #8494B2",
    "). c #8B99B6",
    "_. c #8D97B2",
    "`. c #9293AD",
    "'. c #9898A9",
    "]. c #9595B2",
    "[. c #949AB4",
    "{. c #9A9AB4",
    "}. c #95A2BC",
    "|. c #9BA5BD",
    " X c #A68A8E",
    ".X c #AA9F8B",
    "XX c #B69897",
    "oX c #B89E97",
    "OX c #B29493",
    "+X c #A0A0AF",
    "@X c #A3A3B3",
    "#X c #A2A2BA",
    "$X c #A8A8BE",
    "%X c #AAAAB6",
    "&X c #B9AAB2",
    "*X c #9F9FC0",
    "=X c #99A7C0",
    "-X c #9DAAC2",
    ";X c #A2AEC5",
    ":X c #ACACC2",
    ">X c #A8A8C8",
    ",X c #A4A4C4",
    "<X c #A4B0C6",
    "1X c #A6B2C8",
    "2X c #AAB5CA",
    "3X c #AEB9CD",
    "4X c #B3B3CC",
    "5X c #B0BACE",
    "6X c #BBBBCD",
    "7X c #B3BDD0",
    "8X c #BABAD2",
    "9X c #B7B7D3",
    "0X c #B6C0D2",
    "qX c #BBC4D4",
    "wX c #C3A79D",
    "eX c #CAAEA1",
    "rX c #C6B7BB",
    "tX c #E4B699",
    "yX c #FFCB80",
    "uX c #F1C28A",
    "iX c #FFDC8B",
    "pX c #FFD18A",
    "aX c #FCD99D",
    "sX c #FFD591",
    "dX c #EDC8A1",
    "fX c #F2D0B3",
    "gX c #FFE483",
    "hX c #FFE491",
    "jX c #FFF686",
    "kX c #FFF690",
    "lX c #FFF49B",
    "zX c #FFECB3",
    "xX c #C2C2D3",
    "cX c #C3CBDA",
    "vX c #CBCBDB",
    "bX c #C6C6D7",
    "nX c #CAD1DE",
    "mX c #D9CCC2",
    "MX c #D1D1DD",
    "NX c #CED4E1",
    "BX c #D3D6E2",
    "VX c #D3D9E4",
    "CX c #D9DBE5",
    "ZX c #DADFE8",
    "AX c #DDE1EA",
    "SX c #E9DECF",
    "DX c #FBE5CE",
    "FX c #FFEFD7",
    "GX c #FEF0DC",
    "HX c #E3E4EB",
    "JX c #E9E9EF",
    "KX c #EBECF1",
    "LX c #E6E9F0",
    "PX c #FEF9EF",
    "IX c #FEFEFE",
    "UX c #F2F2F5",
    "YX c None",
    /* pixels */
    "YXYXYXYXYXYXYXYXYXYXYXYXYXYXYXYXYXYX .7.,.^ P YXYXYXYXYXYXYXYXYX",
    "YXYXYXYXYXYXYXYXYXYXYXYXYXYXYXYXYX..u.zXGXDX<.P YXYXYXYXYXYXYXYX",
    "YXYXYXYXYXYXYXYXYXYXYXYXYXYXYXYXYX .k.y.iXGXGX<.P YXYXYXYXYXYXYX",
    "YX:X$X#X#X#X{.].`./.!.L !.D A C Y q.k.w.#.&.5.` P YXYXYXYXYXYXYX",
    "2XKXLXHXIXIXVXVXVXVXIXIXIXIXIXIXm.k.j.#.#.-.o./ i YXYXYXYXYXYXYX",
    "$XHXVXVXIXIX> 8 t e IXIXIXIXIXGX%.k.w.e.$.o._ Q.L & YXYXYXYXYXYX",
    "#XAXVXNXIXIX: c N K IXIXIXIXIXC.j.j.r.$.@.o.I ).H * YXYXYXYXYXYX",
    "#XAXNXvXIXIX; G L (.IXIXIXIXPXr.l.i.r.*.o.X.[ (.C * YXYXYXYXYXYX",
    "{.AXvXcXIXIXe (.}.<XIXIXIXIXS.x.z.p.p.:.;.) (.K v & YXYXYXYXYXYX",
    "[.VXcXcXIXIX(.5XqXnXIXIXIXPX=.v.g.a.a.;.+.tXK V z & YXYXYXYXYXYX",
    "[.NXcXqXIXIXIXIXIXIXIXIXIXaXc.c.d.d.>.3.) HXB M g & YXYXYXYXYXYX",
    "/.NXqXqXZXZXVXVXVXVXNXNXcX>.b.h.f.f.4.;.~ |.M x d # YXYXYXYXYXYX",
    "/.nXqX5X5X5X2X1X;X;X-X|.{ h.L.M.M.n.6.) m M l l a # YXYXYXYXYXYX",
    "!.cX5X5X3X2X1X<X-X-X|.}.1.I.K.N.N.6.5.U n l k j u # YXYXYXYXYXYX",
    "L cX5X2X2X<X;X;X-X|.}..XM.U.B.V.m.9.} v l z j d y @ YXYXYX    YX",
    "D cX2X2XqXqX5X5X3X2X;X| R.U.B.B.A.Z.E J J V p p 0 @             ",
    "D qX1X<XIXIXIXIXUXLXSXN.E.H.F.F.D.2.rXxXxX6Xp a 9 +             ",
    "A qX;X-XIXIXUXKXLXAXC.jXE.H.H.J.D.] xXxX6X4Xu r 5 +             ",
    "b 5X-X-XIXUXKXJXLXAXn.kXgXT.J.pX2.oXqX6X:X@Xr w 2 +             ",
    "b 7X=X}.UX8X9X9X4X3X9.lXgXgXiXsX' `./.W.L [.w 9 3 +             ",
    "v 3X=X(.JXCXCXBXMXvX8.FXzXiXaX8.! *X{.].].].9 7 = +             ",
    "k 3X).~.HXvXbXbXxXeXtXGXGXGXfXQ ].]././.^.`.7 7 = .         YXYX",
    "g 1X~.L HX6X6X4X4XoXdXFXGXfXE /.!.!.!.H H /.5 5 = .     YXYXYXYX",
    "h =XL K CXCXMXMXvXeX[ mXtX~ #X@X{.{.].`./.^.5 1 $ O YXYXYXYXYXYX",
    "h {.G V CX>X,X,X{. X[ W T H H H H D A A b ^.4 1 $ O YXYXYXYXYXYX",
    "a ).V B MXbXxX6X6XXXI ! ].].]././.!.!.^./.`.1 - % . YXYXYXYXYXYX",
    "i _.B M vXbXxXxXxX&XOX$X#X@X@X{./.`.`.`././.- - o . YXYXYXYXYXYX",
    "0 !.g d %X%X+X+X'.'.'.^./.^.W.W.W.S S S Z Z o o X . YXYXYXYXYXYX",
    "YX6 < & 2 < 2 < < < < < < < * , , * * * * * . . . YXYXYXYXYXYXYX",
    "YXYXYXYXYXYXYXYXYXYXYXYXYXYXYXYXYXYXYXYXYXYXYXYXYXYXYXYXYXYXYXYX",
    "YXYXYXYXYXYXYXYXYXYXYXYXYXYXYXYXYXYXYXYXYXYXYXYXYXYXYXYXYXYXYXYX",
    "YXYXYXYXYXYXYXYXYXYXYXYXYXYXYXYXYXYXYXYXYXYXYXYXYXYXYXYXYXYXYXYX"
  };

#else // Default DeltaHF theme

const char *
AlcPix::m_about_xpm[]=
  { /* XPM */
    /* columns rows colors chars-per-pixel */
    "32 32 291 2",
    "  	c None",
    ". 	c #0C0C0C",
    "+ 	c #0A0A0A",
    "@ 	c #090909",
    "# 	c #222222",
    "$ 	c #9A9A9A",
    "% 	c #A2A2A2",
    "& 	c #9B9B9B",
    "* 	c #959595",
    "= 	c #858585",
    "- 	c #5C5C5C",
    "; 	c #2B2B2B",
    "> 	c #7D7D7D",
    ", 	c #969696",
    "' 	c #878787",
    ") 	c #989898",
    "! 	c #8B8B8B",
    "~ 	c #777777",
    "{ 	c #292929",
    "] 	c #4F4F4F",
    "^ 	c #A8A8A8",
    "/ 	c #8F8F8F",
    "( 	c #6A6A6A",
    "_ 	c #212121",
    ": 	c #161616",
    "< 	c #6E6E6E",
    "[ 	c #898989",
    "} 	c #888888",
    "| 	c #414141",
    "1 	c #353535",
    "2 	c #2F2F2F",
    "3 	c #5A5A5A",
    "4 	c #8C8C8C",
    "5 	c #555555",
    "6 	c #AFAFAF",
    "7 	c #838383",
    "8 	c #3E3E3E",
    "9 	c #505050",
    "0 	c #A1A1A1",
    "a 	c #7E7E7E",
    "b 	c #454545",
    "c 	c #585958",
    "d 	c #A9A9A9",
    "e 	c #3C3C3C",
    "f 	c #CAD7CA",
    "g 	c #DFE8DF",
    "h 	c #808780",
    "i 	c #979797",
    "j 	c #404440",
    "k 	c #242D24",
    "l 	c #C8D5C8",
    "m 	c #D5DED5",
    "n 	c #B0B9B0",
    "o 	c #788378",
    "p 	c #2B362B",
    "q 	c #A4A4A4",
    "r 	c #A0A0A0",
    "s 	c #3D433D",
    "t 	c #768576",
    "u 	c #576657",
    "v 	c #374237",
    "w 	c #C9D6C9",
    "x 	c #E0E9E0",
    "y 	c #B4BDB4",
    "z 	c #465546",
    "A 	c #344334",
    "B 	c #2E3A2E",
    "C 	c #2B322B",
    "D 	c #3D413D",
    "E 	c #5B635B",
    "F 	c #819081",
    "G 	c #96A996",
    "H 	c #7F907F",
    "I 	c #6C796C",
    "J 	c #516051",
    "K 	c #2C372C",
    "L 	c #C6D5C6",
    "M 	c #D7E0D7",
    "N 	c #B3BCB3",
    "O 	c #798479",
    "P 	c #374637",
    "Q 	c #364536",
    "R 	c #354435",
    "S 	c #334233",
    "T 	c #384738",
    "U 	c #485948",
    "V 	c #9BAE9B",
    "W 	c #9EB19E",
    "X 	c #94A794",
    "Y 	c #889D88",
    "Z 	c #7F947F",
    "` 	c #7A897A",
    " .	c #6B7A6B",
    "..	c #596859",
    "+.	c #374437",
    "@.	c #B0BBB0",
    "#.	c #ABB6AB",
    "$.	c #C7D0C7",
    "%.	c #939E93",
    "&.	c #576457",
    "*.	c #3D4C3D",
    "=.	c #3C4B3C",
    "-.	c #3B4A3B",
    ";.	c #2F3A2F",
    ">.	c #A7A7A7",
    ",.	c #556255",
    "'.	c #8CA18C",
    ").	c #829582",
    "!.	c #758A75",
    "~.	c #687D68",
    "{.	c #6F826F",
    "].	c #728372",
    "^.	c #606F60",
    "/.	c #212A21",
    "(.	c #A6B9A6",
    "_.	c #B1BEB1",
    ":.	c #808B80",
    "<.	c #5B685B",
    "[.	c #4E5D4E",
    "}.	c #4B5C4B",
    "|.	c #4D5E4D",
    "1.	c #4C5C4C",
    "2.	c #313D31",
    "3.	c #9F9F9F",
    "4.	c #B8B8B8",
    "5.	c #7C917C",
    "6.	c #6F846F",
    "7.	c #637863",
    "8.	c #5E735E",
    "9.	c #708370",
    "0.	c #8C9D8C",
    "a.	c #323D32",
    "b.	c #ACBDAC",
    "c.	c #D8E1D8",
    "d.	c #D9E2D9",
    "e.	c #CBD6CB",
    "f.	c #AAB7AA",
    "g.	c #717E71",
    "h.	c #5D6C5D",
    "i.	c #576857",
    "j.	c #566756",
    "k.	c #404D40",
    "l.	c #1F251F",
    "m.	c #2D332D",
    "n.	c #2E342E",
    "o.	c #3D483D",
    "p.	c #6C816C",
    "q.	c #778A77",
    "r.	c #889988",
    "s.	c #657665",
    "t.	c #A9BEA9",
    "u.	c #D5E0D5",
    "v.	c #E1E8E1",
    "w.	c #E3EAE3",
    "x.	c #DBE4DB",
    "y.	c #D2DDD2",
    "z.	c #C1D0C1",
    "A.	c #9DAC9D",
    "B.	c #738473",
    "C.	c #5F705F",
    "D.	c #5B6C5B",
    "E.	c #697E69",
    "F.	c #667B66",
    "G.	c #758875",
    "H.	c #90A190",
    "I.	c #7A8B7A",
    "J.	c #697A69",
    "K.	c #586758",
    "L.	c #232C23",
    "M.	c #A0B5A0",
    "N.	c #E2E9E2",
    "O.	c #DCE5DC",
    "P.	c #D4DFD4",
    "Q.	c #BFD0BF",
    "R.	c #B2C3B2",
    "S.	c #9BAC9B",
    "T.	c #6A796A",
    "U.	c #5C6D5C",
    "V.	c #607560",
    "W.	c #7D907D",
    "X.	c #92A592",
    "Y.	c #889B88",
    "Z.	c #6A7D6A",
    "`.	c #677867",
    " +	c #637463",
    ".+	c #5E6E5E",
    "++	c #5B6A5B",
    "@+	c #283328",
    "#+	c #AFBCAF",
    "$+	c #D0DBD0",
    "%+	c #BBCCBB",
    "&+	c #B7C8B7",
    "*+	c #495649",
    "=+	c #ABBAAB",
    "-+	c #8B9E8B",
    ";+	c #7A8F7A",
    ">+	c #718471",
    ",+	c #667766",
    "'+	c #647564",
    ")+	c #617261",
    "!+	c #3B483B",
    "~+	c #1E251E",
    "{+	c #B2BFB2",
    "]+	c #C3CEC3",
    "^+	c #C3D0C3",
    "/+	c #BDCEBD",
    "(+	c #B5C6B5",
    "_+	c #AABBAA",
    ":+	c #3D4A3D",
    "<+	c #627162",
    "[+	c #525D52",
    "}+	c #8B9A8B",
    "|+	c #788B78",
    "1+	c #768976",
    "2+	c #6B7E6B",
    "3+	c #384538",
    "4+	c #141B15",
    "5+	c #485548",
    "6+	c #95A295",
    "7+	c #ACBBAC",
    "8+	c #AFC0AF",
    "9+	c #9CAB9C",
    "0+	c #354035",
    "a+	c #505D50",
    "b+	c #728572",
    "c+	c #4F5E4F",
    "d+	c #444D44",
    "e+	c #869386",
    "f+	c #394639",
    "g+	c #192019",
    "h+	c #333E33",
    "i+	c #5F6E5F",
    "j+	c #334033",
    "k+	c #4B584B",
    "l+	c #8C9B8C",
    "m+	c #343F34",
    "n+	c #4A554A",
    "o+	c #4D5C4D",
    "p+	c #505F50",
    "q+	c #495249",
    "r+	c #818E81",
    "s+	c #3F4D3E",
    "t+	c #394439",
    "u+	c #3F4C3F",
    "v+	c #6C7F6C",
    "w+	c #798C79",
    "x+	c #516251",
    "y+	c #3F463F",
    "z+	c #3C493C",
    "A+	c #414E41",
    "B+	c #768574",
    "C+	c #889D86",
    "D+	c #819681",
    "E+	c #6D806D",
    "F+	c #657865",
    "G+	c #809580",
    "H+	c #556655",
    "I+	c #546354",
    "J+	c #4B5A4B",
    "K+	c #465346",
    "L+	c #3E4B3E",
    "M+	c #4D5A4D",
    "N+	c #566354",
    "O+	c #7C8C79",
    "P+	c #819580",
    "Q+	c #859C85",
    "R+	c #5A6B5A",
    "S+	c #526152",
    "T+	c #4C5B4C",
    "U+	c #485748",
    "V+	c #434E43",
    "W+	c #333C33",
    "X+	c #5D6D5C",
    "Y+	c #7B8B78",
    "Z+	c #7E937E",
    "`+	c #8AA18A",
    " @	c #5D6E5D",
    ".@	c #536453",
    "+@	c #536253",
    "@@	c #3A473A",
    "#@	c #556354",
    "$@	c #778877",
    "%@	c #869C85",
    "&@	c #91A891",
    "*@	c #607160",
    "=@	c #566556",
    "-@	c #3B463B",
    ";@	c #5A6A59",
    ">@	c #859782",
    ",@	c #5C6B5C",
    "'@	c #415041",
    "                                                                ",
    "                                                                ",
    "                                                                ",
    "                              . + @ @                           ",
    "                          # $ % & * = - ;                       ",
    "                        + > , ' $ ) ! = ~ {                     ",
    "                        ] ^ / ( _ : < [ } |                     ",
    "                        : 1 2 :     3 4 [ |                     ",
    "                                  5 6 7 7 8                     ",
    "                                9 0 a 4 b                       ",
    "                              c d a > e                         ",
    "                        f g h $ $ i j k                         ",
    "                    l m n o p q r 6 s t u v                     ",
    "                w x y o z A B C D E F G H I J K                 ",
    "            L M N O P Q R S T U V W V X Y Z `  ...+.            ",
    "        @.#.$.%.&.*.=.*.*.-.;.r >.6 ,.'.).!.~.{.].^.v /.        ",
    "            (._.:.<.[.}.|.1.2.3.r 4.C 5.6.7.8.9.0.a.            ",
    "          b.c.d.e.f.g.h.i.j.k.l.m.n.o.p.8.q.r.H s.h./.          ",
    "        t.u.v.w.x.y.z.A.B.C.D.D.E.7.F.G.H.I.J.s.h.K...L.        ",
    "      M.f u.v.N.O.P.L Q.R.S.T.U.V.W.X.Y.{.Z.`. +.+++C.s.@+      ",
    "        h.#+P.M u.$+L Q.%+&+b.*+=+-+;+q.>+Z.`.,+'+)+!+~+        ",
    "            h.{+]+^+z./+(+_+:+<+[+}+|+1+>+2+,+,+3+4+            ",
    "              v 5+6+7+8+9+0+a+b+c+d+e+>+2+ +f+g+h+              ",
    "              I i+j+k+l+m+n+C.b+o+p+q+r+s+g+t+u+:+              ",
    "              H 1+v+C.j+5+..s.w+x+J *+y+a.z+!+A+A+              ",
    "              B+C+D+E+F+s. +J.G+H+I+J+K+u+L+u+5+M+              ",
    "                N+O+P+;+1+b+{.Q+R+j.S+T+U+T+V+W+                ",
    "                    X+Y+D+Z Z+`+ @D.j..@+@@@                    ",
    "                        #@$@%@&@ @*@=@-@                        ",
    "                            ;@>@,@'@                            ",
    "                                                                ",
    "                                                                "
  };

const char *
AlcPix::m_alc_xpm[]=
  { /* XPM */
    /* columns rows colors chars-per-pixel */
    "32 32 142 2",
    "   c #000000",
    ".  c #0C0B00",
    "X  c #0B0B0B",
    "o  c #131313",
    "O  c #121318",
    "+  c #1A1A1A",
    "@  c #2D1A00",
    "#  c #292100",
    "$  c #29251E",
    "%  c #222222",
    "&  c #292929",
    "*  c #323232",
    "=  c #36383B",
    "-  c #393836",
    ";  c #3E3E3E",
    ":  c #5F3F06",
    ">  c #534400",
    ",  c #594400",
    "<  c #584A00",
    "1  c #6F4700",
    "2  c #604418",
    "3  c #7F6F00",
    "4  c gray26",
    "5  c #4A4A4A",
    "6  c #4D4D58",
    "7  c #505052",
    "8  c #5A5A5A",
    "9  c #5B5C63",
    "0  c #786448",
    "q  c #646464",
    "w  c #696B6F",
    "e  c #747474",
    "r  c #77797D",
    "t  c #7C7C7C",
    "y  c #7C7D82",
    "u  c #995B0A",
    "i  c #9A7700",
    "p  c #8D682E",
    "a  c #AA7900",
    "s  c #9B7F4C",
    "d  c #867C6A",
    "f  c #817D7A",
    "g  c #9A8B00",
    "h  c #A38002",
    "j  c #AC8800",
    "k  c #A59200",
    "l  c #BE8D2D",
    "z  c #B5A200",
    "x  c #97876C",
    "c  c #958873",
    "v  c #9F9079",
    "b  c #B3B272",
    "n  c #BFB97D",
    "m  c #D59700",
    "M  c #C5B500",
    "N  c #E4AA14",
    "B  c #FBB904",
    "V  c #E9AB38",
    "C  c #FCBC20",
    "Z  c #D1AB66",
    "A  c #F0B355",
    "S  c #E0B96A",
    "D  c #D6C500",
    "F  c #D9C300",
    "G  c #DED100",
    "H  c #E4D700",
    "J  c #EDDE00",
    "K  c #F1C500",
    "L  c #FFC604",
    "P  c #FCC90B",
    "I  c #FFD600",
    "U  c #FFDB00",
    "Y  c #FFD81D",
    "T  c #FFCF2A",
    "R  c #FFD32C",
    "E  c #FFD433",
    "W  c #FFD23A",
    "Q  c #F0E500",
    "!  c #FEE300",
    "~  c #FFE800",
    "^  c #FDE114",
    "/  c #FFF000",
    "(  c #FEFB01",
    ")  c #FDFC28",
    "_  c #FFD541",
    "`  c #FFD64A",
    "'  c #E0E046",
    "]  c #858585",
    "[  c #83868D",
    "{  c #86888C",
    "}  c #8B8B8B",
    "|  c #8A8C91",
    " . c #8E9197",
    ".. c #939393",
    "X. c #9B9B9B",
    "o. c #9D9EA0",
    "O. c #9FA1A6",
    "+. c #AB9B82",
    "@. c #AAA297",
    "#. c #B6A588",
    "$. c #BBAC94",
    "%. c #A3A3A3",
    "&. c #ABABAB",
    "*. c #B2B2B2",
    "=. c #BABABA",
    "-. c #BCBEC0",
    ";. c #BFC1C4",
    ":. c #CBBCA4",
    ">. c #C6C6A3",
    ",. c #D9C8AE",
    "<. c #D8D9BA",
    "1. c #EBDB9F",
    "2. c #F9D78E",
    "3. c #F3D598",
    "4. c #FDD790",
    "5. c #FBDE9E",
    "6. c #EDDEBE",
    "7. c #FFEAAB",
    "8. c #F7EAB4",
    "9. c #FEE6B1",
    "0. c #FFEBB2",
    "q. c #FFF1B2",
    "w. c #C3C3C3",
    "e. c #C5C5C9",
    "r. c #CCCCCC",
    "t. c #CDCFD3",
    "y. c #D0D0C0",
    "u. c #D4D4D3",
    "i. c #D2D2D8",
    "p. c #DBDBDB",
    "a. c #EEDFD0",
    "s. c #EDE7DD",
    "d. c #FCFBD4",
    "f. c #FEF8D9",
    "g. c #E3E3E3",
    "h. c #E7E9ED",
    "j. c #EAEAEA",
    "k. c #E8EBF3",
    "l. c #F2F2F2",
    "z. c #F0F1F8",
    "x. c #FDFDFD",
    "c. c None",
    /* pixels */
    "c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.",
    "c.c.c.c.c.c.c.c.c.c.c.c.    X o + o     c.c.c.c.c.c.c.c.c.c.c.c.",
    "c.c.c.c.c.c.c.c.c.c.  $ q X.=.r.w.w.&.t *   c.c.c.c.c.c.c.c.c.c.",
    "c.c.c.c.c.c.c.c.c.X q w.p.r.=.=.=.w.=.w.=.t +   c.c.c.c.c.c.c.c.",
    "c.c.c.c.c.c.c.  X t j.x.x.x.u.%.%.X.%.&.&.&...%   c.c.c.c.c.c.c.",
    "c.c.c.c.c.c.c.  7 p.x.x.x.x.x.w.} =.g.x.l.u.%.e X   c.c.c.c.c.c.",
    "c.c.c.c.c.c.  o } x.x.x.x.l.=.%.*.x.x.x.x.l.r.] *   c.c.c.c.c.c.",
    "c.c.c.c.c.    & X.x.x.x.l.r.e & } ..x.x.j.p.u.} ;     c.c.c.c.c.",
    "c.c.c.c.c.    % t x.x.l.g.r.9 6 y } x.j.p.r.w.t *     c.c.c.c.c.",
    "c.c.c.c.      o 4 p.x.g.p.y.>.b n f.s.p.t.e.%.5 +       c.c.c.c.",
    "c.c.c.c.        + q p.p.e.' ( ( U L A r.*.] 4 %         c.c.c.c.",
    "c.c.c.c.            ; r.i.<.) / I C s.h.%.&   X         c.c.c.c.",
    "c.c.c.c.          X %.x.x.x.d.^ P a.h.g.s.*.&             c.c.c.",
    "c.c.            X *.x.x.x.x.x.8.1.k.s.p.u.p.*.%   X       c.c.c.",
    "c.    X X X X   ] x.x.x.x.x.x.k.h.g.i.u.r.w.e...o X   X X     c.",
    "    o o o o X 4 l.x.x.x.x.x.j.j.g.p.u.r.w.=.=.=.8     X o X     ",
    "  X X o o + X X.x.x.x.x.x.l.j.g.p.u.r.e.w.=.*.*...o X X         ",
    "          + * h.x.x.x.l.l.j.g.p.t.r.e.w.=.*.&.%.%.5 +           ",
    "c.c.c.c.  o e x.x.x.x.l.j.s.p.u.r.w.-.=.*.&.%.%.@.e %   c.c.c.c.",
    "c.c.c.c.  o &.x.x.x.l.h.g.p.u.r.y.=.=.*.&.%.%.X...[ %   c.c.c.c.",
    "c.c.c.c.  X r.x.x.l.j.s.a.i.t.e.;.=.*.&.&.O.....} } +   c.c.c.c.",
    "c.c.c.c.c.X s.x.l.j.g.p.u.r.e.;.*.*.&.%.O.X.....} } +   c.c.c.c.",
    "c.c.c.c.c.X p.x.h.g.p.i.r.e.-.=.*.&.&.@.......} } 8   c.c.c.c.c.",
    "c.c.c.c.c.c.6 h.s.p.u.r.e.-.=.*.&.%.o.X.....] ] t o   c.c.c.c.c.",
    "c.c.c.c.c.c.c.9 t.r.;.;.-.=.*.&.%.o.X...{ ] r w O   c.c.c.c.c.c.",
    "c.c.c.c.c.c.u 2 #.,.:.$.@.o.O.X.X.| [ f c v $.v 0 p : c.c.c.c.c.",
    "c.c.c.c.1 V 4.0.0.0.9.9.3.Z x | } t s S 5.7.7.q.q.7.2.l @ c.c.c.",
    "c.c.c.  m E ` _ _ _ W _ ` T N }  .d B R E E E E E E W Y a   c.c.",
    "c.c.c.  i U U U ~ U ~ U U U a - = $ j U ~ ~ ~ ~ ~ ~ U K ,   c.c.",
    "c.c.c.c.  > k D J Q J F k <       c.  > g M G H D z 3 #   c.c.c.",
    "c.c.c.c.c.c.    . . . .     c.c.c.c.c.c.    . .         c.c.c.c.",
    "c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c."
  };

const char *
AlcPix::m_copy_xpm[]=
  { /* XPM */
    /* columns rows colors chars-per-pixel */
    "32 32 258 2",
    "  	c None",
    ". 	c #F8F1E4",
    "+ 	c #EAD097",
    "@ 	c #9F8753",
    "# 	c #CE920B",
    "$ 	c #865F07",
    "% 	c #F1E2C0",
    "& 	c #F9F5EF",
    "* 	c #583E04",
    "= 	c #634504",
    "- 	c #E0BD6D",
    "; 	c #785505",
    "> 	c #CAD7CA",
    ", 	c #C8D5C8",
    "' 	c #D5DED5",
    ") 	c #B0B9B0",
    "! 	c #788378",
    "~ 	c #768576",
    "{ 	c #576657",
    "] 	c #374237",
    "^ 	c #C9D6C9",
    "/ 	c #E0E9E0",
    "( 	c #B4BDB4",
    "_ 	c #465546",
    ": 	c #344334",
    "< 	c #394839",
    "[ 	c #9FB29F",
    "} 	c #96A996",
    "| 	c #7F907F",
    "1 	c #6C796C",
    "2 	c #516051",
    "3 	c #2C372C",
    "4 	c #C6D5C6",
    "5 	c #D7E0D7",
    "6 	c #B3BCB3",
    "7 	c #798479",
    "8 	c #374637",
    "9 	c #364536",
    "0 	c #324132",
    "a 	c #475847",
    "b 	c #80682F",
    "c 	c #A2AD97",
    "d 	c #A89478",
    "e 	c #9A896F",
    "f 	c #89967F",
    "g 	c #7F947F",
    "h 	c #7A897A",
    "i 	c #6B7A6B",
    "j 	c #596859",
    "k 	c #374437",
    "l 	c #B0BBB0",
    "m 	c #ABB6AB",
    "n 	c #C7D0C7",
    "o 	c #939E93",
    "p 	c #576457",
    "q 	c #3D4C3D",
    "r 	c #3C4B3C",
    "s 	c #3A493A",
    "t 	c #344040",
    "u 	c #3C3D74",
    "v 	c #3E4A4B",
    "w 	c #8F917B",
    "x 	c #BC7A57",
    "y 	c #D7683F",
    "z 	c #BB4E21",
    "A 	c #935834",
    "B 	c #7A7F67",
    "C 	c #687D68",
    "D 	c #6F826F",
    "E 	c #728372",
    "F 	c #606F60",
    "G 	c #212A21",
    "H 	c #A6B9A6",
    "I 	c #B1BEB1",
    "J 	c #808B80",
    "K 	c #5B685B",
    "L 	c #4D5C4D",
    "M 	c #3E4B4F",
    "N 	c #28295F",
    "O 	c #272372",
    "P 	c #363070",
    "Q 	c #272551",
    "R 	c #7F4B35",
    "S 	c #D06E47",
    "T 	c #EE8C6A",
    "U 	c #CF592E",
    "V 	c #9D3508",
    "W 	c #864F2B",
    "X 	c #5E735E",
    "Y 	c #708370",
    "Z 	c #8C9D8C",
    "` 	c #323D32",
    " .	c #ACBDAC",
    "..	c #D8E1D8",
    "+.	c #D9E2D9",
    "@.	c #CBD6CB",
    "#.	c #AAB7AA",
    "$.	c #5D6771",
    "%.	c #2A2D63",
    "&.	c #171264",
    "*.	c #1F1A5E",
    "=.	c #1D1A45",
    "-.	c #181631",
    ";.	c #62260D",
    ">.	c #A0512F",
    ",.	c #D06D3F",
    "'.	c #B64D1C",
    ").	c #8B451F",
    "!.	c #836E53",
    "~.	c #889988",
    "{.	c #657665",
    "].	c #5D6C5D",
    "^.	c #A9BEA9",
    "/.	c #D5E0D5",
    "(.	c #E1E8E1",
    "_.	c #E3EAE3",
    ":.	c #DBE4DB",
    "<.	c #D2DDD2",
    "[.	c #C1D0C1",
    "}.	c #9DAC9D",
    "|.	c #58636F",
    "1.	c #323463",
    "2.	c #1D1A46",
    "3.	c #110E24",
    "4.	c #32190C",
    "5.	c #4F220B",
    "6.	c #7F4D2A",
    "7.	c #7F7157",
    "8.	c #90A190",
    "9.	c #7A8B7A",
    "0.	c #697A69",
    "a.	c #586758",
    "b.	c #232C23",
    "c.	c #A0B5A0",
    "d.	c #E2E9E2",
    "e.	c #DCE5DC",
    "f.	c #D4DFD4",
    "g.	c #BFD0BF",
    "h.	c #B2C3B2",
    "i.	c #94A499",
    "j.	c #515A67",
    "k.	c #2D2F48",
    "l.	c #3A392E",
    "m.	c #6E6A56",
    "n.	c #919E8A",
    "o.	c #889B88",
    "p.	c #6A7D6A",
    "q.	c #677867",
    "r.	c #637463",
    "s.	c #5E6E5E",
    "t.	c #5B6A5B",
    "u.	c #5F705F",
    "v.	c #283328",
    "w.	c #AFBCAF",
    "x.	c #D0DBD0",
    "y.	c #BBCCBB",
    "z.	c #B7C8B7",
    "A.	c #495649",
    "B.	c #ABBAAB",
    "C.	c #8B9E8B",
    "D.	c #7A8F7A",
    "E.	c #778A77",
    "F.	c #718471",
    "G.	c #667766",
    "H.	c #647564",
    "I.	c #617261",
    "J.	c #3B483B",
    "K.	c #1E251E",
    "L.	c #B2BFB2",
    "M.	c #C3CEC3",
    "N.	c #C3D0C3",
    "O.	c #BDCEBD",
    "P.	c #B5C6B5",
    "Q.	c #AABBAA",
    "R.	c #3D4A3D",
    "S.	c #627162",
    "T.	c #525D52",
    "U.	c #8B9A8B",
    "V.	c #788B78",
    "W.	c #768976",
    "X.	c #6B7E6B",
    "Y.	c #384538",
    "Z.	c #141B15",
    "`.	c #485548",
    " +	c #95A295",
    ".+	c #ACBBAC",
    "++	c #AFC0AF",
    "@+	c #9CAB9C",
    "#+	c #354035",
    "$+	c #505D50",
    "%+	c #728572",
    "&+	c #4F5E4F",
    "*+	c #444D44",
    "=+	c #869386",
    "-+	c #394639",
    ";+	c #192019",
    ">+	c #333E33",
    ",+	c #5F6E5F",
    "'+	c #334033",
    ")+	c #4B584B",
    "!+	c #8C9B8C",
    "~+	c #343F34",
    "{+	c #4A554A",
    "]+	c #505F50",
    "^+	c #495249",
    "/+	c #818E81",
    "(+	c #3F4D3E",
    "_+	c #394439",
    ":+	c #3F4C3F",
    "<+	c #6C7F6C",
    "[+	c #798C79",
    "}+	c #516251",
    "|+	c #3F463F",
    "1+	c #3C493C",
    "2+	c #414E41",
    "3+	c #768574",
    "4+	c #889D86",
    "5+	c #819681",
    "6+	c #6D806D",
    "7+	c #657865",
    "8+	c #809580",
    "9+	c #556655",
    "0+	c #546354",
    "a+	c #4B5A4B",
    "b+	c #465346",
    "c+	c #3E4B3E",
    "d+	c #4D5A4D",
    "e+	c #566354",
    "f+	c #7C8C79",
    "g+	c #819580",
    "h+	c #859C85",
    "i+	c #5A6B5A",
    "j+	c #566756",
    "k+	c #526152",
    "l+	c #4C5B4C",
    "m+	c #485748",
    "n+	c #434E43",
    "o+	c #333C33",
    "p+	c #5D6D5C",
    "q+	c #7B8B78",
    "r+	c #7E937E",
    "s+	c #8AA18A",
    "t+	c #5D6E5D",
    "u+	c #5B6C5B",
    "v+	c #536453",
    "w+	c #536253",
    "x+	c #3A473A",
    "y+	c #556354",
    "z+	c #778877",
    "A+	c #869C85",
    "B+	c #91A891",
    "C+	c #607160",
    "D+	c #566556",
    "E+	c #3B463B",
    "F+	c #5A6A59",
    "G+	c #859782",
    "H+	c #5C6B5C",
    "I+	c #415041",
    "                                                                ",
    "                                                                ",
    "                                                                ",
    "                            . + + + @                           ",
    "                            + # # # $                           ",
    "                            + # # # $                           ",
    "                            + # # # $                           ",
    "                            + # # # $                           ",
    "                            + # # # $                           ",
    "                      % + + & # # # * $ $ =                     ",
    "                        - # # # # # # # ;                       ",
    "                        > - # # # # # ;                         ",
    "                    , ' ) ! - # # # ; ~ { ]                     ",
    "                ^ / ( ! _ : < - # ; [ } | 1 2 3                 ",
    "            4 5 6 7 8 9 : 0 8 a b c d e f g h i j k             ",
    "        l m n o p q r r s t u v w x y z A B C D E F ] G         ",
    "            H I J K L M N O P Q R S T U V W X Y Z `             ",
    "           ...+.@.#.$.%.&.*.=.-.;.>.,.'.).!.~.| {.].G           ",
    "        ^./.(._.:.<.[.}.|.1.2.3.4.5.6.7.8.9.0.{.].a.j b.        ",
    "      c.> /.(.d.e.f.4 g.h.i.j.k.l.m.n.o.D p.q.r.s.t.u.{.v.      ",
    "        ].w.f.5 /.x.4 g.y.z. .A.B.C.D.E.F.p.q.G.H.I.J.K.        ",
    "            ].L.M.N.[.O.P.Q.R.S.T.U.V.W.F.X.G.G.Y.Z.            ",
    "              ] `. +.+++@+#+$+%+&+*+=+F.X.r.-+;+>+              ",
    "              1 ,+'+)+!+~+{+u.%+L ]+^+/+(+;+_+:+R.              ",
    "              | W.<+u.'+`.j {.[+}+2 A.|+` 1+J.2+2+              ",
    "              3+4+5+6+7+{.r.0.8+9+0+a+b+:+c+:+`.d+              ",
    "                e+f+g+D.W.%+D h+i+j+k+l+m+l+n+o+                ",
    "                    p+q+5+g r+s+t+u+j+v+w+x+                    ",
    "                        y+z+A+B+t+C+D+E+                        ",
    "                            F+G+H+I+                            ",
    "                                                                ",
    "                                                                "
  };

const char *
AlcPix::m_open_xpm[]=
  { /* XPM */
    /* columns rows colors chars-per-pixel */
    "32 32 258 2",
    "  	c None",
    ". 	c #CAADA4",
    "+ 	c #B08476",
    "@ 	c #884631",
    "# 	c #6E3827",
    "$ 	c #3D1F15",
    "% 	c #522A1D",
    "& 	c #5F3122",
    "* 	c #B2887A",
    "= 	c #B68E81",
    "- 	c #CAD7CA",
    "; 	c #DFE8DF",
    "> 	c #2A352A",
    ", 	c #C8D5C8",
    "' 	c #D5DED5",
    ") 	c #B0B9B0",
    "! 	c #788378",
    "~ 	c #768576",
    "{ 	c #576657",
    "] 	c #374237",
    "^ 	c #C9D6C9",
    "/ 	c #E0E9E0",
    "( 	c #B4BDB4",
    "_ 	c #465546",
    ": 	c #344334",
    "< 	c #8A6559",
    "[ 	c #3E1F15",
    "} 	c #96A996",
    "| 	c #7F907F",
    "1 	c #6C796C",
    "2 	c #516051",
    "3 	c #2C372C",
    "4 	c #C6D5C6",
    "5 	c #D7E0D7",
    "6 	c #B3BCB3",
    "7 	c #798479",
    "8 	c #374637",
    "9 	c #364536",
    "0 	c #324132",
    "a 	c #475847",
    "b 	c #9AAD9A",
    "c 	c #A2AD97",
    "d 	c #A89478",
    "e 	c #9A896F",
    "f 	c #89967F",
    "g 	c #7F947F",
    "h 	c #7A897A",
    "i 	c #6B7A6B",
    "j 	c #596859",
    "k 	c #374437",
    "l 	c #B0BBB0",
    "m 	c #ABB6AB",
    "n 	c #C7D0C7",
    "o 	c #939E93",
    "p 	c #576457",
    "q 	c #3D4C3D",
    "r 	c #3C4B3C",
    "s 	c #3A493A",
    "t 	c #344040",
    "u 	c #3C3D74",
    "v 	c #3E4A4B",
    "w 	c #8F917B",
    "x 	c #BC7A57",
    "y 	c #D7683F",
    "z 	c #BB4E21",
    "A 	c #935834",
    "B 	c #7A7F67",
    "C 	c #687D68",
    "D 	c #6F826F",
    "E 	c #728372",
    "F 	c #606F60",
    "G 	c #212A21",
    "H 	c #A6B9A6",
    "I 	c #B1BEB1",
    "J 	c #808B80",
    "K 	c #5B685B",
    "L 	c #4D5C4D",
    "M 	c #3E4B4F",
    "N 	c #28295F",
    "O 	c #272372",
    "P 	c #363070",
    "Q 	c #272551",
    "R 	c #7F4B35",
    "S 	c #D06E47",
    "T 	c #EE8C6A",
    "U 	c #CF592E",
    "V 	c #9D3508",
    "W 	c #864F2B",
    "X 	c #5E735E",
    "Y 	c #708370",
    "Z 	c #8C9D8C",
    "` 	c #323D32",
    " .	c #ACBDAC",
    "..	c #D8E1D8",
    "+.	c #D9E2D9",
    "@.	c #CBD6CB",
    "#.	c #AAB7AA",
    "$.	c #5D6771",
    "%.	c #2A2D63",
    "&.	c #171264",
    "*.	c #1F1A5E",
    "=.	c #1D1A45",
    "-.	c #181631",
    ";.	c #62260D",
    ">.	c #A0512F",
    ",.	c #D06D3F",
    "'.	c #B64D1C",
    ").	c #8B451F",
    "!.	c #836E53",
    "~.	c #889988",
    "{.	c #657665",
    "].	c #5D6C5D",
    "^.	c #A9BEA9",
    "/.	c #D5E0D5",
    "(.	c #E1E8E1",
    "_.	c #E3EAE3",
    ":.	c #DBE4DB",
    "<.	c #D2DDD2",
    "[.	c #C1D0C1",
    "}.	c #9DAC9D",
    "|.	c #58636F",
    "1.	c #323463",
    "2.	c #1D1A46",
    "3.	c #110E24",
    "4.	c #32190C",
    "5.	c #4F220B",
    "6.	c #7F4D2A",
    "7.	c #7F7157",
    "8.	c #90A190",
    "9.	c #7A8B7A",
    "0.	c #697A69",
    "a.	c #586758",
    "b.	c #232C23",
    "c.	c #A0B5A0",
    "d.	c #E2E9E2",
    "e.	c #DCE5DC",
    "f.	c #D4DFD4",
    "g.	c #BFD0BF",
    "h.	c #B2C3B2",
    "i.	c #94A499",
    "j.	c #515A67",
    "k.	c #2D2F48",
    "l.	c #3A392E",
    "m.	c #6E6A56",
    "n.	c #919E8A",
    "o.	c #889B88",
    "p.	c #6A7D6A",
    "q.	c #677867",
    "r.	c #637463",
    "s.	c #5E6E5E",
    "t.	c #5B6A5B",
    "u.	c #5F705F",
    "v.	c #283328",
    "w.	c #AFBCAF",
    "x.	c #D0DBD0",
    "y.	c #BBCCBB",
    "z.	c #B7C8B7",
    "A.	c #495649",
    "B.	c #ABBAAB",
    "C.	c #8B9E8B",
    "D.	c #7A8F7A",
    "E.	c #778A77",
    "F.	c #718471",
    "G.	c #667766",
    "H.	c #647564",
    "I.	c #617261",
    "J.	c #3B483B",
    "K.	c #1E251E",
    "L.	c #B2BFB2",
    "M.	c #C3CEC3",
    "N.	c #C3D0C3",
    "O.	c #BDCEBD",
    "P.	c #B5C6B5",
    "Q.	c #AABBAA",
    "R.	c #3D4A3D",
    "S.	c #627162",
    "T.	c #525D52",
    "U.	c #8B9A8B",
    "V.	c #788B78",
    "W.	c #768976",
    "X.	c #6B7E6B",
    "Y.	c #384538",
    "Z.	c #141B15",
    "`.	c #485548",
    " +	c #95A295",
    ".+	c #ACBBAC",
    "++	c #AFC0AF",
    "@+	c #9CAB9C",
    "#+	c #354035",
    "$+	c #505D50",
    "%+	c #728572",
    "&+	c #4F5E4F",
    "*+	c #444D44",
    "=+	c #869386",
    "-+	c #394639",
    ";+	c #192019",
    ">+	c #333E33",
    ",+	c #5F6E5F",
    "'+	c #334033",
    ")+	c #4B584B",
    "!+	c #8C9B8C",
    "~+	c #343F34",
    "{+	c #4A554A",
    "]+	c #505F50",
    "^+	c #495249",
    "/+	c #818E81",
    "(+	c #3F4D3E",
    "_+	c #394439",
    ":+	c #3F4C3F",
    "<+	c #6C7F6C",
    "[+	c #798C79",
    "}+	c #516251",
    "|+	c #3F463F",
    "1+	c #3C493C",
    "2+	c #414E41",
    "3+	c #768574",
    "4+	c #889D86",
    "5+	c #819681",
    "6+	c #6D806D",
    "7+	c #657865",
    "8+	c #809580",
    "9+	c #556655",
    "0+	c #546354",
    "a+	c #4B5A4B",
    "b+	c #465346",
    "c+	c #3E4B3E",
    "d+	c #4D5A4D",
    "e+	c #566354",
    "f+	c #7C8C79",
    "g+	c #819580",
    "h+	c #859C85",
    "i+	c #5A6B5A",
    "j+	c #566756",
    "k+	c #526152",
    "l+	c #4C5B4C",
    "m+	c #485748",
    "n+	c #434E43",
    "o+	c #333C33",
    "p+	c #5D6D5C",
    "q+	c #7B8B78",
    "r+	c #7E937E",
    "s+	c #8AA18A",
    "t+	c #5D6E5D",
    "u+	c #5B6C5B",
    "v+	c #536453",
    "w+	c #536253",
    "x+	c #3A473A",
    "y+	c #556354",
    "z+	c #778877",
    "A+	c #869C85",
    "B+	c #91A891",
    "C+	c #607160",
    "D+	c #566556",
    "E+	c #3B463B",
    "F+	c #5A6A59",
    "G+	c #859782",
    "H+	c #5C6B5C",
    "I+	c #415041",
    "                                                                ",
    "                                                                ",
    "                                .                               ",
    "                              + @ #                             ",
    "                            + @ @ @ #                           ",
    "                          + @ @ @ @ @ #                         ",
    "                        + @ @ @ @ @ @ @ #                       ",
    "                      + @ @ @ @ @ @ $ % % &                     ",
    "                            * @ @ @ %                           ",
    "                            = @ @ @ %                           ",
    "                            = @ @ @ %                           ",
    "                        - ; = @ @ @ % >                         ",
    "                    , ' ) ! = @ @ @ % ~ { ]                     ",
    "                ^ / ( ! _ : < % % % [ } | 1 2 3                 ",
    "            4 5 6 7 8 9 : 0 8 a b c d e f g h i j k             ",
    "        l m n o p q r r s t u v w x y z A B C D E F ] G         ",
    "            H I J K L M N O P Q R S T U V W X Y Z `             ",
    "           ...+.@.#.$.%.&.*.=.-.;.>.,.'.).!.~.| {.].G           ",
    "        ^./.(._.:.<.[.}.|.1.2.3.4.5.6.7.8.9.0.{.].a.j b.        ",
    "      c.- /.(.d.e.f.4 g.h.i.j.k.l.m.n.o.D p.q.r.s.t.u.{.v.      ",
    "        ].w.f.5 /.x.4 g.y.z. .A.B.C.D.E.F.p.q.G.H.I.J.K.        ",
    "            ].L.M.N.[.O.P.Q.R.S.T.U.V.W.F.X.G.G.Y.Z.            ",
    "              ] `. +.+++@+#+$+%+&+*+=+F.X.r.-+;+>+              ",
    "              1 ,+'+)+!+~+{+u.%+L ]+^+/+(+;+_+:+R.              ",
    "              | W.<+u.'+`.j {.[+}+2 A.|+` 1+J.2+2+              ",
    "              3+4+5+6+7+{.r.0.8+9+0+a+b+:+c+:+`.d+              ",
    "                e+f+g+D.W.%+D h+i+j+k+l+m+l+n+o+                ",
    "                    p+q+5+g r+s+t+u+j+v+w+x+                    ",
    "                        y+z+A+B+t+C+D+E+                        ",
    "                            F+G+H+I+                            ",
    "                                                                ",
    "                                                                "
  };

const char *
AlcPix::m_saveas_xpm[]=
  { /* XPM */
    /* columns rows colors chars-per-pixel */
    "32 32 251 2",
    "  	c None",
    ". 	c #DFE3DE",
    "+ 	c #92A28D",
    "@ 	c #97A692",
    "# 	c #5D6A59",
    "$ 	c #5D7555",
    "% 	c #3B4A36",
    "& 	c #9BAA96",
    "* 	c #B0BCAC",
    "= 	c #9CAB97",
    "- 	c #A8B5A4",
    "; 	c #C9D1C8",
    "> 	c #303E2D",
    ", 	c #374633",
    "' 	c #788C71",
    ") 	c #40503A",
    "! 	c #CAD7CA",
    "~ 	c #C8D5C8",
    "{ 	c #D5DED5",
    "] 	c #B0B9B0",
    "^ 	c #788378",
    "/ 	c #768576",
    "( 	c #576657",
    "_ 	c #374237",
    ": 	c #C9D6C9",
    "< 	c #E0E9E0",
    "[ 	c #B4BDB4",
    "} 	c #465546",
    "| 	c #344334",
    "1 	c #394839",
    "2 	c #9FB29F",
    "3 	c #96A996",
    "4 	c #7F907F",
    "5 	c #6C796C",
    "6 	c #516051",
    "7 	c #2C372C",
    "8 	c #C6D5C6",
    "9 	c #D7E0D7",
    "0 	c #B3BCB3",
    "a 	c #798479",
    "b 	c #374637",
    "c 	c #364536",
    "d 	c #354435",
    "e 	c #334233",
    "f 	c #384738",
    "g 	c #485948",
    "h 	c #444F40",
    "i 	c #9EB19E",
    "j 	c #9BAE9B",
    "k 	c #94A794",
    "l 	c #889D88",
    "m 	c #7F947F",
    "n 	c #7A897A",
    "o 	c #6B7A6B",
    "p 	c #596859",
    "q 	c #374437",
    "r 	c #B0BBB0",
    "s 	c #ABB6AB",
    "t 	c #C7D0C7",
    "u 	c #939E93",
    "v 	c #576457",
    "w 	c #3D4C3D",
    "x 	c #3C4B3C",
    "y 	c #3B4A3B",
    "z 	c #3E4D3E",
    "A 	c #91A691",
    "B 	c #8CA18C",
    "C 	c #829582",
    "D 	c #758A75",
    "E 	c #687D68",
    "F 	c #6F826F",
    "G 	c #728372",
    "H 	c #606F60",
    "I 	c #212A21",
    "J 	c #A6B9A6",
    "K 	c #B1BEB1",
    "L 	c #808B80",
    "M 	c #5B685B",
    "N 	c #4E5D4E",
    "O 	c #4B5C4B",
    "P 	c #4D5E4D",
    "Q 	c #4C5C4C",
    "R 	c #4A5B4A",
    "S 	c #4E5F4E",
    "T 	c #839883",
    "U 	c #849984",
    "V 	c #819681",
    "W 	c #7C917C",
    "X 	c #6F846F",
    "Y 	c #637863",
    "Z 	c #5E735E",
    "` 	c #708370",
    " .	c #8C9D8C",
    "..	c #323D32",
    "+.	c #ACBDAC",
    "@.	c #D8E1D8",
    "#.	c #D9E2D9",
    "$.	c #CBD6CB",
    "%.	c #AAB7AA",
    "&.	c #717E71",
    "*.	c #5D6C5D",
    "=.	c #576857",
    "-.	c #566756",
    ";.	c #546554",
    ">.	c #788D78",
    ",.	c #778C77",
    "'.	c #728772",
    ").	c #6C816C",
    "!.	c #778A77",
    "~.	c #889988",
    "{.	c #657665",
    "].	c #A9BEA9",
    "^.	c #D5E0D5",
    "/.	c #E1E8E1",
    "(.	c #E3EAE3",
    "_.	c #DBE4DB",
    ":.	c #D2DDD2",
    "<.	c #C1D0C1",
    "[.	c #9DAC9D",
    "}.	c #738473",
    "|.	c #5F705F",
    "1.	c #5B6C5B",
    "2.	c #697E69",
    "3.	c #667B66",
    "4.	c #758875",
    "5.	c #90A190",
    "6.	c #7A8B7A",
    "7.	c #697A69",
    "8.	c #586758",
    "9.	c #232C23",
    "0.	c #A0B5A0",
    "a.	c #E2E9E2",
    "b.	c #DCE5DC",
    "c.	c #D4DFD4",
    "d.	c #BFD0BF",
    "e.	c #B2C3B2",
    "f.	c #9BAC9B",
    "g.	c #6A796A",
    "h.	c #5C6D5C",
    "i.	c #607560",
    "j.	c #7D907D",
    "k.	c #92A592",
    "l.	c #889B88",
    "m.	c #6A7D6A",
    "n.	c #677867",
    "o.	c #637463",
    "p.	c #5E6E5E",
    "q.	c #5B6A5B",
    "r.	c #283328",
    "s.	c #AFBCAF",
    "t.	c #D0DBD0",
    "u.	c #BBCCBB",
    "v.	c #B7C8B7",
    "w.	c #495649",
    "x.	c #ABBAAB",
    "y.	c #8B9E8B",
    "z.	c #7A8F7A",
    "A.	c #718471",
    "B.	c #667766",
    "C.	c #647564",
    "D.	c #617261",
    "E.	c #3B483B",
    "F.	c #1E251E",
    "G.	c #B2BFB2",
    "H.	c #C3CEC3",
    "I.	c #C3D0C3",
    "J.	c #BDCEBD",
    "K.	c #B5C6B5",
    "L.	c #AABBAA",
    "M.	c #3D4A3D",
    "N.	c #627162",
    "O.	c #525D52",
    "P.	c #8B9A8B",
    "Q.	c #788B78",
    "R.	c #768976",
    "S.	c #6B7E6B",
    "T.	c #384538",
    "U.	c #141B15",
    "V.	c #485548",
    "W.	c #95A295",
    "X.	c #ACBBAC",
    "Y.	c #AFC0AF",
    "Z.	c #9CAB9C",
    "`.	c #354035",
    " +	c #505D50",
    ".+	c #728572",
    "++	c #4F5E4F",
    "@+	c #444D44",
    "#+	c #869386",
    "$+	c #394639",
    "%+	c #192019",
    "&+	c #333E33",
    "*+	c #5F6E5F",
    "=+	c #334033",
    "-+	c #4B584B",
    ";+	c #8C9B8C",
    ">+	c #343F34",
    ",+	c #4A554A",
    "'+	c #4D5C4D",
    ")+	c #505F50",
    "!+	c #495249",
    "~+	c #818E81",
    "{+	c #3F4D3E",
    "]+	c #394439",
    "^+	c #3F4C3F",
    "/+	c #6C7F6C",
    "(+	c #798C79",
    "_+	c #516251",
    ":+	c #3F463F",
    "<+	c #3C493C",
    "[+	c #414E41",
    "}+	c #768574",
    "|+	c #889D86",
    "1+	c #6D806D",
    "2+	c #657865",
    "3+	c #809580",
    "4+	c #556655",
    "5+	c #546354",
    "6+	c #4B5A4B",
    "7+	c #465346",
    "8+	c #3E4B3E",
    "9+	c #4D5A4D",
    "0+	c #566354",
    "a+	c #7C8C79",
    "b+	c #819580",
    "c+	c #859C85",
    "d+	c #5A6B5A",
    "e+	c #526152",
    "f+	c #4C5B4C",
    "g+	c #485748",
    "h+	c #434E43",
    "i+	c #333C33",
    "j+	c #5D6D5C",
    "k+	c #7B8B78",
    "l+	c #7E937E",
    "m+	c #8AA18A",
    "n+	c #5D6E5D",
    "o+	c #536453",
    "p+	c #536253",
    "q+	c #3A473A",
    "r+	c #556354",
    "s+	c #778877",
    "t+	c #869C85",
    "u+	c #91A891",
    "v+	c #607160",
    "w+	c #566556",
    "x+	c #3B463B",
    "y+	c #5A6A59",
    "z+	c #859782",
    "A+	c #5C6B5C",
    "B+	c #415041",
    "                                                                ",
    "                                                                ",
    "                                                                ",
    "                            . + @ @ #                           ",
    "                            @ $ $ $ %                           ",
    "                            @ $ $ $ %                           ",
    "                            @ $ $ $ %                           ",
    "                            @ $ $ $ %                           ",
    "                            & $ $ $ %                           ",
    "                      * = - ; $ $ $ > % % ,                     ",
    "                        ' $ $ $ $ $ $ $ )                       ",
    "                        ! ' $ $ $ $ $ )                         ",
    "                    ~ { ] ^ ' $ $ $ ) / ( _                     ",
    "                : < [ ^ } | 1 ' $ ) 2 3 4 5 6 7                 ",
    "            8 9 0 a b c d e f g h i j k l m n o p q             ",
    "        r s t u v w x w w y z g A k A B C D E F G H _ I         ",
    "            J K L M N O P Q R S T U V W X Y Z `  ...            ",
    "          +.@.#.$.%.&.*.=.-.;.;.>.,.'.).Z !.~.4 {.*.I           ",
    "        ].^./.(._.:.<.[.}.|.1.1.2.Y 3.4.5.6.7.{.*.8.p 9.        ",
    "      0.! ^./.a.b.c.8 d.e.f.g.h.i.j.k.l.F m.n.o.p.q.|.{.r.      ",
    "        *.s.c.9 ^.t.8 d.u.v.+.w.x.y.z.!.A.m.n.B.C.D.E.F.        ",
    "            *.G.H.I.<.J.K.L.M.N.O.P.Q.R.A.S.B.B.T.U.            ",
    "              _ V.W.X.Y.Z.`. +.+++@+#+A.S.o.$+%+&+              ",
    "              5 *+=+-+;+>+,+|..+'+)+!+~+{+%+]+^+M.              ",
    "              4 R./+|.=+V.p {.(+_+6 w.:+..<+E.[+[+              ",
    "              }+|+V 1+2+{.o.7.3+4+5+6+7+^+8+^+V.9+              ",
    "                0+a+b+z.R..+F c+d+-.e+f+g+f+h+i+                ",
    "                    j+k+V m l+m+n+1.-.o+p+q+                    ",
    "                        r+s+t+u+n+v+w+x+                        ",
    "                            y+z+A+B+                            ",
    "                                                                ",
    "                                                                "
  };

#endif
