//
// This file is part of the aMule AdunanzA Project (mod of official aMule)
//
// Copyright (c) 2003-2008 aMule AdunanzA Team ( http://www.adunanza.net )
//
// Any parts of this program derived from the xMule, lMule, eMule or aMule project,
// or contributed by third-party developers are copyrighted by their
// respective authors.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301, USA
//

#if defined(_DEBUG)
#include "DebugHelpers.h"
#endif

#include "amule.h"
#include "updownclient.h"
#include "Friend.h"
#include "ClientList.h"
#include "OtherFunctions.h"
#include "PartFile.h"
#include "ListenSocket.h"
#include "Friend.h"
#include <zlib.h>
#include "Packet.h"
#include "SafeFile.h"
#include "Preferences.h"
#include "Statistics.h"
#include "ClientCredits.h"
#include "IPFilter.h"
#include "UploadQueue.h"
#include "DownloadQueue.h"
#include "SearchList.h"
#include "SharedFileList.h"

// Mr Hyde per Clarensio
#include <protocol/ed2k/ClientSoftware.h> // per SO_AMULE/SO_EMULE
#include "NetworkFunctions.h"


#if defined(__USE_KAD__)
#include "Kademlia/Kademlia/Kademlia.h"
#include "Kademlia/Net/KademliaUDPListener.h"
#endif

#if !defined(_CONSOLE) && !defined(AMULE_DAEMON)
#include "TransferWnd.h"
#include "ServerWnd.h"
#include "ChatWnd.h"
#endif

#include <cmath>

#include "AdunanzA.h"
#include "RemoteSettings.h"
#include "common/Constants.h"

// Mr Hyde Patch BEGIN
#include "Logger.h"
// Mr Hyde Patch END

// Inclusi per il parsing sul file per Updater
#include <cstdio>
#include <cstdlib>

// #define thePrefs (*(theApp->glob_prefs)) Mr Hyde: thePrefs e' la definizione di una classe statica (vedi src/Preferences.h)
// Funzione molto semplice che ritorna un 
// valore booleano vero se l'ip passatogli in input 
// appartiene alla rete FastWeb italiana.
/*
MAN Milano........................   1.0.0.0/8
MAN Milano hinterland Nord........   2.0.0.0/8
MAN Genova........................   5.0.0.0/8
MAN Veneto........................  11.0.0.0/8
MAN Milano hinterland Sud.........  14.0.0.0/8
MAN Ancona........................  21.0.0.0/8
MAN Grosseto......................  22.0.0.0/8
MAN Roma..........................  23.0.0.0/8
MAN Toscana.......................  27.0.0.0/8
MAN Piemonte......................  28.0.0.0/8
MAN Triveneto.....................  29.0.0.0/8
MAN Bari..........................  31.0.0.0/8
MAN Sicilia.......................  36.0.0.0/8
MAN Bologna.......................  37.0.0.0/8
MAN Napoli........................  39.0.0.0/8
MAN Torino........................  41.0.0.0/8
MAN Reggio Emilia.................  42.0.0.0/8
MAN Cagliari......................  51.0.0.0/8

Routers & OAM.....................  10.0.0.0/8
Organization, Administration & Management (ad. es.: Server interni ntp, voip, billing etc. etc.)
*/

bool AduIsFastWebLANIP(uint32 ip)
{
	switch (ip & 0xff) {
		case MAN_ROMA:
		case MAN_MILANO:
		case MAN_MILANO_H_NORD:
		case MAN_MILANO_H_SUD:
		case MAN_GENOVA:
		case MAN_TRIVENETO:
		case MAN_BARI:
		case MAN_BOLOGNA:
		case MAN_NAPOLI:
		case MAN_TORINO:
		case MAN_REGGIO_EMILIA:
		case MAN_TOSCANA:
	 	case MAN_PIEMONTE:
		case MAN_VENETO:
		case MAN_GROSSETO:
		case MAN_SICILIA:
		case MAN_ANCONA:
		case MAN_CAGLIARI:
		case FASTWEB_ROUTERS:
			return true;
		default:
			return false;
	}
}

void CUpDownClient::SetClientFWCity()
{
	switch (m_dwUserIP & 0x000000ff) {
		case MAN_ROMA:
			m_FWCity = wxT("RM");
			break;
		case MAN_MILANO:
			m_FWCity = wxT("MI");
			break;
		case MAN_MILANO_H_NORD:
			m_FWCity = wxT("MI H. Nord");
			break;
		case MAN_MILANO_H_SUD:
			m_FWCity = wxT("MI H. Sud");
			break;
		case MAN_GENOVA:
			m_FWCity = wxT("GE");
			break;
		case MAN_TRIVENETO:
			m_FWCity = wxT("Triveneto");
			break;
		case MAN_BARI:
			m_FWCity = wxT("BA");
			break;
		case MAN_BOLOGNA:
			m_FWCity = wxT("BO");
			break;
		case MAN_NAPOLI:
			m_FWCity = wxT("NA");
			break;
		case MAN_TORINO:
			m_FWCity = wxT("TO");
			break;
		case MAN_REGGIO_EMILIA:
			m_FWCity = wxT("RE");
			break;
		case MAN_TOSCANA:
			m_FWCity = wxT("Toscana");
			break;
		case MAN_PIEMONTE:
			m_FWCity = wxT("Piemonte");
			break;
		case MAN_VENETO:
			m_FWCity = wxT("Veneto");
			break;
		case MAN_GROSSETO:
			m_FWCity = wxT("GR");
			break;
		case MAN_SICILIA:
			m_FWCity = wxT("Sicilia");
			break;
		case MAN_ANCONA:
			m_FWCity = wxT("AN");
			break;
		case MAN_CAGLIARI:
			m_FWCity = wxT("CA");
			break;
		case FASTWEB_ROUTERS:
			m_FWCity = wxT("OAM");
			break;
		default:
			m_FWCity = wxT("");
			break;
	}
}



bool AduIsFiber (uint32 ip) {
  bool	is128 = (((ip >> 15) & 1) == (uint32)0);

	return (is128 && AduIsFastWebLANIP(ip));
}

bool AduIsFastWebIP(uint32 ip)
{
	if (AduIsFastWebLANIP(ip)) 
		return true;
	
	// match rapido: (ip & mask) == netid

	// netid 213.140.0.0/19			- netid (hex) 0x00008cd5 / mask 0x00e0ffff
	if ((ip & 0x00e0ffff) == 0x00008cd5 ||
	// netid 213.156.32.0/19		- netid (hex) 0x00209cd5 / mask 0x00e0ffff
			(ip & 0x00e0ffff) == 0x00209cd5 ||
	// netid 62.101.64.0/18			- netid (hex) 0x0040653e / mask 0x00c0ffff
			(ip & 0x00c0ffff) == 0x0040653e ||
	// netid 81.208.0.0/17			-	netid (hex) 0x0000d051 / mask 0x0080ffff
			(ip & 0x0080ffff) == 0x0000d051 ||
	// netid 83.103.0.0/17			- netid (hex) 0x00006753 / mask 0x0080ffff
			(ip & 0x0080ffff) == 0x00006753 ||
	// netid 85.18.0.0/16       - netid (hex) 0x00001255 / mask 0x0000ffff
			(ip & 0x0000ffff) == 0x00001255 ||
	// netid 89.96.0.0/15       - netid (hex) 0x00006059 / mask 0x0000f7ff
			(ip & 0x0000f7ff) == 0x00006059 ||
	// netid 93.32.0.0/11       - netid (hex) 0x0000205d / mask 0x0000e0ff  // Allineamento 3.15b74
			(ip & 0x0000e0ff) == 0x0000205d)
			return true;


	return false;
}
 
bool AduIsFastWebIP(const wxString& ipv4string)
{
	uint32 ipv4addr;
	bool bTmp = StringIPtoUint32(ipv4string, ipv4addr);

	return (bTmp && AduIsFastWebIP(ipv4addr));
}

#include "Logger.h"
#include <common/Format.h>
#include "NetworkFunctions.h"

bool     AduIsValidKaduAddress( uint32 host )
{
	host = wxUINT32_SWAP_ALWAYS( host );
	//AddDebugLogLineM(false, logClientKadUDP, CFormat(wxT("Checking %s for kADU validity")) % Uint32toStringIP(host));

	// TODO: Add Banlist support here

	return AduIsFastWebIP( host );
}

// Metodo dell'oggetto CUpDownClient
// Vedere il file 
// Questo metodo ritorna 
// ADUNANZA_ICON_NONE	Se il client non e' adunanza
// ADUNANZA_ICON_FW		Se il client non e' adunanza ma e' sulla rete FastWeb Italia
// ADUNANZA_ICON_ADU	Se il client e' AdunanzA ed e' sulla rete FastWeb Italia
uint32 CUpDownClient::GetClientAduType() const
{
	// Mr Hyde ADUFLAGS
	if (IsFastweb())
	{
		if (IsAdunanzA())
			return ADUNANZA_ICON_ADU;
		else 
			return ADUNANZA_ICON_FW;
	}
	return ADUNANZA_ICON_NONE;
}

float calcolaStima(float   input_avail,
                   uint32& firstPublish,
                   uint32  publishInterval,
                   uint32  pubkRTK,
                   bool    sameIP,
                   uint32  now) {

	float avail = input_avail;

	int32 kRTK = theApp->rm->kadRepublishTimeK;

	// Using this increment style, we can guess also if clients use different publish rates.
	float inc = (float) pubkRTK / kRTK;
	
	// Only old clients, with republishtimek == 24hrs don't publish their republishtimek.
	if (inc == (float) 0.0) {
  		inc = HR2S(24) / kRTK;	
	}

	if (publishInterval > kRTK) {
		avail        = (float) 0.0;
		firstPublish = now;
	}

	while ( ((now-firstPublish) > kRTK) && 
	        (avail > (float) 2.0) ) {
		avail--;
		firstPublish += ((uint32)(kRTK/avail));
	}

	// Some client seem to send duplicate publish to already contacted clients.
	// In 90% of the times we avoid this here.
	if (!sameIP) {
		avail += inc;
	}

	return avail;
}

float normalizzaStima( float avail, uint32 from, uint32 to ) {
	// Parte necessaria per il debug
	// calcolo il coefficiente di normalizzazione
	int kRTK = theApp->rm->kadRepublishTimeK;

 	float norm_factor = (float) 1.0;

	if (avail > theApp->rm->kadFreshGuess_NoNorm) {
// Mr Hyde Patch BEGIN	
		if (kRTK == 0) {
			AddDebugLogLineM(false, logKadSearch, wxString::Format(wxT("DENOMINATORE kRTK ZERO")));
			return 0.0; 
		}
// Mr Hyde Patch END	
		norm_factor = (to - from)/kRTK;
// Mr Hyde Patch BEGIN	
		if (avail == 0.0) {
			AddDebugLogLineM(false, logKadSearch, wxString::Format(wxT("DENOMINATORE avail ZERO")));
			return 0.0; 
		}
		if ( norm_factor > 1-1/avail ) {
			norm_factor = (float) 1.0;
		}
// Mr Hyde Patch END	

		norm_factor = ( norm_factor < theApp->rm->kadFreshGuess_Tol ? theApp->rm->kadFreshGuess_Tol : norm_factor );

		// We have a good number of publishes, but not high.
		// Low normalization is still suggested.
		if ( avail < theApp->rm->kadFreshGuess_LowNorm && norm_factor > avail / theApp->rm->kadFreshGuess_LowNorm ) {
			norm_factor /= powf( (avail/theApp->rm->kadFreshGuess_LowNorm), 0.5f );
		}
	}

	if ( avail > 2.0f ) {
		avail /= powf( norm_factor, theApp->rm->kadFreshGuess_Weight );
	}

  return avail;
}

#include "Statistics.h"


// Decido come selezionare un client in base alla
// banda realmente data in upload
uint32 AduGetTypeBand()
{
	uint64 sessionSentBytes    = theApp->m_statistics->GetSessionSentBytes();
	uint64 sessionRecvBytes    = theApp->m_statistics->GetSessionReceivedBytes();

	uint64 aduSessionSentBytes = theApp->m_statistics->GetAduSessionSentBytes();
	uint64 aduSessionRecvBytes = theApp->m_statistics->GetAduSessionReceivedBytes();

	uint64 sentToExternal      = sessionSentBytes - aduSessionSentBytes;
	uint64 recvFromExternal    = sessionRecvBytes - aduSessionRecvBytes;

	if ( sentToExternal < recvFromExternal )
		return ADUNANZA_EXTERN;
	else 
		return ADUNANZA_FASTWEB;
}


#ifndef CLIENT_GUI
int AduQ(void) {
	return theApp->uploadqueue->GetAdunanzAUserCount();
}

bool AduDebt(void) {
	uint64 sentToExternal   = theApp->m_statistics->GetSessionSentBytes() - theApp->m_statistics->GetAduSessionSentBytes();
	uint64 recvFromExternal = theApp->m_statistics->GetSessionReceivedBytes() - theApp->m_statistics->GetAduSessionReceivedBytes();

	if ( sentToExternal < recvFromExternal )
		return true;
	else 
		return false;
}

// Mr Hyde: per ricavare l'upload rate corrente
// (codice copiato da UploadBandwidthThrottler.cpp)

uint32 getAllowedUploadDataRate()
{
	uint32 allowedDataRate = 0;

	if (thePrefs::GetMaxUpload() == UNLIMITED) {
		// Try to increase the upload rate
		if (theApp->uploadqueue) {
			allowedDataRate = (uint32)theStats::GetUploadRate() + 5 * 1024;
		} else {
			// App not created yet or already destroyed.
			allowedDataRate = (uint32)(-1);
		}
	} else {
		allowedDataRate = thePrefs::GetMaxUpload() * 1024;
	}

	return allowedDataRate;
}


int OLDSetSlots(void) {
	float maxUp           = (float) thePrefs::GetMaxUpload();
	float kBpsUpPerClient = (float) thePrefs::GetSlotAllocation();
	float kBpsUp          = ((float) theStats::GetUploadRate()) / 1024.0f;
	int   slots;


	if (thePrefs::GetMaxUpload() == UNLIMITED)
		slots = (int)( kBpsUp / kBpsUpPerClient + 2 );
	else
		slots = (int)floor( maxUp / kBpsUpPerClient + 0.5f );

	return std::max(MIN_UP_CLIENTS_ALLOWED,slots);
}


int SetSlots(void) {
#if 0
	float maxUp           = (float) (thePrefs::GetMaxUpload()); 
	float kBpsUpPerClient = (float) thePrefs::GetSlotAllocation();
	float kBpsUp          = (float) (theStats::GetUploadRate() / 1024.0); // lo shift di 10 bit equivale a dividere per 1024 (piu' rapido)  

	int   slots;
	slots = (int)floor( maxUp / kBpsUpPerClient + 0.5f );

	return std::max(MIN_UP_CLIENTS_ALLOWED,slots);
#endif
	uint16   nMaxSlots;
	float kBpsUpPerClient = (float) thePrefs::GetSlotAllocation();

		if (thePrefs::GetMaxUpload() >= 10) {
			nMaxSlots = (uint16)floor((float)thePrefs::GetMaxUpload() / kBpsUpPerClient + 0.5);
				// floor(x + 0.5) is a way of doing round(x) that works with gcc < 3 ...
			if (nMaxSlots < MIN_UP_CLIENTS_ALLOWED) {
				nMaxSlots=MIN_UP_CLIENTS_ALLOWED;
			}
		} else {
			nMaxSlots = MIN_UP_CLIENTS_ALLOWED;
		}

		return ((int) nMaxSlots);

}

int TotSlots(void) {
	if (AduDebt())
		return (int)(SetSlots() * 1.5f);
	else
		return SetSlots();
}

int ExtSlots(void) {
	if (AduDebt())
		return (int)(TotSlots() * 0.5f);
	else
		return TotSlots();
}

uint32 AduNextClient(int fix) {

	int totslots = TotSlots();
	int totcount = theApp->uploadqueue->GetUploadCount() - fix;

	if (totcount < totslots) {
		if (!AduQ())
			return ADUNANZA_ANY;

		int aducount = theApp->uploadqueue->GetAduUploadCount();
		int extcount = totcount - aducount;

		if (AduDebt()) {
			int extslots = ExtSlots() - fix;
			int aduslots = totslots - extslots;
/*
			if ( (extslots > extcount) && (aduslots > aducount) )
				return ADUNANZA_ANY;
			else if (extslots > extcount)
				return ADUNANZA_EXTERN;
			else if (aduslots > aducount)
				return ADUNANZA_FASTWEB;
			else
				return ADUNANZA_NONE; // non dovrebbe poter succedere
*/
			if (extslots > extcount)
			{
				return ((aduslots > aducount) ? ADUNANZA_ANY : ADUNANZA_EXTERN);
			}
			else
			{
				return ((aduslots > aducount) ? ADUNANZA_FASTWEB : ADUNANZA_NONE);
			}

 

		} else {
			return ADUNANZA_FASTWEB;
		}
	} else
		return ADUNANZA_NONE;
}

uint32 AduGetMaxUploadSlots(void)
{
	return TotSlots();
}

bool AduMaxTrans(void) {
	uint32 now = (uint32)time(NULL);

	if ( AduQ() && 
	     (AduNextClient(1) == ADUNANZA_FASTWEB) &&
	     (now > (theApp->uploadqueue->lastmax + 45)) ) {
		theApp->uploadqueue->lastmax = now;
		return true;
	} else {
		return false;
	}
}
#endif

// Mr Hyde
uint32 CAduUploadSlotsManager::getAllowedUploadDataRate()
{
	uint32 allowedDataRate = 0;

	if (thePrefs::GetMaxUpload() == UNLIMITED) {
		// Try to increase the upload rate
		if (theApp->uploadqueue) {
			allowedDataRate = (uint32)theStats::GetUploadRate() + 5 * 1024;
		} else {
			// App not created yet or already destroyed.
			allowedDataRate = (uint32)(-1);
		}
	} else {
		allowedDataRate = thePrefs::GetMaxUpload() * 1024;
	}

	return allowedDataRate;
}

uint32 CAduUploadSlotsManager::next() const
{
#if 0
	if (m_fastweb)
	{
		if (m_extern)
			return ADUNANZA_ANY;
		else
			return ADUNANZA_FASTWEB;
	}
	else
	{
		if (m_extern)
			return ADUNANZA_EXTERN;
		else
			return ADUNANZA_NONE;
	}
#endif
	if (!m_adunanzaSlots && !m_externSlots) return ADUNANZA_NONE;

	// controllo se ho debiti pendenti
	if (m_adunanzaDebt)
	{
		// adunanza e' in debito nei confronti degli esterni
		// quindi se ho disponibili slot per esterni scelgo subito uno slot esterno
		if (m_externSlots) return ADUNANZA_EXTERN;
	}

	if (m_externDebt)
	{
		// gli esterni sono in debito con gli AdunanzA
		// quindi se ho disponibili slot per AdunanzA scelgo subito uno slot AdunanzA
		if (m_adunanzaSlots) return ADUNANZA_FASTWEB;
	}


#if 0	
	if (m_adunanzaSlots)
	{
		if (m_externSlots)
			return ADUNANZA_ANY;
		else
			return ADUNANZA_FASTWEB;
	}
	else
	{
		if (m_externSlots)
			return ADUNANZA_EXTERN;
		else
			return ADUNANZA_NONE;
	}
#endif
	/*	
	if (m_adunanzaSlots && m_externSlots)
	{
		if (m_adunanzaSlots == m_externSlots) return ADUNANZA_ANY;
		return ((m_adunanzaSlots > m_externSlots) ? ADUNANZA_EXTERN : ADUNANZA_FASTWEB);
	}
	*/
	if (m_adunanzaSlots && m_externSlots) return ADUNANZA_ANY;


	if (m_adunanzaSlots) return ADUNANZA_FASTWEB;
	if (m_externSlots)   return ADUNANZA_EXTERN;

	return ADUNANZA_NONE; // giusto per evitare warning
}
#if 0
uint32 CAduUploadSlotsManager::nextAndConsume() 
{
	uint32 theNext = next();

	switch(theNext)
	{
		case ADUNANZA_FASTWEB:
			if (m_fastweb) m_fastweb--;
			break;
		case ADUNANZA_EXTERN:
			if (m_extern) m_extern--;
			break;
		default:
			break;
	}
	return theNext;
}
#endif
void CAduUploadSlotsManager::consume(CUpDownClient* pClient)
{
	return;

	if (!pClient) return;
	if (pClient->IsAdunanzA())
	{
		if (m_adunanzaSlots)
		{
			// ora controllo se ero in debito verso AdunanzA, se si' decremento il debito
			// di uno slot e lascio perdere gli slot fastweb
			if (m_externDebt) m_externDebt--;
			else m_adunanzaSlots--;
		}
		else
		{
			// in questo caso NON avevo slot disponibili per i client AdunanzA ma ho scelto comunque
			// di assegnare lo slot ad un client AdunanzA.
			// Questo significa che i client AdunanzA sono in debito nei confronti degli esterni
			m_adunanzaDebt++;
			// scalo il prestito dagli slot extern
			if (m_externSlots) m_externSlots--;
		}
	}
	else
	{
		if (m_externSlots)
		{
			// ora controllo se ero in debito verso i client esterni, se si' decremento il debito
			// di uno slot
			if (m_adunanzaDebt) m_adunanzaDebt--;
			else m_externSlots--;
		}
		else
		{
			// in questo caso NON avevo slot disponibili per i client esterni ma ho scelto comunque
			// di assegnare lo slot ad un client esterno.
			// Questo significa che i client esterni sono in debito nei confronti degli AdunanzA
			m_externDebt++;
			// scalo il prestito dagli slot adunanza
			if (m_adunanzaSlots) m_adunanzaSlots--;
		}
	}
#if 0
	std::cout << "(consume) EXTERN: "
		<< m_externSlots
		<< " ADUNANZA: "
		<< m_adunanzaSlots
		<< " EXTERNDEBTS: "
		<< m_externDebt
		<< " ADUNANZADEBTS: "
		<< m_adunanzaDebt
		<< std::endl;
#endif	
}

void CAduUploadSlotsManager::update(CClientPtrList& uploadingList)
{
	// OK, al momento quanti sono gli slot attivi in totale?
	// Tanti quanti i client in upload
	uint32 currentUsedSlots = uploadingList.size();

	// e di questi quanti sono gli slot attivi AdunanzA?
	uint32 currentAdunanzASlots = 0;
	for (CClientPtrList::iterator it = uploadingList.begin();
			it != uploadingList.end();
			++it)
	{
		if ((*it)->IsAdunanzA()) currentAdunanzASlots++;
	}

	uint32 currentExternSlots = currentUsedSlots - currentAdunanzASlots;

	// if (m_extern || m_fastweb) return; // aggiorno solo se ho esaurito gli slot!

	// calcolo l'attuale upload rate massimo
	uint32 maxUpDataRate = (getAllowedUploadDataRate() >> 10);

	// calcolo il numero degli slot attualmente a disposizione
	uint32 maxUpSlots = maxUpDataRate / thePrefs::GetSlotAllocation();
	// std::cout << "Slots = " << maxUpSlots << std::endl;

	// sia ad AdunanzA che a Esterni al max spetta la meta' degli slot
	// a disposizione.
	// Uso uno shift di 1 bit (equivale a dividere per 2)
	uint32 maxCategorySlotsLimit = (maxUpSlots >> 1);


	// ora calcolo, per ciascuna categoria, quanti sono gli slot ancora liberi.
	// Per farlo sottraggo gli slot occupati agli slot possibili (maxCategorySlotLimit)
	//
	if (maxCategorySlotsLimit > currentExternSlots)
	{
		m_externSlots = maxCategorySlotsLimit - currentExternSlots;
		m_externDebt = 0;
	}
	else
	{
		m_externSlots = 0;
		m_externDebt = currentExternSlots - maxCategorySlotsLimit;
	}


	if (maxCategorySlotsLimit > currentAdunanzASlots)
	{
		m_adunanzaSlots = maxCategorySlotsLimit - currentAdunanzASlots;
		m_adunanzaDebt = 0;
	}
	else
	{
		m_adunanzaSlots = 0;
		m_adunanzaDebt = currentAdunanzASlots - maxCategorySlotsLimit;
	}

	// se adunanza e' in debito nei confronti degli extern scarico il debito
	// dagli extern (perche' adunanza STA USANDO slot che sarebbero degli extern)
	if (m_externSlots > m_adunanzaDebt) m_externSlots-=m_adunanzaDebt;

	if (m_adunanzaSlots > m_externDebt) m_adunanzaSlots-=m_externDebt;

#if 0
	uint32 oldSlots = (m_externSlots + m_adunanzaSlots);
	if (oldSlots == maxUpSlots) return;
	// qualcosa e' cambiato rispetto al giro precedente

	if (oldSlots < maxUpSlots)
	{
		// devo aggiungere.
		std::cout << "ADDING " << std::endl;
		for (uint32 i = oldSlots; i < maxUpSlots; i++)
		{
			if (m_adunanzaSlots > m_externSlots) m_externSlots++;
			else m_adunanzaSlots++;
		}
	}
	else
	{
		// devo togliere
		std::cout << "DELETING " << std::endl;
		for (uint32 i = oldSlots; i < maxUpSlots; i--)
		{
			if (m_adunanzaSlots > m_externSlots)
			{
				if (m_adunanzaSlots) m_adunanzaSlots--;
			}
			else
			{
				if (m_externSlots) m_externSlots--;
			}
		}
	}
	std::cout << "(update) EXTERN: "
		<< m_externSlots
		<< " ADUNANZA: "
		<< m_adunanzaSlots
		<< " EXTERNDEBT: "
		<< m_externDebt
		<< " ADUNANZADEBT: "
		<< m_adunanzaDebt
		<< std::endl;
#endif
}

