<?php
/* vim:set tabstop=8 softtabstop=8 shiftwidth=8 noexpandtab: */
/**
 * Show Preference Admin
 *
 *
 * LICENSE: GNU General Public License, version 2 (GPLv2)
 * Copyright (c) 2001 - 2011 Ampache.org All Rights Reserved
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License v2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * @package	Ampache
 * @copyright	2001 - 2011 Ampache.org
 * @license	http://opensource.org/licenses/gpl-2.0 GPLv2
 * @link	http://www.ampache.org/
 */

?>
<?php show_box_top(T_('Preference Administration')); ?>
<form method="post" action="<?php echo conf('web_path'); ?>/admin/preferences.php" enctype="multipart/form-data">
<table class="tabledata" cellpadding="0" cellspacing="0">
<colgroup>
  <col id="col_preference" />
  <col id="col_level" />
</colgroup>
<tr class="th-top">
	<th class="cel_preference"><?php echo T_('Preference'); ?></th>
	<th class="cel_level"><?php echo T_('Level'); ?></th>
</tr>
<?php foreach ($preferences as $preference) {
	unset($is_25,$is_5,$is_100);
?>
<tr class="<?php echo flip_class(); ?>">
	<td class="cel_preference"><?php echo scrub_out(T_($preference['description'])); ?></td>
	<td class="cel_level">
		<?php $level_name = "is_" . $preference['level']; ${$level_name} = 'selected="selected"'; ?>
		<select name="prefs[<?php echo scrub_out($preference['name']); ?>]">
			<option value="5" <?php echo $is_5; ?>><?php echo T_('Guest'); ?></option>
			<option value="25" <?php echo $is_25; ?>><?php echo T_('User'); ?></option>
			<option value="100" <?php echo $is_100; ?>><?php echo T_('Admin'); ?></option>
		</select>
	</td>
</tr>
<?php } ?>
<tr class="th-bottom">
	<th class="cel_preference"><?php echo T_('Preference'); ?></th>
	<th class="cel_level"><?php echo T_('Level'); ?></th>
</tr>
</table>
<div class="formValidation">
		<input type="hidden" name="action" value="set_preferences" />
		<input type="submit" value="<?php echo T_('Update'); ?>" />
</div>
</form>
<?php show_box_bottom(); ?>
