/* amitk_xif_sel.h - this is gtkfilesel, but slightly modified
   so that it lists .xif files in the file list, and compiles
   cleanly under AMIDE
*/

/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * Modified by the GTK+ Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/. 
 */

#ifndef __AMITK_XIF_SEL_H__
#define __AMITK_XIF_SEL_H__


#include <gtk/gtk.h>


G_BEGIN_DECLS

#define AMITK_TYPE_XIF_SELECTION            (amitk_xif_selection_get_type ())
#define AMITK_XIF_SELECTION(obj)            (GTK_CHECK_CAST ((obj), AMITK_TYPE_XIF_SELECTION, AmitkXifSelection))
#define AMITK_XIF_SELECTION_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), AMITK_TYPE_XIF_SELECTION, AmitkXifSelectionClass))
#define AMITK_IS_XIF_SELECTION(obj)         (GTK_CHECK_TYPE ((obj), AMITK_TYPE_XIF_SELECTION))
#define AMITK_IS_XIF_SELECTION_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), AMITK_TYPE_XIF_SELECTION))
#define AMITK_XIF_SELECTION_GET_CLASS(obj)  (GTK_CHECK_GET_CLASS ((obj), AMITK_TYPE_XIF_SELECTION, AmitkXifSelectionClass))


typedef struct _AmitkXifSelection       AmitkXifSelection;
typedef struct _AmitkXifSelectionClass  AmitkXifSelectionClass;

struct _AmitkXifSelection
{
  /*< private >*/
  GtkDialog parent_instance;

  /*< public >*/
  GtkWidget *dir_list;
  GtkWidget *file_list;
  GtkWidget *selection_entry;
  GtkWidget *selection_text;
  GtkWidget *main_vbox;
  GtkWidget *ok_button;
  GtkWidget *cancel_button;
  GtkWidget *help_button;
  GtkWidget *history_pulldown;
  GtkWidget *history_menu;
  GList     *history_list;
  GtkWidget *fileop_dialog;
  GtkWidget *fileop_entry;
  gchar     *fileop_file;
  gpointer   cmpl_state;
  
  GtkWidget *fileop_c_dir;
  GtkWidget *fileop_del_file;
  GtkWidget *fileop_ren_file;
  
  GtkWidget *button_area;
  GtkWidget *action_area;

  GPtrArray *selected_names;
  gchar     *last_selected;
};

struct _AmitkXifSelectionClass
{
  GtkDialogClass parent_class;

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};


GtkType    amitk_xif_selection_get_type            (void) G_GNUC_CONST;
GtkWidget* amitk_xif_selection_new                 (const gchar      *title);
void       amitk_xif_selection_set_filename        (AmitkXifSelection *filesel,
						   const gchar      *filename);
/* This function returns the selected filename in the C runtime's
 * multibyte string encoding, which may or may not be the same as that
 * used by GDK (UTF-8). To convert to UTF-8, call g_filename_to_utf8().
 * The returned string points to a statically allocated buffer and
 * should be copied away.
 */
G_CONST_RETURN gchar* amitk_xif_selection_get_filename        (AmitkXifSelection *filesel);

void	   amitk_xif_selection_complete		  (AmitkXifSelection *filesel,
						   const gchar	    *pattern);
void       amitk_xif_selection_show_fileop_buttons (AmitkXifSelection *filesel);
void       amitk_xif_selection_hide_fileop_buttons (AmitkXifSelection *filesel);

gchar**    amitk_xif_selection_get_selections      (AmitkXifSelection *filesel);

void       amitk_xif_selection_set_select_multiple (AmitkXifSelection *filesel,
						   gboolean          select_multiple);
gboolean   amitk_xif_selection_get_select_multiple (AmitkXifSelection *filesel);

G_END_DECLS

#endif /* __AMITK_XIF_SEL_H__ */
