/*
 *
 *  (c) COPYRIGHT INRIA, 1996-2005
 *  Please first read the full copyright statement in file COPYRIGHT.
 *
 */
 
/* 
 * locate what is designated in Concrete Image in unstructured mode.
 *
 * Author: I. Vatton (INRIA)
 *
 */
#include "thot_gui.h"
#include "ustring.h"
#include "libmsg.h"
#include "thot_sys.h"

#include "constmedia.h"
#include "typemedia.h"
#include "message.h"
#include "appdialogue.h"

#define THOT_EXPORT extern
#include "boxes_tv.h"
#include "frame_tv.h"
#include "edit_tv.h"
#include "platform_tv.h"
#include "appdialogue_tv.h"

#include "absboxes_f.h"
#include "appli_f.h"
#include "boxmoves_f.h"
#include "boxlocate_f.h"
#include "boxpositions_f.h"
#include "boxselection_f.h"
#include "buildboxes_f.h"
#include "buildlines_f.h"
#include "callback_f.h"
#include "changepresent_f.h"
#include "exceptions_f.h"
#include "font_f.h"
#include "geom_f.h"
#include "structcreation_f.h"
#include "views_f.h"


#define MAX_DISTANCE THOT_MAXINT

/*----------------------------------------------------------------------
  GetDistance returns 0 if value is between -delta and +delta.
  In other cases returns the absolute value of value - delta
  ----------------------------------------------------------------------*/
int GetDistance (int value, int delta)
{
  if (value > delta)
    return (value - delta);
  else if (value < -delta)
    return (-value - delta);
  else
    return (0);
}

/*----------------------------------------------------------------------
  GetBoxDistance computes the distance of a point xRef, yRef to a box
  We apply a ratio to vertical distances to give a preference to the
  horizontal proximity.
  ----------------------------------------------------------------------*/
int GetBoxDistance (PtrBox pBox, PtrFlow pFlow, int xRef, int yRef,
                    int ratio, int frame)
{
  PtrAbstractBox      pCell;
  PtrDocument         pDoc;
  int                 value, x, y, width, height;
  int                 xcell, ycell, wcell, hcell, view;

  if (pBox == NULL || pBox->BxAbstractBox == NULL ||
      FrameTable[frame].FrDoc == 0)
    return MAX_DISTANCE;
  /* check limits given by an enclosing cell */
  pDoc = LoadedDocument[FrameTable[frame].FrDoc - 1];
  view = pDoc->DocView[pBox->BxAbstractBox->AbDocView - 1].DvPSchemaView;
  if (view == 1)
    pCell = GetParentCell (pBox);
  else
    pCell = NULL;

  if (pCell && pCell->AbPrevious && pCell->AbPrevious->AbPresentationBox)
    /* use the pesentation box limits */
    pCell = pCell->AbPrevious;
  xcell = ycell = 0;
  wcell = hcell = MAX_DISTANCE;
#ifdef _GL
  x = pBox->BxClipX;
  y = pBox->BxClipY;
  width = pBox->BxClipW;
  height = pBox->BxClipH;
  if (pCell && pCell->AbBox)
    {
      /* get cell limits */
      xcell = pCell->AbBox->BxClipX;
      ycell = pCell->AbBox->BxClipY;
      wcell = pCell->AbBox->BxClipW;
      hcell = pCell->AbBox->BxClipH;
    }
#else /*_GL */
  x = pBox->BxXOrg;
  y = pBox->BxYOrg;
  width = pBox->BxWidth;
  height = pBox->BxHeight;
  if (pCell && pCell->AbBox)
    {
      /* get cell limits */
      xcell = pCell->AbBox->BxXOrg;
      ycell = pCell->AbBox->BxYOrg;
      wcell = pCell->AbBox->BxWidth;
      hcell = pCell->AbBox->BxHeight;
    }
#endif /*_GL */
  /* take into account the positioning */
  if (pFlow)
    {
      x += pFlow->FlXStart;
      y += pFlow->FlYStart;
    }
  if (pCell && pCell->AbBox)
    {
      pFlow = GetRelativeFlow (pCell->AbBox, frame);
      if (pFlow)
        {
          xcell += pFlow->FlXStart;
          ycell += pFlow->FlYStart;
        }
    }

  /* get the middle of the current box */
  width /= 2;
  x += width;
  height /= 2;
  y += height;
  if (xRef < xcell || xRef > xcell + wcell ||
      yRef < ycell || yRef > ycell + hcell)
    //return MAX_DISTANCE;
    return value = GetDistance (xRef - x, width) + ratio * GetDistance (yRef - y, height);
  else if (pCell)
    value = GetDistance (xRef - x, width) + 10 * GetDistance (yRef - y, height);
  else
    value = GetDistance (xRef - x, width) + ratio * GetDistance (yRef - y, height);
  return (value);
}

/*----------------------------------------------------------------------
  GetParentWithException returns the abstract box which has the exceptNum
  exception or NULL..
  ----------------------------------------------------------------------*/
PtrAbstractBox GetParentWithException (int exceptNum, PtrAbstractBox pAb)
{
  while (pAb && pAb->AbElement)
    {
      if (TypeHasException (exceptNum,
                            pAb->AbElement->ElTypeNumber,
                            pAb->AbElement->ElStructSchema))
        return pAb;
      else
        pAb = pAb->AbEnclosing;
    }
  return NULL;
}

/*----------------------------------------------------------------------
  GetClickedBox look for the abstract box that overlaps the point x,y
  or the nearest abstract box.
  The function checks all boxes in the tree and returns the best choice.
  Between a box and its child the function choses the child.
  The parameter ration fixes penalities of the vertical proximity.
  ----------------------------------------------------------------------*/
void GetClickedBox (PtrBox *result, PtrFlow *pFlow, PtrAbstractBox pRootAb,
                    int frame, int x, int y, int ratio, int *pointselect)
{
  PtrAbstractBox      pAb, active, sel_active;
  PtrBox              pSelBox, pBox;
  PtrBox              graphicBox;
  ViewFrame          *pFrame;
  int                 dist;
  int                 pointIndex;
  int                 d, bx, by, bw;

  pBox = NULL;
  pSelBox = NULL;
  *pFlow = NULL;
  sel_active = NULL;
  /* dist gives the previous distance of the selected box
     MAX_DISTANCE when no box is selected */
  dist = MAX_DISTANCE;
  pFrame = &ViewFrameTable[frame - 1];

  if (pFrame->FrAbstractBox != NULL)
    pBox = pFrame->FrAbstractBox->AbBox;
  
  if (pBox != NULL)
    {
      pBox = pBox->BxNext;
      while (pBox)
        {
          pAb = pBox->BxAbstractBox;
#ifdef _GL
          if (pBox->BxBoundinBoxComputed ||
              pBox->BxType == BoBlock || pBox->BxNChars == 0)
            {
              bx = pBox->BxClipX;
              by = pBox->BxClipY;
              bw = pBox->BxClipW;
#else  /* _GL */
              bx = pBox->BxXOrg;
              by = pBox->BxYOrg;
              bw = pBox->BxWidth;
#endif  /* _GL */
              *pFlow = GetRelativeFlow (pBox, frame);
              if (*pFlow)
                {
                  /* apply the box shift */
                  bx += (*pFlow)->FlXStart;
                  by += (*pFlow)->FlYStart;
                }
              if (pAb->AbVisibility >= pFrame->FrVisibility)
                {
                  pointIndex = 0;
                  graphicBox = NULL;
                  if ((pAb->AbPresentationBox && !pAb->AbCanBeModified) ||
                      pAb->AbLeafType == LtGraphics ||
                      pAb->AbLeafType == LtPolyLine ||
                      pAb->AbLeafType == LtPath ||
                      // skip column heads
                      (pAb->AbEnclosing && pAb->AbEnclosing->AbBox &&
                       pAb->AbEnclosing->AbBox->BxType == BoColumn))
                    {
#ifdef _GL  
                      if (bx <= x && bx + pBox->BxClipW >= x &&
                          by <= y && by + pBox->BxClipH >= y)
#endif  /* _GL */
                        graphicBox = GetEnclosingClickedBox (pAb, x, x, y, frame,
                                                             &pointIndex, pFlow);
                      if (graphicBox == NULL)
                        /* eliminate this box */
                        d = dist + 1;
                      else
                        d = 0;
                    }
                  else if (pAb->AbLeafType == LtSymbol && pAb->AbShape == 'r')
                    /* glitch for the root symbol */
                    d = GetShapeDistance (x, y, pBox, 1, frame);
                  else if (pAb->AbLeafType == LtText ||
                           pAb->AbLeafType == LtSymbol ||
                           pAb->AbLeafType == LtPicture ||
                           /* or an empty compound box */
                           (pAb->AbLeafType == LtCompound && pAb->AbVolume == 0))
                    {
                      if (pAb->AbLeafType == LtPicture)
                        {
                          /* check if the right side of the picture is selected */
                          d = bx + (bw / 2);
                          if (x > d)
                            pointIndex = 1;
                        }
                      d = GetBoxDistance (pBox, *pFlow, x, y, ratio, frame);
                      if (d > dist && dist == MAX_DISTANCE)
                        /* it's the first box selected */
                        dist = d;
                    }
                  else
                    d = dist + 1;
		  
                  /* select the nearest box */
                  active = GetParentWithException (ExcClickableSurface, pAb);
                  if (active &&
                      (active->AbBox == NULL ||
                       GetBoxDistance (active->AbBox, *pFlow, x, y, ratio, frame) != 0))
                    active = NULL;
                  if (active && sel_active == NULL)
                    dist = d + 1;
                  else if (active == NULL && sel_active)
                    d = dist + 1;
                  if (d < dist ||
                      (d == dist &&
                       (pSelBox == NULL ||
                        pSelBox->BxAbstractBox->AbDepth >= pBox->BxAbstractBox->AbDepth)))
                    {
                      dist = d;
                      pSelBox = pBox;
                      sel_active = active;
                      /* the selected reference point */
                      *pointselect = pointIndex;
                    }
                }
#ifdef _GL
            }
#endif /* _GL */
          pBox = pBox->BxNext;
        }
      /* return the root box if there is no box selected */
      if (pSelBox == NULL)
        pSelBox = pBox = pFrame->FrAbstractBox->AbBox;
    }
  *result = pSelBox;
}
