#!#############################################################################
#! File:    sc.t
#! Purpose: tmake template file from which makefile.sc is generated by running
#!          tmake -t sc wxwin.pro -o makefile.sc
#! Author:  Vadim Zeitlin
#! Created: 14.07.99
#! Version: $Id: sc.t,v 1.1.1.1 2005/07/06 09:30:07 gully Exp $
#!#############################################################################

#${
    #! include the code which parses filelist.txt file and initializes
    #! %wxCommon, %wxGeneric and %wxMSW hashes.
    IncludeTemplate("filelist.t");

    #! now transform these hashes into $project tags
    foreach $file (sort keys %wxGeneric) {
        my $tag = "";
        if ( $wxGeneric{$file} =~ /\b(PS|G|16|U)\b/ ) {
            $tag = "WXNONESSENTIALOBJS";
        }
        else {
            $tag = "WXGENERICOBJS";
        }

        $file =~ s/cp?p?$/obj/;
        $project{$tag} .= '$(GENDIR)\\' . $file . " "
    }

    foreach $file (sort keys %wxHTML) {
        next if $wxHTML{$file} =~ /\b16\b/;

        $file =~ s/cp?p?$/obj/;
        $project{"WXHTMLOBJS"} .= '$(HTMLDIR)\\' . $file . " "
    }

    foreach $file (sort keys %wxCommon) {
        next if $wxCommon{$file} =~ /\b(16|U)\b/;

        $file =~ s/cp?p?$/obj/;
        $project{"WXCOMMONOBJS"} .= '$(COMMDIR)\\' . $file . " "
    }

    foreach $file (sort keys %wxMSW) {
        #! these files don't compile with SC++ 6
        #! next if $file =~ /^(joystick|pnghand)\./;

        next if $wxMSW{$file} =~ /\b16\b/;

        my $isOleObj = $wxMSW{$file} =~ /\bO\b/;
        $file =~ s/cp?p?$/obj/;
        $project{"WXMSWOBJS"} .= '$(MSWDIR)\\';
        $project{"WXMSWOBJS"} .= 'ole\\' if $isOleObj;
        $project{"WXMSWOBJS"} .= $file . " "
    }
#$}

# This file was automatically generated by tmake 
# DO NOT CHANGE THIS FILE, YOUR CHANGES WILL BE LOST! CHANGE SC.T!

# Digital mars makefile 
# was Symantec C++ makefile for the msw objects
#
# called from src\makefile.sc

# configuration section (see src\makefile.sc) ###########################

WXDIR = ..\..

include ..\makesc.env

DEBUG=0

LIBTARGET = $(LIBDIR)\wx$(SC_SUFFIX).lib

OPTIONS=

# end of configuration section ##########################################

GENDIR=$(WXDIR)\src\generic
COMMDIR=$(WXDIR)\src\common
HTMLDIR=$(WXDIR)\src\html
OLEDIR=ole
MSWDIR=$(WXDIR)\src\msw

GENERICOBJS= #$ ExpandList("WXGENERICOBJS");

COMMONOBJS = #$ ExpandList("WXCOMMONOBJS");

HTMLOBJS = #$ ExpandList ("WXHTMLOBJS");

MSWOBJS = #$ ExpandList("WXMSWOBJS");

# Add $(NONESSENTIALOBJS) if wanting generic dialogs, PostScript etc.
OBJECTS = $(COMMONOBJS) $(GENERICOBJS) $(MSWOBJS) $(HTMLOBJS) 

all: MAKEARCHDIR MAKELIBS PCH $(LIBTARGET) zlib png jpeg tiff regex

MAKEARCHDIR:
    @if not exist $(MSWINCDIR)\setup.h copy $(MSWINCDIR)\setup0.h $(MSWINCDIR)\setup.h
    @if not exist $(ARCHINCDIR)\wx\setup.h mkdir $(ARCHINCDIR)
    @if not exist $(ARCHINCDIR)\wx\setup.h mkdir $(ARCHINCDIR)\wx
    @if not exist $(ARCHINCDIR)\wx\setup.h copy $(MSWINCDIR)\setup.h $(ARCHINCDIR)\wx\setup.h
    @if not exist $(WXOUTDIR)\nul mkdir $(WXOUTDIR)

#build our own copies of missing libraries
MAKELIBS:
      implib  /s $(LIBDIR)\$(SHELLLIB) $(LIBDIR)\$(SC_SUFFIX)\$(SHELLLIB).def
      implib  /s $(LIBDIR)\$(WINSOCKLIB) $(LIBDIR)\$(SC_SUFFIX)\$(WINSOCKLIB).def

$(LIBTARGET): $(OBJECTS)
	-del $(LIBTARGET)
	*lib /PAGESIZE:512 $(LIBTARGET) y $(OBJECTS), nul;

clean: clean_msw clean_zlib clean_png clean_jpeg clean_tiff clean_regex clean_pch

clean_msw:
	-del $(COMMDIR)\*.obj
	-del $(MSWDIR)\*.obj
	-del $(GENDIR)\*.obj
        -del $(HTMLDIR)\*.obj
	-del *.obj
        -del *.sym
        -del ole\*.obj
        -del $(LIBTARGET)

PCH: $(INCDIR)\wx\wxprec.h
        dmc $(CPPFLAGS) $(CFLAGS) $(INCLUDE) -HF$(WXOUTDIR)\wxprec.SYM -o$(WXOUTDIR)\wxprec.PCO $(INCDIR)\wx\wxprec.h

clean_pch:
        del $(WXOUTDIR)\*.sym
        del $(WXOUTDIR)\*.PCO


png:   
        make -f $(WXDIR)\src\png\makefile.sc FINAL=$(FINAL)

clean_png:
        make -f $(WXDIR)\src\png\makefile.sc clean

zlib:   
        make -f $(WXDIR)\src\zlib\makefile.sc FINAL=$(FINAL) 

clean_zlib:
        make -f $(WXDIR)\src\zlib\makefile.sc clean

jpeg:   
        make -f $(WXDIR)\src\jpeg\makefile.sc FINAL=$(FINAL)

clean_jpeg:
        make -f $(WXDIR)\src\jpeg\makefile.sc clean

regex:  
        make -f $(WXDIR)\src\regex\makefile.sc FINAL=$(FINAL) 

clean_regex:
        make -f $(WXDIR)\src\regex\makefile.sc clean

tiff:  
        make -f $(WXDIR)\src\tiff\makefile.sc FINAL=$(FINAL) 

clean_tiff:
        make -f $(WXDIR)\src\tiff\makefile.sc clean

MFTYPE=sc
self : $(WXWIN)\distrib\msw\tmake\filelist.txt $(WXWIN)\distrib\msw\tmake\$(MFTYPE).t
	perl -x$(WXWIN)\distrib\msw\tmake -S tmake -t$(MFTYPE) wxwin.pro -o $(WXWIN)\distrib\msw\tmake\makefile.sc
	copy $(WXWIN)\distrib\msw\tmake\makefile.$(MFTYPE) $(WXWIN)\src\msw
