/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.19
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

/***********************************************************************
 * common.swg
 *
 *     This file contains generic SWIG runtime support for pointer
 *     type checking as well as a few commonly used macros to control
 *     external linkage.
 *
 * Author : David Beazley (beazley@cs.uchicago.edu)
 *
 * Copyright (c) 1999-2000, The University of Chicago
 * 
 * This file may be freely redistributed without license or fee provided
 * this copyright message remains intact.
 ************************************************************************/

#include <string.h>

#if defined(_WIN32) || defined(__WIN32__)
#       if defined(_MSC_VER)
#               if defined(STATIC_LINKED)
#                       define SWIGEXPORT(a) a
#                       define SWIGIMPORT(a) extern a
#               else
#                       define SWIGEXPORT(a) __declspec(dllexport) a
#                       define SWIGIMPORT(a) extern a
#               endif
#       else
#               if defined(__BORLANDC__)
#                       define SWIGEXPORT(a) a _export
#                       define SWIGIMPORT(a) a _export
#               else
#                       define SWIGEXPORT(a) a
#                       define SWIGIMPORT(a) a
#               endif
#       endif
#else
#       define SWIGEXPORT(a) a
#       define SWIGIMPORT(a) a
#endif

#ifdef SWIG_GLOBAL
#define SWIGRUNTIME(a) SWIGEXPORT(a)
#else
#define SWIGRUNTIME(a) static a
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef void *(*swig_converter_func)(void *);
typedef struct swig_type_info *(*swig_dycast_func)(void **);

typedef struct swig_type_info {
  const char             *name;                 
  swig_converter_func     converter;
  const char             *str;
  void                   *clientdata;	
  swig_dycast_func        dcast;
  struct swig_type_info  *next;
  struct swig_type_info  *prev;
} swig_type_info;

#ifdef SWIG_NOINCLUDE

SWIGIMPORT(swig_type_info *) SWIG_TypeRegister(swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeCheck(char *c, swig_type_info *);
SWIGIMPORT(void *)           SWIG_TypeCast(swig_type_info *, void *);
SWIGIMPORT(swig_type_info *) SWIG_TypeDynamicCast(swig_type_info *, void **);
SWIGIMPORT(const char *)     SWIG_TypeName(const swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeQuery(const char *);
SWIGIMPORT(void)             SWIG_TypeClientData(swig_type_info *, void *);

#else

static swig_type_info *swig_type_list = 0;

/* Register a type mapping with the type-checking */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeRegister(swig_type_info *ti)
{
  swig_type_info *tc, *head, *ret, *next;
  /* Check to see if this type has already been registered */
  tc = swig_type_list;
  while (tc) {
    if (strcmp(tc->name, ti->name) == 0) {
      /* Already exists in the table.  Just add additional types to the list */
      if (tc->clientdata) ti->clientdata = tc->clientdata;	
      head = tc;
      next = tc->next;
      goto l1;
    }
    tc = tc->prev;
  }
  head = ti;
  next = 0;

  /* Place in list */
  ti->prev = swig_type_list;
  swig_type_list = ti;

  /* Build linked lists */
 l1:
  ret = head;
  tc = ti + 1;
  /* Patch up the rest of the links */
  while (tc->name) {
    head->next = tc;
    tc->prev = head;
    head = tc;
    tc++;
  }
  if (next) next->prev = head;  /**/
  head->next = next;
  return ret;
}

/* Check the typename */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeCheck(char *c, swig_type_info *ty)
{
  swig_type_info *s;
  if (!ty) return 0;        /* Void pointer */
  s = ty->next;             /* First element always just a name */
  do {
    if (strcmp(s->name,c) == 0) {
      if (s == ty->next) return s;
      /* Move s to the top of the linked list */
      s->prev->next = s->next;
      if (s->next) {
	s->next->prev = s->prev;
      }
      /* Insert s as second element in the list */
      s->next = ty->next;
      if (ty->next) ty->next->prev = s;
      ty->next = s;
      s->prev = ty;  /**/
      return s;
    }
    s = s->next;
  } while (s && (s != ty->next));
  return 0;
}

/* Cast a pointer up an inheritance hierarchy */
SWIGRUNTIME(void *) 
SWIG_TypeCast(swig_type_info *ty, void *ptr) 
{
  if ((!ty) || (!ty->converter)) return ptr;
  return (*ty->converter)(ptr);
}

/* Dynamic pointer casting. Down an inheritance hierarchy */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeDynamicCast(swig_type_info *ty, void **ptr) 
{
  swig_type_info *lastty = ty;
  if (!ty || !ty->dcast) return ty;
  while (ty && (ty->dcast)) {
     ty = (*ty->dcast)(ptr);
     if (ty) lastty = ty;
  }
  return lastty;
}

/* Return the name associated with this type */
SWIGRUNTIME(const char *)
SWIG_TypeName(const swig_type_info *ty) {
  return ty->name;
}

/* Search for a swig_type_info structure */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeQuery(const char *name) {
  swig_type_info *ty = swig_type_list;
  while (ty) {
    if (ty->str && (strcmp(name,ty->str) == 0)) return ty;
    if (ty->name && (strcmp(name,ty->name) == 0)) return ty;
    ty = ty->prev;
  }
  return 0;
}

/* Set the clientdata field for a type */
SWIGRUNTIME(void)
SWIG_TypeClientData(swig_type_info *ti, void *clientdata) {
  swig_type_info *tc, *equiv;
  if (ti->clientdata == clientdata) return;
  ti->clientdata = clientdata;
  equiv = ti->next;
  while (equiv) {
    if (!equiv->converter) {
      tc = swig_type_list;
      while (tc) {
	if ((strcmp(tc->name, equiv->name) == 0))
	  SWIG_TypeClientData(tc,clientdata);
	tc = tc->prev;
      }
    }
    equiv = equiv->next;
  }
}
#endif

#ifdef __cplusplus
}

#endif

/*
 * $Header: /sources/cvsroot/redland/tcl/Redland_wrap.c,v 1.1.1.1 2005/07/06 09:38:37 gully Exp $
 * 
 * swigtcl8.swg
 */

#include <tcl.h>
#include <stdlib.h>
#include <stdarg.h>
#include <ctype.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Constant table */

#define SWIG_TCL_INT     1
#define SWIG_TCL_FLOAT   2
#define SWIG_TCL_STRING  3
#define SWIG_TCL_POINTER 4
#define SWIG_TCL_BINARY  5

/* Flags for pointer conversion */
#define SWIG_POINTER_EXCEPTION     0x1
#define SWIG_POINTER_DISOWN        0x2

/* Swig fail macro */

#define SWIG_fail   goto fail
   
/* Constant information structure */
typedef struct swig_const_info {
    int type;
    char *name;
    long lvalue;
    double dvalue;
    void   *pvalue;
    swig_type_info **ptype;
} swig_const_info;

typedef int   (*swig_wrapper)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST []);
typedef int   (*swig_wrapper_func)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST []);
typedef char *(*swig_variable_func)(ClientData, Tcl_Interp *, char *, char *, int);
typedef void  (*swig_delete_func)(ClientData);

typedef struct swig_method { 
  const char     *name;
  swig_wrapper   method;
} swig_method;

typedef struct swig_attribute {
  const char     *name;
  swig_wrapper   getmethod;
  swig_wrapper   setmethod;
} swig_attribute;
  
typedef struct swig_class {
  const char         *name;
  swig_type_info   **type;
  swig_wrapper       constructor;
  void              (*destructor)(void *);
  swig_method        *methods;
  swig_attribute     *attributes;
  struct swig_class **bases;
} swig_class;

typedef struct swig_instance {
  Tcl_Obj       *thisptr;
  void          *thisvalue;
  swig_class   *classptr;
  int            destroy;
  Tcl_Command    cmdtok;
} swig_instance;

#ifdef SWIG_NOINCLUDE
SWIGEXPORT(char *)    SWIG_PackData(char *c, void *ptr, int sz);
SWIGEXPORT(char *)    SWIG_UnpackData(char *c, void *ptr, int sz);
SWIGEXPORT(int)       SWIG_ConvertPtrFromString(Tcl_Interp *, char *, void **, swig_type_info *,int flags);
SWIGEXPORT(int)       SWIG_ConvertPtr(Tcl_Interp *, Tcl_Obj *, void **, swig_type_info *, int flags);
SWIGEXPORT(int)       SWIG_ConvertPacked(Tcl_Interp *, Tcl_Obj *, void *, int sz, swig_type_info *, int flags);
SWIGEXPORT(void)      SWIG_MakePtr(char *, void *, swig_type_info *, int flags);
SWIGEXPORT(Tcl_Obj *) SWIG_NewPointerObj(void *, swig_type_info *, int flags);
SWIGEXPORT(Tcl_Obj *) SWIG_NewPackedObj(void *, int sz, swig_type_info *, int flags);
SWIGEXPORT(int)       SWIG_GetArgs(Tcl_Interp *, int, Tcl_Obj *CONST [], const char *, ...);
SWIGEXPORT(char *)    SWIG_PointerTypeFromString(char *c);
SWIGEXPORT(void)      SWIG_Acquire(void *ptr);
SWIGEXPORT(int)       SWIG_Disown(void *ptr);
SWIGEXPORT(int)       SWIG_Thisown(void *ptr);
SWIGEXPORT(void)      SWIG_InstallConstants(Tcl_Interp *interp, struct swig_const_info constants[]);
SWIGEXPORT(Tcl_Obj *) SWIG_GetConstant(const char *key);
SWIGEXPORT(Tcl_Obj *) SWIG_NewInstanceObj(Tcl_Interp *interp, void *, swig_type_info *, int flags);
SWIGEXPORT(int)       SWIG_ObjectConstructor(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST objv[]);
SWIGEXPORT(int)       SWIG_MethodCommand(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST objv[]);
SWIGEXPORT(void)      SWIG_ObjectDelete(ClientData);
#else

/* Object support */
static Tcl_HashTable  swigobjectTable;
static int            swigobjectTableinit = 0;

/* Acquire ownership of a pointer */
SWIGRUNTIME(void)
SWIG_Acquire(void *ptr)
{
  Tcl_HashEntry *entryPtr;
  int newobj;
  if (!swigobjectTableinit) {
    Tcl_InitHashTable(&swigobjectTable, TCL_ONE_WORD_KEYS);
    swigobjectTableinit = 1;
  }
  entryPtr = Tcl_CreateHashEntry(&swigobjectTable, (char *) ptr, &newobj);
}

/* Disown a pointer.  Returns 1 if we owned it to begin with */
SWIGRUNTIME(int)
SWIG_Disown(void *ptr)
{
  Tcl_HashEntry *entryPtr;
  if (!swigobjectTableinit) return 0;
  entryPtr = Tcl_FindHashEntry(&swigobjectTable, (char *) ptr);
  if (entryPtr) {
    Tcl_DeleteHashEntry(entryPtr);
    return 1;
  } 
  return 0;
}

SWIGRUNTIME(int)
SWIG_Thisown(void *ptr) {
  if (!swigobjectTableinit) return 0;
  if (Tcl_FindHashEntry(&swigobjectTable, (char *) ptr)) {
    return 1;
  }
  return 0;
}

/* Pack binary data into a string */
SWIGRUNTIME(char *)
SWIG_PackData(char *c, void *ptr, int sz) {
  static char hex[17] = "0123456789abcdef";
  int i;
  unsigned char *u = (unsigned char *) ptr;
  register unsigned char uu;
  for (i = 0; i < sz; i++,u++) {
    uu = *u;
    *(c++) = hex[(uu & 0xf0) >> 4];
    *(c++) = hex[uu & 0xf];
  }
  return c;
}

/* Unpack binary data from a string */
SWIGRUNTIME(char *)
SWIG_UnpackData(char *c, void *ptr, int sz) {
  register unsigned char uu = 0;
  register int d;
  unsigned char *u = (unsigned char *) ptr;
  int i;
  if ((int)strlen(c) < (2*sz)) return c;
  for (i = 0; i < sz; i++, u++) {
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu = ((d - '0') << 4);
    else if ((d >= 'a') && (d <= 'f'))
      uu = ((d - ('a'-10)) << 4);
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu |= (d - '0');
    else if ((d >= 'a') && (d <= 'f'))
      uu |= (d - ('a'-10));
    *u = uu;
  }
  return c;
}

/* Convert a pointer value */
SWIGRUNTIME(int)
SWIG_ConvertPtrFromString(Tcl_Interp *interp, char *c, void **ptr, swig_type_info *ty, int flags)
{
  swig_type_info *tc;
  /* Pointer values must start with leading underscore */
  while (*c != '_') {
    *ptr = (void *) 0;
    if (strcmp(c,"NULL") == 0) return TCL_OK;
    /* Hmmm. It could be an object name. */
    if (Tcl_VarEval(interp,c," cget -this", (char *) NULL) == TCL_OK) {
      Tcl_Obj *result = Tcl_GetObjResult(interp);
      c = Tcl_GetStringFromObj(result, NULL);
      continue;
    }
    if (flags & SWIG_POINTER_EXCEPTION) 
      Tcl_SetResult(interp, (char *) "Type error. Expected a pointer", TCL_STATIC);
    return TCL_ERROR;
  }
  c++;
  c = SWIG_UnpackData(c,ptr,sizeof(void *));
  if (ty) {
    tc = SWIG_TypeCheck(c,ty);
    if ((!tc) && (flags & SWIG_POINTER_EXCEPTION)) {
      Tcl_SetResult(interp, (char *) "Type error. Expected ", TCL_STATIC);
      Tcl_AppendElement(interp, (char *) ty->name);
      return TCL_ERROR;
    } else if (!tc) {
      return TCL_ERROR;
    }
    if (flags & SWIG_POINTER_DISOWN) {
      SWIG_Disown((void *) *ptr);
    }
    *ptr = SWIG_TypeCast(tc,(void *) *ptr);
  }
  return TCL_OK;
}

/* Convert a pointer value */
SWIGRUNTIME(int)
SWIG_ConvertPtr(Tcl_Interp *interp, Tcl_Obj *oc, void **ptr, swig_type_info *ty, int flags)
{
  return SWIG_ConvertPtrFromString(interp, Tcl_GetStringFromObj(oc,NULL), ptr, ty, flags);
}

/* Convert a pointer value */
SWIGRUNTIME(char *)
SWIG_PointerTypeFromString(char *c) {
  char d;
  /* Pointer values must start with leading underscore. NULL has no type */
  if (*c != '_') {
    return 0;
  }
  c++;
  /* Extract hex value from pointer */
  while ((d = *c)) {
    if (!(((d >= '0') && (d <= '9')) || ((d >= 'a') && (d <= 'f')))) break;
    c++;
  }
  return c;
}

/* Convert a packed value value */
SWIGRUNTIME(int)
SWIG_ConvertPacked(Tcl_Interp *interp, Tcl_Obj *obj, void *ptr, int sz, swig_type_info *ty, int flags) {
  swig_type_info *tc;
  char  *c;
  
  if (!obj) goto type_error;
  c = Tcl_GetStringFromObj(obj,NULL);
  /* Pointer values must start with leading underscore */
  if (*c != '_') goto type_error;
  c++;
  c = SWIG_UnpackData(c,ptr,sz);
  if (ty) {
    tc = SWIG_TypeCheck(c,ty);
    if (!tc) goto type_error;
  }
  return TCL_OK;

type_error:

  if (flags) {
    if (ty) {
      Tcl_SetResult(interp, (char *) "Type error. Expected ", TCL_STATIC);
      Tcl_AppendElement(interp, (char *) ty->name);
      return TCL_ERROR;
    } else {
      Tcl_SetResult(interp, (char *) "Expected packed data.", TCL_STATIC);
      return TCL_ERROR;
    }
  }
  return TCL_ERROR;
}


/* Take a pointer and convert it to a string */
SWIGRUNTIME(void) 
SWIG_MakePtr(char *c, void *ptr, swig_type_info *ty, int flags) {
  if (ptr) {
    *(c++) = '_';
    c = SWIG_PackData(c,&ptr,sizeof(void *));
    strcpy(c,ty->name);
  } else {
    strcpy(c,(char *)"NULL");
  }
  flags = 0;
}

/* Create a new pointer object */
SWIGRUNTIME(Tcl_Obj *)
SWIG_NewPointerObj(void *ptr, swig_type_info *type, int flags) {
  Tcl_Obj *robj;
  char result[512];
  SWIG_MakePtr(result,ptr,type,flags);
  robj = Tcl_NewStringObj(result,-1);
  return robj;
}

SWIGRUNTIME(Tcl_Obj *)
SWIG_NewPackedObj(void *ptr, int sz, swig_type_info *type, int flags) {
  char result[1024];
  char *r = result;
  if ((2*sz + 1 + strlen(type->name)) > 1000) return 0;
  *(r++) = '_';
  r = SWIG_PackData(r,ptr,sz);
  strcpy(r,type->name);
  flags = 0;
  return Tcl_NewStringObj(result,-1);
}

static Tcl_HashTable   swigconstTable;
static int             swigconstTableinit = 0;

/* Install Constants */
SWIGRUNTIME(void)
SWIG_InstallConstants(Tcl_Interp *interp, swig_const_info constants[]) {
  int i;
  Tcl_Obj *obj;
  Tcl_HashEntry *entryPtr;
  int            newobj;

  if (!swigconstTableinit) {
    Tcl_InitHashTable(&swigconstTable, TCL_STRING_KEYS);
    swigconstTableinit = 1;
  }
  for (i = 0; constants[i].type; i++) {
    switch(constants[i].type) {
    case SWIG_TCL_INT:
      obj = Tcl_NewIntObj(constants[i].lvalue);
      break;
    case SWIG_TCL_FLOAT:
      obj = Tcl_NewDoubleObj(constants[i].dvalue);
      break;
    case SWIG_TCL_STRING:
      obj = Tcl_NewStringObj((char *) constants[i].pvalue,-1);
      break;
    case SWIG_TCL_POINTER:
      obj = SWIG_NewPointerObj(constants[i].pvalue, *(constants[i]).ptype,0);
      break;
    case SWIG_TCL_BINARY:
      obj = SWIG_NewPackedObj(constants[i].pvalue, constants[i].lvalue, *(constants[i].ptype),0);
      break;
    default:
      obj = 0;
      break;
    }
    if (obj) {
      Tcl_ObjSetVar2(interp,Tcl_NewStringObj(constants[i].name,-1), NULL, obj, TCL_GLOBAL_ONLY);
      entryPtr = Tcl_CreateHashEntry(&swigconstTable, constants[i].name, &newobj);
      Tcl_SetHashValue(entryPtr, (ClientData) obj);
    }
  }
}

SWIGRUNTIME(Tcl_Obj *)
SWIG_GetConstant(const char *key) {
  Tcl_HashEntry *entryPtr;
  if (!swigconstTableinit) return 0;
  entryPtr = Tcl_FindHashEntry(&swigconstTable, key);
  if (entryPtr) {
    return (Tcl_Obj *) Tcl_GetHashValue(entryPtr);
  }
  printf("Searching %s\n", key);
  return 0;
}

/* Get arguments */
SWIGRUNTIME(int)
SWIG_GetArgs(Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[], const char *fmt, ...)
{
  int        argno = 0, opt = 0, tempi;
  double     tempd;
  const char *c;
  va_list    ap;
  void      *vptr;
  Tcl_Obj   *obj = 0;
  swig_type_info *ty;

  va_start(ap,fmt);
  for (c = fmt; (*c && (*c != ':') && (*c != ';')); c++,argno++) {
    if (*c == '|') {
      opt = 1;
      c++;
    }
    if (argno >= (objc-1)) {
      if (!opt) {
	Tcl_SetResult(interp, (char *) "Wrong # args. ", TCL_STATIC);
	goto argerror;
      } else {
	va_end(ap);
	return TCL_OK;
      }
    }

    vptr = va_arg(ap,void *);
    if (vptr) {
      if (isupper(*c)) {
	obj = SWIG_GetConstant(Tcl_GetStringFromObj(objv[argno+1],0));
	if (!obj) obj = objv[argno+1];
      } else {
	obj = objv[argno+1];
      }
      switch(*c) {
      case 'i': case 'I':
      case 'l': case 'L':
      case 'h': case 'H':
      case 'b': case 'B':
	if (Tcl_GetIntFromObj(interp,obj,&tempi) != TCL_OK) goto argerror;
	if ((*c == 'i') || (*c == 'I')) *((int *)vptr) = tempi;
	else if ((*c == 'l') || (*c == 'L')) *((long *)vptr) = tempi;
	else if ((*c == 'h') || (*c == 'H')) *((short*)vptr) = tempi;
	else if ((*c == 'b') || (*c == 'B')) *((unsigned char *)vptr) = tempi;
	break;
      case 'f': case 'F':
      case 'd': case 'D':
	if (Tcl_GetDoubleFromObj(interp,obj,&tempd) != TCL_OK) goto argerror;
	if ((*c == 'f') || (*c == 'F')) *((float *) vptr) = (float)tempd;
	else if ((*c == 'd') || (*c == 'D')) *((double*) vptr) = tempd;
	break;
      case 's': case 'S':
	if (*(c+1) == '#') {
	  int *vlptr = (int *) va_arg(ap, void *);
	  *((char **) vptr) = Tcl_GetStringFromObj(obj, vlptr);
	  c++;
	} else {
	  *((char **)vptr) = Tcl_GetStringFromObj(obj,NULL);
	}
	break;
      case 'c': case 'C':
	*((char *)vptr) = *(Tcl_GetStringFromObj(obj,NULL));
	break;
      case 'p': case 'P':
	ty = (swig_type_info *) va_arg(ap, void *);
	if (SWIG_ConvertPtr(interp, obj, (void **) vptr, ty, SWIG_POINTER_EXCEPTION) == TCL_ERROR) goto argerror;
	break;
      case 'o': case 'O':
	*((Tcl_Obj **)vptr) = objv[argno+1];
	break;
      default:
	break;
      }
    }
  }
  
  if ((*c != ';') && ((objc-1) > argno)) {
    Tcl_SetResult(interp, (char *) "Wrong # args.", TCL_STATIC);
    goto argerror;
  }
  va_end(ap);
  return TCL_OK;
  
 argerror:
  {
    char temp[32];
    sprintf(temp,"%d", argno+1);
    c = strchr(fmt,':');
    if (!c) c = strchr(fmt,';');
    if (!c) c = (char *)"";
    Tcl_AppendResult(interp,c," argument ", temp, NULL);
    va_end(ap);
    return TCL_ERROR;
  }
}

SWIGRUNTIME(void)
SWIG_ObjectDelete(ClientData clientData) {
  swig_instance *si = (swig_instance *) clientData;
  if ((si) && (si->destroy) && (SWIG_Disown(si->thisvalue))) {
    if (si->classptr->destructor) {
      (si->classptr->destructor)(si->thisvalue);
    }
  }
  Tcl_DecrRefCount(si->thisptr);
  free(si);
}

/* Function to invoke object methods given an instance */
SWIGRUNTIME(int)
SWIG_MethodCommand(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST _objv[])
{
  char *method,   *attrname;
  swig_instance   *inst = (swig_instance *) clientData;
  swig_method     *meth;
  swig_attribute  *attr;
  Tcl_Obj         *oldarg;
  Tcl_Obj         **objv;
  int              rcode;
  swig_class      *cls;
  swig_class      *cls_stack[64];
  int              cls_stack_bi[64];
  int              cls_stack_top = 0;
  int              numconf = 2;
  int              bi;

  objv = (Tcl_Obj **) _objv;
  if (objc < 2) {
    Tcl_SetResult(interp, (char *) "wrong # args.", TCL_STATIC);
    return TCL_ERROR;
  }
  method = Tcl_GetStringFromObj(objv[1],NULL);
  if (strcmp(method,"-acquire") == 0) {
    inst->destroy = 1;
    SWIG_Acquire(inst->thisvalue);
    return TCL_OK;
  } 
  if (strcmp(method,"-disown") == 0) {
    if (inst->destroy) {
      SWIG_Disown(inst->thisvalue);
    }
    inst->destroy = 0;
    return TCL_OK;
  }
  if (strcmp(method,"-delete") == 0) {
    Tcl_DeleteCommandFromToken(interp,inst->cmdtok);
    return TCL_OK;
  }
  cls_stack[cls_stack_top] = inst->classptr;
  cls_stack_bi[cls_stack_top] = -1;
  cls = inst->classptr;
  while (1) {
    bi = cls_stack_bi[cls_stack_top];
    cls = cls_stack[cls_stack_top];
    if (bi != -1) {
      cls = cls->bases[bi];
      if (cls) {
	cls_stack_bi[cls_stack_top]++;
	cls_stack_top++;
	cls_stack[cls_stack_top] = cls;
	cls_stack_bi[cls_stack_top] = -1;
	continue;
      }
    }
    if (!cls) {
      cls_stack_top--;
      if (cls_stack_top < 0) break;
      else continue;
    }
    cls_stack_bi[cls_stack_top]++;

    meth = cls->methods;
    /* Check for methods */
    while (meth && meth->name) {
      if (strcmp(meth->name,method) == 0) {
	oldarg = objv[1];
	objv[1] = inst->thisptr;
	Tcl_IncrRefCount(inst->thisptr);
	rcode = (*meth->method)(clientData,interp,objc,objv);
	objv[1] = oldarg;
	Tcl_DecrRefCount(inst->thisptr);
	return rcode;
      }
      meth++;
    }
    /* Check class methods for a match */
    if (strcmp(method,"cget") == 0) {
      if (objc < 3) {
	Tcl_SetResult(interp, (char *) "wrong # args.", TCL_STATIC);
	return TCL_ERROR;
      }
      attrname = Tcl_GetStringFromObj(objv[2],NULL);
      attr = cls->attributes;
      while (attr && attr->name) {
	if ((strcmp(attr->name, attrname) == 0) && (attr->getmethod)) {
	  oldarg = objv[1];
	  objv[1] = inst->thisptr;
	  Tcl_IncrRefCount(inst->thisptr);
	  rcode = (*attr->getmethod)(clientData,interp,2, objv);
	  objv[1] = oldarg;
	  Tcl_DecrRefCount(inst->thisptr);
	  return rcode;
	}
	attr++;
      }
      if (strcmp(attrname, "-this") == 0) {
	Tcl_SetObjResult(interp, Tcl_DuplicateObj(inst->thisptr));
	return TCL_OK;
      }
      if (strcmp(attrname, "-thisown") == 0) {
	if (SWIG_Thisown(inst->thisvalue)) {
	  Tcl_SetResult(interp,(char*)"1",TCL_STATIC);
	} else {
	  Tcl_SetResult(interp,(char*)"0",TCL_STATIC);
	}
	return TCL_OK;
      }
    } else if (strcmp(method, "configure") == 0) {
      int i;
      if (objc < 4) {
	Tcl_SetResult(interp, (char *) "wrong # args.", TCL_STATIC);
	return TCL_ERROR;
      }
      i = 2;
      while (i < objc) {
	attrname = Tcl_GetStringFromObj(objv[i],NULL);
	attr = cls->attributes;
	while (attr && attr->name) {
	  if ((strcmp(attr->name, attrname) == 0) && (attr->setmethod)) {
	    oldarg = objv[i];
	    objv[i] = inst->thisptr;
	    Tcl_IncrRefCount(inst->thisptr);
	    rcode = (*attr->setmethod)(clientData,interp,3, &objv[i-1]);
	    objv[i] = oldarg;
	    Tcl_DecrRefCount(inst->thisptr);
	    if (rcode != TCL_OK) return rcode;
	    numconf += 2;
	  }
	  attr++;
	}
	i+=2;
      }
    }
  }
  if (strcmp(method,"configure") == 0) {
    if (numconf >= objc) {
      return TCL_OK;
    } else {
      Tcl_SetResult(interp,(char *) "Invalid attribute name.", TCL_STATIC);
      return TCL_ERROR;
    }
  }
  if (strcmp(method,"cget") == 0) {
      Tcl_SetResult(interp,(char *) "Invalid attribute name.", TCL_STATIC);
      return TCL_ERROR;
  }

  Tcl_SetResult(interp, (char *) "Invalid method. Must be one of: configure cget -acquire -disown -delete", TCL_STATIC);
  cls = inst->classptr;
  bi = 0;
  while (cls) {
    meth = cls->methods;
    while (meth && meth->name) {
      char *cr = (char *) Tcl_GetStringResult(interp);
      if (!strstr(strchr(cr,':'), meth->name))
	Tcl_AppendElement(interp, (char *) meth->name);
      meth++;
    }
    cls = inst->classptr->bases[bi++];
  }
  return TCL_ERROR;
}

/* Function to create objects */
SWIGRUNTIME(int)
SWIG_ObjectConstructor(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[])
{
    Tcl_Obj          *newObj = 0;
    void             *thisvalue = 0;
    swig_instance   *newinst = 0;
    swig_class      *classptr = (swig_class *) clientData;
    swig_wrapper     cons = 0;
    char             *name = 0;
    int               firstarg = 0;
    int               thisarg = 0;
    int               destroy = 1; 

    if (!classptr) {
      Tcl_SetResult(interp, (char *) "swig: internal runtime error. No class object defined.", TCL_STATIC);
      return TCL_ERROR;
    }
    cons = classptr->constructor;
    if (objc > 1) {
      char *s = Tcl_GetStringFromObj(objv[1],NULL);
      if (strcmp(s,"-this") == 0) {
	thisarg = 2;
	cons = 0;
      } else if (strcmp(s,"-args") == 0) {
	firstarg = 1;
      } else if (objc == 2) {
	firstarg = 1;
	name = s;
      } else if (objc >= 3) {
	char *s1;
	name = s;
	s1 = Tcl_GetStringFromObj(objv[2],NULL);
	if (strcmp(s1,"-this") == 0) {
	  thisarg = 3;
	  cons = 0;
	} else {
	  firstarg = 1;
	}
      }
    }
    if (cons) {
      int result;
      result = (*cons)(0, interp, objc-firstarg, &objv[firstarg]);
      if (result != TCL_OK) {
	return result;
      }
      newObj = Tcl_DuplicateObj(Tcl_GetObjResult(interp));
      if (!name) name = Tcl_GetStringFromObj(newObj,NULL);
    } else if (thisarg > 0) {
      if (thisarg < objc) {
	destroy = 0;
	newObj = Tcl_DuplicateObj(objv[thisarg]);
	if (!name) name = Tcl_GetStringFromObj(newObj,NULL);
      } else {
	Tcl_SetResult(interp, (char *) "wrong # args.", TCL_STATIC);
	return TCL_ERROR;
      }
    } else {
      Tcl_SetResult(interp, (char *) "No constructor available.", TCL_STATIC);
      return TCL_ERROR;
    }
    if (SWIG_ConvertPtr(interp,newObj, (void **) &thisvalue, *(classptr->type), SWIG_POINTER_EXCEPTION) == TCL_ERROR) {
      Tcl_DecrRefCount(newObj);
      return TCL_ERROR;
    }
    newinst = (swig_instance *) malloc(sizeof(swig_instance));
    newinst->thisptr = newObj;
    Tcl_IncrRefCount(newObj);
    newinst->thisvalue = thisvalue;
    newinst->classptr = classptr;
    newinst->destroy = destroy;
    if (destroy) {
      SWIG_Acquire(thisvalue);
    }
    newinst->cmdtok = Tcl_CreateObjCommand(interp,name, (swig_wrapper) SWIG_MethodCommand, (ClientData) newinst, (swig_delete_func) SWIG_ObjectDelete);
    return TCL_OK;
}


/* This function takes the current result and turns it into an object command */
SWIGRUNTIME(Tcl_Obj *)
SWIG_NewInstanceObj(Tcl_Interp *interp, void *thisvalue, swig_type_info *type, int flags) {
  Tcl_Obj *robj = SWIG_NewPointerObj(thisvalue, type,0);
  /* Check to see if this pointer belongs to a class or not */
  if ((type->clientdata) && (interp)) {
    Tcl_CmdInfo    ci;
    char          *name;
    name = Tcl_GetStringFromObj(robj,NULL);
    if (!Tcl_GetCommandInfo(interp,name, &ci) || (flags)) {
      swig_instance *newinst = (swig_instance *) malloc(sizeof(swig_instance));
      newinst->thisptr = Tcl_DuplicateObj(robj);
      Tcl_IncrRefCount(newinst->thisptr);
      newinst->thisvalue = thisvalue;
      newinst->classptr = (swig_class *) type->clientdata;
      newinst->destroy = flags;
      newinst->cmdtok = Tcl_CreateObjCommand(interp, Tcl_GetStringFromObj(robj,NULL), (swig_wrapper_func) SWIG_MethodCommand, (ClientData) newinst, (swig_delete_func) SWIG_ObjectDelete);
      if (flags) {
	SWIG_Acquire(thisvalue);
      }
    }
  }
  return robj;
}

#endif

/* Structure for command table */
typedef struct {
  const char *name;
  int       (*wrapper)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST []);
  ClientData  clientdata;
} swig_command_info;

/* Structure for variable linking table */
typedef struct {
  const char *name;
  void *addr;
  char * (*get)(ClientData, Tcl_Interp *, char *, char *, int);
  char * (*set)(ClientData, Tcl_Interp *, char *, char *, int);
} swig_var_info;

#ifdef __cplusplus
}
#endif






/* -------- TYPES TABLE (BEGIN) -------- */

#define  SWIGTYPE_p_librdf_node swig_types[0] 
#define  SWIGTYPE_p_librdf_parser swig_types[1] 
#define  SWIGTYPE_p_librdf_world swig_types[2] 
#define  SWIGTYPE_p_librdf_statement swig_types[3] 
#define  SWIGTYPE_p_librdf_hash swig_types[4] 
#define  SWIGTYPE_p_librdf_iterator swig_types[5] 
#define  SWIGTYPE_p_librdf_storage swig_types[6] 
#define  SWIGTYPE_p_librdf_uri swig_types[7] 
#define  SWIGTYPE_p_librdf_model swig_types[8] 
#define  SWIGTYPE_p_librdf_stream swig_types[9] 
#define  SWIGTYPE_p_librdf_serializer swig_types[10] 
static swig_type_info *swig_types[12];

/* -------- TYPES TABLE (END) -------- */

#define SWIG_init    Redland_Init
#define SWIG_name    "redland"
#define SWIG_prefix  ""
#define SWIG_version "0.0"


#ifdef __cplusplus
extern "C" {
#endif
#ifdef MAC_TCL
#pragma export on
#endif
SWIGEXPORT(int) SWIG_init(Tcl_Interp *);
#ifdef MAC_TCL
#pragma export off
#endif
#ifdef __cplusplus
}
#endif




#ifdef SWIGPERL
/* for perl, these are passed in by MakeMaker derived makefile */
#undef PACKAGE
#undef VERSION

/* Delete one of many names polluted by Perl in embed.h via perl.h */
#ifdef list
#undef list
#endif
#endif

/* SWIG BUG - no SWIGTCL is defined - duh */
#ifdef TCL_MAJOR_VERSION
  /* want symbols starting librdf_ not _librdf_ */
#undef SWIG_prefix
#define SWIG_prefix
#endif

#if defined(SWIGRUBY) || defined (PHP_VERSION)
/* Ruby and PHP pollute the #define space with these names */
#undef PACKAGE_NAME
#undef PACKAGE_STRING
#undef PACKAGE_TARNAME
#undef PACKAGE_VERSION
#undef PACKAGE_BUGREPORT
#endif

#include <rdf_config.h>
#include <redland.h>

/* Internal prototypes */
/* FOR TESTING ERRORS ONLY - NOT PART OF API */
void librdf_internal_test_error(librdf_world *world);
void librdf_internal_test_warning(librdf_world *world);

#ifdef SWIGPYTHON
void librdf_python_world_init(librdf_world *world);
#endif
#ifdef SWIGPERL
void librdf_perl_world_init(librdf_world *world);
void librdf_perl_world_finish(void);
#endif
#ifdef SWIGPHP
librdf_world* librdf_php_get_world(void);
void librdf_php_world_finish(void);
#endif


/* 
 * Thanks to the patch in this Debian bug for the solution
 * to the crash inside vsnprintf on some architectures.
 *
 * "reuse of args inside the while(1) loop is in violation of the
 * specs and only happens to work by accident on other systems."
 *
 * http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=104325 
 */

#ifndef va_copy
#ifdef __va_copy
#define va_copy(dest,src) __va_copy(dest,src)
#else
#define va_copy(dest,src) (dest) = (src)
#endif
#endif



#ifdef SWIGPYTHON
/* swig doesn't seem to declare prototypes of get accessors for statics */
static PyObject *_wrap_librdf_copyright_string_get(void);
static PyObject *_wrap_librdf_version_string_get(void);
static PyObject *_wrap_librdf_short_copyright_string_get(void);
static PyObject *_wrap_librdf_version_decimal_get(void);

static PyObject *_wrap_librdf_version_major_get(void);
static PyObject *_wrap_librdf_version_minor_get(void);
static PyObject *_wrap_librdf_version_release_get(void);

SWIGEXPORT(void) SWIG_init(void);

static PyObject *librdf_python_callback = NULL;

static PyObject * librdf_python_set_callback(PyObject *dummy, PyObject *args);

/*
 * set the Python function object callback
 */
static PyObject *
librdf_python_set_callback(dummy, args)
  PyObject *dummy, *args;
{
  PyObject *result = NULL;
  PyObject *temp;
  
  if (PyArg_ParseTuple(args, "O:set_callback", &temp)) {
    if (!PyCallable_Check(temp)) {
      PyErr_SetString(PyExc_TypeError, "parameter must be callable");
      return NULL;
    }
    Py_XINCREF(temp);         /* Add a reference to new callback */
    Py_XDECREF(librdf_python_callback);  /* Dispose of previous callback */
    librdf_python_callback = temp;       /* Remember new callback */
    /* Boilerplate to return "None" */
    Py_INCREF(Py_None);
    result = Py_None;
  }
  return result;
}


/* Declare a table of methods that python can call */
static PyMethodDef librdf_python_methods [] = {
    {"set_callback",  librdf_python_set_callback, METH_VARARGS,
     "Set python message callback."},
    {NULL, NULL, 0, NULL}        /* Sentinel */
};


/*
 * calls a python function defined as:
 *   RDF.message($$)
 * where first argument is an integer, second is a (scalar) string
 */
static void
librdf_call_python_message(int type, const char *message, va_list arguments)
{
  char empty_buffer[1];
#ifdef PYTHON_EXCEPTIONS_WORKING
  PyObject *arglist;
  PyObject *result;
#endif
  char *buffer;
  int len;
  va_list args_copy;

  if(!librdf_python_callback) {
    fprintf(stderr, "librdf_call_python_message: No message callback registered\n");
    return;
  }

  /* ask vsnprintf size of buffer required */
  va_copy(args_copy, arguments);
  len=vsnprintf(empty_buffer, 1, message, args_copy)+1;
  va_end(args_copy);
  buffer=(char*)malloc(len);
  if(!buffer)
    fprintf(stderr, "librdf_call_python_message: Out of memory\n");
  else {
    va_copy(args_copy, arguments);
    vsnprintf(buffer, len, message, args_copy);
    va_end(args_copy);

    if(type == 0) {
#ifdef PYTHON_EXCEPTIONS_WORKING
      PyObject *error = PyErr_NewException("Redland.error", NULL, NULL);
      /* error */
      PyErr_SetString(error, buffer);
#else
      PyErr_Warn(NULL, buffer);
#endif
    } else {
      /* warning */
       PyErr_Warn(NULL, buffer);
    }

#ifdef PYTHON_EXCEPTIONS_WORKING
    /* call the callback */
    arglist = Py_BuildValue("(is)", type, buffer);
    if(!arglist) {
      fprintf(stderr, "librdf_call_python_message: Out of memory\n");
      free(buffer);
      return;
    }
    result = PyEval_CallObject(librdf_python_callback, arglist);
    Py_DECREF(arglist);
    if (result == NULL) {
      free(buffer);
      return;
    }
    
    /* no result */
    Py_DECREF(result);
#endif
    free(buffer);
  }
}

static void
librdf_python_error_handler(void *user_data, 
                            const char *message, va_list arguments)
{
  librdf_call_python_message(0, message, arguments);
}


static void
librdf_python_warning_handler(void *user_data,
                              const char *message, va_list arguments)
{
  librdf_call_python_message(1, message, arguments);
}

void
librdf_python_world_init(librdf_world *world)
{
  (void) Py_InitModule("Redland_python", librdf_python_methods);
  librdf_world_set_error(world, NULL, librdf_python_error_handler);
  librdf_world_set_warning(world,  NULL, librdf_python_warning_handler);
}
 

#endif

#ifdef SWIGPERL
/*
 * calls a perl subroutine defined as:
 *   RDF::Redland::World::message($$)
 * where first argument is an integer, second is a (scalar) string
 */
static void
librdf_call_perl_message(int type, const char *message, va_list arguments)
{
  char empty_buffer[1];
  dSP;
  char *buffer;
  int len;
  va_list args_copy;
  
  ENTER;
  SAVETMPS;

  /* ask vsnprintf size of buffer required */
  va_copy(args_copy, arguments);
  len=vsnprintf(empty_buffer, 1, message, args_copy)+1;
  va_end(args_copy);
  buffer=(char*)malloc(len);
  if(!buffer)
    fprintf(stderr, "librdf_call_perl_message: Out of memory\n");
  else {
    va_copy(args_copy, arguments);
    vsnprintf(buffer, len, message, args_copy);
    va_end(args_copy);

    PUSHMARK(SP) ;
    XPUSHs(sv_2mortal(newSViv(type)));
    XPUSHs(sv_2mortal(newSVpv(buffer, 0)));
    PUTBACK;
  
    call_pv("RDF::Redland::World::message", G_DISCARD);

    free(buffer);
  }
  
  FREETMPS;
  LEAVE;
}

static void
librdf_perl_error_handler(void *user_data, 
                          const char *message, va_list arguments)
{
  librdf_call_perl_message(0, message, arguments);
}


static void
librdf_perl_warning_handler(void *user_data,
                            const char *message, va_list arguments)
{
  librdf_call_perl_message(1, message, arguments);
}

static librdf_world* librdf_perl_world=NULL;

void
librdf_perl_world_init(librdf_world *world)
{
  librdf_world_set_error(world, NULL, librdf_perl_error_handler);
  librdf_world_set_warning(world,  NULL, librdf_perl_warning_handler);

  librdf_perl_world=world;
}

void
librdf_perl_world_finish(void)
{
  librdf_free_world(librdf_perl_world);
}
#endif


/* When in PHP when being compiled by C */
#if defined (PHP_VERSION)
static librdf_world* librdf_php_world;

static librdf_world*
librdf_php_get_world(void)
{
  return librdf_php_world;
}

void
librdf_php_world_finish(void)
{
  librdf_free_world(librdf_php_world);
}
#endif    


/* prototypes for internal routines called below - NOT PART OF API */
void librdf_error(librdf_world* world, const char *message, ...);
void librdf_warning(librdf_world* world, const char *message, ...);

/* FOR TESTING ERRORS ONLY - NOT PART OF API */
void
librdf_internal_test_error(librdf_world *world) 
{
  librdf_error(world, "test error message number %d.", 1);
}

void
librdf_internal_test_warning(librdf_world *world) 
{
  librdf_warning(world, "test warning message number %d.", 2);
}


extern char const *const librdf_short_copyright_string;
extern char const *const librdf_copyright_string;
extern char const *const librdf_version_string;
extern unsigned int const librdf_version_major;
extern unsigned int const librdf_version_minor;
extern unsigned int const librdf_version_release;
extern unsigned int const librdf_version_decimal;
#ifdef __cplusplus
extern "C" {
#endif
static int
_wrap_librdf_new_world(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_world *result;
    
    if (SWIG_GetArgs(interp, objc, objv,":librdf_new_world ") == TCL_ERROR) SWIG_fail;
    result = (librdf_world *)librdf_new_world();
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj(interp, (void *) result, SWIGTYPE_p_librdf_world,0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_free_world(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:librdf_free_world world ",0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_world,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    librdf_free_world(arg1);
    
    
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_world_open(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:librdf_world_open world ",0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_world,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    librdf_world_open(arg1);
    
    
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_free_iterator(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_iterator *arg1 = (librdf_iterator *) 0 ;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:librdf_free_iterator librdf_iterator * ",0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_iterator,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    librdf_free_iterator(arg1);
    
    
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_iterator_end(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_iterator *arg1 = (librdf_iterator *) 0 ;
    int result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:librdf_iterator_end iterator ",0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_iterator,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (int)librdf_iterator_end(arg1);
    
    Tcl_SetObjResult(interp,Tcl_NewIntObj((long) result));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_iterator_get_object(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_iterator *arg1 = (librdf_iterator *) 0 ;
    librdf_node *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:librdf_iterator_get_object iterator ",0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_iterator,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (librdf_node *)librdf_iterator_get_object(arg1);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj(interp, (void *) result, SWIGTYPE_p_librdf_node,0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_iterator_get_context(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_iterator *arg1 = (librdf_iterator *) 0 ;
    librdf_node *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:librdf_iterator_get_context iterator ",0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_iterator,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (librdf_node *)librdf_iterator_get_context(arg1);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj(interp, (void *) result, SWIGTYPE_p_librdf_node,0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_iterator_next(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_iterator *arg1 = (librdf_iterator *) 0 ;
    int result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:librdf_iterator_next iterator ",0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_iterator,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (int)librdf_iterator_next(arg1);
    
    Tcl_SetObjResult(interp,Tcl_NewIntObj((long) result));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_new_uri(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    char *arg2 ;
    librdf_uri *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"os:librdf_new_uri world string ",0,&arg2) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_world,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (librdf_uri *)librdf_new_uri(arg1,arg2);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj(interp, (void *) result, SWIGTYPE_p_librdf_uri,0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_new_uri_from_uri(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_uri *arg1 = (librdf_uri *) 0 ;
    librdf_uri *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:librdf_new_uri_from_uri uri ",0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_uri,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (librdf_uri *)librdf_new_uri_from_uri(arg1);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj(interp, (void *) result, SWIGTYPE_p_librdf_uri,0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_new_uri_from_filename(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    char *arg2 ;
    librdf_uri *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"os:librdf_new_uri_from_filename world filename ",0,&arg2) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_world,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (librdf_uri *)librdf_new_uri_from_filename(arg1,(char const *)arg2);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj(interp, (void *) result, SWIGTYPE_p_librdf_uri,0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_free_uri(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_uri *arg1 = (librdf_uri *) 0 ;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:librdf_free_uri uri ",0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_uri,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    librdf_free_uri(arg1);
    
    
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_uri_to_string(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_uri *arg1 = (librdf_uri *) 0 ;
    char *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:librdf_uri_to_string uri ",0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_uri,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (char *)librdf_uri_to_string(arg1);
    
    Tcl_SetObjResult(interp,Tcl_NewStringObj(result,-1));
    free(result);
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_uri_equals(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_uri *arg1 = (librdf_uri *) 0 ;
    librdf_uri *arg2 = (librdf_uri *) 0 ;
    int result;
    
    if (SWIG_GetArgs(interp, objc, objv,"oo:librdf_uri_equals first_uri second_uri ",0,0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_uri,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[2], (void **) &arg2, SWIGTYPE_p_librdf_uri,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (int)librdf_uri_equals(arg1,arg2);
    
    Tcl_SetObjResult(interp,Tcl_NewIntObj((long) result));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_new_node(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    librdf_node *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:librdf_new_node world ",0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_world,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (librdf_node *)librdf_new_node(arg1);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj(interp, (void *) result, SWIGTYPE_p_librdf_node,0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_new_node_from_uri_string(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    char *arg2 ;
    librdf_node *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"os:librdf_new_node_from_uri_string world string ",0,&arg2) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_world,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (librdf_node *)librdf_new_node_from_uri_string(arg1,(char const *)arg2);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj(interp, (void *) result, SWIGTYPE_p_librdf_node,0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_new_node_from_uri(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    librdf_uri *arg2 = (librdf_uri *) 0 ;
    librdf_node *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"oo:librdf_new_node_from_uri world uri ",0,0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_world,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[2], (void **) &arg2, SWIGTYPE_p_librdf_uri,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (librdf_node *)librdf_new_node_from_uri(arg1,arg2);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj(interp, (void *) result, SWIGTYPE_p_librdf_node,0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_new_node_from_literal(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    char *arg2 ;
    char *arg3 ;
    int arg4 ;
    librdf_node *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"ossi:librdf_new_node_from_literal world string xml_language is_wf_xml ",0,&arg2,&arg3,&arg4) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_world,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (librdf_node *)librdf_new_node_from_literal(arg1,(char const *)arg2,(char const *)arg3,arg4);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj(interp, (void *) result, SWIGTYPE_p_librdf_node,0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_new_node_from_typed_literal(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    char *arg2 ;
    char *arg3 ;
    librdf_uri *arg4 = (librdf_uri *) 0 ;
    librdf_node *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"osso:librdf_new_node_from_typed_literal world string xml_language datatype_uri ",0,&arg2,&arg3,0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_world,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[4], (void **) &arg4, SWIGTYPE_p_librdf_uri,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (librdf_node *)librdf_new_node_from_typed_literal(arg1,(char const *)arg2,(char const *)arg3,arg4);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj(interp, (void *) result, SWIGTYPE_p_librdf_node,0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_new_node_from_node(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_node *arg1 = (librdf_node *) 0 ;
    librdf_node *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:librdf_new_node_from_node node ",0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (librdf_node *)librdf_new_node_from_node(arg1);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj(interp, (void *) result, SWIGTYPE_p_librdf_node,0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_new_node_from_blank_identifier(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    char *arg2 ;
    librdf_node *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"os:librdf_new_node_from_blank_identifier world identifier ",0,&arg2) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_world,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (librdf_node *)librdf_new_node_from_blank_identifier(arg1,(char const *)arg2);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj(interp, (void *) result, SWIGTYPE_p_librdf_node,0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_free_node(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_node *arg1 = (librdf_node *) 0 ;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:librdf_free_node r ",0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    librdf_free_node(arg1);
    
    
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_node_get_uri(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_node *arg1 = (librdf_node *) 0 ;
    librdf_uri *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:librdf_node_get_uri node ",0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (librdf_uri *)librdf_node_get_uri(arg1);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj(interp, (void *) result, SWIGTYPE_p_librdf_uri,0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_node_get_type(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_node *arg1 = (librdf_node *) 0 ;
    int result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:librdf_node_get_type node ",0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (int)librdf_node_get_type(arg1);
    
    Tcl_SetObjResult(interp,Tcl_NewIntObj((long) result));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_node_get_literal_value(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_node *arg1 = (librdf_node *) 0 ;
    char *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:librdf_node_get_literal_value node ",0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (char *)librdf_node_get_literal_value(arg1);
    
    Tcl_SetObjResult(interp,Tcl_NewStringObj(result,-1));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_node_get_literal_value_as_latin1(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_node *arg1 = (librdf_node *) 0 ;
    char *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:librdf_node_get_literal_value_as_latin1 node ",0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (char *)librdf_node_get_literal_value_as_latin1(arg1);
    
    Tcl_SetObjResult(interp,Tcl_NewStringObj(result,-1));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_node_get_literal_value_language(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_node *arg1 = (librdf_node *) 0 ;
    char *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:librdf_node_get_literal_value_language node ",0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (char *)librdf_node_get_literal_value_language(arg1);
    
    Tcl_SetObjResult(interp,Tcl_NewStringObj(result,-1));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_node_get_literal_value_datatype_uri(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_node *arg1 = (librdf_node *) 0 ;
    librdf_uri *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:librdf_node_get_literal_value_datatype_uri node ",0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (librdf_uri *)librdf_node_get_literal_value_datatype_uri(arg1);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj(interp, (void *) result, SWIGTYPE_p_librdf_uri,0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_node_get_literal_value_is_wf_xml(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_node *arg1 = (librdf_node *) 0 ;
    int result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:librdf_node_get_literal_value_is_wf_xml node ",0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (int)librdf_node_get_literal_value_is_wf_xml(arg1);
    
    Tcl_SetObjResult(interp,Tcl_NewIntObj((long) result));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_node_to_string(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_node *arg1 = (librdf_node *) 0 ;
    char *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:librdf_node_to_string node ",0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (char *)librdf_node_to_string(arg1);
    
    Tcl_SetObjResult(interp,Tcl_NewStringObj(result,-1));
    free(result);
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_node_get_blank_identifier(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_node *arg1 = (librdf_node *) 0 ;
    char *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:librdf_node_get_blank_identifier node ",0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (char *)librdf_node_get_blank_identifier(arg1);
    
    Tcl_SetObjResult(interp,Tcl_NewStringObj(result,-1));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_node_is_resource(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_node *arg1 = (librdf_node *) 0 ;
    int result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:librdf_node_is_resource node ",0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (int)librdf_node_is_resource(arg1);
    
    Tcl_SetObjResult(interp,Tcl_NewIntObj((long) result));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_node_is_literal(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_node *arg1 = (librdf_node *) 0 ;
    int result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:librdf_node_is_literal node ",0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (int)librdf_node_is_literal(arg1);
    
    Tcl_SetObjResult(interp,Tcl_NewIntObj((long) result));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_node_is_blank(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_node *arg1 = (librdf_node *) 0 ;
    int result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:librdf_node_is_blank node ",0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (int)librdf_node_is_blank(arg1);
    
    Tcl_SetObjResult(interp,Tcl_NewIntObj((long) result));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_node_equals(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_node *arg1 = (librdf_node *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    int result;
    
    if (SWIG_GetArgs(interp, objc, objv,"oo:librdf_node_equals first_node second_node ",0,0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[2], (void **) &arg2, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (int)librdf_node_equals(arg1,arg2);
    
    Tcl_SetObjResult(interp,Tcl_NewIntObj((long) result));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_new_statement(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    librdf_statement *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:librdf_new_statement world ",0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_world,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (librdf_statement *)librdf_new_statement(arg1);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj(interp, (void *) result, SWIGTYPE_p_librdf_statement,0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_new_statement_from_statement(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_statement *arg1 = (librdf_statement *) 0 ;
    librdf_statement *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:librdf_new_statement_from_statement statement ",0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_statement,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (librdf_statement *)librdf_new_statement_from_statement(arg1);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj(interp, (void *) result, SWIGTYPE_p_librdf_statement,0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_new_statement_from_nodes(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_node *arg3 = (librdf_node *) 0 ;
    librdf_node *arg4 = (librdf_node *) 0 ;
    librdf_statement *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"oooo:librdf_new_statement_from_nodes world subject predicate object ",0,0,0,0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_world,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[2], (void **) &arg2, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[3], (void **) &arg3, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[4], (void **) &arg4, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (librdf_statement *)librdf_new_statement_from_nodes(arg1,arg2,arg3,arg4);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj(interp, (void *) result, SWIGTYPE_p_librdf_statement,0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_free_statement(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_statement *arg1 = (librdf_statement *) 0 ;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:librdf_free_statement statement ",0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_statement,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    librdf_free_statement(arg1);
    
    
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_statement_get_subject(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_statement *arg1 = (librdf_statement *) 0 ;
    librdf_node *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:librdf_statement_get_subject statement ",0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_statement,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (librdf_node *)librdf_statement_get_subject(arg1);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj(interp, (void *) result, SWIGTYPE_p_librdf_node,0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_statement_set_subject(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_statement *arg1 = (librdf_statement *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    
    if (SWIG_GetArgs(interp, objc, objv,"oo:librdf_statement_set_subject statement subject ",0,0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_statement,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[2], (void **) &arg2, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    librdf_statement_set_subject(arg1,arg2);
    
    
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_statement_get_predicate(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_statement *arg1 = (librdf_statement *) 0 ;
    librdf_node *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:librdf_statement_get_predicate statement ",0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_statement,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (librdf_node *)librdf_statement_get_predicate(arg1);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj(interp, (void *) result, SWIGTYPE_p_librdf_node,0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_statement_set_predicate(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_statement *arg1 = (librdf_statement *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    
    if (SWIG_GetArgs(interp, objc, objv,"oo:librdf_statement_set_predicate statement predicate ",0,0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_statement,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[2], (void **) &arg2, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    librdf_statement_set_predicate(arg1,arg2);
    
    
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_statement_get_object(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_statement *arg1 = (librdf_statement *) 0 ;
    librdf_node *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:librdf_statement_get_object statement ",0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_statement,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (librdf_node *)librdf_statement_get_object(arg1);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj(interp, (void *) result, SWIGTYPE_p_librdf_node,0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_statement_set_object(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_statement *arg1 = (librdf_statement *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    
    if (SWIG_GetArgs(interp, objc, objv,"oo:librdf_statement_set_object statement object ",0,0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_statement,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[2], (void **) &arg2, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    librdf_statement_set_object(arg1,arg2);
    
    
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_statement_to_string(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_statement *arg1 = (librdf_statement *) 0 ;
    char *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:librdf_statement_to_string statement ",0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_statement,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (char *)librdf_statement_to_string(arg1);
    
    Tcl_SetObjResult(interp,Tcl_NewStringObj(result,-1));
    free(result);
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_new_model(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    librdf_storage *arg2 = (librdf_storage *) 0 ;
    char *arg3 ;
    librdf_model *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"oos:librdf_new_model world storage options_string ",0,0,&arg3) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_world,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[2], (void **) &arg2, SWIGTYPE_p_librdf_storage,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (librdf_model *)librdf_new_model(arg1,arg2,arg3);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj(interp, (void *) result, SWIGTYPE_p_librdf_model,0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_new_model_with_options(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    librdf_storage *arg2 = (librdf_storage *) 0 ;
    librdf_hash *arg3 = (librdf_hash *) 0 ;
    librdf_model *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"ooo:librdf_new_model_with_options world storage options ",0,0,0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_world,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[2], (void **) &arg2, SWIGTYPE_p_librdf_storage,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[3], (void **) &arg3, SWIGTYPE_p_librdf_hash,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (librdf_model *)librdf_new_model_with_options(arg1,arg2,arg3);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj(interp, (void *) result, SWIGTYPE_p_librdf_model,0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_new_model_from_model(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_model *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:librdf_new_model_from_model model ",0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_model,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (librdf_model *)librdf_new_model_from_model(arg1);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj(interp, (void *) result, SWIGTYPE_p_librdf_model,0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_free_model(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:librdf_free_model model ",0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_model,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    librdf_free_model(arg1);
    
    
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_model_size(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    int result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:librdf_model_size model ",0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_model,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (int)librdf_model_size(arg1);
    
    Tcl_SetObjResult(interp,Tcl_NewIntObj((long) result));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_model_add(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_node *arg3 = (librdf_node *) 0 ;
    librdf_node *arg4 = (librdf_node *) 0 ;
    int result;
    
    if (SWIG_GetArgs(interp, objc, objv,"oooo:librdf_model_add model subject predicate object ",0,0,0,0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_model,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[2], (void **) &arg2, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[3], (void **) &arg3, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[4], (void **) &arg4, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (int)librdf_model_add(arg1,arg2,arg3,arg4);
    
    Tcl_SetObjResult(interp,Tcl_NewIntObj((long) result));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_model_add_typed_literal_statement(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_node *arg3 = (librdf_node *) 0 ;
    char *arg4 ;
    char *arg5 ;
    librdf_uri *arg6 = (librdf_uri *) 0 ;
    int result;
    
    if (SWIG_GetArgs(interp, objc, objv,"ooosso:librdf_model_add_typed_literal_statement model subject predicate string xml_language datatype_uri ",0,0,0,&arg4,&arg5,0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_model,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[2], (void **) &arg2, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[3], (void **) &arg3, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[6], (void **) &arg6, SWIGTYPE_p_librdf_uri,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (int)librdf_model_add_typed_literal_statement(arg1,arg2,arg3,arg4,arg5,arg6);
    
    Tcl_SetObjResult(interp,Tcl_NewIntObj((long) result));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_model_add_statement(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_statement *arg2 = (librdf_statement *) 0 ;
    int result;
    
    if (SWIG_GetArgs(interp, objc, objv,"oo:librdf_model_add_statement model statement ",0,0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_model,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[2], (void **) &arg2, SWIGTYPE_p_librdf_statement,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (int)librdf_model_add_statement(arg1,arg2);
    
    Tcl_SetObjResult(interp,Tcl_NewIntObj((long) result));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_model_add_statements(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_stream *arg2 = (librdf_stream *) 0 ;
    int result;
    
    if (SWIG_GetArgs(interp, objc, objv,"oo:librdf_model_add_statements model statement_stream ",0,0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_model,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[2], (void **) &arg2, SWIGTYPE_p_librdf_stream,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (int)librdf_model_add_statements(arg1,arg2);
    
    Tcl_SetObjResult(interp,Tcl_NewIntObj((long) result));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_model_remove_statement(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_statement *arg2 = (librdf_statement *) 0 ;
    int result;
    
    if (SWIG_GetArgs(interp, objc, objv,"oo:librdf_model_remove_statement model statement ",0,0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_model,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[2], (void **) &arg2, SWIGTYPE_p_librdf_statement,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (int)librdf_model_remove_statement(arg1,arg2);
    
    Tcl_SetObjResult(interp,Tcl_NewIntObj((long) result));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_model_contains_statement(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_statement *arg2 = (librdf_statement *) 0 ;
    int result;
    
    if (SWIG_GetArgs(interp, objc, objv,"oo:librdf_model_contains_statement model statement ",0,0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_model,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[2], (void **) &arg2, SWIGTYPE_p_librdf_statement,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (int)librdf_model_contains_statement(arg1,arg2);
    
    Tcl_SetObjResult(interp,Tcl_NewIntObj((long) result));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_model_as_stream(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_stream *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:librdf_model_as_stream model ",0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_model,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (librdf_stream *)librdf_model_as_stream(arg1);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj(interp, (void *) result, SWIGTYPE_p_librdf_stream,0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_model_find_statements(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_statement *arg2 = (librdf_statement *) 0 ;
    librdf_stream *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"oo:librdf_model_find_statements model statement ",0,0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_model,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[2], (void **) &arg2, SWIGTYPE_p_librdf_statement,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (librdf_stream *)librdf_model_find_statements(arg1,arg2);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj(interp, (void *) result, SWIGTYPE_p_librdf_stream,0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_model_find_statements_in_context(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_statement *arg2 = (librdf_statement *) 0 ;
    librdf_node *arg3 = (librdf_node *) 0 ;
    librdf_stream *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"ooo:librdf_model_find_statements_in_context model statement context_node ",0,0,0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_model,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[2], (void **) &arg2, SWIGTYPE_p_librdf_statement,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[3], (void **) &arg3, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (librdf_stream *)librdf_model_find_statements_in_context(arg1,arg2,arg3);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj(interp, (void *) result, SWIGTYPE_p_librdf_stream,0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_model_get_sources(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_node *arg3 = (librdf_node *) 0 ;
    librdf_iterator *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"ooo:librdf_model_get_sources model arc target ",0,0,0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_model,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[2], (void **) &arg2, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[3], (void **) &arg3, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (librdf_iterator *)librdf_model_get_sources(arg1,arg2,arg3);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj(interp, (void *) result, SWIGTYPE_p_librdf_iterator,0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_model_get_arcs(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_node *arg3 = (librdf_node *) 0 ;
    librdf_iterator *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"ooo:librdf_model_get_arcs model source target ",0,0,0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_model,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[2], (void **) &arg2, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[3], (void **) &arg3, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (librdf_iterator *)librdf_model_get_arcs(arg1,arg2,arg3);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj(interp, (void *) result, SWIGTYPE_p_librdf_iterator,0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_model_get_targets(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_node *arg3 = (librdf_node *) 0 ;
    librdf_iterator *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"ooo:librdf_model_get_targets model source arc ",0,0,0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_model,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[2], (void **) &arg2, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[3], (void **) &arg3, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (librdf_iterator *)librdf_model_get_targets(arg1,arg2,arg3);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj(interp, (void *) result, SWIGTYPE_p_librdf_iterator,0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_model_get_source(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_node *arg3 = (librdf_node *) 0 ;
    librdf_node *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"ooo:librdf_model_get_source model arc target ",0,0,0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_model,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[2], (void **) &arg2, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[3], (void **) &arg3, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (librdf_node *)librdf_model_get_source(arg1,arg2,arg3);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj(interp, (void *) result, SWIGTYPE_p_librdf_node,0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_model_get_arc(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_node *arg3 = (librdf_node *) 0 ;
    librdf_node *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"ooo:librdf_model_get_arc model source target ",0,0,0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_model,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[2], (void **) &arg2, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[3], (void **) &arg3, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (librdf_node *)librdf_model_get_arc(arg1,arg2,arg3);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj(interp, (void *) result, SWIGTYPE_p_librdf_node,0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_model_get_target(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_node *arg3 = (librdf_node *) 0 ;
    librdf_node *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"ooo:librdf_model_get_target model source arc ",0,0,0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_model,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[2], (void **) &arg2, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[3], (void **) &arg3, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (librdf_node *)librdf_model_get_target(arg1,arg2,arg3);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj(interp, (void *) result, SWIGTYPE_p_librdf_node,0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_model_context_add_statement(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_statement *arg3 = (librdf_statement *) 0 ;
    int result;
    
    if (SWIG_GetArgs(interp, objc, objv,"ooo:librdf_model_context_add_statement model context statement ",0,0,0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_model,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[2], (void **) &arg2, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[3], (void **) &arg3, SWIGTYPE_p_librdf_statement,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (int)librdf_model_context_add_statement(arg1,arg2,arg3);
    
    Tcl_SetObjResult(interp,Tcl_NewIntObj((long) result));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_model_context_add_statements(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_stream *arg3 = (librdf_stream *) 0 ;
    int result;
    
    if (SWIG_GetArgs(interp, objc, objv,"ooo:librdf_model_context_add_statements model context stream ",0,0,0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_model,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[2], (void **) &arg2, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[3], (void **) &arg3, SWIGTYPE_p_librdf_stream,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (int)librdf_model_context_add_statements(arg1,arg2,arg3);
    
    Tcl_SetObjResult(interp,Tcl_NewIntObj((long) result));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_model_context_remove_statement(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_statement *arg3 = (librdf_statement *) 0 ;
    int result;
    
    if (SWIG_GetArgs(interp, objc, objv,"ooo:librdf_model_context_remove_statement model context statement ",0,0,0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_model,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[2], (void **) &arg2, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[3], (void **) &arg3, SWIGTYPE_p_librdf_statement,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (int)librdf_model_context_remove_statement(arg1,arg2,arg3);
    
    Tcl_SetObjResult(interp,Tcl_NewIntObj((long) result));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_model_context_remove_statements(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    int result;
    
    if (SWIG_GetArgs(interp, objc, objv,"oo:librdf_model_context_remove_statements model context ",0,0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_model,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[2], (void **) &arg2, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (int)librdf_model_context_remove_statements(arg1,arg2);
    
    Tcl_SetObjResult(interp,Tcl_NewIntObj((long) result));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_model_context_as_stream(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_stream *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"oo:librdf_model_context_as_stream model context ",0,0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_model,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[2], (void **) &arg2, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (librdf_stream *)librdf_model_context_as_stream(arg1,arg2);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj(interp, (void *) result, SWIGTYPE_p_librdf_stream,0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_model_sync(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:librdf_model_sync model ",0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_model,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    librdf_model_sync(arg1);
    
    
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_model_get_contexts(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_iterator *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:librdf_model_get_contexts model ",0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_model,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (librdf_iterator *)librdf_model_get_contexts(arg1);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj(interp, (void *) result, SWIGTYPE_p_librdf_iterator,0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_model_get_feature(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_uri *arg2 = (librdf_uri *) 0 ;
    librdf_node *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"oo:librdf_model_get_feature model feature ",0,0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_model,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[2], (void **) &arg2, SWIGTYPE_p_librdf_uri,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (librdf_node *)librdf_model_get_feature(arg1,arg2);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj(interp, (void *) result, SWIGTYPE_p_librdf_node,0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_model_set_feature(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_uri *arg2 = (librdf_uri *) 0 ;
    librdf_node *arg3 = (librdf_node *) 0 ;
    int result;
    
    if (SWIG_GetArgs(interp, objc, objv,"ooo:librdf_model_set_feature model feature value ",0,0,0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_model,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[2], (void **) &arg2, SWIGTYPE_p_librdf_uri,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[3], (void **) &arg3, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (int)librdf_model_set_feature(arg1,arg2,arg3);
    
    Tcl_SetObjResult(interp,Tcl_NewIntObj((long) result));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_new_storage(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    char *arg2 ;
    char *arg3 ;
    char *arg4 ;
    librdf_storage *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"osss:librdf_new_storage world storage_name name options_string ",0,&arg2,&arg3,&arg4) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_world,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (librdf_storage *)librdf_new_storage(arg1,arg2,arg3,arg4);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj(interp, (void *) result, SWIGTYPE_p_librdf_storage,0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_new_storage_from_storage(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_storage *arg1 = (librdf_storage *) 0 ;
    librdf_storage *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:librdf_new_storage_from_storage old_storage ",0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_storage,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (librdf_storage *)librdf_new_storage_from_storage(arg1);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj(interp, (void *) result, SWIGTYPE_p_librdf_storage,0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_free_storage(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_storage *arg1 = (librdf_storage *) 0 ;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:librdf_free_storage storage ",0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_storage,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    librdf_free_storage(arg1);
    
    
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_new_parser(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    char *arg2 ;
    char *arg3 ;
    librdf_uri *arg4 = (librdf_uri *) 0 ;
    librdf_parser *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"osso:librdf_new_parser world name mime_type type_uri ",0,&arg2,&arg3,0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_world,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[4], (void **) &arg4, SWIGTYPE_p_librdf_uri,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (librdf_parser *)librdf_new_parser(arg1,(char const *)arg2,(char const *)arg3,arg4);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj(interp, (void *) result, SWIGTYPE_p_librdf_parser,0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_free_parser(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_parser *arg1 = (librdf_parser *) 0 ;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:librdf_free_parser parser ",0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_parser,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    librdf_free_parser(arg1);
    
    
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_parser_parse_as_stream(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_parser *arg1 = (librdf_parser *) 0 ;
    librdf_uri *arg2 = (librdf_uri *) 0 ;
    librdf_uri *arg3 = (librdf_uri *) 0 ;
    librdf_stream *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"ooo:librdf_parser_parse_as_stream parser uri base_uri ",0,0,0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_parser,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[2], (void **) &arg2, SWIGTYPE_p_librdf_uri,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[3], (void **) &arg3, SWIGTYPE_p_librdf_uri,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (librdf_stream *)librdf_parser_parse_as_stream(arg1,arg2,arg3);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj(interp, (void *) result, SWIGTYPE_p_librdf_stream,0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_parser_parse_into_model(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_parser *arg1 = (librdf_parser *) 0 ;
    librdf_uri *arg2 = (librdf_uri *) 0 ;
    librdf_uri *arg3 = (librdf_uri *) 0 ;
    librdf_model *arg4 = (librdf_model *) 0 ;
    int result;
    
    if (SWIG_GetArgs(interp, objc, objv,"oooo:librdf_parser_parse_into_model parser uri base_uri model ",0,0,0,0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_parser,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[2], (void **) &arg2, SWIGTYPE_p_librdf_uri,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[3], (void **) &arg3, SWIGTYPE_p_librdf_uri,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[4], (void **) &arg4, SWIGTYPE_p_librdf_model,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (int)librdf_parser_parse_into_model(arg1,arg2,arg3,arg4);
    
    Tcl_SetObjResult(interp,Tcl_NewIntObj((long) result));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_parser_parse_string_as_stream(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_parser *arg1 = (librdf_parser *) 0 ;
    char *arg2 ;
    librdf_uri *arg3 = (librdf_uri *) 0 ;
    librdf_stream *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"oso:librdf_parser_parse_string_as_stream parser string base_uri ",0,&arg2,0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_parser,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[3], (void **) &arg3, SWIGTYPE_p_librdf_uri,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (librdf_stream *)librdf_parser_parse_string_as_stream(arg1,(char const *)arg2,arg3);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj(interp, (void *) result, SWIGTYPE_p_librdf_stream,0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_parser_parse_string_into_model(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_parser *arg1 = (librdf_parser *) 0 ;
    char *arg2 ;
    librdf_uri *arg3 = (librdf_uri *) 0 ;
    librdf_model *arg4 = (librdf_model *) 0 ;
    int result;
    
    if (SWIG_GetArgs(interp, objc, objv,"osoo:librdf_parser_parse_string_into_model parser string base_uri model ",0,&arg2,0,0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_parser,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[3], (void **) &arg3, SWIGTYPE_p_librdf_uri,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[4], (void **) &arg4, SWIGTYPE_p_librdf_model,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (int)librdf_parser_parse_string_into_model(arg1,(char const *)arg2,arg3,arg4);
    
    Tcl_SetObjResult(interp,Tcl_NewIntObj((long) result));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_parser_get_feature(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_parser *arg1 = (librdf_parser *) 0 ;
    librdf_uri *arg2 = (librdf_uri *) 0 ;
    librdf_node *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"oo:librdf_parser_get_feature parser feature ",0,0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_parser,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[2], (void **) &arg2, SWIGTYPE_p_librdf_uri,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (librdf_node *)librdf_parser_get_feature(arg1,arg2);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj(interp, (void *) result, SWIGTYPE_p_librdf_node,0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_parser_set_feature(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_parser *arg1 = (librdf_parser *) 0 ;
    librdf_uri *arg2 = (librdf_uri *) 0 ;
    librdf_node *arg3 = (librdf_node *) 0 ;
    int result;
    
    if (SWIG_GetArgs(interp, objc, objv,"ooo:librdf_parser_set_feature parser feature value ",0,0,0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_parser,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[2], (void **) &arg2, SWIGTYPE_p_librdf_uri,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[3], (void **) &arg3, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (int)librdf_parser_set_feature(arg1,arg2,arg3);
    
    Tcl_SetObjResult(interp,Tcl_NewIntObj((long) result));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_new_serializer(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    char *arg2 ;
    char *arg3 ;
    librdf_uri *arg4 = (librdf_uri *) 0 ;
    librdf_serializer *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"osso:librdf_new_serializer world name mime_type type_uri ",0,&arg2,&arg3,0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_world,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[4], (void **) &arg4, SWIGTYPE_p_librdf_uri,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (librdf_serializer *)librdf_new_serializer(arg1,(char const *)arg2,(char const *)arg3,arg4);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj(interp, (void *) result, SWIGTYPE_p_librdf_serializer,0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_free_serializer(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_serializer *arg1 = (librdf_serializer *) 0 ;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:librdf_free_serializer serializer ",0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_serializer,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    librdf_free_serializer(arg1);
    
    
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_serializer_serialize_model_to_file(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_serializer *arg1 = (librdf_serializer *) 0 ;
    char *arg2 ;
    librdf_uri *arg3 = (librdf_uri *) 0 ;
    librdf_model *arg4 = (librdf_model *) 0 ;
    int result;
    
    if (SWIG_GetArgs(interp, objc, objv,"osoo:librdf_serializer_serialize_model_to_file serializer name base_uri model ",0,&arg2,0,0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_serializer,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[3], (void **) &arg3, SWIGTYPE_p_librdf_uri,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[4], (void **) &arg4, SWIGTYPE_p_librdf_model,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (int)librdf_serializer_serialize_model_to_file(arg1,(char const *)arg2,arg3,arg4);
    
    Tcl_SetObjResult(interp,Tcl_NewIntObj((long) result));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_serializer_get_feature(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_serializer *arg1 = (librdf_serializer *) 0 ;
    librdf_uri *arg2 = (librdf_uri *) 0 ;
    librdf_node *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"oo:librdf_serializer_get_feature serializer feature ",0,0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_serializer,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[2], (void **) &arg2, SWIGTYPE_p_librdf_uri,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (librdf_node *)librdf_serializer_get_feature(arg1,arg2);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj(interp, (void *) result, SWIGTYPE_p_librdf_node,0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_serializer_set_feature(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_serializer *arg1 = (librdf_serializer *) 0 ;
    librdf_uri *arg2 = (librdf_uri *) 0 ;
    librdf_node *arg3 = (librdf_node *) 0 ;
    int result;
    
    if (SWIG_GetArgs(interp, objc, objv,"ooo:librdf_serializer_set_feature serializer feature value ",0,0,0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_serializer,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[2], (void **) &arg2, SWIGTYPE_p_librdf_uri,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[3], (void **) &arg3, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (int)librdf_serializer_set_feature(arg1,arg2,arg3);
    
    Tcl_SetObjResult(interp,Tcl_NewIntObj((long) result));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_free_stream(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_stream *arg1 = (librdf_stream *) 0 ;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:librdf_free_stream stream ",0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_stream,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    librdf_free_stream(arg1);
    
    
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_stream_end(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_stream *arg1 = (librdf_stream *) 0 ;
    int result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:librdf_stream_end stream ",0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_stream,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (int)librdf_stream_end(arg1);
    
    Tcl_SetObjResult(interp,Tcl_NewIntObj((long) result));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_stream_next(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_stream *arg1 = (librdf_stream *) 0 ;
    int result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:librdf_stream_next stream ",0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_stream,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (int)librdf_stream_next(arg1);
    
    Tcl_SetObjResult(interp,Tcl_NewIntObj((long) result));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_stream_get_object(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_stream *arg1 = (librdf_stream *) 0 ;
    librdf_statement *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:librdf_stream_get_object stream ",0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_stream,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (librdf_statement *)librdf_stream_get_object(arg1);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj(interp, (void *) result, SWIGTYPE_p_librdf_statement,0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_stream_get_context(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_stream *arg1 = (librdf_stream *) 0 ;
    librdf_node *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:librdf_stream_get_context stream ",0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_stream,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (librdf_node *)librdf_stream_get_context(arg1);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj(interp, (void *) result, SWIGTYPE_p_librdf_node,0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_internal_test_error(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:librdf_internal_test_error world ",0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_world,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    librdf_internal_test_error(arg1);
    
    
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_librdf_internal_test_warning(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:librdf_internal_test_warning world ",0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(interp, objv[1], (void **) &arg1, SWIGTYPE_p_librdf_world,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    librdf_internal_test_warning(arg1);
    
    
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static char *_wrap_librdf_short_copyright_string_get(ClientData clientData, Tcl_Interp *interp, char *name1, char *name2, int flags) {
    Tcl_Obj *value = 0;
    
    value = Tcl_NewStringObj((char*) librdf_short_copyright_string,-1);
    if (value) {
        Tcl_SetVar2(interp,name1,name2,Tcl_GetStringFromObj(value,NULL), flags);
        Tcl_DecrRefCount(value);
    }
    return NULL;
}


static const char *swig_readonly(ClientData clientData, Tcl_Interp *interp, char *name1, char *name2, int flags) {
    return (char*) "Variable is read-only";
}


static char *_wrap_librdf_copyright_string_get(ClientData clientData, Tcl_Interp *interp, char *name1, char *name2, int flags) {
    Tcl_Obj *value = 0;
    
    value = Tcl_NewStringObj((char*) librdf_copyright_string,-1);
    if (value) {
        Tcl_SetVar2(interp,name1,name2,Tcl_GetStringFromObj(value,NULL), flags);
        Tcl_DecrRefCount(value);
    }
    return NULL;
}


static char *_wrap_librdf_version_string_get(ClientData clientData, Tcl_Interp *interp, char *name1, char *name2, int flags) {
    Tcl_Obj *value = 0;
    
    value = Tcl_NewStringObj((char*) librdf_version_string,-1);
    if (value) {
        Tcl_SetVar2(interp,name1,name2,Tcl_GetStringFromObj(value,NULL), flags);
        Tcl_DecrRefCount(value);
    }
    return NULL;
}


static char *_wrap_librdf_version_major_get(ClientData clientData, Tcl_Interp *interp, char *name1, char *name2, int flags) {
    Tcl_Obj *value = 0;
    
    value = Tcl_NewIntObj((long) librdf_version_major);
    if (value) {
        Tcl_SetVar2(interp,name1,name2,Tcl_GetStringFromObj(value,NULL), flags);
        Tcl_DecrRefCount(value);
    }
    return NULL;
}


static char *_wrap_librdf_version_minor_get(ClientData clientData, Tcl_Interp *interp, char *name1, char *name2, int flags) {
    Tcl_Obj *value = 0;
    
    value = Tcl_NewIntObj((long) librdf_version_minor);
    if (value) {
        Tcl_SetVar2(interp,name1,name2,Tcl_GetStringFromObj(value,NULL), flags);
        Tcl_DecrRefCount(value);
    }
    return NULL;
}


static char *_wrap_librdf_version_release_get(ClientData clientData, Tcl_Interp *interp, char *name1, char *name2, int flags) {
    Tcl_Obj *value = 0;
    
    value = Tcl_NewIntObj((long) librdf_version_release);
    if (value) {
        Tcl_SetVar2(interp,name1,name2,Tcl_GetStringFromObj(value,NULL), flags);
        Tcl_DecrRefCount(value);
    }
    return NULL;
}


static char *_wrap_librdf_version_decimal_get(ClientData clientData, Tcl_Interp *interp, char *name1, char *name2, int flags) {
    Tcl_Obj *value = 0;
    
    value = Tcl_NewIntObj((long) librdf_version_decimal);
    if (value) {
        Tcl_SetVar2(interp,name1,name2,Tcl_GetStringFromObj(value,NULL), flags);
        Tcl_DecrRefCount(value);
    }
    return NULL;
}



static swig_command_info swig_commands[] = {
    { SWIG_prefix "librdf_new_world", (swig_wrapper_func) _wrap_librdf_new_world, NULL},
    { SWIG_prefix "librdf_free_world", (swig_wrapper_func) _wrap_librdf_free_world, NULL},
    { SWIG_prefix "librdf_world_open", (swig_wrapper_func) _wrap_librdf_world_open, NULL},
    { SWIG_prefix "librdf_free_iterator", (swig_wrapper_func) _wrap_librdf_free_iterator, NULL},
    { SWIG_prefix "librdf_iterator_end", (swig_wrapper_func) _wrap_librdf_iterator_end, NULL},
    { SWIG_prefix "librdf_iterator_get_object", (swig_wrapper_func) _wrap_librdf_iterator_get_object, NULL},
    { SWIG_prefix "librdf_iterator_get_context", (swig_wrapper_func) _wrap_librdf_iterator_get_context, NULL},
    { SWIG_prefix "librdf_iterator_next", (swig_wrapper_func) _wrap_librdf_iterator_next, NULL},
    { SWIG_prefix "librdf_new_uri", (swig_wrapper_func) _wrap_librdf_new_uri, NULL},
    { SWIG_prefix "librdf_new_uri_from_uri", (swig_wrapper_func) _wrap_librdf_new_uri_from_uri, NULL},
    { SWIG_prefix "librdf_new_uri_from_filename", (swig_wrapper_func) _wrap_librdf_new_uri_from_filename, NULL},
    { SWIG_prefix "librdf_free_uri", (swig_wrapper_func) _wrap_librdf_free_uri, NULL},
    { SWIG_prefix "librdf_uri_to_string", (swig_wrapper_func) _wrap_librdf_uri_to_string, NULL},
    { SWIG_prefix "librdf_uri_equals", (swig_wrapper_func) _wrap_librdf_uri_equals, NULL},
    { SWIG_prefix "librdf_new_node", (swig_wrapper_func) _wrap_librdf_new_node, NULL},
    { SWIG_prefix "librdf_new_node_from_uri_string", (swig_wrapper_func) _wrap_librdf_new_node_from_uri_string, NULL},
    { SWIG_prefix "librdf_new_node_from_uri", (swig_wrapper_func) _wrap_librdf_new_node_from_uri, NULL},
    { SWIG_prefix "librdf_new_node_from_literal", (swig_wrapper_func) _wrap_librdf_new_node_from_literal, NULL},
    { SWIG_prefix "librdf_new_node_from_typed_literal", (swig_wrapper_func) _wrap_librdf_new_node_from_typed_literal, NULL},
    { SWIG_prefix "librdf_new_node_from_node", (swig_wrapper_func) _wrap_librdf_new_node_from_node, NULL},
    { SWIG_prefix "librdf_new_node_from_blank_identifier", (swig_wrapper_func) _wrap_librdf_new_node_from_blank_identifier, NULL},
    { SWIG_prefix "librdf_free_node", (swig_wrapper_func) _wrap_librdf_free_node, NULL},
    { SWIG_prefix "librdf_node_get_uri", (swig_wrapper_func) _wrap_librdf_node_get_uri, NULL},
    { SWIG_prefix "librdf_node_get_type", (swig_wrapper_func) _wrap_librdf_node_get_type, NULL},
    { SWIG_prefix "librdf_node_get_literal_value", (swig_wrapper_func) _wrap_librdf_node_get_literal_value, NULL},
    { SWIG_prefix "librdf_node_get_literal_value_as_latin1", (swig_wrapper_func) _wrap_librdf_node_get_literal_value_as_latin1, NULL},
    { SWIG_prefix "librdf_node_get_literal_value_language", (swig_wrapper_func) _wrap_librdf_node_get_literal_value_language, NULL},
    { SWIG_prefix "librdf_node_get_literal_value_datatype_uri", (swig_wrapper_func) _wrap_librdf_node_get_literal_value_datatype_uri, NULL},
    { SWIG_prefix "librdf_node_get_literal_value_is_wf_xml", (swig_wrapper_func) _wrap_librdf_node_get_literal_value_is_wf_xml, NULL},
    { SWIG_prefix "librdf_node_to_string", (swig_wrapper_func) _wrap_librdf_node_to_string, NULL},
    { SWIG_prefix "librdf_node_get_blank_identifier", (swig_wrapper_func) _wrap_librdf_node_get_blank_identifier, NULL},
    { SWIG_prefix "librdf_node_is_resource", (swig_wrapper_func) _wrap_librdf_node_is_resource, NULL},
    { SWIG_prefix "librdf_node_is_literal", (swig_wrapper_func) _wrap_librdf_node_is_literal, NULL},
    { SWIG_prefix "librdf_node_is_blank", (swig_wrapper_func) _wrap_librdf_node_is_blank, NULL},
    { SWIG_prefix "librdf_node_equals", (swig_wrapper_func) _wrap_librdf_node_equals, NULL},
    { SWIG_prefix "librdf_new_statement", (swig_wrapper_func) _wrap_librdf_new_statement, NULL},
    { SWIG_prefix "librdf_new_statement_from_statement", (swig_wrapper_func) _wrap_librdf_new_statement_from_statement, NULL},
    { SWIG_prefix "librdf_new_statement_from_nodes", (swig_wrapper_func) _wrap_librdf_new_statement_from_nodes, NULL},
    { SWIG_prefix "librdf_free_statement", (swig_wrapper_func) _wrap_librdf_free_statement, NULL},
    { SWIG_prefix "librdf_statement_get_subject", (swig_wrapper_func) _wrap_librdf_statement_get_subject, NULL},
    { SWIG_prefix "librdf_statement_set_subject", (swig_wrapper_func) _wrap_librdf_statement_set_subject, NULL},
    { SWIG_prefix "librdf_statement_get_predicate", (swig_wrapper_func) _wrap_librdf_statement_get_predicate, NULL},
    { SWIG_prefix "librdf_statement_set_predicate", (swig_wrapper_func) _wrap_librdf_statement_set_predicate, NULL},
    { SWIG_prefix "librdf_statement_get_object", (swig_wrapper_func) _wrap_librdf_statement_get_object, NULL},
    { SWIG_prefix "librdf_statement_set_object", (swig_wrapper_func) _wrap_librdf_statement_set_object, NULL},
    { SWIG_prefix "librdf_statement_to_string", (swig_wrapper_func) _wrap_librdf_statement_to_string, NULL},
    { SWIG_prefix "librdf_new_model", (swig_wrapper_func) _wrap_librdf_new_model, NULL},
    { SWIG_prefix "librdf_new_model_with_options", (swig_wrapper_func) _wrap_librdf_new_model_with_options, NULL},
    { SWIG_prefix "librdf_new_model_from_model", (swig_wrapper_func) _wrap_librdf_new_model_from_model, NULL},
    { SWIG_prefix "librdf_free_model", (swig_wrapper_func) _wrap_librdf_free_model, NULL},
    { SWIG_prefix "librdf_model_size", (swig_wrapper_func) _wrap_librdf_model_size, NULL},
    { SWIG_prefix "librdf_model_add", (swig_wrapper_func) _wrap_librdf_model_add, NULL},
    { SWIG_prefix "librdf_model_add_typed_literal_statement", (swig_wrapper_func) _wrap_librdf_model_add_typed_literal_statement, NULL},
    { SWIG_prefix "librdf_model_add_statement", (swig_wrapper_func) _wrap_librdf_model_add_statement, NULL},
    { SWIG_prefix "librdf_model_add_statements", (swig_wrapper_func) _wrap_librdf_model_add_statements, NULL},
    { SWIG_prefix "librdf_model_remove_statement", (swig_wrapper_func) _wrap_librdf_model_remove_statement, NULL},
    { SWIG_prefix "librdf_model_contains_statement", (swig_wrapper_func) _wrap_librdf_model_contains_statement, NULL},
    { SWIG_prefix "librdf_model_as_stream", (swig_wrapper_func) _wrap_librdf_model_as_stream, NULL},
    { SWIG_prefix "librdf_model_find_statements", (swig_wrapper_func) _wrap_librdf_model_find_statements, NULL},
    { SWIG_prefix "librdf_model_find_statements_in_context", (swig_wrapper_func) _wrap_librdf_model_find_statements_in_context, NULL},
    { SWIG_prefix "librdf_model_get_sources", (swig_wrapper_func) _wrap_librdf_model_get_sources, NULL},
    { SWIG_prefix "librdf_model_get_arcs", (swig_wrapper_func) _wrap_librdf_model_get_arcs, NULL},
    { SWIG_prefix "librdf_model_get_targets", (swig_wrapper_func) _wrap_librdf_model_get_targets, NULL},
    { SWIG_prefix "librdf_model_get_source", (swig_wrapper_func) _wrap_librdf_model_get_source, NULL},
    { SWIG_prefix "librdf_model_get_arc", (swig_wrapper_func) _wrap_librdf_model_get_arc, NULL},
    { SWIG_prefix "librdf_model_get_target", (swig_wrapper_func) _wrap_librdf_model_get_target, NULL},
    { SWIG_prefix "librdf_model_context_add_statement", (swig_wrapper_func) _wrap_librdf_model_context_add_statement, NULL},
    { SWIG_prefix "librdf_model_context_add_statements", (swig_wrapper_func) _wrap_librdf_model_context_add_statements, NULL},
    { SWIG_prefix "librdf_model_context_remove_statement", (swig_wrapper_func) _wrap_librdf_model_context_remove_statement, NULL},
    { SWIG_prefix "librdf_model_context_remove_statements", (swig_wrapper_func) _wrap_librdf_model_context_remove_statements, NULL},
    { SWIG_prefix "librdf_model_context_as_stream", (swig_wrapper_func) _wrap_librdf_model_context_as_stream, NULL},
    { SWIG_prefix "librdf_model_sync", (swig_wrapper_func) _wrap_librdf_model_sync, NULL},
    { SWIG_prefix "librdf_model_get_contexts", (swig_wrapper_func) _wrap_librdf_model_get_contexts, NULL},
    { SWIG_prefix "librdf_model_get_feature", (swig_wrapper_func) _wrap_librdf_model_get_feature, NULL},
    { SWIG_prefix "librdf_model_set_feature", (swig_wrapper_func) _wrap_librdf_model_set_feature, NULL},
    { SWIG_prefix "librdf_new_storage", (swig_wrapper_func) _wrap_librdf_new_storage, NULL},
    { SWIG_prefix "librdf_new_storage_from_storage", (swig_wrapper_func) _wrap_librdf_new_storage_from_storage, NULL},
    { SWIG_prefix "librdf_free_storage", (swig_wrapper_func) _wrap_librdf_free_storage, NULL},
    { SWIG_prefix "librdf_new_parser", (swig_wrapper_func) _wrap_librdf_new_parser, NULL},
    { SWIG_prefix "librdf_free_parser", (swig_wrapper_func) _wrap_librdf_free_parser, NULL},
    { SWIG_prefix "librdf_parser_parse_as_stream", (swig_wrapper_func) _wrap_librdf_parser_parse_as_stream, NULL},
    { SWIG_prefix "librdf_parser_parse_into_model", (swig_wrapper_func) _wrap_librdf_parser_parse_into_model, NULL},
    { SWIG_prefix "librdf_parser_parse_string_as_stream", (swig_wrapper_func) _wrap_librdf_parser_parse_string_as_stream, NULL},
    { SWIG_prefix "librdf_parser_parse_string_into_model", (swig_wrapper_func) _wrap_librdf_parser_parse_string_into_model, NULL},
    { SWIG_prefix "librdf_parser_get_feature", (swig_wrapper_func) _wrap_librdf_parser_get_feature, NULL},
    { SWIG_prefix "librdf_parser_set_feature", (swig_wrapper_func) _wrap_librdf_parser_set_feature, NULL},
    { SWIG_prefix "librdf_new_serializer", (swig_wrapper_func) _wrap_librdf_new_serializer, NULL},
    { SWIG_prefix "librdf_free_serializer", (swig_wrapper_func) _wrap_librdf_free_serializer, NULL},
    { SWIG_prefix "librdf_serializer_serialize_model_to_file", (swig_wrapper_func) _wrap_librdf_serializer_serialize_model_to_file, NULL},
    { SWIG_prefix "librdf_serializer_get_feature", (swig_wrapper_func) _wrap_librdf_serializer_get_feature, NULL},
    { SWIG_prefix "librdf_serializer_set_feature", (swig_wrapper_func) _wrap_librdf_serializer_set_feature, NULL},
    { SWIG_prefix "librdf_free_stream", (swig_wrapper_func) _wrap_librdf_free_stream, NULL},
    { SWIG_prefix "librdf_stream_end", (swig_wrapper_func) _wrap_librdf_stream_end, NULL},
    { SWIG_prefix "librdf_stream_next", (swig_wrapper_func) _wrap_librdf_stream_next, NULL},
    { SWIG_prefix "librdf_stream_get_object", (swig_wrapper_func) _wrap_librdf_stream_get_object, NULL},
    { SWIG_prefix "librdf_stream_get_context", (swig_wrapper_func) _wrap_librdf_stream_get_context, NULL},
    { SWIG_prefix "librdf_internal_test_error", (swig_wrapper_func) _wrap_librdf_internal_test_error, NULL},
    { SWIG_prefix "librdf_internal_test_warning", (swig_wrapper_func) _wrap_librdf_internal_test_warning, NULL},
    {0, 0, 0}
};

static swig_var_info swig_variables[] = {
    { SWIG_prefix "librdf_short_copyright_string", 0, (swig_variable_func) _wrap_librdf_short_copyright_string_get,(swig_variable_func) swig_readonly},
    { SWIG_prefix "librdf_copyright_string", 0, (swig_variable_func) _wrap_librdf_copyright_string_get,(swig_variable_func) swig_readonly},
    { SWIG_prefix "librdf_version_string", 0, (swig_variable_func) _wrap_librdf_version_string_get,(swig_variable_func) swig_readonly},
    { SWIG_prefix "librdf_version_major", 0, (swig_variable_func) _wrap_librdf_version_major_get,(swig_variable_func) swig_readonly},
    { SWIG_prefix "librdf_version_minor", 0, (swig_variable_func) _wrap_librdf_version_minor_get,(swig_variable_func) swig_readonly},
    { SWIG_prefix "librdf_version_release", 0, (swig_variable_func) _wrap_librdf_version_release_get,(swig_variable_func) swig_readonly},
    { SWIG_prefix "librdf_version_decimal", 0, (swig_variable_func) _wrap_librdf_version_decimal_get,(swig_variable_func) swig_readonly},
    {0,0,0,0}
};

static swig_const_info swig_constants[] = {
    {0,0,0,0,0,0}
};

/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (BEGIN) -------- */

static swig_type_info _swigt__p_librdf_node[] = {{"_p_librdf_node", 0, "librdf_node *", 0},{"_p_librdf_node"},{0}};
static swig_type_info _swigt__p_librdf_parser[] = {{"_p_librdf_parser", 0, "librdf_parser *", 0},{"_p_librdf_parser"},{0}};
static swig_type_info _swigt__p_librdf_world[] = {{"_p_librdf_world", 0, "librdf_world *", 0},{"_p_librdf_world"},{0}};
static swig_type_info _swigt__p_librdf_statement[] = {{"_p_librdf_statement", 0, "librdf_statement *", 0},{"_p_librdf_statement"},{0}};
static swig_type_info _swigt__p_librdf_hash[] = {{"_p_librdf_hash", 0, "librdf_hash *", 0},{"_p_librdf_hash"},{0}};
static swig_type_info _swigt__p_librdf_iterator[] = {{"_p_librdf_iterator", 0, "librdf_iterator *", 0},{"_p_librdf_iterator"},{0}};
static swig_type_info _swigt__p_librdf_storage[] = {{"_p_librdf_storage", 0, "librdf_storage *", 0},{"_p_librdf_storage"},{0}};
static swig_type_info _swigt__p_librdf_uri[] = {{"_p_librdf_uri", 0, "librdf_uri *", 0},{"_p_librdf_uri"},{0}};
static swig_type_info _swigt__p_librdf_model[] = {{"_p_librdf_model", 0, "librdf_model *", 0},{"_p_librdf_model"},{0}};
static swig_type_info _swigt__p_librdf_stream[] = {{"_p_librdf_stream", 0, "librdf_stream *", 0},{"_p_librdf_stream"},{0}};
static swig_type_info _swigt__p_librdf_serializer[] = {{"_p_librdf_serializer", 0, "librdf_serializer *", 0},{"_p_librdf_serializer"},{0}};

static swig_type_info *swig_types_initial[] = {
_swigt__p_librdf_node, 
_swigt__p_librdf_parser, 
_swigt__p_librdf_world, 
_swigt__p_librdf_statement, 
_swigt__p_librdf_hash, 
_swigt__p_librdf_iterator, 
_swigt__p_librdf_storage, 
_swigt__p_librdf_uri, 
_swigt__p_librdf_model, 
_swigt__p_librdf_stream, 
_swigt__p_librdf_serializer, 
0
};


/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (END) -------- */

#ifdef __cplusplus
}
#endif

SWIGEXPORT(int) SWIG_init(Tcl_Interp *interp) {
    int i;
    static int _init = 0;
    if (interp == 0) return TCL_ERROR;
    #ifdef USE_TCL_STUBS
    if (Tcl_InitStubs(interp, (char*)"8.1", 0) == NULL) {
        return TCL_ERROR;
    }
    #endif
    
    Tcl_PkgProvide(interp, (char*)SWIG_name, (char*)SWIG_version);
    
    #ifdef SWIG_namespace
    Tcl_Eval(interp, "namespace eval " SWIG_namespace " { }");
    #endif
    if (!_init) {
        for (i = 0; swig_types_initial[i]; i++) {
            swig_types[i] = SWIG_TypeRegister(swig_types_initial[i]);
        }
        _init = 1;
    }
    for (i = 0; swig_commands[i].name; i++) {
        Tcl_CreateObjCommand(interp, (char *) swig_commands[i].name, (swig_wrapper_func) swig_commands[i].wrapper, swig_commands[i].clientdata, NULL);
    }
    for (i = 0; swig_variables[i].name; i++) {
        Tcl_SetVar(interp, (char *) swig_variables[i].name, (char *) "", TCL_GLOBAL_ONLY);
        Tcl_TraceVar(interp, (char *) swig_variables[i].name, TCL_TRACE_READS | TCL_GLOBAL_ONLY, (Tcl_VarTraceProc *) swig_variables[i].get, (ClientData) swig_variables[i].addr);
        Tcl_TraceVar(interp, (char *) swig_variables[i].name, TCL_TRACE_WRITES | TCL_GLOBAL_ONLY, (Tcl_VarTraceProc *) swig_variables[i].set, (ClientData) swig_variables[i].addr);
    }
    SWIG_InstallConstants(interp, swig_constants);
    
    
    #ifdef TCL_MAJOR_VERSION
    Tcl_PkgProvide(interp, PACKAGE, (char*)librdf_version_string);
    #endif
    
    #ifdef PHP_VERSION
    /* PHP seems happier if this happens at module init time */
    if(!librdf_php_world) {
        librdf_php_world=librdf_new_world();
        librdf_world_open(librdf_php_world);
    }
    #endif
    
    return TCL_OK;
}

