# Makefile for Apple MPW build environment (currently PPC only)

MAKEFILE     = Makefile
MondoBuild = #{MAKEFILE}  # Make blank to avoid rebuilds when makefile is modified
SymPPC      = #-sym on
ObjDirPPC   = :obj:

CFLAGS  = -i :include -i :src -includes unix {SymPPC}

OBJS  = 
		"{ObjDirPPC}ftsystem.c.x" 
		"{ObjDirPPC}ftdebug.c.x" 
		"{ObjDirPPC}ftinit.c.x" 
		"{ObjDirPPC}ftbase.c.x" 
		"{ObjDirPPC}ftglyph.c.x" 
		"{ObjDirPPC}ftmm.c.x" 
		"{ObjDirPPC}ftbbox.c.x" 
		"{ObjDirPPC}autohint.c.x" 
		"{ObjDirPPC}ftcache.c.x" 
		"{ObjDirPPC}cff.c.x" 
		"{ObjDirPPC}type1cid.c.x" 
		"{ObjDirPPC}pcf.c.x" 
		"{ObjDirPPC}psaux.c.x" 
		"{ObjDirPPC}psmodule.c.x" 
		"{ObjDirPPC}raster.c.x" 
		"{ObjDirPPC}sfnt.c.x" 
		"{ObjDirPPC}smooth.c.x" 
		"{ObjDirPPC}truetype.c.x" 
		"{ObjDirPPC}type1.c.x" 
		"{ObjDirPPC}winfnt.c.x" 
		"{ObjDirPPC}ftmac.c.x" 

# Main target - build a library
freetype  {MondoBuild} directories freetype.o

# This is used to build the library
freetype.o  {MondoBuild} {OBJS}
	PPCLink 
		-o :lib:{Targ} {SymPPC} 
		{OBJS} -c '????' -xm l

# This is used to create the directories needed for build
directories 
	if !`Exists obj` ; NewFolder obj ; end
	if !`Exists lib` ; NewFolder lib ; end


"{ObjDirPPC}ftsystem.c.x"  {MondoBuild} ":src:base:ftsystem.c"
	{PPCC} ":src:base:ftsystem.c" -o {Targ} {CFLAGS}

"{ObjDirPPC}ftdebug.c.x"  {MondoBuild} ":src:base:ftdebug.c"
	{PPCC} ":src:base:ftdebug.c" -o {Targ} {CFLAGS}

"{ObjDirPPC}ftinit.c.x"  {MondoBuild} ":src:base:ftinit.c"
	{PPCC} ":src:base:ftinit.c" -o {Targ} {CFLAGS}

"{ObjDirPPC}ftbase.c.x"  {MondoBuild} ":src:base:ftbase.c"
	{PPCC} ":src:base:ftbase.c" -o {Targ} {CFLAGS}

"{ObjDirPPC}ftglyph.c.x"  {MondoBuild} ":src:base:ftglyph.c"
	{PPCC} ":src:base:ftglyph.c" -o {Targ} {CFLAGS}

"{ObjDirPPC}ftmm.c.x"  {MondoBuild} ":src:base:ftmm.c"
	{PPCC} ":src:base:ftmm.c" -o {Targ} {CFLAGS}

"{ObjDirPPC}ftbbox.c.x"  {MondoBuild} ":src:base:ftbbox.c"
	{PPCC} ":src:base:ftbbox.c" -o {Targ} {CFLAGS}

"{ObjDirPPC}autohint.c.x"  {MondoBuild} ":src:autohint:autohint.c"
	{PPCC} ":src:autohint:autohint.c" -o {Targ} {CFLAGS}

"{ObjDirPPC}ftcache.c.x"  {MondoBuild} ":src:cache:ftcache.c"
	{PPCC} ":src:cache:ftcache.c" -o {Targ} {CFLAGS}

"{ObjDirPPC}cff.c.x"  {MondoBuild} ":src:cff:cff.c"
	{PPCC} ":src:cff:cff.c" -o {Targ} {CFLAGS}

"{ObjDirPPC}type1cid.c.x"  {MondoBuild} ":src:cid:type1cid.c"
	{PPCC} ":src:cid:type1cid.c" -o {Targ} {CFLAGS}

"{ObjDirPPC}pcf.c.x"  {MondoBuild} ":src:pcf:pcf.c"
	{PPCC} ":src:pcf:pcf.c" -o {Targ} {CFLAGS}

"{ObjDirPPC}psaux.c.x"  {MondoBuild} ":src:psaux:psaux.c"
	{PPCC} ":src:psaux:psaux.c" -o {Targ} {CFLAGS}

"{ObjDirPPC}psmodule.c.x"  {MondoBuild} ":src:psnames:psmodule.c"
	{PPCC} ":src:psnames:psmodule.c" -o {Targ} {CFLAGS}

"{ObjDirPPC}raster.c.x"  {MondoBuild} ":src:raster:raster.c"
	{PPCC} ":src:raster:raster.c" -o {Targ} {CFLAGS}

"{ObjDirPPC}sfnt.c.x"  {MondoBuild} ":src:sfnt:sfnt.c"
	{PPCC} ":src:sfnt:sfnt.c" -o {Targ} {CFLAGS}

"{ObjDirPPC}smooth.c.x"  {MondoBuild} ":src:smooth:smooth.c"
	{PPCC} ":src:smooth:smooth.c" -o {Targ} {CFLAGS}

"{ObjDirPPC}truetype.c.x"  {MondoBuild} ":src:truetype:truetype.c"
	{PPCC} ":src:truetype:truetype.c" -o {Targ} {CFLAGS}

"{ObjDirPPC}type1.c.x"  {MondoBuild} ":src:type1:type1.c"
	{PPCC} ":src:type1:type1.c" -o {Targ} {CFLAGS}

"{ObjDirPPC}winfnt.c.x"  {MondoBuild} ":src:winfonts:winfnt.c"
	{PPCC} ":src:winfonts:winfnt.c" -o {Targ} {CFLAGS}

"{ObjDirPPC}ftmac.c.x"  {MondoBuild} ":src:base:ftmac.c"
	{PPCC} ":src:base:ftmac.c" -o {Targ} {CFLAGS}