
#ifdef _SVG
/* mapping table of SVG elements */
#include "SVG.h"
static ElemMapping    SVGElemMappingTable[] =
{
   /* This table MUST be in alphabetical order  and in lower case */
   {"a", SPACE, SVG_EL_a, L_OtherValue, FALSE},
   {"altGlyph", SPACE, SVG_EL_altGlyph, L_OtherValue, FALSE},
   {"altGlyphDef", SPACE, SVG_EL_altGlyphDef, L_OtherValue, FALSE},
   {"altGlyphItem", SPACE, SVG_EL_altGlyphItem, L_OtherValue, FALSE},
   {"animate", SPACE, SVG_EL_animate, L_OtherValue, FALSE},
   {"animateColor", SPACE, SVG_EL_animateColor, L_OtherValue, FALSE},
   {"animateMotion", SPACE, SVG_EL_animateMotion, L_OtherValue, FALSE},
   {"animateTransform", SPACE, SVG_EL_animateTransform, L_OtherValue, FALSE},
   {"c", SPACE, SVG_EL_TEXT_UNIT, L_OtherValue, TRUE},
   {"cdata", SPACE, SVG_EL_CDATA, L_OtherValue, FALSE},
   {"cdata_line", SPACE, SVG_EL_CDATA_line, L_OtherValue, FALSE},
   {"circle", SPACE, SVG_EL_circle_, L_OtherValue, FALSE},
   {"clipPath", SPACE, SVG_EL_clipPath, L_OtherValue, FALSE},
   {"color-profile", SPACE, SVG_EL_color_profile, L_OtherValue, FALSE},
   {"cursor", SPACE, SVG_EL_cursor, L_OtherValue, FALSE},
   {"definition-src", SPACE, SVG_EL_definition_src, L_OtherValue, TRUE},
   {"defs", SPACE, SVG_EL_defs, L_OtherValue, FALSE},
   {"desc", SPACE, SVG_EL_desc, L_OtherValue, FALSE},
   {"doctype", SPACE, SVG_EL_DOCTYPE, L_OtherValue, FALSE},
   {"doctype_line", SPACE, SVG_EL_DOCTYPE_line, L_OtherValue, FALSE},
   {"ellipse", SPACE, SVG_EL_ellipse, L_OtherValue, FALSE},
   {"feBlend", SPACE, SVG_EL_feBlend, L_OtherValue, FALSE},
   {"feColorMatrix", SPACE, SVG_EL_feColorMatrix, L_OtherValue, FALSE},
   {"feComponentTransfer", SPACE, SVG_EL_feComponentTransfer, L_OtherValue, FALSE},
   {"feComposite", SPACE, SVG_EL_feComposite, L_OtherValue, FALSE},
   {"feConvolveMatrix", SPACE, SVG_EL_feConvolveMatrix, L_OtherValue, FALSE},
   {"feDiffuseLighting", SPACE, SVG_EL_feDiffuseLighting, L_OtherValue, FALSE},
   {"feDisplacementMap", SPACE, SVG_EL_feDisplacementMap, L_OtherValue, FALSE},
   {"feDistantLight", SPACE, SVG_EL_feDistantLight, L_OtherValue, FALSE},
   {"feFlood", SPACE, SVG_EL_feFlood, L_OtherValue, FALSE},
   {"feFuncA", SPACE, SVG_EL_feFuncA, L_OtherValue, FALSE},
   {"feFuncB", SPACE, SVG_EL_feFuncB, L_OtherValue, FALSE},
   {"feFuncG", SPACE, SVG_EL_feFuncG, L_OtherValue, FALSE},
   {"feFuncR", SPACE, SVG_EL_feFuncR, L_OtherValue, FALSE},
   {"feGaussianBlur", SPACE, SVG_EL_feGaussianBlur, L_OtherValue, FALSE},
   {"feImage", SPACE, SVG_EL_feImage, L_OtherValue, FALSE},
   {"feMerge", SPACE, SVG_EL_feMerge, L_OtherValue, FALSE},
   {"feMergeNode", SPACE, SVG_EL_feMergeNode, L_OtherValue, FALSE},
   {"feMorphology", SPACE, SVG_EL_feMorphology, L_OtherValue, FALSE},
   {"feOffset", SPACE, SVG_EL_feOffset, L_OtherValue, FALSE},
   {"fePointLight", SPACE, SVG_EL_fePointLight, L_OtherValue, FALSE},
   {"feSpecularLighting", SPACE, SVG_EL_feSpecularLighting, L_OtherValue, FALSE},
   {"feSpotLight", SPACE, SVG_EL_feSpotLight, L_OtherValue, FALSE},
   {"feTile", SPACE, SVG_EL_feTile, L_OtherValue, FALSE},
   {"feTurbulence", SPACE, SVG_EL_feTurbulence, L_OtherValue, FALSE},
   {"filter", SPACE, SVG_EL_filter, L_OtherValue, FALSE},
   {"font", SPACE, SVG_EL_font_, L_OtherValue, FALSE},
   {"font-face", SPACE, SVG_EL_font_face, L_OtherValue, FALSE},
   {"font-face-format", SPACE, SVG_EL_font_face_format, L_OtherValue, FALSE},
   {"font-face-name", SPACE, SVG_EL_font_face_name, L_OtherValue, FALSE},
   {"font-face-src", SPACE, SVG_EL_font_face_src, L_OtherValue, FALSE},
   {"font-face-uri", SPACE, SVG_EL_font_face_uri, L_OtherValue, FALSE},
   {"foreignObject", SPACE, SVG_EL_foreignObject, L_OtherValue, FALSE},
   {"g", SPACE, SVG_EL_g, L_OtherValue, FALSE},
   {"glyph", SPACE, SVG_EL_glyph, L_OtherValue, FALSE},
   {"glyphRef", SPACE, SVG_EL_glyphRef, L_OtherValue, FALSE},
   {"hkern", SPACE, SVG_EL_hkern, L_OtherValue, FALSE},
   {"image", SPACE, SVG_EL_image, L_OtherValue, FALSE},
   {"line", SPACE, SVG_EL_line_, L_OtherValue, FALSE},
   {"linearGradient", SPACE, SVG_EL_linearGradient, L_OtherValue, FALSE},
   {"marker", SPACE, SVG_EL_marker, L_OtherValue, FALSE},
   {"mask", SPACE, SVG_EL_mask, L_OtherValue, FALSE},
   {"metadata", SPACE, SVG_EL_metadata, L_OtherValue, FALSE},
   {"missing-glyph", SPACE, SVG_EL_missing_glyph, L_OtherValue, FALSE},
   {"mpath", SPACE, SVG_EL_mpath, L_OtherValue, FALSE},
   {"path", SPACE, SVG_EL_path, L_OtherValue, FALSE},
   {"pattern", SPACE, SVG_EL_pattern, L_OtherValue, FALSE},
   {"polygon", SPACE, SVG_EL_polygon, L_OtherValue, FALSE},
   {"polyline", SPACE, SVG_EL_polyline, L_OtherValue, FALSE},
   {"rect", SPACE, SVG_EL_rect, L_OtherValue, FALSE},
   {"radialGradient", SPACE, SVG_EL_radialGradient, L_OtherValue, FALSE},
   {"script", SPACE, SVG_EL_script_, L_OtherValue, FALSE},
   {"set", SPACE, SVG_EL_set_, L_OtherValue, FALSE},
   {"stop", SPACE, SVG_EL_stop, L_OtherValue, FALSE},
   {"style", SPACE, SVG_EL_style__, L_OtherValue, FALSE},
   {"svg", SPACE, SVG_EL_SVG, L_OtherValue, FALSE},
   {"switch", SPACE, SVG_EL_switch, L_OtherValue, FALSE},
   {"symbol", SPACE, SVG_EL_symbol_, L_OtherValue, FALSE},
   {"text", SPACE, SVG_EL_text_, L_OtherValue, FALSE},
   {"textPath", SPACE, SVG_EL_textPath, L_OtherValue, FALSE},
   {"title", SPACE, SVG_EL_title, L_OtherValue, FALSE},
   {"tref", SPACE, SVG_EL_tref, L_OtherValue, TRUE},
   {"tspan", SPACE, SVG_EL_tspan, L_OtherValue, TRUE},
   {"use", SPACE, SVG_EL_use_, L_OtherValue, FALSE},
   {"view", SPACE, SVG_EL_view, L_OtherValue, FALSE},
   {"vkern", SPACE, SVG_EL_vkern, L_OtherValue, FALSE},
   {"xmlcomment", SPACE, SVG_EL_XMLcomment, L_OtherValue, FALSE},
   {"xmlcomment_line", SPACE, SVG_EL_XMLcomment_line, L_OtherValue, FALSE},
   {"xmlpi", SPACE, SVG_EL_XMLPI, L_OtherValue, FALSE},
   {"xmlpi_line", SPACE, SVG_EL_XMLPI_line, L_OtherValue, FALSE},
   {"", SPACE, 0, L_OtherValue, FALSE} 	/* Last entry. Mandatory */
};

static AttributeMapping SVGAttributeMappingTable[] =
{
   /* The first entry MUST be unknown_attr */
   /* The rest of this table MUST be in alphabetical order */
   {"unknown_attr", "", 'A', SVG_ATTR_Unknown_attribute, L_OtherValue},

   {"accent-height", "", 'A', SVG_ATTR_accent_height, L_OtherValue},
   {"accumulate", "", 'A', SVG_ATTR_accumulate, L_OtherValue},
   {"additive", "", 'A', SVG_ATTR_additive, L_OtherValue},
   {"alignment-baseline", "", 'A', SVG_ATTR_alignment_baseline, L_OtherValue},
   {"alphabetic", "", 'A', SVG_ATTR_alphabetic, L_OtherValue},
   {"amplitude", "", 'A', SVG_ATTR_amplitude, L_OtherValue},
   {"arabic-form", "", 'A', SVG_ATTR_arabic_form, L_OtherValue},
   {"ascent", "", 'A', SVG_ATTR_ascent, L_OtherValue},
   {"attributeName", "", 'A', SVG_ATTR_attributeName_, L_OtherValue},
   {"attributeType", "", 'A', SVG_ATTR_attributeType, L_OtherValue},
   {"azimuth", "", 'A', SVG_ATTR_azimuth, L_OtherValue},
   {"baseFrequency", "", 'A', SVG_ATTR_baseFrequency, L_OtherValue},
   {"baseProfile", "", 'A', SVG_ATTR_baseProfile, L_OtherValue},
   {"baseline-shift", "", 'A', SVG_ATTR_baseline_shift, L_OtherValue},
   {"bbox", "", 'A', SVG_ATTR_bbox, L_OtherValue},
   {"begin", "", 'A', SVG_ATTR_begin_, L_OtherValue},
   {"bias", "", 'A', SVG_ATTR_bias, L_OtherValue},
   {"by", "", 'A', SVG_ATTR_by, L_OtherValue},
   {"calcMode", "", 'A', SVG_ATTR_calcMode, L_OtherValue},
   {"cap-height", "", 'A', SVG_ATTR_cap_height, L_OtherValue},
   {"class", "", 'A', SVG_ATTR_class, L_OtherValue},
   {"clip", "", 'A', SVG_ATTR_clip, L_OtherValue},
   {"clip-path", "", 'A', SVG_ATTR_clip_path, L_OtherValue},
   {"clip-rule", "", 'A', SVG_ATTR_clip_rule, L_OtherValue},
   {"clipPathUnits", "", 'A', SVG_ATTR_clipPathUnits, L_OtherValue},
   {"color", "", 'A', SVG_ATTR_color, L_OtherValue},
   {"color-interpolation", "", 'A', SVG_ATTR_color_interpolation, L_OtherValue},
   {"color-interpolation-filters", "", 'A', SVG_ATTR_color_interpolation_filters, L_OtherValue},
   {"color-profile", "", 'A', SVG_ATTR_color_profile_, L_OtherValue},
   {"color-rendering", "", 'A', SVG_ATTR_color_rendering, L_OtherValue},
   {"content", "", 'A', SVG_ATTR_content_, L_OtherValue},
   {"contentScriptType", "", 'A', SVG_ATTR_contentScriptType, L_OtherValue},
   {"contentStyleType", "", 'A', SVG_ATTR_contentStyleType, L_OtherValue},
   {"cursor", "", 'A', SVG_ATTR_cursor_, L_OtherValue},
   {"cx", "", 'A', SVG_ATTR_cx, L_OtherValue},
   {"cy", "", 'A', SVG_ATTR_cy, L_OtherValue},
   {"d", "", 'A', SVG_ATTR_d, L_OtherValue},
   {"descent", "", 'A', SVG_ATTR_descent, L_OtherValue},
   {"diffuseConstant", "", 'A', SVG_ATTR_diffuseConstant, L_OtherValue},
   {"direction", "", 'A', SVG_ATTR_direction_, L_OtherValue},
   {"display", "", 'A', SVG_ATTR_display_, L_OtherValue},
   {"divisor", "", 'A', SVG_ATTR_divisor, L_OtherValue},
   {"dominant-baseline", "", 'A', SVG_ATTR_dominant_baseline, L_OtherValue},
   {"dur", "", 'A', SVG_ATTR_dur, L_OtherValue},
   {"dx", "", 'A', SVG_ATTR_dx, L_OtherValue},
   {"dy", "", 'A', SVG_ATTR_dy, L_OtherValue},
   {"edgeMode", "", 'A', SVG_ATTR_edgeMode, L_OtherValue},
   {"elevation", "", 'A', SVG_ATTR_elevation, L_OtherValue},
   {"enable-background", "", 'A', SVG_ATTR_enable_background, L_OtherValue},
   {"end", "", 'A', SVG_ATTR_end_, L_OtherValue},
   {"exponent", "", 'A', SVG_ATTR_exponent, L_OtherValue},
   {"externalResourcesRequired", "", 'A', SVG_ATTR_externalResourcesRequired, L_OtherValue},
   {"fill", "animate", 'A', SVG_ATTR_fill_, L_OtherValue},
   {"fill", "animateColor", 'A', SVG_ATTR_fill_, L_OtherValue},
   {"fill", "animateMotion", 'A', SVG_ATTR_fill_, L_OtherValue},
   {"fill", "animateTransform", 'A', SVG_ATTR_fill_, L_OtherValue},
   {"fill", "set", 'A', SVG_ATTR_fill_, L_OtherValue},
   {"fill", "", 'A', SVG_ATTR_fill, L_OtherValue},
   {"fill-opacity", "", 'A', SVG_ATTR_fill_opacity, L_OtherValue},
   {"fill-rule", "", 'A', SVG_ATTR_fill_rule, L_OtherValue},
   {"filter", "", 'A', SVG_ATTR_filter_, L_OtherValue},
   {"filterRes", "", 'A', SVG_ATTR_filterRes, L_OtherValue},
   {"filterUnits", "", 'A', SVG_ATTR_filterUnits, L_OtherValue},
   {"flood-color", "", 'A', SVG_ATTR_flood_color, L_OtherValue},
   {"flood-opacity", "", 'A', SVG_ATTR_flood_opacity, L_OtherValue},
   {"font-family", "", 'A', SVG_ATTR_font_family, L_OtherValue},
   {"font-size", "", 'A', SVG_ATTR_font_size, L_OtherValue},
   {"font-size-adjust", "", 'A', SVG_ATTR_font_size_adjust, L_OtherValue},
   {"font-stretch", "", 'A', SVG_ATTR_font_stretch, L_OtherValue},
   {"font-style", "", 'A', SVG_ATTR_font_style, L_OtherValue},
   {"font-variant", "", 'A', SVG_ATTR_font_variant, L_OtherValue},
   {"font-weight", "", 'A', SVG_ATTR_font_weight, L_OtherValue},
   {"format", "", 'A', SVG_ATTR_format, L_OtherValue},
   {"from", "", 'A', SVG_ATTR_from, L_OtherValue},
   {"fx", "", 'A', SVG_ATTR_fx, L_OtherValue},
   {"fy", "", 'A', SVG_ATTR_fy, L_OtherValue},
   {"g1", "", 'A', SVG_ATTR_g1, L_OtherValue},
   {"g2", "", 'A', SVG_ATTR_g2, L_OtherValue},
   {"glyph-name", "", 'A', SVG_ATTR_glyph_name, L_OtherValue},
   {"glyph-orientation-horizontal", "", 'A', SVG_ATTR_glyph_orientation_horizontal, L_OtherValue},
   {"glyph-orientation-vertical", "", 'A', SVG_ATTR_glyph_orientation_vertical, L_OtherValue},
   {"glyphRef", "", 'A', SVG_ATTR_glyphRef_, L_OtherValue},
   {"gradientTransform", "", 'A', SVG_ATTR_gradientTransform, L_OtherValue},
   {"gradientUnits", "", 'A', SVG_ATTR_gradientUnits, L_OtherValue},
   {"hanging", "", 'A', SVG_ATTR_hanging, L_OtherValue},
   {"height", "", 'A', SVG_ATTR_height_, L_OtherValue},
   {"horiz-adv-x", "", 'A', SVG_ATTR_horiz_adv_x, L_OtherValue},
   {"horiz-origin-x", "", 'A', SVG_ATTR_horiz_origin_x, L_OtherValue},
   {"horiz-origin-y", "", 'A', SVG_ATTR_horiz_origin_y, L_OtherValue},
   {"id", "", 'A', SVG_ATTR_id, L_OtherValue},
   {"ideographic", "", 'A', SVG_ATTR_ideographic, L_OtherValue},
   {"image-rendering", "", 'A', SVG_ATTR_image_rendering, L_OtherValue},
   {"in", "", 'A', SVG_ATTR_in_, L_OtherValue},
   {"in2", "", 'A', SVG_ATTR_in2, L_OtherValue},
   {"intercept", "", 'A', SVG_ATTR_intercept, L_OtherValue},
   {"k", "", 'A', SVG_ATTR_k, L_OtherValue},
   {"k1", "", 'A', SVG_ATTR_k1, L_OtherValue},
   {"k2", "", 'A', SVG_ATTR_k2, L_OtherValue},
   {"k3", "", 'A', SVG_ATTR_k3, L_OtherValue},
   {"k4", "", 'A', SVG_ATTR_k4, L_OtherValue},
   {"kernelMatrix", "", 'A', SVG_ATTR_kernelMatrix, L_OtherValue},
   {"kernelUnitLength", "", 'A', SVG_ATTR_kernelUnitLength, L_OtherValue},
   {"kerning", "", 'A', SVG_ATTR_kerning, L_OtherValue},
   {"keyPoints", "", 'A', SVG_ATTR_keyPoints, L_OtherValue},
   {"keySplines", "", 'A', SVG_ATTR_keySplines, L_OtherValue},
   {"keyTimes", "", 'A', SVG_ATTR_keyTimes, L_OtherValue},
   {"lang", "glyph", 'A', SVG_ATTR_lang, L_OtherValue},
   {"lang", "", 'A', SVG_ATTR_Language, L_OtherValue},
   {"lengthAdjust", "", 'A', SVG_ATTR_lengthAdjust, L_OtherValue},
   {"letter-spacing", "", 'A', SVG_ATTR_letter_spacing, L_OtherValue},
   {"lighting-color", "", 'A', SVG_ATTR_lighting_color, L_OtherValue},
   {"limitingConeAngle", "", 'A', SVG_ATTR_limitingConeAngle, L_OtherValue},
   {"local", "", 'A', SVG_ATTR_local, L_OtherValue},
   {"marker-end", "", 'A', SVG_ATTR_marker_end, L_OtherValue},
   {"marker-mid", "", 'A', SVG_ATTR_marker_mid, L_OtherValue},
   {"marker-start", "", 'A', SVG_ATTR_marker_start, L_OtherValue},
   {"markerHeight", "", 'A', SVG_ATTR_markerHeight, L_OtherValue},
   {"markerUnits", "", 'A', SVG_ATTR_markerUnits, L_OtherValue},
   {"markerWidth", "", 'A', SVG_ATTR_markerWidth, L_OtherValue},
   {"mask", "", 'A', SVG_ATTR_mask_, L_OtherValue},
   {"maskContentUnits", "", 'A', SVG_ATTR_maskContentUnits, L_OtherValue},
   {"maskUnits", "", 'A', SVG_ATTR_maskUnits, L_OtherValue},
   {"mathematical", "", 'A', SVG_ATTR_mathematical, L_OtherValue},
   {"max", "", 'A', SVG_ATTR_max_, L_OtherValue},
   {"media", "", 'A', SVG_ATTR_media, L_OtherValue},
   {"method", "", 'A', SVG_ATTR_method, L_OtherValue},
   {"min", "", 'A', SVG_ATTR_min_, L_OtherValue},
   {"mode", "", 'A', SVG_ATTR_mode, L_OtherValue},
   {"name", "", 'A', SVG_ATTR_name, L_OtherValue},
   {"numOctaves", "", 'A', SVG_ATTR_numOctaves, L_OtherValue},
   {"offset", "stop", 'A', SVG_ATTR_offset, L_OtherValue},
   {"offset", "", 'A', SVG_ATTR_offset_, L_OtherValue},
   {"onabort", "", 'A', SVG_ATTR_onabort, L_OtherValue},
   {"onactivate", "", 'A', SVG_ATTR_onactivate, L_OtherValue},
   {"onbegin", "", 'A', SVG_ATTR_onbegin, L_OtherValue},
   {"onclick", "", 'A', SVG_ATTR_onclick, L_OtherValue},
   {"onend", "", 'A', SVG_ATTR_onend, L_OtherValue},
   {"onerror", "", 'A', SVG_ATTR_onerror, L_OtherValue},
   {"onfocusin", "", 'A', SVG_ATTR_onfocusin, L_OtherValue},
   {"onfocusout", "", 'A', SVG_ATTR_onfocusout, L_OtherValue},
   {"onload", "", 'A', SVG_ATTR_onload, L_OtherValue},
   {"onmousedown", "", 'A', SVG_ATTR_onmousedown, L_OtherValue},
   {"onmousemove", "", 'A', SVG_ATTR_onmousemove, L_OtherValue},
   {"onmouseout", "", 'A', SVG_ATTR_onmouseout, L_OtherValue},
   {"onmouseover", "", 'A', SVG_ATTR_onmouseover, L_OtherValue},
   {"onmouseup", "", 'A', SVG_ATTR_onmouseup, L_OtherValue},
   {"onrepeat", "", 'A', SVG_ATTR_onrepeat, L_OtherValue},
   {"onresize", "", 'A', SVG_ATTR_onresize, L_OtherValue},
   {"onscroll", "", 'A', SVG_ATTR_onscroll, L_OtherValue},
   {"onunload", "", 'A', SVG_ATTR_onunload, L_OtherValue},
   {"onzoom", "", 'A', SVG_ATTR_onzoom, L_OtherValue},
   {"opacity", "", 'A', SVG_ATTR_opacity_, L_OtherValue},
   {"operator", "feComposite", 'A', SVG_ATTR_operator, L_OtherValue},
   {"operator", "feMorphology", 'A', SVG_ATTR_operator_, L_OtherValue},
   {"order", "", 'A', SVG_ATTR_order, L_OtherValue},
   {"orient", "", 'A', SVG_ATTR_orient, L_OtherValue},
   {"orientation", "", 'A', SVG_ATTR_orientation, L_OtherValue},
   {"origin", "", 'A', SVG_ATTR_origin, L_OtherValue},
   {"overflow", "", 'A', SVG_ATTR_overflow, L_OtherValue},
   {"overline-position", "", 'A', SVG_ATTR_overline_position, L_OtherValue},
   {"overline-thickness", "", 'A', SVG_ATTR_overline_thickness, L_OtherValue},
   {"panose-1", "", 'A', SVG_ATTR_panose_1, L_OtherValue},
   {"path", "", 'A', SVG_ATTR_path_, L_OtherValue},
   {"patternContentUnits", "", 'A', SVG_ATTR_patternContentUnits, L_OtherValue},
   {"patternTransform", "", 'A', SVG_ATTR_patternTransform, L_OtherValue},
   {"patternUnits", "", 'A', SVG_ATTR_patternUnits, L_OtherValue},
   {"pathLength", "", 'A', SVG_ATTR_pathLength, L_OtherValue},
   {"pointer-events", "", 'A', SVG_ATTR_pointer_events, L_OtherValue},
   {"points", "", 'A', SVG_ATTR_points, L_OtherValue},
   {"pointsAtX", "", 'A', SVG_ATTR_pointsAtX, L_OtherValue},
   {"pointsAtY", "", 'A', SVG_ATTR_pointsAtY, L_OtherValue},
   {"pointsAtZ", "", 'A', SVG_ATTR_pointsAtZ, L_OtherValue},
   {"preserveAlpha", "", 'A', SVG_ATTR_preserveAlpha, L_OtherValue},
   {"preserveAspectRatio", "", 'A', SVG_ATTR_preserveAspectRatio, L_OtherValue},
   {"primitiveUnits", "", 'A', SVG_ATTR_primitiveUnits, L_OtherValue},
   {"r", "", 'A', SVG_ATTR_r, L_OtherValue},
   {"radius", "", 'A', SVG_ATTR_radius, L_OtherValue},
   {"refX", "", 'A', SVG_ATTR_refX, L_OtherValue},
   {"refY", "", 'A', SVG_ATTR_refY, L_OtherValue},
   {"rendering-intent", "", 'A', SVG_ATTR_rendering_intent, L_OtherValue},
   {"repeatCount", "", 'A', SVG_ATTR_repeatCount, L_OtherValue},
   {"repeatDur", "", 'A', SVG_ATTR_repeatDur, L_OtherValue},
   {"requiredExtensions", "", 'A', SVG_ATTR_requiredExtensions, L_OtherValue},
   {"requiredFeatures", "", 'A', SVG_ATTR_requiredFeatures, L_OtherValue},
   {"restart", "", 'A', SVG_ATTR_restart, L_OtherValue},
   {"result", "", 'A', SVG_ATTR_result, L_OtherValue},
   {"rotate", "", 'A', SVG_ATTR_rotate, L_OtherValue},
   {"rx", "", 'A', SVG_ATTR_rx, L_OtherValue},
   {"ry", "", 'A', SVG_ATTR_ry, L_OtherValue},
   {"scale", "", 'A', SVG_ATTR_scale_, L_OtherValue},
   {"seed", "", 'A', SVG_ATTR_seed, L_OtherValue},
   {"shape-rendering", "", 'A', SVG_ATTR_shape_rendering, L_OtherValue},
   {"slope", "font-face", 'A', SVG_ATTR_slope, L_OtherValue},
   {"slope", "", 'A', SVG_ATTR_slope_, L_OtherValue},
   {"spacing", "", 'A', SVG_ATTR_spacing, L_OtherValue},
   {"specularConstant", "", 'A', SVG_ATTR_specularConstant, L_OtherValue},
   {"specularExponent", "", 'A', SVG_ATTR_specularExponent, L_OtherValue},
   {"spreadMethod", "", 'A', SVG_ATTR_spreadMethod, L_OtherValue},
   {"startOffset", "", 'A', SVG_ATTR_startOffset, L_OtherValue},
   {"stdDeviation", "", 'A', SVG_ATTR_stdDeviation, L_OtherValue},
   {"stemh", "", 'A', SVG_ATTR_stemh, L_OtherValue},
   {"stemv", "", 'A', SVG_ATTR_stemv, L_OtherValue},
   {"stitchTiles", "", 'A', SVG_ATTR_stitchTiles, L_OtherValue},
   {"stop-color", "", 'A', SVG_ATTR_stop_color, L_OtherValue},
   {"stop-opacity", "", 'A', SVG_ATTR_stop_opacity, L_OtherValue},
   {"strikethrough-position", "", 'A', SVG_ATTR_strikethrough_position, L_OtherValue},
   {"strikethrough-thickness", "", 'A', SVG_ATTR_strikethrough_thickness, L_OtherValue},
   {"string", "", 'A', SVG_ATTR_string, L_OtherValue},
   {"stroke", "", 'A', SVG_ATTR_stroke, L_OtherValue},
   {"stroke-dasharray", "", 'A', SVG_ATTR_stroke_dasharray, L_OtherValue},
   {"stroke-dashoffset", "", 'A', SVG_ATTR_stroke_dashoffset, L_OtherValue},
   {"stroke-linecap", "", 'A', SVG_ATTR_stroke_linecap, L_OtherValue},
   {"stroke-linejoin", "", 'A', SVG_ATTR_stroke_linejoin, L_OtherValue},
   {"stroke-miterlimit", "", 'A', SVG_ATTR_stroke_miterlimit, L_OtherValue},
   {"stroke-opacity", "", 'A', SVG_ATTR_stroke_opacity, L_OtherValue},
   {"stroke-width", "", 'A', SVG_ATTR_stroke_width, L_OtherValue},
   {"style", "", 'A', SVG_ATTR_style_, L_OtherValue},
   {"surfaceScale", "", 'A', SVG_ATTR_surfaceScale, L_OtherValue},
   {"systemLanguage", "", 'A', SVG_ATTR_systemLanguage, L_OtherValue},
   {"tableValues", "", 'A', SVG_ATTR_tableValues, L_OtherValue},
   {"target", "", 'A', SVG_ATTR_target_, L_OtherValue},
   {"targetX", "", 'A', SVG_ATTR_targetX, L_OtherValue},
   {"targetY", "", 'A', SVG_ATTR_targetY, L_OtherValue},
   {"text-anchor", "", 'A', SVG_ATTR_text_anchor, L_OtherValue},
   {"text-decoration", "", 'A', SVG_ATTR_text_decoration, L_OtherValue},
   {"text-rendering", "", 'A', SVG_ATTR_text_rendering, L_OtherValue},
   {"textLength", "", 'A', SVG_ATTR_textLength, L_OtherValue},
   {"title", "", 'A', SVG_ATTR_title_, L_OtherValue},
   {"to", "", 'A', SVG_ATTR_to_, L_OtherValue},
   {"transform", "", 'A', SVG_ATTR_transform, L_OtherValue},
   {"type", "animateTransform", 'A', SVG_ATTR_type_, L_OtherValue},
   {"type", "feColorMatrix", 'A', SVG_ATTR_type__, L_OtherValue},
   {"type", "feTurbulence", 'A', SVG_ATTR_type____, L_OtherValue},
   {"type", "script", 'A', SVG_ATTR_type, L_OtherValue},
   {"type", "style", 'A', SVG_ATTR_type, L_OtherValue},
   {"type", "", 'A', SVG_ATTR_type___, L_OtherValue},
   {"u1", "", 'A', SVG_ATTR_u1, L_OtherValue},
   {"u2", "", 'A', SVG_ATTR_u2, L_OtherValue},
   {"underline-position", "", 'A', SVG_ATTR_underline_position, L_OtherValue},
   {"underline-thickness", "", 'A', SVG_ATTR_underline_thickness, L_OtherValue},
   {"unicode", "", 'A', SVG_ATTR_unicode, L_OtherValue},
   {"unicode-bidi", "", 'A', SVG_ATTR_unicode_bidi, L_OtherValue},
   {"unicode-range", "", 'A', SVG_ATTR_unicode_range, L_OtherValue},
   {"units-per-em", "", 'A', SVG_ATTR_units_per_em, L_OtherValue},
   {"v-alphabetic", "", 'A', SVG_ATTR_v_alphabetic, L_OtherValue},
   {"v-hanging", "", 'A', SVG_ATTR_v_hanging, L_OtherValue},
   {"v-ideographic", "", 'A', SVG_ATTR_v_ideographic, L_OtherValue},
   {"v-mathematical", "", 'A', SVG_ATTR_v_mathematical, L_OtherValue},
   {"values", "", 'A', SVG_ATTR_values, L_OtherValue},
   {"version", "", 'A', SVG_ATTR_version, L_OtherValue},
   {"vert-adv-y", "", 'A', SVG_ATTR_vert_adv_y, L_OtherValue},
   {"vert-origin-x", "", 'A', SVG_ATTR_vert_origin_x, L_OtherValue},
   {"vert-origin-y", "", 'A', SVG_ATTR_vert_origin_y, L_OtherValue},
   {"viewBox", "", 'A', SVG_ATTR_viewBox, L_OtherValue},
   {"viewTarget", "", 'A', SVG_ATTR_viewTarget, L_OtherValue},
   {"visibility", "", 'A', SVG_ATTR_visibility_, L_OtherValue},
   {"width", "", 'A', SVG_ATTR_width_, L_OtherValue},
   {"widths", "", 'A', SVG_ATTR_widths, L_OtherValue},
   {"word-spacing", "", 'A', SVG_ATTR_word_spacing, L_OtherValue},
   {"writing-mode", "", 'A', SVG_ATTR_writing_mode, L_OtherValue},
   {"x", "", 'A', SVG_ATTR_x, L_OtherValue},
   {"x-height", "", 'A', SVG_ATTR_x_height, L_OtherValue},
   {"x1", "", 'A', SVG_ATTR_x1, L_OtherValue},
   {"x2", "", 'A', SVG_ATTR_x2, L_OtherValue},
   {"xChannelSelector", "", 'A', SVG_ATTR_xChannelSelector, L_OtherValue},
   {"xlink:actuate", "", 'A', SVG_ATTR_xlink_actuate, L_OtherValue},
   {"xlink:arcrole", "", 'A', SVG_ATTR_xlink_arcrole, L_OtherValue},
   {"xlink:href", "", 'A', SVG_ATTR_xlink_href, L_OtherValue},
   {"xlink:role", "", 'A', SVG_ATTR_xlink_role, L_OtherValue},
   {"xlink:show", "", 'A', SVG_ATTR_xlink_show, L_OtherValue},
   {"xlink:title", "", 'A', SVG_ATTR_xlink_title, L_OtherValue},
   {"xlink:type", "", 'A', SVG_ATTR_xlink_type, L_OtherValue},
   {"xml:base", "", 'A', SVG_ATTR_xml_base, L_OtherValue},
   {"xml:id", "", 'A', SVG_ATTR_xmlid, L_OtherValue},
   {"xml:space", "", 'A', SVG_ATTR_xml_space, L_OtherValue},
   {"y", "", 'A', SVG_ATTR_y, L_OtherValue},
   {"y1", "", 'A', SVG_ATTR_y1, L_OtherValue},
   {"y2", "", 'A', SVG_ATTR_y2, L_OtherValue},
   {"yChannelSelector", "", 'A', SVG_ATTR_yChannelSelector, L_OtherValue},
   {"z", "", 'A', SVG_ATTR_z, L_OtherValue},
   {"zoomAndPan", "", 'A', SVG_ATTR_zoomAndPan, L_OtherValue},
   {"zzghost", "", 'A', SVG_ATTR_Ghost_restruct, L_OtherValue},
   {"", "", EOS, 0, L_OtherValue}	  /* Last entry. Mandatory */
};

/* mapping table of attribute values */
static AttrValueMapping SVGAttrValueMappingTable[] =
{
   {SVG_ATTR_accumulate, "none", SVG_ATTR_accumulate_VAL_none_},
   {SVG_ATTR_accumulate, "sum", SVG_ATTR_accumulate_VAL_sum},

   {SVG_ATTR_additive, "replace", SVG_ATTR_additive_VAL_replace},
   {SVG_ATTR_additive, "sum", SVG_ATTR_additive_VAL_sum},

   {SVG_ATTR_alignment_baseline, "after-edge", SVG_ATTR_alignment_baseline_VAL_after_edge},
   {SVG_ATTR_alignment_baseline, "baseline", SVG_ATTR_alignment_baseline_VAL_baseline},
   {SVG_ATTR_alignment_baseline, "before-edge", SVG_ATTR_alignment_baseline_VAL_before_edge},
   {SVG_ATTR_alignment_baseline, "bottom", SVG_ATTR_alignment_baseline_VAL_bottom},
   {SVG_ATTR_alignment_baseline, "hanging", SVG_ATTR_alignment_baseline_VAL_hanging_},
   {SVG_ATTR_alignment_baseline, "ideographic", SVG_ATTR_alignment_baseline_VAL_ideographic_},
   {SVG_ATTR_alignment_baseline, "inherit", SVG_ATTR_alignment_baseline_VAL_inherit},
   {SVG_ATTR_alignment_baseline, "lower", SVG_ATTR_alignment_baseline_VAL_lower},
   {SVG_ATTR_alignment_baseline, "mathematical", SVG_ATTR_alignment_baseline_VAL_mathematical_},
   {SVG_ATTR_alignment_baseline, "middle", SVG_ATTR_alignment_baseline_VAL_middle},
   {SVG_ATTR_alignment_baseline, "text-after-edge", SVG_ATTR_alignment_baseline_VAL_text_after_edge},
   {SVG_ATTR_alignment_baseline, "text-before-edge", SVG_ATTR_alignment_baseline_VAL_text_before_edge},
   {SVG_ATTR_alignment_baseline, "text-bottom", SVG_ATTR_alignment_baseline_VAL_text_bottom},
   {SVG_ATTR_alignment_baseline, "text-top", SVG_ATTR_alignment_baseline_VAL_text_top},
   {SVG_ATTR_alignment_baseline, "top", SVG_ATTR_alignment_baseline_VAL_top},

   {SVG_ATTR_calcMode, "discrete", SVG_ATTR_calcMode_VAL_discrete},
   {SVG_ATTR_calcMode, "linear", SVG_ATTR_calcMode_VAL_linear},
   {SVG_ATTR_calcMode, "paced", SVG_ATTR_calcMode_VAL_paced},
   {SVG_ATTR_calcMode, "spline", SVG_ATTR_calcMode_VAL_spline},

   {SVG_ATTR_clip_rule, "evenodd", SVG_ATTR_clip_rule_VAL_evenodd},
   {SVG_ATTR_clip_rule, "inherit", SVG_ATTR_clip_rule_VAL_inherit},
   {SVG_ATTR_clip_rule, "nonzero", SVG_ATTR_clip_rule_VAL_nonzero},

   {SVG_ATTR_clipPathUnits, "objectBoundingBox", SVG_ATTR_clipPathUnits_VAL_objectBoundingBox},
   {SVG_ATTR_clipPathUnits, "userSpaceOnUse", SVG_ATTR_clipPathUnits_VAL_userSpaceOnUse},

   {SVG_ATTR_color_interpolation, "auto", SVG_ATTR_color_interpolation_VAL_auto},
   {SVG_ATTR_color_interpolation, "inherit", SVG_ATTR_color_interpolation_VAL_inherit},
   {SVG_ATTR_color_interpolation, "linearRGB", SVG_ATTR_color_interpolation_VAL_linearRGB},
   {SVG_ATTR_color_interpolation, "sRGB", SVG_ATTR_color_interpolation_VAL_sRGB},

   {SVG_ATTR_color_interpolation_filters, "auto", SVG_ATTR_color_interpolation_filters_VAL_auto},
   {SVG_ATTR_color_interpolation_filters, "inherit", SVG_ATTR_color_interpolation_filters_VAL_inherit},
   {SVG_ATTR_color_interpolation_filters, "linearRGB", SVG_ATTR_color_interpolation_filters_VAL_linearRGB},
   {SVG_ATTR_color_interpolation_filters, "sRGB", SVG_ATTR_color_interpolation_filters_VAL_sRGB},

   {SVG_ATTR_color_rendering, "auto", SVG_ATTR_color_rendering_VAL_auto},
   {SVG_ATTR_color_rendering, "inherit", SVG_ATTR_color_rendering_VAL_inherit},
   {SVG_ATTR_color_rendering, "optimizeQuality", SVG_ATTR_color_rendering_VAL_optimizeQuality},
   {SVG_ATTR_color_rendering, "optimizeSpeed", SVG_ATTR_color_rendering_VAL_optimizeSpeed},

   {SVG_ATTR_direction_, "ltr", SVG_ATTR_direction__VAL_ltr_},
   {SVG_ATTR_direction_, "rtl", SVG_ATTR_direction__VAL_rtl_},
   {SVG_ATTR_direction_, "inherit", SVG_ATTR_direction__VAL_inherit},

   {SVG_ATTR_display_, "block", SVG_ATTR_display__VAL_block},
   {SVG_ATTR_display_, "compact", SVG_ATTR_display__VAL_compact},
   {SVG_ATTR_display_, "inherit", SVG_ATTR_display__VAL_inherit},
   {SVG_ATTR_display_, "inline", SVG_ATTR_display__VAL_inline},
   {SVG_ATTR_display_, "inline-table", SVG_ATTR_display__VAL_inline_table},
   {SVG_ATTR_display_, "list-item", SVG_ATTR_display__VAL_list_item},
   {SVG_ATTR_display_, "marker", SVG_ATTR_display__VAL_marker_},
   {SVG_ATTR_display_, "none", SVG_ATTR_display__VAL_none},
   {SVG_ATTR_display_, "run-in", SVG_ATTR_display__VAL_run_in},
   {SVG_ATTR_display_, "table", SVG_ATTR_display__VAL_table},
   {SVG_ATTR_display_, "table-caption", SVG_ATTR_display__VAL_table_caption},
   {SVG_ATTR_display_, "table-cell", SVG_ATTR_display__VAL_table_cell},
   {SVG_ATTR_display_, "table-column", SVG_ATTR_display__VAL_table_column},
   {SVG_ATTR_display_, "table-column-group", SVG_ATTR_display__VAL_table_column_group},
   {SVG_ATTR_display_, "table-footer-group", SVG_ATTR_display__VAL_table_footer_group},
   {SVG_ATTR_display_, "table-header-group", SVG_ATTR_display__VAL_table_header_group},
   {SVG_ATTR_display_, "table-row", SVG_ATTR_display__VAL_table_row},
   {SVG_ATTR_display_, "table-row-group", SVG_ATTR_display__VAL_table_row_group},

   {SVG_ATTR_dominant_baseline, "auto", SVG_ATTR_dominant_baseline_VAL_auto},
   {SVG_ATTR_dominant_baseline, "autosense-script", SVG_ATTR_dominant_baseline_VAL_autosense_script},
   {SVG_ATTR_dominant_baseline, "hanging", SVG_ATTR_dominant_baseline_VAL_hanging_},
   {SVG_ATTR_dominant_baseline, "ideographic", SVG_ATTR_dominant_baseline_VAL_ideographic_},
   {SVG_ATTR_dominant_baseline, "inherit", SVG_ATTR_dominant_baseline_VAL_inherit},
   {SVG_ATTR_dominant_baseline, "lower", SVG_ATTR_dominant_baseline_VAL_lower},
   {SVG_ATTR_dominant_baseline, "mathematical", SVG_ATTR_dominant_baseline_VAL_mathematical_},
   {SVG_ATTR_dominant_baseline, "no-change", SVG_ATTR_dominant_baseline_VAL_no_change},
   {SVG_ATTR_dominant_baseline, "reset", SVG_ATTR_dominant_baseline_VAL_reset},

   {SVG_ATTR_edgeMode, "duplicate", SVG_ATTR_edgeMode_VAL_duplicate},
   {SVG_ATTR_edgeMode, "none", SVG_ATTR_edgeMode_VAL_none},
   {SVG_ATTR_edgeMode, "wrap", SVG_ATTR_edgeMode_VAL_wrap},

   {SVG_ATTR_externalResourcesRequired, "false", SVG_ATTR_externalResourcesRequired_VAL_false},
   {SVG_ATTR_externalResourcesRequired, "true", SVG_ATTR_externalResourcesRequired_VAL_true},

   {SVG_ATTR_fill_, "freeze", SVG_ATTR_fill__VAL_freeze},
   {SVG_ATTR_fill_, "remove", SVG_ATTR_fill__VAL_remove_},

   {SVG_ATTR_fill_rule, "evenodd", SVG_ATTR_fill_rule_VAL_evenodd},
   {SVG_ATTR_fill_rule, "inherit", SVG_ATTR_fill_rule_VAL_inherit},
   {SVG_ATTR_fill_rule, "nonzero", SVG_ATTR_fill_rule_VAL_nonzero},

   {SVG_ATTR_filterUnits, "userSpaceOnUse", SVG_ATTR_filterUnits_VAL_userSpaceOnUse},
   {SVG_ATTR_filterUnits, "objectBoundingBox", SVG_ATTR_filterUnits_VAL_objectBoundingBox},

   {SVG_ATTR_font_stretch, "condensed", SVG_ATTR_font_stretch_VAL_condensed},
   {SVG_ATTR_font_stretch, "expanded", SVG_ATTR_font_stretch_VAL_expanded},
   {SVG_ATTR_font_stretch, "extra-condensed", SVG_ATTR_font_stretch_VAL_extra_condensed},
   {SVG_ATTR_font_stretch, "extra-expanded", SVG_ATTR_font_stretch_VAL_extra_expanded},
   {SVG_ATTR_font_stretch, "inherit", SVG_ATTR_font_stretch_VAL_inherit},
   {SVG_ATTR_font_stretch, "narrower", SVG_ATTR_font_stretch_VAL_narrower},
   {SVG_ATTR_font_stretch, "normal", SVG_ATTR_font_stretch_VAL_normal_},
   {SVG_ATTR_font_stretch, "semi-condensed", SVG_ATTR_font_stretch_VAL_semi_condensed},
   {SVG_ATTR_font_stretch, "semi-expanded", SVG_ATTR_font_stretch_VAL_semi_expanded},
   {SVG_ATTR_font_stretch, "ultra-condensed", SVG_ATTR_font_stretch_VAL_ultra_condensed},
   {SVG_ATTR_font_stretch, "ultra-expanded", SVG_ATTR_font_stretch_VAL_ultra_expanded},
   {SVG_ATTR_font_stretch, "wider", SVG_ATTR_font_stretch_VAL_wider},

   {SVG_ATTR_font_style, "inherit", SVG_ATTR_font_style_VAL_inherit},
   {SVG_ATTR_font_style, "italic", SVG_ATTR_font_style_VAL_italic},
   {SVG_ATTR_font_style, "normal", SVG_ATTR_font_style_VAL_normal_},
   {SVG_ATTR_font_style, "oblique", SVG_ATTR_font_style_VAL_oblique_},

   {SVG_ATTR_font_variant, "inherit", SVG_ATTR_font_variant_VAL_inherit},
   {SVG_ATTR_font_variant, "normal", SVG_ATTR_font_variant_VAL_normal_},
   {SVG_ATTR_font_variant, "small-caps", SVG_ATTR_font_variant_VAL_small_caps},

   {SVG_ATTR_font_weight, "100", SVG_ATTR_font_weight_VAL_w100},
   {SVG_ATTR_font_weight, "200", SVG_ATTR_font_weight_VAL_w200},
   {SVG_ATTR_font_weight, "300", SVG_ATTR_font_weight_VAL_w300},
   {SVG_ATTR_font_weight, "400", SVG_ATTR_font_weight_VAL_w400},
   {SVG_ATTR_font_weight, "500", SVG_ATTR_font_weight_VAL_w500},
   {SVG_ATTR_font_weight, "600", SVG_ATTR_font_weight_VAL_w600},
   {SVG_ATTR_font_weight, "700", SVG_ATTR_font_weight_VAL_w700},
   {SVG_ATTR_font_weight, "800", SVG_ATTR_font_weight_VAL_w800},
   {SVG_ATTR_font_weight, "900", SVG_ATTR_font_weight_VAL_w900},
   {SVG_ATTR_font_weight, "bold", SVG_ATTR_font_weight_VAL_bold_},
   {SVG_ATTR_font_weight, "bolder", SVG_ATTR_font_weight_VAL_bolder},
   {SVG_ATTR_font_weight, "inherit", SVG_ATTR_font_weight_VAL_inherit},
   {SVG_ATTR_font_weight, "lighter", SVG_ATTR_font_weight_VAL_lighter},
   {SVG_ATTR_font_weight, "normal", SVG_ATTR_font_weight_VAL_normal_},

   {SVG_ATTR_gradientUnits, "objectBoundingBox", SVG_ATTR_gradientUnits_VAL_objectBoundingBox},
   {SVG_ATTR_gradientUnits, "userSpaceOnUse", SVG_ATTR_gradientUnits_VAL_userSpaceOnUse},

   {SVG_ATTR_image_rendering, "auto", SVG_ATTR_image_rendering_VAL_auto},
   {SVG_ATTR_image_rendering, "inherit", SVG_ATTR_image_rendering_VAL_inherit},
   {SVG_ATTR_image_rendering, "optimizeQuality", SVG_ATTR_image_rendering_VAL_optimizeQuality},
   {SVG_ATTR_image_rendering, "optimizeSpeed", SVG_ATTR_image_rendering_VAL_optimizeSpeed},

   {SVG_ATTR_lengthAdjust, "spacing", SVG_ATTR_lengthAdjust_VAL_spacing_},
   {SVG_ATTR_lengthAdjust, "spacingAndGlyphs", SVG_ATTR_lengthAdjust_VAL_spacingAndGlyphs},

   {SVG_ATTR_markerUnits, "strokeWidth", SVG_ATTR_markerUnits_VAL_strokeWidth},
   {SVG_ATTR_markerUnits, "userSpaceOnUse", SVG_ATTR_markerUnits_VAL_userSpaceOnUse},

   {SVG_ATTR_maskContentUnits, "objectBoundingBox", SVG_ATTR_maskContentUnits_VAL_objectBoundingBox},
   {SVG_ATTR_maskContentUnits, "userSpaceOnUse", SVG_ATTR_maskContentUnits_VAL_userSpaceOnUse},

   {SVG_ATTR_maskUnits, "objectBoundingBox", SVG_ATTR_maskUnits_VAL_objectBoundingBox},
   {SVG_ATTR_maskUnits, "userSpaceOnUse", SVG_ATTR_maskUnits_VAL_userSpaceOnUse},

   {SVG_ATTR_method, "align", SVG_ATTR_method_VAL_align},
   {SVG_ATTR_method, "stretch", SVG_ATTR_method_VAL_stretch},

   {SVG_ATTR_mode, "darken", SVG_ATTR_mode_VAL_darken},
   {SVG_ATTR_mode, "lighten", SVG_ATTR_mode_VAL_lighten},
   {SVG_ATTR_mode, "multiply", SVG_ATTR_mode_VAL_multiply},
   {SVG_ATTR_mode, "normal", SVG_ATTR_mode_VAL_normal_},
   {SVG_ATTR_mode, "screen", SVG_ATTR_mode_VAL_screen},

   {SVG_ATTR_operator, "arithmetic", SVG_ATTR_operator_VAL_arithmetic},
   {SVG_ATTR_operator, "atop", SVG_ATTR_operator_VAL_atop},
   {SVG_ATTR_operator, "in", SVG_ATTR_operator_VAL_in__},
   {SVG_ATTR_operator, "out", SVG_ATTR_operator_VAL_out},
   {SVG_ATTR_operator, "over", SVG_ATTR_operator_VAL_over},
   {SVG_ATTR_operator, "xor", SVG_ATTR_operator_VAL_xor},

   {SVG_ATTR_operator_, "dilate", SVG_ATTR_operator__VAL_dilate},
   {SVG_ATTR_operator_, "erode", SVG_ATTR_operator__VAL_erode},

   {SVG_ATTR_overflow, "auto", SVG_ATTR_overflow_VAL_auto},
   {SVG_ATTR_overflow, "hidden", SVG_ATTR_overflow_VAL_hidden_},
   {SVG_ATTR_overflow, "inherit", SVG_ATTR_overflow_VAL_inherit},
   {SVG_ATTR_overflow, "scroll", SVG_ATTR_overflow_VAL_scroll},
   {SVG_ATTR_overflow, "visible", SVG_ATTR_overflow_VAL_visible},

   {SVG_ATTR_patternContentUnits, "objectBoundingBox", SVG_ATTR_patternContentUnits_VAL_objectBoundingBox},
   {SVG_ATTR_patternContentUnits, "userSpaceOnUse", SVG_ATTR_patternContentUnits_VAL_userSpaceOnUse},

   {SVG_ATTR_patternUnits, "objectBoundingBox", SVG_ATTR_patternUnits_VAL_objectBoundingBox},
   {SVG_ATTR_patternUnits, "userSpaceOnUse", SVG_ATTR_patternUnits_VAL_userSpaceOnUse},

   {SVG_ATTR_pointer_events, "all", SVG_ATTR_pointer_events_VAL_all},
   {SVG_ATTR_pointer_events, "fill", SVG_ATTR_pointer_events_VAL_fill__},
   {SVG_ATTR_pointer_events, "inherit", SVG_ATTR_pointer_events_VAL_inherit},
   {SVG_ATTR_pointer_events, "none", SVG_ATTR_pointer_events_VAL_none},
   {SVG_ATTR_pointer_events, "painted", SVG_ATTR_pointer_events_VAL_painted},
   {SVG_ATTR_pointer_events, "stroke", SVG_ATTR_pointer_events_VAL_stroke_},
   {SVG_ATTR_pointer_events, "visible", SVG_ATTR_pointer_events_VAL_visible},
   {SVG_ATTR_pointer_events, "visibleFill", SVG_ATTR_pointer_events_VAL_visibleFill},
   {SVG_ATTR_pointer_events, "visiblePainted", SVG_ATTR_pointer_events_VAL_visiblePainted},
   {SVG_ATTR_pointer_events, "visibleStroke", SVG_ATTR_pointer_events_VAL_visibleStroke},

   {SVG_ATTR_primitiveUnits, "userSpaceOnUse", SVG_ATTR_primitiveUnits_VAL_userSpaceOnUse},
   {SVG_ATTR_primitiveUnits, "objectBoundingBox", SVG_ATTR_primitiveUnits_VAL_objectBoundingBox},

   {SVG_ATTR_rendering_intent, "absolute-colorimetric", SVG_ATTR_rendering_intent_VAL_absolute_colorimetric},
   {SVG_ATTR_rendering_intent, "auto", SVG_ATTR_rendering_intent_VAL_auto},
   {SVG_ATTR_rendering_intent, "perceptual", SVG_ATTR_rendering_intent_VAL_perceptual},
   {SVG_ATTR_rendering_intent, "relative-colorimetric", SVG_ATTR_rendering_intent_VAL_relative_colorimetric},
   {SVG_ATTR_rendering_intent, "saturation", SVG_ATTR_rendering_intent_VAL_saturation},

   {SVG_ATTR_restart, "always", SVG_ATTR_restart_VAL_always},
   {SVG_ATTR_restart, "never", SVG_ATTR_restart_VAL_never},
   {SVG_ATTR_restart, "whenNotActive", SVG_ATTR_restart_VAL_whenNotActive},

   {SVG_ATTR_shape_rendering, "auto", SVG_ATTR_shape_rendering_VAL_auto},
   {SVG_ATTR_shape_rendering, "crispEdges", SVG_ATTR_shape_rendering_VAL_crispEdges},
   {SVG_ATTR_shape_rendering, "geometricPrecision", SVG_ATTR_shape_rendering_VAL_geometricPrecision},
   {SVG_ATTR_shape_rendering, "inherit", SVG_ATTR_shape_rendering_VAL_inherit},
   {SVG_ATTR_shape_rendering, "optimizeSpeed", SVG_ATTR_shape_rendering_VAL_optimizeSpeed},

   {SVG_ATTR_spacing, "auto", SVG_ATTR_spacing_VAL_auto},
   {SVG_ATTR_spacing, "exact", SVG_ATTR_spacing_VAL_exact},

   {SVG_ATTR_spreadMethod, "pad", SVG_ATTR_spreadMethod_VAL_pad},
   {SVG_ATTR_spreadMethod, "reflect", SVG_ATTR_spreadMethod_VAL_reflect},
   {SVG_ATTR_spreadMethod, "repeat", SVG_ATTR_spreadMethod_VAL_repeat},

   {SVG_ATTR_stitchTiles, "noStitch", SVG_ATTR_stitchTiles_VAL_noStitch},
   {SVG_ATTR_stitchTiles, "stitch", SVG_ATTR_stitchTiles_VAL_stitch},

   {SVG_ATTR_stroke_linecap, "butt", SVG_ATTR_stroke_linecap_VAL_butt},
   {SVG_ATTR_stroke_linecap, "inherit", SVG_ATTR_stroke_linecap_VAL_inherit},
   {SVG_ATTR_stroke_linecap, "round", SVG_ATTR_stroke_linecap_VAL_round},
   {SVG_ATTR_stroke_linecap, "square", SVG_ATTR_stroke_linecap_VAL_square},

   {SVG_ATTR_stroke_linejoin, "bevel", SVG_ATTR_stroke_linejoin_VAL_bevel},
   {SVG_ATTR_stroke_linejoin, "inherit", SVG_ATTR_stroke_linejoin_VAL_inherit},
   {SVG_ATTR_stroke_linejoin, "miter", SVG_ATTR_stroke_linejoin_VAL_miter},
   {SVG_ATTR_stroke_linejoin, "round", SVG_ATTR_stroke_linejoin_VAL_round},

   {SVG_ATTR_text_anchor, "start", SVG_ATTR_text_anchor_VAL_start},
   {SVG_ATTR_text_anchor, "middle", SVG_ATTR_text_anchor_VAL_middle},
   {SVG_ATTR_text_anchor, "end", SVG_ATTR_text_anchor_VAL_end__},
   {SVG_ATTR_text_anchor, "inherit", SVG_ATTR_text_anchor_VAL_inherit},

   {SVG_ATTR_text_rendering, "auto", SVG_ATTR_text_rendering_VAL_auto},
   {SVG_ATTR_text_rendering, "geometricPrecision", SVG_ATTR_text_rendering_VAL_geometricPrecision},
   {SVG_ATTR_text_rendering, "inherit", SVG_ATTR_text_rendering_VAL_inherit},
   {SVG_ATTR_text_rendering, "optimizeLegibility", SVG_ATTR_text_rendering_VAL_optimizeLegibility},
   {SVG_ATTR_text_rendering, "optimizeSpeed", SVG_ATTR_text_rendering_VAL_optimizeSpeed},

   {SVG_ATTR_type_, "rotate", SVG_ATTR_type__VAL_rotate_},
   {SVG_ATTR_type_, "scale", SVG_ATTR_type__VAL_scale},
   {SVG_ATTR_type_, "skewX", SVG_ATTR_type__VAL_skewX},
   {SVG_ATTR_type_, "skewY", SVG_ATTR_type__VAL_skewY},
   {SVG_ATTR_type_, "translate", SVG_ATTR_type__VAL_translate},

   {SVG_ATTR_type__, "hueRotate", SVG_ATTR_type___VAL_hueRotate},
   {SVG_ATTR_type__, "luminanceToAlpha", SVG_ATTR_type___VAL_luminanceToAlpha},
   {SVG_ATTR_type__, "matrix", SVG_ATTR_type___VAL_matrix},
   {SVG_ATTR_type__, "saturate", SVG_ATTR_type___VAL_saturate},

   {SVG_ATTR_type___, "discrete", SVG_ATTR_type____VAL_discrete},
   {SVG_ATTR_type___, "gamma", SVG_ATTR_type____VAL_gamma},
   {SVG_ATTR_type___, "identity", SVG_ATTR_type____VAL_identity},
   {SVG_ATTR_type___, "linear", SVG_ATTR_type____VAL_linear},
   {SVG_ATTR_type___, "table", SVG_ATTR_type____VAL_table},

   {SVG_ATTR_type____, "fractalNoise", SVG_ATTR_type_____VAL_fractalNoise},
   {SVG_ATTR_type____, "turbulence", SVG_ATTR_type_____VAL_turbulence},

   {SVG_ATTR_unicode_bidi, "normal", SVG_ATTR_unicode_bidi_VAL_normal_},
   {SVG_ATTR_unicode_bidi, "embed", SVG_ATTR_unicode_bidi_VAL_embed_},
   {SVG_ATTR_unicode_bidi, "bidi-override", SVG_ATTR_unicode_bidi_VAL_bidi_override},
   {SVG_ATTR_unicode_bidi, "inherit", SVG_ATTR_unicode_bidi_VAL_inherit},

   {SVG_ATTR_visibility_, "hidden", SVG_ATTR_visibility__VAL_hidden_},
   {SVG_ATTR_visibility_, "inherit", SVG_ATTR_visibility__VAL_inherit},
   {SVG_ATTR_visibility_, "visible", SVG_ATTR_visibility__VAL_visible},

   {SVG_ATTR_writing_mode, "lr-tb", SVG_ATTR_writing_mode_VAL_lr_tb},
   {SVG_ATTR_writing_mode, "rl-tb", SVG_ATTR_writing_mode_VAL_rl_tb},
   {SVG_ATTR_writing_mode, "tb-rl", SVG_ATTR_writing_mode_VAL_tb_rl},
   {SVG_ATTR_writing_mode, "lr", SVG_ATTR_writing_mode_VAL_lr},
   {SVG_ATTR_writing_mode, "rl", SVG_ATTR_writing_mode_VAL_rl},
   {SVG_ATTR_writing_mode, "tb", SVG_ATTR_writing_mode_VAL_tb},
   {SVG_ATTR_writing_mode, "inherit", SVG_ATTR_writing_mode_VAL_inherit},

   {SVG_ATTR_xChannelSelector, "A", SVG_ATTR_xChannelSelector_VAL_A},
   {SVG_ATTR_xChannelSelector, "B", SVG_ATTR_xChannelSelector_VAL_B},
   {SVG_ATTR_xChannelSelector, "G", SVG_ATTR_xChannelSelector_VAL_G},
   {SVG_ATTR_xChannelSelector, "R", SVG_ATTR_xChannelSelector_VAL_R},

   {SVG_ATTR_xlink_actuate, "onLoad", SVG_ATTR_xlink_actuate_VAL_onLoad},

   {SVG_ATTR_xlink_show, "embed", SVG_ATTR_xlink_show_VAL_embed},
   {SVG_ATTR_xlink_show, "other", SVG_ATTR_xlink_show_VAL_other},

   {SVG_ATTR_xlink_type, "simple", SVG_ATTR_xlink_type_VAL_simple},

   {SVG_ATTR_xml_space, "default", SVG_ATTR_xml_space_VAL_xml_space_default},
   {SVG_ATTR_xml_space, "preserve", SVG_ATTR_xml_space_VAL_xml_space_preserve},

   {SVG_ATTR_yChannelSelector, "A", SVG_ATTR_yChannelSelector_VAL_A},
   {SVG_ATTR_yChannelSelector, "B", SVG_ATTR_yChannelSelector_VAL_B},
   {SVG_ATTR_yChannelSelector, "G", SVG_ATTR_yChannelSelector_VAL_G},
   {SVG_ATTR_yChannelSelector, "R", SVG_ATTR_yChannelSelector_VAL_R},

   {SVG_ATTR_zoomAndPan, "disable", SVG_ATTR_zoomAndPan_VAL_disable},
   {SVG_ATTR_zoomAndPan, "magnify", SVG_ATTR_zoomAndPan_VAL_magnify},

   {0, "", 0}			/* Last entry. Mandatory */
};
#else /* _SVG */
/* there is no mapping table of SVG elements */

static ElemMapping *SVGElemMappingTable = NULL;
static AttributeMapping* SVGAttributeMappingTable = NULL;
#endif /* _SVG */
