/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.19
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

#define SWIGPYTHON

#include "Python.h"

/***********************************************************************
 * common.swg
 *
 *     This file contains generic SWIG runtime support for pointer
 *     type checking as well as a few commonly used macros to control
 *     external linkage.
 *
 * Author : David Beazley (beazley@cs.uchicago.edu)
 *
 * Copyright (c) 1999-2000, The University of Chicago
 * 
 * This file may be freely redistributed without license or fee provided
 * this copyright message remains intact.
 ************************************************************************/

#include <string.h>

#if defined(_WIN32) || defined(__WIN32__)
#       if defined(_MSC_VER)
#               if defined(STATIC_LINKED)
#                       define SWIGEXPORT(a) a
#                       define SWIGIMPORT(a) extern a
#               else
#                       define SWIGEXPORT(a) __declspec(dllexport) a
#                       define SWIGIMPORT(a) extern a
#               endif
#       else
#               if defined(__BORLANDC__)
#                       define SWIGEXPORT(a) a _export
#                       define SWIGIMPORT(a) a _export
#               else
#                       define SWIGEXPORT(a) a
#                       define SWIGIMPORT(a) a
#               endif
#       endif
#else
#       define SWIGEXPORT(a) a
#       define SWIGIMPORT(a) a
#endif

#ifdef SWIG_GLOBAL
#define SWIGRUNTIME(a) SWIGEXPORT(a)
#else
#define SWIGRUNTIME(a) static a
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef void *(*swig_converter_func)(void *);
typedef struct swig_type_info *(*swig_dycast_func)(void **);

typedef struct swig_type_info {
  const char             *name;                 
  swig_converter_func     converter;
  const char             *str;
  void                   *clientdata;	
  swig_dycast_func        dcast;
  struct swig_type_info  *next;
  struct swig_type_info  *prev;
} swig_type_info;

#ifdef SWIG_NOINCLUDE

SWIGIMPORT(swig_type_info *) SWIG_TypeRegister(swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeCheck(char *c, swig_type_info *);
SWIGIMPORT(void *)           SWIG_TypeCast(swig_type_info *, void *);
SWIGIMPORT(swig_type_info *) SWIG_TypeDynamicCast(swig_type_info *, void **);
SWIGIMPORT(const char *)     SWIG_TypeName(const swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeQuery(const char *);
SWIGIMPORT(void)             SWIG_TypeClientData(swig_type_info *, void *);

#else

static swig_type_info *swig_type_list = 0;

/* Register a type mapping with the type-checking */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeRegister(swig_type_info *ti)
{
  swig_type_info *tc, *head, *ret, *next;
  /* Check to see if this type has already been registered */
  tc = swig_type_list;
  while (tc) {
    if (strcmp(tc->name, ti->name) == 0) {
      /* Already exists in the table.  Just add additional types to the list */
      if (tc->clientdata) ti->clientdata = tc->clientdata;	
      head = tc;
      next = tc->next;
      goto l1;
    }
    tc = tc->prev;
  }
  head = ti;
  next = 0;

  /* Place in list */
  ti->prev = swig_type_list;
  swig_type_list = ti;

  /* Build linked lists */
 l1:
  ret = head;
  tc = ti + 1;
  /* Patch up the rest of the links */
  while (tc->name) {
    head->next = tc;
    tc->prev = head;
    head = tc;
    tc++;
  }
  if (next) next->prev = head;  /**/
  head->next = next;
  return ret;
}

/* Check the typename */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeCheck(char *c, swig_type_info *ty)
{
  swig_type_info *s;
  if (!ty) return 0;        /* Void pointer */
  s = ty->next;             /* First element always just a name */
  do {
    if (strcmp(s->name,c) == 0) {
      if (s == ty->next) return s;
      /* Move s to the top of the linked list */
      s->prev->next = s->next;
      if (s->next) {
	s->next->prev = s->prev;
      }
      /* Insert s as second element in the list */
      s->next = ty->next;
      if (ty->next) ty->next->prev = s;
      ty->next = s;
      s->prev = ty;  /**/
      return s;
    }
    s = s->next;
  } while (s && (s != ty->next));
  return 0;
}

/* Cast a pointer up an inheritance hierarchy */
SWIGRUNTIME(void *) 
SWIG_TypeCast(swig_type_info *ty, void *ptr) 
{
  if ((!ty) || (!ty->converter)) return ptr;
  return (*ty->converter)(ptr);
}

/* Dynamic pointer casting. Down an inheritance hierarchy */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeDynamicCast(swig_type_info *ty, void **ptr) 
{
  swig_type_info *lastty = ty;
  if (!ty || !ty->dcast) return ty;
  while (ty && (ty->dcast)) {
     ty = (*ty->dcast)(ptr);
     if (ty) lastty = ty;
  }
  return lastty;
}

/* Return the name associated with this type */
SWIGRUNTIME(const char *)
SWIG_TypeName(const swig_type_info *ty) {
  return ty->name;
}

/* Search for a swig_type_info structure */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeQuery(const char *name) {
  swig_type_info *ty = swig_type_list;
  while (ty) {
    if (ty->str && (strcmp(name,ty->str) == 0)) return ty;
    if (ty->name && (strcmp(name,ty->name) == 0)) return ty;
    ty = ty->prev;
  }
  return 0;
}

/* Set the clientdata field for a type */
SWIGRUNTIME(void)
SWIG_TypeClientData(swig_type_info *ti, void *clientdata) {
  swig_type_info *tc, *equiv;
  if (ti->clientdata == clientdata) return;
  ti->clientdata = clientdata;
  equiv = ti->next;
  while (equiv) {
    if (!equiv->converter) {
      tc = swig_type_list;
      while (tc) {
	if ((strcmp(tc->name, equiv->name) == 0))
	  SWIG_TypeClientData(tc,clientdata);
	tc = tc->prev;
      }
    }
    equiv = equiv->next;
  }
}
#endif

#ifdef __cplusplus
}

#endif

/***********************************************************************
 * python.swg
 *
 *     This file contains the runtime support for Python modules
 *     and includes code for managing global variables and pointer
 *     type checking.
 *
 * Author : David Beazley (beazley@cs.uchicago.edu)
 ************************************************************************/

#include "Python.h"

#ifdef __cplusplus
extern "C" {
#endif

#define SWIG_PY_INT     1
#define SWIG_PY_FLOAT   2
#define SWIG_PY_STRING  3
#define SWIG_PY_POINTER 4
#define SWIG_PY_BINARY  5

/* Flags for pointer conversion */

#define SWIG_POINTER_EXCEPTION     0x1
#define SWIG_POINTER_DISOWN        0x2

/* Exception handling in wrappers */
#define SWIG_fail   goto fail

/* Constant information structure */
typedef struct swig_const_info {
    int type;
    char *name;
    long lvalue;
    double dvalue;
    void   *pvalue;
    swig_type_info **ptype;
} swig_const_info;

#ifdef SWIG_NOINCLUDE

SWIGEXPORT(PyObject *)        SWIG_newvarlink(void);
SWIGEXPORT(void)              SWIG_addvarlink(PyObject *, char *, PyObject *(*)(void), int (*)(PyObject *));
SWIGEXPORT(int)               SWIG_ConvertPtr(PyObject *, void **, swig_type_info *, int);
SWIGEXPORT(int)               SWIG_ConvertPacked(PyObject *, void *, int sz, swig_type_info *, int);
SWIGEXPORT(char *)            SWIG_PackData(char *c, void *, int);
SWIGEXPORT(char *)            SWIG_UnpackData(char *c, void *, int);
SWIGEXPORT(PyObject *)        SWIG_NewPointerObj(void *, swig_type_info *,int own);
SWIGEXPORT(PyObject *)        SWIG_NewPackedObj(void *, int sz, swig_type_info *);
SWIGEXPORT(void)              SWIG_InstallConstants(PyObject *d, swig_const_info constants[]);
#else

/* -----------------------------------------------------------------------------
 * global variable support code.
 * ----------------------------------------------------------------------------- */

typedef struct swig_globalvar {   
  char       *name;                  /* Name of global variable */
  PyObject *(*get_attr)(void);       /* Return the current value */
  int       (*set_attr)(PyObject *); /* Set the value */
  struct swig_globalvar *next;
} swig_globalvar;

typedef struct swig_varlinkobject {
  PyObject_HEAD
  swig_globalvar *vars;
} swig_varlinkobject;

static PyObject *
swig_varlink_repr(swig_varlinkobject *v) {
  v = v;
  return PyString_FromString("<Global variables>");
}

static int
swig_varlink_print(swig_varlinkobject *v, FILE *fp, int flags) {
  swig_globalvar  *var;
  flags = flags;
  fprintf(fp,"Global variables { ");
  for (var = v->vars; var; var=var->next) {
    fprintf(fp,"%s", var->name);
    if (var->next) fprintf(fp,", ");
  }
  fprintf(fp," }\n");
  return 0;
}

static PyObject *
swig_varlink_getattr(swig_varlinkobject *v, char *n) {
  swig_globalvar *var = v->vars;
  while (var) {
    if (strcmp(var->name,n) == 0) {
      return (*var->get_attr)();
    }
    var = var->next;
  }
  PyErr_SetString(PyExc_NameError,"Unknown C global variable");
  return NULL;
}

static int
swig_varlink_setattr(swig_varlinkobject *v, char *n, PyObject *p) {
  swig_globalvar *var = v->vars;
  while (var) {
    if (strcmp(var->name,n) == 0) {
      return (*var->set_attr)(p);
    }
    var = var->next;
  }
  PyErr_SetString(PyExc_NameError,"Unknown C global variable");
  return 1;
}

statichere PyTypeObject varlinktype = {
  PyObject_HEAD_INIT(0)              
  0,
  (char *)"swigvarlink",                      /* Type name    */
  sizeof(swig_varlinkobject),         /* Basic size   */
  0,                                  /* Itemsize     */
  0,                                  /* Deallocator  */ 
  (printfunc) swig_varlink_print,     /* Print        */
  (getattrfunc) swig_varlink_getattr, /* get attr     */
  (setattrfunc) swig_varlink_setattr, /* Set attr     */
  0,                                  /* tp_compare   */
  (reprfunc) swig_varlink_repr,       /* tp_repr      */    
  0,                                  /* tp_as_number */
  0,                                  /* tp_as_mapping*/
  0,                                  /* tp_hash      */
};

/* Create a variable linking object for use later */
SWIGRUNTIME(PyObject *)
SWIG_newvarlink(void) {
  swig_varlinkobject *result = 0;
  result = PyMem_NEW(swig_varlinkobject,1);
  varlinktype.ob_type = &PyType_Type;    /* Patch varlinktype into a PyType */
  result->ob_type = &varlinktype;
  result->vars = 0;
  result->ob_refcnt = 0;
  Py_XINCREF((PyObject *) result);
  return ((PyObject*) result);
}

SWIGRUNTIME(void)
SWIG_addvarlink(PyObject *p, char *name,
	   PyObject *(*get_attr)(void), int (*set_attr)(PyObject *p)) {
  swig_varlinkobject *v;
  swig_globalvar *gv;
  v= (swig_varlinkobject *) p;
  gv = (swig_globalvar *) malloc(sizeof(swig_globalvar));
  gv->name = (char *) malloc(strlen(name)+1);
  strcpy(gv->name,name);
  gv->get_attr = get_attr;
  gv->set_attr = set_attr;
  gv->next = v->vars;
  v->vars = gv;
}

/* Pack binary data into a string */
SWIGRUNTIME(char *)
SWIG_PackData(char *c, void *ptr, int sz) {
  static char hex[17] = "0123456789abcdef";
  int i;
  unsigned char *u = (unsigned char *) ptr;
  register unsigned char uu;
  for (i = 0; i < sz; i++,u++) {
    uu = *u;
    *(c++) = hex[(uu & 0xf0) >> 4];
    *(c++) = hex[uu & 0xf];
  }
  return c;
}

/* Unpack binary data from a string */
SWIGRUNTIME(char *)
SWIG_UnpackData(char *c, void *ptr, int sz) {
  register unsigned char uu = 0;
  register int d;
  unsigned char *u = (unsigned char *) ptr;
  int i;
  for (i = 0; i < sz; i++, u++) {
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu = ((d - '0') << 4);
    else if ((d >= 'a') && (d <= 'f'))
      uu = ((d - ('a'-10)) << 4);
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu |= (d - '0');
    else if ((d >= 'a') && (d <= 'f'))
      uu |= (d - ('a'-10));
    *u = uu;
  }
  return c;
}

/* Convert a pointer value */
SWIGRUNTIME(int)
SWIG_ConvertPtr(PyObject *obj, void **ptr, swig_type_info *ty, int flags) {
  swig_type_info *tc;
  char  *c;
  static PyObject *SWIG_this = 0;
  int    newref = 0;
  PyObject  *pyobj = 0;

  if (!obj) return 0;
  if (obj == Py_None) {
    *ptr = 0;
    return 0;
  }
#ifdef SWIG_COBJECT_TYPES
  if (!(PyCObject_Check(obj))) {
    if (!SWIG_this)
      SWIG_this = PyString_FromString("this");
    pyobj = obj;
    obj = PyObject_GetAttr(obj,SWIG_this);
    newref = 1;
    if (!obj) goto type_error;
    if (!PyCObject_Check(obj)) {
      Py_DECREF(obj);
      goto type_error;
    }
  }  
  *ptr = PyCObject_AsVoidPtr(obj);
  c = (char *) PyCObject_GetDesc(obj);
  if (newref) Py_DECREF(obj);
  goto cobject;
#else
  if (!(PyString_Check(obj))) {
    if (!SWIG_this)
      SWIG_this = PyString_FromString("this");
    pyobj = obj;
    obj = PyObject_GetAttr(obj,SWIG_this);
    newref = 1;
    if (!obj) goto type_error;
    if (!PyString_Check(obj)) {
      Py_DECREF(obj);
      goto type_error;
    }
  } 
  c = PyString_AsString(obj);
  /* Pointer values must start with leading underscore */
  if (*c != '_') {
    *ptr = (void *) 0;
    if (strcmp(c,"NULL") == 0) {
      if (newref) { Py_DECREF(obj); }
      return 0;
    } else {
      if (newref) { Py_DECREF(obj); }
      goto type_error;
    }
  }
  c++;
  c = SWIG_UnpackData(c,ptr,sizeof(void *));
  if (newref) { Py_DECREF(obj); }
#endif

#ifdef SWIG_COBJECT_TYPES
cobject:
#endif

  if (ty) {
    tc = SWIG_TypeCheck(c,ty);
    if (!tc) goto type_error;
    *ptr = SWIG_TypeCast(tc,(void*) *ptr);
  }

  if ((pyobj) && (flags & SWIG_POINTER_DISOWN)) {
      PyObject *zero = PyInt_FromLong(0);
      PyObject_SetAttrString(pyobj,(char*)"thisown",zero);
      Py_DECREF(zero);
  }
  return 0;

type_error:
  if (flags & SWIG_POINTER_EXCEPTION) {
    if (ty) {
      char *temp = (char *) malloc(64+strlen(ty->name));
      sprintf(temp,"Type error. Expected %s", ty->name);
      PyErr_SetString(PyExc_TypeError, temp);
      free((char *) temp);
    } else {
      PyErr_SetString(PyExc_TypeError,"Expected a pointer");
    }
  }
  return -1;
}

/* Convert a packed value value */
SWIGRUNTIME(int)
SWIG_ConvertPacked(PyObject *obj, void *ptr, int sz, swig_type_info *ty, int flags) {
  swig_type_info *tc;
  char  *c;

  if ((!obj) || (!PyString_Check(obj))) goto type_error;
  c = PyString_AsString(obj);
  /* Pointer values must start with leading underscore */
  if (*c != '_') goto type_error;
  c++;
  c = SWIG_UnpackData(c,ptr,sz);
  if (ty) {
    tc = SWIG_TypeCheck(c,ty);
    if (!tc) goto type_error;
  }
  return 0;

type_error:

  if (flags) {
    if (ty) {
      char *temp = (char *) malloc(64+strlen(ty->name));
      sprintf(temp,"Type error. Expected %s", ty->name);
      PyErr_SetString(PyExc_TypeError, temp);
      free((char *) temp);
    } else {
      PyErr_SetString(PyExc_TypeError,"Expected a pointer");
    }
  }
  return -1;
}

/* Create a new pointer object */
SWIGRUNTIME(PyObject *)
SWIG_NewPointerObj(void *ptr, swig_type_info *type, int own) {
  PyObject *robj;
  if (!ptr) {
    Py_INCREF(Py_None);
    return Py_None;
  }
#ifdef SWIG_COBJECT_TYPES
  robj = PyCObject_FromVoidPtrAndDesc((void *) ptr, (char *) type->name, NULL);
#else
  {
    char result[1024];
    char *r = result;
    *(r++) = '_';
    r = SWIG_PackData(r,&ptr,sizeof(void *));
    strcpy(r,type->name);
    robj = PyString_FromString(result);
  }
#endif
  if (!robj || (robj == Py_None)) return robj;
  if (type->clientdata) {
    PyObject *inst;
    PyObject *args = Py_BuildValue((char*)"(O)", robj);
    Py_DECREF(robj);
    inst = PyObject_CallObject((PyObject *) type->clientdata, args);
    Py_DECREF(args);
    if (inst) {
      if (own) {
	PyObject *n = PyInt_FromLong(1);
	PyObject_SetAttrString(inst,(char*)"thisown",n);
	Py_DECREF(n);
      }
      robj = inst;
    }
  }
  return robj;
}

SWIGRUNTIME(PyObject *)
SWIG_NewPackedObj(void *ptr, int sz, swig_type_info *type) {
  char result[1024];
  char *r = result;
  if ((2*sz + 1 + strlen(type->name)) > 1000) return 0;
  *(r++) = '_';
  r = SWIG_PackData(r,ptr,sz);
  strcpy(r,type->name);
  return PyString_FromString(result);
}

/* Install Constants */
SWIGRUNTIME(void)
SWIG_InstallConstants(PyObject *d, swig_const_info constants[]) {
  int i;
  PyObject *obj;
  for (i = 0; constants[i].type; i++) {
    switch(constants[i].type) {
    case SWIG_PY_INT:
      obj = PyInt_FromLong(constants[i].lvalue);
      break;
    case SWIG_PY_FLOAT:
      obj = PyFloat_FromDouble(constants[i].dvalue);
      break;
    case SWIG_PY_STRING:
      obj = PyString_FromString((char *) constants[i].pvalue);
      break;
    case SWIG_PY_POINTER:
      obj = SWIG_NewPointerObj(constants[i].pvalue, *(constants[i]).ptype,0);
      break;
    case SWIG_PY_BINARY:
      obj = SWIG_NewPackedObj(constants[i].pvalue, constants[i].lvalue, *(constants[i].ptype));
      break;
    default:
      obj = 0;
      break;
    }
    if (obj) {
      PyDict_SetItemString(d,constants[i].name,obj);
      Py_DECREF(obj);
    }
  }
}

#endif

#ifdef __cplusplus
}
#endif








/* -------- TYPES TABLE (BEGIN) -------- */

#define  SWIGTYPE_p_librdf_node swig_types[0] 
#define  SWIGTYPE_p_librdf_parser swig_types[1] 
#define  SWIGTYPE_p_librdf_world swig_types[2] 
#define  SWIGTYPE_p_librdf_hash swig_types[3] 
#define  SWIGTYPE_p_librdf_statement swig_types[4] 
#define  SWIGTYPE_p_librdf_iterator swig_types[5] 
#define  SWIGTYPE_p_librdf_storage swig_types[6] 
#define  SWIGTYPE_p_librdf_uri swig_types[7] 
#define  SWIGTYPE_p_librdf_model swig_types[8] 
#define  SWIGTYPE_p_librdf_stream swig_types[9] 
#define  SWIGTYPE_p_librdf_serializer swig_types[10] 
static swig_type_info *swig_types[12];

/* -------- TYPES TABLE (END) -------- */

#define SWIG_init    initRedland

#define SWIG_name    "Redland"


#ifdef SWIGPERL
/* for perl, these are passed in by MakeMaker derived makefile */
#undef PACKAGE
#undef VERSION
#endif

/* SWIG BUG - no SWIGTCL is defined - duh */
#ifdef TCL_MAJOR_VERSION
  /* want symbols starting librdf_ not _librdf_ */
#undef SWIG_prefix
#define SWIG_prefix
#endif

#ifdef SWIGRUBY
/* Ruby pollutes the #define space with these names */
#undef PACKAGE_NAME
#undef PACKAGE_STRING
#undef PACKAGE_TARNAME
#undef PACKAGE_VERSION
#undef PACKAGE_BUGREPORT
#endif

#include <rdf_config.h>
#include <redland.h>

/* Internal prototypes */
/* FOR TESTING ERRORS ONLY - NOT PART OF API */
void librdf_internal_test_error(librdf_world *world);
void librdf_internal_test_warning(librdf_world *world);

#ifdef SWIGPYTHON
void librdf_python_world_init(librdf_world *world);
#endif
#ifdef SWIGPERL
void librdf_perl_world_init(librdf_world *world);
void librdf_perl_world_finish(void);
#endif


/* 
 * Thanks to the patch in this Debian bug for the solution
 * to the crash inside vsnprintf on some architectures.
 *
 * "reuse of args inside the while(1) loop is in violation of the
 * specs and only happens to work by accident on other systems."
 *
 * http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=104325 
 */

#ifndef va_copy
#ifdef __va_copy
#define va_copy(dest,src) __va_copy(dest,src)
#else
#define va_copy(dest,src) (dest) = (src)
#endif
#endif



#ifdef SWIGPYTHON
/* swig doesn't declare all prototypes */
static PyObject *_wrap_librdf_copyright_string_get(void);
static PyObject *_wrap_librdf_version_string_get(void);

static PyObject *_wrap_librdf_version_major_get(void);
static PyObject *_wrap_librdf_version_minor_get(void);
static PyObject *_wrap_librdf_version_release_get(void);


static PyObject *librdf_python_callback = NULL;

static PyObject * librdf_python_set_callback(PyObject *dummy, PyObject *args);

/*
 * set the Python function object callback
 */
static PyObject *
librdf_python_set_callback(dummy, args)
  PyObject *dummy, *args;
{
  PyObject *result = NULL;
  PyObject *temp;
  
  if (PyArg_ParseTuple(args, "O:set_callback", &temp)) {
    if (!PyCallable_Check(temp)) {
      PyErr_SetString(PyExc_TypeError, "parameter must be callable");
      return NULL;
    }
    Py_XINCREF(temp);         /* Add a reference to new callback */
    Py_XDECREF(librdf_python_callback);  /* Dispose of previous callback */
    librdf_python_callback = temp;       /* Remember new callback */
    /* Boilerplate to return "None" */
    Py_INCREF(Py_None);
    result = Py_None;
  }
  return result;
}


/* Declare a table of methods that python can call */
static PyMethodDef librdf_python_methods [] = {
    {"set_callback",  librdf_python_set_callback, METH_VARARGS,
     "Set python message callback."},
    {NULL, NULL, 0, NULL}        /* Sentinel */
};


/*
 * calls a python function defined as:
 *   RDF.message($$)
 * where first argument is an integer, second is a (scalar) string
 */
static void
librdf_call_python_message(int type, const char *message, va_list arguments)
{
  char empty_buffer[1];
#ifdef PYTHON_EXCEPTIONS_WORKING
  PyObject *arglist;
  PyObject *result;
#endif
  char *buffer;
  int len;
  va_list args_copy;

  if(!librdf_python_callback) {
    fprintf(stderr, "librdf_call_python_message: No message callback registered\n");
    return;
  }

  /* ask vsnprintf size of buffer required */
  va_copy(args_copy, arguments);
  len=vsnprintf(empty_buffer, 1, message, args_copy)+1;
  va_end(args_copy);
  buffer=(char*)malloc(len);
  if(!buffer)
    fprintf(stderr, "librdf_call_python_message: Out of memory\n");
  else {
    va_copy(args_copy, arguments);
    vsnprintf(buffer, len, message, args_copy);
    va_end(args_copy);

    if(type == 0) {
#ifdef PYTHON_EXCEPTIONS_WORKING
      PyObject *error = PyErr_NewException("Redland.error", NULL, NULL);
      /* error */
      PyErr_SetString(error, buffer);
#else
      PyErr_Warn(NULL, buffer);
#endif
    } else {
      /* warning */
       PyErr_Warn(NULL, buffer);
    }

#ifdef PYTHON_EXCEPTIONS_WORKING
    /* call the callback */
    arglist = Py_BuildValue("(is)", type, buffer);
    if(!arglist) {
      fprintf(stderr, "librdf_call_python_message: Out of memory\n");
      free(buffer);
      return;
    }
    result = PyEval_CallObject(librdf_python_callback, arglist);
    Py_DECREF(arglist);
    if (result == NULL) {
      free(buffer);
      return;
    }
    
    /* no result */
    Py_DECREF(result);
#endif
    free(buffer);
  }
}

static void
librdf_python_error_handler(void *user_data, 
                            const char *message, va_list arguments)
{
  librdf_call_python_message(0, message, arguments);
}


static void
librdf_python_warning_handler(void *user_data,
                              const char *message, va_list arguments)
{
  librdf_call_python_message(1, message, arguments);
}

void
librdf_python_world_init(librdf_world *world)
{
  (void) Py_InitModule("Redland_python", librdf_python_methods);
  librdf_world_set_error(world, NULL, librdf_python_error_handler);
  librdf_world_set_warning(world,  NULL, librdf_python_warning_handler);
}
 

#endif

#ifdef SWIGPERL
/*
 * calls a perl subroutine defined as:
 *   RDF::Redland::World::message($$)
 * where first argument is an integer, second is a (scalar) string
 */
static void
librdf_call_perl_message(int type, const char *message, va_list arguments)
{
  char empty_buffer[1];
  dSP;
  char *buffer;
  int len;
  va_list args_copy;
  
  ENTER;
  SAVETMPS;

  /* ask vsnprintf size of buffer required */
  va_copy(args_copy, arguments);
  len=vsnprintf(empty_buffer, 1, message, args_copy)+1;
  va_end(args_copy);
  buffer=(char*)malloc(len);
  if(!buffer)
    fprintf(stderr, "librdf_call_perl_message: Out of memory\n");
  else {
    va_copy(args_copy, arguments);
    vsnprintf(buffer, len, message, args_copy);
    va_end(args_copy);

    PUSHMARK(SP) ;
    XPUSHs(sv_2mortal(newSViv(type)));
    XPUSHs(sv_2mortal(newSVpv(buffer, 0)));
    PUTBACK;
  
    call_pv("RDF::Redland::World::message", G_DISCARD);

    free(buffer);
  }
  
  FREETMPS;
  LEAVE;
}

static void
librdf_perl_error_handler(void *user_data, 
                          const char *message, va_list arguments)
{
  librdf_call_perl_message(0, message, arguments);
}


static void
librdf_perl_warning_handler(void *user_data,
                            const char *message, va_list arguments)
{
  librdf_call_perl_message(1, message, arguments);
}

static librdf_world* librdf_perl_world=NULL;

void
librdf_perl_world_init(librdf_world *world)
{
  librdf_world_set_error(world, NULL, librdf_perl_error_handler);
  librdf_world_set_warning(world,  NULL, librdf_perl_warning_handler);

  librdf_perl_world=world;
}

void
librdf_perl_world_finish(void)
{
  librdf_free_world(librdf_perl_world);
}
#endif


/* FOR TESTING ERRORS ONLY - NOT PART OF API */
void
librdf_internal_test_error(librdf_world *world) 
{
  librdf_error(world, "test error message number %d.", 1);
}

void
librdf_internal_test_warning(librdf_world *world) 
{
  librdf_warning(world, "test warning message number %d.", 2);
}


extern char const *const librdf_short_copyright_string;
extern char const *const librdf_copyright_string;
extern char const *const librdf_version_string;
extern unsigned int const librdf_version_major;
extern unsigned int const librdf_version_minor;
extern unsigned int const librdf_version_release;
extern unsigned int const librdf_version_decimal;
#ifdef __cplusplus
extern "C" {
#endif
static PyObject *_wrap_librdf_new_world(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_world *result;
    
    if(!PyArg_ParseTuple(args,(char *)":librdf_new_world")) goto fail;
    result = (librdf_world *)librdf_new_world();
    
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_world, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_free_world(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_world *arg1 = (librdf_world *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:librdf_free_world",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_world,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    librdf_free_world(arg1);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_world_open(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_world *arg1 = (librdf_world *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:librdf_world_open",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_world,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    librdf_world_open(arg1);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_init_world(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    char *arg1 ;
    librdf_hash *arg2 = (librdf_hash *) 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"sO:librdf_init_world",&arg1,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj1,(void **) &arg2, SWIGTYPE_p_librdf_hash,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    librdf_init_world(arg1,arg2);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_destroy_world(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    
    if(!PyArg_ParseTuple(args,(char *)":librdf_destroy_world")) goto fail;
    librdf_destroy_world();
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_free_iterator(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_iterator *arg1 = (librdf_iterator *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:librdf_free_iterator",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_iterator,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    librdf_free_iterator(arg1);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_iterator_have_elements(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_iterator *arg1 = (librdf_iterator *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:librdf_iterator_have_elements",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_iterator,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (int)librdf_iterator_have_elements(arg1);
    
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_iterator_end(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_iterator *arg1 = (librdf_iterator *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:librdf_iterator_end",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_iterator,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (int)librdf_iterator_end(arg1);
    
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_iterator_get_object(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_iterator *arg1 = (librdf_iterator *) 0 ;
    librdf_node *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:librdf_iterator_get_object",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_iterator,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (librdf_node *)librdf_iterator_get_object(arg1);
    
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_node, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_iterator_get_context(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_iterator *arg1 = (librdf_iterator *) 0 ;
    librdf_node *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:librdf_iterator_get_context",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_iterator,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (librdf_node *)librdf_iterator_get_context(arg1);
    
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_node, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_iterator_next(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_iterator *arg1 = (librdf_iterator *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:librdf_iterator_next",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_iterator,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (int)librdf_iterator_next(arg1);
    
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_new_uri(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_world *arg1 = (librdf_world *) 0 ;
    char *arg2 ;
    librdf_uri *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Os:librdf_new_uri",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_world,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (librdf_uri *)librdf_new_uri(arg1,arg2);
    
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_uri, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_new_uri_from_uri(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_uri *arg1 = (librdf_uri *) 0 ;
    librdf_uri *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:librdf_new_uri_from_uri",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_uri,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (librdf_uri *)librdf_new_uri_from_uri(arg1);
    
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_uri, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_new_uri_from_filename(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_world *arg1 = (librdf_world *) 0 ;
    char *arg2 ;
    librdf_uri *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Os:librdf_new_uri_from_filename",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_world,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (librdf_uri *)librdf_new_uri_from_filename(arg1,(char const *)arg2);
    
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_uri, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_free_uri(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_uri *arg1 = (librdf_uri *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:librdf_free_uri",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_uri,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    librdf_free_uri(arg1);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_uri_to_string(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_uri *arg1 = (librdf_uri *) 0 ;
    char *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:librdf_uri_to_string",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_uri,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (char *)librdf_uri_to_string(arg1);
    
    resultobj = result ? PyString_FromString(result) : Py_BuildValue((char*)"");
    free(result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_uri_equals(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_uri *arg1 = (librdf_uri *) 0 ;
    librdf_uri *arg2 = (librdf_uri *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:librdf_uri_equals",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_uri,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **) &arg2, SWIGTYPE_p_librdf_uri,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (int)librdf_uri_equals(arg1,arg2);
    
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_new_node(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_world *arg1 = (librdf_world *) 0 ;
    librdf_node *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:librdf_new_node",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_world,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (librdf_node *)librdf_new_node(arg1);
    
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_node, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_new_node_from_uri_string(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_world *arg1 = (librdf_world *) 0 ;
    char *arg2 ;
    librdf_node *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Os:librdf_new_node_from_uri_string",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_world,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (librdf_node *)librdf_new_node_from_uri_string(arg1,arg2);
    
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_node, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_new_node_from_uri(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_world *arg1 = (librdf_world *) 0 ;
    librdf_uri *arg2 = (librdf_uri *) 0 ;
    librdf_node *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:librdf_new_node_from_uri",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_world,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **) &arg2, SWIGTYPE_p_librdf_uri,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (librdf_node *)librdf_new_node_from_uri(arg1,arg2);
    
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_node, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_new_node_from_literal(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_world *arg1 = (librdf_world *) 0 ;
    char *arg2 ;
    char *arg3 ;
    int arg4 ;
    librdf_node *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Ossi:librdf_new_node_from_literal",&obj0,&arg2,&arg3,&arg4)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_world,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (librdf_node *)librdf_new_node_from_literal(arg1,arg2,arg3,arg4);
    
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_node, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_new_node_from_typed_literal(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_world *arg1 = (librdf_world *) 0 ;
    char *arg2 ;
    char *arg3 ;
    librdf_uri *arg4 = (librdf_uri *) 0 ;
    librdf_node *result;
    PyObject * obj0 = 0 ;
    PyObject * obj3 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OssO:librdf_new_node_from_typed_literal",&obj0,&arg2,&arg3,&obj3)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_world,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj3,(void **) &arg4, SWIGTYPE_p_librdf_uri,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (librdf_node *)librdf_new_node_from_typed_literal(arg1,(char const *)arg2,(char const *)arg3,arg4);
    
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_node, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_new_node_from_node(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_node *arg1 = (librdf_node *) 0 ;
    librdf_node *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:librdf_new_node_from_node",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (librdf_node *)librdf_new_node_from_node(arg1);
    
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_node, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_new_node_from_blank_identifier(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_world *arg1 = (librdf_world *) 0 ;
    char *arg2 ;
    librdf_node *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Os:librdf_new_node_from_blank_identifier",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_world,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (librdf_node *)librdf_new_node_from_blank_identifier(arg1,(char const *)arg2);
    
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_node, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_free_node(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_node *arg1 = (librdf_node *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:librdf_free_node",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    librdf_free_node(arg1);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_node_get_uri(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_node *arg1 = (librdf_node *) 0 ;
    librdf_uri *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:librdf_node_get_uri",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (librdf_uri *)librdf_node_get_uri(arg1);
    
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_uri, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_node_get_type(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_node *arg1 = (librdf_node *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:librdf_node_get_type",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (int)librdf_node_get_type(arg1);
    
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_node_get_literal_value(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_node *arg1 = (librdf_node *) 0 ;
    char *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:librdf_node_get_literal_value",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (char *)librdf_node_get_literal_value(arg1);
    
    resultobj = result ? PyString_FromString(result) : Py_BuildValue((char*)"");
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_node_get_literal_value_as_latin1(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_node *arg1 = (librdf_node *) 0 ;
    char *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:librdf_node_get_literal_value_as_latin1",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (char *)librdf_node_get_literal_value_as_latin1(arg1);
    
    resultobj = result ? PyString_FromString(result) : Py_BuildValue((char*)"");
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_node_get_literal_value_language(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_node *arg1 = (librdf_node *) 0 ;
    char *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:librdf_node_get_literal_value_language",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (char *)librdf_node_get_literal_value_language(arg1);
    
    resultobj = result ? PyString_FromString(result) : Py_BuildValue((char*)"");
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_node_get_literal_value_datatype_uri(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_node *arg1 = (librdf_node *) 0 ;
    librdf_uri *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:librdf_node_get_literal_value_datatype_uri",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (librdf_uri *)librdf_node_get_literal_value_datatype_uri(arg1);
    
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_uri, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_node_get_literal_value_is_wf_xml(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_node *arg1 = (librdf_node *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:librdf_node_get_literal_value_is_wf_xml",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (int)librdf_node_get_literal_value_is_wf_xml(arg1);
    
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_node_to_string(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_node *arg1 = (librdf_node *) 0 ;
    char *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:librdf_node_to_string",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (char *)librdf_node_to_string(arg1);
    
    resultobj = result ? PyString_FromString(result) : Py_BuildValue((char*)"");
    free(result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_node_get_blank_identifier(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_node *arg1 = (librdf_node *) 0 ;
    char *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:librdf_node_get_blank_identifier",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (char *)librdf_node_get_blank_identifier(arg1);
    
    resultobj = result ? PyString_FromString(result) : Py_BuildValue((char*)"");
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_node_is_resource(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_node *arg1 = (librdf_node *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:librdf_node_is_resource",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (int)librdf_node_is_resource(arg1);
    
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_node_is_literal(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_node *arg1 = (librdf_node *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:librdf_node_is_literal",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (int)librdf_node_is_literal(arg1);
    
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_node_is_blank(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_node *arg1 = (librdf_node *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:librdf_node_is_blank",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (int)librdf_node_is_blank(arg1);
    
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_node_equals(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_node *arg1 = (librdf_node *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:librdf_node_equals",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **) &arg2, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (int)librdf_node_equals(arg1,arg2);
    
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_new_statement(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_world *arg1 = (librdf_world *) 0 ;
    librdf_statement *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:librdf_new_statement",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_world,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (librdf_statement *)librdf_new_statement(arg1);
    
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_statement, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_new_statement_from_statement(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_statement *arg1 = (librdf_statement *) 0 ;
    librdf_statement *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:librdf_new_statement_from_statement",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_statement,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (librdf_statement *)librdf_new_statement_from_statement(arg1);
    
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_statement, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_new_statement_from_nodes(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_world *arg1 = (librdf_world *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_node *arg3 = (librdf_node *) 0 ;
    librdf_node *arg4 = (librdf_node *) 0 ;
    librdf_statement *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOO:librdf_new_statement_from_nodes",&obj0,&obj1,&obj2,&obj3)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_world,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **) &arg2, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj2,(void **) &arg3, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj3,(void **) &arg4, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (librdf_statement *)librdf_new_statement_from_nodes(arg1,arg2,arg3,arg4);
    
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_statement, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_free_statement(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_statement *arg1 = (librdf_statement *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:librdf_free_statement",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_statement,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    librdf_free_statement(arg1);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_statement_get_subject(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_statement *arg1 = (librdf_statement *) 0 ;
    librdf_node *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:librdf_statement_get_subject",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_statement,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (librdf_node *)librdf_statement_get_subject(arg1);
    
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_node, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_statement_set_subject(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_statement *arg1 = (librdf_statement *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:librdf_statement_set_subject",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_statement,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **) &arg2, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    librdf_statement_set_subject(arg1,arg2);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_statement_get_predicate(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_statement *arg1 = (librdf_statement *) 0 ;
    librdf_node *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:librdf_statement_get_predicate",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_statement,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (librdf_node *)librdf_statement_get_predicate(arg1);
    
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_node, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_statement_set_predicate(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_statement *arg1 = (librdf_statement *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:librdf_statement_set_predicate",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_statement,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **) &arg2, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    librdf_statement_set_predicate(arg1,arg2);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_statement_get_object(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_statement *arg1 = (librdf_statement *) 0 ;
    librdf_node *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:librdf_statement_get_object",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_statement,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (librdf_node *)librdf_statement_get_object(arg1);
    
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_node, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_statement_set_object(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_statement *arg1 = (librdf_statement *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:librdf_statement_set_object",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_statement,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **) &arg2, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    librdf_statement_set_object(arg1,arg2);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_statement_to_string(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_statement *arg1 = (librdf_statement *) 0 ;
    char *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:librdf_statement_to_string",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_statement,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (char *)librdf_statement_to_string(arg1);
    
    resultobj = result ? PyString_FromString(result) : Py_BuildValue((char*)"");
    free(result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_new_model(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_world *arg1 = (librdf_world *) 0 ;
    librdf_storage *arg2 = (librdf_storage *) 0 ;
    char *arg3 ;
    librdf_model *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOs:librdf_new_model",&obj0,&obj1,&arg3)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_world,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **) &arg2, SWIGTYPE_p_librdf_storage,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (librdf_model *)librdf_new_model(arg1,arg2,arg3);
    
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_model, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_new_model_with_options(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_world *arg1 = (librdf_world *) 0 ;
    librdf_storage *arg2 = (librdf_storage *) 0 ;
    librdf_hash *arg3 = (librdf_hash *) 0 ;
    librdf_model *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:librdf_new_model_with_options",&obj0,&obj1,&obj2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_world,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **) &arg2, SWIGTYPE_p_librdf_storage,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj2,(void **) &arg3, SWIGTYPE_p_librdf_hash,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (librdf_model *)librdf_new_model_with_options(arg1,arg2,arg3);
    
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_model, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_new_model_from_model(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_model *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:librdf_new_model_from_model",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_model,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (librdf_model *)librdf_new_model_from_model(arg1);
    
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_model, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_free_model(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_model *arg1 = (librdf_model *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:librdf_free_model",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_model,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    librdf_free_model(arg1);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_model_size(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_model *arg1 = (librdf_model *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:librdf_model_size",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_model,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (int)librdf_model_size(arg1);
    
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_model_add(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_node *arg3 = (librdf_node *) 0 ;
    librdf_node *arg4 = (librdf_node *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOO:librdf_model_add",&obj0,&obj1,&obj2,&obj3)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_model,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **) &arg2, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj2,(void **) &arg3, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj3,(void **) &arg4, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (int)librdf_model_add(arg1,arg2,arg3,arg4);
    
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_model_add_typed_literal_statement(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_node *arg3 = (librdf_node *) 0 ;
    char *arg4 ;
    char *arg5 ;
    librdf_uri *arg6 = (librdf_uri *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj5 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOssO:librdf_model_add_typed_literal_statement",&obj0,&obj1,&obj2,&arg4,&arg5,&obj5)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_model,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **) &arg2, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj2,(void **) &arg3, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj5,(void **) &arg6, SWIGTYPE_p_librdf_uri,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (int)librdf_model_add_typed_literal_statement(arg1,arg2,arg3,arg4,arg5,arg6);
    
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_model_add_statement(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_statement *arg2 = (librdf_statement *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:librdf_model_add_statement",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_model,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **) &arg2, SWIGTYPE_p_librdf_statement,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (int)librdf_model_add_statement(arg1,arg2);
    
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_model_add_statements(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_stream *arg2 = (librdf_stream *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:librdf_model_add_statements",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_model,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **) &arg2, SWIGTYPE_p_librdf_stream,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (int)librdf_model_add_statements(arg1,arg2);
    
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_model_remove_statement(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_statement *arg2 = (librdf_statement *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:librdf_model_remove_statement",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_model,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **) &arg2, SWIGTYPE_p_librdf_statement,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (int)librdf_model_remove_statement(arg1,arg2);
    
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_model_contains_statement(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_statement *arg2 = (librdf_statement *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:librdf_model_contains_statement",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_model,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **) &arg2, SWIGTYPE_p_librdf_statement,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (int)librdf_model_contains_statement(arg1,arg2);
    
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_model_as_stream(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_stream *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:librdf_model_as_stream",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_model,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (librdf_stream *)librdf_model_as_stream(arg1);
    
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_stream, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_model_serialise(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_stream *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:librdf_model_serialise",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_model,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (librdf_stream *)librdf_model_serialise(arg1);
    
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_stream, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_model_find_statements(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_statement *arg2 = (librdf_statement *) 0 ;
    librdf_stream *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:librdf_model_find_statements",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_model,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **) &arg2, SWIGTYPE_p_librdf_statement,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (librdf_stream *)librdf_model_find_statements(arg1,arg2);
    
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_stream, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_model_get_sources(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_node *arg3 = (librdf_node *) 0 ;
    librdf_iterator *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:librdf_model_get_sources",&obj0,&obj1,&obj2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_model,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **) &arg2, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj2,(void **) &arg3, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (librdf_iterator *)librdf_model_get_sources(arg1,arg2,arg3);
    
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_iterator, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_model_get_arcs(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_node *arg3 = (librdf_node *) 0 ;
    librdf_iterator *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:librdf_model_get_arcs",&obj0,&obj1,&obj2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_model,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **) &arg2, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj2,(void **) &arg3, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (librdf_iterator *)librdf_model_get_arcs(arg1,arg2,arg3);
    
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_iterator, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_model_get_targets(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_node *arg3 = (librdf_node *) 0 ;
    librdf_iterator *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:librdf_model_get_targets",&obj0,&obj1,&obj2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_model,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **) &arg2, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj2,(void **) &arg3, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (librdf_iterator *)librdf_model_get_targets(arg1,arg2,arg3);
    
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_iterator, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_model_get_source(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_node *arg3 = (librdf_node *) 0 ;
    librdf_node *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:librdf_model_get_source",&obj0,&obj1,&obj2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_model,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **) &arg2, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj2,(void **) &arg3, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (librdf_node *)librdf_model_get_source(arg1,arg2,arg3);
    
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_node, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_model_get_arc(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_node *arg3 = (librdf_node *) 0 ;
    librdf_node *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:librdf_model_get_arc",&obj0,&obj1,&obj2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_model,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **) &arg2, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj2,(void **) &arg3, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (librdf_node *)librdf_model_get_arc(arg1,arg2,arg3);
    
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_node, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_model_get_target(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_node *arg3 = (librdf_node *) 0 ;
    librdf_node *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:librdf_model_get_target",&obj0,&obj1,&obj2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_model,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **) &arg2, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj2,(void **) &arg3, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (librdf_node *)librdf_model_get_target(arg1,arg2,arg3);
    
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_node, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_model_context_add_statement(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_statement *arg3 = (librdf_statement *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:librdf_model_context_add_statement",&obj0,&obj1,&obj2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_model,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **) &arg2, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj2,(void **) &arg3, SWIGTYPE_p_librdf_statement,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (int)librdf_model_context_add_statement(arg1,arg2,arg3);
    
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_model_context_add_statements(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_stream *arg3 = (librdf_stream *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:librdf_model_context_add_statements",&obj0,&obj1,&obj2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_model,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **) &arg2, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj2,(void **) &arg3, SWIGTYPE_p_librdf_stream,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (int)librdf_model_context_add_statements(arg1,arg2,arg3);
    
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_model_context_remove_statement(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_statement *arg3 = (librdf_statement *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:librdf_model_context_remove_statement",&obj0,&obj1,&obj2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_model,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **) &arg2, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj2,(void **) &arg3, SWIGTYPE_p_librdf_statement,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (int)librdf_model_context_remove_statement(arg1,arg2,arg3);
    
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_model_context_remove_statements(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:librdf_model_context_remove_statements",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_model,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **) &arg2, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (int)librdf_model_context_remove_statements(arg1,arg2);
    
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_model_context_as_stream(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_stream *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:librdf_model_context_as_stream",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_model,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **) &arg2, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (librdf_stream *)librdf_model_context_as_stream(arg1,arg2);
    
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_stream, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_model_context_serialize(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_stream *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:librdf_model_context_serialize",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_model,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **) &arg2, SWIGTYPE_p_librdf_node,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (librdf_stream *)librdf_model_context_serialize(arg1,arg2);
    
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_stream, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_model_sync(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_model *arg1 = (librdf_model *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:librdf_model_sync",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_model,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    librdf_model_sync(arg1);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_new_storage(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_world *arg1 = (librdf_world *) 0 ;
    char *arg2 ;
    char *arg3 ;
    char *arg4 ;
    librdf_storage *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Osss:librdf_new_storage",&obj0,&arg2,&arg3,&arg4)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_world,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (librdf_storage *)librdf_new_storage(arg1,arg2,arg3,arg4);
    
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_storage, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_new_storage_from_storage(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_storage *arg1 = (librdf_storage *) 0 ;
    librdf_storage *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:librdf_new_storage_from_storage",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_storage,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (librdf_storage *)librdf_new_storage_from_storage(arg1);
    
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_storage, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_free_storage(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_storage *arg1 = (librdf_storage *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:librdf_free_storage",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_storage,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    librdf_free_storage(arg1);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_new_parser(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_world *arg1 = (librdf_world *) 0 ;
    char *arg2 ;
    char *arg3 ;
    librdf_uri *arg4 = (librdf_uri *) 0 ;
    librdf_parser *result;
    PyObject * obj0 = 0 ;
    PyObject * obj3 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OssO:librdf_new_parser",&obj0,&arg2,&arg3,&obj3)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_world,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj3,(void **) &arg4, SWIGTYPE_p_librdf_uri,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (librdf_parser *)librdf_new_parser(arg1,(char const *)arg2,(char const *)arg3,arg4);
    
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_parser, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_free_parser(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_parser *arg1 = (librdf_parser *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:librdf_free_parser",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_parser,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    librdf_free_parser(arg1);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_parser_parse_as_stream(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_parser *arg1 = (librdf_parser *) 0 ;
    librdf_uri *arg2 = (librdf_uri *) 0 ;
    librdf_uri *arg3 = (librdf_uri *) 0 ;
    librdf_stream *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:librdf_parser_parse_as_stream",&obj0,&obj1,&obj2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_parser,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **) &arg2, SWIGTYPE_p_librdf_uri,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj2,(void **) &arg3, SWIGTYPE_p_librdf_uri,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (librdf_stream *)librdf_parser_parse_as_stream(arg1,arg2,arg3);
    
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_stream, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_parser_parse_into_model(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_parser *arg1 = (librdf_parser *) 0 ;
    librdf_uri *arg2 = (librdf_uri *) 0 ;
    librdf_uri *arg3 = (librdf_uri *) 0 ;
    librdf_model *arg4 = (librdf_model *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOO:librdf_parser_parse_into_model",&obj0,&obj1,&obj2,&obj3)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_parser,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **) &arg2, SWIGTYPE_p_librdf_uri,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj2,(void **) &arg3, SWIGTYPE_p_librdf_uri,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj3,(void **) &arg4, SWIGTYPE_p_librdf_model,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (int)librdf_parser_parse_into_model(arg1,arg2,arg3,arg4);
    
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_parser_parse_string_as_stream(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_parser *arg1 = (librdf_parser *) 0 ;
    char *arg2 ;
    librdf_uri *arg3 = (librdf_uri *) 0 ;
    librdf_stream *result;
    PyObject * obj0 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OsO:librdf_parser_parse_string_as_stream",&obj0,&arg2,&obj2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_parser,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj2,(void **) &arg3, SWIGTYPE_p_librdf_uri,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (librdf_stream *)librdf_parser_parse_string_as_stream(arg1,(char const *)arg2,arg3);
    
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_stream, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_parser_parse_string_into_model(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_parser *arg1 = (librdf_parser *) 0 ;
    char *arg2 ;
    librdf_uri *arg3 = (librdf_uri *) 0 ;
    librdf_model *arg4 = (librdf_model *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OsOO:librdf_parser_parse_string_into_model",&obj0,&arg2,&obj2,&obj3)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_parser,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj2,(void **) &arg3, SWIGTYPE_p_librdf_uri,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj3,(void **) &arg4, SWIGTYPE_p_librdf_model,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (int)librdf_parser_parse_string_into_model(arg1,(char const *)arg2,arg3,arg4);
    
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_parser_get_feature(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_parser *arg1 = (librdf_parser *) 0 ;
    librdf_uri *arg2 = (librdf_uri *) 0 ;
    char *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:librdf_parser_get_feature",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_parser,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **) &arg2, SWIGTYPE_p_librdf_uri,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (char *)librdf_parser_get_feature(arg1,arg2);
    
    resultobj = result ? PyString_FromString(result) : Py_BuildValue((char*)"");
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_parser_set_feature(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_parser *arg1 = (librdf_parser *) 0 ;
    librdf_uri *arg2 = (librdf_uri *) 0 ;
    char *arg3 ;
    int result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOs:librdf_parser_set_feature",&obj0,&obj1,&arg3)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_parser,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **) &arg2, SWIGTYPE_p_librdf_uri,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (int)librdf_parser_set_feature(arg1,arg2,(char const *)arg3);
    
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_new_serializer(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_world *arg1 = (librdf_world *) 0 ;
    char *arg2 ;
    char *arg3 ;
    librdf_uri *arg4 = (librdf_uri *) 0 ;
    librdf_serializer *result;
    PyObject * obj0 = 0 ;
    PyObject * obj3 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OssO:librdf_new_serializer",&obj0,&arg2,&arg3,&obj3)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_world,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj3,(void **) &arg4, SWIGTYPE_p_librdf_uri,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (librdf_serializer *)librdf_new_serializer(arg1,(char const *)arg2,(char const *)arg3,arg4);
    
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_serializer, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_free_serializer(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_serializer *arg1 = (librdf_serializer *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:librdf_free_serializer",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_serializer,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    librdf_free_serializer(arg1);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_serializer_serialize_model_to_file(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_serializer *arg1 = (librdf_serializer *) 0 ;
    char *arg2 ;
    librdf_uri *arg3 = (librdf_uri *) 0 ;
    librdf_model *arg4 = (librdf_model *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OsOO:librdf_serializer_serialize_model_to_file",&obj0,&arg2,&obj2,&obj3)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_serializer,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj2,(void **) &arg3, SWIGTYPE_p_librdf_uri,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj3,(void **) &arg4, SWIGTYPE_p_librdf_model,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (int)librdf_serializer_serialize_model_to_file(arg1,(char const *)arg2,arg3,arg4);
    
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_serializer_get_feature(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_serializer *arg1 = (librdf_serializer *) 0 ;
    librdf_uri *arg2 = (librdf_uri *) 0 ;
    char *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:librdf_serializer_get_feature",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_serializer,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **) &arg2, SWIGTYPE_p_librdf_uri,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (char *)librdf_serializer_get_feature(arg1,arg2);
    
    resultobj = result ? PyString_FromString(result) : Py_BuildValue((char*)"");
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_serializer_set_feature(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_serializer *arg1 = (librdf_serializer *) 0 ;
    librdf_uri *arg2 = (librdf_uri *) 0 ;
    char *arg3 ;
    int result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOs:librdf_serializer_set_feature",&obj0,&obj1,&arg3)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_serializer,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **) &arg2, SWIGTYPE_p_librdf_uri,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (int)librdf_serializer_set_feature(arg1,arg2,(char const *)arg3);
    
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_free_stream(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_stream *arg1 = (librdf_stream *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:librdf_free_stream",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_stream,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    librdf_free_stream(arg1);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_stream_end(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_stream *arg1 = (librdf_stream *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:librdf_stream_end",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_stream,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (int)librdf_stream_end(arg1);
    
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_stream_next(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_stream *arg1 = (librdf_stream *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:librdf_stream_next",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_stream,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (int)librdf_stream_next(arg1);
    
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_stream_get_object(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_stream *arg1 = (librdf_stream *) 0 ;
    librdf_statement *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:librdf_stream_get_object",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_stream,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (librdf_statement *)librdf_stream_get_object(arg1);
    
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_statement, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_stream_get_context(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_stream *arg1 = (librdf_stream *) 0 ;
    librdf_node *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:librdf_stream_get_context",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_stream,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (librdf_node *)librdf_stream_get_context(arg1);
    
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_node, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_python_world_init(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_world *arg1 = (librdf_world *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:librdf_python_world_init",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_world,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    librdf_python_world_init(arg1);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_internal_test_error(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_world *arg1 = (librdf_world *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:librdf_internal_test_error",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_world,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    librdf_internal_test_error(arg1);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_librdf_internal_test_warning(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    librdf_world *arg1 = (librdf_world *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:librdf_internal_test_warning",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_librdf_world,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    librdf_internal_test_warning(arg1);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static int _wrap_librdf_short_copyright_string_set(PyObject *_val) {
    PyErr_SetString(PyExc_TypeError,"Variable librdf_short_copyright_string is read-only.");
    return 1;
}


static PyObject *_wrap_librdf_short_copyright_string_get() {
    PyObject *pyobj;
    
    pyobj = librdf_short_copyright_string ? PyString_FromString(librdf_short_copyright_string) : Py_BuildValue((char*)"");
    return pyobj;
}


static int _wrap_librdf_copyright_string_set(PyObject *_val) {
    PyErr_SetString(PyExc_TypeError,"Variable librdf_copyright_string is read-only.");
    return 1;
}


static PyObject *_wrap_librdf_copyright_string_get() {
    PyObject *pyobj;
    
    pyobj = librdf_copyright_string ? PyString_FromString(librdf_copyright_string) : Py_BuildValue((char*)"");
    return pyobj;
}


static int _wrap_librdf_version_string_set(PyObject *_val) {
    PyErr_SetString(PyExc_TypeError,"Variable librdf_version_string is read-only.");
    return 1;
}


static PyObject *_wrap_librdf_version_string_get() {
    PyObject *pyobj;
    
    pyobj = librdf_version_string ? PyString_FromString(librdf_version_string) : Py_BuildValue((char*)"");
    return pyobj;
}


static int _wrap_librdf_version_major_set(PyObject *_val) {
    PyErr_SetString(PyExc_TypeError,"Variable librdf_version_major is read-only.");
    return 1;
}


static PyObject *_wrap_librdf_version_major_get() {
    PyObject *pyobj;
    
    pyobj = PyInt_FromLong((long)librdf_version_major);
    return pyobj;
}


static int _wrap_librdf_version_minor_set(PyObject *_val) {
    PyErr_SetString(PyExc_TypeError,"Variable librdf_version_minor is read-only.");
    return 1;
}


static PyObject *_wrap_librdf_version_minor_get() {
    PyObject *pyobj;
    
    pyobj = PyInt_FromLong((long)librdf_version_minor);
    return pyobj;
}


static int _wrap_librdf_version_release_set(PyObject *_val) {
    PyErr_SetString(PyExc_TypeError,"Variable librdf_version_release is read-only.");
    return 1;
}


static PyObject *_wrap_librdf_version_release_get() {
    PyObject *pyobj;
    
    pyobj = PyInt_FromLong((long)librdf_version_release);
    return pyobj;
}


static int _wrap_librdf_version_decimal_set(PyObject *_val) {
    PyErr_SetString(PyExc_TypeError,"Variable librdf_version_decimal is read-only.");
    return 1;
}


static PyObject *_wrap_librdf_version_decimal_get() {
    PyObject *pyobj;
    
    pyobj = PyInt_FromLong((long)librdf_version_decimal);
    return pyobj;
}


static PyMethodDef SwigMethods[] = {
	 { (char *)"librdf_new_world", _wrap_librdf_new_world, METH_VARARGS },
	 { (char *)"librdf_free_world", _wrap_librdf_free_world, METH_VARARGS },
	 { (char *)"librdf_world_open", _wrap_librdf_world_open, METH_VARARGS },
	 { (char *)"librdf_init_world", _wrap_librdf_init_world, METH_VARARGS },
	 { (char *)"librdf_destroy_world", _wrap_librdf_destroy_world, METH_VARARGS },
	 { (char *)"librdf_free_iterator", _wrap_librdf_free_iterator, METH_VARARGS },
	 { (char *)"librdf_iterator_have_elements", _wrap_librdf_iterator_have_elements, METH_VARARGS },
	 { (char *)"librdf_iterator_end", _wrap_librdf_iterator_end, METH_VARARGS },
	 { (char *)"librdf_iterator_get_object", _wrap_librdf_iterator_get_object, METH_VARARGS },
	 { (char *)"librdf_iterator_get_context", _wrap_librdf_iterator_get_context, METH_VARARGS },
	 { (char *)"librdf_iterator_next", _wrap_librdf_iterator_next, METH_VARARGS },
	 { (char *)"librdf_new_uri", _wrap_librdf_new_uri, METH_VARARGS },
	 { (char *)"librdf_new_uri_from_uri", _wrap_librdf_new_uri_from_uri, METH_VARARGS },
	 { (char *)"librdf_new_uri_from_filename", _wrap_librdf_new_uri_from_filename, METH_VARARGS },
	 { (char *)"librdf_free_uri", _wrap_librdf_free_uri, METH_VARARGS },
	 { (char *)"librdf_uri_to_string", _wrap_librdf_uri_to_string, METH_VARARGS },
	 { (char *)"librdf_uri_equals", _wrap_librdf_uri_equals, METH_VARARGS },
	 { (char *)"librdf_new_node", _wrap_librdf_new_node, METH_VARARGS },
	 { (char *)"librdf_new_node_from_uri_string", _wrap_librdf_new_node_from_uri_string, METH_VARARGS },
	 { (char *)"librdf_new_node_from_uri", _wrap_librdf_new_node_from_uri, METH_VARARGS },
	 { (char *)"librdf_new_node_from_literal", _wrap_librdf_new_node_from_literal, METH_VARARGS },
	 { (char *)"librdf_new_node_from_typed_literal", _wrap_librdf_new_node_from_typed_literal, METH_VARARGS },
	 { (char *)"librdf_new_node_from_node", _wrap_librdf_new_node_from_node, METH_VARARGS },
	 { (char *)"librdf_new_node_from_blank_identifier", _wrap_librdf_new_node_from_blank_identifier, METH_VARARGS },
	 { (char *)"librdf_free_node", _wrap_librdf_free_node, METH_VARARGS },
	 { (char *)"librdf_node_get_uri", _wrap_librdf_node_get_uri, METH_VARARGS },
	 { (char *)"librdf_node_get_type", _wrap_librdf_node_get_type, METH_VARARGS },
	 { (char *)"librdf_node_get_literal_value", _wrap_librdf_node_get_literal_value, METH_VARARGS },
	 { (char *)"librdf_node_get_literal_value_as_latin1", _wrap_librdf_node_get_literal_value_as_latin1, METH_VARARGS },
	 { (char *)"librdf_node_get_literal_value_language", _wrap_librdf_node_get_literal_value_language, METH_VARARGS },
	 { (char *)"librdf_node_get_literal_value_datatype_uri", _wrap_librdf_node_get_literal_value_datatype_uri, METH_VARARGS },
	 { (char *)"librdf_node_get_literal_value_is_wf_xml", _wrap_librdf_node_get_literal_value_is_wf_xml, METH_VARARGS },
	 { (char *)"librdf_node_to_string", _wrap_librdf_node_to_string, METH_VARARGS },
	 { (char *)"librdf_node_get_blank_identifier", _wrap_librdf_node_get_blank_identifier, METH_VARARGS },
	 { (char *)"librdf_node_is_resource", _wrap_librdf_node_is_resource, METH_VARARGS },
	 { (char *)"librdf_node_is_literal", _wrap_librdf_node_is_literal, METH_VARARGS },
	 { (char *)"librdf_node_is_blank", _wrap_librdf_node_is_blank, METH_VARARGS },
	 { (char *)"librdf_node_equals", _wrap_librdf_node_equals, METH_VARARGS },
	 { (char *)"librdf_new_statement", _wrap_librdf_new_statement, METH_VARARGS },
	 { (char *)"librdf_new_statement_from_statement", _wrap_librdf_new_statement_from_statement, METH_VARARGS },
	 { (char *)"librdf_new_statement_from_nodes", _wrap_librdf_new_statement_from_nodes, METH_VARARGS },
	 { (char *)"librdf_free_statement", _wrap_librdf_free_statement, METH_VARARGS },
	 { (char *)"librdf_statement_get_subject", _wrap_librdf_statement_get_subject, METH_VARARGS },
	 { (char *)"librdf_statement_set_subject", _wrap_librdf_statement_set_subject, METH_VARARGS },
	 { (char *)"librdf_statement_get_predicate", _wrap_librdf_statement_get_predicate, METH_VARARGS },
	 { (char *)"librdf_statement_set_predicate", _wrap_librdf_statement_set_predicate, METH_VARARGS },
	 { (char *)"librdf_statement_get_object", _wrap_librdf_statement_get_object, METH_VARARGS },
	 { (char *)"librdf_statement_set_object", _wrap_librdf_statement_set_object, METH_VARARGS },
	 { (char *)"librdf_statement_to_string", _wrap_librdf_statement_to_string, METH_VARARGS },
	 { (char *)"librdf_new_model", _wrap_librdf_new_model, METH_VARARGS },
	 { (char *)"librdf_new_model_with_options", _wrap_librdf_new_model_with_options, METH_VARARGS },
	 { (char *)"librdf_new_model_from_model", _wrap_librdf_new_model_from_model, METH_VARARGS },
	 { (char *)"librdf_free_model", _wrap_librdf_free_model, METH_VARARGS },
	 { (char *)"librdf_model_size", _wrap_librdf_model_size, METH_VARARGS },
	 { (char *)"librdf_model_add", _wrap_librdf_model_add, METH_VARARGS },
	 { (char *)"librdf_model_add_typed_literal_statement", _wrap_librdf_model_add_typed_literal_statement, METH_VARARGS },
	 { (char *)"librdf_model_add_statement", _wrap_librdf_model_add_statement, METH_VARARGS },
	 { (char *)"librdf_model_add_statements", _wrap_librdf_model_add_statements, METH_VARARGS },
	 { (char *)"librdf_model_remove_statement", _wrap_librdf_model_remove_statement, METH_VARARGS },
	 { (char *)"librdf_model_contains_statement", _wrap_librdf_model_contains_statement, METH_VARARGS },
	 { (char *)"librdf_model_as_stream", _wrap_librdf_model_as_stream, METH_VARARGS },
	 { (char *)"librdf_model_serialise", _wrap_librdf_model_serialise, METH_VARARGS },
	 { (char *)"librdf_model_find_statements", _wrap_librdf_model_find_statements, METH_VARARGS },
	 { (char *)"librdf_model_get_sources", _wrap_librdf_model_get_sources, METH_VARARGS },
	 { (char *)"librdf_model_get_arcs", _wrap_librdf_model_get_arcs, METH_VARARGS },
	 { (char *)"librdf_model_get_targets", _wrap_librdf_model_get_targets, METH_VARARGS },
	 { (char *)"librdf_model_get_source", _wrap_librdf_model_get_source, METH_VARARGS },
	 { (char *)"librdf_model_get_arc", _wrap_librdf_model_get_arc, METH_VARARGS },
	 { (char *)"librdf_model_get_target", _wrap_librdf_model_get_target, METH_VARARGS },
	 { (char *)"librdf_model_context_add_statement", _wrap_librdf_model_context_add_statement, METH_VARARGS },
	 { (char *)"librdf_model_context_add_statements", _wrap_librdf_model_context_add_statements, METH_VARARGS },
	 { (char *)"librdf_model_context_remove_statement", _wrap_librdf_model_context_remove_statement, METH_VARARGS },
	 { (char *)"librdf_model_context_remove_statements", _wrap_librdf_model_context_remove_statements, METH_VARARGS },
	 { (char *)"librdf_model_context_as_stream", _wrap_librdf_model_context_as_stream, METH_VARARGS },
	 { (char *)"librdf_model_context_serialize", _wrap_librdf_model_context_serialize, METH_VARARGS },
	 { (char *)"librdf_model_sync", _wrap_librdf_model_sync, METH_VARARGS },
	 { (char *)"librdf_new_storage", _wrap_librdf_new_storage, METH_VARARGS },
	 { (char *)"librdf_new_storage_from_storage", _wrap_librdf_new_storage_from_storage, METH_VARARGS },
	 { (char *)"librdf_free_storage", _wrap_librdf_free_storage, METH_VARARGS },
	 { (char *)"librdf_new_parser", _wrap_librdf_new_parser, METH_VARARGS },
	 { (char *)"librdf_free_parser", _wrap_librdf_free_parser, METH_VARARGS },
	 { (char *)"librdf_parser_parse_as_stream", _wrap_librdf_parser_parse_as_stream, METH_VARARGS },
	 { (char *)"librdf_parser_parse_into_model", _wrap_librdf_parser_parse_into_model, METH_VARARGS },
	 { (char *)"librdf_parser_parse_string_as_stream", _wrap_librdf_parser_parse_string_as_stream, METH_VARARGS },
	 { (char *)"librdf_parser_parse_string_into_model", _wrap_librdf_parser_parse_string_into_model, METH_VARARGS },
	 { (char *)"librdf_parser_get_feature", _wrap_librdf_parser_get_feature, METH_VARARGS },
	 { (char *)"librdf_parser_set_feature", _wrap_librdf_parser_set_feature, METH_VARARGS },
	 { (char *)"librdf_new_serializer", _wrap_librdf_new_serializer, METH_VARARGS },
	 { (char *)"librdf_free_serializer", _wrap_librdf_free_serializer, METH_VARARGS },
	 { (char *)"librdf_serializer_serialize_model_to_file", _wrap_librdf_serializer_serialize_model_to_file, METH_VARARGS },
	 { (char *)"librdf_serializer_get_feature", _wrap_librdf_serializer_get_feature, METH_VARARGS },
	 { (char *)"librdf_serializer_set_feature", _wrap_librdf_serializer_set_feature, METH_VARARGS },
	 { (char *)"librdf_free_stream", _wrap_librdf_free_stream, METH_VARARGS },
	 { (char *)"librdf_stream_end", _wrap_librdf_stream_end, METH_VARARGS },
	 { (char *)"librdf_stream_next", _wrap_librdf_stream_next, METH_VARARGS },
	 { (char *)"librdf_stream_get_object", _wrap_librdf_stream_get_object, METH_VARARGS },
	 { (char *)"librdf_stream_get_context", _wrap_librdf_stream_get_context, METH_VARARGS },
	 { (char *)"librdf_python_world_init", _wrap_librdf_python_world_init, METH_VARARGS },
	 { (char *)"librdf_internal_test_error", _wrap_librdf_internal_test_error, METH_VARARGS },
	 { (char *)"librdf_internal_test_warning", _wrap_librdf_internal_test_warning, METH_VARARGS },
	 { NULL, NULL }
};


/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (BEGIN) -------- */

static swig_type_info _swigt__p_librdf_node[] = {{"_p_librdf_node", 0, "librdf_node *", 0},{"_p_librdf_node"},{0}};
static swig_type_info _swigt__p_librdf_parser[] = {{"_p_librdf_parser", 0, "librdf_parser *", 0},{"_p_librdf_parser"},{0}};
static swig_type_info _swigt__p_librdf_world[] = {{"_p_librdf_world", 0, "librdf_world *", 0},{"_p_librdf_world"},{0}};
static swig_type_info _swigt__p_librdf_hash[] = {{"_p_librdf_hash", 0, "librdf_hash *", 0},{"_p_librdf_hash"},{0}};
static swig_type_info _swigt__p_librdf_statement[] = {{"_p_librdf_statement", 0, "librdf_statement *", 0},{"_p_librdf_statement"},{0}};
static swig_type_info _swigt__p_librdf_iterator[] = {{"_p_librdf_iterator", 0, "librdf_iterator *", 0},{"_p_librdf_iterator"},{0}};
static swig_type_info _swigt__p_librdf_storage[] = {{"_p_librdf_storage", 0, "librdf_storage *", 0},{"_p_librdf_storage"},{0}};
static swig_type_info _swigt__p_librdf_uri[] = {{"_p_librdf_uri", 0, "librdf_uri *", 0},{"_p_librdf_uri"},{0}};
static swig_type_info _swigt__p_librdf_model[] = {{"_p_librdf_model", 0, "librdf_model *", 0},{"_p_librdf_model"},{0}};
static swig_type_info _swigt__p_librdf_stream[] = {{"_p_librdf_stream", 0, "librdf_stream *", 0},{"_p_librdf_stream"},{0}};
static swig_type_info _swigt__p_librdf_serializer[] = {{"_p_librdf_serializer", 0, "librdf_serializer *", 0},{"_p_librdf_serializer"},{0}};

static swig_type_info *swig_types_initial[] = {
_swigt__p_librdf_node, 
_swigt__p_librdf_parser, 
_swigt__p_librdf_world, 
_swigt__p_librdf_hash, 
_swigt__p_librdf_statement, 
_swigt__p_librdf_iterator, 
_swigt__p_librdf_storage, 
_swigt__p_librdf_uri, 
_swigt__p_librdf_model, 
_swigt__p_librdf_stream, 
_swigt__p_librdf_serializer, 
0
};


/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (END) -------- */

static swig_const_info swig_const_table[] = {
{0}};

#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C"
#endif
SWIGEXPORT(void) SWIG_init(void) {
    static PyObject *SWIG_globals = 0; 
    static int       typeinit = 0;
    PyObject *m, *d;
    int       i;
    if (!SWIG_globals) SWIG_globals = SWIG_newvarlink();
    m = Py_InitModule((char *) SWIG_name, SwigMethods);
    d = PyModule_GetDict(m);
    
    if (!typeinit) {
        for (i = 0; swig_types_initial[i]; i++) {
            swig_types[i] = SWIG_TypeRegister(swig_types_initial[i]);
        }
        typeinit = 1;
    }
    SWIG_InstallConstants(d,swig_const_table);
    
    
    #ifdef TCL_MAJOR_VERSION
    Tcl_PkgProvide(interp, PACKAGE, (char*)librdf_version_string);
    #endif
    
    PyDict_SetItemString(d,(char*)"cvar", SWIG_globals);
    SWIG_addvarlink(SWIG_globals,(char*)"librdf_short_copyright_string",_wrap_librdf_short_copyright_string_get, _wrap_librdf_short_copyright_string_set);
    SWIG_addvarlink(SWIG_globals,(char*)"librdf_copyright_string",_wrap_librdf_copyright_string_get, _wrap_librdf_copyright_string_set);
    SWIG_addvarlink(SWIG_globals,(char*)"librdf_version_string",_wrap_librdf_version_string_get, _wrap_librdf_version_string_set);
    SWIG_addvarlink(SWIG_globals,(char*)"librdf_version_major",_wrap_librdf_version_major_get, _wrap_librdf_version_major_set);
    SWIG_addvarlink(SWIG_globals,(char*)"librdf_version_minor",_wrap_librdf_version_minor_get, _wrap_librdf_version_minor_set);
    SWIG_addvarlink(SWIG_globals,(char*)"librdf_version_release",_wrap_librdf_version_release_get, _wrap_librdf_version_release_set);
    SWIG_addvarlink(SWIG_globals,(char*)"librdf_version_decimal",_wrap_librdf_version_decimal_get, _wrap_librdf_version_decimal_set);
}

