#
# Fake MakeMaker Makefile.PL - top level Makefile.PL for Redland
#
# $Id: Makefile.PL,v 1.2 2003/09/03 14:52:10 cmdjb Exp $
#
# Copyright (C) 2001-2003 David Beckett - http://purl.org/net/dajobe/
# Institute for Learning and Research Technology - http://www.ilrt.org/
# University of Bristol - http://www.bristol.ac.uk/
# 
# This package is Free Software or Open Source available under the
# following licenses (these are alternatives):
#   1. GNU Lesser General Public License (LGPL)
#   2. GNU General Public License (GPL)
#   3. Mozilla Public License (MPL)
# 
# See LICENSE.html or LICENSE.txt at the top of this package for the
# full license terms.
# 
# 

require 5.6.0;
use File::Basename;
use Config;

my $program=basename $0;

# Inspired by the way that ePerl does its configuration of perl.
# See http://www.engelschall.com/sw/eperl/
#
# There are many makefiles :) and this is their story
#   Makefile.am Makefile.in - GNU automake, autoconf source files
#     which generate Makefile after ./configure is run
#   Makefile.PL - this file runs ./configure and renames
#     the autoconfigure-made top level makefile Makefile to
#     Makefile.stand and then uses it to do the top level build of
#     Redland.
#   Makefile.stand - autoconfigure-made makefile, renamed as described above
#   Makefile - created by this script.  A skeleton makefile that
#     calls either the GNU autoconfigure-made top-level
#     Makefile.stand or one of the makefiles in the perl directory.
#     OR if this perl script isn't run, remains the top-level
#     autoconfigure-made generated makefile built from
#     Makefile.am/Makefile.in after substitution.
#   perl/Makefile - autoconfigure made makefile for building the Redland
#     perl interface inside Redland. Calls perl/Makefile.PL to create
#     perl/Makefile.perl via the usual perl MakeMaker.
#   perl/Makefile.perl - makefile built by perl/Makefile.PL using MakeMaker
#   perl/Makefile.PL - MakeMaker source file for Redland perl interface
#
# All clear now?
#

$TOP_SRCDIR=$ENV{TOP_SRCDIR} || '.';
$PACKAGE=$ENV{PACKAGE} || "Redland";

my $version=$ENV{VERSION};

if(!$version) {
  my $conf_in_file="$TOP_SRCDIR/configure.ac";
  open(CONF, $conf_in_file) or die "Cannot open $conf_in_file for version - $!\n";
  my $v;
  while(<CONF>) {
    if(/LIBRDF_VERSION_(MAJOR|MINOR|RELEASE)=(\d+)$/) {
      $v{$1}=$2;
    }
  }
  close(CONF);
  $version=join(".",$v{MAJOR}, $v{MINOR}, $v{RELEASE});
  die "Cannot find AM_INIT_AUTOMAKE in $conf_in_file for version\n"
    unless $version;
}


my $perl_makefile="Makefile";
my $standalone_makefile="Makefile.stand";

unlink "$TOP_SRCDIR/$perl_makefile";
unlink "$TOP_SRCDIR/$standalone_makefile";

my $perl = $Config{perlpath};

my $prefix = $Config{prefix};

my $cc = $Config{cc};
my $ccarg = "";
if ($args =~ m|CC=(\S+)|) {
  $cc = $1;
  $ccarg = "CC=$1 ";
}

open(MK, ">$TOP_SRCDIR/$perl_makefile") 
  or die "Cannot create $TOP_SRCDIR/$perl_makefile - $!";

print MK <<"EOM";
# Fake MakeMaker-compatible generated Makefile
# Generated automatically by $program
# DO NOT EDIT THIS FILE - changes will be lost
# To rebuild this makefile, run $perl $program with no arguments
#

DISTNAME = $PACKAGE
VERSION = $version

SHELL = /bin/sh
NOOP = \$(SHELL) -c true
RM_RF = rm -rf

DISTVNAME = \$(DISTNAME)-\$(VERSION)
TAR  = tar
TARFLAGS = cvf
ZIP  = zip
ZIPFLAGS = -r
COMPRESS = gzip --best
SUFFIX = .gz
SHAR = shar
PREOP = @\$(NOOP)
POSTOP = @\$(NOOP)
TO_UNIX = @\$(NOOP)
CI = ci -u
DIST_CP = best
DIST_DEFAULT = tardist


# MakeMaker target
all: config

# MakeMaker target
config:
	\@if [ ! -f ${standalone_makefile} ]; then \\
	  cp ${perl_makefile} Makefile.perl; \\
	  echo "${ccarg}PERL=$perl ./configure --prefix=$prefix"; \\
	  ${ccarg}PERL=$perl ./configure --prefix=$prefix; \\
	  cp Makefile ${standalone_makefile}; \\
	  cp Makefile.perl ${perl_makefile}; \\
	  rm Makefile.perl; \\
	  echo \$(MAKE) -f ${standalone_makefile}; \\
	  \$(MAKE) -f ${standalone_makefile}; \\
	fi
	\@if [ ! -f perl/Makefile.perl ]; then \\
	  echo "cd perl"; \\
	  cd perl; \\
	  echo "\$(MAKE) \$(MFLAGS) Makefile.perl"; \\
	  \$(MAKE) \$(MFLAGS) Makefile.perl; \\
	  echo "\$(MAKE) \$(MFLAGS) -f Makefile.perl all"; \\
	  \$(MAKE) \$(MFLAGS) -f Makefile.perl all; \\
	fi

# MakeMaker targets
test: config
	cd perl && \$(MAKE) \$(MFLAGS) -f Makefile.perl \$@

install: config
	\@if [ -f ${standalone_makefile} ]; then \\
	  cd raptor && \$(MAKE) \$(MFLAGS) install-libLTLIBRARIES; cd ..; \\
	  cd librdf && \$(MAKE) \$(MFLAGS) install-libLTLIBRARIES; cd ..; \\
	fi
	cd perl && \$(MAKE) \$(MFLAGS) -f Makefile.perl \$@

# MakeMaker target
clean:
	\@if [ -f ${standalone_makefile} ]; then \\
	  echo \$(MAKE) -k \$(MFLAGS) -f ${standalone_makefile} \$@; \\
	  (\$(MAKE) -k \$(MFLAGS) -f ${standalone_makefile} \$@; exit 0; ); \\
	fi
	\@if [ -f perl/Makefile.perl ]; then \\
	  echo "cd perl"; \\
	  cd perl; \\
	  echo "\$(MAKE) \$(MFLAGS) \$@\-perl"; \\
	  \$(MAKE) \$(MFLAGS) \$\@-perl; \\
	fi

# MakeMaker/GNU target
distclean:
	\$(MAKE) \$(MFLAGS) -f ${standalone_makefile} distclean
	cd perl && \$(MAKE) \$(MFLAGS) realclean-perl
	-rm -f ${standalone_makefile}
	-rm -f ${perl_makefile}

# Rebuild this generated makefile when the source file changes
Makefile: Makefile.PL
	${perl} Makefile.PL

# MakeMaker[dist]/GNU targets
# Pass on some targets to GNU autoconfigured makefile in order
# so that 'make [all]' and 'make dist' work
all-recursive all-am dist dist-hook: config
	\$(MAKE) \$(MFLAGS) -f ${standalone_makefile} \$@


# MakeMaker targets
distcheck:
	${perl} -MExtUtils::Manifest=fullcheck -e fullcheck

skipcheck:
	${perl} -MExtUtils::Manifest=skipcheck -e skipcheck

manifest: MANIFEST

# MakeMaker dist_dir section:
perl-distdir: MANIFEST
	rm -rf \$(DISTVNAME)
	$perl -MExtUtils::Manifest=manicopy,maniread \\
		-e "manicopy(maniread(),'\$(DISTVNAME)', '\$(DIST_CP)');"

tardist : \$(DISTVNAME).tar\$(SUFFIX)

zipdist : \$(DISTVNAME).zip

\$(DISTVNAME).tar\$(SUFFIX) : perl-distdir
	\$(PREOP)
	\$(TO_UNIX)
	\$(TAR) \$(TARFLAGS) \$(DISTVNAME).tar \$(DISTVNAME)
	\$(RM_RF) \$(DISTVNAME)
	\$(COMPRESS) \$(DISTVNAME).tar
	\$(POSTOP)

\$(DISTVNAME).zip : perl-distdir
	\$(PREOP)
	\$(ZIP) \$(ZIPFLAGS) \$(DISTVNAME).zip \$(DISTVNAME)
	\$(RM_RF) \$(DISTVNAME)
	\$(POSTOP)

EOM
close(MK)
