# $Id: LHA.pm,v 1.9 2003/03/31 06:06:35 bengen Exp $

#
# Module for extracting LHA files
#

package AMAVIS::Extract::LHA;
use strict;
use vars qw($VERSION);
$VERSION='0.1';

use AMAVIS;
use AMAVIS::Logging;

use vars qw(
	    $cfg_lha_binary
	   );

sub init {
  my $self = shift;
  my $args = shift;
  my $types = shift;
  $cfg_lha_binary=($AMAVIS::cfg->val('external', 'lha') || '/usr/bin/lha');
  if (! -x  $cfg_lha_binary) {
    writelog($args,LOG_CRIT, __PACKAGE__.
	     ": lha binary ($cfg_lha_binary) not executable");
    return 0;
  }
  $$types{'application/x-lha'}=$self;
  writelog($args,LOG_DEBUG,__PACKAGE__." initialized.");
  return 1;
}

sub extract {
  my $self = shift;
  my $args = shift;
  my $filename = shift;
  my $unpacked_size = 0;
  my @lha_filenames;

  writelog($args,LOG_DEBUG, "Attempting to unpack $filename as LHA file");

  # Determine contents of archive...
  # This is safe. No filenames specified from outside
  my @list;
  my $output_handle = cmd_pipe($args, $cfg_lha_binary, 'lq',
			       "$$args{'directory'}/parts/$filename");
  while (<$output_handle>) {
    chop;
    my @vals = split(/\ \ */);
    # Put filenames into hash, leave directories out.
    push(@lha_filenames, $vals[7]) unless ($vals[7] =~ /.*\/$/);
  }
  wait;

  foreach (@lha_filenames) {
    if ($$args{'unpacked_files'}++ > $cfg_maxfiles) {
      writelog($args,LOG_ERR, __PACKAGE__.": Unpacking uses too many files");
      return 0;
    }

    my $in_handle=cmd_pipe($args, $cfg_lha_binary,
			   'pq',
			   "$$args{'directory'}/parts/$filename",
			   $_);

    my $securename=get_secure_filename($args);
    my $out_handle=IO::File->new(">$$args{'directory'}/parts/"
				 .$securename);
    while (my $len=$in_handle->read(my $buffer, 4096)) {
      $out_handle->write($buffer, $len);
      $unpacked_size += $len;
      if ($$args{'unpacked_size'} + $unpacked_size >= $cfg_maxspace) {
	$in_handle->close();
	$out_handle->close();
	writelog($args,LOG_ERR, __PACKAGE__.": Unpacking takes too much space");
	return 0;
      }
    }
    $in_handle->close();
    $out_handle->close();
    $ {$$args{'contents'}}{$securename} = {'original_filename' => $_};
    $ {$ {$$args{'contents'}}{$securename}}{insecure_type}='';
  }
  $$args{'unpacked_size'} += $unpacked_size;
  return 1;
}

1;
