# $Id: Sophie.pm,v 1.4 2002/08/04 21:19:57 bengen Exp $

#
# Module for Sophie daemon
#

package AMAVIS::AV::Sophie;
use strict;

use vars qw($VERSION);
$VERSION='0.1';

use AMAVIS;
use AMAVIS::Logging;
use IO::Socket;

use vars qw(
	    $cfg_sophie_socket
	   );

sub init {
  my $self = shift;
  my $args = shift;
  push @{$$args{'virus_scanners'}}, 'Sophie';

  $cfg_sophie_socket=$AMAVIS::cfg->val('Sophie', 'socket');
  if (! defined $cfg_sophie_socket) {
    writelog($args,LOG_CRIT, __PACKAGE__.": Sophie socket not specified");
    return 0;
  }

  writelog($args,LOG_DEBUG,__PACKAGE__." initialized.\n");
  # Return successfully
  return 1;
}

# Called from AMAVIS.pm. Scanning takes place here.
sub scan {
  my $self = shift;
  my $args = shift;

  my $socket=IO::Socket::UNIX->new(Peer=>$cfg_sophie_socket);
  if (!defined $socket) {
    writelog($args,LOG_CRIT, __PACKAGE__.
	     ": Cannot connect to $cfg_sophie_socket.");
    return 0;
  }

  my $path="$$args{directory}/parts\n";
  $socket->syswrite($path, length($path)) or do {
    writelog($args,LOG_ERR, __PACKAGE__.": Write to socket failed.");
    return 0;
  };

  my $output;
  my $result=$socket->sysread($output, 256);
  unless ($result) {
    writelog($args,LOG_ERR, __PACKAGE__.": Read from socket failed.");
    return 0;
  }
  $socket->close() or do {
    writelog($args,LOG_ERR, __PACKAGE__.": Closing socket failed");
    return 0;
  };

  my @virusname;
  if ($output =~ m/^1/) {
    if ($output =~ m/^1:.*$/) {
      @virusname = ($output =~ m/^1:'?(.*)'?$/g);
    }
    @virusname = (undef)  if !@virusname;  # just in case: make list nonnil
    writelog($args,LOG_DEBUG, __PACKAGE__.
	     ": Virus(es) found.".join(',',@virusname));
    my %uniq;
    foreach my $virus (@virusname) {
      unless($uniq{$virus}++) {
	push @{$$args{'found_viruses'}{'Sophie'}}, $virus;
      }
    }
  } elsif ($output == 0) {
    writelog($args,LOG_DEBUG, __PACKAGE__.": No virusses found");
  } elsif ($output == -1) {
    writelog($args,LOG_ERR,__PACKAGE__.": Unknown virus scanner failure: $output");
    return 0;
  } else {
    writelog($args,LOG_ERR, __PACKAGE__.\
	     ": Virus scanner failure: error code: $output");
    return 0;
  }

  # Return successfully...
  return 1;
}

1;
