/* $Id: wmroot.h,v 1.6 2000/07/26 14:47:40 komatsu Exp $ */

#ifndef __WM_ROOT_H__
#define __WM_ROOT_H__

#include <gdk/gdk.h>
#include <gdk/gdkx.h>
#include <X11/Xlib.h>
#include <glib.h>

#include <gtk/gtkwidget.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define WM_ROOT(obj)          GTK_CHECK_CAST (obj, wm_root_get_type (), WmRoot)
#define WM_ROOT_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, wm_root_get_type (), WmRootClass)
#define IS_WM_ROOT(obj)       GTK_CHECK_TYPE (obj, wm_root_get_type ())
/* #define WM_ROOT_WIDTH()    (((GdkWindowPrivate*)GDK_ROOT_PARENT())->width) */
/* #define WM_ROOT_HEIGHT()   (((GdkWindowPrivate*)GDK_ROOT_PARENT())->height) */
#define WM_ROOT_WIDTH(obj)    (WM_ROOT(obj)->width)
#define WM_ROOT_HEIGHT(obj)   (WM_ROOT(obj)->height)

typedef struct _WmRoot        WmRoot;
typedef struct _WmRootClass   WmRootClass;

struct _WmRoot
{
    GtkWidget widget;

    guint16 width;
    guint16 height;
};

struct _WmRootClass
{
    GtkWidgetClass parent_class;

    void (* create_client)(WmRoot *wm_root);
    void (* delete_client)(WmRoot *wm_root);
};


GtkWidget* wm_root_new(void);
GtkType    wm_root_get_type(void);
GdkWindow* wm_root_window_new(GdkWindow *parent, GdkWindowAttr *attributes,
			      gint attributes_mask, Window client);
GList* wm_root_client_init(void);

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __WM_ROOT_H__ */
