# This file was automatically generated by SWIG (http://www.swig.org).
# Version 1.3.35
#
# Don't modify this file, modify the SWIG interface instead.

package Amanda::Device;
require Exporter;
require DynaLoader;
@ISA = qw(Exporter DynaLoader);
require Amanda::Types;
package Amanda::Devicec;
bootstrap Amanda::Device;
package Amanda::Device;
@EXPORT = qw( );

# ---------- BASE METHODS -------------

package Amanda::Device;

sub TIEHASH {
    my ($classname,$obj) = @_;
    return bless $obj, $classname;
}

sub CLEAR { }

sub FIRSTKEY { }

sub NEXTKEY { }

sub FETCH {
    my ($self,$field) = @_;
    my $member_func = "swig_${field}_get";
    $self->$member_func();
}

sub STORE {
    my ($self,$field,$newval) = @_;
    my $member_func = "swig_${field}_set";
    $self->$member_func($newval);
}

sub this {
    my $ptr = shift;
    return tied(%$ptr);
}


# ------- FUNCTION WRAPPERS --------

package Amanda::Device;

*IS_WRITABLE_ACCESS_MODE = *Amanda::Devicec::IS_WRITABLE_ACCESS_MODE;

############# Class : Amanda::Device::queue_fd_t ##############

package Amanda::Device::queue_fd_t;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( Amanda::Device );
%OWNER = ();
%ITERATORS = ();
*swig_fd_get = *Amanda::Devicec::queue_fd_t_fd_get;
*swig_fd_set = *Amanda::Devicec::queue_fd_t_fd_set;
*swig_errmsg_get = *Amanda::Devicec::queue_fd_t_errmsg_get;
*swig_errmsg_set = *Amanda::Devicec::queue_fd_t_errmsg_set;
sub new {
    my $pkg = shift;
    my $self = Amanda::Devicec::new_queue_fd_t(@_);
    bless $self, $pkg if defined($self);
}

sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        Amanda::Devicec::delete_queue_fd_t($self);
        delete $OWNER{$self};
    }
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : Amanda::Device::Device ##############

package Amanda::Device::Device;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( Amanda::Device );
%OWNER = ();
%ITERATORS = ();
sub new {
    my $pkg = shift;
    my $self = Amanda::Devicec::new_Device(@_);
    bless $self, $pkg if defined($self);
}

sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        Amanda::Devicec::delete_Device($self);
        delete $OWNER{$self};
    }
}

*configure = *Amanda::Devicec::Device_configure;
*error = *Amanda::Devicec::Device_error;
*status_error = *Amanda::Devicec::Device_status_error;
*error_or_status = *Amanda::Devicec::Device_error_or_status;
*read_label = *Amanda::Devicec::Device_read_label;
*start = *Amanda::Devicec::Device_start;
*finish = *Amanda::Devicec::Device_finish;
*start_file = *Amanda::Devicec::Device_start_file;
*write_block = *Amanda::Devicec::Device_write_block;
*write_from_fd = *Amanda::Devicec::Device_write_from_fd;
*finish_file = *Amanda::Devicec::Device_finish_file;
*seek_file = *Amanda::Devicec::Device_seek_file;
*seek_block = *Amanda::Devicec::Device_seek_block;
*read_block = *Amanda::Devicec::Device_read_block;
*read_to_fd = *Amanda::Devicec::Device_read_to_fd;
*property_list = *Amanda::Devicec::Device_property_list;
*property_get = *Amanda::Devicec::Device_property_get;
*property_set = *Amanda::Devicec::Device_property_set;
*property_set_ex = *Amanda::Devicec::Device_property_set_ex;
*recycle_file = *Amanda::Devicec::Device_recycle_file;
*file = *Amanda::Devicec::Device_file;
*block = *Amanda::Devicec::Device_block;
*in_file = *Amanda::Devicec::Device_in_file;
*device_name = *Amanda::Devicec::Device_device_name;
*access_mode = *Amanda::Devicec::Device_access_mode;
*is_eof = *Amanda::Devicec::Device_is_eof;
*volume_label = *Amanda::Devicec::Device_volume_label;
*volume_time = *Amanda::Devicec::Device_volume_time;
*status = *Amanda::Devicec::Device_status;
*min_block_size = *Amanda::Devicec::Device_min_block_size;
*max_block_size = *Amanda::Devicec::Device_max_block_size;
*block_size = *Amanda::Devicec::Device_block_size;
*volume_header = *Amanda::Devicec::Device_volume_header;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


# ------- VARIABLE STUBS --------

package Amanda::Device;

*ACCESS_NULL = *Amanda::Devicec::ACCESS_NULL;
*ACCESS_READ = *Amanda::Devicec::ACCESS_READ;
*ACCESS_WRITE = *Amanda::Devicec::ACCESS_WRITE;
*ACCESS_APPEND = *Amanda::Devicec::ACCESS_APPEND;
*DEVICE_STATUS_SUCCESS = *Amanda::Devicec::DEVICE_STATUS_SUCCESS;
*DEVICE_STATUS_DEVICE_ERROR = *Amanda::Devicec::DEVICE_STATUS_DEVICE_ERROR;
*DEVICE_STATUS_DEVICE_BUSY = *Amanda::Devicec::DEVICE_STATUS_DEVICE_BUSY;
*DEVICE_STATUS_VOLUME_MISSING = *Amanda::Devicec::DEVICE_STATUS_VOLUME_MISSING;
*DEVICE_STATUS_VOLUME_UNLABELED = *Amanda::Devicec::DEVICE_STATUS_VOLUME_UNLABELED;
*DEVICE_STATUS_VOLUME_ERROR = *Amanda::Devicec::DEVICE_STATUS_VOLUME_ERROR;
*DEVICE_STATUS_FLAGS_MAX = *Amanda::Devicec::DEVICE_STATUS_FLAGS_MAX;
*PROPERTY_PHASE_BEFORE_START = *Amanda::Devicec::PROPERTY_PHASE_BEFORE_START;
*PROPERTY_PHASE_BETWEEN_FILE_WRITE = *Amanda::Devicec::PROPERTY_PHASE_BETWEEN_FILE_WRITE;
*PROPERTY_PHASE_INSIDE_FILE_WRITE = *Amanda::Devicec::PROPERTY_PHASE_INSIDE_FILE_WRITE;
*PROPERTY_PHASE_BETWEEN_FILE_READ = *Amanda::Devicec::PROPERTY_PHASE_BETWEEN_FILE_READ;
*PROPERTY_PHASE_INSIDE_FILE_READ = *Amanda::Devicec::PROPERTY_PHASE_INSIDE_FILE_READ;
*PROPERTY_PHASE_MAX = *Amanda::Devicec::PROPERTY_PHASE_MAX;
*PROPERTY_PHASE_MASK = *Amanda::Devicec::PROPERTY_PHASE_MASK;
*PROPERTY_PHASE_SHIFT = *Amanda::Devicec::PROPERTY_PHASE_SHIFT;
*PROPERTY_ACCESS_GET_BEFORE_START = *Amanda::Devicec::PROPERTY_ACCESS_GET_BEFORE_START;
*PROPERTY_ACCESS_GET_BETWEEN_FILE_WRITE = *Amanda::Devicec::PROPERTY_ACCESS_GET_BETWEEN_FILE_WRITE;
*PROPERTY_ACCESS_GET_INSIDE_FILE_WRITE = *Amanda::Devicec::PROPERTY_ACCESS_GET_INSIDE_FILE_WRITE;
*PROPERTY_ACCESS_GET_BETWEEN_FILE_READ = *Amanda::Devicec::PROPERTY_ACCESS_GET_BETWEEN_FILE_READ;
*PROPERTY_ACCESS_GET_INSIDE_FILE_READ = *Amanda::Devicec::PROPERTY_ACCESS_GET_INSIDE_FILE_READ;
*PROPERTY_ACCESS_SET_BEFORE_START = *Amanda::Devicec::PROPERTY_ACCESS_SET_BEFORE_START;
*PROPERTY_ACCESS_SET_BETWEEN_FILE_WRITE = *Amanda::Devicec::PROPERTY_ACCESS_SET_BETWEEN_FILE_WRITE;
*PROPERTY_ACCESS_SET_INSIDE_FILE_WRITE = *Amanda::Devicec::PROPERTY_ACCESS_SET_INSIDE_FILE_WRITE;
*PROPERTY_ACCESS_SET_BETWEEN_FILE_READ = *Amanda::Devicec::PROPERTY_ACCESS_SET_BETWEEN_FILE_READ;
*PROPERTY_ACCESS_SET_INSIDE_FILE_READ = *Amanda::Devicec::PROPERTY_ACCESS_SET_INSIDE_FILE_READ;
*PROPERTY_ACCESS_GET_MASK = *Amanda::Devicec::PROPERTY_ACCESS_GET_MASK;
*PROPERTY_ACCESS_SET_MASK = *Amanda::Devicec::PROPERTY_ACCESS_SET_MASK;
*CONCURRENCY_PARADIGM_EXCLUSIVE = *Amanda::Devicec::CONCURRENCY_PARADIGM_EXCLUSIVE;
*CONCURRENCY_PARADIGM_SHARED_READ = *Amanda::Devicec::CONCURRENCY_PARADIGM_SHARED_READ;
*CONCURRENCY_PARADIGM_RANDOM_ACCESS = *Amanda::Devicec::CONCURRENCY_PARADIGM_RANDOM_ACCESS;
*STREAMING_REQUIREMENT_NONE = *Amanda::Devicec::STREAMING_REQUIREMENT_NONE;
*STREAMING_REQUIREMENT_DESIRED = *Amanda::Devicec::STREAMING_REQUIREMENT_DESIRED;
*STREAMING_REQUIREMENT_REQUIRED = *Amanda::Devicec::STREAMING_REQUIREMENT_REQUIRED;
*MEDIA_ACCESS_MODE_READ_ONLY = *Amanda::Devicec::MEDIA_ACCESS_MODE_READ_ONLY;
*MEDIA_ACCESS_MODE_WORM = *Amanda::Devicec::MEDIA_ACCESS_MODE_WORM;
*MEDIA_ACCESS_MODE_READ_WRITE = *Amanda::Devicec::MEDIA_ACCESS_MODE_READ_WRITE;
*MEDIA_ACCESS_MODE_WRITE_ONLY = *Amanda::Devicec::MEDIA_ACCESS_MODE_WRITE_ONLY;
*SIZE_ACCURACY_UNKNOWN = *Amanda::Devicec::SIZE_ACCURACY_UNKNOWN;
*SIZE_ACCURACY_ESTIMATE = *Amanda::Devicec::SIZE_ACCURACY_ESTIMATE;
*SIZE_ACCURACY_REAL = *Amanda::Devicec::SIZE_ACCURACY_REAL;
*PROPERTY_SURETY_BAD = *Amanda::Devicec::PROPERTY_SURETY_BAD;
*PROPERTY_SURETY_GOOD = *Amanda::Devicec::PROPERTY_SURETY_GOOD;
*PROPERTY_SOURCE_DEFAULT = *Amanda::Devicec::PROPERTY_SOURCE_DEFAULT;
*PROPERTY_SOURCE_DETECTED = *Amanda::Devicec::PROPERTY_SOURCE_DETECTED;
*PROPERTY_SOURCE_USER = *Amanda::Devicec::PROPERTY_SOURCE_USER;

@EXPORT_OK = ();
%EXPORT_TAGS = ();

=head1 NAME

Amanda::Device - interact with Amanda data-storage devices

=head1 SYNOPSIS

  use Amanda::Device qw( :constants );

  my $dev = Amanda::Device->new($device_name);
  if ($dev->read_label() == $DEVICE_STATUS_SUCCESS) {
      print "Label on $device_name is '$dev->volume_label'\n";
  }
  
See http://wiki.zmanda.com/index.php/Device_API for details on how Devices are used.

=head1 API STATUS

Stable

=head1 Amanda::Device Objects

See the wiki for descriptions of these functions.  Note that C instance variables
are represented by accessor functions of the same name.

=over

=item C<configure($use_global_config)>

=item C<read_label()>

=item C<start($mode, $label, $timestamp)>

=item C<finish()>

=item C<start_file($jobinfo)>

where C<$jobinfo> is a C<dumpfile_t> (see L<Amanda::Types>)

=item C<write_block($size, $data, $short_block)>

Note that Perl code is not expected to handle on-device data, so there
is currently no way to provide data to this function from Perl.  This may
change in future revisions.

=item C<write_from_fd($queue_fd)>

where C<$fd> is an integer file descriptor, not a filehandle

=item C<finish_file()>

=item C<seek_file($file)>

=item C<seek_block($block)>

=item C<read_block($size)>

=item C<read_to_fd($queue_fd)>

where C<$fd> is an integer file descriptor, not a filehandle

Note that Perl code is not expected to handle on-device data, so there
is currently no way to access the data this function returns.  This may
change in future revisions.

=item C<property_list()>

returns a list of properties, each represented as a hash:

  { 'access' => $access_flags,
    'name' => $property_name,
    'description' => $property_description }

=item C<property_get($property_name)>

returns the property, with the appropriate Perl type, or undef.  In array
context, returns the list C<($value, $surety, $source)>.

=item C<property_set($property_name, $value)>

=item C<property_set_ex($property_name, $value, $surety, $source)>

where C<$value> is of an appropriate type for the given property, C<$surety> is
a C<$PROPERTY_SURETY_*> constant, and C<$source> is a C<$PROPERTY_SOURCE_*>
constant.

=item C<recycle_file($filenum)>

=item C<file()> (accessor function)

=item C<block()> (accessor function)

=item C<in_file()> (accessor function)

=item C<device_name()> (accessor function)

=item C<access_mode()> (accessor function)

=item C<is_eof()> (accessor function)

=item C<volume_label()> (accessor function)

=item C<volume_time()> (accessor function)

=item C<min_block_size()> (accessor function)

=item C<max_block_size()> (accessor function)

=item C<block_size()> (accessor function)

=item C<volume_header()> (accessor function)

=back

=head1 CONSTANTS

This module defines a large number of constants.  Again, consult the
wiki or C<device.h> for the details on their meaning.  These constants
are available from the package namespace (e.g.,
C<Amanda::Device::ACCESS_WRITE>), or imported with the C<:constant>
import tag.

=cut

push @EXPORT_OK, qw(DeviceAccessMode_to_strings);
push @{$EXPORT_TAGS{"DeviceAccessMode"}}, qw(DeviceAccessMode_to_strings);

my %_DeviceAccessMode_VALUES;
#Convert a flag value to a list of names for flags that are set.
sub DeviceAccessMode_to_strings {
    my ($flags) = @_;
    my @result = ();

    for my $k (keys %_DeviceAccessMode_VALUES) {
	my $v = $_DeviceAccessMode_VALUES{$k};

	#is this a matching flag?
	if (($v == 0 && $flags == 0) || ($v != 0 && ($flags & $v) == $v)) {
	    push @result, $k;
	}
    }

#by default, just return the number as a 1-element list
    if (!@result) {
	return ($flags);
    }

    return @result;
}

push @EXPORT_OK, qw($ACCESS_NULL);
push @{$EXPORT_TAGS{"DeviceAccessMode"}}, qw($ACCESS_NULL);

$_DeviceAccessMode_VALUES{"NULL"} = $ACCESS_NULL;

push @EXPORT_OK, qw($ACCESS_READ);
push @{$EXPORT_TAGS{"DeviceAccessMode"}}, qw($ACCESS_READ);

$_DeviceAccessMode_VALUES{"READ"} = $ACCESS_READ;

push @EXPORT_OK, qw($ACCESS_WRITE);
push @{$EXPORT_TAGS{"DeviceAccessMode"}}, qw($ACCESS_WRITE);

$_DeviceAccessMode_VALUES{"WRITE"} = $ACCESS_WRITE;

push @EXPORT_OK, qw($ACCESS_APPEND);
push @{$EXPORT_TAGS{"DeviceAccessMode"}}, qw($ACCESS_APPEND);

$_DeviceAccessMode_VALUES{"APPEND"} = $ACCESS_APPEND;

push @EXPORT_OK, qw(IS_WRITABLE_ACCESS_MODE);
push @{$EXPORT_TAGS{"DeviceAccessMode"}}, qw(IS_WRITABLE_ACCESS_MODE);

#copy symbols in DeviceAccessMode to constants
push @{$EXPORT_TAGS{"constants"}},  @{$EXPORT_TAGS{"DeviceAccessMode"}};

push @EXPORT_OK, qw(DeviceStatusFlags_to_strings);
push @{$EXPORT_TAGS{"DeviceStatusFlags"}}, qw(DeviceStatusFlags_to_strings);

my %_DeviceStatusFlags_VALUES;
#Convert a flag value to a list of names for flags that are set.
sub DeviceStatusFlags_to_strings {
    my ($flags) = @_;
    my @result = ();

    for my $k (keys %_DeviceStatusFlags_VALUES) {
	my $v = $_DeviceStatusFlags_VALUES{$k};

	#is this a matching flag?
	if (($v == 0 && $flags == 0) || ($v != 0 && ($flags & $v) == $v)) {
	    push @result, $k;
	}
    }

#by default, just return the number as a 1-element list
    if (!@result) {
	return ($flags);
    }

    return @result;
}

push @EXPORT_OK, qw($DEVICE_STATUS_SUCCESS);
push @{$EXPORT_TAGS{"DeviceStatusFlags"}}, qw($DEVICE_STATUS_SUCCESS);

$_DeviceStatusFlags_VALUES{"SUCCESS"} = $DEVICE_STATUS_SUCCESS;

push @EXPORT_OK, qw($DEVICE_STATUS_DEVICE_ERROR);
push @{$EXPORT_TAGS{"DeviceStatusFlags"}}, qw($DEVICE_STATUS_DEVICE_ERROR);

$_DeviceStatusFlags_VALUES{"DEVICE_ERROR"} = $DEVICE_STATUS_DEVICE_ERROR;

push @EXPORT_OK, qw($DEVICE_STATUS_DEVICE_BUSY);
push @{$EXPORT_TAGS{"DeviceStatusFlags"}}, qw($DEVICE_STATUS_DEVICE_BUSY);

$_DeviceStatusFlags_VALUES{"DEVICE_BUSY"} = $DEVICE_STATUS_DEVICE_BUSY;

push @EXPORT_OK, qw($DEVICE_STATUS_VOLUME_MISSING);
push @{$EXPORT_TAGS{"DeviceStatusFlags"}}, qw($DEVICE_STATUS_VOLUME_MISSING);

$_DeviceStatusFlags_VALUES{"VOLUME_MISSING"} = $DEVICE_STATUS_VOLUME_MISSING;

push @EXPORT_OK, qw($DEVICE_STATUS_VOLUME_UNLABELED);
push @{$EXPORT_TAGS{"DeviceStatusFlags"}}, qw($DEVICE_STATUS_VOLUME_UNLABELED);

$_DeviceStatusFlags_VALUES{"VOLUME_UNLABELED"} = $DEVICE_STATUS_VOLUME_UNLABELED;

push @EXPORT_OK, qw($DEVICE_STATUS_VOLUME_ERROR);
push @{$EXPORT_TAGS{"DeviceStatusFlags"}}, qw($DEVICE_STATUS_VOLUME_ERROR);

$_DeviceStatusFlags_VALUES{"VOLUME_ERROR"} = $DEVICE_STATUS_VOLUME_ERROR;

push @EXPORT_OK, qw($DEVICE_STATUS_FLAGS_MAX);
push @{$EXPORT_TAGS{"DeviceStatusFlags"}}, qw($DEVICE_STATUS_FLAGS_MAX);

#copy symbols in DeviceStatusFlags to constants
push @{$EXPORT_TAGS{"constants"}},  @{$EXPORT_TAGS{"DeviceStatusFlags"}};

push @EXPORT_OK, qw(PropertyPhaseFlags_to_strings);
push @{$EXPORT_TAGS{"PropertyPhaseFlags"}}, qw(PropertyPhaseFlags_to_strings);

my %_PropertyPhaseFlags_VALUES;
#Convert a flag value to a list of names for flags that are set.
sub PropertyPhaseFlags_to_strings {
    my ($flags) = @_;
    my @result = ();

    for my $k (keys %_PropertyPhaseFlags_VALUES) {
	my $v = $_PropertyPhaseFlags_VALUES{$k};

	#is this a matching flag?
	if (($v == 0 && $flags == 0) || ($v != 0 && ($flags & $v) == $v)) {
	    push @result, $k;
	}
    }

#by default, just return the number as a 1-element list
    if (!@result) {
	return ($flags);
    }

    return @result;
}

push @EXPORT_OK, qw($PROPERTY_PHASE_BEFORE_START);
push @{$EXPORT_TAGS{"PropertyPhaseFlags"}}, qw($PROPERTY_PHASE_BEFORE_START);

$_PropertyPhaseFlags_VALUES{"BEFORE_START"} = $PROPERTY_PHASE_BEFORE_START;

push @EXPORT_OK, qw($PROPERTY_PHASE_BETWEEN_FILE_WRITE);
push @{$EXPORT_TAGS{"PropertyPhaseFlags"}}, qw($PROPERTY_PHASE_BETWEEN_FILE_WRITE);

$_PropertyPhaseFlags_VALUES{"BETWEEN_FILE_WRITE"} = $PROPERTY_PHASE_BETWEEN_FILE_WRITE;

push @EXPORT_OK, qw($PROPERTY_PHASE_INSIDE_FILE_WRITE);
push @{$EXPORT_TAGS{"PropertyPhaseFlags"}}, qw($PROPERTY_PHASE_INSIDE_FILE_WRITE);

$_PropertyPhaseFlags_VALUES{"INSIDE_FILE_WRITE"} = $PROPERTY_PHASE_INSIDE_FILE_WRITE;

push @EXPORT_OK, qw($PROPERTY_PHASE_BETWEEN_FILE_READ);
push @{$EXPORT_TAGS{"PropertyPhaseFlags"}}, qw($PROPERTY_PHASE_BETWEEN_FILE_READ);

$_PropertyPhaseFlags_VALUES{"BETWEEN_FILE_READ"} = $PROPERTY_PHASE_BETWEEN_FILE_READ;

push @EXPORT_OK, qw($PROPERTY_PHASE_INSIDE_FILE_READ);
push @{$EXPORT_TAGS{"PropertyPhaseFlags"}}, qw($PROPERTY_PHASE_INSIDE_FILE_READ);

$_PropertyPhaseFlags_VALUES{"INSIDE_FILE_READ"} = $PROPERTY_PHASE_INSIDE_FILE_READ;

push @EXPORT_OK, qw($PROPERTY_PHASE_MAX);
push @{$EXPORT_TAGS{"PropertyPhaseFlags"}}, qw($PROPERTY_PHASE_MAX);

push @EXPORT_OK, qw($PROPERTY_PHASE_MASK);
push @{$EXPORT_TAGS{"PropertyPhaseFlags"}}, qw($PROPERTY_PHASE_MASK);

push @EXPORT_OK, qw($PROPERTY_PHASE_SHIFT);
push @{$EXPORT_TAGS{"PropertyPhaseFlags"}}, qw($PROPERTY_PHASE_SHIFT);

#copy symbols in PropertyPhaseFlags to constants
push @{$EXPORT_TAGS{"constants"}},  @{$EXPORT_TAGS{"PropertyPhaseFlags"}};

push @EXPORT_OK, qw(PropertyAccessFlags_to_strings);
push @{$EXPORT_TAGS{"PropertyAccessFlags"}}, qw(PropertyAccessFlags_to_strings);

my %_PropertyAccessFlags_VALUES;
#Convert a flag value to a list of names for flags that are set.
sub PropertyAccessFlags_to_strings {
    my ($flags) = @_;
    my @result = ();

    for my $k (keys %_PropertyAccessFlags_VALUES) {
	my $v = $_PropertyAccessFlags_VALUES{$k};

	#is this a matching flag?
	if (($v == 0 && $flags == 0) || ($v != 0 && ($flags & $v) == $v)) {
	    push @result, $k;
	}
    }

#by default, just return the number as a 1-element list
    if (!@result) {
	return ($flags);
    }

    return @result;
}

push @EXPORT_OK, qw($PROPERTY_ACCESS_GET_BEFORE_START);
push @{$EXPORT_TAGS{"PropertyAccessFlags"}}, qw($PROPERTY_ACCESS_GET_BEFORE_START);

$_PropertyAccessFlags_VALUES{"GET_BEFORE_START"} = $PROPERTY_ACCESS_GET_BEFORE_START;

push @EXPORT_OK, qw($PROPERTY_ACCESS_GET_BETWEEN_FILE_WRITE);
push @{$EXPORT_TAGS{"PropertyAccessFlags"}}, qw($PROPERTY_ACCESS_GET_BETWEEN_FILE_WRITE);

$_PropertyAccessFlags_VALUES{"GET_BETWEEN_FILE_WRITE"} = $PROPERTY_ACCESS_GET_BETWEEN_FILE_WRITE;

push @EXPORT_OK, qw($PROPERTY_ACCESS_GET_INSIDE_FILE_WRITE);
push @{$EXPORT_TAGS{"PropertyAccessFlags"}}, qw($PROPERTY_ACCESS_GET_INSIDE_FILE_WRITE);

$_PropertyAccessFlags_VALUES{"GET_INSIDE_FILE_WRITE"} = $PROPERTY_ACCESS_GET_INSIDE_FILE_WRITE;

push @EXPORT_OK, qw($PROPERTY_ACCESS_GET_BETWEEN_FILE_READ);
push @{$EXPORT_TAGS{"PropertyAccessFlags"}}, qw($PROPERTY_ACCESS_GET_BETWEEN_FILE_READ);

$_PropertyAccessFlags_VALUES{"GET_BETWEEN_FILE_READ"} = $PROPERTY_ACCESS_GET_BETWEEN_FILE_READ;

push @EXPORT_OK, qw($PROPERTY_ACCESS_GET_INSIDE_FILE_READ);
push @{$EXPORT_TAGS{"PropertyAccessFlags"}}, qw($PROPERTY_ACCESS_GET_INSIDE_FILE_READ);

$_PropertyAccessFlags_VALUES{"GET_INSIDE_FILE_READ"} = $PROPERTY_ACCESS_GET_INSIDE_FILE_READ;

push @EXPORT_OK, qw($PROPERTY_ACCESS_SET_BEFORE_START);
push @{$EXPORT_TAGS{"PropertyAccessFlags"}}, qw($PROPERTY_ACCESS_SET_BEFORE_START);

$_PropertyAccessFlags_VALUES{"SET_BEFORE_START"} = $PROPERTY_ACCESS_SET_BEFORE_START;

push @EXPORT_OK, qw($PROPERTY_ACCESS_SET_BETWEEN_FILE_WRITE);
push @{$EXPORT_TAGS{"PropertyAccessFlags"}}, qw($PROPERTY_ACCESS_SET_BETWEEN_FILE_WRITE);

$_PropertyAccessFlags_VALUES{"SET_BETWEEN_FILE_WRITE"} = $PROPERTY_ACCESS_SET_BETWEEN_FILE_WRITE;

push @EXPORT_OK, qw($PROPERTY_ACCESS_SET_INSIDE_FILE_WRITE);
push @{$EXPORT_TAGS{"PropertyAccessFlags"}}, qw($PROPERTY_ACCESS_SET_INSIDE_FILE_WRITE);

$_PropertyAccessFlags_VALUES{"SET_INSIDE_FILE_WRITE"} = $PROPERTY_ACCESS_SET_INSIDE_FILE_WRITE;

push @EXPORT_OK, qw($PROPERTY_ACCESS_SET_BETWEEN_FILE_READ);
push @{$EXPORT_TAGS{"PropertyAccessFlags"}}, qw($PROPERTY_ACCESS_SET_BETWEEN_FILE_READ);

$_PropertyAccessFlags_VALUES{"SET_BETWEEN_FILE_READ"} = $PROPERTY_ACCESS_SET_BETWEEN_FILE_READ;

push @EXPORT_OK, qw($PROPERTY_ACCESS_SET_INSIDE_FILE_READ);
push @{$EXPORT_TAGS{"PropertyAccessFlags"}}, qw($PROPERTY_ACCESS_SET_INSIDE_FILE_READ);

$_PropertyAccessFlags_VALUES{"SET_INSIDE_FILE_READ"} = $PROPERTY_ACCESS_SET_INSIDE_FILE_READ;

push @EXPORT_OK, qw($PROPERTY_ACCESS_GET_MASK);
push @{$EXPORT_TAGS{"PropertyAccessFlags"}}, qw($PROPERTY_ACCESS_GET_MASK);

push @EXPORT_OK, qw($PROPERTY_ACCESS_SET_MASK);
push @{$EXPORT_TAGS{"PropertyAccessFlags"}}, qw($PROPERTY_ACCESS_SET_MASK);

#copy symbols in PropertyAccessFlags to constants
push @{$EXPORT_TAGS{"constants"}},  @{$EXPORT_TAGS{"PropertyAccessFlags"}};

push @EXPORT_OK, qw(ConcurrencyParadigm_to_string);
push @{$EXPORT_TAGS{"ConcurrencyParadigm"}}, qw(ConcurrencyParadigm_to_string);

my %_ConcurrencyParadigm_VALUES;
#Convert an enum value to a single string
sub ConcurrencyParadigm_to_string {
    my ($enumval) = @_;

    for my $k (keys %_ConcurrencyParadigm_VALUES) {
	my $v = $_ConcurrencyParadigm_VALUES{$k};

	#is this a matching flag?
	if ($enumval == $v) {
	    return $k;
	}
    }

#default, just return the number
    return $enumval;
}

push @EXPORT_OK, qw($CONCURRENCY_PARADIGM_EXCLUSIVE);
push @{$EXPORT_TAGS{"ConcurrencyParadigm"}}, qw($CONCURRENCY_PARADIGM_EXCLUSIVE);

$_ConcurrencyParadigm_VALUES{"EXCLUSIVE"} = $CONCURRENCY_PARADIGM_EXCLUSIVE;

push @EXPORT_OK, qw($CONCURRENCY_PARADIGM_SHARED_READ);
push @{$EXPORT_TAGS{"ConcurrencyParadigm"}}, qw($CONCURRENCY_PARADIGM_SHARED_READ);

$_ConcurrencyParadigm_VALUES{"SHARED_READ"} = $CONCURRENCY_PARADIGM_SHARED_READ;

push @EXPORT_OK, qw($CONCURRENCY_PARADIGM_RANDOM_ACCESS);
push @{$EXPORT_TAGS{"ConcurrencyParadigm"}}, qw($CONCURRENCY_PARADIGM_RANDOM_ACCESS);

$_ConcurrencyParadigm_VALUES{"RANDOM_ACCESS"} = $CONCURRENCY_PARADIGM_RANDOM_ACCESS;

#copy symbols in ConcurrencyParadigm to constants
push @{$EXPORT_TAGS{"constants"}},  @{$EXPORT_TAGS{"ConcurrencyParadigm"}};

push @EXPORT_OK, qw(StreamingRequirement_to_string);
push @{$EXPORT_TAGS{"StreamingRequirement"}}, qw(StreamingRequirement_to_string);

my %_StreamingRequirement_VALUES;
#Convert an enum value to a single string
sub StreamingRequirement_to_string {
    my ($enumval) = @_;

    for my $k (keys %_StreamingRequirement_VALUES) {
	my $v = $_StreamingRequirement_VALUES{$k};

	#is this a matching flag?
	if ($enumval == $v) {
	    return $k;
	}
    }

#default, just return the number
    return $enumval;
}

push @EXPORT_OK, qw($STREAMING_REQUIREMENT_NONE);
push @{$EXPORT_TAGS{"StreamingRequirement"}}, qw($STREAMING_REQUIREMENT_NONE);

$_StreamingRequirement_VALUES{"NONE"} = $STREAMING_REQUIREMENT_NONE;

push @EXPORT_OK, qw($STREAMING_REQUIREMENT_DESIRED);
push @{$EXPORT_TAGS{"StreamingRequirement"}}, qw($STREAMING_REQUIREMENT_DESIRED);

$_StreamingRequirement_VALUES{"DESIRED"} = $STREAMING_REQUIREMENT_DESIRED;

push @EXPORT_OK, qw($STREAMING_REQUIREMENT_REQUIRED);
push @{$EXPORT_TAGS{"StreamingRequirement"}}, qw($STREAMING_REQUIREMENT_REQUIRED);

$_StreamingRequirement_VALUES{"REQUIRED"} = $STREAMING_REQUIREMENT_REQUIRED;

#copy symbols in StreamingRequirement to constants
push @{$EXPORT_TAGS{"constants"}},  @{$EXPORT_TAGS{"StreamingRequirement"}};

push @EXPORT_OK, qw(MediaAccessMode_to_string);
push @{$EXPORT_TAGS{"MediaAccessMode"}}, qw(MediaAccessMode_to_string);

my %_MediaAccessMode_VALUES;
#Convert an enum value to a single string
sub MediaAccessMode_to_string {
    my ($enumval) = @_;

    for my $k (keys %_MediaAccessMode_VALUES) {
	my $v = $_MediaAccessMode_VALUES{$k};

	#is this a matching flag?
	if ($enumval == $v) {
	    return $k;
	}
    }

#default, just return the number
    return $enumval;
}

push @EXPORT_OK, qw($MEDIA_ACCESS_MODE_READ_ONLY);
push @{$EXPORT_TAGS{"MediaAccessMode"}}, qw($MEDIA_ACCESS_MODE_READ_ONLY);

$_MediaAccessMode_VALUES{"READ_ONLY"} = $MEDIA_ACCESS_MODE_READ_ONLY;

push @EXPORT_OK, qw($MEDIA_ACCESS_MODE_WORM);
push @{$EXPORT_TAGS{"MediaAccessMode"}}, qw($MEDIA_ACCESS_MODE_WORM);

$_MediaAccessMode_VALUES{"WORM"} = $MEDIA_ACCESS_MODE_WORM;

push @EXPORT_OK, qw($MEDIA_ACCESS_MODE_READ_WRITE);
push @{$EXPORT_TAGS{"MediaAccessMode"}}, qw($MEDIA_ACCESS_MODE_READ_WRITE);

$_MediaAccessMode_VALUES{"READ_WRITE"} = $MEDIA_ACCESS_MODE_READ_WRITE;

push @EXPORT_OK, qw($MEDIA_ACCESS_MODE_WRITE_ONLY);
push @{$EXPORT_TAGS{"MediaAccessMode"}}, qw($MEDIA_ACCESS_MODE_WRITE_ONLY);

$_MediaAccessMode_VALUES{"WRITE_ONLY"} = $MEDIA_ACCESS_MODE_WRITE_ONLY;

#copy symbols in MediaAccessMode to constants
push @{$EXPORT_TAGS{"constants"}},  @{$EXPORT_TAGS{"MediaAccessMode"}};

push @EXPORT_OK, qw(SizeAccuracy_to_string);
push @{$EXPORT_TAGS{"SizeAccuracy"}}, qw(SizeAccuracy_to_string);

my %_SizeAccuracy_VALUES;
#Convert an enum value to a single string
sub SizeAccuracy_to_string {
    my ($enumval) = @_;

    for my $k (keys %_SizeAccuracy_VALUES) {
	my $v = $_SizeAccuracy_VALUES{$k};

	#is this a matching flag?
	if ($enumval == $v) {
	    return $k;
	}
    }

#default, just return the number
    return $enumval;
}

push @EXPORT_OK, qw($SIZE_ACCURACY_UNKNOWN);
push @{$EXPORT_TAGS{"SizeAccuracy"}}, qw($SIZE_ACCURACY_UNKNOWN);

$_SizeAccuracy_VALUES{"UNKNOWN"} = $SIZE_ACCURACY_UNKNOWN;

push @EXPORT_OK, qw($SIZE_ACCURACY_ESTIMATE);
push @{$EXPORT_TAGS{"SizeAccuracy"}}, qw($SIZE_ACCURACY_ESTIMATE);

$_SizeAccuracy_VALUES{"ESTIMATE"} = $SIZE_ACCURACY_ESTIMATE;

push @EXPORT_OK, qw($SIZE_ACCURACY_REAL);
push @{$EXPORT_TAGS{"SizeAccuracy"}}, qw($SIZE_ACCURACY_REAL);

$_SizeAccuracy_VALUES{"REAL"} = $SIZE_ACCURACY_REAL;

#copy symbols in SizeAccuracy to constants
push @{$EXPORT_TAGS{"constants"}},  @{$EXPORT_TAGS{"SizeAccuracy"}};

push @EXPORT_OK, qw(PropertySurety_to_strings);
push @{$EXPORT_TAGS{"PropertySurety"}}, qw(PropertySurety_to_strings);

my %_PropertySurety_VALUES;
#Convert a flag value to a list of names for flags that are set.
sub PropertySurety_to_strings {
    my ($flags) = @_;
    my @result = ();

    for my $k (keys %_PropertySurety_VALUES) {
	my $v = $_PropertySurety_VALUES{$k};

	#is this a matching flag?
	if (($v == 0 && $flags == 0) || ($v != 0 && ($flags & $v) == $v)) {
	    push @result, $k;
	}
    }

#by default, just return the number as a 1-element list
    if (!@result) {
	return ($flags);
    }

    return @result;
}

push @EXPORT_OK, qw($PROPERTY_SURETY_BAD);
push @{$EXPORT_TAGS{"PropertySurety"}}, qw($PROPERTY_SURETY_BAD);

$_PropertySurety_VALUES{"SURETY_BAD"} = $PROPERTY_SURETY_BAD;

push @EXPORT_OK, qw($PROPERTY_SURETY_GOOD);
push @{$EXPORT_TAGS{"PropertySurety"}}, qw($PROPERTY_SURETY_GOOD);

$_PropertySurety_VALUES{"SURETY_GOOD"} = $PROPERTY_SURETY_GOOD;

#copy symbols in PropertySurety to constants
push @{$EXPORT_TAGS{"constants"}},  @{$EXPORT_TAGS{"PropertySurety"}};

push @EXPORT_OK, qw(PropertySource_to_strings);
push @{$EXPORT_TAGS{"PropertySource"}}, qw(PropertySource_to_strings);

my %_PropertySource_VALUES;
#Convert a flag value to a list of names for flags that are set.
sub PropertySource_to_strings {
    my ($flags) = @_;
    my @result = ();

    for my $k (keys %_PropertySource_VALUES) {
	my $v = $_PropertySource_VALUES{$k};

	#is this a matching flag?
	if (($v == 0 && $flags == 0) || ($v != 0 && ($flags & $v) == $v)) {
	    push @result, $k;
	}
    }

#by default, just return the number as a 1-element list
    if (!@result) {
	return ($flags);
    }

    return @result;
}

push @EXPORT_OK, qw($PROPERTY_SOURCE_DEFAULT);
push @{$EXPORT_TAGS{"PropertySource"}}, qw($PROPERTY_SOURCE_DEFAULT);

$_PropertySource_VALUES{"SOURCE_DEFAULT"} = $PROPERTY_SOURCE_DEFAULT;

push @EXPORT_OK, qw($PROPERTY_SOURCE_DETECTED);
push @{$EXPORT_TAGS{"PropertySource"}}, qw($PROPERTY_SOURCE_DETECTED);

$_PropertySource_VALUES{"SOURCE_DETECTED"} = $PROPERTY_SOURCE_DETECTED;

push @EXPORT_OK, qw($PROPERTY_SOURCE_USER);
push @{$EXPORT_TAGS{"PropertySource"}}, qw($PROPERTY_SOURCE_USER);

$_PropertySource_VALUES{"SOURCE_USER"} = $PROPERTY_SOURCE_USER;

#copy symbols in PropertySource to constants
push @{$EXPORT_TAGS{"constants"}},  @{$EXPORT_TAGS{"PropertySource"}};


# SWIG produces a sub-package for the Device "class", in this case named 
# Amanda::Device::Device.  For user convenience, we allow Amanda::Device->new(..) to
# do the same thing.  This is a wrapper function, and not just a typeglob assignment,
# because we want to get the right blessing.
sub new {
    my $pkg = shift;
    Amanda::Device::Device->new(@_);
}
1;
