(**************************************************************************)
(*                                                                        *)
(*     The Alt-Ergo theorem prover                                        *)
(*     Copyright (C) 2006-2011                                            *)
(*                                                                        *)
(*     Sylvain Conchon                                                    *)
(*     Evelyne Contejean                                                  *)
(*                                                                        *)
(*     Francois Bobot                                                     *)
(*     Mohamed Iguernelala                                                *)
(*     Stephane Lescuyer                                                  *)
(*     Alain Mebsout                                                      *)
(*                                                                        *)
(*     CNRS - INRIA - Universite Paris Sud                                *)
(*                                                                        *)
(*   This file is distributed under the terms of the CeCILL-C licence     *)
(*                                                                        *)
(**************************************************************************)

open Why_annoted


val prune : ?register:bool -> env -> 'a annoted -> unit

val incorrect_prune : ?register:bool -> env -> 'a annoted -> unit

val unprune : ?register:bool -> env -> 'a annoted -> unit

val toggle_prune : env -> 'a annoted -> unit

val connect : env -> unit

val clear_used_lemmas_tags : env -> unit

val show_used_lemmas : env -> Explanation.t -> unit

val prune_unused : env -> unit

val add_instance : 
  ?register:bool -> env -> int -> aform -> string -> 
  Why_ptree.inversion -> string list -> unit

val readd_trigger : ?register:bool -> env -> int -> string -> bool -> unit
