/*****************************************************************************
*
* ALPS Project: Algorithms and Libraries for Physics Simulations
*
* ALPS Light Libraries
*
* Copyright (C) 1994-2004 by Matthias Troyer <troyer@itp.phys.ethz.ch>,
*                            Synge Todo <wistaria@comp-phys.org>
*
* This software is part of the "ALPS Light" Libraries, public-domain
* part of the ALPS Libraries. If you need the full functionality of
* the ALPS Libraries, such as Lattice, Model, Scheduler, etc, please
* use the full version of ALPS Libraries, which is available from
* http://alps.comp-phys.org/.
*
* Permission is hereby granted, free of charge, to any person or organization
* obtaining a copy of the software and accompanying documentation covered by
* this license (the "Software") to use, reproduce, display, distribute,
* execute, and transmit the Software, and to prepare derivative works of the
* Software, and to permit third-parties to whom the Software is furnished to
* do so, all subject to the following:
*
* The copyright notices in the Software and this entire statement, including
* the above license grant, this restriction and the following disclaimer,
* must be included in all copies of the Software, in whole or in part, and
* all derivative works of the Software, unless such copies or derivative
* works are solely in the form of machine-executable object code generated by
* a source language processor.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
* FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT 
* SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE 
* FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE, 
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
* DEALINGS IN THE SOFTWARE.
*
*****************************************************************************/

/* $Id: buffer.h,v 1.7 2004/04/25 03:04:59 troyer Exp $ */

#ifndef OSIRIS_BUFFER_H
#define OSIRIS_BUFFER_H

#include <alps/config.h>
#include <vector>

namespace alps {
namespace detail {

class Buffer;

/** a simple Buffer class. values can be written into it or read from it. */
class Buffer : public std::vector<char>
{
  public:
  /** create a buffer. */
  Buffer()
    : std::vector<char>(),
      read_pos(0) {}

 /// erase the Buffer
 void clear() {(*this)=Buffer();}

  /** get a pointer to the Buffer. 
      This pointer might be invalidated by writing to the Buffer.
  */
  operator char* () { return (size() ? &(this->operator[](0)) : 0); }

  // write basic data types and arrays of them

template <class T>
  void write(const T* p,size_type n)
  {
    write_buffer(p, n*sizeof(T));
  }

  template <class T>
  void write(const T x) 
  {
    write_buffer(&x, sizeof(T));
  }

  // read basic data types and arrays of them
  
  template <class T>
  void read(T* p,size_type n=1) { read_buffer(p, n*sizeof(T));}

  template <class T>
  void read(T& x) { read_buffer(&x, sizeof(T)); }

private:
  // the position at which reading will take place
  uint32_t read_pos; 

  void write_buffer(const void*, size_type);
  void read_buffer(void*, size_type);
};

} // end namespace detail
} // end namespace alps

#endif // OSIRIS_BUFFER_H
