/*****************************************************************************
*
* ALPS Project: Algorithms and Libraries for Physics Simulations
*
* ALPS Light Libraries
*
* Copyright (C) 2001-2003 by Matthias Troyer <troyer@comp-phys.org>,
*                            Synge Todo <wistaria@comp-phys.org>
*
* This software is part of the "ALPS Light" Libraries, public-domain
* part of the ALPS Libraries. If you need the full functionality of
* the ALPS Libraries, such as Lattice, Model, Scheduler, etc, please
* use the full version of ALPS Libraries, which is available from
* http://alps.comp-phys.org/.
*
* Permission is hereby granted, free of charge, to any person or organization
* obtaining a copy of the software and accompanying documentation covered by
* this license (the "Software") to use, reproduce, display, distribute,
* execute, and transmit the Software, and to prepare derivative works of the
* Software, and to permit third-parties to whom the Software is furnished to
* do so, all subject to the following:
*
* The copyright notices in the Software and this entire statement, including
* the above license grant, this restriction and the following disclaimer,
* must be included in all copies of the Software, in whole or in part, and
* all derivative works of the Software, unless such copies or derivative
* works are solely in the form of machine-executable object code generated by
* a source language processor.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
* FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT 
* SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE 
* FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE, 
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
* DEALINGS IN THE SOFTWARE.
*
*****************************************************************************/

/* $Id: expression_impl.h,v 1.8 2004/06/17 15:06:37 wistaria Exp $ */

#ifndef ALPS_EXPRESSION_IMPL_H
#define ALPS_EXPRESSION_IMPL_H

#include <alps/config.h>

#ifndef ALPS_WITH_NEW_EXPRESSION

#include <alps/expression.h>
#include <iostream>

namespace alps {
namespace detail {

class Block : public Expression
{
public:
  Block(std::istream&);
  Block(const Expression& e) : Expression(e) {}
  void output(std::ostream&) const;
  Evaluatable* clone() const;
  void flatten();
  boost::shared_ptr<Evaluatable> flatten_one();
  Evaluatable* partial_evaluate_replace(const Evaluator& p);
};

class Symbol : public Evaluatable {
public:
  Symbol(const std::string& n) : name_(n) {}
  double value(const Evaluator& p) const;
  bool can_evaluate(const Evaluator& p) const;
  void output(std::ostream&) const;
  Evaluatable* clone() const;
  Evaluatable* partial_evaluate_replace(const Evaluator& p);
  bool depends_on(const std::string& s) const;
private:
  std::string name_;
};

class Function : public Evaluatable {
public:
  Function(std::istream&, const std::string&);
  Function(const std::string& n, const Expression& e) : name_(n), arg_(e) {}
  double value(const Evaluator& p) const;
  bool can_evaluate(const Evaluator& p) const;
  void output(std::ostream&) const;
  Evaluatable* clone() const;
  boost::shared_ptr<Evaluatable> flatten_one();
  Evaluatable* partial_evaluate_replace(const Evaluator& p);
  bool depends_on(const std::string& s) const;
private:
 std::string name_;
 Expression arg_;
};

class Number : public Evaluatable {
public:
  Number(double x) : val_(x) {}
  double value(const Evaluator& p) const;
  bool can_evaluate(const Evaluator& p) const;
  void output(std::ostream&) const;
  Evaluatable* clone() const;
private:
 double val_;
};

} // end namespace detail
} // end namespace alps

#endif // ! ALPS_WITH_NEW_EXPRESSION

#endif // ! ALPS_EXPRESSION_IMPL_H
