/* ========================================================================
 * Copyright 1988-2007 University of Washington
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * 
 * ========================================================================
 */

/*
 * Program:	Unicode width table (current as of Unicode 5.0)
 *
 * Author:	Mark Crispin
 *		Networks and Distributed Computing
 *		Computing & Communications
 *		University of Washington
 *		Administration Building, AG-44
 *		Seattle, WA  98195
 *		Internet: MRC@CAC.Washington.EDU
 *
 * Date:	20 March 2006
 * Last Edited:	10 January 2007
 */

/* Table of 2-bit character widths, indexed by Unicode codepoint and
 * big-endian within bytes:
 *  0	zero-width
 *  1	single-width (half-width)
 *  2	double-width (full-width)
 *  3	invalid (C0/C1 controls, surrogates)
 *
 * NOTE!!: There are manual exceptions in this table, derived through
 * empirical testing.  Do not re-generate the table from the UnicodeData.txt
 * and EastAsianWidth.txt files without re-doing the exceptions:
 *
 * U+00AD (SOFT HYPHEN) has width 1 even though it is a format control
 *
 * All codepoints with "A" in EastAsianWidth.txt are considered to be double
 * width.
 */

#define UCS4_WIDLEN 196608

static const unsigned char ucs4_widthtab[49152] = {
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+0000 - U+001f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+0020 - U+003f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+0040 - U+005f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x57,	/* U+0060 - U+007f */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+0080 - U+009f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+00a0 - U+00bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+00c0 - U+00df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+00e0 - U+00ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+0100 - U+011f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+0120 - U+013f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+0140 - U+015f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+0160 - U+017f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+0180 - U+019f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+01a0 - U+01bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+01c0 - U+01df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+01e0 - U+01ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+0200 - U+021f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+0220 - U+023f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+0240 - U+025f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+0260 - U+027f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+0280 - U+029f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+02a0 - U+02bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+02c0 - U+02df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+02e0 - U+02ff */
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* U+0300 - U+031f */
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* U+0320 - U+033f */
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* U+0340 - U+035f */
  0x00,0x00,0x00,0x00,0x55,0x55,0x55,0x55,	/* U+0360 - U+037f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+0380 - U+039f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+03a0 - U+03bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+03c0 - U+03df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+03e0 - U+03ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+0400 - U+041f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+0420 - U+043f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+0440 - U+045f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+0460 - U+047f */
  0x54,0x01,0x05,0x55,0x55,0x55,0x55,0x55,	/* U+0480 - U+049f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+04a0 - U+04bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+04c0 - U+04df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+04e0 - U+04ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+0500 - U+051f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+0520 - U+053f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+0540 - U+055f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+0560 - U+057f */
  0x55,0x55,0x55,0x55,0x40,0x00,0x00,0x00,	/* U+0580 - U+059f */
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,	/* U+05a0 - U+05bf */
  0x41,0x04,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+05c0 - U+05df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+05e0 - U+05ff */
  0x00,0x55,0x55,0x55,0x00,0x05,0x55,0x55,	/* U+0600 - U+061f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+0620 - U+063f */
  0x55,0x55,0x54,0x00,0x00,0x00,0x00,0x01,	/* U+0640 - U+065f */
  0x55,0x55,0x55,0x55,0x15,0x55,0x55,0x55,	/* U+0660 - U+067f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+0680 - U+069f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+06a0 - U+06bf */
  0x55,0x55,0x55,0x55,0x55,0x50,0x00,0x00,	/* U+06c0 - U+06df */
  0x00,0x14,0x10,0x05,0x55,0x55,0x55,0x55,	/* U+06e0 - U+06ff */
  0x55,0x55,0x55,0x54,0x45,0x55,0x55,0x55,	/* U+0700 - U+071f */
  0x55,0x55,0x55,0x55,0x00,0x00,0x00,0x00,	/* U+0720 - U+073f */
  0x00,0x00,0x01,0x55,0x55,0x55,0x55,0x55,	/* U+0740 - U+075f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+0760 - U+077f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+0780 - U+079f */
  0x55,0x50,0x00,0x00,0x15,0x55,0x55,0x55,	/* U+07a0 - U+07bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+07c0 - U+07df */
  0x55,0x55,0x54,0x00,0x00,0x55,0x55,0x55,	/* U+07e0 - U+07ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+0800 - U+081f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+0820 - U+083f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+0840 - U+085f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+0860 - U+087f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+0880 - U+089f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+08a0 - U+08bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+08c0 - U+08df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+08e0 - U+08ff */
  0x41,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+0900 - U+091f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x15,	/* U+0920 - U+093f */
  0x40,0x00,0x15,0x45,0x40,0x15,0x55,0x55,	/* U+0940 - U+095f */
  0x50,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+0960 - U+097f */
  0x45,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+0980 - U+099f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x15,	/* U+09a0 - U+09bf */
  0x40,0x15,0x55,0x45,0x55,0x55,0x55,0x55,	/* U+09c0 - U+09df */
  0x50,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+09e0 - U+09ff */
  0x41,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+0a00 - U+0a1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x15,	/* U+0a20 - U+0a3f */
  0x41,0x54,0x14,0x05,0x55,0x55,0x55,0x55,	/* U+0a40 - U+0a5f */
  0x55,0x55,0x55,0x55,0x05,0x55,0x55,0x55,	/* U+0a60 - U+0a7f */
  0x41,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+0a80 - U+0a9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x15,	/* U+0aa0 - U+0abf */
  0x40,0x04,0x15,0x45,0x55,0x55,0x55,0x55,	/* U+0ac0 - U+0adf */
  0x50,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+0ae0 - U+0aff */
  0x45,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+0b00 - U+0b1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x14,	/* U+0b20 - U+0b3f */
  0x40,0x55,0x55,0x45,0x55,0x51,0x55,0x55,	/* U+0b40 - U+0b5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+0b60 - U+0b7f */
  0x51,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+0b80 - U+0b9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+0ba0 - U+0bbf */
  0x15,0x55,0x55,0x45,0x55,0x55,0x55,0x55,	/* U+0bc0 - U+0bdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+0be0 - U+0bff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+0c00 - U+0c1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x50,	/* U+0c20 - U+0c3f */
  0x15,0x50,0x10,0x05,0x55,0x41,0x55,0x55,	/* U+0c40 - U+0c5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+0c60 - U+0c7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+0c80 - U+0c9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x15,	/* U+0ca0 - U+0cbf */
  0x55,0x55,0x55,0x05,0x55,0x55,0x55,0x55,	/* U+0cc0 - U+0cdf */
  0x50,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+0ce0 - U+0cff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+0d00 - U+0d1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+0d20 - U+0d3f */
  0x40,0x55,0x55,0x45,0x55,0x55,0x55,0x55,	/* U+0d40 - U+0d5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+0d60 - U+0d7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+0d80 - U+0d9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+0da0 - U+0dbf */
  0x55,0x55,0x51,0x55,0x50,0x11,0x55,0x55,	/* U+0dc0 - U+0ddf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+0de0 - U+0dff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+0e00 - U+0e1f */
  0x55,0x55,0x55,0x55,0x45,0x00,0x01,0x55,	/* U+0e20 - U+0e3f */
  0x55,0x54,0x00,0x01,0x55,0x55,0x55,0x55,	/* U+0e40 - U+0e5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+0e60 - U+0e7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+0e80 - U+0e9f */
  0x55,0x55,0x55,0x55,0x45,0x00,0x04,0x15,	/* U+0ea0 - U+0ebf */
  0x55,0x55,0x00,0x05,0x55,0x55,0x55,0x55,	/* U+0ec0 - U+0edf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+0ee0 - U+0eff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x05,0x55,	/* U+0f00 - U+0f1f */
  0x55,0x55,0x55,0x55,0x55,0x44,0x45,0x55,	/* U+0f20 - U+0f3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+0f40 - U+0f5f */
  0x55,0x55,0x55,0x55,0x40,0x00,0x00,0x01,	/* U+0f60 - U+0f7f */
  0x00,0x10,0x55,0x55,0x00,0x00,0x40,0x00,	/* U+0f80 - U+0f9f */
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x15,	/* U+0fa0 - U+0fbf */
  0x55,0x51,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+0fc0 - U+0fdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+0fe0 - U+0fff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1000 - U+101f */
  0x55,0x55,0x55,0x40,0x11,0x50,0x45,0x55,	/* U+1020 - U+103f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x05,0x55,	/* U+1040 - U+105f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1060 - U+107f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1080 - U+109f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10a0 - U+10bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10c0 - U+10df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10e0 - U+10ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+1100 - U+111f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+1120 - U+113f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xa5,0x56,	/* U+1140 - U+115f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1160 - U+117f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1180 - U+119f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11a0 - U+11bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11c0 - U+11df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11e0 - U+11ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1200 - U+121f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1220 - U+123f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1240 - U+125f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1260 - U+127f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1280 - U+129f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12a0 - U+12bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12c0 - U+12df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12e0 - U+12ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1300 - U+131f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1320 - U+133f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x54,	/* U+1340 - U+135f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1360 - U+137f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1380 - U+139f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13a0 - U+13bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13c0 - U+13df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13e0 - U+13ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1400 - U+141f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1420 - U+143f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1440 - U+145f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1460 - U+147f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1480 - U+149f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14a0 - U+14bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14c0 - U+14df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14e0 - U+14ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1500 - U+151f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1520 - U+153f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1540 - U+155f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1560 - U+157f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1580 - U+159f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15a0 - U+15bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15c0 - U+15df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15e0 - U+15ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1600 - U+161f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1620 - U+163f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1640 - U+165f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1660 - U+167f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1680 - U+169f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16a0 - U+16bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16c0 - U+16df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16e0 - U+16ff */
  0x55,0x55,0x55,0x55,0x50,0x15,0x55,0x55,	/* U+1700 - U+171f */
  0x55,0x55,0x55,0x55,0x50,0x15,0x55,0x55,	/* U+1720 - U+173f */
  0x55,0x55,0x55,0x55,0x50,0x55,0x55,0x55,	/* U+1740 - U+175f */
  0x55,0x55,0x55,0x55,0x50,0x55,0x55,0x55,	/* U+1760 - U+177f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1780 - U+179f */
  0x55,0x55,0x55,0x55,0x55,0x04,0x00,0x05,	/* U+17a0 - U+17bf */
  0x55,0x51,0x40,0x00,0x00,0x55,0x55,0x45,	/* U+17c0 - U+17df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17e0 - U+17ff */
  0x55,0x55,0x54,0x05,0x55,0x55,0x55,0x55,	/* U+1800 - U+181f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1820 - U+183f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1840 - U+185f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1860 - U+187f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1880 - U+189f */
  0x55,0x55,0x45,0x55,0x55,0x55,0x55,0x55,	/* U+18a0 - U+18bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18c0 - U+18df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18e0 - U+18ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1900 - U+191f */
  0x01,0x54,0x00,0x55,0x51,0x55,0x40,0x55,	/* U+1920 - U+193f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1940 - U+195f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1960 - U+197f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1980 - U+199f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19a0 - U+19bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19c0 - U+19df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19e0 - U+19ff */
  0x55,0x55,0x55,0x55,0x55,0x54,0x15,0x55,	/* U+1a00 - U+1a1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a20 - U+1a3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a40 - U+1a5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a60 - U+1a7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a80 - U+1a9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1aa0 - U+1abf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ac0 - U+1adf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ae0 - U+1aff */
  0x00,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b00 - U+1b1f */
  0x55,0x55,0x55,0x55,0x55,0x10,0x01,0x15,	/* U+1b20 - U+1b3f */
  0x51,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b40 - U+1b5f */
  0x55,0x55,0x54,0x00,0x00,0x55,0x55,0x55,	/* U+1b60 - U+1b7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b80 - U+1b9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ba0 - U+1bbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1bc0 - U+1bdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1be0 - U+1bff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c00 - U+1c1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c20 - U+1c3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c40 - U+1c5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c60 - U+1c7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c80 - U+1c9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ca0 - U+1cbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1cc0 - U+1cdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ce0 - U+1cff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d00 - U+1d1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d20 - U+1d3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d40 - U+1d5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d60 - U+1d7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d80 - U+1d9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1da0 - U+1dbf */
  0x00,0x00,0x01,0x55,0x55,0x55,0x55,0x55,	/* U+1dc0 - U+1ddf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x50,	/* U+1de0 - U+1dff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e00 - U+1e1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e20 - U+1e3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e40 - U+1e5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e60 - U+1e7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e80 - U+1e9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ea0 - U+1ebf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ec0 - U+1edf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ee0 - U+1eff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f00 - U+1f1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f20 - U+1f3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f40 - U+1f5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f60 - U+1f7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f80 - U+1f9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1fa0 - U+1fbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1fc0 - U+1fdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1fe0 - U+1fff */
  0x55,0x55,0x54,0x00,0x96,0xa9,0xa5,0xa5,	/* U+2000 - U+201f */
  0xa9,0xaa,0x50,0x01,0x9a,0x65,0x56,0x59,	/* U+2020 - U+203f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+2040 - U+205f */
  0x00,0x55,0x50,0x00,0x55,0x95,0x55,0x56,	/* U+2060 - U+207f */
  0x6a,0x95,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+2080 - U+209f */
  0x55,0x55,0x55,0x95,0x55,0x55,0x55,0x55,	/* U+20a0 - U+20bf */
  0x55,0x55,0x55,0x55,0x00,0x00,0x00,0x00,	/* U+20c0 - U+20df */
  0x00,0x00,0x00,0x00,0x55,0x55,0x55,0x55,	/* U+20e0 - U+20ff */
  0x56,0x65,0x65,0x55,0x56,0x59,0x55,0x55,	/* U+2100 - U+211f */
  0x69,0x59,0x56,0x55,0x55,0x55,0x55,0x55,	/* U+2120 - U+213f */
  0x55,0x55,0x55,0x55,0x56,0x95,0x56,0xa9,	/* U+2140 - U+215f */
  0xaa,0xaa,0xaa,0x55,0xaa,0xaa,0xa5,0x55,	/* U+2160 - U+217f */
  0x55,0x55,0x55,0x55,0xaa,0xaa,0xa5,0x55,	/* U+2180 - U+219f */
  0x55,0x55,0x55,0x55,0x55,0x55,0xa5,0x55,	/* U+21a0 - U+21bf */
  0x55,0x55,0x55,0x55,0x59,0x95,0x55,0x55,	/* U+21c0 - U+21df */
  0x55,0x56,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+21e0 - U+21ff */
  0x9a,0x56,0x96,0x56,0x65,0x65,0x59,0x6a,	/* U+2200 - U+221f */
  0x96,0x66,0xaa,0x99,0x55,0xaa,0x55,0xa5,	/* U+2220 - U+223f */
  0x55,0x55,0x95,0x95,0x59,0x55,0x55,0x55,	/* U+2240 - U+225f */
  0xa5,0xaa,0x5a,0x5a,0x55,0x55,0x55,0x55,	/* U+2260 - U+227f */
  0x5a,0x5a,0x55,0x55,0x55,0x65,0x65,0x55,	/* U+2280 - U+229f */
  0x55,0x65,0x55,0x55,0x55,0x55,0x55,0x56,	/* U+22a0 - U+22bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+22c0 - U+22df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+22e0 - U+22ff */
  0x55,0x55,0x55,0x55,0x59,0x55,0x55,0x55,	/* U+2300 - U+231f */
  0x55,0x55,0x69,0x55,0x55,0x55,0x55,0x55,	/* U+2320 - U+233f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+2340 - U+235f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+2360 - U+237f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+2380 - U+239f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+23a0 - U+23bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+23c0 - U+23df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+23e0 - U+23ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+2400 - U+241f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+2420 - U+243f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+2440 - U+245f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2460 - U+247f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2480 - U+249f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24a0 - U+24bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24c0 - U+24df */
  0xaa,0xaa,0xa6,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24e0 - U+24ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2500 - U+251f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2520 - U+253f */
  0xaa,0xaa,0xaa,0x55,0xaa,0xaa,0xaa,0xaa,	/* U+2540 - U+255f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0x55,0x55,0x55,	/* U+2560 - U+257f */
  0xaa,0xaa,0xaa,0xaa,0x5a,0xa5,0x55,0x55,	/* U+2580 - U+259f */
  0xa6,0xaa,0xa5,0x55,0x5a,0x5a,0x55,0xa5,	/* U+25a0 - U+25bf */
  0xa5,0x5a,0x96,0x5a,0xa5,0x55,0x55,0x55,	/* U+25c0 - U+25df */
  0x5a,0xa5,0x55,0x56,0x55,0x55,0x55,0x55,	/* U+25e0 - U+25ff */
  0x55,0x69,0x65,0x5a,0x55,0xa5,0x55,0x99,	/* U+2600 - U+261f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+2620 - U+263f */
  0x99,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+2640 - U+265f */
  0xa6,0xa6,0xa9,0xa6,0x55,0x55,0x55,0x55,	/* U+2660 - U+267f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+2680 - U+269f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+26a0 - U+26bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+26c0 - U+26df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+26e0 - U+26ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+2700 - U+271f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x65,	/* U+2720 - U+273f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+2740 - U+275f */
  0x55,0x55,0x55,0x55,0x55,0x5a,0xaa,0xaa,	/* U+2760 - U+277f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+2780 - U+279f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+27a0 - U+27bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+27c0 - U+27df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+27e0 - U+27ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+2800 - U+281f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+2820 - U+283f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+2840 - U+285f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+2860 - U+287f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+2880 - U+289f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+28a0 - U+28bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+28c0 - U+28df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+28e0 - U+28ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+2900 - U+291f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+2920 - U+293f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+2940 - U+295f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+2960 - U+297f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+2980 - U+299f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+29a0 - U+29bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+29c0 - U+29df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+29e0 - U+29ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+2a00 - U+2a1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+2a20 - U+2a3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+2a40 - U+2a5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+2a60 - U+2a7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+2a80 - U+2a9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+2aa0 - U+2abf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+2ac0 - U+2adf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+2ae0 - U+2aff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+2b00 - U+2b1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+2b20 - U+2b3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+2b40 - U+2b5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+2b60 - U+2b7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+2b80 - U+2b9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+2ba0 - U+2bbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+2bc0 - U+2bdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+2be0 - U+2bff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+2c00 - U+2c1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+2c20 - U+2c3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+2c40 - U+2c5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+2c60 - U+2c7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+2c80 - U+2c9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+2ca0 - U+2cbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+2cc0 - U+2cdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+2ce0 - U+2cff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+2d00 - U+2d1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+2d20 - U+2d3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+2d40 - U+2d5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+2d60 - U+2d7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+2d80 - U+2d9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+2da0 - U+2dbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+2dc0 - U+2ddf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+2de0 - U+2dff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+2e00 - U+2e1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+2e20 - U+2e3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+2e40 - U+2e5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+2e60 - U+2e7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xa6,0xaa,	/* U+2e80 - U+2e9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ea0 - U+2ebf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ec0 - U+2edf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0x55,0x55,0x55,	/* U+2ee0 - U+2eff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f00 - U+2f1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f20 - U+2f3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f40 - U+2f5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f60 - U+2f7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f80 - U+2f9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2fa0 - U+2fbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xa5,0x55,0x55,	/* U+2fc0 - U+2fdf */
  0x55,0x55,0x55,0x55,0xaa,0xaa,0xaa,0x55,	/* U+2fe0 - U+2fff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3000 - U+301f */
  0xaa,0xaa,0xa0,0x00,0xaa,0xaa,0xaa,0xa9,	/* U+3020 - U+303f */
  0x6a,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3040 - U+305f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3060 - U+307f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xa9,0x42,0xaa,	/* U+3080 - U+309f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+30a0 - U+30bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+30c0 - U+30df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+30e0 - U+30ff */
  0x55,0x6a,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3100 - U+311f */
  0xaa,0xaa,0xaa,0x95,0x6a,0xaa,0xaa,0xaa,	/* U+3120 - U+313f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3140 - U+315f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3160 - U+317f */
  0xaa,0xaa,0xaa,0xa9,0xaa,0xaa,0xaa,0xaa,	/* U+3180 - U+319f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x55,0x55,	/* U+31a0 - U+31bf */
  0xaa,0xaa,0xaa,0xaa,0x55,0x55,0x55,0x55,	/* U+31c0 - U+31df */
  0x55,0x55,0x55,0x55,0xaa,0xaa,0xaa,0xaa,	/* U+31e0 - U+31ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xa9,	/* U+3200 - U+321f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3220 - U+323f */
  0xaa,0x55,0x55,0x55,0xaa,0xaa,0xaa,0xaa,	/* U+3240 - U+325f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3260 - U+327f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3280 - U+329f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+32a0 - U+32bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+32c0 - U+32df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xa9,	/* U+32e0 - U+32ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3300 - U+331f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3320 - U+333f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3340 - U+335f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3360 - U+337f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3380 - U+339f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+33a0 - U+33bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+33c0 - U+33df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+33e0 - U+33ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3400 - U+341f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3420 - U+343f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3440 - U+345f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3460 - U+347f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3480 - U+349f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+34a0 - U+34bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+34c0 - U+34df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+34e0 - U+34ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3500 - U+351f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3520 - U+353f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3540 - U+355f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3560 - U+357f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3580 - U+359f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+35a0 - U+35bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+35c0 - U+35df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+35e0 - U+35ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3600 - U+361f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3620 - U+363f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3640 - U+365f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3660 - U+367f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3680 - U+369f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+36a0 - U+36bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+36c0 - U+36df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+36e0 - U+36ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3700 - U+371f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3720 - U+373f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3740 - U+375f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3760 - U+377f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3780 - U+379f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+37a0 - U+37bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+37c0 - U+37df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+37e0 - U+37ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3800 - U+381f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3820 - U+383f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3840 - U+385f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3860 - U+387f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3880 - U+389f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+38a0 - U+38bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+38c0 - U+38df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+38e0 - U+38ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3900 - U+391f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3920 - U+393f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3940 - U+395f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3960 - U+397f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3980 - U+399f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+39a0 - U+39bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+39c0 - U+39df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+39e0 - U+39ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3a00 - U+3a1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3a20 - U+3a3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3a40 - U+3a5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3a60 - U+3a7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3a80 - U+3a9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3aa0 - U+3abf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3ac0 - U+3adf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3ae0 - U+3aff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3b00 - U+3b1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3b20 - U+3b3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3b40 - U+3b5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3b60 - U+3b7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3b80 - U+3b9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3ba0 - U+3bbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3bc0 - U+3bdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3be0 - U+3bff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3c00 - U+3c1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3c20 - U+3c3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3c40 - U+3c5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3c60 - U+3c7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3c80 - U+3c9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3ca0 - U+3cbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3cc0 - U+3cdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3ce0 - U+3cff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3d00 - U+3d1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3d20 - U+3d3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3d40 - U+3d5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3d60 - U+3d7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3d80 - U+3d9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3da0 - U+3dbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3dc0 - U+3ddf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3de0 - U+3dff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3e00 - U+3e1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3e20 - U+3e3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3e40 - U+3e5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3e60 - U+3e7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3e80 - U+3e9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3ea0 - U+3ebf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3ec0 - U+3edf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3ee0 - U+3eff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3f00 - U+3f1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3f20 - U+3f3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3f40 - U+3f5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3f60 - U+3f7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3f80 - U+3f9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3fa0 - U+3fbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3fc0 - U+3fdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+3fe0 - U+3fff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4000 - U+401f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4020 - U+403f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4040 - U+405f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4060 - U+407f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4080 - U+409f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+40a0 - U+40bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+40c0 - U+40df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+40e0 - U+40ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4100 - U+411f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4120 - U+413f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4140 - U+415f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4160 - U+417f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4180 - U+419f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+41a0 - U+41bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+41c0 - U+41df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+41e0 - U+41ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4200 - U+421f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4220 - U+423f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4240 - U+425f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4260 - U+427f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4280 - U+429f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+42a0 - U+42bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+42c0 - U+42df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+42e0 - U+42ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4300 - U+431f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4320 - U+433f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4340 - U+435f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4360 - U+437f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4380 - U+439f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+43a0 - U+43bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+43c0 - U+43df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+43e0 - U+43ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4400 - U+441f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4420 - U+443f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4440 - U+445f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4460 - U+447f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4480 - U+449f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+44a0 - U+44bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+44c0 - U+44df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+44e0 - U+44ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4500 - U+451f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4520 - U+453f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4540 - U+455f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4560 - U+457f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4580 - U+459f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+45a0 - U+45bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+45c0 - U+45df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+45e0 - U+45ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4600 - U+461f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4620 - U+463f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4640 - U+465f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4660 - U+467f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4680 - U+469f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+46a0 - U+46bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+46c0 - U+46df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+46e0 - U+46ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4700 - U+471f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4720 - U+473f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4740 - U+475f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4760 - U+477f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4780 - U+479f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+47a0 - U+47bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+47c0 - U+47df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+47e0 - U+47ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4800 - U+481f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4820 - U+483f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4840 - U+485f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4860 - U+487f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4880 - U+489f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+48a0 - U+48bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+48c0 - U+48df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+48e0 - U+48ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4900 - U+491f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4920 - U+493f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4940 - U+495f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4960 - U+497f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4980 - U+499f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+49a0 - U+49bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+49c0 - U+49df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+49e0 - U+49ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4a00 - U+4a1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4a20 - U+4a3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4a40 - U+4a5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4a60 - U+4a7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4a80 - U+4a9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4aa0 - U+4abf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4ac0 - U+4adf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4ae0 - U+4aff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4b00 - U+4b1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4b20 - U+4b3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4b40 - U+4b5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4b60 - U+4b7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4b80 - U+4b9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4ba0 - U+4bbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4bc0 - U+4bdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4be0 - U+4bff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4c00 - U+4c1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4c20 - U+4c3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4c40 - U+4c5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4c60 - U+4c7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4c80 - U+4c9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4ca0 - U+4cbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4cc0 - U+4cdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4ce0 - U+4cff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4d00 - U+4d1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4d20 - U+4d3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4d40 - U+4d5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4d60 - U+4d7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4d80 - U+4d9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xa5,0x55,0x55,	/* U+4da0 - U+4dbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+4dc0 - U+4ddf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+4de0 - U+4dff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4e00 - U+4e1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4e20 - U+4e3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4e40 - U+4e5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4e60 - U+4e7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4e80 - U+4e9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4ea0 - U+4ebf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4ec0 - U+4edf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4ee0 - U+4eff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4f00 - U+4f1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4f20 - U+4f3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4f40 - U+4f5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4f60 - U+4f7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4f80 - U+4f9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4fa0 - U+4fbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4fc0 - U+4fdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+4fe0 - U+4fff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5000 - U+501f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5020 - U+503f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5040 - U+505f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5060 - U+507f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5080 - U+509f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+50a0 - U+50bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+50c0 - U+50df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+50e0 - U+50ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5100 - U+511f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5120 - U+513f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5140 - U+515f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5160 - U+517f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5180 - U+519f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+51a0 - U+51bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+51c0 - U+51df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+51e0 - U+51ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5200 - U+521f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5220 - U+523f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5240 - U+525f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5260 - U+527f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5280 - U+529f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+52a0 - U+52bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+52c0 - U+52df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+52e0 - U+52ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5300 - U+531f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5320 - U+533f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5340 - U+535f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5360 - U+537f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5380 - U+539f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+53a0 - U+53bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+53c0 - U+53df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+53e0 - U+53ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5400 - U+541f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5420 - U+543f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5440 - U+545f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5460 - U+547f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5480 - U+549f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+54a0 - U+54bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+54c0 - U+54df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+54e0 - U+54ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5500 - U+551f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5520 - U+553f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5540 - U+555f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5560 - U+557f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5580 - U+559f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+55a0 - U+55bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+55c0 - U+55df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+55e0 - U+55ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5600 - U+561f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5620 - U+563f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5640 - U+565f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5660 - U+567f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5680 - U+569f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+56a0 - U+56bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+56c0 - U+56df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+56e0 - U+56ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5700 - U+571f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5720 - U+573f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5740 - U+575f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5760 - U+577f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5780 - U+579f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+57a0 - U+57bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+57c0 - U+57df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+57e0 - U+57ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5800 - U+581f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5820 - U+583f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5840 - U+585f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5860 - U+587f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5880 - U+589f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+58a0 - U+58bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+58c0 - U+58df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+58e0 - U+58ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5900 - U+591f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5920 - U+593f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5940 - U+595f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5960 - U+597f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5980 - U+599f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+59a0 - U+59bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+59c0 - U+59df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+59e0 - U+59ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5a00 - U+5a1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5a20 - U+5a3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5a40 - U+5a5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5a60 - U+5a7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5a80 - U+5a9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5aa0 - U+5abf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5ac0 - U+5adf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5ae0 - U+5aff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5b00 - U+5b1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5b20 - U+5b3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5b40 - U+5b5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5b60 - U+5b7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5b80 - U+5b9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5ba0 - U+5bbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5bc0 - U+5bdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5be0 - U+5bff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5c00 - U+5c1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5c20 - U+5c3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5c40 - U+5c5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5c60 - U+5c7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5c80 - U+5c9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5ca0 - U+5cbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5cc0 - U+5cdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5ce0 - U+5cff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5d00 - U+5d1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5d20 - U+5d3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5d40 - U+5d5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5d60 - U+5d7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5d80 - U+5d9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5da0 - U+5dbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5dc0 - U+5ddf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5de0 - U+5dff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5e00 - U+5e1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5e20 - U+5e3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5e40 - U+5e5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5e60 - U+5e7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5e80 - U+5e9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5ea0 - U+5ebf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5ec0 - U+5edf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5ee0 - U+5eff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5f00 - U+5f1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5f20 - U+5f3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5f40 - U+5f5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5f60 - U+5f7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5f80 - U+5f9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5fa0 - U+5fbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5fc0 - U+5fdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+5fe0 - U+5fff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6000 - U+601f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6020 - U+603f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6040 - U+605f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6060 - U+607f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6080 - U+609f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+60a0 - U+60bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+60c0 - U+60df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+60e0 - U+60ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6100 - U+611f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6120 - U+613f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6140 - U+615f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6160 - U+617f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6180 - U+619f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+61a0 - U+61bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+61c0 - U+61df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+61e0 - U+61ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6200 - U+621f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6220 - U+623f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6240 - U+625f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6260 - U+627f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6280 - U+629f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+62a0 - U+62bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+62c0 - U+62df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+62e0 - U+62ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6300 - U+631f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6320 - U+633f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6340 - U+635f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6360 - U+637f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6380 - U+639f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+63a0 - U+63bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+63c0 - U+63df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+63e0 - U+63ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6400 - U+641f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6420 - U+643f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6440 - U+645f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6460 - U+647f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6480 - U+649f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+64a0 - U+64bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+64c0 - U+64df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+64e0 - U+64ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6500 - U+651f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6520 - U+653f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6540 - U+655f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6560 - U+657f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6580 - U+659f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+65a0 - U+65bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+65c0 - U+65df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+65e0 - U+65ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6600 - U+661f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6620 - U+663f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6640 - U+665f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6660 - U+667f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6680 - U+669f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+66a0 - U+66bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+66c0 - U+66df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+66e0 - U+66ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6700 - U+671f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6720 - U+673f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6740 - U+675f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6760 - U+677f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6780 - U+679f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+67a0 - U+67bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+67c0 - U+67df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+67e0 - U+67ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6800 - U+681f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6820 - U+683f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6840 - U+685f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6860 - U+687f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6880 - U+689f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+68a0 - U+68bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+68c0 - U+68df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+68e0 - U+68ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6900 - U+691f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6920 - U+693f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6940 - U+695f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6960 - U+697f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6980 - U+699f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+69a0 - U+69bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+69c0 - U+69df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+69e0 - U+69ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6a00 - U+6a1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6a20 - U+6a3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6a40 - U+6a5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6a60 - U+6a7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6a80 - U+6a9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6aa0 - U+6abf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6ac0 - U+6adf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6ae0 - U+6aff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6b00 - U+6b1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6b20 - U+6b3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6b40 - U+6b5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6b60 - U+6b7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6b80 - U+6b9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6ba0 - U+6bbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6bc0 - U+6bdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6be0 - U+6bff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6c00 - U+6c1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6c20 - U+6c3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6c40 - U+6c5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6c60 - U+6c7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6c80 - U+6c9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6ca0 - U+6cbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6cc0 - U+6cdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6ce0 - U+6cff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6d00 - U+6d1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6d20 - U+6d3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6d40 - U+6d5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6d60 - U+6d7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6d80 - U+6d9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6da0 - U+6dbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6dc0 - U+6ddf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6de0 - U+6dff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6e00 - U+6e1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6e20 - U+6e3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6e40 - U+6e5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6e60 - U+6e7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6e80 - U+6e9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6ea0 - U+6ebf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6ec0 - U+6edf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6ee0 - U+6eff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6f00 - U+6f1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6f20 - U+6f3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6f40 - U+6f5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6f60 - U+6f7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6f80 - U+6f9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6fa0 - U+6fbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6fc0 - U+6fdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+6fe0 - U+6fff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7000 - U+701f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7020 - U+703f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7040 - U+705f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7060 - U+707f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7080 - U+709f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+70a0 - U+70bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+70c0 - U+70df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+70e0 - U+70ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7100 - U+711f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7120 - U+713f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7140 - U+715f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7160 - U+717f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7180 - U+719f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+71a0 - U+71bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+71c0 - U+71df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+71e0 - U+71ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7200 - U+721f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7220 - U+723f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7240 - U+725f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7260 - U+727f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7280 - U+729f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+72a0 - U+72bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+72c0 - U+72df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+72e0 - U+72ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7300 - U+731f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7320 - U+733f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7340 - U+735f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7360 - U+737f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7380 - U+739f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+73a0 - U+73bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+73c0 - U+73df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+73e0 - U+73ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7400 - U+741f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7420 - U+743f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7440 - U+745f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7460 - U+747f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7480 - U+749f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+74a0 - U+74bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+74c0 - U+74df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+74e0 - U+74ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7500 - U+751f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7520 - U+753f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7540 - U+755f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7560 - U+757f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7580 - U+759f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+75a0 - U+75bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+75c0 - U+75df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+75e0 - U+75ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7600 - U+761f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7620 - U+763f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7640 - U+765f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7660 - U+767f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7680 - U+769f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+76a0 - U+76bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+76c0 - U+76df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+76e0 - U+76ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7700 - U+771f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7720 - U+773f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7740 - U+775f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7760 - U+777f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7780 - U+779f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+77a0 - U+77bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+77c0 - U+77df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+77e0 - U+77ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7800 - U+781f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7820 - U+783f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7840 - U+785f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7860 - U+787f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7880 - U+789f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+78a0 - U+78bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+78c0 - U+78df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+78e0 - U+78ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7900 - U+791f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7920 - U+793f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7940 - U+795f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7960 - U+797f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7980 - U+799f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+79a0 - U+79bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+79c0 - U+79df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+79e0 - U+79ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7a00 - U+7a1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7a20 - U+7a3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7a40 - U+7a5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7a60 - U+7a7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7a80 - U+7a9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7aa0 - U+7abf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7ac0 - U+7adf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7ae0 - U+7aff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7b00 - U+7b1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7b20 - U+7b3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7b40 - U+7b5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7b60 - U+7b7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7b80 - U+7b9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7ba0 - U+7bbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7bc0 - U+7bdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7be0 - U+7bff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7c00 - U+7c1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7c20 - U+7c3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7c40 - U+7c5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7c60 - U+7c7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7c80 - U+7c9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7ca0 - U+7cbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7cc0 - U+7cdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7ce0 - U+7cff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7d00 - U+7d1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7d20 - U+7d3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7d40 - U+7d5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7d60 - U+7d7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7d80 - U+7d9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7da0 - U+7dbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7dc0 - U+7ddf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7de0 - U+7dff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7e00 - U+7e1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7e20 - U+7e3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7e40 - U+7e5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7e60 - U+7e7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7e80 - U+7e9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7ea0 - U+7ebf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7ec0 - U+7edf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7ee0 - U+7eff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7f00 - U+7f1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7f20 - U+7f3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7f40 - U+7f5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7f60 - U+7f7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7f80 - U+7f9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7fa0 - U+7fbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7fc0 - U+7fdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+7fe0 - U+7fff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8000 - U+801f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8020 - U+803f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8040 - U+805f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8060 - U+807f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8080 - U+809f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+80a0 - U+80bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+80c0 - U+80df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+80e0 - U+80ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8100 - U+811f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8120 - U+813f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8140 - U+815f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8160 - U+817f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8180 - U+819f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+81a0 - U+81bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+81c0 - U+81df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+81e0 - U+81ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8200 - U+821f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8220 - U+823f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8240 - U+825f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8260 - U+827f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8280 - U+829f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+82a0 - U+82bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+82c0 - U+82df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+82e0 - U+82ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8300 - U+831f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8320 - U+833f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8340 - U+835f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8360 - U+837f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8380 - U+839f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+83a0 - U+83bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+83c0 - U+83df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+83e0 - U+83ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8400 - U+841f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8420 - U+843f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8440 - U+845f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8460 - U+847f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8480 - U+849f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+84a0 - U+84bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+84c0 - U+84df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+84e0 - U+84ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8500 - U+851f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8520 - U+853f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8540 - U+855f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8560 - U+857f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8580 - U+859f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+85a0 - U+85bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+85c0 - U+85df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+85e0 - U+85ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8600 - U+861f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8620 - U+863f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8640 - U+865f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8660 - U+867f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8680 - U+869f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+86a0 - U+86bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+86c0 - U+86df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+86e0 - U+86ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8700 - U+871f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8720 - U+873f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8740 - U+875f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8760 - U+877f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8780 - U+879f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+87a0 - U+87bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+87c0 - U+87df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+87e0 - U+87ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8800 - U+881f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8820 - U+883f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8840 - U+885f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8860 - U+887f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8880 - U+889f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+88a0 - U+88bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+88c0 - U+88df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+88e0 - U+88ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8900 - U+891f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8920 - U+893f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8940 - U+895f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8960 - U+897f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8980 - U+899f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+89a0 - U+89bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+89c0 - U+89df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+89e0 - U+89ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8a00 - U+8a1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8a20 - U+8a3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8a40 - U+8a5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8a60 - U+8a7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8a80 - U+8a9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8aa0 - U+8abf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8ac0 - U+8adf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8ae0 - U+8aff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8b00 - U+8b1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8b20 - U+8b3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8b40 - U+8b5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8b60 - U+8b7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8b80 - U+8b9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8ba0 - U+8bbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8bc0 - U+8bdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8be0 - U+8bff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8c00 - U+8c1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8c20 - U+8c3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8c40 - U+8c5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8c60 - U+8c7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8c80 - U+8c9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8ca0 - U+8cbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8cc0 - U+8cdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8ce0 - U+8cff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8d00 - U+8d1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8d20 - U+8d3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8d40 - U+8d5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8d60 - U+8d7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8d80 - U+8d9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8da0 - U+8dbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8dc0 - U+8ddf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8de0 - U+8dff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8e00 - U+8e1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8e20 - U+8e3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8e40 - U+8e5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8e60 - U+8e7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8e80 - U+8e9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8ea0 - U+8ebf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8ec0 - U+8edf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8ee0 - U+8eff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8f00 - U+8f1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8f20 - U+8f3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8f40 - U+8f5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8f60 - U+8f7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8f80 - U+8f9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8fa0 - U+8fbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8fc0 - U+8fdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+8fe0 - U+8fff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9000 - U+901f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9020 - U+903f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9040 - U+905f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9060 - U+907f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9080 - U+909f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+90a0 - U+90bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+90c0 - U+90df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+90e0 - U+90ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9100 - U+911f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9120 - U+913f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9140 - U+915f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9160 - U+917f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9180 - U+919f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+91a0 - U+91bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+91c0 - U+91df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+91e0 - U+91ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9200 - U+921f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9220 - U+923f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9240 - U+925f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9260 - U+927f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9280 - U+929f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+92a0 - U+92bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+92c0 - U+92df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+92e0 - U+92ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9300 - U+931f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9320 - U+933f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9340 - U+935f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9360 - U+937f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9380 - U+939f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+93a0 - U+93bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+93c0 - U+93df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+93e0 - U+93ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9400 - U+941f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9420 - U+943f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9440 - U+945f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9460 - U+947f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9480 - U+949f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+94a0 - U+94bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+94c0 - U+94df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+94e0 - U+94ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9500 - U+951f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9520 - U+953f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9540 - U+955f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9560 - U+957f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9580 - U+959f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+95a0 - U+95bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+95c0 - U+95df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+95e0 - U+95ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9600 - U+961f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9620 - U+963f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9640 - U+965f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9660 - U+967f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9680 - U+969f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+96a0 - U+96bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+96c0 - U+96df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+96e0 - U+96ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9700 - U+971f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9720 - U+973f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9740 - U+975f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9760 - U+977f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9780 - U+979f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+97a0 - U+97bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+97c0 - U+97df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+97e0 - U+97ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9800 - U+981f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9820 - U+983f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9840 - U+985f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9860 - U+987f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9880 - U+989f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+98a0 - U+98bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+98c0 - U+98df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+98e0 - U+98ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9900 - U+991f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9920 - U+993f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9940 - U+995f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9960 - U+997f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9980 - U+999f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+99a0 - U+99bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+99c0 - U+99df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+99e0 - U+99ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9a00 - U+9a1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9a20 - U+9a3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9a40 - U+9a5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9a60 - U+9a7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9a80 - U+9a9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9aa0 - U+9abf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9ac0 - U+9adf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9ae0 - U+9aff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9b00 - U+9b1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9b20 - U+9b3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9b40 - U+9b5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9b60 - U+9b7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9b80 - U+9b9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9ba0 - U+9bbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9bc0 - U+9bdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9be0 - U+9bff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9c00 - U+9c1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9c20 - U+9c3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9c40 - U+9c5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9c60 - U+9c7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9c80 - U+9c9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9ca0 - U+9cbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9cc0 - U+9cdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9ce0 - U+9cff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9d00 - U+9d1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9d20 - U+9d3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9d40 - U+9d5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9d60 - U+9d7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9d80 - U+9d9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9da0 - U+9dbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9dc0 - U+9ddf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9de0 - U+9dff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9e00 - U+9e1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9e20 - U+9e3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9e40 - U+9e5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9e60 - U+9e7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9e80 - U+9e9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9ea0 - U+9ebf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9ec0 - U+9edf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9ee0 - U+9eff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9f00 - U+9f1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9f20 - U+9f3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9f40 - U+9f5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9f60 - U+9f7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+9f80 - U+9f9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x55,	/* U+9fa0 - U+9fbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+9fc0 - U+9fdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+9fe0 - U+9fff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+a000 - U+a01f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+a020 - U+a03f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+a040 - U+a05f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+a060 - U+a07f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+a080 - U+a09f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+a0a0 - U+a0bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+a0c0 - U+a0df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+a0e0 - U+a0ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+a100 - U+a11f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+a120 - U+a13f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+a140 - U+a15f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+a160 - U+a17f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+a180 - U+a19f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+a1a0 - U+a1bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+a1c0 - U+a1df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+a1e0 - U+a1ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+a200 - U+a21f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+a220 - U+a23f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+a240 - U+a25f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+a260 - U+a27f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+a280 - U+a29f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+a2a0 - U+a2bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+a2c0 - U+a2df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+a2e0 - U+a2ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+a300 - U+a31f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+a320 - U+a33f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+a340 - U+a35f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+a360 - U+a37f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+a380 - U+a39f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+a3a0 - U+a3bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+a3c0 - U+a3df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+a3e0 - U+a3ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+a400 - U+a41f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+a420 - U+a43f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+a440 - U+a45f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+a460 - U+a47f */
  0xaa,0xaa,0xaa,0x95,0xaa,0xaa,0xaa,0xaa,	/* U+a480 - U+a49f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+a4a0 - U+a4bf */
  0xaa,0xa9,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+a4c0 - U+a4df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+a4e0 - U+a4ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+a500 - U+a51f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+a520 - U+a53f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+a540 - U+a55f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+a560 - U+a57f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+a580 - U+a59f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+a5a0 - U+a5bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+a5c0 - U+a5df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+a5e0 - U+a5ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+a600 - U+a61f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+a620 - U+a63f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+a640 - U+a65f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+a660 - U+a67f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+a680 - U+a69f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+a6a0 - U+a6bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+a6c0 - U+a6df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+a6e0 - U+a6ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+a700 - U+a71f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+a720 - U+a73f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+a740 - U+a75f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+a760 - U+a77f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+a780 - U+a79f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+a7a0 - U+a7bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+a7c0 - U+a7df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+a7e0 - U+a7ff */
  0x51,0x51,0x54,0x55,0x55,0x55,0x55,0x55,	/* U+a800 - U+a81f */
  0x55,0x41,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+a820 - U+a83f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+a840 - U+a85f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+a860 - U+a87f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+a880 - U+a89f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+a8a0 - U+a8bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+a8c0 - U+a8df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+a8e0 - U+a8ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+a900 - U+a91f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+a920 - U+a93f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+a940 - U+a95f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+a960 - U+a97f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+a980 - U+a99f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+a9a0 - U+a9bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+a9c0 - U+a9df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+a9e0 - U+a9ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+aa00 - U+aa1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+aa20 - U+aa3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+aa40 - U+aa5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+aa60 - U+aa7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+aa80 - U+aa9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+aaa0 - U+aabf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+aac0 - U+aadf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+aae0 - U+aaff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+ab00 - U+ab1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+ab20 - U+ab3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+ab40 - U+ab5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+ab60 - U+ab7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+ab80 - U+ab9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+aba0 - U+abbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+abc0 - U+abdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+abe0 - U+abff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+ac00 - U+ac1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+ac20 - U+ac3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+ac40 - U+ac5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+ac60 - U+ac7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+ac80 - U+ac9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+aca0 - U+acbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+acc0 - U+acdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+ace0 - U+acff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+ad00 - U+ad1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+ad20 - U+ad3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+ad40 - U+ad5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+ad60 - U+ad7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+ad80 - U+ad9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+ada0 - U+adbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+adc0 - U+addf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+ade0 - U+adff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+ae00 - U+ae1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+ae20 - U+ae3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+ae40 - U+ae5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+ae60 - U+ae7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+ae80 - U+ae9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+aea0 - U+aebf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+aec0 - U+aedf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+aee0 - U+aeff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+af00 - U+af1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+af20 - U+af3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+af40 - U+af5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+af60 - U+af7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+af80 - U+af9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+afa0 - U+afbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+afc0 - U+afdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+afe0 - U+afff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b000 - U+b01f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b020 - U+b03f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b040 - U+b05f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b060 - U+b07f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b080 - U+b09f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b0a0 - U+b0bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b0c0 - U+b0df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b0e0 - U+b0ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b100 - U+b11f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b120 - U+b13f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b140 - U+b15f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b160 - U+b17f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b180 - U+b19f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b1a0 - U+b1bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b1c0 - U+b1df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b1e0 - U+b1ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b200 - U+b21f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b220 - U+b23f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b240 - U+b25f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b260 - U+b27f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b280 - U+b29f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b2a0 - U+b2bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b2c0 - U+b2df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b2e0 - U+b2ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b300 - U+b31f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b320 - U+b33f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b340 - U+b35f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b360 - U+b37f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b380 - U+b39f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b3a0 - U+b3bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b3c0 - U+b3df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b3e0 - U+b3ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b400 - U+b41f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b420 - U+b43f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b440 - U+b45f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b460 - U+b47f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b480 - U+b49f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b4a0 - U+b4bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b4c0 - U+b4df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b4e0 - U+b4ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b500 - U+b51f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b520 - U+b53f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b540 - U+b55f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b560 - U+b57f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b580 - U+b59f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b5a0 - U+b5bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b5c0 - U+b5df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b5e0 - U+b5ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b600 - U+b61f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b620 - U+b63f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b640 - U+b65f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b660 - U+b67f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b680 - U+b69f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b6a0 - U+b6bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b6c0 - U+b6df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b6e0 - U+b6ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b700 - U+b71f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b720 - U+b73f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b740 - U+b75f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b760 - U+b77f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b780 - U+b79f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b7a0 - U+b7bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b7c0 - U+b7df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b7e0 - U+b7ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b800 - U+b81f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b820 - U+b83f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b840 - U+b85f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b860 - U+b87f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b880 - U+b89f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b8a0 - U+b8bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b8c0 - U+b8df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b8e0 - U+b8ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b900 - U+b91f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b920 - U+b93f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b940 - U+b95f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b960 - U+b97f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b980 - U+b99f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b9a0 - U+b9bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b9c0 - U+b9df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+b9e0 - U+b9ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+ba00 - U+ba1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+ba20 - U+ba3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+ba40 - U+ba5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+ba60 - U+ba7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+ba80 - U+ba9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+baa0 - U+babf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+bac0 - U+badf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+bae0 - U+baff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+bb00 - U+bb1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+bb20 - U+bb3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+bb40 - U+bb5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+bb60 - U+bb7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+bb80 - U+bb9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+bba0 - U+bbbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+bbc0 - U+bbdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+bbe0 - U+bbff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+bc00 - U+bc1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+bc20 - U+bc3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+bc40 - U+bc5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+bc60 - U+bc7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+bc80 - U+bc9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+bca0 - U+bcbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+bcc0 - U+bcdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+bce0 - U+bcff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+bd00 - U+bd1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+bd20 - U+bd3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+bd40 - U+bd5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+bd60 - U+bd7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+bd80 - U+bd9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+bda0 - U+bdbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+bdc0 - U+bddf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+bde0 - U+bdff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+be00 - U+be1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+be20 - U+be3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+be40 - U+be5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+be60 - U+be7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+be80 - U+be9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+bea0 - U+bebf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+bec0 - U+bedf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+bee0 - U+beff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+bf00 - U+bf1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+bf20 - U+bf3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+bf40 - U+bf5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+bf60 - U+bf7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+bf80 - U+bf9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+bfa0 - U+bfbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+bfc0 - U+bfdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+bfe0 - U+bfff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c000 - U+c01f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c020 - U+c03f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c040 - U+c05f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c060 - U+c07f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c080 - U+c09f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c0a0 - U+c0bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c0c0 - U+c0df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c0e0 - U+c0ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c100 - U+c11f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c120 - U+c13f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c140 - U+c15f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c160 - U+c17f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c180 - U+c19f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c1a0 - U+c1bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c1c0 - U+c1df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c1e0 - U+c1ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c200 - U+c21f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c220 - U+c23f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c240 - U+c25f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c260 - U+c27f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c280 - U+c29f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c2a0 - U+c2bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c2c0 - U+c2df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c2e0 - U+c2ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c300 - U+c31f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c320 - U+c33f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c340 - U+c35f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c360 - U+c37f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c380 - U+c39f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c3a0 - U+c3bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c3c0 - U+c3df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c3e0 - U+c3ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c400 - U+c41f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c420 - U+c43f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c440 - U+c45f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c460 - U+c47f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c480 - U+c49f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c4a0 - U+c4bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c4c0 - U+c4df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c4e0 - U+c4ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c500 - U+c51f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c520 - U+c53f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c540 - U+c55f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c560 - U+c57f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c580 - U+c59f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c5a0 - U+c5bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c5c0 - U+c5df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c5e0 - U+c5ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c600 - U+c61f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c620 - U+c63f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c640 - U+c65f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c660 - U+c67f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c680 - U+c69f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c6a0 - U+c6bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c6c0 - U+c6df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c6e0 - U+c6ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c700 - U+c71f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c720 - U+c73f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c740 - U+c75f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c760 - U+c77f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c780 - U+c79f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c7a0 - U+c7bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c7c0 - U+c7df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c7e0 - U+c7ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c800 - U+c81f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c820 - U+c83f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c840 - U+c85f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c860 - U+c87f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c880 - U+c89f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c8a0 - U+c8bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c8c0 - U+c8df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c8e0 - U+c8ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c900 - U+c91f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c920 - U+c93f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c940 - U+c95f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c960 - U+c97f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c980 - U+c99f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c9a0 - U+c9bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c9c0 - U+c9df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+c9e0 - U+c9ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+ca00 - U+ca1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+ca20 - U+ca3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+ca40 - U+ca5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+ca60 - U+ca7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+ca80 - U+ca9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+caa0 - U+cabf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+cac0 - U+cadf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+cae0 - U+caff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+cb00 - U+cb1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+cb20 - U+cb3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+cb40 - U+cb5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+cb60 - U+cb7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+cb80 - U+cb9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+cba0 - U+cbbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+cbc0 - U+cbdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+cbe0 - U+cbff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+cc00 - U+cc1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+cc20 - U+cc3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+cc40 - U+cc5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+cc60 - U+cc7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+cc80 - U+cc9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+cca0 - U+ccbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+ccc0 - U+ccdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+cce0 - U+ccff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+cd00 - U+cd1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+cd20 - U+cd3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+cd40 - U+cd5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+cd60 - U+cd7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+cd80 - U+cd9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+cda0 - U+cdbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+cdc0 - U+cddf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+cde0 - U+cdff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+ce00 - U+ce1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+ce20 - U+ce3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+ce40 - U+ce5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+ce60 - U+ce7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+ce80 - U+ce9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+cea0 - U+cebf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+cec0 - U+cedf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+cee0 - U+ceff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+cf00 - U+cf1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+cf20 - U+cf3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+cf40 - U+cf5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+cf60 - U+cf7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+cf80 - U+cf9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+cfa0 - U+cfbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+cfc0 - U+cfdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+cfe0 - U+cfff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+d000 - U+d01f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+d020 - U+d03f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+d040 - U+d05f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+d060 - U+d07f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+d080 - U+d09f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+d0a0 - U+d0bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+d0c0 - U+d0df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+d0e0 - U+d0ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+d100 - U+d11f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+d120 - U+d13f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+d140 - U+d15f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+d160 - U+d17f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+d180 - U+d19f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+d1a0 - U+d1bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+d1c0 - U+d1df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+d1e0 - U+d1ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+d200 - U+d21f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+d220 - U+d23f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+d240 - U+d25f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+d260 - U+d27f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+d280 - U+d29f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+d2a0 - U+d2bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+d2c0 - U+d2df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+d2e0 - U+d2ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+d300 - U+d31f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+d320 - U+d33f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+d340 - U+d35f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+d360 - U+d37f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+d380 - U+d39f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+d3a0 - U+d3bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+d3c0 - U+d3df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+d3e0 - U+d3ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+d400 - U+d41f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+d420 - U+d43f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+d440 - U+d45f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+d460 - U+d47f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+d480 - U+d49f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+d4a0 - U+d4bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+d4c0 - U+d4df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+d4e0 - U+d4ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+d500 - U+d51f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+d520 - U+d53f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+d540 - U+d55f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+d560 - U+d57f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+d580 - U+d59f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+d5a0 - U+d5bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+d5c0 - U+d5df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+d5e0 - U+d5ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+d600 - U+d61f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+d620 - U+d63f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+d640 - U+d65f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+d660 - U+d67f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+d680 - U+d69f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+d6a0 - U+d6bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+d6c0 - U+d6df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+d6e0 - U+d6ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+d700 - U+d71f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+d720 - U+d73f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+d740 - U+d75f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+d760 - U+d77f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+d780 - U+d79f */
  0xaa,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+d7a0 - U+d7bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+d7c0 - U+d7df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+d7e0 - U+d7ff */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+d800 - U+d81f */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+d820 - U+d83f */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+d840 - U+d85f */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+d860 - U+d87f */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+d880 - U+d89f */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+d8a0 - U+d8bf */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+d8c0 - U+d8df */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+d8e0 - U+d8ff */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+d900 - U+d91f */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+d920 - U+d93f */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+d940 - U+d95f */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+d960 - U+d97f */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+d980 - U+d99f */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+d9a0 - U+d9bf */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+d9c0 - U+d9df */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+d9e0 - U+d9ff */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+da00 - U+da1f */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+da20 - U+da3f */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+da40 - U+da5f */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+da60 - U+da7f */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+da80 - U+da9f */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+daa0 - U+dabf */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+dac0 - U+dadf */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+dae0 - U+daff */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+db00 - U+db1f */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+db20 - U+db3f */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+db40 - U+db5f */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+db60 - U+db7f */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+db80 - U+db9f */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+dba0 - U+dbbf */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+dbc0 - U+dbdf */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+dbe0 - U+dbff */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+dc00 - U+dc1f */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+dc20 - U+dc3f */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+dc40 - U+dc5f */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+dc60 - U+dc7f */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+dc80 - U+dc9f */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+dca0 - U+dcbf */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+dcc0 - U+dcdf */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+dce0 - U+dcff */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+dd00 - U+dd1f */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+dd20 - U+dd3f */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+dd40 - U+dd5f */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+dd60 - U+dd7f */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+dd80 - U+dd9f */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+dda0 - U+ddbf */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+ddc0 - U+dddf */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+dde0 - U+ddff */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+de00 - U+de1f */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+de20 - U+de3f */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+de40 - U+de5f */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+de60 - U+de7f */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+de80 - U+de9f */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+dea0 - U+debf */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+dec0 - U+dedf */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+dee0 - U+deff */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+df00 - U+df1f */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+df20 - U+df3f */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+df40 - U+df5f */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+df60 - U+df7f */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+df80 - U+df9f */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+dfa0 - U+dfbf */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+dfc0 - U+dfdf */
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,	/* U+dfe0 - U+dfff */
  0x95,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e000 - U+e01f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e020 - U+e03f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e040 - U+e05f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e060 - U+e07f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e080 - U+e09f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e0a0 - U+e0bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e0c0 - U+e0df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e0e0 - U+e0ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e100 - U+e11f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e120 - U+e13f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e140 - U+e15f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e160 - U+e17f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e180 - U+e19f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e1a0 - U+e1bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e1c0 - U+e1df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e1e0 - U+e1ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e200 - U+e21f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e220 - U+e23f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e240 - U+e25f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e260 - U+e27f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e280 - U+e29f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e2a0 - U+e2bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e2c0 - U+e2df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e2e0 - U+e2ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e300 - U+e31f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e320 - U+e33f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e340 - U+e35f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e360 - U+e37f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e380 - U+e39f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e3a0 - U+e3bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e3c0 - U+e3df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e3e0 - U+e3ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e400 - U+e41f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e420 - U+e43f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e440 - U+e45f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e460 - U+e47f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e480 - U+e49f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e4a0 - U+e4bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e4c0 - U+e4df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e4e0 - U+e4ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e500 - U+e51f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e520 - U+e53f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e540 - U+e55f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e560 - U+e57f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e580 - U+e59f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e5a0 - U+e5bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e5c0 - U+e5df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e5e0 - U+e5ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e600 - U+e61f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e620 - U+e63f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e640 - U+e65f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e660 - U+e67f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e680 - U+e69f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e6a0 - U+e6bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e6c0 - U+e6df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e6e0 - U+e6ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e700 - U+e71f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e720 - U+e73f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e740 - U+e75f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e760 - U+e77f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e780 - U+e79f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e7a0 - U+e7bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e7c0 - U+e7df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e7e0 - U+e7ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e800 - U+e81f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e820 - U+e83f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e840 - U+e85f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e860 - U+e87f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e880 - U+e89f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e8a0 - U+e8bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e8c0 - U+e8df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e8e0 - U+e8ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e900 - U+e91f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e920 - U+e93f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e940 - U+e95f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e960 - U+e97f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e980 - U+e99f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e9a0 - U+e9bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e9c0 - U+e9df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+e9e0 - U+e9ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+ea00 - U+ea1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+ea20 - U+ea3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+ea40 - U+ea5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+ea60 - U+ea7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+ea80 - U+ea9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+eaa0 - U+eabf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+eac0 - U+eadf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+eae0 - U+eaff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+eb00 - U+eb1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+eb20 - U+eb3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+eb40 - U+eb5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+eb60 - U+eb7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+eb80 - U+eb9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+eba0 - U+ebbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+ebc0 - U+ebdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+ebe0 - U+ebff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+ec00 - U+ec1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+ec20 - U+ec3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+ec40 - U+ec5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+ec60 - U+ec7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+ec80 - U+ec9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+eca0 - U+ecbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+ecc0 - U+ecdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+ece0 - U+ecff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+ed00 - U+ed1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+ed20 - U+ed3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+ed40 - U+ed5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+ed60 - U+ed7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+ed80 - U+ed9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+eda0 - U+edbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+edc0 - U+eddf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+ede0 - U+edff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+ee00 - U+ee1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+ee20 - U+ee3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+ee40 - U+ee5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+ee60 - U+ee7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+ee80 - U+ee9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+eea0 - U+eebf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+eec0 - U+eedf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+eee0 - U+eeff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+ef00 - U+ef1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+ef20 - U+ef3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+ef40 - U+ef5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+ef60 - U+ef7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+ef80 - U+ef9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+efa0 - U+efbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+efc0 - U+efdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+efe0 - U+efff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f000 - U+f01f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f020 - U+f03f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f040 - U+f05f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f060 - U+f07f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f080 - U+f09f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f0a0 - U+f0bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f0c0 - U+f0df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f0e0 - U+f0ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f100 - U+f11f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f120 - U+f13f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f140 - U+f15f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f160 - U+f17f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f180 - U+f19f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f1a0 - U+f1bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f1c0 - U+f1df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f1e0 - U+f1ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f200 - U+f21f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f220 - U+f23f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f240 - U+f25f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f260 - U+f27f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f280 - U+f29f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f2a0 - U+f2bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f2c0 - U+f2df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f2e0 - U+f2ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f300 - U+f31f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f320 - U+f33f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f340 - U+f35f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f360 - U+f37f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f380 - U+f39f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f3a0 - U+f3bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f3c0 - U+f3df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f3e0 - U+f3ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f400 - U+f41f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f420 - U+f43f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f440 - U+f45f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f460 - U+f47f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f480 - U+f49f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f4a0 - U+f4bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f4c0 - U+f4df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f4e0 - U+f4ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f500 - U+f51f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f520 - U+f53f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f540 - U+f55f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f560 - U+f57f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f580 - U+f59f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f5a0 - U+f5bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f5c0 - U+f5df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f5e0 - U+f5ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f600 - U+f61f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f620 - U+f63f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f640 - U+f65f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f660 - U+f67f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f680 - U+f69f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f6a0 - U+f6bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f6c0 - U+f6df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f6e0 - U+f6ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f700 - U+f71f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f720 - U+f73f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f740 - U+f75f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f760 - U+f77f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f780 - U+f79f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f7a0 - U+f7bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f7c0 - U+f7df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f7e0 - U+f7ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f800 - U+f81f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f820 - U+f83f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f840 - U+f85f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f860 - U+f87f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f880 - U+f89f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f8a0 - U+f8bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f8c0 - U+f8df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+f8e0 - U+f8ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+f900 - U+f91f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+f920 - U+f93f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+f940 - U+f95f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+f960 - U+f97f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+f980 - U+f99f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+f9a0 - U+f9bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+f9c0 - U+f9df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+f9e0 - U+f9ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+fa00 - U+fa1f */
  0xaa,0xaa,0xaa,0xa5,0xaa,0xaa,0xaa,0xaa,	/* U+fa20 - U+fa3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+fa40 - U+fa5f */
  0xaa,0xaa,0xa9,0x55,0xaa,0xaa,0xaa,0xaa,	/* U+fa60 - U+fa7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+fa80 - U+fa9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+faa0 - U+fabf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xa5,0x55,	/* U+fac0 - U+fadf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+fae0 - U+faff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x51,	/* U+fb00 - U+fb1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+fb20 - U+fb3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+fb40 - U+fb5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+fb60 - U+fb7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+fb80 - U+fb9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+fba0 - U+fbbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+fbc0 - U+fbdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+fbe0 - U+fbff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+fc00 - U+fc1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+fc20 - U+fc3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+fc40 - U+fc5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+fc60 - U+fc7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+fc80 - U+fc9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+fca0 - U+fcbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+fcc0 - U+fcdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+fce0 - U+fcff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+fd00 - U+fd1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+fd20 - U+fd3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+fd40 - U+fd5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+fd60 - U+fd7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+fd80 - U+fd9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+fda0 - U+fdbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+fdc0 - U+fddf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+fde0 - U+fdff */
  0x00,0x00,0x00,0x00,0xaa,0xaa,0xa5,0x55,	/* U+fe00 - U+fe1f */
  0x00,0x55,0x55,0x55,0xaa,0xaa,0xaa,0xaa,	/* U+fe20 - U+fe3f */
  0xaa,0xaa,0xaa,0xaa,0xa9,0xaa,0xaa,0xaa,	/* U+fe40 - U+fe5f */
  0xaa,0xa9,0xaa,0x55,0x55,0x55,0x55,0x55,	/* U+fe60 - U+fe7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+fe80 - U+fe9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+fea0 - U+febf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+fec0 - U+fedf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x54,	/* U+fee0 - U+feff */
  0x6a,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+ff00 - U+ff1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+ff20 - U+ff3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+ff40 - U+ff5f */
  0x95,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+ff60 - U+ff7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+ff80 - U+ff9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+ffa0 - U+ffbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+ffc0 - U+ffdf */
  0xaa,0xa9,0x55,0x55,0x55,0x55,0x40,0x65,	/* U+ffe0 - U+ffff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10000 - U+1001f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10020 - U+1003f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10040 - U+1005f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10060 - U+1007f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10080 - U+1009f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+100a0 - U+100bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+100c0 - U+100df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+100e0 - U+100ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10100 - U+1011f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10120 - U+1013f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10140 - U+1015f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10160 - U+1017f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10180 - U+1019f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+101a0 - U+101bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+101c0 - U+101df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+101e0 - U+101ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10200 - U+1021f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10220 - U+1023f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10240 - U+1025f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10260 - U+1027f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10280 - U+1029f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+102a0 - U+102bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+102c0 - U+102df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+102e0 - U+102ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10300 - U+1031f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10320 - U+1033f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10340 - U+1035f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10360 - U+1037f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10380 - U+1039f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+103a0 - U+103bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+103c0 - U+103df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+103e0 - U+103ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10400 - U+1041f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10420 - U+1043f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10440 - U+1045f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10460 - U+1047f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10480 - U+1049f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+104a0 - U+104bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+104c0 - U+104df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+104e0 - U+104ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10500 - U+1051f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10520 - U+1053f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10540 - U+1055f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10560 - U+1057f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10580 - U+1059f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+105a0 - U+105bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+105c0 - U+105df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+105e0 - U+105ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10600 - U+1061f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10620 - U+1063f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10640 - U+1065f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10660 - U+1067f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10680 - U+1069f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+106a0 - U+106bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+106c0 - U+106df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+106e0 - U+106ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10700 - U+1071f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10720 - U+1073f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10740 - U+1075f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10760 - U+1077f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10780 - U+1079f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+107a0 - U+107bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+107c0 - U+107df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+107e0 - U+107ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10800 - U+1081f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10820 - U+1083f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10840 - U+1085f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10860 - U+1087f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10880 - U+1089f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+108a0 - U+108bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+108c0 - U+108df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+108e0 - U+108ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10900 - U+1091f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10920 - U+1093f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10940 - U+1095f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10960 - U+1097f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10980 - U+1099f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+109a0 - U+109bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+109c0 - U+109df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+109e0 - U+109ff */
  0x40,0x41,0x55,0x00,0x55,0x55,0x55,0x55,	/* U+10a00 - U+10a1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x01,0x54,	/* U+10a20 - U+10a3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10a40 - U+10a5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10a60 - U+10a7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10a80 - U+10a9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10aa0 - U+10abf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10ac0 - U+10adf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10ae0 - U+10aff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10b00 - U+10b1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10b20 - U+10b3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10b40 - U+10b5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10b60 - U+10b7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10b80 - U+10b9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10ba0 - U+10bbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10bc0 - U+10bdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10be0 - U+10bff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10c00 - U+10c1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10c20 - U+10c3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10c40 - U+10c5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10c60 - U+10c7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10c80 - U+10c9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10ca0 - U+10cbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10cc0 - U+10cdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10ce0 - U+10cff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10d00 - U+10d1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10d20 - U+10d3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10d40 - U+10d5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10d60 - U+10d7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10d80 - U+10d9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10da0 - U+10dbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10dc0 - U+10ddf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10de0 - U+10dff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10e00 - U+10e1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10e20 - U+10e3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10e40 - U+10e5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10e60 - U+10e7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10e80 - U+10e9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10ea0 - U+10ebf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10ec0 - U+10edf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10ee0 - U+10eff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10f00 - U+10f1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10f20 - U+10f3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10f40 - U+10f5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10f60 - U+10f7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10f80 - U+10f9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10fa0 - U+10fbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10fc0 - U+10fdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+10fe0 - U+10fff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11000 - U+1101f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11020 - U+1103f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11040 - U+1105f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11060 - U+1107f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11080 - U+1109f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+110a0 - U+110bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+110c0 - U+110df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+110e0 - U+110ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11100 - U+1111f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11120 - U+1113f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11140 - U+1115f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11160 - U+1117f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11180 - U+1119f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+111a0 - U+111bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+111c0 - U+111df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+111e0 - U+111ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11200 - U+1121f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11220 - U+1123f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11240 - U+1125f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11260 - U+1127f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11280 - U+1129f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+112a0 - U+112bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+112c0 - U+112df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+112e0 - U+112ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11300 - U+1131f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11320 - U+1133f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11340 - U+1135f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11360 - U+1137f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11380 - U+1139f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+113a0 - U+113bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+113c0 - U+113df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+113e0 - U+113ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11400 - U+1141f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11420 - U+1143f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11440 - U+1145f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11460 - U+1147f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11480 - U+1149f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+114a0 - U+114bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+114c0 - U+114df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+114e0 - U+114ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11500 - U+1151f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11520 - U+1153f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11540 - U+1155f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11560 - U+1157f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11580 - U+1159f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+115a0 - U+115bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+115c0 - U+115df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+115e0 - U+115ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11600 - U+1161f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11620 - U+1163f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11640 - U+1165f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11660 - U+1167f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11680 - U+1169f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+116a0 - U+116bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+116c0 - U+116df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+116e0 - U+116ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11700 - U+1171f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11720 - U+1173f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11740 - U+1175f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11760 - U+1177f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11780 - U+1179f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+117a0 - U+117bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+117c0 - U+117df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+117e0 - U+117ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11800 - U+1181f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11820 - U+1183f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11840 - U+1185f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11860 - U+1187f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11880 - U+1189f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+118a0 - U+118bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+118c0 - U+118df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+118e0 - U+118ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11900 - U+1191f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11920 - U+1193f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11940 - U+1195f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11960 - U+1197f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11980 - U+1199f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+119a0 - U+119bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+119c0 - U+119df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+119e0 - U+119ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11a00 - U+11a1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11a20 - U+11a3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11a40 - U+11a5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11a60 - U+11a7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11a80 - U+11a9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11aa0 - U+11abf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11ac0 - U+11adf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11ae0 - U+11aff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11b00 - U+11b1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11b20 - U+11b3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11b40 - U+11b5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11b60 - U+11b7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11b80 - U+11b9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11ba0 - U+11bbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11bc0 - U+11bdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11be0 - U+11bff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11c00 - U+11c1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11c20 - U+11c3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11c40 - U+11c5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11c60 - U+11c7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11c80 - U+11c9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11ca0 - U+11cbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11cc0 - U+11cdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11ce0 - U+11cff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11d00 - U+11d1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11d20 - U+11d3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11d40 - U+11d5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11d60 - U+11d7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11d80 - U+11d9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11da0 - U+11dbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11dc0 - U+11ddf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11de0 - U+11dff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11e00 - U+11e1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11e20 - U+11e3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11e40 - U+11e5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11e60 - U+11e7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11e80 - U+11e9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11ea0 - U+11ebf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11ec0 - U+11edf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11ee0 - U+11eff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11f00 - U+11f1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11f20 - U+11f3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11f40 - U+11f5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11f60 - U+11f7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11f80 - U+11f9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11fa0 - U+11fbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11fc0 - U+11fdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+11fe0 - U+11fff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12000 - U+1201f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12020 - U+1203f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12040 - U+1205f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12060 - U+1207f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12080 - U+1209f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+120a0 - U+120bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+120c0 - U+120df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+120e0 - U+120ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12100 - U+1211f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12120 - U+1213f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12140 - U+1215f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12160 - U+1217f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12180 - U+1219f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+121a0 - U+121bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+121c0 - U+121df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+121e0 - U+121ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12200 - U+1221f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12220 - U+1223f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12240 - U+1225f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12260 - U+1227f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12280 - U+1229f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+122a0 - U+122bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+122c0 - U+122df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+122e0 - U+122ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12300 - U+1231f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12320 - U+1233f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12340 - U+1235f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12360 - U+1237f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12380 - U+1239f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+123a0 - U+123bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+123c0 - U+123df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+123e0 - U+123ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12400 - U+1241f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12420 - U+1243f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12440 - U+1245f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12460 - U+1247f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12480 - U+1249f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+124a0 - U+124bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+124c0 - U+124df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+124e0 - U+124ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12500 - U+1251f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12520 - U+1253f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12540 - U+1255f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12560 - U+1257f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12580 - U+1259f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+125a0 - U+125bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+125c0 - U+125df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+125e0 - U+125ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12600 - U+1261f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12620 - U+1263f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12640 - U+1265f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12660 - U+1267f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12680 - U+1269f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+126a0 - U+126bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+126c0 - U+126df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+126e0 - U+126ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12700 - U+1271f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12720 - U+1273f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12740 - U+1275f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12760 - U+1277f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12780 - U+1279f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+127a0 - U+127bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+127c0 - U+127df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+127e0 - U+127ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12800 - U+1281f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12820 - U+1283f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12840 - U+1285f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12860 - U+1287f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12880 - U+1289f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+128a0 - U+128bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+128c0 - U+128df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+128e0 - U+128ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12900 - U+1291f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12920 - U+1293f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12940 - U+1295f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12960 - U+1297f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12980 - U+1299f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+129a0 - U+129bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+129c0 - U+129df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+129e0 - U+129ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12a00 - U+12a1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12a20 - U+12a3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12a40 - U+12a5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12a60 - U+12a7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12a80 - U+12a9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12aa0 - U+12abf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12ac0 - U+12adf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12ae0 - U+12aff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12b00 - U+12b1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12b20 - U+12b3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12b40 - U+12b5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12b60 - U+12b7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12b80 - U+12b9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12ba0 - U+12bbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12bc0 - U+12bdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12be0 - U+12bff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12c00 - U+12c1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12c20 - U+12c3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12c40 - U+12c5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12c60 - U+12c7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12c80 - U+12c9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12ca0 - U+12cbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12cc0 - U+12cdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12ce0 - U+12cff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12d00 - U+12d1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12d20 - U+12d3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12d40 - U+12d5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12d60 - U+12d7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12d80 - U+12d9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12da0 - U+12dbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12dc0 - U+12ddf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12de0 - U+12dff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12e00 - U+12e1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12e20 - U+12e3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12e40 - U+12e5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12e60 - U+12e7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12e80 - U+12e9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12ea0 - U+12ebf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12ec0 - U+12edf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12ee0 - U+12eff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12f00 - U+12f1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12f20 - U+12f3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12f40 - U+12f5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12f60 - U+12f7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12f80 - U+12f9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12fa0 - U+12fbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12fc0 - U+12fdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+12fe0 - U+12fff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13000 - U+1301f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13020 - U+1303f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13040 - U+1305f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13060 - U+1307f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13080 - U+1309f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+130a0 - U+130bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+130c0 - U+130df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+130e0 - U+130ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13100 - U+1311f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13120 - U+1313f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13140 - U+1315f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13160 - U+1317f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13180 - U+1319f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+131a0 - U+131bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+131c0 - U+131df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+131e0 - U+131ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13200 - U+1321f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13220 - U+1323f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13240 - U+1325f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13260 - U+1327f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13280 - U+1329f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+132a0 - U+132bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+132c0 - U+132df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+132e0 - U+132ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13300 - U+1331f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13320 - U+1333f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13340 - U+1335f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13360 - U+1337f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13380 - U+1339f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+133a0 - U+133bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+133c0 - U+133df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+133e0 - U+133ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13400 - U+1341f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13420 - U+1343f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13440 - U+1345f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13460 - U+1347f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13480 - U+1349f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+134a0 - U+134bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+134c0 - U+134df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+134e0 - U+134ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13500 - U+1351f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13520 - U+1353f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13540 - U+1355f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13560 - U+1357f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13580 - U+1359f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+135a0 - U+135bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+135c0 - U+135df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+135e0 - U+135ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13600 - U+1361f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13620 - U+1363f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13640 - U+1365f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13660 - U+1367f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13680 - U+1369f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+136a0 - U+136bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+136c0 - U+136df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+136e0 - U+136ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13700 - U+1371f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13720 - U+1373f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13740 - U+1375f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13760 - U+1377f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13780 - U+1379f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+137a0 - U+137bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+137c0 - U+137df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+137e0 - U+137ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13800 - U+1381f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13820 - U+1383f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13840 - U+1385f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13860 - U+1387f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13880 - U+1389f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+138a0 - U+138bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+138c0 - U+138df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+138e0 - U+138ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13900 - U+1391f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13920 - U+1393f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13940 - U+1395f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13960 - U+1397f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13980 - U+1399f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+139a0 - U+139bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+139c0 - U+139df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+139e0 - U+139ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13a00 - U+13a1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13a20 - U+13a3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13a40 - U+13a5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13a60 - U+13a7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13a80 - U+13a9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13aa0 - U+13abf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13ac0 - U+13adf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13ae0 - U+13aff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13b00 - U+13b1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13b20 - U+13b3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13b40 - U+13b5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13b60 - U+13b7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13b80 - U+13b9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13ba0 - U+13bbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13bc0 - U+13bdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13be0 - U+13bff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13c00 - U+13c1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13c20 - U+13c3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13c40 - U+13c5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13c60 - U+13c7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13c80 - U+13c9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13ca0 - U+13cbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13cc0 - U+13cdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13ce0 - U+13cff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13d00 - U+13d1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13d20 - U+13d3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13d40 - U+13d5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13d60 - U+13d7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13d80 - U+13d9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13da0 - U+13dbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13dc0 - U+13ddf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13de0 - U+13dff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13e00 - U+13e1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13e20 - U+13e3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13e40 - U+13e5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13e60 - U+13e7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13e80 - U+13e9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13ea0 - U+13ebf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13ec0 - U+13edf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13ee0 - U+13eff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13f00 - U+13f1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13f20 - U+13f3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13f40 - U+13f5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13f60 - U+13f7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13f80 - U+13f9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13fa0 - U+13fbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13fc0 - U+13fdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+13fe0 - U+13fff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14000 - U+1401f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14020 - U+1403f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14040 - U+1405f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14060 - U+1407f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14080 - U+1409f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+140a0 - U+140bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+140c0 - U+140df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+140e0 - U+140ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14100 - U+1411f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14120 - U+1413f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14140 - U+1415f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14160 - U+1417f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14180 - U+1419f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+141a0 - U+141bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+141c0 - U+141df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+141e0 - U+141ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14200 - U+1421f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14220 - U+1423f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14240 - U+1425f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14260 - U+1427f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14280 - U+1429f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+142a0 - U+142bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+142c0 - U+142df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+142e0 - U+142ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14300 - U+1431f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14320 - U+1433f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14340 - U+1435f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14360 - U+1437f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14380 - U+1439f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+143a0 - U+143bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+143c0 - U+143df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+143e0 - U+143ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14400 - U+1441f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14420 - U+1443f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14440 - U+1445f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14460 - U+1447f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14480 - U+1449f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+144a0 - U+144bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+144c0 - U+144df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+144e0 - U+144ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14500 - U+1451f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14520 - U+1453f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14540 - U+1455f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14560 - U+1457f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14580 - U+1459f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+145a0 - U+145bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+145c0 - U+145df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+145e0 - U+145ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14600 - U+1461f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14620 - U+1463f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14640 - U+1465f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14660 - U+1467f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14680 - U+1469f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+146a0 - U+146bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+146c0 - U+146df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+146e0 - U+146ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14700 - U+1471f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14720 - U+1473f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14740 - U+1475f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14760 - U+1477f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14780 - U+1479f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+147a0 - U+147bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+147c0 - U+147df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+147e0 - U+147ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14800 - U+1481f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14820 - U+1483f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14840 - U+1485f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14860 - U+1487f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14880 - U+1489f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+148a0 - U+148bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+148c0 - U+148df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+148e0 - U+148ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14900 - U+1491f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14920 - U+1493f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14940 - U+1495f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14960 - U+1497f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14980 - U+1499f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+149a0 - U+149bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+149c0 - U+149df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+149e0 - U+149ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14a00 - U+14a1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14a20 - U+14a3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14a40 - U+14a5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14a60 - U+14a7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14a80 - U+14a9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14aa0 - U+14abf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14ac0 - U+14adf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14ae0 - U+14aff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14b00 - U+14b1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14b20 - U+14b3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14b40 - U+14b5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14b60 - U+14b7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14b80 - U+14b9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14ba0 - U+14bbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14bc0 - U+14bdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14be0 - U+14bff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14c00 - U+14c1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14c20 - U+14c3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14c40 - U+14c5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14c60 - U+14c7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14c80 - U+14c9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14ca0 - U+14cbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14cc0 - U+14cdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14ce0 - U+14cff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14d00 - U+14d1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14d20 - U+14d3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14d40 - U+14d5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14d60 - U+14d7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14d80 - U+14d9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14da0 - U+14dbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14dc0 - U+14ddf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14de0 - U+14dff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14e00 - U+14e1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14e20 - U+14e3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14e40 - U+14e5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14e60 - U+14e7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14e80 - U+14e9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14ea0 - U+14ebf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14ec0 - U+14edf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14ee0 - U+14eff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14f00 - U+14f1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14f20 - U+14f3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14f40 - U+14f5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14f60 - U+14f7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14f80 - U+14f9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14fa0 - U+14fbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14fc0 - U+14fdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+14fe0 - U+14fff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15000 - U+1501f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15020 - U+1503f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15040 - U+1505f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15060 - U+1507f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15080 - U+1509f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+150a0 - U+150bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+150c0 - U+150df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+150e0 - U+150ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15100 - U+1511f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15120 - U+1513f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15140 - U+1515f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15160 - U+1517f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15180 - U+1519f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+151a0 - U+151bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+151c0 - U+151df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+151e0 - U+151ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15200 - U+1521f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15220 - U+1523f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15240 - U+1525f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15260 - U+1527f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15280 - U+1529f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+152a0 - U+152bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+152c0 - U+152df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+152e0 - U+152ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15300 - U+1531f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15320 - U+1533f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15340 - U+1535f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15360 - U+1537f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15380 - U+1539f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+153a0 - U+153bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+153c0 - U+153df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+153e0 - U+153ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15400 - U+1541f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15420 - U+1543f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15440 - U+1545f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15460 - U+1547f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15480 - U+1549f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+154a0 - U+154bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+154c0 - U+154df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+154e0 - U+154ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15500 - U+1551f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15520 - U+1553f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15540 - U+1555f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15560 - U+1557f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15580 - U+1559f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+155a0 - U+155bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+155c0 - U+155df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+155e0 - U+155ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15600 - U+1561f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15620 - U+1563f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15640 - U+1565f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15660 - U+1567f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15680 - U+1569f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+156a0 - U+156bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+156c0 - U+156df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+156e0 - U+156ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15700 - U+1571f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15720 - U+1573f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15740 - U+1575f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15760 - U+1577f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15780 - U+1579f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+157a0 - U+157bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+157c0 - U+157df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+157e0 - U+157ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15800 - U+1581f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15820 - U+1583f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15840 - U+1585f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15860 - U+1587f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15880 - U+1589f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+158a0 - U+158bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+158c0 - U+158df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+158e0 - U+158ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15900 - U+1591f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15920 - U+1593f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15940 - U+1595f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15960 - U+1597f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15980 - U+1599f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+159a0 - U+159bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+159c0 - U+159df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+159e0 - U+159ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15a00 - U+15a1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15a20 - U+15a3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15a40 - U+15a5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15a60 - U+15a7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15a80 - U+15a9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15aa0 - U+15abf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15ac0 - U+15adf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15ae0 - U+15aff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15b00 - U+15b1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15b20 - U+15b3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15b40 - U+15b5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15b60 - U+15b7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15b80 - U+15b9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15ba0 - U+15bbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15bc0 - U+15bdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15be0 - U+15bff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15c00 - U+15c1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15c20 - U+15c3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15c40 - U+15c5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15c60 - U+15c7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15c80 - U+15c9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15ca0 - U+15cbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15cc0 - U+15cdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15ce0 - U+15cff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15d00 - U+15d1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15d20 - U+15d3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15d40 - U+15d5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15d60 - U+15d7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15d80 - U+15d9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15da0 - U+15dbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15dc0 - U+15ddf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15de0 - U+15dff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15e00 - U+15e1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15e20 - U+15e3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15e40 - U+15e5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15e60 - U+15e7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15e80 - U+15e9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15ea0 - U+15ebf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15ec0 - U+15edf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15ee0 - U+15eff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15f00 - U+15f1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15f20 - U+15f3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15f40 - U+15f5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15f60 - U+15f7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15f80 - U+15f9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15fa0 - U+15fbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15fc0 - U+15fdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+15fe0 - U+15fff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16000 - U+1601f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16020 - U+1603f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16040 - U+1605f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16060 - U+1607f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16080 - U+1609f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+160a0 - U+160bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+160c0 - U+160df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+160e0 - U+160ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16100 - U+1611f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16120 - U+1613f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16140 - U+1615f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16160 - U+1617f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16180 - U+1619f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+161a0 - U+161bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+161c0 - U+161df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+161e0 - U+161ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16200 - U+1621f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16220 - U+1623f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16240 - U+1625f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16260 - U+1627f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16280 - U+1629f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+162a0 - U+162bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+162c0 - U+162df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+162e0 - U+162ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16300 - U+1631f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16320 - U+1633f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16340 - U+1635f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16360 - U+1637f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16380 - U+1639f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+163a0 - U+163bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+163c0 - U+163df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+163e0 - U+163ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16400 - U+1641f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16420 - U+1643f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16440 - U+1645f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16460 - U+1647f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16480 - U+1649f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+164a0 - U+164bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+164c0 - U+164df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+164e0 - U+164ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16500 - U+1651f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16520 - U+1653f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16540 - U+1655f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16560 - U+1657f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16580 - U+1659f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+165a0 - U+165bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+165c0 - U+165df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+165e0 - U+165ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16600 - U+1661f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16620 - U+1663f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16640 - U+1665f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16660 - U+1667f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16680 - U+1669f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+166a0 - U+166bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+166c0 - U+166df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+166e0 - U+166ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16700 - U+1671f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16720 - U+1673f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16740 - U+1675f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16760 - U+1677f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16780 - U+1679f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+167a0 - U+167bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+167c0 - U+167df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+167e0 - U+167ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16800 - U+1681f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16820 - U+1683f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16840 - U+1685f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16860 - U+1687f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16880 - U+1689f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+168a0 - U+168bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+168c0 - U+168df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+168e0 - U+168ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16900 - U+1691f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16920 - U+1693f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16940 - U+1695f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16960 - U+1697f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16980 - U+1699f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+169a0 - U+169bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+169c0 - U+169df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+169e0 - U+169ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16a00 - U+16a1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16a20 - U+16a3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16a40 - U+16a5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16a60 - U+16a7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16a80 - U+16a9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16aa0 - U+16abf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16ac0 - U+16adf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16ae0 - U+16aff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16b00 - U+16b1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16b20 - U+16b3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16b40 - U+16b5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16b60 - U+16b7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16b80 - U+16b9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16ba0 - U+16bbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16bc0 - U+16bdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16be0 - U+16bff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16c00 - U+16c1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16c20 - U+16c3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16c40 - U+16c5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16c60 - U+16c7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16c80 - U+16c9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16ca0 - U+16cbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16cc0 - U+16cdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16ce0 - U+16cff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16d00 - U+16d1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16d20 - U+16d3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16d40 - U+16d5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16d60 - U+16d7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16d80 - U+16d9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16da0 - U+16dbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16dc0 - U+16ddf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16de0 - U+16dff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16e00 - U+16e1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16e20 - U+16e3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16e40 - U+16e5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16e60 - U+16e7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16e80 - U+16e9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16ea0 - U+16ebf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16ec0 - U+16edf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16ee0 - U+16eff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16f00 - U+16f1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16f20 - U+16f3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16f40 - U+16f5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16f60 - U+16f7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16f80 - U+16f9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16fa0 - U+16fbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16fc0 - U+16fdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+16fe0 - U+16fff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17000 - U+1701f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17020 - U+1703f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17040 - U+1705f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17060 - U+1707f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17080 - U+1709f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+170a0 - U+170bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+170c0 - U+170df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+170e0 - U+170ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17100 - U+1711f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17120 - U+1713f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17140 - U+1715f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17160 - U+1717f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17180 - U+1719f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+171a0 - U+171bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+171c0 - U+171df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+171e0 - U+171ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17200 - U+1721f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17220 - U+1723f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17240 - U+1725f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17260 - U+1727f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17280 - U+1729f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+172a0 - U+172bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+172c0 - U+172df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+172e0 - U+172ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17300 - U+1731f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17320 - U+1733f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17340 - U+1735f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17360 - U+1737f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17380 - U+1739f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+173a0 - U+173bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+173c0 - U+173df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+173e0 - U+173ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17400 - U+1741f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17420 - U+1743f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17440 - U+1745f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17460 - U+1747f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17480 - U+1749f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+174a0 - U+174bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+174c0 - U+174df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+174e0 - U+174ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17500 - U+1751f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17520 - U+1753f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17540 - U+1755f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17560 - U+1757f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17580 - U+1759f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+175a0 - U+175bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+175c0 - U+175df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+175e0 - U+175ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17600 - U+1761f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17620 - U+1763f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17640 - U+1765f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17660 - U+1767f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17680 - U+1769f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+176a0 - U+176bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+176c0 - U+176df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+176e0 - U+176ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17700 - U+1771f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17720 - U+1773f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17740 - U+1775f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17760 - U+1777f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17780 - U+1779f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+177a0 - U+177bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+177c0 - U+177df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+177e0 - U+177ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17800 - U+1781f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17820 - U+1783f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17840 - U+1785f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17860 - U+1787f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17880 - U+1789f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+178a0 - U+178bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+178c0 - U+178df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+178e0 - U+178ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17900 - U+1791f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17920 - U+1793f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17940 - U+1795f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17960 - U+1797f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17980 - U+1799f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+179a0 - U+179bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+179c0 - U+179df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+179e0 - U+179ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17a00 - U+17a1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17a20 - U+17a3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17a40 - U+17a5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17a60 - U+17a7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17a80 - U+17a9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17aa0 - U+17abf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17ac0 - U+17adf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17ae0 - U+17aff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17b00 - U+17b1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17b20 - U+17b3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17b40 - U+17b5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17b60 - U+17b7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17b80 - U+17b9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17ba0 - U+17bbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17bc0 - U+17bdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17be0 - U+17bff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17c00 - U+17c1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17c20 - U+17c3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17c40 - U+17c5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17c60 - U+17c7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17c80 - U+17c9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17ca0 - U+17cbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17cc0 - U+17cdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17ce0 - U+17cff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17d00 - U+17d1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17d20 - U+17d3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17d40 - U+17d5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17d60 - U+17d7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17d80 - U+17d9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17da0 - U+17dbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17dc0 - U+17ddf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17de0 - U+17dff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17e00 - U+17e1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17e20 - U+17e3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17e40 - U+17e5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17e60 - U+17e7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17e80 - U+17e9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17ea0 - U+17ebf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17ec0 - U+17edf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17ee0 - U+17eff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17f00 - U+17f1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17f20 - U+17f3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17f40 - U+17f5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17f60 - U+17f7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17f80 - U+17f9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17fa0 - U+17fbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17fc0 - U+17fdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+17fe0 - U+17fff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18000 - U+1801f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18020 - U+1803f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18040 - U+1805f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18060 - U+1807f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18080 - U+1809f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+180a0 - U+180bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+180c0 - U+180df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+180e0 - U+180ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18100 - U+1811f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18120 - U+1813f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18140 - U+1815f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18160 - U+1817f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18180 - U+1819f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+181a0 - U+181bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+181c0 - U+181df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+181e0 - U+181ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18200 - U+1821f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18220 - U+1823f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18240 - U+1825f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18260 - U+1827f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18280 - U+1829f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+182a0 - U+182bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+182c0 - U+182df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+182e0 - U+182ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18300 - U+1831f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18320 - U+1833f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18340 - U+1835f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18360 - U+1837f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18380 - U+1839f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+183a0 - U+183bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+183c0 - U+183df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+183e0 - U+183ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18400 - U+1841f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18420 - U+1843f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18440 - U+1845f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18460 - U+1847f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18480 - U+1849f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+184a0 - U+184bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+184c0 - U+184df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+184e0 - U+184ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18500 - U+1851f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18520 - U+1853f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18540 - U+1855f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18560 - U+1857f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18580 - U+1859f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+185a0 - U+185bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+185c0 - U+185df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+185e0 - U+185ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18600 - U+1861f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18620 - U+1863f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18640 - U+1865f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18660 - U+1867f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18680 - U+1869f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+186a0 - U+186bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+186c0 - U+186df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+186e0 - U+186ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18700 - U+1871f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18720 - U+1873f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18740 - U+1875f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18760 - U+1877f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18780 - U+1879f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+187a0 - U+187bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+187c0 - U+187df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+187e0 - U+187ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18800 - U+1881f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18820 - U+1883f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18840 - U+1885f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18860 - U+1887f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18880 - U+1889f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+188a0 - U+188bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+188c0 - U+188df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+188e0 - U+188ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18900 - U+1891f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18920 - U+1893f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18940 - U+1895f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18960 - U+1897f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18980 - U+1899f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+189a0 - U+189bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+189c0 - U+189df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+189e0 - U+189ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18a00 - U+18a1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18a20 - U+18a3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18a40 - U+18a5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18a60 - U+18a7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18a80 - U+18a9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18aa0 - U+18abf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18ac0 - U+18adf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18ae0 - U+18aff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18b00 - U+18b1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18b20 - U+18b3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18b40 - U+18b5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18b60 - U+18b7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18b80 - U+18b9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18ba0 - U+18bbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18bc0 - U+18bdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18be0 - U+18bff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18c00 - U+18c1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18c20 - U+18c3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18c40 - U+18c5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18c60 - U+18c7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18c80 - U+18c9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18ca0 - U+18cbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18cc0 - U+18cdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18ce0 - U+18cff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18d00 - U+18d1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18d20 - U+18d3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18d40 - U+18d5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18d60 - U+18d7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18d80 - U+18d9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18da0 - U+18dbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18dc0 - U+18ddf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18de0 - U+18dff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18e00 - U+18e1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18e20 - U+18e3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18e40 - U+18e5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18e60 - U+18e7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18e80 - U+18e9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18ea0 - U+18ebf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18ec0 - U+18edf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18ee0 - U+18eff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18f00 - U+18f1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18f20 - U+18f3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18f40 - U+18f5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18f60 - U+18f7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18f80 - U+18f9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18fa0 - U+18fbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18fc0 - U+18fdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+18fe0 - U+18fff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19000 - U+1901f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19020 - U+1903f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19040 - U+1905f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19060 - U+1907f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19080 - U+1909f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+190a0 - U+190bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+190c0 - U+190df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+190e0 - U+190ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19100 - U+1911f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19120 - U+1913f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19140 - U+1915f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19160 - U+1917f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19180 - U+1919f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+191a0 - U+191bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+191c0 - U+191df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+191e0 - U+191ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19200 - U+1921f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19220 - U+1923f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19240 - U+1925f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19260 - U+1927f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19280 - U+1929f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+192a0 - U+192bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+192c0 - U+192df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+192e0 - U+192ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19300 - U+1931f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19320 - U+1933f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19340 - U+1935f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19360 - U+1937f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19380 - U+1939f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+193a0 - U+193bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+193c0 - U+193df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+193e0 - U+193ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19400 - U+1941f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19420 - U+1943f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19440 - U+1945f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19460 - U+1947f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19480 - U+1949f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+194a0 - U+194bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+194c0 - U+194df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+194e0 - U+194ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19500 - U+1951f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19520 - U+1953f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19540 - U+1955f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19560 - U+1957f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19580 - U+1959f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+195a0 - U+195bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+195c0 - U+195df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+195e0 - U+195ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19600 - U+1961f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19620 - U+1963f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19640 - U+1965f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19660 - U+1967f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19680 - U+1969f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+196a0 - U+196bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+196c0 - U+196df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+196e0 - U+196ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19700 - U+1971f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19720 - U+1973f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19740 - U+1975f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19760 - U+1977f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19780 - U+1979f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+197a0 - U+197bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+197c0 - U+197df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+197e0 - U+197ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19800 - U+1981f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19820 - U+1983f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19840 - U+1985f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19860 - U+1987f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19880 - U+1989f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+198a0 - U+198bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+198c0 - U+198df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+198e0 - U+198ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19900 - U+1991f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19920 - U+1993f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19940 - U+1995f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19960 - U+1997f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19980 - U+1999f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+199a0 - U+199bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+199c0 - U+199df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+199e0 - U+199ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19a00 - U+19a1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19a20 - U+19a3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19a40 - U+19a5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19a60 - U+19a7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19a80 - U+19a9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19aa0 - U+19abf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19ac0 - U+19adf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19ae0 - U+19aff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19b00 - U+19b1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19b20 - U+19b3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19b40 - U+19b5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19b60 - U+19b7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19b80 - U+19b9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19ba0 - U+19bbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19bc0 - U+19bdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19be0 - U+19bff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19c00 - U+19c1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19c20 - U+19c3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19c40 - U+19c5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19c60 - U+19c7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19c80 - U+19c9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19ca0 - U+19cbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19cc0 - U+19cdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19ce0 - U+19cff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19d00 - U+19d1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19d20 - U+19d3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19d40 - U+19d5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19d60 - U+19d7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19d80 - U+19d9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19da0 - U+19dbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19dc0 - U+19ddf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19de0 - U+19dff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19e00 - U+19e1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19e20 - U+19e3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19e40 - U+19e5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19e60 - U+19e7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19e80 - U+19e9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19ea0 - U+19ebf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19ec0 - U+19edf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19ee0 - U+19eff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19f00 - U+19f1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19f20 - U+19f3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19f40 - U+19f5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19f60 - U+19f7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19f80 - U+19f9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19fa0 - U+19fbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19fc0 - U+19fdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+19fe0 - U+19fff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a000 - U+1a01f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a020 - U+1a03f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a040 - U+1a05f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a060 - U+1a07f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a080 - U+1a09f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a0a0 - U+1a0bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a0c0 - U+1a0df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a0e0 - U+1a0ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a100 - U+1a11f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a120 - U+1a13f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a140 - U+1a15f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a160 - U+1a17f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a180 - U+1a19f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a1a0 - U+1a1bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a1c0 - U+1a1df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a1e0 - U+1a1ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a200 - U+1a21f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a220 - U+1a23f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a240 - U+1a25f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a260 - U+1a27f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a280 - U+1a29f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a2a0 - U+1a2bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a2c0 - U+1a2df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a2e0 - U+1a2ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a300 - U+1a31f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a320 - U+1a33f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a340 - U+1a35f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a360 - U+1a37f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a380 - U+1a39f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a3a0 - U+1a3bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a3c0 - U+1a3df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a3e0 - U+1a3ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a400 - U+1a41f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a420 - U+1a43f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a440 - U+1a45f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a460 - U+1a47f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a480 - U+1a49f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a4a0 - U+1a4bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a4c0 - U+1a4df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a4e0 - U+1a4ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a500 - U+1a51f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a520 - U+1a53f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a540 - U+1a55f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a560 - U+1a57f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a580 - U+1a59f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a5a0 - U+1a5bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a5c0 - U+1a5df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a5e0 - U+1a5ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a600 - U+1a61f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a620 - U+1a63f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a640 - U+1a65f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a660 - U+1a67f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a680 - U+1a69f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a6a0 - U+1a6bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a6c0 - U+1a6df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a6e0 - U+1a6ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a700 - U+1a71f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a720 - U+1a73f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a740 - U+1a75f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a760 - U+1a77f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a780 - U+1a79f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a7a0 - U+1a7bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a7c0 - U+1a7df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a7e0 - U+1a7ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a800 - U+1a81f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a820 - U+1a83f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a840 - U+1a85f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a860 - U+1a87f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a880 - U+1a89f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a8a0 - U+1a8bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a8c0 - U+1a8df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a8e0 - U+1a8ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a900 - U+1a91f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a920 - U+1a93f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a940 - U+1a95f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a960 - U+1a97f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a980 - U+1a99f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a9a0 - U+1a9bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a9c0 - U+1a9df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1a9e0 - U+1a9ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1aa00 - U+1aa1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1aa20 - U+1aa3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1aa40 - U+1aa5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1aa60 - U+1aa7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1aa80 - U+1aa9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1aaa0 - U+1aabf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1aac0 - U+1aadf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1aae0 - U+1aaff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ab00 - U+1ab1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ab20 - U+1ab3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ab40 - U+1ab5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ab60 - U+1ab7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ab80 - U+1ab9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1aba0 - U+1abbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1abc0 - U+1abdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1abe0 - U+1abff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ac00 - U+1ac1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ac20 - U+1ac3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ac40 - U+1ac5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ac60 - U+1ac7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ac80 - U+1ac9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1aca0 - U+1acbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1acc0 - U+1acdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ace0 - U+1acff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ad00 - U+1ad1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ad20 - U+1ad3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ad40 - U+1ad5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ad60 - U+1ad7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ad80 - U+1ad9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ada0 - U+1adbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1adc0 - U+1addf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ade0 - U+1adff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ae00 - U+1ae1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ae20 - U+1ae3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ae40 - U+1ae5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ae60 - U+1ae7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ae80 - U+1ae9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1aea0 - U+1aebf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1aec0 - U+1aedf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1aee0 - U+1aeff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1af00 - U+1af1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1af20 - U+1af3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1af40 - U+1af5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1af60 - U+1af7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1af80 - U+1af9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1afa0 - U+1afbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1afc0 - U+1afdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1afe0 - U+1afff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b000 - U+1b01f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b020 - U+1b03f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b040 - U+1b05f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b060 - U+1b07f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b080 - U+1b09f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b0a0 - U+1b0bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b0c0 - U+1b0df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b0e0 - U+1b0ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b100 - U+1b11f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b120 - U+1b13f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b140 - U+1b15f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b160 - U+1b17f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b180 - U+1b19f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b1a0 - U+1b1bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b1c0 - U+1b1df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b1e0 - U+1b1ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b200 - U+1b21f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b220 - U+1b23f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b240 - U+1b25f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b260 - U+1b27f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b280 - U+1b29f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b2a0 - U+1b2bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b2c0 - U+1b2df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b2e0 - U+1b2ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b300 - U+1b31f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b320 - U+1b33f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b340 - U+1b35f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b360 - U+1b37f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b380 - U+1b39f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b3a0 - U+1b3bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b3c0 - U+1b3df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b3e0 - U+1b3ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b400 - U+1b41f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b420 - U+1b43f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b440 - U+1b45f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b460 - U+1b47f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b480 - U+1b49f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b4a0 - U+1b4bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b4c0 - U+1b4df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b4e0 - U+1b4ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b500 - U+1b51f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b520 - U+1b53f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b540 - U+1b55f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b560 - U+1b57f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b580 - U+1b59f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b5a0 - U+1b5bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b5c0 - U+1b5df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b5e0 - U+1b5ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b600 - U+1b61f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b620 - U+1b63f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b640 - U+1b65f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b660 - U+1b67f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b680 - U+1b69f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b6a0 - U+1b6bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b6c0 - U+1b6df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b6e0 - U+1b6ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b700 - U+1b71f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b720 - U+1b73f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b740 - U+1b75f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b760 - U+1b77f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b780 - U+1b79f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b7a0 - U+1b7bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b7c0 - U+1b7df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b7e0 - U+1b7ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b800 - U+1b81f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b820 - U+1b83f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b840 - U+1b85f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b860 - U+1b87f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b880 - U+1b89f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b8a0 - U+1b8bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b8c0 - U+1b8df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b8e0 - U+1b8ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b900 - U+1b91f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b920 - U+1b93f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b940 - U+1b95f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b960 - U+1b97f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b980 - U+1b99f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b9a0 - U+1b9bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b9c0 - U+1b9df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1b9e0 - U+1b9ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ba00 - U+1ba1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ba20 - U+1ba3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ba40 - U+1ba5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ba60 - U+1ba7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ba80 - U+1ba9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1baa0 - U+1babf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1bac0 - U+1badf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1bae0 - U+1baff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1bb00 - U+1bb1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1bb20 - U+1bb3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1bb40 - U+1bb5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1bb60 - U+1bb7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1bb80 - U+1bb9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1bba0 - U+1bbbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1bbc0 - U+1bbdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1bbe0 - U+1bbff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1bc00 - U+1bc1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1bc20 - U+1bc3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1bc40 - U+1bc5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1bc60 - U+1bc7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1bc80 - U+1bc9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1bca0 - U+1bcbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1bcc0 - U+1bcdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1bce0 - U+1bcff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1bd00 - U+1bd1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1bd20 - U+1bd3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1bd40 - U+1bd5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1bd60 - U+1bd7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1bd80 - U+1bd9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1bda0 - U+1bdbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1bdc0 - U+1bddf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1bde0 - U+1bdff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1be00 - U+1be1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1be20 - U+1be3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1be40 - U+1be5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1be60 - U+1be7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1be80 - U+1be9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1bea0 - U+1bebf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1bec0 - U+1bedf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1bee0 - U+1beff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1bf00 - U+1bf1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1bf20 - U+1bf3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1bf40 - U+1bf5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1bf60 - U+1bf7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1bf80 - U+1bf9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1bfa0 - U+1bfbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1bfc0 - U+1bfdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1bfe0 - U+1bfff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c000 - U+1c01f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c020 - U+1c03f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c040 - U+1c05f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c060 - U+1c07f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c080 - U+1c09f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c0a0 - U+1c0bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c0c0 - U+1c0df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c0e0 - U+1c0ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c100 - U+1c11f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c120 - U+1c13f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c140 - U+1c15f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c160 - U+1c17f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c180 - U+1c19f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c1a0 - U+1c1bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c1c0 - U+1c1df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c1e0 - U+1c1ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c200 - U+1c21f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c220 - U+1c23f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c240 - U+1c25f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c260 - U+1c27f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c280 - U+1c29f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c2a0 - U+1c2bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c2c0 - U+1c2df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c2e0 - U+1c2ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c300 - U+1c31f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c320 - U+1c33f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c340 - U+1c35f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c360 - U+1c37f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c380 - U+1c39f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c3a0 - U+1c3bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c3c0 - U+1c3df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c3e0 - U+1c3ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c400 - U+1c41f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c420 - U+1c43f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c440 - U+1c45f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c460 - U+1c47f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c480 - U+1c49f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c4a0 - U+1c4bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c4c0 - U+1c4df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c4e0 - U+1c4ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c500 - U+1c51f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c520 - U+1c53f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c540 - U+1c55f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c560 - U+1c57f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c580 - U+1c59f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c5a0 - U+1c5bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c5c0 - U+1c5df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c5e0 - U+1c5ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c600 - U+1c61f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c620 - U+1c63f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c640 - U+1c65f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c660 - U+1c67f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c680 - U+1c69f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c6a0 - U+1c6bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c6c0 - U+1c6df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c6e0 - U+1c6ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c700 - U+1c71f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c720 - U+1c73f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c740 - U+1c75f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c760 - U+1c77f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c780 - U+1c79f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c7a0 - U+1c7bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c7c0 - U+1c7df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c7e0 - U+1c7ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c800 - U+1c81f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c820 - U+1c83f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c840 - U+1c85f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c860 - U+1c87f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c880 - U+1c89f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c8a0 - U+1c8bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c8c0 - U+1c8df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c8e0 - U+1c8ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c900 - U+1c91f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c920 - U+1c93f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c940 - U+1c95f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c960 - U+1c97f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c980 - U+1c99f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c9a0 - U+1c9bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c9c0 - U+1c9df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1c9e0 - U+1c9ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ca00 - U+1ca1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ca20 - U+1ca3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ca40 - U+1ca5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ca60 - U+1ca7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ca80 - U+1ca9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1caa0 - U+1cabf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1cac0 - U+1cadf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1cae0 - U+1caff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1cb00 - U+1cb1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1cb20 - U+1cb3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1cb40 - U+1cb5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1cb60 - U+1cb7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1cb80 - U+1cb9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1cba0 - U+1cbbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1cbc0 - U+1cbdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1cbe0 - U+1cbff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1cc00 - U+1cc1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1cc20 - U+1cc3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1cc40 - U+1cc5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1cc60 - U+1cc7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1cc80 - U+1cc9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1cca0 - U+1ccbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ccc0 - U+1ccdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1cce0 - U+1ccff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1cd00 - U+1cd1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1cd20 - U+1cd3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1cd40 - U+1cd5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1cd60 - U+1cd7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1cd80 - U+1cd9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1cda0 - U+1cdbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1cdc0 - U+1cddf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1cde0 - U+1cdff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ce00 - U+1ce1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ce20 - U+1ce3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ce40 - U+1ce5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ce60 - U+1ce7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ce80 - U+1ce9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1cea0 - U+1cebf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1cec0 - U+1cedf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1cee0 - U+1ceff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1cf00 - U+1cf1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1cf20 - U+1cf3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1cf40 - U+1cf5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1cf60 - U+1cf7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1cf80 - U+1cf9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1cfa0 - U+1cfbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1cfc0 - U+1cfdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1cfe0 - U+1cfff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d000 - U+1d01f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d020 - U+1d03f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d040 - U+1d05f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d060 - U+1d07f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d080 - U+1d09f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d0a0 - U+1d0bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d0c0 - U+1d0df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d0e0 - U+1d0ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d100 - U+1d11f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d120 - U+1d13f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d140 - U+1d15f */
  0x55,0x54,0x05,0x55,0x54,0x00,0x00,0x00,	/* U+1d160 - U+1d17f */
  0x01,0x40,0x00,0x55,0x55,0x55,0x55,0x55,	/* U+1d180 - U+1d19f */
  0x55,0x55,0x50,0x05,0x55,0x55,0x55,0x55,	/* U+1d1a0 - U+1d1bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d1c0 - U+1d1df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d1e0 - U+1d1ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d200 - U+1d21f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d220 - U+1d23f */
  0x50,0x15,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d240 - U+1d25f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d260 - U+1d27f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d280 - U+1d29f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d2a0 - U+1d2bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d2c0 - U+1d2df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d2e0 - U+1d2ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d300 - U+1d31f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d320 - U+1d33f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d340 - U+1d35f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d360 - U+1d37f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d380 - U+1d39f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d3a0 - U+1d3bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d3c0 - U+1d3df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d3e0 - U+1d3ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d400 - U+1d41f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d420 - U+1d43f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d440 - U+1d45f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d460 - U+1d47f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d480 - U+1d49f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d4a0 - U+1d4bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d4c0 - U+1d4df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d4e0 - U+1d4ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d500 - U+1d51f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d520 - U+1d53f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d540 - U+1d55f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d560 - U+1d57f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d580 - U+1d59f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d5a0 - U+1d5bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d5c0 - U+1d5df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d5e0 - U+1d5ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d600 - U+1d61f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d620 - U+1d63f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d640 - U+1d65f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d660 - U+1d67f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d680 - U+1d69f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d6a0 - U+1d6bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d6c0 - U+1d6df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d6e0 - U+1d6ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d700 - U+1d71f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d720 - U+1d73f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d740 - U+1d75f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d760 - U+1d77f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d780 - U+1d79f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d7a0 - U+1d7bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d7c0 - U+1d7df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d7e0 - U+1d7ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d800 - U+1d81f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d820 - U+1d83f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d840 - U+1d85f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d860 - U+1d87f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d880 - U+1d89f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d8a0 - U+1d8bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d8c0 - U+1d8df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d8e0 - U+1d8ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d900 - U+1d91f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d920 - U+1d93f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d940 - U+1d95f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d960 - U+1d97f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d980 - U+1d99f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d9a0 - U+1d9bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d9c0 - U+1d9df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1d9e0 - U+1d9ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1da00 - U+1da1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1da20 - U+1da3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1da40 - U+1da5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1da60 - U+1da7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1da80 - U+1da9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1daa0 - U+1dabf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1dac0 - U+1dadf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1dae0 - U+1daff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1db00 - U+1db1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1db20 - U+1db3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1db40 - U+1db5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1db60 - U+1db7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1db80 - U+1db9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1dba0 - U+1dbbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1dbc0 - U+1dbdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1dbe0 - U+1dbff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1dc00 - U+1dc1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1dc20 - U+1dc3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1dc40 - U+1dc5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1dc60 - U+1dc7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1dc80 - U+1dc9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1dca0 - U+1dcbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1dcc0 - U+1dcdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1dce0 - U+1dcff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1dd00 - U+1dd1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1dd20 - U+1dd3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1dd40 - U+1dd5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1dd60 - U+1dd7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1dd80 - U+1dd9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1dda0 - U+1ddbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ddc0 - U+1dddf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1dde0 - U+1ddff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1de00 - U+1de1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1de20 - U+1de3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1de40 - U+1de5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1de60 - U+1de7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1de80 - U+1de9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1dea0 - U+1debf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1dec0 - U+1dedf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1dee0 - U+1deff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1df00 - U+1df1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1df20 - U+1df3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1df40 - U+1df5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1df60 - U+1df7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1df80 - U+1df9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1dfa0 - U+1dfbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1dfc0 - U+1dfdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1dfe0 - U+1dfff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e000 - U+1e01f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e020 - U+1e03f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e040 - U+1e05f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e060 - U+1e07f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e080 - U+1e09f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e0a0 - U+1e0bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e0c0 - U+1e0df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e0e0 - U+1e0ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e100 - U+1e11f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e120 - U+1e13f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e140 - U+1e15f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e160 - U+1e17f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e180 - U+1e19f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e1a0 - U+1e1bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e1c0 - U+1e1df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e1e0 - U+1e1ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e200 - U+1e21f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e220 - U+1e23f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e240 - U+1e25f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e260 - U+1e27f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e280 - U+1e29f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e2a0 - U+1e2bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e2c0 - U+1e2df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e2e0 - U+1e2ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e300 - U+1e31f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e320 - U+1e33f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e340 - U+1e35f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e360 - U+1e37f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e380 - U+1e39f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e3a0 - U+1e3bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e3c0 - U+1e3df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e3e0 - U+1e3ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e400 - U+1e41f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e420 - U+1e43f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e440 - U+1e45f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e460 - U+1e47f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e480 - U+1e49f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e4a0 - U+1e4bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e4c0 - U+1e4df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e4e0 - U+1e4ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e500 - U+1e51f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e520 - U+1e53f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e540 - U+1e55f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e560 - U+1e57f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e580 - U+1e59f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e5a0 - U+1e5bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e5c0 - U+1e5df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e5e0 - U+1e5ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e600 - U+1e61f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e620 - U+1e63f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e640 - U+1e65f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e660 - U+1e67f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e680 - U+1e69f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e6a0 - U+1e6bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e6c0 - U+1e6df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e6e0 - U+1e6ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e700 - U+1e71f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e720 - U+1e73f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e740 - U+1e75f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e760 - U+1e77f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e780 - U+1e79f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e7a0 - U+1e7bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e7c0 - U+1e7df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e7e0 - U+1e7ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e800 - U+1e81f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e820 - U+1e83f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e840 - U+1e85f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e860 - U+1e87f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e880 - U+1e89f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e8a0 - U+1e8bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e8c0 - U+1e8df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e8e0 - U+1e8ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e900 - U+1e91f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e920 - U+1e93f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e940 - U+1e95f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e960 - U+1e97f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e980 - U+1e99f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e9a0 - U+1e9bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e9c0 - U+1e9df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1e9e0 - U+1e9ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ea00 - U+1ea1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ea20 - U+1ea3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ea40 - U+1ea5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ea60 - U+1ea7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ea80 - U+1ea9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1eaa0 - U+1eabf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1eac0 - U+1eadf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1eae0 - U+1eaff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1eb00 - U+1eb1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1eb20 - U+1eb3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1eb40 - U+1eb5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1eb60 - U+1eb7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1eb80 - U+1eb9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1eba0 - U+1ebbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ebc0 - U+1ebdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ebe0 - U+1ebff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ec00 - U+1ec1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ec20 - U+1ec3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ec40 - U+1ec5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ec60 - U+1ec7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ec80 - U+1ec9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1eca0 - U+1ecbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ecc0 - U+1ecdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ece0 - U+1ecff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ed00 - U+1ed1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ed20 - U+1ed3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ed40 - U+1ed5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ed60 - U+1ed7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ed80 - U+1ed9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1eda0 - U+1edbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1edc0 - U+1eddf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ede0 - U+1edff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ee00 - U+1ee1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ee20 - U+1ee3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ee40 - U+1ee5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ee60 - U+1ee7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ee80 - U+1ee9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1eea0 - U+1eebf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1eec0 - U+1eedf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1eee0 - U+1eeff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ef00 - U+1ef1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ef20 - U+1ef3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ef40 - U+1ef5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ef60 - U+1ef7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ef80 - U+1ef9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1efa0 - U+1efbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1efc0 - U+1efdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1efe0 - U+1efff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f000 - U+1f01f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f020 - U+1f03f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f040 - U+1f05f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f060 - U+1f07f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f080 - U+1f09f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f0a0 - U+1f0bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f0c0 - U+1f0df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f0e0 - U+1f0ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f100 - U+1f11f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f120 - U+1f13f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f140 - U+1f15f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f160 - U+1f17f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f180 - U+1f19f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f1a0 - U+1f1bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f1c0 - U+1f1df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f1e0 - U+1f1ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f200 - U+1f21f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f220 - U+1f23f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f240 - U+1f25f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f260 - U+1f27f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f280 - U+1f29f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f2a0 - U+1f2bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f2c0 - U+1f2df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f2e0 - U+1f2ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f300 - U+1f31f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f320 - U+1f33f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f340 - U+1f35f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f360 - U+1f37f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f380 - U+1f39f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f3a0 - U+1f3bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f3c0 - U+1f3df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f3e0 - U+1f3ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f400 - U+1f41f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f420 - U+1f43f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f440 - U+1f45f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f460 - U+1f47f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f480 - U+1f49f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f4a0 - U+1f4bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f4c0 - U+1f4df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f4e0 - U+1f4ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f500 - U+1f51f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f520 - U+1f53f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f540 - U+1f55f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f560 - U+1f57f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f580 - U+1f59f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f5a0 - U+1f5bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f5c0 - U+1f5df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f5e0 - U+1f5ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f600 - U+1f61f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f620 - U+1f63f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f640 - U+1f65f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f660 - U+1f67f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f680 - U+1f69f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f6a0 - U+1f6bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f6c0 - U+1f6df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f6e0 - U+1f6ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f700 - U+1f71f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f720 - U+1f73f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f740 - U+1f75f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f760 - U+1f77f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f780 - U+1f79f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f7a0 - U+1f7bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f7c0 - U+1f7df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f7e0 - U+1f7ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f800 - U+1f81f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f820 - U+1f83f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f840 - U+1f85f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f860 - U+1f87f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f880 - U+1f89f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f8a0 - U+1f8bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f8c0 - U+1f8df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f8e0 - U+1f8ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f900 - U+1f91f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f920 - U+1f93f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f940 - U+1f95f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f960 - U+1f97f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f980 - U+1f99f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f9a0 - U+1f9bf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f9c0 - U+1f9df */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1f9e0 - U+1f9ff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1fa00 - U+1fa1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1fa20 - U+1fa3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1fa40 - U+1fa5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1fa60 - U+1fa7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1fa80 - U+1fa9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1faa0 - U+1fabf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1fac0 - U+1fadf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1fae0 - U+1faff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1fb00 - U+1fb1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1fb20 - U+1fb3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1fb40 - U+1fb5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1fb60 - U+1fb7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1fb80 - U+1fb9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1fba0 - U+1fbbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1fbc0 - U+1fbdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1fbe0 - U+1fbff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1fc00 - U+1fc1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1fc20 - U+1fc3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1fc40 - U+1fc5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1fc60 - U+1fc7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1fc80 - U+1fc9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1fca0 - U+1fcbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1fcc0 - U+1fcdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1fce0 - U+1fcff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1fd00 - U+1fd1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1fd20 - U+1fd3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1fd40 - U+1fd5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1fd60 - U+1fd7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1fd80 - U+1fd9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1fda0 - U+1fdbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1fdc0 - U+1fddf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1fde0 - U+1fdff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1fe00 - U+1fe1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1fe20 - U+1fe3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1fe40 - U+1fe5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1fe60 - U+1fe7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1fe80 - U+1fe9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1fea0 - U+1febf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1fec0 - U+1fedf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1fee0 - U+1feff */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ff00 - U+1ff1f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ff20 - U+1ff3f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ff40 - U+1ff5f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ff60 - U+1ff7f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ff80 - U+1ff9f */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ffa0 - U+1ffbf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ffc0 - U+1ffdf */
  0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,	/* U+1ffe0 - U+1ffff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20000 - U+2001f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20020 - U+2003f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20040 - U+2005f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20060 - U+2007f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20080 - U+2009f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+200a0 - U+200bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+200c0 - U+200df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+200e0 - U+200ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20100 - U+2011f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20120 - U+2013f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20140 - U+2015f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20160 - U+2017f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20180 - U+2019f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+201a0 - U+201bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+201c0 - U+201df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+201e0 - U+201ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20200 - U+2021f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20220 - U+2023f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20240 - U+2025f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20260 - U+2027f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20280 - U+2029f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+202a0 - U+202bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+202c0 - U+202df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+202e0 - U+202ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20300 - U+2031f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20320 - U+2033f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20340 - U+2035f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20360 - U+2037f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20380 - U+2039f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+203a0 - U+203bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+203c0 - U+203df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+203e0 - U+203ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20400 - U+2041f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20420 - U+2043f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20440 - U+2045f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20460 - U+2047f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20480 - U+2049f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+204a0 - U+204bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+204c0 - U+204df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+204e0 - U+204ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20500 - U+2051f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20520 - U+2053f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20540 - U+2055f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20560 - U+2057f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20580 - U+2059f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+205a0 - U+205bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+205c0 - U+205df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+205e0 - U+205ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20600 - U+2061f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20620 - U+2063f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20640 - U+2065f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20660 - U+2067f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20680 - U+2069f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+206a0 - U+206bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+206c0 - U+206df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+206e0 - U+206ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20700 - U+2071f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20720 - U+2073f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20740 - U+2075f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20760 - U+2077f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20780 - U+2079f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+207a0 - U+207bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+207c0 - U+207df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+207e0 - U+207ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20800 - U+2081f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20820 - U+2083f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20840 - U+2085f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20860 - U+2087f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20880 - U+2089f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+208a0 - U+208bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+208c0 - U+208df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+208e0 - U+208ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20900 - U+2091f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20920 - U+2093f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20940 - U+2095f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20960 - U+2097f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20980 - U+2099f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+209a0 - U+209bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+209c0 - U+209df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+209e0 - U+209ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20a00 - U+20a1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20a20 - U+20a3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20a40 - U+20a5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20a60 - U+20a7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20a80 - U+20a9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20aa0 - U+20abf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20ac0 - U+20adf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20ae0 - U+20aff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20b00 - U+20b1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20b20 - U+20b3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20b40 - U+20b5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20b60 - U+20b7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20b80 - U+20b9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20ba0 - U+20bbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20bc0 - U+20bdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20be0 - U+20bff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20c00 - U+20c1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20c20 - U+20c3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20c40 - U+20c5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20c60 - U+20c7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20c80 - U+20c9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20ca0 - U+20cbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20cc0 - U+20cdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20ce0 - U+20cff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20d00 - U+20d1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20d20 - U+20d3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20d40 - U+20d5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20d60 - U+20d7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20d80 - U+20d9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20da0 - U+20dbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20dc0 - U+20ddf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20de0 - U+20dff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20e00 - U+20e1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20e20 - U+20e3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20e40 - U+20e5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20e60 - U+20e7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20e80 - U+20e9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20ea0 - U+20ebf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20ec0 - U+20edf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20ee0 - U+20eff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20f00 - U+20f1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20f20 - U+20f3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20f40 - U+20f5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20f60 - U+20f7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20f80 - U+20f9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20fa0 - U+20fbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20fc0 - U+20fdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+20fe0 - U+20fff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21000 - U+2101f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21020 - U+2103f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21040 - U+2105f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21060 - U+2107f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21080 - U+2109f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+210a0 - U+210bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+210c0 - U+210df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+210e0 - U+210ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21100 - U+2111f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21120 - U+2113f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21140 - U+2115f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21160 - U+2117f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21180 - U+2119f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+211a0 - U+211bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+211c0 - U+211df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+211e0 - U+211ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21200 - U+2121f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21220 - U+2123f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21240 - U+2125f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21260 - U+2127f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21280 - U+2129f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+212a0 - U+212bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+212c0 - U+212df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+212e0 - U+212ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21300 - U+2131f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21320 - U+2133f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21340 - U+2135f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21360 - U+2137f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21380 - U+2139f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+213a0 - U+213bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+213c0 - U+213df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+213e0 - U+213ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21400 - U+2141f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21420 - U+2143f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21440 - U+2145f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21460 - U+2147f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21480 - U+2149f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+214a0 - U+214bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+214c0 - U+214df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+214e0 - U+214ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21500 - U+2151f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21520 - U+2153f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21540 - U+2155f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21560 - U+2157f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21580 - U+2159f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+215a0 - U+215bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+215c0 - U+215df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+215e0 - U+215ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21600 - U+2161f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21620 - U+2163f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21640 - U+2165f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21660 - U+2167f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21680 - U+2169f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+216a0 - U+216bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+216c0 - U+216df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+216e0 - U+216ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21700 - U+2171f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21720 - U+2173f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21740 - U+2175f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21760 - U+2177f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21780 - U+2179f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+217a0 - U+217bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+217c0 - U+217df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+217e0 - U+217ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21800 - U+2181f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21820 - U+2183f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21840 - U+2185f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21860 - U+2187f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21880 - U+2189f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+218a0 - U+218bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+218c0 - U+218df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+218e0 - U+218ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21900 - U+2191f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21920 - U+2193f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21940 - U+2195f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21960 - U+2197f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21980 - U+2199f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+219a0 - U+219bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+219c0 - U+219df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+219e0 - U+219ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21a00 - U+21a1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21a20 - U+21a3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21a40 - U+21a5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21a60 - U+21a7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21a80 - U+21a9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21aa0 - U+21abf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21ac0 - U+21adf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21ae0 - U+21aff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21b00 - U+21b1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21b20 - U+21b3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21b40 - U+21b5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21b60 - U+21b7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21b80 - U+21b9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21ba0 - U+21bbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21bc0 - U+21bdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21be0 - U+21bff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21c00 - U+21c1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21c20 - U+21c3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21c40 - U+21c5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21c60 - U+21c7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21c80 - U+21c9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21ca0 - U+21cbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21cc0 - U+21cdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21ce0 - U+21cff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21d00 - U+21d1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21d20 - U+21d3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21d40 - U+21d5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21d60 - U+21d7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21d80 - U+21d9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21da0 - U+21dbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21dc0 - U+21ddf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21de0 - U+21dff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21e00 - U+21e1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21e20 - U+21e3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21e40 - U+21e5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21e60 - U+21e7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21e80 - U+21e9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21ea0 - U+21ebf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21ec0 - U+21edf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21ee0 - U+21eff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21f00 - U+21f1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21f20 - U+21f3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21f40 - U+21f5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21f60 - U+21f7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21f80 - U+21f9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21fa0 - U+21fbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21fc0 - U+21fdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+21fe0 - U+21fff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22000 - U+2201f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22020 - U+2203f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22040 - U+2205f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22060 - U+2207f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22080 - U+2209f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+220a0 - U+220bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+220c0 - U+220df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+220e0 - U+220ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22100 - U+2211f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22120 - U+2213f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22140 - U+2215f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22160 - U+2217f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22180 - U+2219f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+221a0 - U+221bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+221c0 - U+221df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+221e0 - U+221ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22200 - U+2221f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22220 - U+2223f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22240 - U+2225f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22260 - U+2227f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22280 - U+2229f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+222a0 - U+222bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+222c0 - U+222df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+222e0 - U+222ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22300 - U+2231f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22320 - U+2233f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22340 - U+2235f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22360 - U+2237f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22380 - U+2239f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+223a0 - U+223bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+223c0 - U+223df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+223e0 - U+223ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22400 - U+2241f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22420 - U+2243f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22440 - U+2245f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22460 - U+2247f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22480 - U+2249f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+224a0 - U+224bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+224c0 - U+224df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+224e0 - U+224ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22500 - U+2251f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22520 - U+2253f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22540 - U+2255f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22560 - U+2257f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22580 - U+2259f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+225a0 - U+225bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+225c0 - U+225df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+225e0 - U+225ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22600 - U+2261f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22620 - U+2263f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22640 - U+2265f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22660 - U+2267f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22680 - U+2269f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+226a0 - U+226bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+226c0 - U+226df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+226e0 - U+226ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22700 - U+2271f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22720 - U+2273f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22740 - U+2275f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22760 - U+2277f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22780 - U+2279f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+227a0 - U+227bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+227c0 - U+227df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+227e0 - U+227ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22800 - U+2281f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22820 - U+2283f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22840 - U+2285f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22860 - U+2287f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22880 - U+2289f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+228a0 - U+228bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+228c0 - U+228df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+228e0 - U+228ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22900 - U+2291f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22920 - U+2293f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22940 - U+2295f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22960 - U+2297f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22980 - U+2299f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+229a0 - U+229bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+229c0 - U+229df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+229e0 - U+229ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22a00 - U+22a1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22a20 - U+22a3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22a40 - U+22a5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22a60 - U+22a7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22a80 - U+22a9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22aa0 - U+22abf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22ac0 - U+22adf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22ae0 - U+22aff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22b00 - U+22b1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22b20 - U+22b3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22b40 - U+22b5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22b60 - U+22b7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22b80 - U+22b9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22ba0 - U+22bbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22bc0 - U+22bdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22be0 - U+22bff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22c00 - U+22c1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22c20 - U+22c3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22c40 - U+22c5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22c60 - U+22c7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22c80 - U+22c9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22ca0 - U+22cbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22cc0 - U+22cdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22ce0 - U+22cff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22d00 - U+22d1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22d20 - U+22d3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22d40 - U+22d5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22d60 - U+22d7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22d80 - U+22d9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22da0 - U+22dbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22dc0 - U+22ddf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22de0 - U+22dff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22e00 - U+22e1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22e20 - U+22e3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22e40 - U+22e5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22e60 - U+22e7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22e80 - U+22e9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22ea0 - U+22ebf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22ec0 - U+22edf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22ee0 - U+22eff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22f00 - U+22f1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22f20 - U+22f3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22f40 - U+22f5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22f60 - U+22f7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22f80 - U+22f9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22fa0 - U+22fbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22fc0 - U+22fdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+22fe0 - U+22fff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23000 - U+2301f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23020 - U+2303f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23040 - U+2305f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23060 - U+2307f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23080 - U+2309f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+230a0 - U+230bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+230c0 - U+230df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+230e0 - U+230ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23100 - U+2311f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23120 - U+2313f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23140 - U+2315f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23160 - U+2317f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23180 - U+2319f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+231a0 - U+231bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+231c0 - U+231df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+231e0 - U+231ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23200 - U+2321f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23220 - U+2323f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23240 - U+2325f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23260 - U+2327f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23280 - U+2329f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+232a0 - U+232bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+232c0 - U+232df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+232e0 - U+232ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23300 - U+2331f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23320 - U+2333f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23340 - U+2335f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23360 - U+2337f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23380 - U+2339f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+233a0 - U+233bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+233c0 - U+233df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+233e0 - U+233ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23400 - U+2341f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23420 - U+2343f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23440 - U+2345f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23460 - U+2347f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23480 - U+2349f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+234a0 - U+234bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+234c0 - U+234df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+234e0 - U+234ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23500 - U+2351f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23520 - U+2353f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23540 - U+2355f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23560 - U+2357f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23580 - U+2359f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+235a0 - U+235bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+235c0 - U+235df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+235e0 - U+235ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23600 - U+2361f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23620 - U+2363f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23640 - U+2365f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23660 - U+2367f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23680 - U+2369f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+236a0 - U+236bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+236c0 - U+236df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+236e0 - U+236ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23700 - U+2371f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23720 - U+2373f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23740 - U+2375f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23760 - U+2377f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23780 - U+2379f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+237a0 - U+237bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+237c0 - U+237df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+237e0 - U+237ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23800 - U+2381f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23820 - U+2383f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23840 - U+2385f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23860 - U+2387f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23880 - U+2389f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+238a0 - U+238bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+238c0 - U+238df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+238e0 - U+238ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23900 - U+2391f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23920 - U+2393f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23940 - U+2395f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23960 - U+2397f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23980 - U+2399f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+239a0 - U+239bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+239c0 - U+239df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+239e0 - U+239ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23a00 - U+23a1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23a20 - U+23a3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23a40 - U+23a5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23a60 - U+23a7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23a80 - U+23a9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23aa0 - U+23abf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23ac0 - U+23adf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23ae0 - U+23aff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23b00 - U+23b1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23b20 - U+23b3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23b40 - U+23b5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23b60 - U+23b7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23b80 - U+23b9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23ba0 - U+23bbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23bc0 - U+23bdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23be0 - U+23bff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23c00 - U+23c1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23c20 - U+23c3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23c40 - U+23c5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23c60 - U+23c7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23c80 - U+23c9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23ca0 - U+23cbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23cc0 - U+23cdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23ce0 - U+23cff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23d00 - U+23d1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23d20 - U+23d3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23d40 - U+23d5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23d60 - U+23d7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23d80 - U+23d9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23da0 - U+23dbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23dc0 - U+23ddf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23de0 - U+23dff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23e00 - U+23e1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23e20 - U+23e3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23e40 - U+23e5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23e60 - U+23e7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23e80 - U+23e9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23ea0 - U+23ebf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23ec0 - U+23edf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23ee0 - U+23eff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23f00 - U+23f1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23f20 - U+23f3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23f40 - U+23f5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23f60 - U+23f7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23f80 - U+23f9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23fa0 - U+23fbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23fc0 - U+23fdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+23fe0 - U+23fff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24000 - U+2401f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24020 - U+2403f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24040 - U+2405f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24060 - U+2407f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24080 - U+2409f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+240a0 - U+240bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+240c0 - U+240df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+240e0 - U+240ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24100 - U+2411f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24120 - U+2413f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24140 - U+2415f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24160 - U+2417f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24180 - U+2419f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+241a0 - U+241bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+241c0 - U+241df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+241e0 - U+241ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24200 - U+2421f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24220 - U+2423f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24240 - U+2425f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24260 - U+2427f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24280 - U+2429f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+242a0 - U+242bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+242c0 - U+242df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+242e0 - U+242ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24300 - U+2431f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24320 - U+2433f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24340 - U+2435f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24360 - U+2437f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24380 - U+2439f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+243a0 - U+243bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+243c0 - U+243df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+243e0 - U+243ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24400 - U+2441f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24420 - U+2443f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24440 - U+2445f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24460 - U+2447f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24480 - U+2449f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+244a0 - U+244bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+244c0 - U+244df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+244e0 - U+244ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24500 - U+2451f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24520 - U+2453f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24540 - U+2455f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24560 - U+2457f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24580 - U+2459f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+245a0 - U+245bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+245c0 - U+245df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+245e0 - U+245ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24600 - U+2461f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24620 - U+2463f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24640 - U+2465f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24660 - U+2467f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24680 - U+2469f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+246a0 - U+246bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+246c0 - U+246df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+246e0 - U+246ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24700 - U+2471f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24720 - U+2473f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24740 - U+2475f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24760 - U+2477f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24780 - U+2479f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+247a0 - U+247bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+247c0 - U+247df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+247e0 - U+247ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24800 - U+2481f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24820 - U+2483f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24840 - U+2485f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24860 - U+2487f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24880 - U+2489f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+248a0 - U+248bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+248c0 - U+248df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+248e0 - U+248ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24900 - U+2491f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24920 - U+2493f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24940 - U+2495f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24960 - U+2497f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24980 - U+2499f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+249a0 - U+249bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+249c0 - U+249df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+249e0 - U+249ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24a00 - U+24a1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24a20 - U+24a3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24a40 - U+24a5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24a60 - U+24a7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24a80 - U+24a9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24aa0 - U+24abf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24ac0 - U+24adf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24ae0 - U+24aff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24b00 - U+24b1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24b20 - U+24b3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24b40 - U+24b5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24b60 - U+24b7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24b80 - U+24b9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24ba0 - U+24bbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24bc0 - U+24bdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24be0 - U+24bff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24c00 - U+24c1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24c20 - U+24c3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24c40 - U+24c5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24c60 - U+24c7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24c80 - U+24c9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24ca0 - U+24cbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24cc0 - U+24cdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24ce0 - U+24cff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24d00 - U+24d1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24d20 - U+24d3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24d40 - U+24d5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24d60 - U+24d7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24d80 - U+24d9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24da0 - U+24dbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24dc0 - U+24ddf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24de0 - U+24dff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24e00 - U+24e1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24e20 - U+24e3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24e40 - U+24e5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24e60 - U+24e7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24e80 - U+24e9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24ea0 - U+24ebf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24ec0 - U+24edf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24ee0 - U+24eff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24f00 - U+24f1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24f20 - U+24f3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24f40 - U+24f5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24f60 - U+24f7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24f80 - U+24f9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24fa0 - U+24fbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24fc0 - U+24fdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+24fe0 - U+24fff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25000 - U+2501f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25020 - U+2503f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25040 - U+2505f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25060 - U+2507f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25080 - U+2509f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+250a0 - U+250bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+250c0 - U+250df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+250e0 - U+250ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25100 - U+2511f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25120 - U+2513f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25140 - U+2515f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25160 - U+2517f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25180 - U+2519f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+251a0 - U+251bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+251c0 - U+251df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+251e0 - U+251ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25200 - U+2521f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25220 - U+2523f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25240 - U+2525f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25260 - U+2527f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25280 - U+2529f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+252a0 - U+252bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+252c0 - U+252df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+252e0 - U+252ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25300 - U+2531f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25320 - U+2533f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25340 - U+2535f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25360 - U+2537f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25380 - U+2539f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+253a0 - U+253bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+253c0 - U+253df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+253e0 - U+253ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25400 - U+2541f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25420 - U+2543f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25440 - U+2545f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25460 - U+2547f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25480 - U+2549f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+254a0 - U+254bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+254c0 - U+254df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+254e0 - U+254ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25500 - U+2551f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25520 - U+2553f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25540 - U+2555f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25560 - U+2557f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25580 - U+2559f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+255a0 - U+255bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+255c0 - U+255df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+255e0 - U+255ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25600 - U+2561f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25620 - U+2563f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25640 - U+2565f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25660 - U+2567f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25680 - U+2569f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+256a0 - U+256bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+256c0 - U+256df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+256e0 - U+256ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25700 - U+2571f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25720 - U+2573f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25740 - U+2575f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25760 - U+2577f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25780 - U+2579f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+257a0 - U+257bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+257c0 - U+257df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+257e0 - U+257ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25800 - U+2581f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25820 - U+2583f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25840 - U+2585f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25860 - U+2587f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25880 - U+2589f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+258a0 - U+258bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+258c0 - U+258df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+258e0 - U+258ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25900 - U+2591f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25920 - U+2593f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25940 - U+2595f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25960 - U+2597f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25980 - U+2599f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+259a0 - U+259bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+259c0 - U+259df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+259e0 - U+259ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25a00 - U+25a1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25a20 - U+25a3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25a40 - U+25a5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25a60 - U+25a7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25a80 - U+25a9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25aa0 - U+25abf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25ac0 - U+25adf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25ae0 - U+25aff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25b00 - U+25b1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25b20 - U+25b3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25b40 - U+25b5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25b60 - U+25b7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25b80 - U+25b9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25ba0 - U+25bbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25bc0 - U+25bdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25be0 - U+25bff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25c00 - U+25c1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25c20 - U+25c3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25c40 - U+25c5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25c60 - U+25c7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25c80 - U+25c9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25ca0 - U+25cbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25cc0 - U+25cdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25ce0 - U+25cff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25d00 - U+25d1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25d20 - U+25d3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25d40 - U+25d5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25d60 - U+25d7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25d80 - U+25d9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25da0 - U+25dbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25dc0 - U+25ddf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25de0 - U+25dff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25e00 - U+25e1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25e20 - U+25e3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25e40 - U+25e5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25e60 - U+25e7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25e80 - U+25e9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25ea0 - U+25ebf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25ec0 - U+25edf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25ee0 - U+25eff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25f00 - U+25f1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25f20 - U+25f3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25f40 - U+25f5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25f60 - U+25f7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25f80 - U+25f9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25fa0 - U+25fbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25fc0 - U+25fdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+25fe0 - U+25fff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26000 - U+2601f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26020 - U+2603f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26040 - U+2605f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26060 - U+2607f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26080 - U+2609f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+260a0 - U+260bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+260c0 - U+260df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+260e0 - U+260ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26100 - U+2611f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26120 - U+2613f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26140 - U+2615f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26160 - U+2617f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26180 - U+2619f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+261a0 - U+261bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+261c0 - U+261df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+261e0 - U+261ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26200 - U+2621f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26220 - U+2623f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26240 - U+2625f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26260 - U+2627f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26280 - U+2629f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+262a0 - U+262bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+262c0 - U+262df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+262e0 - U+262ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26300 - U+2631f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26320 - U+2633f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26340 - U+2635f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26360 - U+2637f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26380 - U+2639f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+263a0 - U+263bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+263c0 - U+263df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+263e0 - U+263ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26400 - U+2641f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26420 - U+2643f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26440 - U+2645f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26460 - U+2647f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26480 - U+2649f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+264a0 - U+264bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+264c0 - U+264df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+264e0 - U+264ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26500 - U+2651f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26520 - U+2653f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26540 - U+2655f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26560 - U+2657f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26580 - U+2659f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+265a0 - U+265bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+265c0 - U+265df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+265e0 - U+265ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26600 - U+2661f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26620 - U+2663f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26640 - U+2665f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26660 - U+2667f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26680 - U+2669f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+266a0 - U+266bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+266c0 - U+266df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+266e0 - U+266ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26700 - U+2671f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26720 - U+2673f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26740 - U+2675f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26760 - U+2677f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26780 - U+2679f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+267a0 - U+267bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+267c0 - U+267df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+267e0 - U+267ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26800 - U+2681f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26820 - U+2683f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26840 - U+2685f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26860 - U+2687f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26880 - U+2689f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+268a0 - U+268bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+268c0 - U+268df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+268e0 - U+268ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26900 - U+2691f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26920 - U+2693f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26940 - U+2695f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26960 - U+2697f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26980 - U+2699f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+269a0 - U+269bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+269c0 - U+269df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+269e0 - U+269ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26a00 - U+26a1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26a20 - U+26a3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26a40 - U+26a5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26a60 - U+26a7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26a80 - U+26a9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26aa0 - U+26abf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26ac0 - U+26adf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26ae0 - U+26aff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26b00 - U+26b1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26b20 - U+26b3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26b40 - U+26b5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26b60 - U+26b7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26b80 - U+26b9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26ba0 - U+26bbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26bc0 - U+26bdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26be0 - U+26bff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26c00 - U+26c1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26c20 - U+26c3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26c40 - U+26c5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26c60 - U+26c7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26c80 - U+26c9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26ca0 - U+26cbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26cc0 - U+26cdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26ce0 - U+26cff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26d00 - U+26d1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26d20 - U+26d3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26d40 - U+26d5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26d60 - U+26d7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26d80 - U+26d9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26da0 - U+26dbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26dc0 - U+26ddf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26de0 - U+26dff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26e00 - U+26e1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26e20 - U+26e3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26e40 - U+26e5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26e60 - U+26e7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26e80 - U+26e9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26ea0 - U+26ebf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26ec0 - U+26edf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26ee0 - U+26eff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26f00 - U+26f1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26f20 - U+26f3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26f40 - U+26f5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26f60 - U+26f7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26f80 - U+26f9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26fa0 - U+26fbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26fc0 - U+26fdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+26fe0 - U+26fff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27000 - U+2701f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27020 - U+2703f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27040 - U+2705f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27060 - U+2707f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27080 - U+2709f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+270a0 - U+270bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+270c0 - U+270df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+270e0 - U+270ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27100 - U+2711f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27120 - U+2713f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27140 - U+2715f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27160 - U+2717f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27180 - U+2719f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+271a0 - U+271bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+271c0 - U+271df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+271e0 - U+271ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27200 - U+2721f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27220 - U+2723f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27240 - U+2725f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27260 - U+2727f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27280 - U+2729f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+272a0 - U+272bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+272c0 - U+272df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+272e0 - U+272ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27300 - U+2731f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27320 - U+2733f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27340 - U+2735f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27360 - U+2737f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27380 - U+2739f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+273a0 - U+273bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+273c0 - U+273df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+273e0 - U+273ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27400 - U+2741f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27420 - U+2743f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27440 - U+2745f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27460 - U+2747f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27480 - U+2749f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+274a0 - U+274bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+274c0 - U+274df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+274e0 - U+274ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27500 - U+2751f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27520 - U+2753f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27540 - U+2755f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27560 - U+2757f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27580 - U+2759f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+275a0 - U+275bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+275c0 - U+275df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+275e0 - U+275ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27600 - U+2761f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27620 - U+2763f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27640 - U+2765f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27660 - U+2767f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27680 - U+2769f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+276a0 - U+276bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+276c0 - U+276df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+276e0 - U+276ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27700 - U+2771f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27720 - U+2773f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27740 - U+2775f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27760 - U+2777f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27780 - U+2779f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+277a0 - U+277bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+277c0 - U+277df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+277e0 - U+277ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27800 - U+2781f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27820 - U+2783f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27840 - U+2785f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27860 - U+2787f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27880 - U+2789f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+278a0 - U+278bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+278c0 - U+278df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+278e0 - U+278ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27900 - U+2791f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27920 - U+2793f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27940 - U+2795f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27960 - U+2797f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27980 - U+2799f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+279a0 - U+279bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+279c0 - U+279df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+279e0 - U+279ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27a00 - U+27a1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27a20 - U+27a3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27a40 - U+27a5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27a60 - U+27a7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27a80 - U+27a9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27aa0 - U+27abf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27ac0 - U+27adf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27ae0 - U+27aff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27b00 - U+27b1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27b20 - U+27b3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27b40 - U+27b5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27b60 - U+27b7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27b80 - U+27b9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27ba0 - U+27bbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27bc0 - U+27bdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27be0 - U+27bff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27c00 - U+27c1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27c20 - U+27c3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27c40 - U+27c5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27c60 - U+27c7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27c80 - U+27c9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27ca0 - U+27cbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27cc0 - U+27cdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27ce0 - U+27cff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27d00 - U+27d1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27d20 - U+27d3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27d40 - U+27d5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27d60 - U+27d7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27d80 - U+27d9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27da0 - U+27dbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27dc0 - U+27ddf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27de0 - U+27dff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27e00 - U+27e1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27e20 - U+27e3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27e40 - U+27e5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27e60 - U+27e7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27e80 - U+27e9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27ea0 - U+27ebf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27ec0 - U+27edf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27ee0 - U+27eff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27f00 - U+27f1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27f20 - U+27f3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27f40 - U+27f5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27f60 - U+27f7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27f80 - U+27f9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27fa0 - U+27fbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27fc0 - U+27fdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+27fe0 - U+27fff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28000 - U+2801f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28020 - U+2803f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28040 - U+2805f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28060 - U+2807f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28080 - U+2809f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+280a0 - U+280bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+280c0 - U+280df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+280e0 - U+280ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28100 - U+2811f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28120 - U+2813f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28140 - U+2815f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28160 - U+2817f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28180 - U+2819f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+281a0 - U+281bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+281c0 - U+281df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+281e0 - U+281ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28200 - U+2821f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28220 - U+2823f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28240 - U+2825f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28260 - U+2827f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28280 - U+2829f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+282a0 - U+282bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+282c0 - U+282df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+282e0 - U+282ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28300 - U+2831f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28320 - U+2833f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28340 - U+2835f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28360 - U+2837f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28380 - U+2839f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+283a0 - U+283bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+283c0 - U+283df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+283e0 - U+283ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28400 - U+2841f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28420 - U+2843f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28440 - U+2845f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28460 - U+2847f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28480 - U+2849f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+284a0 - U+284bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+284c0 - U+284df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+284e0 - U+284ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28500 - U+2851f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28520 - U+2853f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28540 - U+2855f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28560 - U+2857f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28580 - U+2859f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+285a0 - U+285bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+285c0 - U+285df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+285e0 - U+285ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28600 - U+2861f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28620 - U+2863f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28640 - U+2865f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28660 - U+2867f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28680 - U+2869f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+286a0 - U+286bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+286c0 - U+286df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+286e0 - U+286ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28700 - U+2871f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28720 - U+2873f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28740 - U+2875f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28760 - U+2877f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28780 - U+2879f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+287a0 - U+287bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+287c0 - U+287df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+287e0 - U+287ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28800 - U+2881f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28820 - U+2883f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28840 - U+2885f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28860 - U+2887f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28880 - U+2889f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+288a0 - U+288bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+288c0 - U+288df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+288e0 - U+288ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28900 - U+2891f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28920 - U+2893f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28940 - U+2895f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28960 - U+2897f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28980 - U+2899f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+289a0 - U+289bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+289c0 - U+289df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+289e0 - U+289ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28a00 - U+28a1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28a20 - U+28a3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28a40 - U+28a5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28a60 - U+28a7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28a80 - U+28a9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28aa0 - U+28abf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28ac0 - U+28adf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28ae0 - U+28aff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28b00 - U+28b1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28b20 - U+28b3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28b40 - U+28b5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28b60 - U+28b7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28b80 - U+28b9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28ba0 - U+28bbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28bc0 - U+28bdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28be0 - U+28bff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28c00 - U+28c1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28c20 - U+28c3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28c40 - U+28c5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28c60 - U+28c7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28c80 - U+28c9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28ca0 - U+28cbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28cc0 - U+28cdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28ce0 - U+28cff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28d00 - U+28d1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28d20 - U+28d3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28d40 - U+28d5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28d60 - U+28d7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28d80 - U+28d9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28da0 - U+28dbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28dc0 - U+28ddf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28de0 - U+28dff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28e00 - U+28e1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28e20 - U+28e3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28e40 - U+28e5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28e60 - U+28e7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28e80 - U+28e9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28ea0 - U+28ebf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28ec0 - U+28edf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28ee0 - U+28eff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28f00 - U+28f1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28f20 - U+28f3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28f40 - U+28f5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28f60 - U+28f7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28f80 - U+28f9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28fa0 - U+28fbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28fc0 - U+28fdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+28fe0 - U+28fff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29000 - U+2901f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29020 - U+2903f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29040 - U+2905f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29060 - U+2907f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29080 - U+2909f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+290a0 - U+290bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+290c0 - U+290df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+290e0 - U+290ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29100 - U+2911f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29120 - U+2913f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29140 - U+2915f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29160 - U+2917f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29180 - U+2919f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+291a0 - U+291bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+291c0 - U+291df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+291e0 - U+291ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29200 - U+2921f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29220 - U+2923f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29240 - U+2925f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29260 - U+2927f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29280 - U+2929f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+292a0 - U+292bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+292c0 - U+292df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+292e0 - U+292ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29300 - U+2931f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29320 - U+2933f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29340 - U+2935f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29360 - U+2937f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29380 - U+2939f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+293a0 - U+293bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+293c0 - U+293df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+293e0 - U+293ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29400 - U+2941f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29420 - U+2943f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29440 - U+2945f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29460 - U+2947f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29480 - U+2949f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+294a0 - U+294bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+294c0 - U+294df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+294e0 - U+294ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29500 - U+2951f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29520 - U+2953f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29540 - U+2955f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29560 - U+2957f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29580 - U+2959f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+295a0 - U+295bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+295c0 - U+295df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+295e0 - U+295ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29600 - U+2961f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29620 - U+2963f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29640 - U+2965f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29660 - U+2967f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29680 - U+2969f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+296a0 - U+296bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+296c0 - U+296df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+296e0 - U+296ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29700 - U+2971f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29720 - U+2973f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29740 - U+2975f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29760 - U+2977f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29780 - U+2979f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+297a0 - U+297bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+297c0 - U+297df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+297e0 - U+297ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29800 - U+2981f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29820 - U+2983f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29840 - U+2985f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29860 - U+2987f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29880 - U+2989f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+298a0 - U+298bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+298c0 - U+298df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+298e0 - U+298ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29900 - U+2991f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29920 - U+2993f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29940 - U+2995f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29960 - U+2997f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29980 - U+2999f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+299a0 - U+299bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+299c0 - U+299df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+299e0 - U+299ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29a00 - U+29a1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29a20 - U+29a3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29a40 - U+29a5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29a60 - U+29a7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29a80 - U+29a9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29aa0 - U+29abf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29ac0 - U+29adf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29ae0 - U+29aff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29b00 - U+29b1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29b20 - U+29b3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29b40 - U+29b5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29b60 - U+29b7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29b80 - U+29b9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29ba0 - U+29bbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29bc0 - U+29bdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29be0 - U+29bff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29c00 - U+29c1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29c20 - U+29c3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29c40 - U+29c5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29c60 - U+29c7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29c80 - U+29c9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29ca0 - U+29cbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29cc0 - U+29cdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29ce0 - U+29cff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29d00 - U+29d1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29d20 - U+29d3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29d40 - U+29d5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29d60 - U+29d7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29d80 - U+29d9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29da0 - U+29dbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29dc0 - U+29ddf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29de0 - U+29dff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29e00 - U+29e1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29e20 - U+29e3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29e40 - U+29e5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29e60 - U+29e7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29e80 - U+29e9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29ea0 - U+29ebf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29ec0 - U+29edf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29ee0 - U+29eff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29f00 - U+29f1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29f20 - U+29f3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29f40 - U+29f5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29f60 - U+29f7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29f80 - U+29f9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29fa0 - U+29fbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29fc0 - U+29fdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+29fe0 - U+29fff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a000 - U+2a01f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a020 - U+2a03f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a040 - U+2a05f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a060 - U+2a07f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a080 - U+2a09f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a0a0 - U+2a0bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a0c0 - U+2a0df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a0e0 - U+2a0ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a100 - U+2a11f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a120 - U+2a13f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a140 - U+2a15f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a160 - U+2a17f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a180 - U+2a19f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a1a0 - U+2a1bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a1c0 - U+2a1df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a1e0 - U+2a1ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a200 - U+2a21f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a220 - U+2a23f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a240 - U+2a25f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a260 - U+2a27f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a280 - U+2a29f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a2a0 - U+2a2bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a2c0 - U+2a2df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a2e0 - U+2a2ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a300 - U+2a31f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a320 - U+2a33f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a340 - U+2a35f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a360 - U+2a37f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a380 - U+2a39f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a3a0 - U+2a3bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a3c0 - U+2a3df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a3e0 - U+2a3ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a400 - U+2a41f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a420 - U+2a43f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a440 - U+2a45f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a460 - U+2a47f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a480 - U+2a49f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a4a0 - U+2a4bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a4c0 - U+2a4df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a4e0 - U+2a4ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a500 - U+2a51f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a520 - U+2a53f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a540 - U+2a55f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a560 - U+2a57f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a580 - U+2a59f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a5a0 - U+2a5bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a5c0 - U+2a5df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a5e0 - U+2a5ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a600 - U+2a61f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a620 - U+2a63f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a640 - U+2a65f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a660 - U+2a67f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a680 - U+2a69f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a6a0 - U+2a6bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a6c0 - U+2a6df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a6e0 - U+2a6ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a700 - U+2a71f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a720 - U+2a73f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a740 - U+2a75f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a760 - U+2a77f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a780 - U+2a79f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a7a0 - U+2a7bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a7c0 - U+2a7df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a7e0 - U+2a7ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a800 - U+2a81f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a820 - U+2a83f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a840 - U+2a85f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a860 - U+2a87f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a880 - U+2a89f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a8a0 - U+2a8bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a8c0 - U+2a8df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a8e0 - U+2a8ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a900 - U+2a91f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a920 - U+2a93f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a940 - U+2a95f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a960 - U+2a97f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a980 - U+2a99f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a9a0 - U+2a9bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a9c0 - U+2a9df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2a9e0 - U+2a9ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2aa00 - U+2aa1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2aa20 - U+2aa3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2aa40 - U+2aa5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2aa60 - U+2aa7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2aa80 - U+2aa9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2aaa0 - U+2aabf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2aac0 - U+2aadf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2aae0 - U+2aaff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ab00 - U+2ab1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ab20 - U+2ab3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ab40 - U+2ab5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ab60 - U+2ab7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ab80 - U+2ab9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2aba0 - U+2abbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2abc0 - U+2abdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2abe0 - U+2abff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ac00 - U+2ac1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ac20 - U+2ac3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ac40 - U+2ac5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ac60 - U+2ac7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ac80 - U+2ac9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2aca0 - U+2acbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2acc0 - U+2acdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ace0 - U+2acff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ad00 - U+2ad1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ad20 - U+2ad3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ad40 - U+2ad5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ad60 - U+2ad7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ad80 - U+2ad9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ada0 - U+2adbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2adc0 - U+2addf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ade0 - U+2adff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ae00 - U+2ae1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ae20 - U+2ae3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ae40 - U+2ae5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ae60 - U+2ae7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ae80 - U+2ae9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2aea0 - U+2aebf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2aec0 - U+2aedf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2aee0 - U+2aeff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2af00 - U+2af1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2af20 - U+2af3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2af40 - U+2af5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2af60 - U+2af7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2af80 - U+2af9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2afa0 - U+2afbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2afc0 - U+2afdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2afe0 - U+2afff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b000 - U+2b01f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b020 - U+2b03f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b040 - U+2b05f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b060 - U+2b07f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b080 - U+2b09f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b0a0 - U+2b0bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b0c0 - U+2b0df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b0e0 - U+2b0ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b100 - U+2b11f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b120 - U+2b13f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b140 - U+2b15f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b160 - U+2b17f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b180 - U+2b19f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b1a0 - U+2b1bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b1c0 - U+2b1df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b1e0 - U+2b1ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b200 - U+2b21f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b220 - U+2b23f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b240 - U+2b25f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b260 - U+2b27f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b280 - U+2b29f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b2a0 - U+2b2bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b2c0 - U+2b2df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b2e0 - U+2b2ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b300 - U+2b31f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b320 - U+2b33f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b340 - U+2b35f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b360 - U+2b37f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b380 - U+2b39f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b3a0 - U+2b3bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b3c0 - U+2b3df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b3e0 - U+2b3ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b400 - U+2b41f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b420 - U+2b43f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b440 - U+2b45f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b460 - U+2b47f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b480 - U+2b49f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b4a0 - U+2b4bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b4c0 - U+2b4df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b4e0 - U+2b4ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b500 - U+2b51f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b520 - U+2b53f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b540 - U+2b55f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b560 - U+2b57f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b580 - U+2b59f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b5a0 - U+2b5bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b5c0 - U+2b5df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b5e0 - U+2b5ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b600 - U+2b61f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b620 - U+2b63f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b640 - U+2b65f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b660 - U+2b67f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b680 - U+2b69f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b6a0 - U+2b6bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b6c0 - U+2b6df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b6e0 - U+2b6ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b700 - U+2b71f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b720 - U+2b73f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b740 - U+2b75f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b760 - U+2b77f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b780 - U+2b79f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b7a0 - U+2b7bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b7c0 - U+2b7df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b7e0 - U+2b7ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b800 - U+2b81f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b820 - U+2b83f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b840 - U+2b85f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b860 - U+2b87f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b880 - U+2b89f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b8a0 - U+2b8bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b8c0 - U+2b8df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b8e0 - U+2b8ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b900 - U+2b91f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b920 - U+2b93f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b940 - U+2b95f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b960 - U+2b97f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b980 - U+2b99f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b9a0 - U+2b9bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b9c0 - U+2b9df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2b9e0 - U+2b9ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ba00 - U+2ba1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ba20 - U+2ba3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ba40 - U+2ba5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ba60 - U+2ba7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ba80 - U+2ba9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2baa0 - U+2babf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2bac0 - U+2badf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2bae0 - U+2baff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2bb00 - U+2bb1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2bb20 - U+2bb3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2bb40 - U+2bb5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2bb60 - U+2bb7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2bb80 - U+2bb9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2bba0 - U+2bbbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2bbc0 - U+2bbdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2bbe0 - U+2bbff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2bc00 - U+2bc1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2bc20 - U+2bc3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2bc40 - U+2bc5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2bc60 - U+2bc7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2bc80 - U+2bc9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2bca0 - U+2bcbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2bcc0 - U+2bcdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2bce0 - U+2bcff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2bd00 - U+2bd1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2bd20 - U+2bd3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2bd40 - U+2bd5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2bd60 - U+2bd7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2bd80 - U+2bd9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2bda0 - U+2bdbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2bdc0 - U+2bddf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2bde0 - U+2bdff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2be00 - U+2be1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2be20 - U+2be3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2be40 - U+2be5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2be60 - U+2be7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2be80 - U+2be9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2bea0 - U+2bebf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2bec0 - U+2bedf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2bee0 - U+2beff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2bf00 - U+2bf1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2bf20 - U+2bf3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2bf40 - U+2bf5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2bf60 - U+2bf7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2bf80 - U+2bf9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2bfa0 - U+2bfbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2bfc0 - U+2bfdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2bfe0 - U+2bfff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c000 - U+2c01f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c020 - U+2c03f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c040 - U+2c05f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c060 - U+2c07f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c080 - U+2c09f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c0a0 - U+2c0bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c0c0 - U+2c0df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c0e0 - U+2c0ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c100 - U+2c11f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c120 - U+2c13f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c140 - U+2c15f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c160 - U+2c17f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c180 - U+2c19f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c1a0 - U+2c1bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c1c0 - U+2c1df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c1e0 - U+2c1ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c200 - U+2c21f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c220 - U+2c23f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c240 - U+2c25f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c260 - U+2c27f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c280 - U+2c29f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c2a0 - U+2c2bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c2c0 - U+2c2df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c2e0 - U+2c2ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c300 - U+2c31f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c320 - U+2c33f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c340 - U+2c35f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c360 - U+2c37f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c380 - U+2c39f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c3a0 - U+2c3bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c3c0 - U+2c3df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c3e0 - U+2c3ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c400 - U+2c41f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c420 - U+2c43f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c440 - U+2c45f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c460 - U+2c47f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c480 - U+2c49f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c4a0 - U+2c4bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c4c0 - U+2c4df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c4e0 - U+2c4ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c500 - U+2c51f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c520 - U+2c53f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c540 - U+2c55f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c560 - U+2c57f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c580 - U+2c59f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c5a0 - U+2c5bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c5c0 - U+2c5df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c5e0 - U+2c5ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c600 - U+2c61f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c620 - U+2c63f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c640 - U+2c65f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c660 - U+2c67f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c680 - U+2c69f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c6a0 - U+2c6bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c6c0 - U+2c6df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c6e0 - U+2c6ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c700 - U+2c71f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c720 - U+2c73f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c740 - U+2c75f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c760 - U+2c77f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c780 - U+2c79f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c7a0 - U+2c7bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c7c0 - U+2c7df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c7e0 - U+2c7ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c800 - U+2c81f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c820 - U+2c83f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c840 - U+2c85f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c860 - U+2c87f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c880 - U+2c89f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c8a0 - U+2c8bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c8c0 - U+2c8df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c8e0 - U+2c8ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c900 - U+2c91f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c920 - U+2c93f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c940 - U+2c95f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c960 - U+2c97f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c980 - U+2c99f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c9a0 - U+2c9bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c9c0 - U+2c9df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2c9e0 - U+2c9ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ca00 - U+2ca1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ca20 - U+2ca3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ca40 - U+2ca5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ca60 - U+2ca7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ca80 - U+2ca9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2caa0 - U+2cabf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2cac0 - U+2cadf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2cae0 - U+2caff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2cb00 - U+2cb1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2cb20 - U+2cb3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2cb40 - U+2cb5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2cb60 - U+2cb7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2cb80 - U+2cb9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2cba0 - U+2cbbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2cbc0 - U+2cbdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2cbe0 - U+2cbff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2cc00 - U+2cc1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2cc20 - U+2cc3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2cc40 - U+2cc5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2cc60 - U+2cc7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2cc80 - U+2cc9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2cca0 - U+2ccbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ccc0 - U+2ccdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2cce0 - U+2ccff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2cd00 - U+2cd1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2cd20 - U+2cd3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2cd40 - U+2cd5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2cd60 - U+2cd7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2cd80 - U+2cd9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2cda0 - U+2cdbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2cdc0 - U+2cddf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2cde0 - U+2cdff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ce00 - U+2ce1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ce20 - U+2ce3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ce40 - U+2ce5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ce60 - U+2ce7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ce80 - U+2ce9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2cea0 - U+2cebf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2cec0 - U+2cedf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2cee0 - U+2ceff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2cf00 - U+2cf1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2cf20 - U+2cf3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2cf40 - U+2cf5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2cf60 - U+2cf7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2cf80 - U+2cf9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2cfa0 - U+2cfbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2cfc0 - U+2cfdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2cfe0 - U+2cfff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d000 - U+2d01f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d020 - U+2d03f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d040 - U+2d05f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d060 - U+2d07f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d080 - U+2d09f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d0a0 - U+2d0bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d0c0 - U+2d0df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d0e0 - U+2d0ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d100 - U+2d11f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d120 - U+2d13f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d140 - U+2d15f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d160 - U+2d17f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d180 - U+2d19f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d1a0 - U+2d1bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d1c0 - U+2d1df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d1e0 - U+2d1ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d200 - U+2d21f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d220 - U+2d23f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d240 - U+2d25f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d260 - U+2d27f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d280 - U+2d29f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d2a0 - U+2d2bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d2c0 - U+2d2df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d2e0 - U+2d2ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d300 - U+2d31f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d320 - U+2d33f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d340 - U+2d35f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d360 - U+2d37f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d380 - U+2d39f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d3a0 - U+2d3bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d3c0 - U+2d3df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d3e0 - U+2d3ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d400 - U+2d41f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d420 - U+2d43f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d440 - U+2d45f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d460 - U+2d47f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d480 - U+2d49f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d4a0 - U+2d4bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d4c0 - U+2d4df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d4e0 - U+2d4ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d500 - U+2d51f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d520 - U+2d53f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d540 - U+2d55f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d560 - U+2d57f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d580 - U+2d59f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d5a0 - U+2d5bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d5c0 - U+2d5df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d5e0 - U+2d5ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d600 - U+2d61f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d620 - U+2d63f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d640 - U+2d65f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d660 - U+2d67f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d680 - U+2d69f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d6a0 - U+2d6bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d6c0 - U+2d6df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d6e0 - U+2d6ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d700 - U+2d71f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d720 - U+2d73f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d740 - U+2d75f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d760 - U+2d77f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d780 - U+2d79f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d7a0 - U+2d7bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d7c0 - U+2d7df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d7e0 - U+2d7ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d800 - U+2d81f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d820 - U+2d83f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d840 - U+2d85f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d860 - U+2d87f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d880 - U+2d89f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d8a0 - U+2d8bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d8c0 - U+2d8df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d8e0 - U+2d8ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d900 - U+2d91f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d920 - U+2d93f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d940 - U+2d95f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d960 - U+2d97f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d980 - U+2d99f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d9a0 - U+2d9bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d9c0 - U+2d9df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2d9e0 - U+2d9ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2da00 - U+2da1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2da20 - U+2da3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2da40 - U+2da5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2da60 - U+2da7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2da80 - U+2da9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2daa0 - U+2dabf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2dac0 - U+2dadf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2dae0 - U+2daff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2db00 - U+2db1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2db20 - U+2db3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2db40 - U+2db5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2db60 - U+2db7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2db80 - U+2db9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2dba0 - U+2dbbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2dbc0 - U+2dbdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2dbe0 - U+2dbff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2dc00 - U+2dc1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2dc20 - U+2dc3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2dc40 - U+2dc5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2dc60 - U+2dc7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2dc80 - U+2dc9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2dca0 - U+2dcbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2dcc0 - U+2dcdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2dce0 - U+2dcff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2dd00 - U+2dd1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2dd20 - U+2dd3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2dd40 - U+2dd5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2dd60 - U+2dd7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2dd80 - U+2dd9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2dda0 - U+2ddbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ddc0 - U+2dddf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2dde0 - U+2ddff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2de00 - U+2de1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2de20 - U+2de3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2de40 - U+2de5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2de60 - U+2de7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2de80 - U+2de9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2dea0 - U+2debf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2dec0 - U+2dedf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2dee0 - U+2deff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2df00 - U+2df1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2df20 - U+2df3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2df40 - U+2df5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2df60 - U+2df7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2df80 - U+2df9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2dfa0 - U+2dfbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2dfc0 - U+2dfdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2dfe0 - U+2dfff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e000 - U+2e01f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e020 - U+2e03f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e040 - U+2e05f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e060 - U+2e07f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e080 - U+2e09f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e0a0 - U+2e0bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e0c0 - U+2e0df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e0e0 - U+2e0ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e100 - U+2e11f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e120 - U+2e13f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e140 - U+2e15f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e160 - U+2e17f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e180 - U+2e19f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e1a0 - U+2e1bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e1c0 - U+2e1df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e1e0 - U+2e1ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e200 - U+2e21f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e220 - U+2e23f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e240 - U+2e25f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e260 - U+2e27f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e280 - U+2e29f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e2a0 - U+2e2bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e2c0 - U+2e2df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e2e0 - U+2e2ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e300 - U+2e31f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e320 - U+2e33f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e340 - U+2e35f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e360 - U+2e37f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e380 - U+2e39f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e3a0 - U+2e3bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e3c0 - U+2e3df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e3e0 - U+2e3ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e400 - U+2e41f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e420 - U+2e43f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e440 - U+2e45f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e460 - U+2e47f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e480 - U+2e49f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e4a0 - U+2e4bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e4c0 - U+2e4df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e4e0 - U+2e4ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e500 - U+2e51f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e520 - U+2e53f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e540 - U+2e55f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e560 - U+2e57f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e580 - U+2e59f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e5a0 - U+2e5bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e5c0 - U+2e5df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e5e0 - U+2e5ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e600 - U+2e61f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e620 - U+2e63f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e640 - U+2e65f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e660 - U+2e67f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e680 - U+2e69f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e6a0 - U+2e6bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e6c0 - U+2e6df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e6e0 - U+2e6ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e700 - U+2e71f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e720 - U+2e73f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e740 - U+2e75f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e760 - U+2e77f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e780 - U+2e79f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e7a0 - U+2e7bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e7c0 - U+2e7df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e7e0 - U+2e7ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e800 - U+2e81f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e820 - U+2e83f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e840 - U+2e85f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e860 - U+2e87f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e880 - U+2e89f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e8a0 - U+2e8bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e8c0 - U+2e8df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e8e0 - U+2e8ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e900 - U+2e91f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e920 - U+2e93f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e940 - U+2e95f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e960 - U+2e97f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e980 - U+2e99f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e9a0 - U+2e9bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e9c0 - U+2e9df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2e9e0 - U+2e9ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ea00 - U+2ea1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ea20 - U+2ea3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ea40 - U+2ea5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ea60 - U+2ea7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ea80 - U+2ea9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2eaa0 - U+2eabf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2eac0 - U+2eadf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2eae0 - U+2eaff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2eb00 - U+2eb1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2eb20 - U+2eb3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2eb40 - U+2eb5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2eb60 - U+2eb7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2eb80 - U+2eb9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2eba0 - U+2ebbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ebc0 - U+2ebdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ebe0 - U+2ebff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ec00 - U+2ec1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ec20 - U+2ec3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ec40 - U+2ec5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ec60 - U+2ec7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ec80 - U+2ec9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2eca0 - U+2ecbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ecc0 - U+2ecdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ece0 - U+2ecff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ed00 - U+2ed1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ed20 - U+2ed3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ed40 - U+2ed5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ed60 - U+2ed7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ed80 - U+2ed9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2eda0 - U+2edbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2edc0 - U+2eddf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ede0 - U+2edff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ee00 - U+2ee1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ee20 - U+2ee3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ee40 - U+2ee5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ee60 - U+2ee7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ee80 - U+2ee9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2eea0 - U+2eebf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2eec0 - U+2eedf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2eee0 - U+2eeff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ef00 - U+2ef1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ef20 - U+2ef3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ef40 - U+2ef5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ef60 - U+2ef7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ef80 - U+2ef9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2efa0 - U+2efbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2efc0 - U+2efdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2efe0 - U+2efff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f000 - U+2f01f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f020 - U+2f03f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f040 - U+2f05f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f060 - U+2f07f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f080 - U+2f09f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f0a0 - U+2f0bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f0c0 - U+2f0df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f0e0 - U+2f0ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f100 - U+2f11f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f120 - U+2f13f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f140 - U+2f15f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f160 - U+2f17f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f180 - U+2f19f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f1a0 - U+2f1bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f1c0 - U+2f1df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f1e0 - U+2f1ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f200 - U+2f21f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f220 - U+2f23f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f240 - U+2f25f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f260 - U+2f27f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f280 - U+2f29f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f2a0 - U+2f2bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f2c0 - U+2f2df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f2e0 - U+2f2ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f300 - U+2f31f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f320 - U+2f33f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f340 - U+2f35f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f360 - U+2f37f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f380 - U+2f39f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f3a0 - U+2f3bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f3c0 - U+2f3df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f3e0 - U+2f3ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f400 - U+2f41f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f420 - U+2f43f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f440 - U+2f45f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f460 - U+2f47f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f480 - U+2f49f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f4a0 - U+2f4bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f4c0 - U+2f4df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f4e0 - U+2f4ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f500 - U+2f51f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f520 - U+2f53f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f540 - U+2f55f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f560 - U+2f57f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f580 - U+2f59f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f5a0 - U+2f5bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f5c0 - U+2f5df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f5e0 - U+2f5ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f600 - U+2f61f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f620 - U+2f63f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f640 - U+2f65f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f660 - U+2f67f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f680 - U+2f69f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f6a0 - U+2f6bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f6c0 - U+2f6df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f6e0 - U+2f6ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f700 - U+2f71f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f720 - U+2f73f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f740 - U+2f75f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f760 - U+2f77f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f780 - U+2f79f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f7a0 - U+2f7bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f7c0 - U+2f7df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f7e0 - U+2f7ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f800 - U+2f81f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f820 - U+2f83f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f840 - U+2f85f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f860 - U+2f87f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f880 - U+2f89f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f8a0 - U+2f8bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f8c0 - U+2f8df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f8e0 - U+2f8ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f900 - U+2f91f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f920 - U+2f93f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f940 - U+2f95f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f960 - U+2f97f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f980 - U+2f99f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f9a0 - U+2f9bf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f9c0 - U+2f9df */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2f9e0 - U+2f9ff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2fa00 - U+2fa1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2fa20 - U+2fa3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2fa40 - U+2fa5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2fa60 - U+2fa7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2fa80 - U+2fa9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2faa0 - U+2fabf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2fac0 - U+2fadf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2fae0 - U+2faff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2fb00 - U+2fb1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2fb20 - U+2fb3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2fb40 - U+2fb5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2fb60 - U+2fb7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2fb80 - U+2fb9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2fba0 - U+2fbbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2fbc0 - U+2fbdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2fbe0 - U+2fbff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2fc00 - U+2fc1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2fc20 - U+2fc3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2fc40 - U+2fc5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2fc60 - U+2fc7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2fc80 - U+2fc9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2fca0 - U+2fcbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2fcc0 - U+2fcdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2fce0 - U+2fcff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2fd00 - U+2fd1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2fd20 - U+2fd3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2fd40 - U+2fd5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2fd60 - U+2fd7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2fd80 - U+2fd9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2fda0 - U+2fdbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2fdc0 - U+2fddf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2fde0 - U+2fdff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2fe00 - U+2fe1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2fe20 - U+2fe3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2fe40 - U+2fe5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2fe60 - U+2fe7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2fe80 - U+2fe9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2fea0 - U+2febf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2fec0 - U+2fedf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2fee0 - U+2feff */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ff00 - U+2ff1f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ff20 - U+2ff3f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ff40 - U+2ff5f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ff60 - U+2ff7f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ff80 - U+2ff9f */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ffa0 - U+2ffbf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,	/* U+2ffc0 - U+2ffdf */
  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xa5	/* U+2ffe0 - U+2ffff */
};
