/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 *  Authors: Jeffrey Stedfast <fejj@ximian.com>
 *
 *  Copyright 2003 Ximian, Inc. (www.ximian.com)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Street #330, Boston, MA 02111-1307, USA.
 *
 */


#ifndef __VG_SKIN_VIEW_H__
#define __VG_SKIN_VIEW_H__

#include <gtk/gtk.h>

#include "symtab.h"

#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */

#define VG_TYPE_SKIN_VIEW            (vg_skin_view_get_type ())
#define VG_SKIN_VIEW(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), VG_TYPE_SKIN_VIEW, VgSkinView))
#define VG_SKIN_VIEW_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), VG_TYPE_SKIN_VIEW, VgSkinViewClass))
#define VG_IS_SKIN_VIEW(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VG_TYPE_SKIN_VIEW))
#define VG_IS_SKIN_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VG_TYPE_SKIN_VIEW))
#define VG_SKIN_VIEW_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), VG_TYPE_SKIN_VIEW, VgSkinViewClass))

typedef struct _VgSkinView VgSkinView;
typedef struct _VgSkinViewClass VgSkinViewClass;

struct _VgSkinView {
	GtkVBox parent_object;
	
	const char **argv;    /* argv of program to debug */
	const char **srcdir;  /* list of src dirs to check for src files */
	
	SymTab *symtab;
	
	GtkWidget *rules;
};

struct _VgSkinViewClass {
	GtkVBoxClass parent_class;
	
	/* virtual methods */
	
	/* state methods */
	void (* clear)   (VgSkinView *view);               /* clears the display (implies a disconnect if needed) */
	void (* reset)   (VgSkinView *view);               /* resets the state */
	void (* connect) (VgSkinView *view, int sockfd);   /* connect to valgrind's --logfile-fd */
	int  (* step)    (VgSkinView *view);               /* take 1 parse step over valgrind's output stream */
	void (* disconnect) (VgSkinView *view);            /* disconnect from valgrind's --logfile-fd */
	
	int (* save_log) (VgSkinView *view, int fd);
	
	/* cut/copy/paste methods */
	void (* cut) (VgSkinView *view);
	void (* copy) (VgSkinView *view);
	void (* paste) (VgSkinView *view);
	
	/* other methods */
	void (* show_rules) (VgSkinView *view);            /* show suppression rules dialog */
};


GType vg_skin_view_get_type (void);

void vg_skin_view_set_argv (VgSkinView *view, const char **argv);
void vg_skin_view_set_srcdir (VgSkinView *view, const char **srcdir);
void vg_skin_view_set_symtab (VgSkinView *view, SymTab *symtab);

void vg_skin_view_clear (VgSkinView *view);
void vg_skin_view_reset (VgSkinView *view);
void vg_skin_view_connect (VgSkinView *view, int sockfd);
int  vg_skin_view_step (VgSkinView *view);
void vg_skin_view_disconnect (VgSkinView *view);

int vg_skin_view_save_log (VgSkinView *view, int fd);

void vg_skin_view_cut (VgSkinView *view);
void vg_skin_view_copy (VgSkinView *view);
void vg_skin_view_paste (VgSkinView *view);

void vg_skin_view_show_rules (VgSkinView *view);

char *vg_skin_view_scan_path (const char *program);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __VG_SKIN_VIEW_H__ */
