# This package provides support for metadata-described properties.
# This is base of Alicq engine now
#
# Author: Ihar Viarheichyk

package provide properties 1.0

namespace eval property {

set null [binary format c 0]
set Meta [list]	
trace variable data w ::property::HookCaller 

# Invoke hooks on property change
proc HookCaller {arr idx op} {
	if {![info exists ::property::oldval($idx)]} return
	Event $idx $idx $::property::oldval($idx) $::property::data($idx)
	set ::property::oldval($idx) $::property::data($idx)
}

if 0 {
	if {[info exists ::property::hook($::property::dmeta($idx))]} {
		Event $::property::hook($::property::dmeta($idx)) $idx $::property::oldval($idx) $::property::data($idx)
	}
}
# Register new property which fits one of metadata keys 
proc Register {key} {
	if {[set ::property::dmeta($key) [Match $key]]=={}} {
		#return -code error "No such property: $key"
		#puts "No such property: $key"
	}
	set meta $::property::dmeta($key)
	if {[info exists ::property::default($meta)]} {
		set ::property::data($key) $::property::default($meta)
	} else {set ::property::data($key) [nil]}
	set ::property::oldval($key) $::property::data($key)
}

# Get Tcl variable associated with property
proc Variable {key} {Get $key; return ::property::data($key) }

# Set property value
proc Set {key value} {
	if {![info exists ::property::data($key)]} {
		Register $key
	} else {
		if {$::property::oldval($key)==$value} {return $value}
	}
	set ::property::data($key) $value
}

proc Unset {key} {
	foreach arr [info vars ::property::*] {
		if {[string equal ::property::Meta $arr]} continue
		if {[info exists ${arr}($key)]} {unset ${arr}($key)}
	}
}

# Get property value
proc Get {key} {
	if {![info exist ::property::data($key)]} { Register $key }
	set ::property::data($key)
}

# Add new metadata description by key
proc Add {key value} {
	foreach {arr val} $value { meta $key $arr $val }
	lappend ::property::Meta $key
}

proc Match {key} {
	foreach item $::property::Meta {
		if {[string match $item $key]} {return $item}
	}
	return {}
}

# Query of change metadata information
proc meta {key arr args} {
	set arr [string trimleft $arr -]
	if {[info exists ::property::dmeta($key)]} { 
		set key $::property::dmeta($key) }
	if {![llength $args]} {
		if {[info exists "::property::${arr}($key)"]} {
			set "::property::${arr}($key)"
		} else {return -code error "Metadata key $arr is not set for property $key"}
	} else {set "::property::${arr}($key)" [lindex $args 0] }
}

proc exists {key args} {
	if {[llength $args]} {
		if {[info exists ::property::dmeta($key)]} { 
			set key $::property::dmeta($key)
		}
		info exists "::property::[string trimleft [lindex $args 0] -]($key)"
	} else {
		expr {[lsearch $::property::Meta $key]!=-1}
	}
}

proc Save0 {file key newval} {
	catch {
		set data [read [set f [open $file r]]]`
		close $f
	}
}
}

proc nil {} {
	set property::null
}

proc nil? {obj} {
	string equal $obj $property::null
}

# Register some aliases to make access to often used procedures easier
interp alias {} lsprop {} array names ::property::data
interp alias {} lsmeta {} set ::property::Meta
interp alias {} property {} property::Add
interp alias {} pget {} property::Get
interp alias {} pset {} property::Set

