'\"
'\" Generated from file '' by tcllib/doctools with format 'nroff'
'\"
.so man.macros
.TH "icq" n 0.8.6  "icq protocol handling command"
.BS
.SH "NAME"
icq \- icq protocol handling command
.SH "SYNOPSIS"
package require \fBicq  0.8.6\fR
.sp
\fBicq::icq\fR \fIUIN\fR \fIpassword\fR ?\fIoptions\fR?\fR
.sp
\fBicq::icq\fR \fBnew\fR \fIpassword\fR ?\fIoptions\fR?\fR
.sp
\fIcmd\fR \fBconfigure\fR \fIoption\fR ?\fIoptions\fR?\fR
.sp
\fIcmd\fR \fBcget\fR \fIkey\fR\fR
.sp
\fIcmd\fR \fBstatus\fR ?\fIstatus\fR?\fR
.sp
\fIcmd\fR \fBsend\fR \fItype\fR \fIrecipient\fR \fImessage\fR\fR
.sp
\fIcmd\fR \fBpassword\fR \fIpassword\fR ?\fIref\fR?\fR
.sp
\fIcmd\fR \fBinfo\fR \fIuin\fR ?\fIref\fR?\fR
.sp
\fIcmd\fR \fBpersonal\fR ?\fIinfo\fR?\fR
.sp
\fIcmd\fR \fBsearch\fR \fIfilter\fR\fR
.sp
\fIcmd\fR \fBroster\fR ?\fIaction\fR? ?\fIitem\fR? ?\fI...\fR?\fR
.sp
\fIcmd\fR \fBcontacts\fR \fIlist\fR ?\fIaction\fR? ?\fIuins\fR?\fR
.sp
\fIcmd\fR \fBencoding\fR ?\fIencoding\fR? ?\fIuins\fR?\fR
.sp
\fIcmd\fR \fBdelete\fR\fR
.sp
.BE
.SH "DESCRIPTION"
\fBicq\fR command creates icq connection command assotiated with given
\fIUIN\fR. This command returns new connection command, which is used for
work in ICQ network. Connection command has number of methods, described below.
\fIuin\fR can be either existing ICQ numerical \fIUIN\fR or word
\fBnew\fR. In latter case new ICQ uin will be registered and
returned in \fBRegistered\fR event.
.SH "OPTIONS"
.TP
\fB-server\fR
Specify ICQ server to connect to. If not specified, the default icq
server \fBlogin.icq.com\fR is used.
.TP
\fB-port\fR
Specifies port to connect to. If not specified, the default port
\fB5190\fR is used.
.TP
\fB-proxy\fR
Specifies tcl command which provides proxy connection interface.
If no command specified, icq command will connect directly to server.
See \fBproxy (n)\fR.
.TP
\fB-events\fR
Specifies script to handle ICQ events (see \fBEVENTS\fR section).
Event name and arguments are added to the end of this script or command
and \fBeval\fR is invoked on result.
.TP
\fB-keepalive\fR
Specifies interval (in seconds) for sending keepalive packets.
If it is zero, keepalive packets are not being sent.
.TP
\fB-ping\fR
Specifies interval (in seconds) for sending ping packets.
If it is zero, ping packets are not being sent. The difference between
ping and keepalive is that ping packets imply pong responces from server.
This means it consumes more bandwidth, but allows detect link death.
.TP
\fB-reconnect\fR
Boolean option which enables or disables automatical reconnect after
disconnect due to network problems.
.TP
\fB-capabilities\fR
List of additional capabilities sent to icq server (see
\fBCAPABILITIES\fR section for details).
Capabilities of wrong format are ignored. Default value is
\fBICQ RELAY UTF8\fR.
.TP
\fB-glue-timeout\fR
Specifies timeout (in milliseconds) after which incomplete long message
is pushed to event script (see \fBLONG MESSAGE SPLITTING\fR secrion
below). Default value is \fB600000\fR (10 minutes).
.TP
\fB-roster\fR
Enable operations with server-side roster. This option is either boolean
value (enable or disable operations with server-side roster), or list of
two integers: time of last update and number of items in local contact
list. If roster is only enabled, all roster items will be retirieved from
server after getting online and passed via event Roster:Items.
If list of time and count is given, roster will be retrieved from server
only if these values do not match with server roster ones, otherwise
.TP
\fB-auto-away\fR
Specify text which will be used as automatical responce when status is
"away"
.TP
\fB-auto-occ\fR
Specify text which will be used as automatical responce when status is
"occupied"
.TP
\fB-auto-dnd\fR
Specify text which will be used as automatical responce when status is
"do not disturb".
.TP
\fB-auto-na\fR
Specify text which will be used as automatical responce when status is
"not available".
.TP
\fB-auto-ffc\fR
Specify text which will be used as automatical responce when status is
"free for chat".
.SH "CONNECTION METHODS"
.TP
\fIcmd\fR \fBconfigure\fR \fIoption\fR ?\fIoptions\fR?\fR
Change one or more icq options (see \fBOPTIONS\fR).
.TP
\fIcmd\fR \fBcget\fR \fIkey\fR\fR
Get value of one of icq options (see \fBOPTIONS\fR).
.TP
\fIcmd\fR \fBstatus\fR ?\fIstatus\fR?\fR
Set new status or retreive current status, if \fIstatus\fR parameter is
omitted. \fIstatus\fR can be one of: \fBoffline\fR, \fBonline\fR,
\fBaway\fR, \fBna\fR, \fBdnd\fR, \fBocc\fR, \fBffc\fR,
\fBinvisible\fR (see \fBICQ STATUS\fR section). The default
status (if no status was previously set) is \fBoffline\fR.
This commands always returns current status, which can differ from new
status, because it requries certain time to icq server set and confirm
new status.
.TP
\fIcmd\fR \fBsend\fR \fItype\fR \fIrecipient\fR \fImessage\fR\fR ?\fImessage-id\fR?
Send message of given type to recipient. \fImessage\fR and \fIrecipient\fR
parameters depend on message type (see \fBMESSAGE TYPES\fR section).
Optional argument \fImessage-id\fR is used to explicitly specify message
identifier. It's format is two hexadecimal numbers delimited with colon.
It's only purpose is to provide ability to re-send message with same
identifier for proper acknowledgements.
.TP
\fIcmd\fR \fBpassword\fR \fIpassword\fR ?\fIref\fR?\fR
Change own login password to \fIpassword\fR. Additional parameter
\fIref\fR can be used for identification of acknowledge event OK:Password.
\fIref\fR can be any integer number in the range \fB0-255\fR.
This subcommand returns event reference.
.TP
\fIcmd\fR \fBinfo\fR \fIuin\fR ?\fIref\fR?\fR
Query contact information in ICQ whitepages by ICQ UIN.
Additional parameter \fIref\fR can be used for acknowledgement
identification (see \fBpassword\fR method). Returns event reference.
.TP
\fIcmd\fR \fBpersonal\fR ?\fIinfo\fR?\fR
Query or change personal information in ICQ whitepages. Returns event
reference.
.TP
\fIcmd\fR \fBsearch\fR \fIfilter\fR\fR
Search for ICQ contacts in ICQ whitepages by provided filter. Filter is
a list of key-value pairs, where key identifies field name and
value - value of the field in whitepages.
.TP
\fIcmd\fR \fBroster\fR ?\fIaction\fR? ?\fIitem\fR? ?\fI...\fR?\fR
Add, delete or modify items in server-side roster. \fIaction\fR should be
one of \fBadd\fR, \fBdelete\fR or \fBupdate\fR. Each item is a list
and consists of following elements: type, id, name, additional information.
Type should be \fBcontact\fR or \fBgroup\fR. Id is numerical identifier
in the range \fB0-32767\fR. Name is ICQ UIN for \fBcontact\fR or group
name for \fBgroup\fR. Additional information is a key-value list of
additional properties.
.TP
\fIcmd\fR \fBcontacts\fR \fIlist\fR ?\fIaction\fR? ?\fIuins\fR?\fR
Get or change one of ICQ contact lists. List is specified with \fIlist\fR
parameter and can be one of: \fBall visible invisible\fR. If
\fIuins\fR is omitted current content of specified list returned,
otherwise contents of the list modified according to \fIaction\fR
parameter with \fIuins\fR list values. \fIaction\fR is one of
\fBadd, delete\fR. Default action is \fBadd\fR.
.TP
\fIcmd\fR \fBencoding\fR ?\fIencoding\fR? ?\fIuins\fR?\fR
Query or set encoding for non-unicode messages. If \fIuins\fR parameter is
omitted, the default encoding queried or set. Default encoding is used if
no encoding specified for contact. If \fIuins\fR parameter is specified,
it should be UIN or list of UINs, and given encoding associates with these
UINs only. This method returns current assotiated encoding.
.TP
\fIcmd\fR \fBdelete\fR\fR
Close connection and delete command \fIcmd\fR.
.SH "EVENTS"
Events is the main way of getting information from ICQ server. To process
events callback script should be defined in \fBicq\fR command or
\fBconfigure\fR method. When one of events occurs, callback script invoked
using \fBeval\fR command, with event name and event parameters (if any) added
to script.
.TP
\fBLog\fR \fItags\fR \fIstring\fR
.TP
\fBError\fR \fIcode\fR ?\fIdescription\fR?
.TP
\fBError:Protocol\fR \fIhandler\fR \fIreason\fR \fIpacket\fR
.TP
\fBStatus\fR \fIuin\fR \fIstatus\fR ?\fIip\fR?
Reports new ICQ status of contact \fIuin\fR when it is changed.
Note, that icq package does not keep statuses of contacts in contacts
list, thus you should handle this event if you want know status of
contact in any time.
.TP
\fBMyStatus\fR \fIuin\fR
.TP
\fBBirthday\fR \fIuin\fR
.TP
\fBShowIp\fR \fIuin\fR
.TP
\fBLanDetails\fR \fIuin\fR \fIaddr\fR \fIport\fR \fItype\fR
.TP
\fBSignupDate\fR \fIuin\fR \fIdate\fR
.TP
\fBSignonDate\fR \fIuin\fR \fIdate\fR
.TP
\fBClient\fR \fIuin\fR \fIversion\fR \fIclient\fR \fIunicode-flag\fR
Additional information about client program of contact. \fIversion\fR is
version of ICQ protocol, usually it is one of \fB7\fR, \fB8\fR,
\fB9\fR. \fIclient\fR is the name of ICQ client contact uses.
It is determined by indirect properties and not always correct.
\fIunicode-flag\fR is boolean value which is set to true if client
supports unicode text and false otherwise.
.TP
\fBRoster\fR \fIroster\fR \fItime\fR
.TP
\fBRoster:OK\fR \fItimestamp\fR \fIsize\fR
.TP
\fBACK\fR \fItype\fR \fIuin\fR \fIid\fR
Acknowledgement on message sent. Type can be one of
\fBclient\fR, \fBserver\fR or \fBsent\fR.
\fBclient\fR acknowledgement is sent when client
receives your message, \fBserver\fR - when ICQ server receives
your message while recipient is offline. \fBsent\fR acknowledgement
is sent when outgoing message is actually sent.
.TP
\fBInfo\fR \fIref\fR \fIinfo\fR
.TP
\fBSearchResults\fR \fIref\fR \fIinfo\fR
.TP
\fBPasswordChanged\fR \fIref\fR
.TP
\fBIncoming\fR \fItype\fR \fIsender\fR \fItime\fR \fImessage\fR
Incoming message \fImessage\fR of type \fItype\fR (see
\fBMESSAGE TYPES\fR) from \fIsender\fR sent at \fItime\fR.
Time is given in seconds since the Epoch (00:00:00 UTC, January 1, 1970).
.TP
\fBOutgoing\fR \fItype\fR \fIrecipient\fR \fItime\fR \fImessage\fR \fImsgid\fR
Outgoing message \fImessage\fR of type \fItype\fR (see
\fBMESSAGE TYPES\fR) to \fIrecipient\fR sent at \fItime\fR.
Time is given in seconds since the Epoch (00:00:00 UTC, January 1, 1970).
\fImsgid\fR is message identifier used in acknowledgements to
identify the message.
.TP
\fBCapabilities\fR \fIuin\fR \fIcapabilities\fR
List of capabilities (see \fBCAPABILITIES\fR) of ICQ client used
by contact \fIuin\fR.
.TP
\fBRegistered\fR \fIuin\fR
.TP
\fBRegistrationRefused\fR
.SH "ICQ STATUS"
The following statuses are supported in ICQ network:
.TP
\fBoffline\fR
No connection to ICQ server, not registered in ICQ network.
.TP
\fBonline\fR
Connected to ICQ server and successfully logged in ICQ network. This is
primary status.
.TP
\fBaway\fR
Indicates that contact is online, but away from computer for short
period of time.
.TP
\fBna\fR
Not awailable. Indicates that contact is online, but away from computer
for a long period of time.
.TP
\fBdnd\fR
Do not disturb. Indicates that contact is online but does not want to
receive messages from anyone now.
.TP
\fBocc\fR
Occupied. Indicates that contact is occupied and will answer only on
important messages.
.TP
\fBffc\fR
Free for chat. Indicates that contact is not occupied and can chat with
anyone who wants it.
.TP
\fBinvisible\fR
Indicates that contact is in invisible mode.
.PP
\fINote\fR, that \fBoffline\fR status differs from other ones - when
status is \fBoffline\fR no network connection required. This means that
switching from \fBoffline\fR to another status implies connecting to
ICQ server, and switching to \fBoffline\fR implies closing connection to
ICQ server.
.SH "MESSAGE TYPES"
ICQ protocol allows different kinds of intormation be sent or received.
icq library supports following types of messages in \fBsend\fR method and
\fBIncoming\fR and \fBOutgoing\fR events. In most message types
sender or recepient is ICQ UIN, unless other specified in type description.
.TP
\fBtext\fR
Most common type of message. It represents just text strings which
ICQ clients send to each other when chatting. Additionaly text can
contain information about background and foreground colors.
.TP
\fBweb\fR
Represents message sent from web client on icq.com. The difference with
\fBtext\fR type is that sender is not ICQ contact, but list of
three elements: \fIname\fR, \fIe-mail\fR and \fIIP address\fR
of sender. This type can appear only in \fBIncoming\fR events
.TP
\fBURL\fR
URL message is a list of two elements: URL and URL description.
.TP
\fBSMS\fR
SMS type can be used to send message to contact's cell phone. This
type is can only be sent and never appears in \fBIncoming\fR event.
.TP
\fBcontacts\fR
Contatacts message is used to send a list of contacts to recepient.
Message of this type is a list with even number of elements representing
url-alias pairs of form {uin alias uin alias ...}.
.TP
\fBauthorization\fR
Accept or reqject authorization request from contact. Authorization
message can be one of the words \fBgrant\fR or \fBdeny\fR to grant
or deny authorization respectively.
.TP
\fBauthrequest\fR
Autorization request. This message is sent to ICQ contact when you
desire to be included in recipient's contact list. When sending this
message via \fBsend\fR method, message conent is just a text string
representing short message for recepient. However, in \fBIncoming\fR
event message it is a list, having following elements: \fInick\fR,
\fIfirst name\fR, \fIlast name\fR, \fIemail\fR,
\fIauxilliary info\fR, \fIautorization request message\fR.
.TP
\fBincluded\fR
Message of this type appears only in \fBIncoming\fR event and
indicates that you was included in sender's contact list. Content
of the message is empty string.
.TP
\fBauto\fR
Same as \fBtext\fR, but it is sent automatically by program as a
responce to common message or to \fBaway\fR, \fBocc\fR, \fBdnd\fR,
\fBna\fR, \fBffc\fR messages. Message of this type is never sent
explicitly.
.TP
\fBaway\fR
Request "away" autoresponce. Contact sends message of type \fBauto\fR as
a responce.
.TP
\fBocc\fR
Request "occupied" autoresponce. Contact sends message of type
\fBauto\fR as a responce.
.TP
\fBdnd\fR
Request "do not disturb" autoresponce. Contact sends message of type
\fBauto\fR as a responce.
.TP
\fBna\fR
Request "not available" autoresponce. Contact sends message of type
\fBauto\fR as a responce.
.TP
\fBffc\fR
Request "free for chat" autoresponce. Contact sends message of type
\fBauto\fR as a responce.
.SH "CAPABILITIES"
Capabilities can be used for icq client identification or other
client-specific purposes. Each capability is a string of 32 hexadecimal
didits, representing 16 byte sequence or one of pre-defined aliases.
If specified capabililty is longer than 32 characters it is truncated, and
filled with zeroes to 32 characters if shorter.
There is a set of pre-defined capabilities aliases. They are:
.TP
\fBICQ\fR
Client is ICQ client, not AIM client.
.TP
\fBRELAY\fR
Client understands type-2 messages with acknowledgements.
.TP
\fBUTF8\fR
Client understands unicode messages in UTF-8 encoding.
.TP
\fBRTF\fR
Client understands messages in Rich Text Format.
.TP
\fBSTR_2001\fR
This capability is sent by ICQ2001.
.TP
\fBSTR_2002\fR
This capability is sent by ICQ2002.
.TP
\fBIS_2001\fR
This capability is sent by ICQ2001.
.TP
\fBLICQ\fR
This capability is sent by Licq.
.TP
\fBWEB\fR
This capability is sent by ICQ Lite and icq2go (java applet).
.TP
\fBTRILL_UNK\fR
Unknonw capability sent by Trillian.
.TP
\fBTRILL_CRYPT\fR
This capability is sent by Trillian and indicates support of encripted
messages.
.TP
\fBAIM_SENDFILE\fR
AIM client send it if supports sending files.
.TP
\fBAIM_GETFILE\fR
AIM client send it if supports receiving files.
.TP
\fBAIM_CHAT\fR
AIM client send it if supports chat.
.TP
\fBAIM_VOICE\fR
AIM specific capability.
.TP
\fBAIM_ICON\fR
AIM specific capability.
.TP
\fBAIM_IMAGE\fR
AIM specific capability.
.TP
\fBAIM_STOCKS\fR
AIM specific capability.
.TP
\fBAIM_GAMES\fR
AIM specific capability.
.TP
\fBAIM_BUD\fR
AIM specific capability.
.TP
\fBAIM_INTEROPERATE\fR
This capability allows ICQ clients send messages to AIM contacts and AIM
clients to ICQ contacts.
.TP
\fBSim\fR
Indicates that client is Sim.
.TP
\fBmICQ\fR
Indicates that client is mICQ.
.SH "LONG MESSAGES SPLITTING"
\fBicq\fR package can automatically split long text messages when
sending them through the server. If recipient of such messages is
\fBicq\fR-based clilent too, it can combine message from chunks
transparently. Special \fIglue\fR sequence (\fB<...>\fR) is used to mark
first, last and inner chunks. First chunk only ends with glue sequence,
last chunks only beginning with glue sequence, inner chunks begin and end
with glue sequences. Such approach allows determine end of long message,
detect previous incomplete long messages, and compatible with other
ICQ clients which do not support message splitting. Moreover,
it allows custom creation of pseudo-long messages, i.e. send messages with
glue which will be interpreted as one long message by recipient.
The possible problem with combining long messages is that receiver does not
know when last chunk arrive, thus incomplete message can be stored in chunk
cache forever, if last chunk is lost. To prevent such situation, incomplete
message ``pushed'' to event script if no messages from same UIN received
during timeout. Default timeout is 10 minutes, and can be specified when
creating icq command or via \fBconfigure\fR method.
.SH "EXAMPLES"
\fIGeneric template for ICQ events handling\fR
.PP
.nf
proc Event {event args} {
	if {[llength [info commands ICQ::$event]]} {
		eval ICQ::$event $args
	} else {
		puts "No handler for ICQ event $event"
	}
}
set icq [icq::icq 47298730 xxx -port 1024\\
	-reconnect yes -events Event]
$icq status online
vwait fin
.fi
.PP
\fISimple ICQ robot to report Unix machine status\fR
.PP
.nf
proc Event {event args} {
	if {[llength [info commands ICQ::$event]]} {
		eval ICQ::$event $args
	}
}
namespace eval ICQ {
	global icqcmd
	proc Incoming {type sender time msg} {
		if {$type!="text"} return
		set f [open "|uptime", r]
		$icqcmd send text $sender [read $f]
		close $f
	}
}

set icqcmd [icq::icq 47298730 xxx -port 1024\\
	-reconnect yes -events Event]
$icqcmd status online
vwait fin
.fi
.SH "AUTHOR"
\fBicq\fR package and this man page was written by
Ihar Viarheichyk <iverg@mail.ru>
.SH "SEE ALSO"
\fBalicq\fR(1), \fBalicqrc\fR(5), \fBproxy\fR(n)
.SH "KEYWORDS"
icq, messenger, protocol
