
option add *AlicqConfig.info*foreground DarkBlue widgetDefault
option add *AlicqConfig.info.title.font {Courier 14 bold} widgetDefault
option add *AlicqConfig.module*Label.justify right widgetDefault
option add *AlicqConfig.module*Label.anchor e
option add *AlicqConfig.module*Menubutton.relief sunken widgetDefault
option add *AlicqConfig.module*Menubutton.background gray90 widgetDefault
option add *AlicqConfig.module*anchor w widgetDefault
option add *AlicqConfig.geometry "600x450" widgetDefault
option add *Separator.height 2 widgetDefault
option add *Separator.relief sunken widgetDefault

proc Grep {lst} {
	grep x $lst {
		[array exists $x] && 
		(![info exists ${x}(type)] || 
		  [lsearch [set ${x}(type)] cache]==-1 &&
		  [lsearch [set ${x}(type)] action]==-1)
	}
}

proc Description {meta} {
	if {[info exists ${meta}(description)]} {
		set text [set ${meta}(description)]
	} else { set text [string totitle [namespace tail $meta]] }
}

proc ModuleName {ns {stopper ::modules}} {
	set parent [namespace parent $ns]
	if {[info exists ${ns}::meta::name]} {
		set name [set ${ns}::meta::name]
	} else {  set name [string totitle [namespace tail $ns]] }
	if {$parent!=$stopper} { return "[ModuleName $parent] $name" }
	set name
}	

proc ConfigDialog {args} {
	variable changed
	set top .config
	if {![winfo exists $top]} {
		toplevel $top -class AlicqConfig
		bindtags $top [concat [bindtags $top] SaveGeometry]
		raise $top
	} else {
		raise $top
		return
	}
	variable node_counter 
	set node_counter 0
	namespace eval tmpobj {}
	set sw [ScrolledWindow $top.sw -relief flat -borderwidth 0]
	set tree [Tree $top.sw.tr -showlines 0 -selectcommand [nc Page $top]]
	$sw setwidget $tree
	foreach x {Text Image} { $tree bind$x <Control-Button-1> "" }
	grid $top.sw -row 0 -column 0 -rowspan 6 -column 0  -sticky news -padx 2
	grid [frame $top.info] -row 0 -column 1 -sticky new
	grid [frame $top.sep1 -class Separator]\
		-row 1 -column 1 -sticky we -padx 8
	grid [frame $top.module] -row 2 -column 1 -sticky news -padx 8 -pady 16
	grid [frame $top.sep2 -class Separator]\
		-row 4 -column 1 -sticky we -padx 8
	grid [frame $top.btn -class ButtonBar]\
		-row 5 -column 1 -sticky se -pady 8

	button $top.btn.apply -text [mc Apply] -command [nc Apply $top]
	button $top.btn.close -command [list destroy $top]
	grid $top.btn.apply $top.btn.close -padx 8
	bind $top.btn.close <Destroy> [nc Close %W]
	bind $top <<Close>> [list $top.btn.close invoke]

	# New object frame
	frame $top.object
	grid [label $top.object.title] -row 0 -column 1\
		-columnspan 2 -sticky we -padx 4
	entry $top.object.name -validate key\
		-vcmd [nc ValidateName $tree $top.object.add %P]
	button $top.object.add -text [mc Add]\
		-command [nc AddObj $tree $top.object.name]
	grid $top.object.name -row 1 -column 1 -sticky we -padx 4
	grid $top.object.add -row 1 -column 2 -sticky e -padx 4
	grid columnconfigure $top.object 1 -weight 1
	bind $top.object.name <<Accept>> [list $top.object.add invoke]

	grid rowconfigure $top 1 -weight 1
	grid rowconfigure $top.module 999 -weight 1
	grid columnconfigure $top 1 -weight 1
	grid columnconfigure $top.info 1 -weight 1
	foreach x {1 2 3} { grid rowconfigure $top $x -weight 1}
	
	grid columnconfigure $top.module 1 -weight 1
	# Create basic info widgets
	grid [label $top.info.title] -sticky we -column 1
	grid [label $top.info.description] -sticky we -column 1
	ModuleTree $tree ::modules root
	variable last
	if {[info exists last] && [$tree exists $last]} {
		$tree selection set $last
	} else { $tree selection set 1 }
	
	trace variable changed w [nc ConfigureApply $top.btn.apply]
	set changed [list]
}

# Populate navigation tree with items
proc ModuleTree {tree ns {node root}} {
	set meta [info vars ${ns}::meta::*]
	set mod [Grep $meta]
	if {[info exists ${ns}::meta::configuration-objects]} {
		set obj [set ${ns}::meta::configuration-objects]
	} else { set obj "" }
	if {[llength $mod] || $obj!=""} {
		set node [TreeItem $tree $node $ns $mod $obj]
	}
	foreach x [namespace children $ns] { ModuleTree $tree $x $node }
}

# Draw tree item
proc TreeItem {tree parent ns mod obj} {
	variable node_counter
	if {$parent=="root"} { set parns ::modules } else {
		set parns [lindex [$tree itemcget $parent -data] 0]
	}	
	set text [ModuleName $ns $parns]
	set node [$tree insert end $parent [incr node_counter] -text $text\
		-data [list $ns $mod $obj] -drawcross never -open 1]
	if {[info exists ${ns}::meta::icon]} {
		$tree itemconfigure $node -image [set ${ns}::meta::icon]
	}
	if {$obj!=""} { 
		ObjectItem $tree $node $obj
		$tree itemconfigure $node -drawcross allways -open 0
	}
	set node
}

# Draw object item (unilke module item)
proc ObjectItem {tree parent class} {
	variable node_counter
	foreach x [select $class] {
		$tree insert end $parent [incr node_counter] -data [list $x]\
			-text [lindex [split $x :] end]
	}
}

# Display configuration page according to item selected
proc Page {top tree node} {
	variable last
	set last $node
	set data [$tree itemcget $node -data]
	if {[llength $data]!=3} {
		foreach x {module object} { Page:$x $top.$x "" }
		ObjectInfo $top.info [lindex $data 0]
		Page:editobject $top.module [lindex $data 0] $tree
	} else {
		foreach {ns module object} $data break
		ModuleInfo $top.info $ns
		foreach x {module object} { Page:$x $top.$x [set $x] }
	}
	set text [$top.info.title cget -text]
	wm title $top "$text - Alicq configuration"
}

# Module configuration page
proc Page:module {name meta} {
	foreach x [grid slaves $name] { destroy $x }
	UnifiedConfig $name $meta widget x {
		set var [meta2var $x]
		[seekType $x temporary] $var $var.temporary $x
		[seekType $x assign] $widget $var.temporary
		trace variable $var.temporary w [nc ModvarChanged $var]
	}
}

# Ppage for modules which have assotiated objects
proc Page:object {name objs} {
	if {[winfo ismapped $name]} {
		if {$objs==""} { grid forget $name; return }
	} elseif {$objs!=""} {
		grid $name -row 2 -column 1 -sticky ews -padx 10
	} else return
	$name.name delete 0 end
	$name.title configure -text "You can create new $objs here."
}

# Page to edit properties of selected object itself
proc Page:editobject {name obj tree} {
	set tmp [namespace current]::tmpobj::$obj
	if {![info exists $tmp] && [info exists [ref $obj]]} { 
		#array set $tmp [array get [ref $obj]] 
		trace variable $tmp w [nc ObjvarChanged]
	}
	set ref [ref $obj]
	UnifiedConfig $name [metainfo object $obj] w x {
		set field [namespace tail $x]
		[seekType $x temporary] ${ref}($field) ${tmp}($field) $x
		[seekType $x assign] $w ${tmp}($field)
	}
	button $name.delete -text [mc Delete] -command [nc DelObj $tree]
	grid $name.delete -column 1 -padx 4 -pady 4
}

# Unified configuration for module and object metainformation
proc UnifiedConfig {name meta widget var script} {
	set num 0
	upvar 1 $var x
	upvar 1 $widget w
	foreach x [lsort -command comparator $meta] {
		set text [Description $x]
		set w $name.w$num
		grid [label $name.lb$num -text [mc [Description $x]]]\
		     [[seekType $x type] $w $x] -sticky new -padx 4 -pady 2
		uplevel 1 $script
		incr num
	}
}

# Add new object - create array and put item into the navigation tree
proc AddObj {tree entry} {
	variable node_counter
	set name [$entry get]
	set node [$tree selection get]
	set class [lindex [$tree itemcget $node -data] end]
	$tree itemconfigure $node -open 1
	set node [$tree insert end $node [incr node_counter]\
		-text $name -data [list ${class}:${name}]]
	$tree selection set $node
	variable changed
	lappend changed [list add ${class}:$name {}]
}

# Delete object - change 'changed' variable and remove item from the tree
proc DelObj {tree} {
	variable changed
	set node [$tree selection get]
	set parent [$tree parent $node]
	set idx [$tree index $node]
	set obj [lindex [$tree itemcget $node -data] 0]
	$tree delete $node
	set next [$tree nodes $parent $idx]
	if {$next==""} { set next [$tree nodes $parent end] }
	if {$next==""} { set next $parent }
	$tree selection set $next

	# For newly created objects, delete corrsponding record 
	# from 'changed' list
	set pos [lsearch $changed [list add $obj {}]]
	if {$pos!=-1} { set changed [lreplace $changed $pos $pos] }
	
	# For existing objects, remove all changes and put 'delete' record
	if {[array exists [ref $obj]]} {
		while {[set pos [lsearch $changed [list update $obj *]]]!=-1} {
			set changed [lreplace $changed $pos $pos]
		}
		lappend changed [list delete $obj {}]
	}
	unset [namespace current]::tmpobj::$obj
}

# Validate name of object to create
proc ValidateName {tree button val} {
	set node [$tree selection get]
	set nodes [map x [$tree nodes $node] { $tree itemcget $x -text }]
	set state normal
	set v [string trimright $val]
	if {$v=="" || [lsearch -exact $nodes $v]!=-1} { set state disabled }
	$button configure -state $state
	expr { [string first " " $val]==-1 }
}

# Temporary object variable changed
proc ObjvarChanged {name field op} {
	set obj [namespace tail $name]
	set changes [changes? [ref $obj]($field)\
		[metainfo object $obj $field] [set ${name}($field)]]
	UpdateChanged $changes [list update $obj $field]
}

# Temporary module configuration variable changed
proc ModvarChanged {var args} {
	set changes [changes? $var [var2meta $var] [set $var.temporary]]
	UpdateChanged $changes [list $var]
}

# Update list of changes
proc UpdateChanged {changes value} {
	variable changed
	if {![info exists changed]} return
	set pos [lsearch $changed $value]
	if {$changes && $pos==-1} {
		lappend changed $value 
	} elseif {!$changes && $pos!=-1} {
		set changed [lreplace $changed $pos $pos]
	}
}

# Apply changes
proc Apply {top args} {
	variable changed
	foreach x $changed { 
		if {[llength $x]==1} {
			set x [lindex $x 0]
			set $x [string trimleft [set $x.temporary] "\0"]
		} elseif {[llength $x]==3} { eval ModifyObject $x }
	}
	set changed [list]
}

proc ModifyObject {action obj field} {
	set local [namespace current]::tmpobj::$obj
	switch -exact $action {
		add { 
			new $obj [array get $local]
			trace variable $local w [nc ObjvarChanged]
		}
		delete { unset [ref $obj] }
		update { set [ref $obj]($field) [set ${local}($field)] }
	}
}

proc Close {top} {
	variable changed
	# Destroy existsing temporary variables
	foreach x $changed {
		if {[llength $x]==1} { unset [lindex $x 0].temporary }
	}
	namespace delete tmpobj
	unset changed
}

proc ConfigureApply {apply args} {
	variable changed
	$apply configure -state [expr [llength $changed]?"normal":"disabled"]
}

proc ModuleInfo {info ns} {
	set text [list]
	foreach x {description author} y [list "" "[mc Author]: "] {
		if {[info exists ${ns}::meta::$x]} {
			lappend text [set y][mc [set ${ns}::meta::$x]]
		}
	}	
	$info.description configure -text [join $text "\n"]
	$info.title configure -text [ModuleName $ns]
}

proc ObjectInfo {info obj} {
	set name [string map {: " "} $obj]
	$info.title configure -text $name
	$info.description configure -text "[mc {Edit properties of}] $name"
}

proc comparator {var1 var2} {
	cmp [ifval ${var1}(weight) .5] [ifval ${var2}(weight) 0.5]
}

proc ifval {var def} { expr {[info exists $var]?[set $var]:[set def]} }
proc cmp {n1 n2} { expr { ($n1<$n2)?-1:(($n1>$n2)?1:0) } }

proc seekType {name prefix} {
	upvar #0 $name meta
	if {[info exists meta(type)]} { set types $meta(type) }
	lappend types {}
	foreach x $types {
		if {[info commands $prefix:$x]!=""} { return $prefix:$x }
	}
}

proc type: {name meta} { entry $name -vcmd [nc Valid $meta %P] -validate key }

proc assign: {name var} {
	$name configure -textvariable {}
	$name delete 0 end
	$name configure -textvariable $var
}

proc type:password {name meta} { entry $name -show * }

proc type:boolean {name meta} { checkbutton $name }
proc assign:boolean {name var} { $name configure -variable $var }

proc type:text {name meta} { ui::text $name -wrap word -width 50 -height 6 }

proc assign:text {name var} { $name configure -variable $var }

proc type:variant {name meta} {
	if {[info exists ${meta}(values)]} {
	 	set values [set ${meta}(values)]
	} elseif {[info exists ${meta}(valuescript)]} {
		set values [eval [set ${meta}(valuescript)]]
	}
	if {[info exists ${meta}(empty)]} {
		set values [concat [list [list "\0"\
			[set ${meta}(empty)]]] $values]
	}
	ui::variant $name -values $values
}

proc assign:variant {name var} { $name configure -variable $var }

proc type:hidden {args} { return -code continue }
set n [namespace current]
foreach x {action cache} { interp alias {} ${n}::type:$x {} ${n}::type:hidden }

proc temporary: {var temp args} {
	if {[info exists $var]} { set $temp [set $var] }
	set temp
}

proc temporary:variant {var temp meta} {
	if {[info exists $var]} { 
		set val [set $var]
	} else { 
		if {[info exists ${meta}(default)]} {
			set val [set ${meta}(default)]
		} else {set val "" }
	}	
	if {$val==""} { set val "\0"}
	set $temp $val
	set temp
}

proc Valid {meta val} { expr { ($val=="")?1:[valid $meta $val] } }

namespace eval meta {
	array set config {type action weight .70 menu Settings
		script ConfigDialog}
}

