package require Tk
package require BWidget

set lSex {Unset Female Male}
set lOnline {{All users} {Only online users}}
set lLanguages {Unset Arabic Bhojpuri Bulgarian Burmese Cantonese Catalan 
		Chinese Croatian Czech Danish Dutch English Esperanto
		Estonian Farsi Finnish French Gaelic German Greek Hebrew
		Hindi Hungarian Icelandic Indonesian Italian Japanese Khmer
		Korean Lao Latvian Lithuanian Malay Norwegian Polish
		Portuguese Romanian Russian Serbian Slovak Slovenian Somali
		Spanish Swahili Swedish Tagalog Tatar Thai Turkish Ukrainian
		Urdu Vietnamese Yiddish Yoruba Afrikaans Bosnian Persian
		Albanian Armenian Punjabi Chamorro Mongolian Mandarin
		Taiwaness Macedonian Sindhi Welsh Azerbaijani Kurdish Gujarati
		Tamil Belarusian Unknown
		}
set aCountries { 
	0 Unset 1 USA 7 Russia 20 Egypt 27 {South Africa} 30 Greece 31 Netherlands
	32 Belgium 33 France 34 Spain 36 Hungary 38 Yugoslavia
	39 Italy 40 Romania 41 Switzerland 42 {Czech Republic} 43 Austria
	44 UK 45 Denmark 46 Sweden 47 Norway 48 Poland 49 Germany 51 Peru 
	52 Mexico 53 Cuba 54 Argentina 55 Brazil 56 Chile 57 Columbia 58 Venezuela
	60 Malaysia 61 Australia 62 Indonesia 63 Philippines 64 {New Zealand}
	65 Singapore 66 Thailand 81 Japan 82 {South Korea} 84 Vietnam 86 China
	90 Turkey 91 India 92 Pakistan 93 Afghanistan 94 {Sri Lanka} 95 Myanmar
	98 Iran 101 Anguilla 102 Antigua 103 Bahamas 104 Barbados 105 Bermuda 
	106 {British Virgin Islands} 107 Canada 108 {Cayman Islands} 109 Dominica
	110 {Dominican Republic} 111 Grenada 112 Jamaica 113 Montserrat 114 Nevis 
	115 {St. Kitts} 116 {St. Vincent and the Grenadines} 
	117 {Trinidad and Tobago} 118 {Turks and Caicos Islands} 120 Barbuda
	121 {Puerto Rico} 122 {Saint Lucia} 123 {US Virgin Islands}
	212 Morocco 213 Algeria 216 Tunisia 218 Libya 221 Senegal 223 Mali 
	224 Guinea 225 {Ivory Coast} 226 {Burkina Faso} 227 Niger 228 Togo
	229 Benin 230 Mauritius 231 Liberia 232 {Sierra Leone} 233 Ghana
	234 Nigeria 235 Chad 236 {Central African Republic} 237 Cameroon
	238 {Cape Verde Islands} 239 {Sao Tome and Principe} 240 {Equatorial Guinea}
	241 Gabon 242 Congo 243 Zaire 244 Angola 245 Guinea-Bissau
	246 {Diego Garcia} 247 {Ascension Island} 248 {Seychelle Islands} 249 Sudan
	250 Rwanda 251 Ethiopia 252 Somalia 253 Djibouti 254 Kenya 255 Tanzania
	256 Uganda 257 Burundi 258 Mozambique 260 Zambia 261 Madagascar
	262 {Reunion Island} 263 Zimbabwe 264 Namibia 265 Malawi 266 Lesotho
	267 Botswana 268 Swaziland 269 {Mayotte Island} 290 {St. Helena}
	291 Eritrea 297 Aruba 297 {Faeroe Islands} 299 Greenland 350 Gibraltar
	351 Portugal 352 Luxembourg 353 Ireland 354 Iceland 356 Malta 357 Cyprus
	358 Finland 359 Bulgaria 370 Lithuania 371 Latvia 372 Estonia 373 Moldova
	374 Armenia 375 Belarus 376 Andorra 377 Monaco 371 {San Marino}
	379 {Vatican City} 380 Ukraine 381 Yugoslavia 385 Croatia 386 Slovenia
	387 {Bosnia and Herzegovina} 389 Macedonia 500 {Falkland Islands}
	501 Belize 502 Guatemala 503 {El Salvador} 504 Honduras 505 Nicaragua
	506 {Costa Rice} 507 Panama 508 {St. Pierre and Miquelon} 509 Haiti
	590 Guadeloupe 591 Bolivia 592 Guyana 593 Ecuador 594 {French Guiana}
	595 Paraguay 596 {French Antilles} 597 Suriname 598 Uruguay 
	599 {Netherlands Antilles} 670 Saipan 671 Guam 672 {Christmas Island}
	673 Brunei 674 Nauru 675 {Papua New Guinea} 676 Tonga 677 {Solomon Islands}
	678 Vanuatu 679 Fiji 680 Palau 681 {Wallis and Futuna Islands}
	682 {Cook Islands} 683 Niue 684 {American Samoa} 685 {Western Samoa}
	686 Kiribati 687 {New Caledonia} 688 Tuvalu 689 {French Polynesia}
	690 Tokelau 691 Micronesia 692 {Marshall Islands} 705 Kazakhstan
	706 {Kyrgyz Republic} 708 Tajikistan 709 Turkmenistan 711 Uzbekistan
	850 {North Korea} 852 {Hong Kong} 853 Macau 855 Cambodia 856 Laos
	868 {Trinidad and Tobago} 880 Bangladesh 886 Taiwan 960 Maldives
	961 Lebanon 962 Jordan 963 Syria 964 Iraq 965 Kuwait 966 {Saudia Arabia}
	967 Yemen 968 Oman 971 {United Arab Emirates} 972 Israel 973 Bahrain
	974 Qatar 975 Bhutan 976 Mongolia 977 Nepal 994 Azerbaijan 995 Georgia
	4101 Liechtenstein 4201 {Slovak Republic} 65535 {Not entered}
} 
set aTimeZones {0 {0 (Greenwich)} 
		1  {-0030} 2  {-0100} 3  {-0130} 4  {-0200} 
		5  {-0230} 6  {-0300} 7  {-0330} 8  {-0400}
		9  {-0430} 10 {-0500} 11 {-0530} 12 {-0600} 
		13 {-0630} 14 {-0700} 15 {-0730} 16 {-0800} 
		17 {-0900} 18 {-0930} 19 {-1000} 20 {-1030}
		21 {-1100} 22 {-1130}
		-1  {+0030} -2  {+0100} -3  {+0130} -4  {+0200}
		-5  {+0230} -6  {+0300} -7  {+0330} -8  {+0400}
		-9  {+0430} -10 {+0500} -11 {+0530} -12 {+0600}
		-13 {+0630} -14 {+0700} -15 {+0730} -16 {+0800} 
		-17 {+0900} -18 {+0930} -19 {+1000} -20 {+1030} 
		-21 {+1100} -22 {+1130}
}

set WPlayout {
 Main { { Nick=Alias UIN }
	{ Status IP}
	{ FirstName=Name LastName= }
	{ {email=e-Mail 1} {email1=e-Mail 2}}
	{ {email2=e-Mail 3} {email3=e-Mail 4}}
	{ Homepage }
      }
Where { { Country City}
  	{ State Zip}
  	{ Street=Address }
  	{ Phone Fax}
  	{ {Mobile=Cell phone} {TimeZone=Time Zone}}
      }
 More { { Sex Age }
 	{ =Birthday =Languages }
	{ Day {Lang1=Language 1}}
	{ Month {Lang2=Language 2}}
	{ Year {Lang3=Language 3}}
      }
}
set ro {UIN Status IP}
set SearchLayout {
	{ Nick Email=E-Mail }
	{ FirstName=Name LastName=}
	{ Sex Language }
	{ Country City }
	{ {MinAge=Minumal age} {MaxAge=Maximal age} }
	{ {OnlineOnly=Online Only} }
}

array set WPmeta {
	TimeZone {keyvariant	aTimeZones}
	dSex	 {listvariant	lSex}
	Country  {keyvariant	aCountries}
	Lang1	 {listvariant	lLanguages}
	Lang2	 {listvariant	lLanguages}
	Lang3	 {listvariant	lLanguages}
	Language {listvariant	lLanguages}
	OnlineOnly {listvariant	lOnline}
} 

interp alias {} eq {} string equal

proc MetaDialog {top layout {ro 1}} {
	pack [set nb [NoteBook $top.nb]]
	foreach {page items} $layout {
		MetaPage [$nb insert end $page -text $page] $items $ro
	}
	$nb raise [$nb pages 0]
}
	
proc MetaPage {fr items {lro 0}} {
	variable ro
	set rnum 0
	if {[package vsatisfies [package present Tcl] 8.4]} {
		set modifier readonly
	} else {set modifier disabled}
	foreach row $items {
		set colnum 0
		set adder [expr {([llength $row]==1)?2:0}]
		foreach col $row {
			if {[string first = $col]==-1} {
				set id $col
				set label $col
			} else {
				foreach {id label} [split $col =] break
			}
			if {$label!={}} {
				set span [expr {[eq $id {}]?2:1}]
				grid [label $fr.l$label -text $label]\
					-row $rnum -column $colnum\
					-sticky we -columnspan $span
				incr colnum $span
			}
			if {$id!={}} {
				set span [expr {([eq $label {}]?2:1)+$adder}]
				grid [set w [SelfWidget $fr.e$id $id]]\
					-row $rnum -column $colnum\
					-sticky we -columnspan $span
				if {[lsearch $ro $id]!=-1 || $lro } { 
					if {[winfo class $w]=="Entry"} {
						$w configure -state $modifier 
					} else {
						$w configure -state disabled 
					}	
				}
				incr colnum $span
			}
		}
		incr rnum
	}
	bind $fr <Destroy> [nc clear $fr]
}

proc clear {fr} {
	set var [namespace current]::[lindex [split $fr .] 1]
	if {[array exists $var]} { array unset $var }
}

proc SelfWidget {name id} {
	variable WPmeta
	set ns [namespace current]
	set textvar ${ns}::[lindex [split $name .] 1]($id)
	if {[info exists WPmeta($id)]} {
	  foreach {type var} $WPmeta($id) break
	  variable $var
	  switch -- $type {
	    listvariant { set values  [set ${var}] }
	    keyvariant  { set values [list]
	    		  foreach {x y} [set $var] {lappend values $y}
	    		}
	  }
	  if {[llength $values]>30} {
		set values [map x $values {set _ [string index $x 0]:$x}]
	  }
	  set w [::ui::frame::variant $name $textvar [lsort $values]]
	} else {
	  set w [entry $name -textvariable $textvar]
	}
}

handler {Contact:ICQ:*|info:view info:update} View {{id Me}} {
	variable WPlayout
	set uid [lindex [split $id |] 0]
	if {[eq $uid Me]} {
		variable uin
		if {![info exists uin]} {
			Event Error ICQ "ICQ UIN is not set"
			return
		}
		set uid Contact:ICQ:$uin
		set buttons [list [list Update [nc UpdateInfo]]]
		set ro 0
	} else { set buttons [list]; set ro 1 }
	set UIN [lindex [split $uid :] 2]
	set top .info-[string map {: -} $uid]
	if {[catch {raise $top}]} {
		toplevel $top -class AlicqInfoWindow
		lappend buttons [list Close "destroy $top"]
		pack [frame $top.content] -fill both -expand yes
		pack [ButtonBar $top.btn $buttons] -side bottom
		MetaDialog $top.content $WPlayout $ro
	}
	set ref [expr [clock seconds] & 0xFF]
	set id [hook Info [nc FillInfo $UIN $ref]]
	bind $top <Destroy> "if {{%W}=={$top}} {unhook $id} "
	Event Info $ref [list UIN $UIN Status [get $uid Status offline] IP [get $uid IP Unknown]]
	Event InfoRequest $uid $ref
}

proc FillInfo {uin myref ref info} {
	if {$ref!=$myref} return
	foreach {key val} $info {
		SetVal [namespace current]::info-Contact-ICQ-$uin $key $val 
	}
}

proc UpdateInfo {} {
	variable uin
	if {![info exists uin]} { 
		Event Error "ICQ" "ICQ UIN is not set"
		return
	}
	set var [namespace current]::info-Contact-ICQ-$uin
	set info [list]
	foreach {key val} [array get $var ] { lappend info $key [MapVal $key $val] }
	Event UpdateInfo $info
}

proc MapVal {id val} {
	variable WPmeta
	if {[info exists WPmeta($id)]} {
	  foreach {type var} $WPmeta($id) break
	  variable $var
	  switch -- $type {
	  	listvariant { set val [lsearch [set $var] $val]
			      if {$val==-1} {set val 0}	
			    }
	  	keyvariant { foreach {key txt} [set $var] {
				if {$txt==$val} {set val $key; break}
			     }
			   }
	  }
	}
	set val
}

proc SetVal {arr id val} {
	variable WPmeta
	set textvar ${arr}($id)
	if {[info exists WPmeta($id)]} {
	  foreach {type var} $WPmeta($id) break
	  variable $var
	  switch -- $type {
	  	listvariant { set $textvar [lindex [set $var] $val]}
	  	keyvariant  { foreach {key txt} [set $var] {
			          if {$key==$val} { set $textvar $txt; break}
			      }
			    } 
	  }
	} else { set $textvar $val}
}

handler search Search {args} {
	variable SearchLayout
	set top .search
	if {[catch {raise $top}]} {
		toplevel $top -class AlicqSearchWindow
		set cmd [nc SearchRun $top]
		set buttons [list\
			[list Search $cmd]\
			[list {More Info} [namespace code {Event Contact:ICQ:[GetFound]|info:view Contact:ICQ:[GetFound]|info:view}] {} disabled]\
			[list {Add} [namespace code {::AddObject contact [GetFound]}] {} disabled]\
			[list {Close} "destroy $top"]]
		pack [frame $top.content] -fill x -expand yes
		pack [frame $top.results] -fill both -expand yes
		pack [label $top.results.status -relief groove] -fill x
		pack [listbox $top.results.list -selectmode single]\
			-expand yes -fill both
		pack [ButtonBar $top.btn $buttons] -side bottom
		MetaPage $top.content $SearchLayout
		
		set id [hook SearchResults [namespace current]::SearchResults]
		bind $top <Destroy> "if {{%W}=={$top}} { unhook $id }"
	}
}

proc SearchRun {top} {
	variable search
	$top.results.list delete 0 end
	$top configure -cursor watch
	"$top.btn.bMore Info" configure -state disabled
	$top.btn.bAdd configure -state disabled
	$top.results.status configure -text "Searching..."
	set info [list]
	foreach {key val} [array get search ] { lappend info $key [MapVal $key $val] }
	puts "search for: $info"
	Event search $info
	#icq::Search $info
}

proc SearchResults {Ref Info} {
	if {$Info=={}} { 
		.search configure -cursor {}
		.search.results.status configure -text "Search complete"
		return 
	}
	array set user $Info
	".search.btn.bMore Info" configure -state normal
	.search.btn.bAdd configure -state normal
	.search.results.list insert end "$user(UIN): $user(Nick) \($user(FirstName) $user(LastName): $user(email)\)"
	.search.results.list selection set 0
	unset user
}

proc GetFound {} {
	lindex [split [.search.results.list get [lindex [.search.results.list curselection] 0]] :] 0
}

proc MapToLocal {ext local args} {
	upvar #0 $ext [namespace current]::$local
	trace vdelete $ext w [nc MapToLocal $ext $local]
}
handler ConfigLoaded onConfig {args} {
	if {[lsearch [namespace children ::modules] *::icq]==-1} return
	set ext [pref "icq uin"]
	if {[info exists $ext]} {
		upvar #0 $ext [namespace current]::uin
	} else {
		trace variable $ext w [nc MapToLocal $ext uin]
	}
}


namespace eval meta {
	set name "ICQ White Pages"
	set description "Search contacts view information on contacts and update personal information in ICQ White Pages "
	set author "Ihar iarheichyk <iverg@mail.ru>"
	array set search {type action weight .1 script Search menu "ICQ Search"}
	array set info:update {type action weight .2 menu {ICQ "Update personal info"}}
}

namespace eval [ref Contact:ICQ]::meta {
	array set info:view [list type action menu Info\
		script [uplevel 1 namespace current]::View]
}

