# This module is used to view Alicq log messages in Alicq.
# it is part of Alicq instant messenger client
# 
# Author: Ihar Viarheichyk

proc ViewLog {args} {
	set top .log
	if [catch {toplevel $top}] return
	set cmd "destroy $top"
	pack [ScrolledTxt $top.log] -expand yes -fill both
	pack [ButtonBar $top.btn [list [list [mc Close] $cmd <Escape>]]]
	$top.log.txt configure -state disabled
	if {[info exists ::LOGNAME]} {
		if {[catch { 
			set fd [open $::LOGNAME] 
			Update $top [read $fd] ""
			close $fd
			set id [hook ViewLog [nc Update $top]]
			bind $top.log.txt <Destroy> [list unhook $id]
		   } v]} { Event Error warning "Can not open $::LOGNAME: $v" }
	}
}
proc Update {top str {end "\n"}} {
	$top.log.txt configure -state normal
	$top.log.txt insert end $str {} $end {}
	$top.log.txt see end
	$top.log.txt configure -state disabled
}

namespace eval meta {
	array set ViewLog {type action script ViewLog
		menu {"View Log"} weight .9}
}

